# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.message_status_user import MessageStatusUser
from typing import Optional, Set
from typing_extensions import Self

class MessageStatus(BaseModel):
    """
    Holds the status of a particular message, indicating which user the message has been sent, delivered or read. 
    """ # noqa: E501
    author: Optional[MessageStatusUser] = None
    read: Optional[List[MessageStatusUser]] = Field(default=None, description="All users who have read that message, in any Symphony client.")
    delivered: Optional[List[MessageStatusUser]] = Field(default=None, description="All users who have at least one Symphony client to which the message has been delivered, and not read yet. ")
    sent: Optional[List[MessageStatusUser]] = Field(default=None, description="All users to whom the message has been sent and received by the Symphony system, but not yet delivered to any user's Symphony client. ")
    __properties: ClassVar[List[str]] = ["author", "read", "delivered", "sent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessageStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in read (list)
        _items = []
        if self.read:
            for _item_read in self.read:
                if _item_read:
                    _items.append(_item_read.to_dict())
            _dict['read'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in delivered (list)
        _items = []
        if self.delivered:
            for _item_delivered in self.delivered:
                if _item_delivered:
                    _items.append(_item_delivered.to_dict())
            _dict['delivered'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sent (list)
        _items = []
        if self.sent:
            for _item_sent in self.sent:
                if _item_sent:
                    _items.append(_item_sent.to_dict())
            _dict['sent'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessageStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": MessageStatusUser.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "read": [MessageStatusUser.from_dict(_item) for _item in obj["read"]] if obj.get("read") is not None else None,
            "delivered": [MessageStatusUser.from_dict(_item) for _item in obj["delivered"]] if obj.get("delivered") is not None else None,
            "sent": [MessageStatusUser.from_dict(_item) for _item in obj["sent"]] if obj.get("sent") is not None else None
        })
        return _obj


