# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from symphony.bdk.gen.pod_model.product import Product
from typing import Optional, Set
from typing_extensions import Self

class UserAppEntitlementPatch(BaseModel):
    """
    Application Entitlements to patch for the user
    """ # noqa: E501
    app_id: Annotated[str, Field(min_length=1, strict=True, max_length=256)] = Field(description="Unique ID for the Application", alias="appId")
    listed: Optional[StrictStr] = Field(default='KEEP', description="If \"TRUE\", this application will be listed in the appstore for this user. If \"FALSE\", this application will be hidden in the appstore. If \"KEEP\" or not set, the current value is kept. If \"REMOVE\", it will be removed from user settings and the pod level setting's value will be used.")
    install: Optional[StrictStr] = Field(default='KEEP', description="If \"TRUE\", this application will be installed for this user. If \"FALSE\", this application will not be installed for this user. If \"KEEP\" or not set, the current value is kept. If \"REMOVE\", it will be removed from user settings and the pod level setting's value will be used.")
    product: Optional[Product] = None
    __properties: ClassVar[List[str]] = ["appId", "listed", "install", "product"]

    @field_validator('listed')
    def listed_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TRUE', 'FALSE', 'KEEP', 'REMOVE']):
            raise ValueError("must be one of enum values ('TRUE', 'FALSE', 'KEEP', 'REMOVE')")
        return value

    @field_validator('install')
    def install_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TRUE', 'FALSE', 'KEEP', 'REMOVE']):
            raise ValueError("must be one of enum values ('TRUE', 'FALSE', 'KEEP', 'REMOVE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserAppEntitlementPatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of product
        if self.product:
            _dict['product'] = self.product.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserAppEntitlementPatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appId": obj.get("appId"),
            "listed": obj.get("listed") if obj.get("listed") is not None else 'KEEP',
            "install": obj.get("install") if obj.get("install") is not None else 'KEEP',
            "product": Product.from_dict(obj["product"]) if obj.get("product") is not None else None
        })
        return _obj


