# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserSystemInfo(BaseModel):
    """
    User Status Information.
    """ # noqa: E501
    id: Optional[StrictInt] = None
    status: Optional[StrictStr] = None
    suspended: Optional[StrictBool] = Field(default=None, description="An optional attribute indicating whether the user is temporarily suspended or not. Since SBE 20.14.")
    suspended_until: Optional[StrictInt] = Field(default=None, description="An optional unix timestamp until which the suspension is effective. Since SBE 20.14.", alias="suspendedUntil")
    suspension_reason: Optional[StrictStr] = Field(default=None, description="An optional description of the suspension reason. Since SBE 20.14.", alias="suspensionReason")
    created_date: Optional[StrictInt] = Field(default=None, alias="createdDate")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    last_updated_date: Optional[StrictInt] = Field(default=None, alias="lastUpdatedDate")
    last_login_date: Optional[StrictInt] = Field(default=None, alias="lastLoginDate")
    last_password_reset: Optional[StrictInt] = Field(default=None, alias="lastPasswordReset")
    deactivated_date: Optional[StrictInt] = Field(default=None, alias="deactivatedDate")
    __properties: ClassVar[List[str]] = ["id", "status", "suspended", "suspendedUntil", "suspensionReason", "createdDate", "createdBy", "lastUpdatedDate", "lastLoginDate", "lastPasswordReset", "deactivatedDate"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ENABLED', 'DISABLED']):
            raise ValueError("must be one of enum values ('ENABLED', 'DISABLED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserSystemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserSystemInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "suspended": obj.get("suspended"),
            "suspendedUntil": obj.get("suspendedUntil"),
            "suspensionReason": obj.get("suspensionReason"),
            "createdDate": obj.get("createdDate"),
            "createdBy": obj.get("createdBy"),
            "lastUpdatedDate": obj.get("lastUpdatedDate"),
            "lastLoginDate": obj.get("lastLoginDate"),
            "lastPasswordReset": obj.get("lastPasswordReset"),
            "deactivatedDate": obj.get("deactivatedDate")
        })
        return _obj


