# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.avatar import Avatar
from typing import Optional, Set
from typing_extensions import Self

class UserV2(BaseModel):
    """
    User record version 2
    """ # noqa: E501
    id: Optional[StrictInt] = None
    email_address: Optional[StrictStr] = Field(default=None, alias="emailAddress")
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    title: Optional[StrictStr] = None
    company: Optional[StrictStr] = None
    username: Optional[StrictStr] = None
    location: Optional[StrictStr] = None
    account_type: Optional[StrictStr] = Field(default=None, alias="accountType")
    avatars: Optional[List[Avatar]] = None
    work_phone_number: Optional[StrictStr] = Field(default=None, description="Note: only available if the application has the extended user or contact permission", alias="workPhoneNumber")
    mobile_phone_number: Optional[StrictStr] = Field(default=None, description="Note: only available if the application has the extended user or contact permission", alias="mobilePhoneNumber")
    job_function: Optional[StrictStr] = Field(default=None, description="Note: only available if the application has the extended user or contact permission", alias="jobFunction")
    department: Optional[StrictStr] = Field(default=None, description="Note: only available if the application has the extended user or contact permission")
    division: Optional[StrictStr] = Field(default=None, description="Note: only available if the application has the extended user or contact permission")
    roles: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["id", "emailAddress", "firstName", "lastName", "displayName", "title", "company", "username", "location", "accountType", "avatars", "workPhoneNumber", "mobilePhoneNumber", "jobFunction", "department", "division", "roles"]

    @field_validator('account_type')
    def account_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NORMAL', 'SYSTEM', 'SDL']):
            raise ValueError("must be one of enum values ('NORMAL', 'SYSTEM', 'SDL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in avatars (list)
        _items = []
        if self.avatars:
            for _item_avatars in self.avatars:
                if _item_avatars:
                    _items.append(_item_avatars.to_dict())
            _dict['avatars'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "emailAddress": obj.get("emailAddress"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "displayName": obj.get("displayName"),
            "title": obj.get("title"),
            "company": obj.get("company"),
            "username": obj.get("username"),
            "location": obj.get("location"),
            "accountType": obj.get("accountType"),
            "avatars": [Avatar.from_dict(_item) for _item in obj["avatars"]] if obj.get("avatars") is not None else None,
            "workPhoneNumber": obj.get("workPhoneNumber"),
            "mobilePhoneNumber": obj.get("mobilePhoneNumber"),
            "jobFunction": obj.get("jobFunction"),
            "department": obj.get("department"),
            "division": obj.get("division"),
            "roles": obj.get("roles")
        })
        return _obj


