# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class V1Session(BaseModel):
    """
    V1 Detailed Session record.
    """ # noqa: E501
    session_id: Optional[StrictStr] = Field(default=None, description="The id of the user session", alias="sessionId")
    client_ip: Optional[StrictStr] = Field(default=None, description="The ip address of the session initiator", alias="clientIp")
    user_id: Optional[StrictInt] = Field(default=None, description="The user id of the session initiator", alias="userId")
    user_agent: Optional[StrictStr] = Field(default=None, description="The user agent of the session", alias="userAgent")
    browser: Optional[StrictStr] = Field(default=None, description="The browser section of the user agent")
    os: Optional[StrictStr] = Field(default=None, description="The os section of the user agent")
    device: Optional[StrictStr] = Field(default=None, description="The device section of the user agent")
    device_hash: Optional[StrictStr] = Field(default=None, description="A hash uniquely identifying the device of the requester", alias="deviceHash")
    creation_time: Optional[StrictInt] = Field(default=None, description="The timestamp of the creation time the user session", alias="creationTime")
    expiration_delay: Optional[StrictInt] = Field(default=None, description="The timestamp of the expiry time of the user session", alias="expirationDelay")
    __properties: ClassVar[List[str]] = ["sessionId", "clientIp", "userId", "userAgent", "browser", "os", "device", "deviceHash", "creationTime", "expirationDelay"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1Session from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1Session from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sessionId": obj.get("sessionId"),
            "clientIp": obj.get("clientIp"),
            "userId": obj.get("userId"),
            "userAgent": obj.get("userAgent"),
            "browser": obj.get("browser"),
            "os": obj.get("os"),
            "device": obj.get("device"),
            "deviceHash": obj.get("deviceHash"),
            "creationTime": obj.get("creationTime"),
            "expirationDelay": obj.get("expirationDelay")
        })
        return _obj


