# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class V2AdminStreamAttributes(BaseModel):
    """
    additional optional properties for the stream
    """ # noqa: E501
    room_name: Optional[StrictStr] = Field(default=None, description="room name (room only)", alias="roomName")
    room_description: Optional[StrictStr] = Field(default=None, description="description of the room (room only)", alias="roomDescription")
    members: Optional[List[StrictInt]] = Field(default=None, description="list of userid who is member of the stream - im or mim only")
    created_by_user_id: Optional[StrictInt] = Field(default=None, description="creator user id", alias="createdByUserId")
    created_date: Optional[StrictInt] = Field(default=None, description="created date", alias="createdDate")
    last_modified_date: Optional[StrictInt] = Field(default=None, description="last modified date", alias="lastModifiedDate")
    origin_company: Optional[StrictStr] = Field(default=None, description="company name of the creator", alias="originCompany")
    origin_company_id: Optional[StrictInt] = Field(default=None, description="company id of the creator", alias="originCompanyId")
    members_count: Optional[StrictInt] = Field(default=None, description="total number of members in the stream", alias="membersCount")
    last_message_date: Optional[StrictInt] = Field(default=None, description="last date a message was sent in this stream", alias="lastMessageDate")
    group_chat: Optional[StrictBool] = Field(default=None, description="whether a stream is a group chat or not. Since SBE 20.16.", alias="groupChat")
    __properties: ClassVar[List[str]] = ["roomName", "roomDescription", "members", "createdByUserId", "createdDate", "lastModifiedDate", "originCompany", "originCompanyId", "membersCount", "lastMessageDate", "groupChat"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AdminStreamAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AdminStreamAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "roomName": obj.get("roomName"),
            "roomDescription": obj.get("roomDescription"),
            "members": obj.get("members"),
            "createdByUserId": obj.get("createdByUserId"),
            "createdDate": obj.get("createdDate"),
            "lastModifiedDate": obj.get("lastModifiedDate"),
            "originCompany": obj.get("originCompany"),
            "originCompanyId": obj.get("originCompanyId"),
            "membersCount": obj.get("membersCount"),
            "lastMessageDate": obj.get("lastMessageDate"),
            "groupChat": obj.get("groupChat")
        })
        return _obj


