# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.v2_admin_stream_type import V2AdminStreamType
from typing import Optional, Set
from typing_extensions import Self

class V2AdminStreamFilter(BaseModel):
    """
    stream filter criteria
    """ # noqa: E501
    stream_types: Optional[List[V2AdminStreamType]] = Field(default=None, description="type of streams to search for", alias="streamTypes")
    scope: Optional[StrictStr] = Field(default=None, description="Scope of the room. Valid values are INTERNAL or EXTERNAL. If not specified, it will include both Internal and External scope ")
    origin: Optional[StrictStr] = Field(default=None, description="Origin of the room. It indicates whether the room was created by a user within the company by another company. Valid values are INTERNAL or EXTERNAL. If not specified, it will include both Internal and External origin ")
    status: Optional[StrictStr] = Field(default=None, description="Status of the room. Valid values are ACTIVE or INACTIVE. If not specified, it will include both Active and Inactive status ")
    privacy: Optional[StrictStr] = Field(default=None, description="Privacy setting of the stream. Valid values are PUBLIC or PRIVATE. If not specified, it will include both public and private streams ")
    start_date: Optional[StrictInt] = Field(default=None, description="Start date in unix timestamp in millseconds", alias="startDate")
    end_date: Optional[StrictInt] = Field(default=None, description="End date in unix timestamp in millseconds.  If not specified, it assume to be current time.", alias="endDate")
    __properties: ClassVar[List[str]] = ["streamTypes", "scope", "origin", "status", "privacy", "startDate", "endDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AdminStreamFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in stream_types (list)
        _items = []
        if self.stream_types:
            for _item_stream_types in self.stream_types:
                if _item_stream_types:
                    _items.append(_item_stream_types.to_dict())
            _dict['streamTypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AdminStreamFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "streamTypes": [V2AdminStreamType.from_dict(_item) for _item in obj["streamTypes"]] if obj.get("streamTypes") is not None else None,
            "scope": obj.get("scope"),
            "origin": obj.get("origin"),
            "status": obj.get("status"),
            "privacy": obj.get("privacy"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate")
        })
        return _obj


