# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.v2_admin_stream_filter import V2AdminStreamFilter
from symphony.bdk.gen.pod_model.v2_admin_stream_info import V2AdminStreamInfo
from typing import Optional, Set
from typing_extensions import Self

class V2AdminStreamList(BaseModel):
    """
    list of streams info
    """ # noqa: E501
    count: Optional[StrictInt] = Field(default=None, description="total number of streams which match the filter criteria")
    skip: Optional[StrictInt] = Field(default=None, description="number of streams skipped")
    limit: Optional[StrictInt] = Field(default=None, description="maximum number of streams return")
    filter: Optional[V2AdminStreamFilter] = None
    streams: Optional[List[V2AdminStreamInfo]] = Field(default=None, description="list of stream info")
    __properties: ClassVar[List[str]] = ["count", "skip", "limit", "filter", "streams"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2AdminStreamList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in streams (list)
        _items = []
        if self.streams:
            for _item_streams in self.streams:
                if _item_streams:
                    _items.append(_item_streams.to_dict())
            _dict['streams'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2AdminStreamList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "count": obj.get("count"),
            "skip": obj.get("skip"),
            "limit": obj.get("limit"),
            "filter": V2AdminStreamFilter.from_dict(obj["filter"]) if obj.get("filter") is not None else None,
            "streams": [V2AdminStreamInfo.from_dict(_item) for _item in obj["streams"]] if obj.get("streams") is not None else None
        })
        return _obj


