# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.v2_conversation_specific_stream_attributes import V2ConversationSpecificStreamAttributes
from symphony.bdk.gen.pod_model.v2_room_specific_stream_attributes import V2RoomSpecificStreamAttributes
from symphony.bdk.gen.pod_model.v2_stream_type import V2StreamType
from typing import Optional, Set
from typing_extensions import Self

class V2StreamAttributes(BaseModel):
    """
    V2StreamAttributes
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The stream ID.")
    cross_pod: Optional[StrictBool] = Field(default=None, description="If true, this is a cross-pod stream.", alias="crossPod")
    origin: Optional[StrictStr] = Field(default=None, description="INTERNAL if the creator of this stream belongs to the pod, EXTERNAL otherwise")
    active: Optional[StrictBool] = Field(default=None, description="If true, this stream is active.")
    last_message_date: Optional[StrictInt] = Field(default=None, description="unix timestamp of the last message sent in the stream", alias="lastMessageDate")
    stream_type: Optional[V2StreamType] = Field(default=None, alias="streamType")
    stream_attributes: Optional[V2ConversationSpecificStreamAttributes] = Field(default=None, alias="streamAttributes")
    room_attributes: Optional[V2RoomSpecificStreamAttributes] = Field(default=None, alias="roomAttributes")
    __properties: ClassVar[List[str]] = ["id", "crossPod", "origin", "active", "lastMessageDate", "streamType", "streamAttributes", "roomAttributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2StreamAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of stream_type
        if self.stream_type:
            _dict['streamType'] = self.stream_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stream_attributes
        if self.stream_attributes:
            _dict['streamAttributes'] = self.stream_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of room_attributes
        if self.room_attributes:
            _dict['roomAttributes'] = self.room_attributes.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2StreamAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "crossPod": obj.get("crossPod"),
            "origin": obj.get("origin"),
            "active": obj.get("active"),
            "lastMessageDate": obj.get("lastMessageDate"),
            "streamType": V2StreamType.from_dict(obj["streamType"]) if obj.get("streamType") is not None else None,
            "streamAttributes": V2ConversationSpecificStreamAttributes.from_dict(obj["streamAttributes"]) if obj.get("streamAttributes") is not None else None,
            "roomAttributes": V2RoomSpecificStreamAttributes.from_dict(obj["roomAttributes"]) if obj.get("roomAttributes") is not None else None
        })
        return _obj


