# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.v2_user_key_request import V2UserKeyRequest
from typing import Optional, Set
from typing_extensions import Self

class V2UserAttributes(BaseModel):
    """
    V2 User record.
    """ # noqa: E501
    email_address: Optional[StrictStr] = Field(default=None, alias="emailAddress")
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    user_name: Optional[StrictStr] = Field(default=None, alias="userName")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    company_name: Optional[StrictStr] = Field(default=None, alias="companyName")
    department: Optional[StrictStr] = None
    division: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    work_phone_number: Optional[StrictStr] = Field(default=None, alias="workPhoneNumber")
    mobile_phone_number: Optional[StrictStr] = Field(default=None, alias="mobilePhoneNumber")
    two_factor_auth_phone: Optional[StrictStr] = Field(default=None, alias="twoFactorAuthPhone")
    sms_number: Optional[StrictStr] = Field(default=None, alias="smsNumber")
    account_type: Optional[StrictStr] = Field(default=None, alias="accountType")
    location: Optional[StrictStr] = None
    recommended_language: Optional[StrictStr] = Field(default=None, alias="recommendedLanguage")
    job_function: Optional[StrictStr] = Field(default=None, alias="jobFunction")
    asset_classes: Optional[List[StrictStr]] = Field(default=None, alias="assetClasses")
    industries: Optional[List[StrictStr]] = None
    market_coverage: Optional[List[StrictStr]] = Field(default=None, alias="marketCoverage")
    responsibility: Optional[List[StrictStr]] = None
    function: Optional[List[StrictStr]] = None
    instrument: Optional[List[StrictStr]] = None
    current_key: Optional[V2UserKeyRequest] = Field(default=None, alias="currentKey")
    previous_key: Optional[V2UserKeyRequest] = Field(default=None, alias="previousKey")
    __properties: ClassVar[List[str]] = ["emailAddress", "firstName", "lastName", "userName", "displayName", "companyName", "department", "division", "title", "workPhoneNumber", "mobilePhoneNumber", "twoFactorAuthPhone", "smsNumber", "accountType", "location", "recommendedLanguage", "jobFunction", "assetClasses", "industries", "marketCoverage", "responsibility", "function", "instrument", "currentKey", "previousKey"]

    @field_validator('account_type')
    def account_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NORMAL', 'SYSTEM', 'SDL']):
            raise ValueError("must be one of enum values ('NORMAL', 'SYSTEM', 'SDL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2UserAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of current_key
        if self.current_key:
            _dict['currentKey'] = self.current_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous_key
        if self.previous_key:
            _dict['previousKey'] = self.previous_key.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2UserAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "emailAddress": obj.get("emailAddress"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "userName": obj.get("userName"),
            "displayName": obj.get("displayName"),
            "companyName": obj.get("companyName"),
            "department": obj.get("department"),
            "division": obj.get("division"),
            "title": obj.get("title"),
            "workPhoneNumber": obj.get("workPhoneNumber"),
            "mobilePhoneNumber": obj.get("mobilePhoneNumber"),
            "twoFactorAuthPhone": obj.get("twoFactorAuthPhone"),
            "smsNumber": obj.get("smsNumber"),
            "accountType": obj.get("accountType"),
            "location": obj.get("location"),
            "recommendedLanguage": obj.get("recommendedLanguage"),
            "jobFunction": obj.get("jobFunction"),
            "assetClasses": obj.get("assetClasses"),
            "industries": obj.get("industries"),
            "marketCoverage": obj.get("marketCoverage"),
            "responsibility": obj.get("responsibility"),
            "function": obj.get("function"),
            "instrument": obj.get("instrument"),
            "currentKey": V2UserKeyRequest.from_dict(obj["currentKey"]) if obj.get("currentKey") is not None else None,
            "previousKey": V2UserKeyRequest.from_dict(obj["previousKey"]) if obj.get("previousKey") is not None else None
        })
        return _obj


