# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.avatar import Avatar
from symphony.bdk.gen.pod_model.user_system_info import UserSystemInfo
from symphony.bdk.gen.pod_model.v2_user_attributes import V2UserAttributes
from typing import Optional, Set
from typing_extensions import Self

class V2UserDetail(BaseModel):
    """
    V2 Detailed User record.
    """ # noqa: E501
    user_attributes: Optional[V2UserAttributes] = Field(default=None, alias="userAttributes")
    user_system_info: Optional[UserSystemInfo] = Field(default=None, alias="userSystemInfo")
    features: Optional[List[StrictInt]] = None
    apps: Optional[List[StrictInt]] = None
    groups: Optional[List[StrictInt]] = None
    roles: Optional[List[StrictStr]] = None
    disclaimers: Optional[List[StrictInt]] = None
    avatar: Optional[Avatar] = None
    __properties: ClassVar[List[str]] = ["userAttributes", "userSystemInfo", "features", "apps", "groups", "roles", "disclaimers", "avatar"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2UserDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user_attributes
        if self.user_attributes:
            _dict['userAttributes'] = self.user_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_system_info
        if self.user_system_info:
            _dict['userSystemInfo'] = self.user_system_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of avatar
        if self.avatar:
            _dict['avatar'] = self.avatar.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2UserDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userAttributes": V2UserAttributes.from_dict(obj["userAttributes"]) if obj.get("userAttributes") is not None else None,
            "userSystemInfo": UserSystemInfo.from_dict(obj["userSystemInfo"]) if obj.get("userSystemInfo") is not None else None,
            "features": obj.get("features"),
            "apps": obj.get("apps"),
            "groups": obj.get("groups"),
            "roles": obj.get("roles"),
            "disclaimers": obj.get("disclaimers"),
            "avatar": Avatar.from_dict(obj["avatar"]) if obj.get("avatar") is not None else None
        })
        return _obj


