# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.faceted_match_count import FacetedMatchCount
from symphony.bdk.gen.pod_model.v2_room_search_criteria import V2RoomSearchCriteria
from symphony.bdk.gen.pod_model.v3_room_detail import V3RoomDetail
from typing import Optional, Set
from typing_extensions import Self

class V3RoomSearchResults(BaseModel):
    """
    A list of search results and counts per search parameter.
    """ # noqa: E501
    count: Optional[StrictInt] = Field(default=None, description="The total number of rooms matched by the search.")
    skip: Optional[StrictInt] = Field(default=None, description="The number of skipped results.")
    limit: Optional[StrictInt] = Field(default=None, description="The number of returned results.")
    query: Optional[V2RoomSearchCriteria] = None
    rooms: Optional[List[V3RoomDetail]] = Field(default=None, description="A list of rooms matched by the query.")
    faceted_match_count: Optional[List[FacetedMatchCount]] = Field(default=None, description="Detailed counts of matched rooms per search criterion.", alias="facetedMatchCount")
    __properties: ClassVar[List[str]] = ["count", "skip", "limit", "query", "rooms", "facetedMatchCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V3RoomSearchResults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of query
        if self.query:
            _dict['query'] = self.query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rooms (list)
        _items = []
        if self.rooms:
            for _item_rooms in self.rooms:
                if _item_rooms:
                    _items.append(_item_rooms.to_dict())
            _dict['rooms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in faceted_match_count (list)
        _items = []
        if self.faceted_match_count:
            for _item_faceted_match_count in self.faceted_match_count:
                if _item_faceted_match_count:
                    _items.append(_item_faceted_match_count.to_dict())
            _dict['facetedMatchCount'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V3RoomSearchResults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "count": obj.get("count"),
            "skip": obj.get("skip"),
            "limit": obj.get("limit"),
            "query": V2RoomSearchCriteria.from_dict(obj["query"]) if obj.get("query") is not None else None,
            "rooms": [V3RoomDetail.from_dict(_item) for _item in obj["rooms"]] if obj.get("rooms") is not None else None,
            "facetedMatchCount": [FacetedMatchCount.from_dict(_item) for _item in obj["facetedMatchCount"]] if obj.get("facetedMatchCount") is not None else None
        })
        return _obj


