/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;

public class ArraySetItemHandler
extends AbstractHandler {
    @Override
    Object process(Command command) throws Exception {
        if (command.getPayload()[0] instanceof Object[]) {
            return this.setArrayElement(command);
        }
        if (command.getPayload()[0] instanceof List) {
            return this.setListElement(command);
        }
        if (command.getPayload()[0] instanceof Map) {
            return this.setMapElement(command);
        }
        if (command.getPayload()[0] instanceof Dictionary) {
            return this.setDictionaryElement(command);
        }
        throw new Exception(String.format("Cannot set element from %s", command.getPayload()[0]));
    }

    private Object setArrayElement(Command command) throws Exception {
        Object array = command.getPayload()[0];
        Object[] indexes = command.getPayload()[1] instanceof Object[] ? (Object[])command.getPayload()[1] : new Object[]{command.getPayload()[1]};
        Object value = command.getPayload()[2];
        switch (indexes.length) {
            case 1: {
                ((Object[])array)[((Integer)indexes[0]).intValue()] = value;
                break;
            }
            case 2: {
                ((Object[][])array)[((Integer)indexes[0]).intValue()][((Integer)indexes[1]).intValue()] = value;
                break;
            }
            case 3: {
                ((Object[][][])array)[((Integer)indexes[0]).intValue()][((Integer)indexes[1]).intValue()][((Integer)indexes[2]).intValue()] = value;
                break;
            }
            default: {
                throw new Exception("ArrayGetItemHandler exception");
            }
        }
        return 0;
    }

    private Object setListElement(Command command) {
        if (command.getPayload().length >= 3) {
            Object payload0 = command.getPayload()[0];
            Object payload1 = command.getPayload()[1];
            Object payload2 = command.getPayload()[2];
            if (payload0 instanceof List && payload1 instanceof Integer) {
                List list = (List)payload0;
                int index = (Integer)payload1;
                if (index >= 0 && index < list.size()) {
                    return list.set(index, payload2);
                }
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for list of size " + list.size());
            }
            throw new IllegalArgumentException("Expected a List and an Integer as the first two elements of the payload");
        }
        throw new IllegalArgumentException("Payload array must have at least 3 elements");
    }

    private Object setMapElement(Command command) {
        Map map = (Map)command.getPayload()[0];
        Object key = command.getPayload()[1];
        Object value = command.getPayload()[2];
        return map.put(key, value);
    }

    private Object setDictionaryElement(Command command) {
        Dictionary dict = (Dictionary)command.getPayload()[0];
        Object key = command.getPayload()[1];
        Object value = command.getPayload()[2];
        return dict.put(key, value);
    }
}

