/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeSerializer;
import com.javonet.utils.Command;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CommandSerializer {
    public byte[] serialize(Command rootCommand, IConnectionData connectionData) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write((byte)rootCommand.getRuntimeName().ordinal());
            stream.write(0);
            if (connectionData != null) {
                stream.write(connectionData.serializeConnectionData());
            } else {
                stream.write(new byte[]{0, 0, 0, 0, 0, 0, 0});
            }
            stream.write(new byte[]{(byte)RuntimeName.Jvm.ordinal(), (byte)rootCommand.getCommandType().ordinal()});
            this.serializeRecursively(rootCommand, stream);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error during serialization", e);
        }
    }

    private void serializeRecursively(Command command, ByteArrayOutputStream stream) throws IOException {
        for (Object item : command.getPayload()) {
            if (item instanceof Command) {
                Command innerCommand = (Command)item;
                stream.write(TypeSerializer.serializeCommand(innerCommand));
                this.serializeRecursively(innerCommand, stream);
                continue;
            }
            stream.write(TypeSerializer.serializePrimitive(item));
        }
    }
}

