/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.sdk.ConfigRuntimeFactory;
import com.javonet.sdk.RuntimeFactory;
import com.javonet.utils.UtilsConst;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.connectiondata.TcpConnectionData;
import com.javonet.utils.connectiondata.WsConnectionData;
import com.javonet.utils.messagehelper.MessageHelper;

public final class Javonet {
    public static RuntimeFactory inMemory() {
        return new RuntimeFactory(new InMemoryConnectionData());
    }

    public static RuntimeFactory tcp(TcpConnectionData connectionData) {
        return new RuntimeFactory(connectionData);
    }

    public static RuntimeFactory webSocket(WsConnectionData connectionData) {
        return new RuntimeFactory(connectionData);
    }

    public static ConfigRuntimeFactory withConfig(String configSource) {
        return new ConfigRuntimeFactory(configSource);
    }

    public static void activate(String licenseKey) {
        UtilsConst.setLicenseKey(licenseKey);
    }

    public static void setConfigSource(String configSource) {
        UtilsConst.setConfigSource(configSource);
    }

    public static void setJavonetWorkingDirectory(String path) {
        UtilsConst.setJavonetWorkingDirectory(path);
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                MessageHelper.getInstance().sendMessageToAppInsightsSync("UncaughtException", e.toString());
            }
        });
        MessageHelper.getInstance().sendMessageToAppInsights("SdkMessage", "Javonet SDK initialized");
    }
}

