# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Widget API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.widget.v1.models.env_info import EnvInfo
from dana.widget.v1.models.order import Order
from dana.widget.v1.models.service_info import ServiceInfo
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class WidgetPaymentRequestAdditionalInfo(BaseModel, BaseSdkModel):
    """
    WidgetPaymentRequestAdditionalInfo
    """ # noqa: E501
    support_deep_link_checkout_url: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of deeplink checkout URL. For Mini Program, DANA will treat as false")
    phone_number: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of user's phone number")
    public_user_id: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of public user's identifier")
    product_code: Annotated[str, Field(strict=True, max_length=32)] = Field(description="Additional information of product code")
    service_info: Optional[ServiceInfo] = Field(default=None)
    order: Order
    mcc: Annotated[str, Field(strict=True, max_length=64)] = Field(description="Additional information of merchant category code. This parameter is used to identify the type of business in which a merchant is engaged.")
    env_info: EnvInfo = Field()
    extend_info: Optional[Annotated[str, Field(strict=True, max_length=4096)]] = Field(default=None, description="Additional information of extend")
    __properties: ClassVar[List[str]] = ["supportDeepLinkCheckoutUrl", "phoneNumber", "publicUserId", "productCode", "serviceInfo", "order", "mcc", "envInfo", "extendInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WidgetPaymentRequestAdditionalInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of service_info
        if self.service_info:
            _dict['serviceInfo'] = self.service_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of env_info
        if self.env_info:
            _dict['envInfo'] = self.env_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WidgetPaymentRequestAdditionalInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "supportDeepLinkCheckoutUrl": obj.get("supportDeepLinkCheckoutUrl"),
            "phoneNumber": obj.get("phoneNumber"),
            "publicUserId": obj.get("publicUserId"),
            "productCode": obj.get("productCode"),
            "serviceInfo": ServiceInfo.from_dict(obj["serviceInfo"]) if obj.get("serviceInfo") is not None else None,
            "order": Order.from_dict(obj["order"]) if obj.get("order") is not None else None,
            "mcc": obj.get("mcc"),
            "envInfo": EnvInfo.from_dict(obj["envInfo"]) if obj.get("envInfo") is not None else None,
            "extendInfo": obj.get("extendInfo")
        })
        return _obj


