A [PsychoPy](https://www.psychopy.org/) plugin to work with the [Brain Imaging Data Structure (BIDS)](https://bids-specification.readthedocs.io/)

* **Website:** [https://psygraz.gitlab.io/psychopy-bids](https://psygraz.gitlab.io/psychopy-bids)
* **Documentation:** [https://psychopy-bids.readthedocs.io](https://psychopy-bids.readthedocs.io)
* **Source code:** [https://psychopy-bids.readthedocs.io](https://gitlab.com/psygraz/psychopy-bids/)
* **Contributing:** [https://psychopy-bids.readthedocs.io/en/doc/contributing/](https://psychopy-bids.readthedocs.io/en/doc/contributing/)
* **Bug reports:** [https://gitlab.com/psygraz/psychopy-bids/issues](https://gitlab.com/psygraz/psychopy-bids/issues)
* **Code of Conduct:** [https://psychopy-bids.readthedocs.io/en/doc/conduct/](https://psychopy-bids.readthedocs.io/en/doc/conduct/)

## Installation

We recommend installation in a virtual environment.

``` console
pip install psychopy_bids
```

## Usage

The psychopy bids plugin can be used to create valid BIDS valid datasets by creating [behavioral](https://bids-specification.readthedocs.io/en/stable/modality-specific-files/behavioral-experiments.html#example-_behtsv) or [task events](https://bids-specification.readthedocs.io/en/stable/04-modality-specific-files/05-task-events.html) in Psychopy. This can be done directly in python code or using the psychopy builder.

In code, the *BIDSHandler* can create or extend an existing BIDS dataset, including directory structure and necessary metadata files. Individual BIDS events can be added during the experiment and are passed to the *BIDSHandler* to write event `.tsv` files and accompanying `.json` files.

``` py linenums="1"
from psychopy_bids import bids

handler = bids.BIDSHandler(dataset="usage", subject="01", task="A")
handler.createDataset()

event_list = [
    bids.BIDSTaskEvent(
        onset=1.0,
        duration=0,
        trial_type="trigger"
    )
]

participant_info = {'participant_id': handler.subject, 'age': 18}
handler.addTaskEvents(event_list, participant_info)
```

In the builder you can use the newly added BIDS components to add events to a BIDS dataset.

![BIDS components](./img/home-fig01.PNG)

Using features such as custom columns it is possible to create detailed event tables for BIDS data.

| onset | duration | event_role | word | color | pressed_key | trial_type | response_time | trial_number | response_accuracy |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| 15.2876 | 1.2295 | instruction | instruction_text | black | space | n/a | 1.2295 | n/a | n/a |
| 16.5171 | n/a | response | n/a | n/a | space | n/a | 1.2295 | n/a | n/a |
| 16.538 | 0.5 | fixation | +  | black | n/a | n/a | n/a | n/a | n/a |
| 17.0593 | 0.8105 | stimulus | Red | green | left | incongruent | 0.8105 | 1.0 | correct |
| 17.8698 | n/a | response | Red | green | left | incongruent | 0.8105 | 1.0 | correct |
| 17.8972 | 1.0 | feedback | Correct! | green | n/a | incongruent | n/a | 1.0 | n/a |
| 18.9272  | 0.5 | fixation | + | black | n/a | n/a | n/a | n/a | n/a |

Please see individual tutorials for using psychopy bids in [code](./coder.md) or the [psychopy builder](./builder.md).

## Contributing

Interested in contributing? Check out the contributing guidelines. Please note that this project is released with a Code of Conduct. By contributing to this project, you agree to abide by its terms.

## License

`psychopy_bids` was created by Christoph Anzengruber & Florian Schöngaßner. It is licensed under the terms of the GNU General Public License v3.0 license.

## Credits

`psychopy_bids` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).