"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .method_response import MethodResponse
from .method_status import MethodStatus
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityMethodAllImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class EntityMethodAllImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class EntityMethodAllIssuerImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class EntityMethodAllIssuerImage(BaseModel):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class EntityMethodAllIssuerTypedDict(TypedDict):
    resource: str
    id: str
    name: str
    r"""The full name of the issuer."""
    image: EntityMethodAllIssuerImageTypedDict
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class EntityMethodAllIssuer(BaseModel):
    resource: str

    id: str

    name: str
    r"""The full name of the issuer."""

    image: EntityMethodAllIssuerImage
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class EntityMethodAllLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityMethodAllLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PricingTypedDict(TypedDict):
    description: str
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a
    category of cards (`American Express`). If a `locale` is provided, the description may be translated.
    """
    fixed: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    variable: str
    r"""The variable price charged per payment, as a percentage string."""
    fee_region: NotRequired[Nullable[str]]
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as
    returned in the [Payments API](get-payment).
    """


class Pricing(BaseModel):
    description: str
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a
    category of cards (`American Express`). If a `locale` is provided, the description may be translated.
    """

    fixed: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    variable: str
    r"""The variable price charged per payment, as a percentage string."""

    fee_region: Annotated[OptionalNullable[str], pydantic.Field(alias="feeRegion")] = (
        UNSET
    )
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as
    returned in the [Payments API](get-payment).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["feeRegion"]
        nullable_fields = ["feeRegion"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EntityMethodAllTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """
    id: Nullable[MethodResponse]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """
    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    maximum_amount: Nullable[AmountNullableTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    image: EntityMethodAllImageTypedDict
    r"""URLs of images representing the payment method."""
    status: MethodStatus
    r"""The payment method's activation status for this profile."""
    links: EntityMethodAllLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    issuers: NotRequired[List[EntityMethodAllIssuerTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """
    pricing: NotRequired[List[PricingTypedDict]]
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on
    your account.
    """


class EntityMethodAll(BaseModel):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """

    id: Annotated[Nullable[MethodResponse], PlainValidator(validate_open_enum(False))]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """

    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[Amount, pydantic.Field(alias="minimumAmount")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    maximum_amount: Annotated[
        Nullable[AmountNullable], pydantic.Field(alias="maximumAmount")
    ]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    image: EntityMethodAllImage
    r"""URLs of images representing the payment method."""

    status: Annotated[MethodStatus, PlainValidator(validate_open_enum(False))]
    r"""The payment method's activation status for this profile."""

    links: Annotated[EntityMethodAllLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    issuers: Optional[List[EntityMethodAllIssuer]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """

    pricing: Optional[List[Pricing]] = None
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on
    your account.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["issuers", "pricing"]
        nullable_fields = ["id", "maximumAmount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
