"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .route_destination_type_response import RouteDestinationTypeResponse
from .url import URL, URLTypedDict
from mollie.types import BaseModel
from mollie.utils import validate_open_enum
import pydantic
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RouteGetResponseDestinationTypedDict(TypedDict):
    r"""The destination of the route."""

    type: RouteDestinationTypeResponse
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str


class RouteGetResponseDestination(BaseModel):
    r"""The destination of the route."""

    type: Annotated[
        RouteDestinationTypeResponse, PlainValidator(validate_open_enum(False))
    ]
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]


class RouteGetResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteGetResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteGetResponseTypedDict(TypedDict):
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    resource: NotRequired[str]
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: NotRequired[str]
    payment_id: NotRequired[str]
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: NotRequired[str]
    r"""The description of the route. This description is shown in the reports."""
    destination: NotRequired[RouteGetResponseDestinationTypedDict]
    r"""The destination of the route."""
    links: NotRequired[RouteGetResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class RouteGetResponse(BaseModel):
    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    resource: Optional[str] = None
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: Optional[str] = None

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: Optional[str] = None
    r"""The description of the route. This description is shown in the reports."""

    destination: Optional[RouteGetResponseDestination] = None
    r"""The destination of the route."""

    links: Annotated[
        Optional[RouteGetResponseLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
