import * as cdk from '@aws-cdk/core';
/**
 * Properties of the StackOutputs.
 *
 * @stability stable
 */
export interface StackOutputsProps {
    /**
     * The remote CDK stack to get the outputs from.
     *
     * @stability stable
     */
    readonly stack: cdk.Stack;
    /**
     * Indicate whether always update the custom resource to get the new stack output.
     *
     * @default true
     * @stability stable
     */
    readonly alwaysUpdate?: boolean;
}
/**
 * Represents the StackOutputs of the remote CDK stack.
 *
 * @stability stable
 */
export declare class StackOutputs extends cdk.Construct {
    /**
     * The outputs from the remote stack.
     *
     * @stability stable
     */
    readonly outputs: cdk.CustomResource;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: StackOutputsProps);
    /**
     * Get the attribute value from the outputs.
     *
     * @param key output key.
     * @stability stable
     */
    getAttString(key: string): string;
}
