"""The fib Model Code 2010."""

import typing as t

from ._concrete_creep_and_shrinkage import (
    alpha_fcm,
    beta_bc_fcm,
    beta_bc_t,
    beta_bs,
    beta_dc_fcm,
    beta_dc_RH,
    beta_dc_t,
    beta_dc_t0,
    beta_ds,
    beta_h,
    beta_RH,
    beta_s1,
    calc_J,
    eps_cbs,
    eps_cbs0,
    eps_cds,
    eps_cds0,
    gamma_t0,
    k_sigma,
    phi,
    phi_bc,
    phi_dc,
    t0_adj,
    t_T,
)
from ._concrete_interface_different_casting_times import (
    tau_edi,
    tau_rdi_with_reinforcement,
    tau_rdi_without_reinforcement,
)
from ._concrete_material_properties import (
    Eci,
    Eci_t,
    Gf,
    beta_cc,
    beta_e,
    eps_c1,
    eps_c2,
    eps_c3,
    eps_cu1,
    eps_cu2,
    eps_cu3,
    fcd,
    fcm,
    fctkmax,
    fctkmin,
    fctm,
    k_sargin,
    n_parabolic_rectangular,
)
from ._concrete_punching import (
    b_0,
    m_ed,
    psi_punching,
    v_rd_max_punching,
    v_rd_punching,
    v_rdc_punching,
    v_rds_punching,
)
from ._concrete_shear import (
    create_load_dict,
    epsilon_x,
    eta_fc,
    v_rd,
    v_rd_ct,
    v_rd_ct_approx1,
    v_rd_ct_approx2,
    v_rd_max,
    v_rd_max_approx1,
    v_rd_max_approx2,
    v_rd_max_approx3,
    v_rdc,
    v_rdc_approx1,
    v_rdc_approx2,
    v_rdc_approx3,
    v_rds,
)
from ._concrete_torsion import t_rd, t_rd_max, v_ed_ti
from ._interface_concrete_steel_rebar import (
    K_tr,
    eta_2,
    f_stm,
    s_1,
    s_2,
    s_3,
    s_tau_bu_split,
    tau_bmax,
    tau_bu_split,
    tau_yield,
)
from ._reinforcement_material_properties import (
    epsud,
    fyd,
    reinforcement_duct_props,
)

__all__ = [
    'fcm',
    'fctm',
    'fctkmin',
    'fctkmax',
    'fcd',
    'Gf',
    'eps_c1',
    'eps_cu1',
    'k_sargin',
    'eps_c2',
    'eps_cu2',
    'n_parabolic_rectangular',
    'eps_c3',
    'eps_cu3',
    'fyd',
    'epsud',
    'reinforcement_duct_props',
    'Eci',
    'Eci_t',
    'beta_cc',
    'beta_e',
    'alpha_fcm',
    'beta_bc_fcm',
    'beta_bc_t',
    'beta_bs',
    'beta_dc_fcm',
    'beta_dc_RH',
    'beta_dc_t',
    'beta_dc_t0',
    'beta_ds',
    'beta_h',
    'beta_RH',
    'beta_s1',
    'calc_J',
    'eps_cbs',
    'eps_cbs0',
    'eps_cds',
    'eps_cds0',
    'gamma_t0',
    'k_sigma',
    'phi',
    'phi_bc',
    'phi_dc',
    't0_adj',
    't_T',
    'create_load_dict',
    'epsilon_x',
    'eta_fc',
    'v_rd',
    'v_rd_ct',
    'v_rd_ct_approx1',
    'v_rd_ct_approx2',
    'v_rd_max',
    'v_rd_max_approx1',
    'v_rd_max_approx2',
    'v_rd_max_approx3',
    'v_rdc',
    'v_rdc_approx1',
    'v_rdc_approx2',
    'v_rdc_approx3',
    'v_rds',
    'b_0',
    'm_ed',
    'psi_punching',
    'v_rd_max_punching',
    'v_rd_punching',
    'v_rdc_punching',
    'v_rds_punching',
    'v_ed_ti',
    't_rd_max',
    't_rd',
    'tau_edi',
    'tau_rdi_with_reinforcement',
    'tau_rdi_without_reinforcement',
    'eta_2',
    'tau_bu_split',
    'K_tr',
    'tau_bmax',
    's_1',
    's_2',
    's_3',
    's_tau_bu_split',
    'f_stm',
    'tau_yield',
]

__title__: str = 'fib Model Code 2010'
__year__: str = '2013'
__materials__: t.Tuple[str] = ('concrete', 'reinforcement')
