from zope.interface import Interface
from zope.interface import Attribute
from zope.interface import implements

from zope.event import notify
from zope.app.event.interfaces import IObjectEvent
from zope.app.event.objectevent import ObjectEvent

from Acquisition import aq_inner
from Acquisition import aq_parent

from Products.DCWorkflow.DCWorkflow import DCWorkflowDefinition
from Products.DCWorkflow.Expression import StateChangeInfo
from Products.DCWorkflow.Expression import createExprContext
from Products.DCWorkflow import interfaces as DCWorkflowInterfaces

"""
Patch implementation of the CMF 2.1 workflow transition event notification
system.

This patch is generated by AGX2 if plone_target_version points to '2.5' to
be sure the event notification on workflow transitions works.
"""

class ITransitionEvent(IObjectEvent):
    """An event that's fired upon a workflow transition.
    """
    workflow = Attribute(u"The workflow definition triggering the "
                          "transition")
    old_state = Attribute(u"The state definition of the workflow state before "
                           "the transition")
    new_state = Attribute(u"The state definition of the workflow state before "
                           "after transition")
    transition = Attribute(u"The transition definition taking place. "
                            "May be None if this is the 'transition' to the "
                            "initial state.")                                   
    status = Attribute(u"The history/status dict of the object before the "
                        "transition.")
    kwargs = Attribute(u"Any keyword arguments passed to doActionFor() when "
                        "the transition was invoked")
    
class IBeforeTransitionEvent(ITransitionEvent):    
    """An event fired before a workflow transition.
    """
    
class IAfterTransitionEvent(ITransitionEvent):
    """An event that's fired after a workflow transition.
    """

class TransitionEvent(ObjectEvent):
    implements(ITransitionEvent)
    
    def __init__(self, obj, workflow, old_state, new_state,
                 transition, status, kwargs):
        ObjectEvent.__init__(self, obj)
        self.workflow = workflow
        self.old_state = old_state
        self.new_state = new_state
        self.transition = transition
        self.status = status
        self.kwargs = kwargs
        
class BeforeTransitionEvent(TransitionEvent):
    implements(IBeforeTransitionEvent)
    
class AfterTransitionEvent(TransitionEvent):
    implements(IAfterTransitionEvent)

def _executeTransition(self, ob, tdef=None, kwargs=None):
    """
    Private method.
    Puts object in a new state.
    """
    sci = None
    econtext = None
    moved_exc = None

    # Figure out the old and new states.
    old_sdef = self._getWorkflowStateOf(ob)
    old_state = old_sdef.getId()
    if tdef is None:
        new_state = self.initial_state
        former_status = {}
    else:
        new_state = tdef.new_state_id
        if not new_state:
            # Stay in same state.
            new_state = old_state
        former_status = self._getStatusOf(ob)
    new_sdef = self.states.get(new_state, None)
    if new_sdef is None:
        raise WorkflowException, (
            'Destination state undefined: ' + new_state)
        
    # Fire "before" event
    notify(BeforeTransitionEvent(ob, self, old_sdef, new_sdef, tdef,
                                 former_status, kwargs))
    
    # Execute the "before" script.
    if tdef is not None and tdef.script_name:
        script = self.scripts[tdef.script_name]
        # Pass lots of info to the script in a single parameter.
        sci = StateChangeInfo(
            ob, self, former_status, tdef, old_sdef, new_sdef, kwargs)
        try:
            script(sci)  # May throw an exception.
        except ObjectMoved, moved_exc:
            ob = moved_exc.getNewObject()
            # Re-raise after transition

    # Update variables.
    state_values = new_sdef.var_values
    if state_values is None: state_values = {}
    tdef_exprs = None
    if tdef is not None: tdef_exprs = tdef.var_exprs
    if tdef_exprs is None: tdef_exprs = {}
    status = {}
    for id, vdef in self.variables.items():
        if not vdef.for_status:
            continue
        expr = None
        if state_values.has_key(id):
            value = state_values[id]
        elif tdef_exprs.has_key(id):
            expr = tdef_exprs[id]
        elif not vdef.update_always and former_status.has_key(id):
            # Preserve former value
            value = former_status[id]
        else:
            if vdef.default_expr is not None:
                expr = vdef.default_expr
            else:
                value = vdef.default_value
        if expr is not None:
            # Evaluate an expression.
            if econtext is None:
                # Lazily create the expression context.
                if sci is None:
                    sci = StateChangeInfo(
                        ob, self, former_status, tdef,
                        old_sdef, new_sdef, kwargs)
                econtext = createExprContext(sci)
            value = expr(econtext)
        status[id] = value

    # Update state.
    status[self.state_var] = new_state
    tool = aq_parent(aq_inner(self))
    tool.setStatusOf(self.id, ob, status)

    # Update role to permission assignments.
    self.updateRoleMappingsFor(ob)

    # Execute the "after" script.
    if tdef is not None and tdef.after_script_name:
        script = self.scripts[tdef.after_script_name]
        # Pass lots of info to the script in a single parameter.
        sci = StateChangeInfo(
            ob, self, status, tdef, old_sdef, new_sdef, kwargs)
        script(sci)  # May throw an exception.
    
    # Fire "after" event
    notify(AfterTransitionEvent(ob, self, old_sdef, new_sdef,
                                tdef, former_status, kwargs))

    # Return the new state object.
    if moved_exc is not None:
        # Propagate the notification that the object has moved.
        raise moved_exc
    else:
        return new_sdef

DCWorkflowDefinition._executeTransition = _executeTransition
DCWorkflowInterfaces.ITransitionEvent = ITransitionEvent
DCWorkflowInterfaces.IBeforeTransitionEvent = IBeforeTransitionEvent
DCWorkflowInterfaces.IAfterTransitionEvent = IAfterTransitionEvent
