import pytest
from promise import Promise

from graphene import ObjectType
from graphene.relay import Connection, Node

from ..fields import (SQLAlchemyConnectionField,
                      UnsortedSQLAlchemyConnectionField)
from ..types import SQLAlchemyObjectType
from .models import Editor as EditorModel
from .models import Pet as PetModel


class Pet(SQLAlchemyObjectType):
    class Meta:
        model = PetModel
        interfaces = (Node,)


class Editor(SQLAlchemyObjectType):
    class Meta:
        model = EditorModel

##
# SQLAlchemyConnectionField
##


def test_promise_connection_resolver():
    def resolver(_obj, _info):
        return Promise.resolve([])

    result = UnsortedSQLAlchemyConnectionField.connection_resolver(
        resolver, Pet._meta.connection, Pet, None, None
    )
    assert isinstance(result, Promise)


def test_type_assert_sqlalchemy_object_type():
    with pytest.raises(AssertionError, match="only accepts SQLAlchemyObjectType"):
        SQLAlchemyConnectionField(ObjectType).type


def test_type_assert_object_has_connection():
    with pytest.raises(AssertionError, match="doesn't have a connection"):
        SQLAlchemyConnectionField(Editor).type

##
# UnsortedSQLAlchemyConnectionField
##


def test_sort_added_by_default():
    field = SQLAlchemyConnectionField(Pet._meta.connection)
    assert "sort" in field.args
    assert field.args["sort"] == Pet.sort_argument()


def test_sort_can_be_removed():
    field = SQLAlchemyConnectionField(Pet._meta.connection, sort=None)
    assert "sort" not in field.args


def test_custom_sort():
    field = SQLAlchemyConnectionField(Pet._meta.connection, sort=Editor.sort_argument())
    assert field.args["sort"] == Editor.sort_argument()


def test_sort_init_raises():
    with pytest.raises(TypeError, match="Cannot create sort"):
        SQLAlchemyConnectionField(Connection)
