(function(){RB.AbstractCommentBlock=Backbone.Model.extend({defaults:{hasDraft:false,canDelete:false,draftComment:null,reviewRequest:null,review:null,serializedComments:[],count:0},initialize:function(){var comments=this.get("serializedComments"),newSerializedComments=[],comment_attr={};console.assert(this.get("reviewRequest"),"reviewRequest must be provided");console.assert(this.get("review"),"review must be provided");if(comments.length>0){_.each(comments,function(comment){comment.text=$("<div/>").html(comment.text).text();if(comment.localdraft){comment_attr.text=comment.text;comment_attr.richText=comment.rich_text;comment_attr.issueOpened=comment.issue_opened;comment_attr.issueStatus=comment.issue_status;this.ensureDraftComment(comment.comment_id,comment_attr)}else{newSerializedComments.push(comment)}},this);this.set("serializedComments",newSerializedComments)}else{this.ensureDraftComment()}this.on("change:draftComment",this._updateCount,this);this._updateCount()},isEmpty:function(){return this.get("serializedComments").length===0&&!this.has("draftComment")},createComment:function(){console.assert(false,"This must be implemented by a subclass")},ensureDraftComment:function(id,comment_attr){var comment;if(this.has("draftComment")){return}comment=this.createComment(id);comment.set(comment_attr);comment.on("destroy",function(){this.set("draftComment",null);this._updateCount()},this);comment.on("saved",this._updateCount,this);this.set("draftComment",comment)},_updateCount:function(){var count=this.get("serializedComments").length;if(this.has("draftComment")){count++}this.set("count",count)}});RB.AbstractReviewable=Backbone.Model.extend({defaults:{caption:null,renderedInline:false,reviewRequest:null,review:null,serializedCommentBlocks:[]},commentBlockModel:null,defaultCommentBlockFields:[],initialize:function(){var reviewRequest=this.get("reviewRequest");console.assert(this.commentBlockModel,"'commentBlockModel' must be defined in the "+"reviewable's object definition");console.assert(reviewRequest,"'reviewRequest' must be provided when constructing "+"the reviewable");if(!this.get("review")){this.set("review",reviewRequest.createReview())}this.commentBlocks=new Backbone.Collection;this.commentBlocks.model=this.commentBlockModel;_.each(this.get("serializedCommentBlocks"),this.loadSerializedCommentBlock,this)},createCommentBlock:function(attrs){this.commentBlocks.add(_.defaults({reviewRequest:this.get("reviewRequest"),review:this.get("review")},attrs))},loadSerializedCommentBlock:function(){console.assert(false,"loadSerializedCommentBlock must be "+"implemented by a subclass")}});RB.CommentEditor=Backbone.Model.extend({defaults:function(){var userSession=RB.UserSession.instance;return{canDelete:false,canEdit:undefined,canSave:false,editing:false,extraData:{},comment:null,dirty:false,openIssue:userSession.get("commentsOpenAnIssue"),publishedComments:[],publishedCommentsType:null,reviewRequest:null,richText:userSession.get("defaultUseRichText"),statusText:"",text:""}},initialize:function(){var reviewRequest=this.get("reviewRequest");this.on("change:comment",this._updateFromComment,this);this._updateFromComment();if(this.get("canEdit")===undefined){reviewRequest.on("change:hasDraft",this._updateCanEdit,this);this._updateCanEdit()}this.on("change:dirty",function(model,dirty){var reviewRequestEditor=this.get("reviewRequestEditor");if(reviewRequestEditor){if(dirty){reviewRequestEditor.incr("editCount")}else{reviewRequestEditor.decr("editCount")}}this.set("statusText",dirty?gettext("This comment has unsaved changes."):"")},this);this.on("change:openIssue change:richText change:text",function(){if(this.get("editing")){this.set("dirty",true);this._updateState()}},this);this._updateState()},setExtraData:function(key,value){var extraData=this.get("extraData");extraData[key]=value},getExtraData:function(key){return this.get("extraData")[key]},beginEdit:function(){console.assert(this.get("canEdit"),"beginEdit() called when canEdit is false.");console.assert(this.get("comment"),"beginEdit() called when no comment was first set.");this.set({dirty:false,editing:true});this._updateState()},deleteComment:function(){var comment=this.get("comment");console.assert(this.get("canDelete"),"deleteComment() called when canDelete is false.");comment.destroy({success:function(){this.trigger("deleted");this.close()}},this)},cancel:function(){var comment=this.get("comment");this.off("change:comment",this._updateFromComment,this);if(comment){comment.destroyIfEmpty();this.trigger("canceled")}this.close()},close:function(){this.set("editing",false);this.set({comment:null,dirty:false,extraData:{},text:""});this.trigger("closed")},save:function(options,context){var comment=this.get("comment");console.assert(this.get("canSave"),"save() called when canSave is false.");options=options||{};comment.set({text:this.get("text"),issueOpened:this.get("openIssue"),extraData:_.clone(this.get("extraData")),richText:this.get("richText"),includeTextTypes:"raw,markdown"});comment.save({success:_.bind(function(){this.set("dirty",false);this.trigger("saved");if(_.isFunction(options.success)){options.success.call(context)}},this),error:_.isFunction(options.error)?_.bind(options.error,context):undefined})},_updateFromComment:function(){var oldComment=this.previous("comment"),comment=this.get("comment"),defaultRichText,textFields;if(oldComment){oldComment.destroyIfEmpty()}this.set("statusText","");if(comment){defaultRichText=this.defaults().richText;this.set({dirty:false,extraData:comment.get("extraData"),openIssue:comment.get("issueOpened")===null?this.defaults().openIssue:comment.get("issueOpened"),richText:defaultRichText||!!comment.get("richText")});textFields=comment.get("richText")||!defaultRichText?comment.get("rawTextFields"):comment.get("markdownTextFields");this.set("text",!_.isEmpty(textFields)?textFields.text:comment.get("text"));comment.ready({ready:this._updateState},this)}},_updateCanEdit:function(){var reviewRequest=this.get("reviewRequest"),userSession=RB.UserSession.instance;this.set("canEdit",userSession.get("authenticated")&&!reviewRequest.get("hasDraft"))},_updateState:function(){var canEdit=this.get("canEdit"),editing=this.get("editing"),comment=this.get("comment");this.set({canDelete:canEdit&&editing&&comment&&!comment.isNew(),canSave:canEdit&&editing&&this.get("text")!==""})}});RB.CommentIssueManager=Backbone.Model.extend({defaults:{reviewRequest:null},initialize:function(){this._comments={}},setCommentState:function(reviewID,commentID,commentType,state){var comment=this._getComment(reviewID,commentID,commentType);this._requestState(comment,state)},_getComment:function(reviewID,commentID,commentType){if(!this._comments[commentID]){var comment=null,reviewRequest=this.get("reviewRequest");if(commentType==="diff_comments"){comment=reviewRequest.createReview(reviewID).createDiffComment(commentID)}else if(commentType==="screenshot_comments"){comment=reviewRequest.createReview(reviewID).createScreenshotComment(commentID)}else if(commentType==="file_attachment_comments"){comment=reviewRequest.createReview(reviewID).createFileAttachmentComment(commentID)}else{console.log("getComment received unexpected context type '%s'",commentType)}this._comments[commentID]=comment}return this._comments[commentID]},_requestState:function(comment,state){var self=this;comment.ready({ready:function(){var oldIssueStatus=comment.get("issueStatus");comment.set("issueStatus",state);comment.save({attrs:["issueStatus"],success:function(comment,rsp){var rspComment=rsp.diff_comment||rsp.file_attachment_comment||rsp.screenshot_comment;self.trigger("issueStatusUpdated",comment,oldIssueStatus,rspComment.timestamp)}})}})}});RB.FileAttachmentCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({fileAttachmentID:null,diffAgainstFileAttachmentID:null},RB.AbstractCommentBlock.prototype.defaults),serializedFields:[],createComment:function(id){var comment=this.get("review").createFileAttachmentComment(id,this.get("fileAttachmentID"),this.get("diffAgainstFileAttachmentID"));_.extend(comment.get("extraData"),_.pick(this.attributes,this.serializedFields));return comment}});RB.FileAttachmentReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({caption:"",fileAttachmentID:null,diffAgainstFileAttachmentID:null},RB.AbstractReviewable.prototype.defaults),defaultCommentBlockFields:["fileAttachmentID","diffAgainstFileAttachmentID"],loadSerializedCommentBlock:function(serializedCommentBlock){this.createCommentBlock(_.extend({fileAttachmentID:this.get("fileAttachmentID"),diffAgainstFileAttachmentID:this.get("diffAgainstFileAttachmentID"),serializedComments:serializedCommentBlock},this.commentBlockModel.prototype.parse(_.pick(serializedCommentBlock[0],this.commentBlockModel.prototype.serializedFields))))}});RB.RegionCommentBlock=RB.FileAttachmentCommentBlock.extend({defaults:_.defaults({x:null,y:null,width:null,height:null},RB.AbstractCommentBlock.prototype.defaults),serializedFields:["x","y","width","height"],parse:function(fields){fields.x=parseInt(fields.x,10)||undefined;fields.y=parseInt(fields.y,10)||undefined;fields.width=parseInt(fields.width,10)||undefined;fields.height=parseInt(fields.height,10)||undefined;return fields}});RB.ReviewReplyEditor=Backbone.Model.extend({defaults:{contextID:null,contextType:null,commentID:null,hasDraft:false,replyObject:null,review:null,reviewReply:null,richText:null,text:""},replyClasses:{diff_comments:RB.DiffCommentReply,screenshot_comments:RB.ScreenshotCommentReply,file_attachment_comments:RB.FileAttachmentCommentReply},initialize:function(){this.on("change:reviewReply",this._setupReviewReply,this);this._setupReviewReply()},save:function(){var contextType=this.get("contextType"),reviewReply=this.get("reviewReply"),valueAttr,richTextAttr,ReplyClass,obj;if(contextType==="body_top"){valueAttr="bodyTop";richTextAttr="bodyTopRichText";obj=reviewReply}else if(contextType==="body_bottom"){valueAttr="bodyBottom";richTextAttr="bodyBottomRichText";obj=reviewReply}else{valueAttr="text";richTextAttr="richText";obj=this.get("replyObject");if(!obj){ReplyClass=this.replyClasses[contextType];console.assert(ReplyClass,"Unexpected context type '%s'",contextType);obj=new ReplyClass({parentObject:reviewReply,replyToID:this.get("contextID"),id:this.get("commentID")})}}this.set("replyObject",obj);this.trigger("saving");obj.ready({ready:function(){var text=this.get("text");if(text){obj.set(valueAttr,text);obj.set(richTextAttr,this.get("richText"));obj.set({forceTextType:"html",includeTextTypes:"raw"});obj.save({attrs:[valueAttr,richTextAttr,"forceTextType","includeTextTypes","replyToID"],success:function(){this.set({hasDraft:true,text:obj.get(valueAttr),richText:true});this.trigger("textUpdated");this.trigger("saved")}},this)}else{this.resetStateIfEmpty()}}},this)},resetStateIfEmpty:function(){var text=this.get("text"),replyObject=this.get("replyObject");if(text.strip()!==""){return}if(!replyObject||replyObject.isNew()){this._resetState()}else{replyObject.destroy({success:this._resetState},this)}},_setupReviewReply:function(){var reviewReply=this.get("reviewReply"),oldReviewReply=this.previous("reviewReply");if(oldReviewReply){oldReviewReply.off(null,null,this)}this.listenTo(reviewReply,"destroyed",function(){this.trigger("discarded");this._resetState()});this.listenTo(reviewReply,"published",function(){this.trigger("published");this._resetState(false)})},_resetState:function(shouldDiscardIfEmpty){this.set({commentID:null,hasDraft:false,replyObject:null});if(shouldDiscardIfEmpty===false){this.trigger("resetState")}else{this.get("reviewReply").discardIfEmpty({success:function(){this.trigger("resetState")}},this)}}});RB.ReviewRequestEditor=Backbone.Model.extend({defaults:{commentIssueManager:null,editable:false,editCount:0,hasDraft:false,fileAttachmentComments:{},mutableByUser:false,pendingSaveCount:0,publishing:false,reviewRequest:null,statusEditable:false,statusMutableByUser:false},initialize:function(){var reviewRequest=this.get("reviewRequest");this.fileAttachments=new Backbone.Collection([],{model:RB.FileAttachment});this.fileAttachments.on("add",this._onFileAttachmentOrScreenshotAdded,this);this.screenshots=new Backbone.Collection([],{model:RB.Screenshot});this.screenshots.on("add",this._onFileAttachmentOrScreenshotAdded,this);reviewRequest.draft.on("saving",function(){this.trigger("saving")},this);reviewRequest.draft.on("saved",function(){this.trigger("saved")},this);this.listenTo(reviewRequest,"change:state",this._computeEditable);this._computeEditable()},createFileAttachment:function(attributes){var draft=this.get("reviewRequest").draft,fileAttachment=draft.createFileAttachment(attributes);this.fileAttachments.add(fileAttachment);return fileAttachment},getDraftField:function(fieldName,options){var reviewRequest=this.get("reviewRequest"),draft=reviewRequest.draft;if(options.useExtraData){return draft.get("extraData")[options.fieldID]}else if(fieldName==="closeDescription"||fieldName==="closeDescriptionRichText"){return reviewRequest.get(fieldName)}else{return draft.get(fieldName)}},setDraftField:function(fieldName,value,options,context){var reviewRequest=this.get("reviewRequest"),jsonFieldName,jsonTextTypeFieldName,richText,data={};options=options||{};richText=!!options.richText;if(fieldName==="closeDescription"&&_.has(options,"closeType")){reviewRequest.close({type:options.closeType,richText:richText,description:value,success:options.success,error:options.error,postData:{force_text_type:"html",include_text_types:"raw"}},context);return}jsonFieldName=options.jsonFieldName;if(options.useExtraData){jsonFieldName="extra_data."+jsonFieldName}if(options.allowMarkdown){jsonTextTypeFieldName=options.jsonTextTypeFieldName;if(options.useExtraData){jsonTextTypeFieldName="extra_data."+jsonTextTypeFieldName}data[jsonTextTypeFieldName]=richText?"markdown":"plain";data.force_text_type="html";data.include_text_types="raw"}data[jsonFieldName]=value;reviewRequest.draft.save({data:data,error:function(model,xhr){var rsp,fieldValue,fieldValueLen,message="";this.set("publishing",false);if(_.isFunction(options.error)){rsp=xhr.errorPayload;fieldValue=rsp.fields[jsonFieldName];fieldValueLen=fieldValue.length;_.each(fieldValue,function(value,i){if(i===fieldValueLen-1&&fieldValueLen>1){if(i>2){message+=", "}message+=" and '"+value+"'"}else{if(i>0){message+=", "}message+="'"+value+"'"}});if(fieldName==="targetGroups"){message=interpolate(ngettext("Group %s does not exist.","Groups %s do not exist.",fieldValue.length),[message])}else if(fieldName==="targetPeople"){message=interpolate(ngettext("User %s does not exist.","Users %s do not exist.",fieldValue.length),[message])}else if(fieldName==="dependsOn"){message=interpolate(ngettext("Review Request %s does not exist.","Review Requests %s do not exist.",fieldValue.length),[message])}options.error.call(context,{errorText:message})}},success:function(){if(_.isFunction(options.success)){options.success.call(context)}if(this.get("publishing")){this.decr("pendingSaveCount");if(this.get("pendingSaveCount")===0){this.set("publishing",false);this.publishDraft()}}}},this)},publishDraft:function(){var reviewRequest=this.get("reviewRequest"),onError=function(model,xhr){this.trigger("publishError",xhr.errorText)};reviewRequest.draft.ensureCreated({success:function(){reviewRequest.draft.publish({success:function(){this.trigger("published")},error:onError},this)},error:onError},this)},incr:function(attr){var value=this.get(attr);console.assert(_.isNumber(value));this.set(attr,value+1,{validate:true})},decr:function(attr){var value=this.get(attr);console.assert(_.isNumber(value));this.set(attr,value-1,{validate:true})},validate:function(attrs){var strings=RB.ReviewRequestEditor.strings;if(_.has(attrs,"editCount")&&attrs.editCount<0){return strings.UNBALANCED_EDIT_COUNT}},_computeEditable:function(){var state=this.get("reviewRequest").get("state"),pending=state===RB.ReviewRequest.PENDING;this.set({editable:this.get("mutableByUser")&&pending,statusEditable:this.get("statusMutableByUser")&&!pending})},_onFileAttachmentOrScreenshotAdded:function(fileAttachment){fileAttachment.on("saving",function(){this.trigger("saving")},this);fileAttachment.on("saved destroy",function(){this.trigger("saved")},this)}},{strings:{UNBALANCED_EDIT_COUNT:gettext("There is an internal error balancing the edit count")}});RB.ImageReviewable=RB.FileAttachmentReviewable.extend({defaults:_.defaults({imageURL:"",diffAgainstImageURL:""},RB.FileAttachmentReviewable.prototype.defaults),commentBlockModel:RB.RegionCommentBlock});RB.ScreenshotCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({screenshotID:null,x:null,y:null,width:null,height:null},RB.AbstractCommentBlock.prototype.defaults),createComment:function(id){return this.get("review").createScreenshotComment(id,this.get("screenshotID"),this.get("x"),this.get("y"),this.get("width"),this.get("height"))}});RB.ScreenshotReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({caption:"",imageURL:"",screenshotID:null},RB.AbstractReviewable.prototype.defaults),commentBlockModel:RB.ScreenshotCommentBlock,defaultCommentBlockFields:["screenshotID"],loadSerializedCommentBlock:function(serializedCommentBlock){this.createCommentBlock({screenshotID:this.get("screenshotID"),x:serializedCommentBlock[0].x,y:serializedCommentBlock[0].y,width:serializedCommentBlock[0].w,height:serializedCommentBlock[0].h,serializedComments:serializedCommentBlock})}});RB.TextCommentBlock=RB.FileAttachmentCommentBlock.extend({defaults:_.defaults({beginLineNum:null,endLineNum:null,viewMode:false,$beginRow:null,$endRow:null},RB.FileAttachmentCommentBlock.prototype.defaults),serializedFields:["beginLineNum","endLineNum","viewMode"],parse:function(fields){fields.beginLineNum=parseInt(fields.beginLineNum,10);fields.endLineNum=parseInt(fields.endLineNum,10);return fields}});RB.TextBasedReviewable=RB.FileAttachmentReviewable.extend({defaults:_.defaults({viewMode:"source",hasRenderedView:false},RB.FileAttachmentReviewable.prototype.defaults),commentBlockModel:RB.TextCommentBlock,defaultCommentBlockFields:["viewMode"].concat(RB.FileAttachmentReviewable.prototype.defaultCommentBlockFields)});RB.DiffViewerPageModel=Backbone.Model.extend({defaults:{commentsHint:null,files:null,numDiffs:1,pagination:null,revision:null},parse:function(rsp){return{commentsHint:new RB.DiffCommentsHint(rsp.comments_hint,{parse:true}),files:new RB.DiffFileCollection(rsp.files,{parse:true}),numDiffs:rsp.num_diffs,pagination:new RB.Pagination(rsp.pagination,{parse:true}),revision:new RB.DiffRevision(rsp.revision,{parse:true})}},set:function(attrs,options){var toSet={numDiffs:attrs.numDiffs};if(this.attributes.commentsHint){this.attributes.commentsHint.set(attrs.commentsHint.attributes)}else{toSet.commentsHint=attrs.commentsHint}if(this.attributes.files){this.attributes.files.set(attrs.files.models);this.attributes.files.trigger("update")}else{toSet.files=attrs.files}if(this.attributes.pagination){this.attributes.pagination.set(attrs.pagination.attributes)}else{toSet.pagination=attrs.pagination}if(this.attributes.revision){this.attributes.revision.set(attrs.revision.attributes)}else{toSet.revision=attrs.revision}Backbone.Model.prototype.set.call(this,toSet,options)}});(function(){var UpdatesBubbleView=Backbone.View.extend({id:"updates-bubble",template:_.template(['<span id="updates-bubble-summary"><%- summary %></span>'," by ",'<a href="<%- user.url %>" id="updates-bubble-user">',"<%- user.fullname || user.username %>","</a>",'<span id="updates-bubble-buttons">',' <a href="#" class="update-page"><%- updatePageText %></a>'," | ",' <a href="#" class="ignore"><%- ignoreText %></a>'].join("")),events:{"click .update-page":"_onUpdatePageClicked","click .ignore":"_onIgnoreClicked"},render:function(){this.$el.html(this.template(_.defaults({updatePageText:gettext("Update Page"),ignoreText:gettext("Ignore")},this.options.updateInfo))).hide();return this},open:function(){this.$el.css("position","fixed").fadeIn()},close:function(){this.trigger("closed");this.$el.fadeOut(_.bind(this.remove,this))},_onUpdatePageClicked:function(e){e.preventDefault();e.stopPropagation();this.trigger("updatePage")},_onIgnoreClicked:function(e){e.preventDefault();e.stopPropagation();this.close()}});RB.ReviewablePageView=Backbone.View.extend({events:{"click #review-link":"_onEditReviewClicked","click #shipit-link":"_onShipItClicked"},initialize:function(){console.assert(this.options.reviewRequestData);console.assert(this.options.editorData);this.reviewRequest=new RB.ReviewRequest(this.options.reviewRequestData,{extraDraftAttrs:this.options.extraReviewRequestDraftData});this.pendingReview=this.reviewRequest.createReview();this.commentIssueManager=new RB.CommentIssueManager({reviewRequest:this.reviewRequest});this.reviewRequestEditor=new RB.ReviewRequestEditor(_.defaults({commentIssueManager:this.commentIssueManager,reviewRequest:this.reviewRequest},this.options.editorData));this.reviewRequestEditorView=new RB.ReviewRequestEditorView({el:$("#review_request"),model:this.reviewRequestEditor});this._updatesBubble=null;this._favIconURL=null;this._favIconNotifyURL=null;window.gReviewRequest=this.reviewRequest},render:function(){var $favicon=$("head").find('link[rel="shortcut icon"]');this._favIconURL=$favicon.attr("href");this._favIconNotifyURL=STATIC_URLS["rb/images/favicon_notify.ico"];this.draftReviewBanner=RB.DraftReviewBannerView.create({el:$("#review-banner"),model:this.pendingReview,reviewRequestEditor:this.reviewRequestEditor});this.listenTo(this.pendingReview,"destroy published",function(){this.draftReviewBanner.hideAndReload()});this.reviewRequestEditorView.render();this._registerForUpdates();return this},_registerForUpdates:function(){this.listenTo(this.reviewRequest,"updated",function(info){this._updateFavIcon(this._favIconNotifyURL);if(this._updatesBubble){this._updatesBubble.remove()}this._updatesBubble=new UpdatesBubbleView({updateInfo:info,reviewRequest:this.reviewRequest});this.listenTo(this._updatesBubble,"closed",function(){this._updateFavIcon(this._favIconURL)});this.listenTo(this._updatesBubble,"updatePage",function(){window.location=this.reviewRequest.get("reviewURL")});this._updatesBubble.render().$el.appendTo(this.$el);this._updatesBubble.open()});this.reviewRequest.beginCheckForUpdates(this.options.checkUpdatesType,this.options.lastActivityTimestamp)},_updateFavIcon:function(url){$("head").find('link[rel="shortcut icon"]').remove().end().append($("<link/>").attr({href:url,rel:"shortcut icon",type:"image/x-icon"}))},_onEditReviewClicked:function(){RB.ReviewDialogView.create({review:this.pendingReview,reviewRequestEditor:this.reviewRequestEditor});return false},_onShipItClicked:function(){if(confirm(gettext("Are you sure you want to post this review?"))){this.pendingReview.ready({ready:function(){this.pendingReview.set({shipIt:true,bodyTop:gettext("Ship It!")});this.pendingReview.publish()}},this)}return false}})})();RB.ReviewRequestPageView=RB.ReviewablePageView.extend({initialize:function(){RB.ReviewablePageView.prototype.initialize.call(this);this._reviewBoxListView=new RB.ReviewBoxListView({el:$("#content"),pageEditState:this.reviewRequestEditor,reviewRequestEditorView:this.reviewRequestEditorView,reviewRequest:this.reviewRequest});if(this.reviewRequestEditorView.issueSummaryTableView){this.reviewRequestEditorView.issueSummaryTableView.on("issueClicked",_.bind(this._expandIssueBox,this))}},render:function(){RB.ReviewablePageView.prototype.render.call(this);this._reviewBoxListView.render();return this},queueLoadDiff:function(commentID,key){this._reviewBoxListView.diffFragmentQueue.queueLoad(commentID,key)},openCommentEditor:function(contextType,contextID){this._reviewBoxListView.openCommentEditor(contextType,contextID)},_expandIssueBox:function(commentAttributes){var typeToPrefixMap={diff:"",file:"f",screenshot:"s"},selector="#"+typeToPrefixMap[commentAttributes.type]+"comment"+commentAttributes.id;_.each(this._reviewBoxListView._boxes,function(box){if(box.$el.find(selector).length){box.expand()}})}});RB.DiffViewerPageView=RB.ReviewablePageView.extend({SCROLL_BACKWARD:-1,SCROLL_FORWARD:1,ANCHOR_COMMENT:1,ANCHOR_FILE:2,ANCHOR_CHUNK:4,DIFF_SCROLLDOWN_AMOUNT:15,keyBindings:{"aAKP<m":"_selectPreviousFile","fFJN>":"_selectNextFile","sSkp,":"_selectPreviousDiff","dDjn.":"_selectNextDiff","[x":"_selectPreviousComment","]c":"_selectNextComment","\r":"_recenterSelected",rR:"_createComment"},events:_.extend({"click .toggle-whitespace-only-chunks":"_toggleWhitespaceOnlyChunks","click .toggle-show-whitespace":"_toggleShowExtraWhitespace"},RB.ReviewablePageView.prototype.events),initialize:function(){var revisionInfo=this.model.get("revision"),curRevision=revisionInfo.get("revision"),curInterdiffRevision=revisionInfo.get("interdiffRevision"),url=document.location.toString(),hash=document.location.hash||"",search=document.location.search||"",revisionRange;_super(this).initialize.call(this);this._selectedAnchorIndex=-1;this._$anchors=$();this._$controls=null;this._diffReviewableViews=[];this._diffFileIndexView=null;this._highlightedChunk=null;this.listenTo(this.model.get("files"),"update",this._setFiles);this._startAtAnchorName=url.match("#")?url.split("#")[1]:null;this.router=new Backbone.Router({routes:{":revision/":"revision",":revision/?page=:page":"revision"}});this.listenTo(this.router,"route:revision",function(revision,page){var parts;if(page===undefined){page=1}else{page=parseInt(page,10)}if(revision.indexOf("-")===-1){this._loadRevision(0,parseInt(revision,10),page)}else{parts=revision.split("-",2);this._loadRevision(parseInt(parts[0],10),parseInt(parts[1],10),page)}});Backbone.history.start({pushState:true,hashChange:false,root:this.options.reviewRequestData.reviewURL+"diff/",silent:true});revisionRange=curRevision;if(curInterdiffRevision){revisionRange+="-"+curInterdiffRevision}this.router.navigate(revisionRange+"/"+search+hash,{replace:true,trigger:false})},remove:function(){_super(this).remove.call(this);this._diffFileIndexView.remove()},render:function(){var $reviewRequest,numDiffs=this.model.get("numDiffs"),revisionModel=this.model.get("revision");_super(this).render.call(this);$reviewRequest=this.$(".review-request");this._$controls=$reviewRequest.find("ul.controls");this._diffFileIndexView=new RB.DiffFileIndexView({el:$("#diff_index"),collection:this.model.get("files")});this._diffFileIndexView.render();this.listenTo(this._diffFileIndexView,"anchorClicked",this.selectAnchorByName);this._diffRevisionLabelView=new RB.DiffRevisionLabelView({el:$("#diff_revision_label"),model:revisionModel});this._diffRevisionLabelView.render();this.listenTo(this._diffRevisionLabelView,"revisionSelected",this._onRevisionSelected);if(numDiffs>1){this._diffRevisionSelectorView=new RB.DiffRevisionSelectorView({el:$("#diff_revision_selector"),model:revisionModel,numDiffs:numDiffs});this._diffRevisionSelectorView.render();this.listenTo(this._diffRevisionSelectorView,"revisionSelected",this._onRevisionSelected)}this._commentsHintModel=this.options.commentsHint;this._commentsHintView=new RB.DiffCommentsHintView({el:$("#diff_comments_hint"),model:this.model.get("commentsHint")});this._commentsHintView.render();this.listenTo(this._commentsHintView,"revisionSelected",this._onRevisionSelected);this._paginationView1=new RB.PaginationView({el:$("#pagination1"),model:this.model.get("pagination")});this._paginationView1.render();this.listenTo(this._paginationView1,"pageSelected",_.partial(this._onPageSelected,false));this._paginationView2=new RB.PaginationView({el:$("#pagination2"),model:this.model.get("pagination")});this._paginationView2.render();this.listenTo(this._paginationView2,"pageSelected",_.partial(this._onPageSelected,true));$("#diffs").bindClass(RB.UserSession.instance,"diffsShowExtraWhitespace","ewhl");this._setFiles();$("#diff-details").removeClass("loading");return this},_fileEntryTemplate:_.template(['<div class="diff-container">',' <div class="diff-box">','  <table class="sidebyside loading <% if (newfile) { %>newfile<% } %>"','         id="file_container_<%- id %>">',"   <thead>",'    <tr class="filename-row">',"     <th><%- depotFilename %></th>","    </tr>","   </thead>","   <tbody>","    <tr><td><pre>&nbsp;</pre></td></tr>","   </tbody>","  </table>"," </div>","</div>"].join("")),_setFiles:function(){var files=this.model.get("files"),$diffs=$("#diffs").empty();this._highlightedChunk=null;files.each(function(file){var filediff=file.get("filediff"),interfilediff=file.get("interfilediff"),interdiffRevision=null;$diffs.append(this._fileEntryTemplate(file.attributes));if(interfilediff){interdiffRevision=interfilediff.revision}else if(file.get("forceInterdiff")){interdiffRevision=file.get("forceInterdiffRevision")}this.queueLoadDiff(filediff.id,filediff.revision,interfilediff?interfilediff.id:null,interdiffRevision,file.get("index"),file.get("commentCounts"))},this);$.funcQueue("diff_files").start()},queueLoadDiff:function(fileDiffID,fileDiffRevision,interFileDiffID,interdiffRevision,fileIndex,serializedCommentBlocks){var diffReviewable=new RB.DiffReviewable({reviewRequest:this.reviewRequest,fileIndex:fileIndex,fileDiffID:fileDiffID,interFileDiffID:interFileDiffID,revision:fileDiffRevision,interdiffRevision:interdiffRevision,serializedCommentBlocks:serializedCommentBlocks});$.funcQueue("diff_files").add(function(){if($("#file"+fileDiffID).length===1){this._renderFileDiff(diffReviewable)}else{diffReviewable.getRenderedDiff({complete:function(xhr){$("#file_container_"+fileDiffID).replaceWith(xhr.responseText);this._renderFileDiff(diffReviewable)}},this)}},this)},_renderFileDiff:function(diffReviewable){var $el=$("#file"+diffReviewable.get("fileDiffID")),diffReviewableView,$anchor;if($el.length===0){$.funcQueue("diff_files").next();return}diffReviewableView=new RB.DiffReviewableView({el:$el,model:diffReviewable});this._diffFileIndexView.addDiff(this._diffReviewableViews.length,diffReviewableView);this._diffReviewableViews.push(diffReviewableView);diffReviewableView.render();this.listenTo(diffReviewableView,"fileClicked",function(){this.selectAnchorByName(diffReviewable.get("fileIndex"))});this.listenTo(diffReviewableView,"chunkClicked",function(name){this.selectAnchorByName(name,false)});this.listenTo(diffReviewableView,"moveFlagClicked",function(line){this.selectAnchor(this.$("a[target="+line+"]"))});this._updateAnchors(diffReviewableView.$el);this.listenTo(diffReviewableView,"chunkExpansionChanged",function(){this._highlightAnchor($(this._$anchors[this._selectedAnchorIndex]))});if(this._startAtAnchorName){$anchor=$('a[name="'+this._startAtAnchorName+'"]');if($anchor.length!==0){this.selectAnchor($anchor);this._startAtAnchorName=null}}$.funcQueue("diff_files").next()},selectAnchor:function($anchor,scroll){var scrollAmount,i,url;if(!$anchor||$anchor.length===0||$anchor.parent().is(":hidden")){return false}if(scroll!==false){url=[this._getCurrentURL(),location.search,"#",$anchor.attr("name")].join("");this.router.navigate(url,{replace:true,trigger:false});scrollAmount=this.DIFF_SCROLLDOWN_AMOUNT;if(RB.DraftReviewBannerView.instance){scrollAmount+=RB.DraftReviewBannerView.instance.getHeight()}$(window).scrollTop($anchor.offset().top-scrollAmount)}this._highlightAnchor($anchor);for(i=0;i<this._$anchors.length;i++){if(this._$anchors[i]===$anchor[0]){this._selectedAnchorIndex=i;break}}return true},selectAnchorByName:function(name,scroll){return this.selectAnchor($('a[name="'+name+'"]'),scroll)},_highlightAnchor:function($anchor){this._highlightedChunk=$anchor.parents("tbody:first, thead:first");RB.ChunkHighlighterView.highlight($anchor.parents("tbody:first, thead:first"))},_updateAnchors:function($table){this._$anchors=this._$anchors.add($table.find("a[name]"));if(this._selectedAnchorIndex===-1&&this._$anchors.length>0){this._selectedAnchorIndex=0;this._highlightAnchor($(this._$anchors[this._selectedAnchorIndex]))}},_getNextAnchor:function(dir,anchorTypes){var $anchor,i;for(i=this._selectedAnchorIndex+dir;i>=0&&i<this._$anchors.length;i+=dir){
$anchor=$(this._$anchors[i]);if($anchor.parents("tr").hasClass("dimmed")){continue}if(anchorTypes&this.ANCHOR_COMMENT&&$anchor.hasClass("commentflag-anchor")||anchorTypes&this.ANCHOR_FILE&&$anchor.hasClass("file-anchor")||anchorTypes&this.ANCHOR_CHUNK&&$anchor.hasClass("chunk-anchor")){return $anchor}}return null},_selectPreviousFile:function(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_FILE))},_selectNextFile:function(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_FILE))},_selectPreviousDiff:function(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_CHUNK|this.ANCHOR_FILE))},_selectNextDiff:function(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_CHUNK|this.ANCHOR_FILE))},_selectPreviousComment:function(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_COMMENT))},_selectNextComment:function(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_COMMENT))},_recenterSelected:function(){this.selectAnchor($(this._$anchors[this._selectedAnchorIndex]))},_createComment:function(){var chunkID=this._highlightedChunk[0].id,chunkElement=document.getElementById(chunkID),lineElements,beginLineNum,beginNode,endLineNum,endNode;if(chunkElement){lineElements=chunkElement.getElementsByTagName("tr");beginLineNum=lineElements[0].getAttribute("line");beginNode=lineElements[0].cells[2];endLineNum=lineElements[lineElements.length-1].getAttribute("line");endNode=lineElements[lineElements.length-1].cells[2];_.each(this._diffReviewableViews,function(diffReviewableView){if($.contains(diffReviewableView.el,beginNode)){diffReviewableView.createComment(beginLineNum,endLineNum,beginNode,endNode)}})}},_toggleWhitespaceOnlyChunks:function(){_.each(this._diffReviewableViews,function(diffReviewableView){diffReviewableView.toggleWhitespaceOnlyChunks()});this._$controls.find(".ws").toggle();return false},_toggleShowExtraWhitespace:function(){this._$controls.find(".ew").toggle();RB.UserSession.instance.toggleAttr("diffsShowExtraWhitespace");return false},_onRevisionSelected:function(base,tip){if(base===0){this.router.navigate(tip+"/",{trigger:true})}else{this.router.navigate(base+"-"+tip+"/",{trigger:true})}},_getCurrentURL:function(){var revision=this.model.get("revision"),url=revision.get("revision");if(revision.get("interdiffRevision")!==null){url+="-"+revision.get("interdiffRevision")}return url},_onPageSelected:function(scroll,page){var url=this._getCurrentURL();if(scroll){this.selectAnchorByName("index_header",true)}url+="/?page="+page;this.router.navigate(url,{trigger:true})},_loadRevision:function(base,tip,page){var reviewRequestURL=_.result(this.reviewRequest,"url"),contextURL=reviewRequestURL+"diff-context/",$downloadLink=$("#download-diff");if(base===0){contextURL+="?revision="+tip;$downloadLink.show()}else{contextURL+="?revision="+base+"&interdiff-revision="+tip;$downloadLink.hide()}if(page!==1){contextURL+="&page="+page}$.ajax(contextURL).done(_.bind(function(rsp){_.each(this._diffReviewableViews,function(diffReviewableView){diffReviewableView.remove()});this._diffReviewableViews=[];this.model.set(this.model.parse(rsp.diff_context))},this))}});_.extend(RB.DiffViewerPageView.prototype,RB.KeyBindingsMixin);(function(){RB.formatText=function($el,options){options=options||{};if(options.richText){if(options.newText!==undefined){$el.html(options.newText)}$el.addClass("rich-text").find("a").attr("target","_blank");RB.LinkifyUtils.linkifyChildren($el[0],options.bugTrackerURL)}else if(options.newText!==undefined){$el.html(RB.LinkifyUtils.linkifyText(options.newText||"",options.bugTrackerURL,options.isHTMLEncoded)).removeClass("rich-text")}else if($el!==undefined&&$el.length!==0){RB.LinkifyUtils.linkifyChildren($el[0],options.bugTrackerURL)}}})();RB.AbstractCommentBlockView=Backbone.View.extend({events:{click:"_onClicked"},tooltipSides:"lrbt",dispose:function(){this.remove();this._$tooltip.remove()},render:function(){this._$tooltip=$.tooltip(this.$el,{side:this.tooltipSides}).addClass("comments");this.renderContent();this.model.on("change:draftComment",this._onDraftCommentChanged,this);this._onDraftCommentChanged();this._updateTooltip();return this},positionCommentDlg:function(commentDlg){commentDlg.positionBeside(this.$el,{side:"r",fitOnScreen:true})},positionNotifyBubble:function($bubble){$bubble.move(Math.round((this.$el.width()-$bubble.width())/2),Math.round((this.$el.height()-$bubble.height())/2))},notify:function(text,cb,context){var $bubble=$("<div/>").addClass("bubble").appendTo(this.$el).text(text);$bubble.css("opacity",0);this.positionNotifyBubble($bubble);$bubble.animate({top:"-=10px",opacity:.8},350,"swing").delay(1200).animate({top:"+=10px",opacity:0},350,"swing",function(){$bubble.remove();if(_.isFunction(cb)){cb.call(context)}})},_updateTooltip:function(){var list=$("<ul/>"),draftComment=this.model.get("draftComment");function addEntry(text){return $("<li>").text(text.truncate()).appendTo(list)}if(draftComment){addEntry(draftComment.get("text")).addClass("draft")}_.each(this.model.get("serializedComments"),function(comment){addEntry(comment.text)});this._$tooltip.empty().append(list)},_onDraftCommentChanged:function(){var self=this,$el=this.$el,comment=this.model.get("draftComment");if(!comment){$el.removeClass("draft");return}comment.on("change:text",this._updateTooltip,this);comment.on("destroy",function(){this.notify(gettext("Comment Deleted"),function(){if(this.model.isEmpty()){$el.fadeOut(350,function(){self.dispose()})}else{$el.removeClass("draft");this._updateTooltip()}},this)},this);comment.on("saved",function(){this._updateTooltip();this.notify(gettext("Comment Saved"));RB.DraftReviewBannerView.instance.show()},this);$el.addClass("draft")},_onClicked:function(){this.trigger("clicked")}});RB.AbstractReviewableView=Backbone.View.extend({commentBlockView:null,commentsListName:null,initialize:function(options){options=options||{};console.assert(this.commentBlockView,"commentBlockView must be defined by the subclass");console.assert(this.commentsListName,"commentsListName must be defined by the subclass");this.commentDlg=null;this._activeCommentBlock=null;this.renderedInline=options.renderedInline||false},render:function(){this.renderContent();this.model.commentBlocks.each(this._addCommentBlockView,this);this.model.commentBlocks.on("add",this._addCommentBlockView,this);return this},renderContent:function(){},createAndEditCommentBlock:function(opts){var defaultCommentBlockFields=_.result(this.model,"defaultCommentBlockFields");if(defaultCommentBlockFields.length===0&&this.model.reviewableIDField){console.log("Deprecation notice: Reviewable subclass is missing "+"defaultCommentBlockFields. Rename reviewableIDField "+"to defaultCommentBlockFields, and make it a list.");defaultCommentBlockFields=[this.model.reviewableIDField]}this.once("commentBlockViewAdded",function(commentBlockView){this.showCommentDlg(commentBlockView)},this);_.extend(opts,_.pick(this.model.attributes,defaultCommentBlockFields));this.model.createCommentBlock(opts)},showCommentDlg:function(commentBlockView){var commentBlock=commentBlockView.model;commentBlock.ensureDraftComment();if(this._activeCommentBlock===commentBlock){return}this.stopListening(this.commentDlg,"closed");this.commentDlg=RB.CommentDialogView.create({comment:commentBlock.get("draftComment"),publishedComments:commentBlock.get("serializedComments"),publishedCommentsType:this.commentsListName,position:function(dlg){commentBlockView.positionCommentDlg(dlg)}});this._activeCommentBlock=commentBlock;this.listenTo(this.commentDlg,"closed",function(){this.commentDlg=null;this._activeCommentBlock=null})},_addCommentBlockView:function(commentBlock){var commentBlockView=new this.commentBlockView({model:commentBlock});commentBlockView.on("clicked",function(){this.showCommentDlg(commentBlockView)},this);commentBlockView.render();this.trigger("commentBlockViewAdded",commentBlockView)}});RB.CollapsableBoxView=Backbone.View.extend({events:{"click .collapse-button":"_onToggleCollapseClicked"},render:function(){this._$box=this.$(".box");this._$expandCollapseButton=this.$(".collapse-button .rb-icon");if(this._$box.hasClass("collapsed")){this._$expandCollapseButton.addClass("rb-icon-expand-review")}else{this._$expandCollapseButton.addClass("rb-icon-collapse-review")}return this},expand:function(){this._$box.removeClass("collapsed");this._$expandCollapseButton.removeClass("rb-icon-expand-review").addClass("rb-icon-collapse-review")},collapse:function(){this._$box.addClass("collapsed");this._$expandCollapseButton.removeClass("rb-icon-collapse-review").addClass("rb-icon-expand-review")},_onToggleCollapseClicked:function(){if(this._$box.hasClass("collapsed")){this.expand()}else{this.collapse()}}});var CommentsListView=Backbone.View.extend({itemTemplate:_.template(['<li class="<%= itemClass %>">',"<h2>","<%- comment.user.name %>",'<span class="actions">','<a href="<%= comment.url %>"><%- viewText %></a>','<a href="<%= reviewRequestURL %>',"?reply_id=<%= comment.comment_id %>",'&reply_type=<%= replyType %>">Reply</a>',"</span>","</h2>","<pre><%- comment.text %></pre>"].join("")),setComments:function(comments,replyType){var reviewRequestURL=this.options.reviewRequestURL,commentIssueManager=this.options.commentIssueManager,interactive=this.options.issuesInteractive,odd=true,$items=$();if(comments.length===0){return}_.each(comments,function(serializedComment){var commentID=serializedComment.comment_id,$item=$(this.itemTemplate({comment:serializedComment,itemClass:odd?"odd":"even",reviewRequestURL:reviewRequestURL,replyType:replyType,viewText:gettext("View")})),commentIssueBar;if(serializedComment.issue_opened){commentIssueBar=new RB.CommentIssueBarView({reviewID:serializedComment.review_id,commentID:commentID,commentType:replyType,issueStatus:serializedComment.issue_status,interactive:interactive,commentIssueManager:commentIssueManager});commentIssueBar.render().$el.appendTo($item);commentIssueManager.on("issueStatusUpdated",function(comment){if(comment.id===commentID){serializedComment.issue_status=comment.get("issueStatus")}})}$items=$items.add($item);odd=!odd},this);this.$el.empty().append($items)}});RB.CommentDialogView=Backbone.View.extend({DIALOG_TOTAL_HEIGHT:300,DIALOG_NON_EDITABLE_HEIGHT:120,SLIDE_DISTANCE:10,COMMENTS_BOX_WIDTH:280,FORM_BOX_WIDTH:430,className:"comment-dlg",template:_.template(['<div class="other-comments">',' <h1 class="title"><%- otherReviewsText %></h1>'," <ul></ul>","</div>",'<form method="post">',' <h1 class="comment-dlg-header">','  <span class="title"><%- yourCommentText %></span>',"<% if (authenticated && !hasDraft) { %>",'  <a class="markdown-info" href="<%- markdownDocsURL %>"','     target="_blank"><%- markdownText %></a>',"<% } %>"," </h1>","<% if (!authenticated) { %>",' <p class="login-text">',"  <%= loginText %>"," </p>","<% } else if (hasDraft) { %>",' <p class="draft-warning"><%= draftWarning %></p>',"<% } %>",' <div class="comment-dlg-body">','  <div class="comment-text-field"></div>','  <ul class="comment-dlg-options">','   <li class="comment-issue-options">','    <input type="checkbox" id="comment_issue" />','    <label for="comment_issue" accesskey="i"><%= openAnIssueText %></label>',"   </li>",'   <li class="comment-markdown-options">','    <input type="checkbox" id="enable_markdown" />','    <label for="enable_markdown" accesskey="m"><%= enableMarkdownText %></label>',"   </li>","  </ul>"," </div>",' <div class="comment-dlg-footer">','  <div class="status"></div>','  <div class="buttons">','   <input type="button" class="save" value="<%- saveButton %>" ','          disabled="true" />','   <input type="button" class="cancel" value="<%- cancelButton %>" />','   <input type="button" class="delete" value="<%- deleteButton %>" ','          disabled="true" />','   <input type="button" class="close" value="<%- closeButton %>" />',"  </div>"," </div>","</form>"].join("")),events:{"click .buttons .cancel":"_onCancelClicked","click .buttons .close":"_onCancelClicked","click .buttons .delete":"_onDeleteClicked","click .buttons .save":"save","keydown .comment-text-field":"_onTextKeyDown"},initialize:function(){},render:function(){var userSession=RB.UserSession.instance,reviewRequest=this.model.get("reviewRequest"),reviewRequestEditor=this.model.get("reviewRequestEditor");this.options.animate=this.options.animate!==false;this.$el.hide().html(this.template({authenticated:userSession.get("authenticated"),hasDraft:reviewRequest.get("hasDraft"),markdownDocsURL:MANUAL_URL+"users/markdown/",markdownText:gettext("Markdown"),otherReviewsText:gettext("Other reviews"),yourCommentText:gettext("Your comment"),loginText:interpolate(gettext('You must <a href="%s">log in</a> to post a comment.'),[userSession.get("loginURL")]),draftWarning:interpolate(gettext('The review request\'s current <a href="%s">draft</a> needs to be published before you can comment.'),[reviewRequest.get("reviewURL")]),openAnIssueText:gettext("Open an <u>I</u>ssue"),enableMarkdownText:gettext("Enable <u>M</u>arkdown"),saveButton:gettext("Save"),cancelButton:gettext("Cancel"),deleteButton:gettext("Delete"),closeButton:gettext("Close")}));this._$commentsPane=this.$(".other-comments");this._$draftForm=this.$("form");this._$body=this._$draftForm.children(".comment-dlg-body");this._$header=this._$draftForm.children(".comment-dlg-header");this._$footer=this._$draftForm.children(".comment-dlg-footer");this._$statusField=this._$footer.children(".status");this._$commentOptions=this._$body.children(".comment-dlg-options");this._$issueOptions=this._$commentOptions.children(".comment-issue-options").bindVisibility(this.model,"canEdit");this._$markdownOptions=this._$commentOptions.children(".comment-markdown-options").bindVisibility(this.model,"canEdit");this._$issueField=this._$issueOptions.find("input").bindProperty("checked",this.model,"openIssue").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this._$enableMarkdownField=this._$markdownOptions.find("input").bindProperty("checked",this.model,"richText").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this.$buttons=this._$footer.find(".buttons");this.$saveButton=this.$buttons.find("input.save").bindVisibility(this.model,"canEdit").bindProperty("disabled",this.model,"canSave",{elementToModel:false,inverse:true});this.$cancelButton=this.$buttons.find("input.cancel").bindVisibility(this.model,"canEdit");this.$deleteButton=this.$buttons.find("input.delete").bindVisibility(this.model,"canDelete").bindProperty("disabled",this.model,"canDelete",{elementToModel:false,inverse:true});this.$closeButton=this.$buttons.find("input.close").bindVisibility(this.model,"canEdit",{inverse:true});this.commentsList=new CommentsListView({el:this._$commentsPane.find("ul"),reviewRequestURL:reviewRequest.get("reviewURL"),commentIssueManager:this.options.commentIssueManager,issuesInteractive:reviewRequestEditor.get("editable")});this._textEditor=new RB.TextEditorView({el:this._$draftForm.find(".comment-text-field"),autoSize:false,minHeight:0,text:this.model.get("text"),bindRichText:{model:this.model,attrName:"richText"}});this._textEditor.render();this._textEditor.show();this._textEditor.$el.keypress(_.bind(this._onTextKeyPress,this)).bindVisibility(this.model,"canEdit");this._textEditor.on("change",function(){this.model.set("text",this._textEditor.getText())},this);this._textEditor.bindRichTextCheckbox(this._$enableMarkdownField);this._textEditor.bindRichTextVisibility(this._$draftForm.find(".markdown-info"));this.listenTo(this.model,"change:text",function(){this._textEditor.setText(this.model.get("text"))});this.listenTo(this.model,"change:richText",this._handleResize);this.$el.css("position","absolute").mousedown(function(evt){evt.stopPropagation()}).proxyTouchEvents();if(!$.browser.msie||$.browser.version>=9){this.$el.resizable({handles:$.support.touch?"grip,se":"grip,n,e,s,w,se,sw,ne,nw",transparent:true,resize:_.bind(this._handleResize,this)})}this._$header.css("cursor","move");this.$el.draggable({handle:".comment-dlg-header"});this.model.on("change:dirty",function(){if(this.$el.is(":visible")){this._handleResize()}},this);this.model.on("change:statusText",function(model,text){if(text){this._$statusField.text(text).show()}else{this._$statusField.text("").hide()}},this);this.model.on("change:publishedComments",this._onPublishedCommentsChanged,this);this._onPublishedCommentsChanged();RB.CommentDialogHook.each(function(hook){var HookViewType=hook.get("viewType"),hookView=new HookViewType({commentDialog:this,commentEditor:this.model,el:this.el});hookView.render()},this);return this},save:function(){this.model.set("text",this._textEditor.getText());if(this.model.get("canSave")){this.model.save({error:function(model,xhr){alert(gettext("Error saving comment: ")+xhr.errorText)}},this);this.close()}},open:function(){function openDialog(){this.$el.scrollIntoView();this._textEditor.focus()}this.$el.css({top:parseInt(this.$el.css("top"),10)-this.SLIDE_DISTANCE,opacity:0}).show();this._handleResize();if(this.model.get("canEdit")){this.model.beginEdit()}if(this.options.animate){this.$el.animate({top:"+="+this.SLIDE_DISTANCE+"px",opacity:1},350,"swing",_.bind(openDialog,this))}else{openDialog.call(this)}},close:function(onClosed,context){function closeDialog(){this.model.close();this.$el.remove();this.trigger("closed");if(_.isFunction(onClosed)){onClosed.call(context)}}if(this.options.animate&&this.$el.is(":visible")){this.$el.animate({top:"-="+this.SLIDE_DISTANCE+"px",opacity:0},350,"swing",_.bind(closeDialog,this))}else{closeDialog.call(this)}},move:function(x,y){this.$el.move(x,y)},positionBeside:function($el,options){this.$el.positionToSide($el,options)},_onPublishedCommentsChanged:function(){var comments=this.model.get("publishedComments")||[],showComments=comments.length>0,width=this.FORM_BOX_WIDTH;this.commentsList.setComments(comments,this.model.get("publishedCommentsType"));this._$commentsPane.setVisible(showComments);if(showComments){width+=this.COMMENTS_BOX_WIDTH}this.$el.width(width).height(this.model.get("canEdit")?this.DIALOG_TOTAL_HEIGHT:this.DIALOG_NON_EDITABLE_HEIGHT)},_handleResize:function(){var $draftForm=this._$draftForm,$commentsPane=this._$commentsPane,$commentsList=this.commentsList.$el,$textField=this._textEditor.$el,width=this.$el.width(),height=this.$el.height(),commentsWidth=0;if($commentsPane.is(":visible")){$commentsPane.outerWidth(this.COMMENTS_BOX_WIDTH).outerHeight(height).move(0,0,"absolute");$commentsList.height($commentsPane.height()-$commentsList.position().top);commentsWidth=$commentsPane.outerWidth(true);width-=commentsWidth}$draftForm.outerWidth(width).outerHeight(height).move(commentsWidth,0,"absolute");this._textEditor.setSize(this._$body.width()-$textField.getExtents("b","lr"),$draftForm.height()-this._$header.outerHeight()-this._$commentOptions.outerHeight()-this._$footer.outerHeight()-$textField.getExtents("b","tb"))},_onCancelClicked:function(){this.model.cancel();this.close()},_onDeleteClicked:function(){if(this.model.get("canDelete")){this.model.deleteComment();this.close()}},_onTextKeyDown:function(e){e.stopPropagation();if(e.which===$.ui.keyCode.ESCAPE){this._onCancelClicked();return false}},_onTextKeyPress:function(e){e.stopPropagation();switch(e.which){case 10:case $.ui.keyCode.ENTER:if(e.ctrlKey){this.save();return false}break;case 73:case 105:if(e.altKey){this.model.set("openIssue",!this.model.get("openIssue"))}break;case 77:case 109:if(e.altKey){this.model.set("richText",!this.model.get("richText"))}break;default:break}}},{_instance:null,create:function(options){var instance=RB.CommentDialogView._instance,reviewRequestEditor=options.reviewRequestEditor||RB.PageManager.getPage().reviewRequestEditor,commentIssueManager=options.commentIssueManager||reviewRequestEditor.get("commentIssueManager"),beside,dlg,x,y;function showCommentDlg(){try{dlg.open()}catch(e){dlg.close();throw e}RB.CommentDialogView._instance=dlg}console.assert(options.comment,"A comment must be specified");options=options||{};dlg=new RB.CommentDialogView({animate:options.animate,commentIssueManager:commentIssueManager,model:new RB.CommentEditor({comment:options.comment,reviewRequest:reviewRequestEditor.get("reviewRequest"),reviewRequestEditor:reviewRequestEditor,publishedComments:options.publishedComments||undefined,publishedCommentsType:options.publishedCommentsType||undefined})});dlg.render().$el.css("z-index",999).appendTo(options.container||document.body);options.position=options.position||{};if(_.isFunction(options.position)){options.position(dlg)}else if(options.position.beside){beside=options.position.beside;dlg.positionBeside(beside.el,beside)}else{x=options.position.x;y=options.position.y;if(x===undefined){x=$(document).scrollLeft()+($(window).width()-dlg.$el.width())/2}if(y===undefined){y=$(document).scrollTop()+($(window).height()-dlg.$el.height())/2}dlg.move(x,y)}dlg.on("closed",function(){RB.CommentDialogView._instance=null});if(instance){instance.on("closed",showCommentDlg);instance.close()}else{showCommentDlg()}return dlg}});RB.CommentIssueBarView=Backbone.View.extend({events:{"click .reopen":"_onReopenClicked","click .resolve":"_onResolveClicked","click .drop":"_onDropClicked"},STATUS_OPEN:"open",STATUS_FIXED:"resolved",STATUS_DROPPED:"dropped",statusInfo:{open:{visibleButtons:[".drop",".resolve"],text:gettext("An issue was opened.")},resolved:{visibleButtons:[".reopen"],text:gettext("The issue has been resolved.")},dropped:{visibleButtons:[".reopen"],text:gettext("The issue has been dropped.")}},template:_.template(['<div class="issue-state">',' <div class="issue-container">','  <span class="rb-icon"></span>','  <span class="issue-message"></span>',"<% if (interactive) { %>",'  <div class="buttons">','   <input type="button" class="issue-button resolve" ','          value="<%- fixedLabel %>" />','   <input type="button" class="issue-button drop" ','          value="<%- dropLabel %>" />','   <input type="button" class="issue-button reopen" ','          value="<%- reopenLabel %>" />',"  </div>"," </div>","<% } %>","</div>"].join("")),initialize:function(){this._manager=this.options.commentIssueManager||RB.PageManager.getPage().reviewRequestEditor.get("commentIssueManager");this._issueStatus=this.options.issueStatus;this._$buttons=null;this._$state=null;this._$icon=null;this._$message=null},render:function(){if(this.$el.children().length===0){this.$el.append(this.template({interactive:this.options.interactive,fixedLabel:gettext("Fixed"),dropLabel:gettext("Drop"),reopenLabel:gettext("Re-open")}))}this._$buttons=this.$(".issue-button");this._$state=this.$(".issue-state");this._$icon=this.$(".rb-icon");this._$message=this.$(".issue-message");this._manager.on("issueStatusUpdated",this._onIssueStatusUpdated,this);this._showStatus(this._issueStatus);return this},_setStatus:function(issueStatus){this._$buttons.prop("disabled",true);this._manager.setCommentState(this.options.reviewID,this.options.commentID,this.options.commentType,issueStatus)},_showStatus:function(issueStatus){var statusInfo=this.statusInfo[issueStatus],prevStatus=this._issueStatus;this._issueStatus=issueStatus;this._$state.removeClass(prevStatus).addClass(issueStatus);this._$icon.removeClass("rb-icon-issue-"+prevStatus).addClass("rb-icon-issue-"+issueStatus);this._$buttons.hide();this._$message.text(statusInfo.text);if(this.options.interactive){this._$buttons.filter(statusInfo.visibleButtons.join(",")).show();this._$buttons.prop("disabled",false)}this.trigger("statusChanged",issueStatus)},_onReopenClicked:function(){this._setStatus(this.STATUS_OPEN)},_onResolveClicked:function(){this._setStatus(this.STATUS_FIXED)},_onDropClicked:function(){this._setStatus(this.STATUS_DROPPED)},_onIssueStatusUpdated:function(comment){if(comment.id===this.options.commentID){this._showStatus(comment.get("issueStatus"))}}});RB.DiffFragmentQueueView=Backbone.View.extend({initialize:function(){this._queue={}},queueLoad:function(comment_id,key){var queue=this._queue;if(!queue[key]){queue[key]=[]}queue[key].push(comment_id)},loadFragments:function(){var queueName=this.options.queueName,urlPrefix,urlSuffix;if(!this._queue){return}urlPrefix=this.options.reviewRequestPath+"fragments/diff-comments/";urlSuffix="/?queue="+queueName+"&container_prefix="+this.options.containerPrefix+"&"+TEMPLATE_SERIAL;_.each(this._queue,function(comments){var url=urlPrefix+comments.join(",")+urlSuffix;$.funcQueue(queueName).add(_.bind(function(){this._addScript(url)},this))},this);this._queue={};$.funcQueue(queueName).start()},_addScript:function(url){var e=document.createElement("script");e.type="text/javascript";e.src=url;document.body.appendChild(e)}});var DnDDropOverlayView=Backbone.View.extend({className:"dnd-overlay",events:{dragleave:"_onDragLeave",drop:"_onDrop",dragover:"_onDragOver",mouseenter:"_onMouseEnter"},render:function(){var height=$(window).height();this.$el.width($(window).width()).height(height).css("line-height",height+"px").text(gettext("Drop to Upload"));return this},close:function(){this.$el.fadeOut(_.bind(function(){this.trigger("closed");this.remove()},this))},_onDrop:function(event){var dt=event.originalEvent.dataTransfer,files=dt&&dt.files;event.stopPropagation();event.preventDefault();if(files){this.trigger("filesDropped",files)}this.close()},_onDragOver:function(event){var dt=event.originalEvent.dataTransfer;if(dt){dt.dropEffect="copy"}return false},_onDragLeave:function(event){var dt=event.originalEvent.dataTransfer;if(dt){dt.dropEffect="none"}this.close();return false},_onMouseEnter:function(){this.close();return false}});RB.DnDUploader=Backbone.View.extend({initialize:function(){this._dropOverlay=null;$(document.body).on("dragenter",_.bind(this._onDragEnter,this))},_onDragEnter:function(event){if(!this._dropOverlay&&_.indexOf(event.originalEvent.dataTransfer.types,"Files")!==-1){this._dropOverlay=new DnDDropOverlayView;this._dropOverlay.render().$el.appendTo(document.body);this._dropOverlay.on("filesDropped",function(files){_.each(files,this._uploadFile,this)},this);this._dropOverlay.on("closed",function(){this._dropOverlay=null},this)}},_uploadFile:function(file){var editor=this.options.reviewRequestEditor,fileAttachment=editor.createFileAttachment();fileAttachment.set("file",file);fileAttachment.save()}});RB.DraftReviewBannerView=Backbone.View.extend({events:{"click #review-banner-edit":"_onEditReviewClicked","click #review-banner-publish":"_onPublishClicked","click #review-banner-discard":"_onDiscardClicked"},getHeight:function(){return this._$banner.outerHeight()},render:function(){var model=this.model;this._$buttons=this.$("input");this._$banner=this.$(".banner");model.on("saving destroying",function(){this._$buttons.prop("disabled",true)},this);model.on("saved destroyed",function(){this._$buttons.prop("disabled",false)},this);model.on("publishError",function(errorText){alert(errorText)});return this},show:function(){if(this.$el.is(":hidden")){this.$el.slideDown();this._$banner.hide().slideDown()}},hide:function(onDone,context){this.$el.slideUp();this._$banner.slideUp();if(_.isFunction(onDone)){this.$el.queue(_.bind(onDone,context))}},hideAndReload:function(){this.hide(function(){_.defer(_.bind(function(){window.location=this.model.get("parentObject").get("reviewURL")},this))},this)},_onEditReviewClicked:function(){RB.ReviewDialogView.create({review:this.model,reviewRequestEditor:this.options.reviewRequestEditor});return false},_onPublishClicked:function(){this.model.publish();return false},_onDiscardClicked:function(){var model=this.model;$("<p/>").text(gettext("If you discard this review, all related comments will be permanently deleted.")).modalBox({title:gettext("Are you sure you want to discard this review?"),buttons:[$('<input type="button" value="'+gettext("Cancel")+'"/>'),$('<input type="button" value="'+gettext("Discard")+'"/>').click(function(){model.destroy()})]});return false}},{instance:null,create:function(options){if(!this.instance){this.instance=new RB.DraftReviewBannerView(options);this.instance.render()}return this.instance}});RB.FileAttachmentReviewableView=RB.AbstractReviewableView.extend({commentsListName:"file_attachment_comments"});RB.FileAttachmentThumbnail=Backbone.View.extend({className:"file-container",events:{"click .delete":"_onDeleteClicked","click .file-add-comment a":"_onAddCommentClicked"},template:_.template(['<div class="file">',' <ul class="actions" />',' <div class="file-header">','  <a class="download">','   <img class="icon" />','   <span class="filename"><%- filename %></span>',"  </a>"," </div>",' <div class="file-thumbnail-container" />',' <div class="file-caption-container">','  <div class="file-caption can-edit">','<a href="<%- downloadURL %>"','   class="edit <% if (!caption) { %>empty-caption<% } %>">',"<% if (caption) { %><%- caption %><% } else { %><%- noCaptionText %><% } %>","</a>","</div>"," </div>","</div>"].join("")),actionsTemplate:_.template(["<% if (loaded) { %>","<%   if (reviewURL) { %>",' <li class="file-review"><a href="<%- reviewURL %>"><%- reviewText %></a></li>',"<%   } else { %>",' <li class="file-add-comment"><a href="#"><%- addCommentText %></a></li>',"<%   } %>",' <li class="delete">','  <a href="#" alt="<%- deleteFileText %>"','     title="<%- deleteFileText %>">','   <span class="ui-icon ui-icon-trash"></span>',"  </a>"," </li>","<% } %>"].join("")),thumbnailContainerTemplate:_.template(["<% if (!loaded) { %>",' <img class="file-thumbnail spinner" width="16" height="16" ','src="<%- spinnerURL %>" />',"<% } else { %>","<%   if (reviewURL) { %>",' <a href="<%- reviewURL %>" class="file-thumbnail-overlay"','    alt="<%- reviewAltText %>" title="<%- reviewAltText %>"> </a>',"<%   } %>","<%=  thumbnailHTML %>","<% } %>"].join("")),initialize:function(options){this.options=options;this._draftComment=null;this._comments=[];this._commentsProcessed=false},render:function(){var self=this;if(this.options.renderThumbnail){this._renderContents()}this._$captionContainer=this.$(".file-caption");this._$caption=this._$captionContainer.find("a.edit");this._$addCommentButton=this.$(".file-add-comment a");this.listenTo(this.model,"destroy",function(){this.$el.fadeOut(function(){self.remove()})});this.listenTo(this.model,"change:caption",this._onCaptionChanged);this._onCaptionChanged();if(this.options.renderThumbnail){this._$actions=this.$(".actions");this._$fileHeader=this.$(".file-header");this._$captionContainer=this.$(".file-caption-container");this._$thumbnailContainer=this.$(".file-thumbnail-container");this._$fileHeader.find(".download").bindProperty("href",this.model,"downloadURL",{elementToModel:false});this._$fileHeader.find(".icon").bindProperty("src",this.model,"iconURL",{elementToModel:false});this._$fileHeader.find(".filename").bindProperty("text",this.model,"filename",{elementToModel:false});this._$caption.bindProperty("href",this.model,"downloadURL",{elementToModel:false});this.listenTo(this.model,"change:loaded",this._onLoadedChanged);this._onLoadedChanged();this.listenTo(this.model,"change:thumbnailHTML",this._renderThumbnail);this._renderThumbnail()}if(this.options.canEdit!==false){this._$caption.inlineEditor({editIconClass:"rb-icon rb-icon-edit",showButtons:true}).on({beginEditPreShow:function(){self.$el.addClass("editing")},beginEdit:function(){var $this=$(this);if($this.hasClass("empty-caption")){$this.inlineEditor("field").val("")}self.trigger("beginEdit")},cancel:function(){self.$el.removeClass("editing");self.trigger("endEdit")},complete:function(e,value){self.$el.removeClass("editing");self.model.ready({ready:function(){self.model.set("caption",value);self.trigger("endEdit");self.model.save({attrs:["caption"]})}})}})}return this},fadeIn:function(){this.$el.css("opacity",0).fadeTo(1e3,1)},showCommentDlg:function(){console.assert(!this.model.get("reviewURL"),"showCommentDlg can only be called if the file "+"attachment does not have a review UI");

this._processComments();this._createDraftComment();RB.CommentDialogView.create({comment:this._draftComment,publishedComments:this._comments,publishedCommentsType:"file_attachment_comments",position:{beside:{el:this._$addCommentButton,side:"b",fitOnScreen:true}}})},_processComments:function(){var comments=this.options.comments||[],len=comments.length,comment,i;if(this._commentsProcessed){return}for(i=0;i<len;i++){comment=comments[i];if(comment.localdraft){this._createDraftComment(comment.comment_id,comment.text)}else{this._comments.push(comment)}}this._commentsProcessed=true},_createDraftComment:function(commentID,text){var review;if(this._draftComment!==null){return}review=this.options.reviewRequest.createReview();this._draftComment=review.createFileAttachmentComment(commentID,this.model.id);if(text){this._draftComment.set("text",text)}this._draftComment.on("saved",function(){this.trigger("commentSaved",this._draftComment)},this)},_renderContents:function(){this.$el.html(this.template(_.defaults({noCaptionText:gettext("No caption")},this.model.attributes))).addClass(this.className)},_renderThumbnail:function(){this._$thumbnailContainer.html(this.thumbnailContainerTemplate(_.extend({reviewAltText:gettext("Click to review"),spinnerURL:STATIC_URLS["rb/images/spinner.gif"]},this.model.attributes)))},_onLoadedChanged:function(){var $fileHeaderChildren=this._$fileHeader.children();if(this.model.get("loaded")){$fileHeaderChildren.show();this._$actions.show();this._$captionContainer.css("visibility","visible")}else{$fileHeaderChildren.hide();this._$actions.hide();this._$captionContainer.css("visibility","hidden")}this._$actions.html(this.actionsTemplate(_.defaults({deleteFileText:gettext("Delete this file"),reviewText:gettext("Review"),addCommentText:gettext("New Comment")},this.model.attributes)))},_onCaptionChanged:function(){var caption=this.model.get("caption");if(caption){this._$caption.text(caption).removeClass("empty-caption")}else{this._$caption.text(gettext("No caption")).addClass("empty-caption")}},_onAddCommentClicked:function(e){e.preventDefault();e.stopPropagation();this.showCommentDlg()},_onDeleteClicked:function(e){e.preventDefault();e.stopPropagation();this.model.destroy()}});RB.FloatingBannerView=Backbone.View.extend({initialize:function(){this._$floatSpacer=null;_.bindAll(this,"_updateFloatPosition","_updateSize")},render:function(){$(window).scroll(this._updateFloatPosition).resize(this._updateSize);_.defer(this._updateFloatPosition);return this},_updateSize:function(){if(this._$floatSpacer!==null){this.$el.width(this._$floatSpacer.parent().width()-this.$el.getExtents("bpm","lr"))}},_updateFloatPosition:function(){var $container,containerTop,containerBottom,containerHeight,wasFloating,windowTop,topOffset,outerHeight;if(this.$el.parent().length===0){return}if($.browser.msie){return}if(this._$floatSpacer===null){this._$floatSpacer=this.$el.wrap($("<div/>")).parent();this._updateSize()}$container=this.options.$floatContainer;containerTop=$container.offset().top;containerHeight=$container.outerHeight();containerBottom=containerTop+containerHeight;windowTop=$(window).scrollTop();topOffset=this._$floatSpacer.offset().top-windowTop;outerHeight=this.$el.outerHeight(true);wasFloating=this.$el.hasClass("floating");if(!$container.hasClass(this.options.noFloatContainerClass)&&topOffset<0&&containerTop<windowTop&&windowTop<containerBottom){if(!wasFloating){this._$floatSpacer.height(this.$el.outerHeight()).css({"margin-top":this.$el.css("margin-top"),"margin-bottom":this.$el.css("margin-bottom")});this.$el.addClass("floating").css("position","fixed")}this.$el.css("top",windowTop>containerBottom-outerHeight?containerBottom-outerHeight-windowTop:0);this._updateSize()}else if(wasFloating){this.$el.removeClass("floating").css({top:"",position:""});this._$floatSpacer.height("auto").css("margin",0)}}});RB.IssueSummaryTableView=Backbone.View.extend({events:{"change .filter":"_onFilterChanged","click thead th":"_onHeaderClicked","click .summary-anchor":"_onAnchorClicked"},stateToSelectorMap:{open:".open",dropped:".dropped",resolved:".resolved",all:""},initialize:function(){this.statusFilterState="open";this.reviewerFilterState="all";this.reviewerToSelectorMap={all:""}},render:function(){this._$table=this.$el.find("table");this._$thead=this._$table.find("thead");this._$tbody=this._$table.find("tbody");this._buildReviewerFilterMap();this._checkNoIssues();this._uncollapseTarget();this.model.on("issueStatusUpdated",this._onIssueStatusChanged,this);return this},setVisibility:function(entry,status){if(this.statusFilterState!==status&&this.statusFilterState!=="all"){entry.addClass("hidden")}else{entry.removeClass("hidden")}},updateCounters:function(old_status,new_status){var old_counter=$("#"+old_status+"-counter"),new_counter=$("#"+new_status+"-counter");old_counter.text(parseInt(old_counter.text(),10)-1);new_counter.text(parseInt(new_counter.text(),10)+1)},updateStatus:function(entry,old_status,new_status){entry.removeClass(old_status).addClass(new_status).find(".status").text(new_status);this.setVisibility(entry,new_status);this._checkNoIssues()},updateTimeStamp:function(entry,timestamp){entry.find(".last-updated").attr("timestamp",new Date(timestamp).getTime()).text(timestamp)},_onFilterChanged:function(){$(".issue"+this.stateToSelectorMap[this.statusFilterState]+this.reviewerToSelectorMap[this.reviewerFilterState]).toggleClass("hidden");this.statusFilterState=$("#issue-state-filter").val();this.reviewerFilterState=$("#issue-reviewer-filter").val();$(".issue"+this.stateToSelectorMap[this.statusFilterState]+this.reviewerToSelectorMap[this.reviewerFilterState]).toggleClass("hidden");this._checkNoIssues()},_onHeaderClicked:function(event){if(this._$tbody.find("tr.issue:visible").length!==0){var $header=$(event.target);this._sortByCol($header.parent().children().index(event.target)+1)}return false},_onAnchorClicked:function(event){event.stopPropagation();var $el=$(event.target);this.trigger("issueClicked",{type:$el.attr("comment-type"),id:$el.attr("issue-id")})},_checkNoIssues:function(){this._$tbody.find("tr.no-issues").remove();this._$thead.show();if(this._$tbody.find("tr.issue:visible").length===0){var text;if(this.reviewerFilterState!=="all"){if(this.statusFilterState==="open"){text=interpolate(gettext("There are no open issues from %s"),[this.reviewerFilterState])}else if(this.statusFilterState==="dropped"){text=interpolate(gettext("There are no dropped issues from %s"),[this.reviewerFilterState])}else if(this.statusFilterState==="resolved"){text=interpolate(gettext("There are no resolved issues"),[this.reviewerFilterState])}}else{if(this.statusFilterState==="open"){text=gettext("There are no open issues")}else if(this.statusFilterState==="dropped"){text=gettext("There are no dropped issues")}else if(this.statusFilterState==="resolved"){text=gettext("There are no resolved issues")}}this._$thead.hide();this._$tbody.append($("<tr>").addClass("no-issues").append($("<td>").attr("colspan",5).append($("<i>").text(text))))}},_sortByCol:function(colIndex){this._$tbody.html($(".issue").sort(function(a,b){var firstElement=$(a).find("td:nth-child("+colIndex+")"),secondElement=$(b).find("td:nth-child("+colIndex+")"),firstElementText=firstElement.text().toLowerCase(),secondElementText=secondElement.text().toLowerCase(),firstText,secondText;if(firstElement.attr("timestamp")){return parseInt(firstElement.attr("timestamp"),10)-parseInt(secondElement.attr("timestamp"),10)}else if(firstElement.hasClass("comment-id")){firstText=firstElementText.split(" ");secondText=secondElementText.split(" ");if(firstText[0]>secondText[0]){return 1}else if(firstText[0]<secondText[0]){return-1}else{return parseInt(firstText[1],10)-parseInt(secondText[1],10)}}else if(firstElementText>secondElementText){return 1}else if(firstElementText===secondElementText){return 0}else{return-1}}))},_buildReviewerFilterMap:function(){var self=this;this._$tbody.find(".issue").each(function(){var reviewer=$(this).attr("reviewer");if(!_.has(self.reviewerToSelectorMap,reviewer)){self.reviewerToSelectorMap[reviewer]='[reviewer="'+reviewer+'"]';$("#issue-reviewer-filter").append($("<option>").text(reviewer).val(reviewer))}})},_uncollapseTarget:function(){var hash=window.location.hash,commentName,targetBox;if(hash.indexOf("comment")>0){commentName=hash.toString().substring(1);targetBox=$("a[name="+commentName+"]").closest(".box");if(targetBox.hasClass("collapsed")){targetBox.removeClass("collapsed");window.location=window.location}}},_onIssueStatusChanged:function(comment,oldStatus,lastUpdated){var entry=$("#summary-table-entry-"+comment.id),newStatus=comment.get("issueStatus"),oldHeight=this.$el.height();this.updateStatus(entry,oldStatus,newStatus);this.updateCounters(oldStatus,newStatus);this.updateTimeStamp(entry,lastUpdated);$(window).scrollTop($(window).scrollTop()+this.$el.height()-oldHeight)}});RB.RegionCommentBlockView=RB.AbstractCommentBlockView.extend({className:"selection",initialize:function(){this.on("change:x change:y change:width change:height",this._updateDimensions,this)},renderContent:function(){this._updateDimensions();this._$flag=$("<div/>").addClass("selection-flag").appendTo(this.$el);this.model.on("change:count",this._updateCount,this);this._updateCount()},positionCommentDlg:function(commentDlg){commentDlg.positionBeside(this._$flag,{side:"b",fitOnScreen:true})},_updateDimensions:function(){var model=this.model;this.$el.move(model.get("x"),model.get("y"),"absolute").width(model.get("width")).height(model.get("height"))},_updateCount:function(){this._$flag.text(this.model.get("count"))}});RB.ChangeBoxView=RB.CollapsableBoxView.extend({initialize:function(options){this.reviewRequest=options.reviewRequest;this.reviewRequestEditorView=options.reviewRequestEditorView},render:function(){var $text=this.$(".changedesc-text");_super(this).render.call(this);this.reviewRequestEditorView.formatText($text);_.each(this.$(".diff-index tr"),function(rowEl){var $row=$(rowEl),iconView=new RB.DiffComplexityIconView({numInserts:$row.data("insert-count"),numDeletes:$row.data("delete-count"),numReplaces:$row.data("replace-count"),totalLines:$row.data("total-line-count")});iconView.$el.appendTo($row.find(".diff-file-icon"));iconView.render()});_.each(this.$(".file-container"),function(thumbnailEl){var $thumbnail=$(thumbnailEl),$caption=$thumbnail.find(".file-caption .edit"),model=this.reviewRequest.draft.createFileAttachment({id:$thumbnail.data("file-id")});if(!$caption.hasClass("empty-caption")){model.set("caption",$caption.text())}this.reviewRequestEditorView.buildFileAttachmentThumbnail(model,null,{$el:$thumbnail,canEdit:false})},this);return this}});RB.ReviewBoxListView=Backbone.View.extend({events:{"click #collapse-all":"_onCollapseAllClicked","click #expand-all":"_onExpandAllClicked"},initialize:function(options){this.options=options;this.diffFragmentQueue=new RB.DiffFragmentQueueView({reviewRequestPath:this.options.reviewRequest.get("reviewURL"),containerPrefix:"comment_container",queueName:"diff_fragments"});this._boxes=[]},render:function(){var pageEditState=this.options.pageEditState,reviewRequest=this.options.reviewRequest;_.each(this.$el.children(".review"),function(reviewEl){var $review=$(reviewEl),$body=$review.find(".body"),reviewID=$review.data("review-id"),review=reviewRequest.createReview(reviewID),box=new RB.ReviewBoxView({el:$review,model:review,pageEditState:pageEditState});review.set({shipIt:$review.data("ship-it"),"public":true,bodyTop:$body.children(".body_top").text(),bodyBottom:$body.children(".body_bottom").text()});box.render();this._boxes.push(box)},this);_.each(this.$el.children(".changedesc"),function(changeBoxEl){var box=new RB.ChangeBoxView({el:changeBoxEl,reviewRequest:reviewRequest,reviewRequestEditorView:this.options.reviewRequestEditorView});box.render();this._boxes.push(box)},this);this.diffFragmentQueue.loadFragments();return this},openCommentEditor:function(contextType,contextID){this._boxes.every(function(box){var reviewReplyEditorView;if(box.getReviewReplyEditorView){reviewReplyEditorView=box.getReviewReplyEditorView(contextType,contextID);if(reviewReplyEditorView){reviewReplyEditorView.openCommentEditor();return false}}return true})},_onCollapseAllClicked:function(){_.each(this._boxes,function(box){box.collapse()});return false},_onExpandAllClicked:function(){_.each(this._boxes,function(box){box.expand()});return false}});RB.ReviewBoxView=RB.CollapsableBoxView.extend({initialize:function(){this._$shipIt=null;this._reviewReply=null;this._replyEditors=[];this._replyEditorViews=[];this._draftBannerShown=false;this._$banners=null;this._openIssueCount=0;this._setupNewReply(this.options.reviewReply)},render:function(){var reviewRequest=this.model.get("parentObject"),pageEditState=this.options.pageEditState,bugTrackerURL=reviewRequest.get("bugTrackerURL"),review=this.model,loadReviewID;RB.CollapsableBoxView.prototype.render.call(this);if(document.URL.indexOf("#review")>-1){loadReviewID=document.URL.split("#review")[1];if(parseInt(loadReviewID,10)===this.model.id){this._$box.removeClass("collapsed");this._$expandCollapseButton.removeClass("rb-icon-expand-review").addClass("rb-icon-collapse-review")}}this._$banners=this.$(".banners");this._$shipIt=this.$(".shipit");_.each(this.$(".review-comments .issue-indicator"),function(el){var $issueState=$(".issue-state",el),issueStatus,issueBar;if($issueState.length>0){issueStatus=$issueState.data("issue-status");if(issueStatus===RB.BaseComment.STATE_OPEN){this._openIssueCount++}issueBar=new RB.CommentIssueBarView({el:el,reviewID:this.model.id,commentID:$issueState.data("comment-id"),commentType:$issueState.data("comment-type"),issueStatus:$issueState.data("issue-status"),interactive:$issueState.data("interactive")});issueBar.render();this.listenTo(issueBar,"statusChanged",this._onIssueStatusChanged)}},this);_.each(this.$(".comment-section"),function(el){var $el=$(el),editor=new RB.ReviewReplyEditor({contextID:$el.data("context-id"),contextType:$el.data("context-type"),review:review,reviewReply:this._reviewReply}),view=new RB.ReviewReplyEditorView({el:el,model:editor,pageEditState:pageEditState});editor.on("change:hasDraft",function(model,hasDraft){if(hasDraft){this._showReplyDraftBanner()}},this);view.render();this._replyEditors.push(editor);this._replyEditorViews.push(view)},this);this.$("pre.reviewtext").each(function(){RB.formatText($(this),{bugTrackerURL:bugTrackerURL})})},getReviewReplyEditorView:function(contextType,contextID){if(contextID===undefined){contextID=null}return _.find(this._replyEditorViews,function(view){var editor=view.model;return editor.get("contextID")===contextID&&editor.get("contextType")===contextType})},_showReplyDraftBanner:function(){if(!this._draftBannerShown){var banner=new RB.ReviewReplyDraftBannerView({model:this._reviewReply,$floatContainer:this.$(".box"),noFloatContainerClass:"collapsed"});banner.render().$el.appendTo(this._$banners);this._draftBannerShown=true}},_hideReplyDraftBanner:function(){this._$banners.children().remove();this._draftBannerShown=false},_setupNewReply:function(reviewReply){var hadReviewReply=this._reviewReply!==null;if(!reviewReply){reviewReply=this.model.createReply()}if(hadReviewReply){this.stopListening(this._reviewReply);_.each(this._replyEditors,function(editor){editor.set("reviewReply",reviewReply)},this);this._hideReplyDraftBanner()}this.listenTo(reviewReply,"destroyed published",function(){this._setupNewReply()});this._reviewReply=reviewReply},_onIssueStatusChanged:function(issueStatus){if(issueStatus===RB.BaseComment.STATE_OPEN){this._openIssueCount++}else{this._openIssueCount--}if(this._$shipIt.length>0){this._updateShipItLabel()}},_updateShipItLabel:function(){if(this._openIssueCount===0){this._$shipIt.removeClass("with-issues").text(gettext("Ship it!"))}else{this._$shipIt.addClass("with-issues").text(gettext("Fix it, then Ship it!"))}}});(function(){var BaseCommentView,DiffCommentView,FileAttachmentCommentView,ScreenshotCommentView;BaseCommentView=Backbone.View.extend({tagName:"li",thumbnailTemplate:"",editorTemplate:_.template(['<div class="edit-fields">',' <div class="edit-field">','  <div class="comment-text-field"></div>'," </div>",' <div class="edit-field">','  <input class="issue-opened" id="<%= issueOpenedID %>" ','         type="checkbox" />','  <label for="<%= issueOpenedID %>"><%- openAnIssueText %></label>'," </div>",' <div class="edit-field">','  <input class="enable-markdown" id="<%= enableMarkdownID %>" ','         type="checkbox" />','  <label for="<%= enableMarkdownID %>"><%- enableMarkdownText %>',"</label>"," </div>","</div>"].join("")),initialize:function(){this.$issueOpened=null;this.textEditor=null;this._origIssueOpened=this.model.get("issueOpened");this._origRichText=this.model.get("richText");this._origExtraData=_.clone(this.model.get("extraData"));this._hookViews=[];this.model.set("includeTextTypes","raw")},remove:function(){_.each(this._hookViews,function(hookView){hookView.remove()});this._hookViews=[];_super(this).remove.call(this)},needsSave:function(){var newValue=this.textEditor.getText(),newIssueOpened=this.$issueOpened.prop("checked");newRichText=this.textEditor.richText;return this.model.get("text")!==newValue||this.model.get("issueOpened")!==newIssueOpened||this.model.get("richText")!==newRichText||!_.isEqual(this.model.get("extraData"),this._origExtraData)},save:function(options){this.model.set({issueOpened:this.$issueOpened.prop("checked"),richText:this.textEditor.richText,text:this.textEditor.getText()});this.model.save(options)},render:function(){var $editFields;this.$el.append(this.renderThumbnail()).append($(this.editorTemplate({text:this.model.get("text"),issueOpenedID:_.uniqueId("issue-opened"),openAnIssueText:gettext("Open an Issue"),enableMarkdownID:_.uniqueId("enable-markdown"),enableMarkdownText:gettext("Enable Markdown")})));this.textEditor=new RB.TextEditorView({el:this.$(".comment-text-field"),text:this.model.get("text"),bindRichText:{model:this.model,attrName:"richText"}});this.textEditor.render();this.textEditor.show();this.textEditor.bindRichTextCheckbox(this.$(".enable-markdown"));this.$issueOpened=this.$(".issue-opened").prop("checked",this.model.get("issueOpened"));$editFields=this.$(".edit-fields");RB.ReviewDialogCommentHook.each(function(hook){var HookView=hook.get("viewType"),hookView=new HookView({model:this.model});this._hookViews.push(hookView);$editFields.append($('<div class="edit-field"/>').append(hookView.$el));hookView.render()},this);return this},renderThumbnail:function(){return $(this.thumbnailTemplate(this.model.attributes))}});DiffCommentView=BaseCommentView.extend({thumbnailTemplate:_.template(['<div id="review_draft_comment_container_<%= id %>">',' <table class="sidebyside loading">',"  <thead>","   <tr>",'    <th class="filename">',"     <%- fileDiff.destFilename %>","     <% if (interFileDiff) { %>","      (Diff revisions <%- fileDiff.sourceRevision %> - ","       <%- interFileDiff.sourceRevision %>)","     <% } else { %>","      (Diff revision <%- fileDiff.sourceRevision %>)","     <% } %>","    </th>","   </tr>","  </thead>","  <tbody>","   <% for (var i = 0; i < numLines; i++) { %>","    <tr><td><pre>&nbsp;</pre></td></tr>","   <% } %>","  </tbody>"," </table>","</div>"].join("")),render:function(){var fileDiffID=this.model.get("fileDiffID"),interFileDiffID=this.model.get("interFileDiffID");BaseCommentView.prototype.render.call(this);this.options.diffQueue.queueLoad(this.model.id,interFileDiffID?fileDiffID+"-"+interFileDiffID:fileDiffID);return this},renderThumbnail:function(){var interFileDiff=this.model.get("interFileDiff");return $(this.thumbnailTemplate(_.defaults({numLines:this.model.getNumLines(),fileDiff:this.model.get("fileDiff").attributes,interFileDiff:interFileDiff?interFileDiff.attributes:{}},this.model.attributes)))}});FileAttachmentCommentView=BaseCommentView.extend({thumbnailTemplate:_.template(['<div class="file-attachment">',' <span class="filename">','  <img src="<%- fileAttachment.iconURL %>" />','  <a href="<%- reviewURL %>"><%- linkText %></a>'," </span>",' <div class="thumbnail"><%= thumbnailHTML %></div>',"</div>"].join("")),renderThumbnail:function(){return $(this.thumbnailTemplate(_.defaults({fileAttachment:this.model.get("fileAttachment").attributes},this.model.attributes)))}});ScreenshotCommentView=BaseCommentView.extend({thumbnailTemplate:_.template(['<div class="screenshot">',' <span class="filename">','  <a href="<%- screenshot.reviewURL %>"><%- displayName %></a>'," </span>",' <img src="<%= thumbnailURL %>" width="<%= width %>" ','      height="<%= height %>" alt="<%- displayName %>" />',"</div>"].join("")),renderThumbnail:function(){var screenshot=this.model.get("screenshot");return $(this.thumbnailTemplate(_.defaults({screenshot:screenshot.attributes,displayName:screenshot.getDisplayName()},this.model.attributes)))}});RB.ReviewDialogView=Backbone.View.extend({id:"review-form-comments",className:"review",template:_.template(['<div class="edit-field">',' <a class="markdown-info" href="<%- markdownDocsURL %>"','    target="_blank"><%- markdownText %></a>',' <input id="id_shipit" type="checkbox" />',' <label for="id_shipit"><%- shipItText %></label>',"</div>",'<div class="review-dialog-hooks-container"></div>','<div class="edit-field">',' <div class="body-top"></div>',' <span class="enable-markdown">','  <input id="enable_body_top_markdown" type="checkbox" />','  <label for="enable_body_top_markdown">',"<%- enableMarkdownText %></label>"," </span>","</div>",'<ul class="comments"></ul>','<div class="spinner"></div>','<div class="edit-field" id="body_bottom_fields">',' <div class="body-bottom"></div>',' <span class="enable-markdown">','  <input id="enable_body_bottom_markdown" type="checkbox" />','  <label for="enable_body_bottom_markdown">',"<%- enableMarkdownText %></label>"," </span>","</div>"].join("")),initialize:function(){var reviewRequest=this.model.get("parentObject");this._$comments=null;this._$shipIt=null;this._$dlg=null;this._$buttons=null;this._$spinner=null;this._bodyTopEditor=null;this._bodyBottomEditor=null;this._$bodyBottomFields=null;this._commentViews=[];this._hookViews=[];this._diffQueue=new RB.DiffFragmentQueueView({containerPrefix:"review_draft_comment_container",reviewRequestPath:reviewRequest.get("reviewURL"),queueName:"review_draft_diff_comments"});this._diffCommentsCollection=new RB.ResourceCollection([],{model:RB.DiffComment,parentResource:this.model,extraQueryData:{"order-by":"filediff,first_line"}});this.listenTo(this._diffCommentsCollection,"add",function(comment){this._renderComment(new DiffCommentView({model:comment,diffQueue:this._diffQueue}))});this._fileAttachmentCommentsCollection=new RB.ResourceCollection([],{model:RB.FileAttachmentComment,parentResource:this.model});this.listenTo(this._fileAttachmentCommentsCollection,"add",function(comment){this._renderComment(new FileAttachmentCommentView({model:comment}))});this._screenshotCommentsCollection=new RB.ResourceCollection([],{model:RB.ScreenshotComment,parentResource:this.model});this.listenTo(this._screenshotCommentsCollection,"add",function(comment){this._renderComment(new ScreenshotCommentView({model:comment}))});this._defaultUseRichText=RB.UserSession.instance.get("defaultUseRichText");if(this._defaultUseRichText){this.model.set({forceTextType:"markdown",includeTextTypes:"raw"});this._queryData={"force-text-type":"markdown","include-text-types":"raw"}}else{this._queryData={"force-text-type":undefined,"include-text-types":undefined}}this.options.reviewRequestEditor.incr("editCount")},remove:function(){_.each(this._hookViews,function(hookView){hookView.remove()});this._hookViews=[];_super(this).remove.call(this)},close:function(){this.options.reviewRequestEditor.decr("editCount");this._$dlg.modalBox("destroy");this.trigger("closed");this.remove()},render:function(){var $hooksContainer;this.$el.html(this.template({shipItText:gettext("Ship It"),markdownDocsURL:MANUAL_URL+"users/markdown/",markdownText:gettext("Markdown Reference"),enableMarkdownText:gettext("Enable Markdown")}));this._$shipIt=this.$("#id_shipit");this._$comments=this.$el.children(".comments");this._$spinner=this.$el.children(".spinner");this._$bodyBottomFields=this.$el.children("#body_bottom_fields");$hooksContainer=this.$(".review-dialog-hooks-container");RB.ReviewDialogHook.each(function(hook){var HookView=hook.get("viewType"),hookView=new HookView({model:this.model});this._hookViews.push(hookView);$hooksContainer.append(hookView.$el);hookView.render()},this);this._bodyTopEditor=new RB.TextEditorView({el:this.$(".body-top"),bindRichText:{model:this.model,attrName:"bodyTopRichText"}});this._bodyTopEditor.render();this._bodyTopEditor.show();this._bodyTopEditor.bindRichTextCheckbox(this.$("#enable_body_top_markdown"));this._bodyBottomEditor=new RB.TextEditorView({el:this.$(".body-bottom"),bindRichText:{model:this.model,attrName:"bodyBottomRichText"}});this._bodyBottomEditor.render();this._bodyBottomEditor.hide();this._$bodyBottomFields.hide();this._bodyBottomEditor.bindRichTextCheckbox(this.$("#enable_body_bottom_markdown"));this.model.ready({data:this._queryData,ready:function(){var bodyBottom,bodyTop;this._renderDialog();if(this.model.isNew()){this._$spinner.remove();this._$spinner=null}else{bodyBottom=this.model.get("bodyBottom")||"";bodyTop=this.model.get("bodyTop")||"";this._bodyBottomEditor.setText(bodyBottom);this._bodyTopEditor.setText(bodyTop);this._$shipIt.prop("checked",this.model.get("shipIt"));this._loadComments()}}},this);return this},_loadComments:function(){var collections=[this._screenshotCommentsCollection,this._fileAttachmentCommentsCollection,this._diffCommentsCollection];this._loadCommentsFromCollection(collections,function(){this._$spinner.remove();this._$spinner=null;if(this._commentViews.length>0){this._$bodyBottomFields.show();this._bodyBottomEditor.show()}})},_loadCommentsFromCollection:function(collections,onDone){var collection=collections.shift();if(collection){collection.fetchAll({data:this._queryData,success:function(){if(collection===this._diffCommentsCollection){this._diffQueue.loadFragments()}this._loadCommentsFromCollection(collections,onDone)},error:function(rsp){alert(rsp.errorText)}},this)}else{onDone.call(this)}},_renderComment:function(view){this._commentViews.push(view);view.$el.appendTo(this._$comments);view.render()},_renderDialog:function(){var reviewRequest=this.model.get("parentObject");this._$dlg=$("<div/>").attr("id","review-form").append(this.$el).modalBox({container:this.options.container||"body",boxID:"review-form-modalbox",title:gettext("Review for: ")+reviewRequest.get("summary"),stretchX:true,stretchY:true,buttons:[$('<input type="button"/>').val(gettext("Publish Review")).click(_.bind(function(){this._saveReview(true);return false},this)),$('<input type="button"/>').val(gettext("Discard Review")).click(_.bind(this._onDiscardClicked,this)),$('<input type="button"/>').val(gettext("Cancel")).click(_.bind(function(){this.close();return false},this)),$('<input type="button"/>').val(gettext("Save")).click(_.bind(function(){this._saveReview();return false},this))]}).keypress(function(e){e.stopPropagation()}).attr("scrollTop",0).trigger("ready");this._$buttons=this._$dlg.modalBox("buttons");this._bodyTopEditor.focus()},_onDiscardClicked:function(){var model=this.model,self=this;$("<p/>").text(gettext("If you discard this review, all related comments will be permanently deleted.")).modalBox({title:gettext("Are you sure you want to discard this review?"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Discard")).click(function(){self.close();model.destroy({success:function(){RB.DraftReviewBannerView.instance.hideAndReload()}})})]});return false},_saveReview:function(publish){this._$buttons.prop("disabled");$.funcQueue("reviewForm").clear();_.each(this._commentViews,function(view){if(view.needsSave()){$.funcQueue("reviewForm").add(function(){view.save({success:function(){$.funcQueue("reviewForm").next()}})})}});$.funcQueue("reviewForm").add(function(){var saveFunc=publish?this.model.publish:this.model.save;this.model.set({shipIt:this._$shipIt.prop("checked"),bodyTop:this._bodyTopEditor.getText(),bodyBottom:this._bodyBottomEditor.getText(),bodyTopRichText:this._bodyTopEditor.richText,bodyBottomRichText:this._bodyBottomEditor.richText});saveFunc.call(this.model,{success:function(){$.funcQueue("reviewForm").next()},error:function(){console.log(arguments)}})},this);$.funcQueue("reviewForm").add(function(){var reviewBanner=RB.DraftReviewBannerView.instance;this.close();if(reviewBanner){if(publish){reviewBanner.hideAndReload()}else{reviewBanner.show()}}},this);$.funcQueue("reviewForm").start()}},{_instance:null,create:function(options){var instance=RB.ReviewDialogView._instance,reviewRequestEditor=options.reviewRequestEditor,dlg;options=options||{};console.assert(!instance,"A ReviewDialogView is already opened");console.assert(options.review,"A review must be specified");dlg=new RB.ReviewDialogView({container:options.container,model:options.review,reviewRequestEditor:reviewRequestEditor});RB.ReviewDialogView._instance=dlg;dlg.render();dlg.on("closed",function(){RB.ReviewDialogView._instance=null});return dlg}})})();RB.ReviewReplyDraftBannerView=RB.FloatingBannerView.extend({className:"banner",template:_.template(["<h1><%- draftText %></h1>"," Be sure to publish when finished.",'<input type="button" value="Publish" class="publish-button" />','<input type="button" value="Discard" class="discard-button" />'].join("")),events:{"click .publish-button":"_onPublishClicked","click .discard-button":"_onDiscardClicked"},render:function(){_super(this).render.call(this);this.$el.html(this.template({draftText:gettext("This reply is a draft.")}));this.model.on("saving destroying",function(){this.$("input").prop("disabled",true)},this);this.model.on("saved",function(){this.$("input").prop("disabled",false)},this);this.model.on("publishError",function(errorText){alert(errorText)},this);return this},_onPublishClicked:function(){this.model.publish()},_onDiscardClicked:function(){this.model.destroy()}});RB.ReviewReplyEditorView=Backbone.View.extend({commentTemplate:_.template(['<li <% if (isDraft) { %>class="draft"<% } %>','    <% if (commentID) { %>data-comment-id="<%= commentID %>"<% } %>>'," <dl>","  <dt>",'   <label for="<%= id %>">','    <a href="<%= userPageURL %>" class="user"><%- fullName %></a>',"<% if (timestamp) { %>",'    <span class="timestamp">','     <time class="timesince" datetime="<%= timestampISO %>">',"<%= timestamp %></time> (<%= timestamp %>)","    </span>","<% } %>","   </label>","  </dt>",'  <dd><pre id="<%= id %>" class="reviewtext">',"<%- text %></pre></dd>"," </dl>","</li>"].join("")),events:{"click .add_comment_link":"_onAddCommentClicked"},initialize:function(){this._$addCommentLink=null;this._$draftComment=null;this._$editor=null;this._$commentsList=null},render:function(){var $draftComment,$reviewText,$time;this._$addCommentLink=this.$(".add_comment_link");this._$commentsList=this.$(".reply-comments");$draftComment=this._$commentsList.children(".draft");if($draftComment.length!==0){$time=$draftComment.find("time");$reviewText=$draftComment.find(".reviewtext");this.model.set({commentID:$draftComment.data("comment-id"),text:$reviewText.html(),timestamp:new Date($time.attr("datetime")),richText:$reviewText.hasClass("rich-text"),hasDraft:true});this._createCommentEditor($draftComment)}this.listenTo(this.model,"textUpdated",function(){var reviewRequest=this.model.get("review").get("parentObject");if(this._$editor){RB.formatText(this._$editor,{newText:this.model.get("text"),richText:this.model.get("richText"),bugTrackerURL:reviewRequest.get("bugTrackerURL")})}});this.model.on("resetState",function(){if(this._$draftComment){this._$draftComment.fadeOut(_.bind(function(){this._$draftComment.remove();this._$draftComment=null},this))}this._$addCommentLink.fadeIn();

},this);this.model.on("published",this._onPublished,this)},openCommentEditor:function(){this._createCommentEditor(this._makeCommentElement());this._$editor.inlineEditor("startEdit")},_createCommentEditor:function($draftComment){var pageEditState=this.options.pageEditState;this._$draftComment=$draftComment;this._$editor=$draftComment.find("pre.reviewtext");this._$editor.inlineEditor(_.extend({cls:"inline-comment-editor",editIconClass:"rb-icon rb-icon-edit",notifyUnchangedCompletion:true,multiline:true,hasRawValue:true,rawValue:this._$editor.data("raw-value")||""},RB.TextEditorView.getInlineEditorOptions({richText:this._$editor.hasClass("rich-text")}))).removeAttr("data-raw-value").on({beginEdit:function(){if(pageEditState){pageEditState.incr("editCount")}},complete:_.bind(function(e,value){var textEditor=RB.TextEditorView.getFromInlineEditor(this._$editor);if(pageEditState){pageEditState.decr("editCount")}this.model.set({text:value,richText:textEditor.richText});this.model.save()},this),cancel:_.bind(function(){if(pageEditState){pageEditState.decr("editCount")}this.model.resetStateIfEmpty()},this)});this._$addCommentLink.hide()},_makeCommentElement:function(options){var userSession=RB.UserSession.instance,reviewRequest=this.model.get("review").get("parentObject"),now,$el;options=options||{};now=options.now||moment().zone(userSession.get("timezoneOffset"));$el=$(this.commentTemplate(_.extend({id:_.uniqueId("draft_comment_"),text:"",commentID:null,userPageURL:userSession.get("userPageURL"),fullName:userSession.get("fullName"),isDraft:true,timestampISO:now.format(),timestamp:now.format("MMMM Do, YYYY, h:mm ")+(now.hour()<12?"a.m.":"p.m.")},options))).find(".user").user_infobox().end().find("time.timesince").timesince().end().appendTo(this._$commentsList);if(options.text){RB.formatText($el.find(".reviewtext"),{newText:options.text,richText:options.richText,bugTrackerURL:reviewRequest.get("bugTrackerURL")})}return $el},_onAddCommentClicked:function(e){e.preventDefault();e.stopPropagation();this.openCommentEditor()},_onPublished:function(){if(this._$draftComment){this._$draftComment.replaceWith(this._makeCommentElement({commentID:this.model.get("commentID"),text:this.model.get("text"),richText:this.model.get("richText"),isDraft:false}));this._$draftComment=null}}});(function(){var BannerView,ClosedBannerView,DraftBannerView;BannerView=Backbone.View.extend({className:"banner",title:"",subtitle:"",actions:[],showChangesField:true,describeText:"",fieldOptions:{},descriptionFieldID:"changedescription",descriptionFieldName:null,template:_.template(["<h1><%- title %></h1>","<%- subtitle %>","<% _.each(actions, function(action) { %>",' <input type="button" id="<%= action.id %>" ','        value="<%- action.label %>" />',"<% }); %>","<% if (showChangesField) { %>",' <p><label for="field_changedescription">',"<%- describeText %></label></p>",' <pre id="field_changedescription"','      class="editable field-text-area field"','      data-field-id="changedescription">',"<%- closeDescription %></pre>","<% } %>"].join("")),initialize:function(options){this.reviewRequestEditorView=options.reviewRequestEditorView;this.reviewRequest=this.reviewRequestEditorView.model.get("reviewRequest");this.reviewRequestEditorView.registerField(_.defaults({fieldID:this.descriptionFieldID,fieldName:this.descriptionFieldName,elementOptional:true,allowMarkdown:true,useExtraData:false,formatter:function(view,data,$el,fieldOptions){view.formatText($el,{newText:data,fieldOptions:fieldOptions})}},this.fieldOptions));this.$buttons=null},render:function(){var reviewRequestEditor=this.reviewRequestEditorView.model;if(this.$el.children().length===0){this.$el.html(this.template({title:this.title,subtitle:this.subtitle,actions:this.actions,showChangesField:this.showChangesField,describeText:this.describeText,closeDescription:this.reviewRequest.get("closeDescription")}))}this.$buttons=this.$("input");reviewRequestEditor.on("saving destroying",function(){this.$buttons.prop("disabled",true)},this);reviewRequestEditor.on("saved saveFailed destroyed",function(){this.$buttons.prop("disabled",false)},this);this.reviewRequestEditorView.setupFieldEditor(this.descriptionFieldID);return this}});ClosedBannerView=BannerView.extend({descriptionFieldName:"closeDescription",actions:[{id:"btn-review-request-reopen",label:gettext("Reopen for Review")}],fieldOptions:{statusField:true},events:{"click #btn-review-request-reopen":"_onReopenClicked"},_onReopenClicked:function(){this.reviewRequest.reopen({error:function(model,xhr){alert(xhr.errorText)}});return false}});DiscardedBannerView=ClosedBannerView.extend({id:"discard-banner",title:gettext("This change has been discarded."),describeText:gettext("Describe the reason it's discarded (optional):"),fieldOptions:_.defaults({closeType:RB.ReviewRequest.CLOSE_DISCARDED},ClosedBannerView.prototype.fieldOptions)});SubmittedBannerView=ClosedBannerView.extend({id:"submitted-banner",title:gettext("This change has been marked as submitted."),describeText:gettext("Describe the submission (optional):"),fieldOptions:_.defaults({closeType:RB.ReviewRequest.CLOSE_SUBMITTED},ClosedBannerView.prototype.fieldOptions)});DraftBannerView=BannerView.extend({id:"draft-banner",subtitle:"Be sure to publish when finished.",describeText:"Describe your changes (optional):",descriptionFieldName:"changeDescription",events:{"click #btn-draft-publish":"_onPublishDraftClicked","click #btn-draft-discard":"_onDiscardDraftClicked","click #btn-review-request-discard":"_onCloseDiscardedClicked"},initialize:function(){_super(this).initialize.apply(this,arguments);if(this.reviewRequest.get("public")){this.title="This review request is a draft.";this.actions=[{id:"btn-draft-publish",label:gettext("Publish Changes")},{id:"btn-draft-discard",label:gettext("Discard Draft")}]}else{this.showChangesField=false;this.actions=[{id:"btn-draft-publish",label:gettext("Publish")},{id:"btn-review-request-discard",label:gettext("Discard Review Request")}]}},_onPublishDraftClicked:function(){this.reviewRequestEditorView.publishDraft();return false},_onDiscardDraftClicked:function(){this.reviewRequest.draft.destroy({error:function(xhr){alert(xhr.errorText)}});return false},_onDiscardedReviewRequestClicked:function(){this.reviewRequestEditorView.closeDiscarded();return false},_onCloseDiscardedClicked:function(){this.reviewRequest.close({type:RB.ReviewRequest.CLOSE_DISCARDED});return false}});RB.ReviewRequestEditorView=Backbone.View.extend({defaultFields:[{fieldID:"branch"},{fieldID:"bugs_closed",fieldName:"bugsClosed",selector:"#field_bugs_closed",useEditIconOnly:true,formatter:function(view,data,$el){var reviewRequest=view.model.get("reviewRequest"),bugTrackerURL=reviewRequest.get("bugTrackerURL");data=data||[];if(bugTrackerURL){$el.html(view.urlizeList(data,function(item){return bugTrackerURL.replace("%s",item)},_.escape))}else{$el.text(data.join(", "))}}},{fieldID:"depends_on",fieldName:"dependsOn",useEditIconOnly:true,formatter:function(view,data,$el){$el.html(view.urlizeList(data,function(item){return item.url},function(item){return item.id}))}},{fieldID:"description",allowMarkdown:true,formatter:function(view,data,$el,fieldOptions){view.formatText($el,{newText:data,fieldOptions:fieldOptions})}},{fieldID:"summary"},{fieldID:"target_groups",fieldName:"targetGroups",useEditIconOnly:true,autocomplete:{fieldName:"groups",nameKey:"name",descKey:"display_name",extraParams:{displayname:1}},formatter:function(view,data,$el){$el.html(view.urlizeList(data,function(item){return item.url},function(item){return item.name}))}},{fieldID:"target_people",fieldName:"targetPeople",useEditIconOnly:true,autocomplete:{fieldName:"users",nameKey:"username",descKey:"fullname",extraParams:{fullname:1},cmp:function(term,a,b){var aUsername=a.data.username,bUsername=b.data.username,aFullname=a.data.fullname,bFullname=a.data.fullname;if(aUsername.indexOf(term)===0){if(bUsername.indexOf(term)===0){return aUsername.localeCompare(bUsername)}return-1}else if(bUsername.indexOf(term)===0){return 1}else{return aFullname.localeCompare(bFullname)}}},formatter:function(view,data,$el){var $list=$(view.urlizeList(data,function(item){return item.url},function(item){return item.username}));$el.html($list.addClass("user").user_infobox())}},{fieldID:"testing_done",fieldName:"testingDone",allowMarkdown:true,formatter:function(view,data,$el,fieldOptions){view.formatText($el,{newText:data,fieldOptions:fieldOptions})}}],initialize:function(){var $issueSummary=$("#issue-summary");_.bindAll(this,"_checkResizeLayout","_scheduleResizeLayout");this._fieldEditors={};this._hasFields=this.$(".editable").length>0;if(this._hasFields){_.each(this.defaultFields,function(fieldInfo){this.registerField(_.defaults({useExtraData:false},fieldInfo))},this)}this.draft=this.model.get("reviewRequest").draft;this.banner=null;this._$main=null;this._$extra=null;this._blockResizeLayout=false;if($issueSummary.length>0){this.issueSummaryTableView=new RB.IssueSummaryTableView({el:$("#issue-summary"),model:this.model.get("commentIssueManager")})}},registerField:function(options){var fieldID=options.fieldID,useExtraData=options.useExtraData===undefined?true:options.useExtraData;console.assert(fieldID);options=_.extend({selector:"#field_"+fieldID,elementOptional:false,fieldID:fieldID,fieldName:fieldID,formatter:null,jsonFieldName:fieldID,jsonTextTypeFieldName:options.allowMarkdown?fieldID+"_text_type":null,useEditIconOnly:false,useExtraData:useExtraData},options);options.richTextAttr=options.allowMarkdown?options.fieldName+"RichText":null;this._fieldEditors[fieldID]=options},render:function(){var reviewRequest=this.model.get("reviewRequest"),draft=reviewRequest.draft,extraData=draft.get("extraData");this._$box=this.$(".review-request");this._$warning=$("#review-request-warning");this._$screenshots=$("#screenshot-thumbnails");this._$attachments=$("#file-list");this._$attachmentsContainer=$(this._$attachments.parent()[0]);this._$bannersContainer=$("#review_request_banners");this._$main=$("#review_request_main");this._$extra=$("#review_request_extra");if(this._hasFields){_.each(this.$(".field.editable"),function(field){var $field=$(field),fieldID=$field.data("field-id"),isCommaEditable,richTextFieldID,fieldInfo,rawValue;if(!this._fieldEditors[fieldID]&&$field.hasClass("editable")){isCommaEditable=$field.hasClass("comma-editable");fieldInfo={fieldID:fieldID};rawValue=$field.data("raw-value");if(rawValue===undefined){extraData[fieldID]=$field.text()}else{extraData[fieldID]=rawValue||""}$field.removeAttr("data-raw-value");if($field.data("allow-markdown")){fieldInfo.allowMarkdown=true;if(fieldID==="text"){richTextFieldID="rich_text"}else{richTextFieldID=fieldID+"_rich_text"}extraData[richTextFieldID]=$field.hasClass("rich-text")}if(isCommaEditable){fieldInfo.useEditIconOnly=true;fieldInfo.formatter=function(view,data,$el){data=data||[];$el.html(data.join(", "))}}else if(fieldInfo.allowMarkdown){fieldInfo.formatter=function(view,data,$el,fieldOptions){view.formatText($el,{newText:data,fieldOptions:fieldOptions})}}this.registerField(fieldInfo)}},this);_.each(this._fieldEditors,function(fieldOptions,fieldID){this.setupFieldEditor(fieldID)},this)}if(this._$bannersContainer.children().filter(":visible").length>0){this.showBanner()}if(this._hasFields){_.each(this.$(".field-text-area"),function(el){this.formatText($(el))},this);if(this.model.get("editable")){this.dndUploader=new RB.DnDUploader({reviewRequestEditor:this.model})}$(window).resize(this._scheduleResizeLayout);this.listenTo(this.model,"change:editCount",this._checkResizeLayout);this._checkResizeLayout();if(this.issueSummaryTableView){this.issueSummaryTableView.render()}this.model.fileAttachments.on("add",this.buildFileAttachmentThumbnail,this);_.each(this._$screenshots.find(".screenshot-container"),this._importScreenshotThumbnail,this);_.each(this._$attachments.find(".file-container"),this._importFileAttachmentThumbnail,this);_.each($(".binary"),this._importFileAttachmentThumbnail,this)}this._setupActions();this.model.on("publishError",function(errorText){alert(errorText);this.$("#btn-draft-publish").enable();this.$("#btn-draft-discard").enable()},this);this.model.on("closeError",function(errorText){alert(errorText)},this);this.model.on("saved",this.showBanner,this);this.model.on("published",this._refreshPage,this);reviewRequest.on("closed reopened",this._refreshPage,this);draft.on("destroyed",this._refreshPage,this);window.onbeforeunload=_.bind(function(evt){if((this.model.get("editable")||this.model.get("statusEditable"))&&this.model.get("editCount")>0){var msg=gettext("You have unsaved changes that will be lost if you navigate away from this page.");evt=evt||window.event;evt.returnValue=msg;return msg}},this);return this},setupFieldEditor:function(fieldID){var fieldOptions=this._fieldEditors[fieldID],$el=this.$(fieldOptions.selector),listenObj;if($el.length===0){return}this._buildEditor($el,fieldOptions);if(_.has(fieldOptions,"autocomplete")){this._buildAutoComplete($el,fieldOptions.autocomplete);$el.inlineEditor("setupEvents")}if(fieldOptions.fieldName==="closeDescription"){listenObj=this.model.get("reviewRequest")}else{listenObj=this.draft}this.listenTo(listenObj,"change:"+fieldOptions.fieldName,_.bind(this._formatField,this,fieldOptions))},showBanner:function(){var BannerClass,reviewRequest=this.model.get("reviewRequest"),state=reviewRequest.get("state"),$existingBanner=this._$bannersContainer.children();if(this.banner){return}console.assert($existingBanner.length<=1);if($existingBanner.length===0){$existingBanner=undefined}if(state===RB.ReviewRequest.CLOSE_SUBMITTED){BannerClass=SubmittedBannerView}else if(state===RB.ReviewRequest.CLOSE_DISCARDED){BannerClass=DiscardedBannerView}else if(state===RB.ReviewRequest.PENDING){BannerClass=DraftBannerView}console.assert(BannerClass);this.banner=new BannerClass({el:$existingBanner,reviewRequestEditorView:this});if($existingBanner){$existingBanner.show()}else{this.banner.$el.appendTo(this._$bannersContainer)}this.banner.render()},publishDraft:function(){var fields=this.$(".editable:inlineEditorDirty");this.model.set({publishing:true,pendingSaveCount:fields.length});if(fields.length===0){this.model.publishDraft()}else{fields.inlineEditor("submit")}},urlizeList:function(list,urlFunc,textFunc){var str="",len,item,i;if(!list){return""}len=list.length;for(i=0;i<len;i++){item=list[i];str+='<a href="';str+=urlFunc?urlFunc(item):item;str+='">';str+=textFunc?textFunc(item):item;str+="</a>";if(i<len-1){str+=", "}}return str},formatText:function($el,options){var reviewRequest=this.model.get("reviewRequest"),fieldOptions;options=_.defaults({bugTrackerURL:reviewRequest.get("bugTrackerURL"),isHTMLEncoded:true},options);fieldOptions=options.fieldOptions;if(fieldOptions&&fieldOptions.richTextAttr){options.richText=this.model.getDraftField(fieldOptions.richTextAttr,fieldOptions)}RB.formatText($el,options);$el.find("img").load(this._checkResizeLayout)},_setupActions:function(){var $closeDiscarded=this.$("#discard-review-request-link"),$closeSubmitted=this.$("#link-review-request-close-submitted"),$deletePermanently=this.$("#delete-review-request-link"),$menuitem;function showMenu(){if($menuitem){$menuitem.children("ul").fadeOut("fast");$menuitem=null}$(this).children("ul").fadeIn("fast")}function hideMenu(){$menuitem=$(this);setTimeout(function(){if($menuitem){$menuitem.children("ul").fadeOut("fast")}},400)}this.$(".actions > li:has(ul.menu)").hover(showMenu,hideMenu).toggle(showMenu,hideMenu);$closeDiscarded.click(_.bind(this._onCloseDiscardedClicked,this));$closeSubmitted.click(_.bind(this._onCloseSubmittedClicked,this));$deletePermanently.click(_.bind(this._onDeleteReviewRequestClicked,this))},buildFileAttachmentThumbnail:function(fileAttachment,collection,options){var fileAttachmentComments=this.model.get("fileAttachmentComments"),$thumbnail,view;options=options||{};$thumbnail=options.$el;view=new RB.FileAttachmentThumbnail({el:$thumbnail,model:fileAttachment,comments:fileAttachmentComments[fileAttachment.id],renderThumbnail:$thumbnail===undefined,reviewRequest:this.model.get("reviewRequest"),canEdit:this.model.get("editable")===true});view.render();if(!$thumbnail){this._$attachmentsContainer.show();view.$el.insertBefore(this._$attachments.children("br"));view.fadeIn()}view.on("beginEdit",function(){this.model.incr("editCount")},this);view.on("endEdit",function(){this.model.decr("editCount")},this);view.on("commentSaved",function(){RB.DraftReviewBannerView.instance.show()},this)},_importFileAttachmentThumbnail:function(thumbnailEl){var $thumbnail=$(thumbnailEl),id=$thumbnail.data("file-id"),$caption=$thumbnail.find(".file-caption .edit"),reviewRequest=this.model.get("reviewRequest"),fileAttachment=reviewRequest.draft.createFileAttachment({id:id});if(!$caption.hasClass("empty-caption")){fileAttachment.set("caption",$caption.text())}this.model.fileAttachments.add(fileAttachment,{$el:$thumbnail})},_importScreenshotThumbnail:function(thumbnailEl){var $thumbnail=$(thumbnailEl),id=$thumbnail.data("screenshot-id"),reviewRequest=this.model.get("reviewRequest"),screenshot=reviewRequest.createScreenshot(id),view=new RB.ScreenshotThumbnail({el:$thumbnail,model:screenshot});view.render();this.model.screenshots.add(screenshot);view.on("beginEdit",function(){this.model.incr("editCount")},this);view.on("endEdit",function(){this.model.decr("editCount")},this)},_buildEditor:function($el,fieldOptions){var model=this.model,el=$el[0],id=el.id,editableProp=fieldOptions.statusField?"statusEditable":"editable",multiline=$el.hasClass("field-text-area"),options={cls:id+"-editor",editIconClass:"rb-icon rb-icon-edit",enabled:this.model.get(editableProp),multiline:multiline,useEditIconOnly:fieldOptions.useEditIconOnly,showRequiredFlag:$el.hasClass("required"),deferEventSetup:_.has(fieldOptions,"autocomplete")};if(fieldOptions.allowMarkdown){_.extend(options,RB.TextEditorView.getInlineEditorOptions({minHeight:0,richText:model.getDraftField(fieldOptions.richTextAttr,fieldOptions)}),{matchHeight:false,hasRawValue:true,rawValue:model.getDraftField(fieldOptions.fieldName,fieldOptions)||""})}$el.inlineEditor(options).on({beginEdit:function(){model.incr("editCount")},cancel:_.bind(function(){this._scheduleResizeLayout();model.decr("editCount")},this),complete:_.bind(function(e,value){var extraOptions={},textEditor;if(fieldOptions.allowMarkdown){textEditor=RB.TextEditorView.getFromInlineEditor($el);extraOptions.richText=textEditor.richText}this._scheduleResizeLayout();model.decr("editCount");model.setDraftField(fieldOptions.fieldName,value,_.defaults({error:function(error){this._formatField(fieldOptions);this._$warning.delay(6e3).fadeOut(400,function(){$(this).hide()}).show().html(error.errorText)},success:function(){this._formatField(fieldOptions);this.showBanner()}},fieldOptions,extraOptions),this)},this),resize:this._checkResizeLayout});this.listenTo(this.model,"change:"+editableProp,function(model,editable){$el.inlineEditor(editable?"enable":"disable")})},_buildAutoComplete:function($el,options){var reviewRequest=this.model.get("reviewRequest");$el.inlineEditor("field").rbautocomplete({formatItem:function(data){var s=data[options.nameKey];if(options.descKey&&data[options.descKey]){s+=" <span>("+_.escape(data[options.descKey])+")</span>"}return s},matchCase:false,multiple:true,parse:function(data){var items=data[options.fieldName],itemsLen=items.length,parsed=[],value,i;for(i=0;i<itemsLen;i++){value=items[i];parsed.push({data:value,value:value[options.nameKey],result:value[options.nameKey]})}return parsed},url:SITE_ROOT+reviewRequest.get("localSitePrefix")+"api/"+(options.resourceName||options.fieldName)+"/",extraParams:options.extraParams,cmp:options.cmp,width:350,error:function(xhr){var text;try{text=$.parseJSON(xhr.responseText).err.msg}catch(e){text="HTTP "+xhr.status+" "+xhr.statusText}alert(text)}}).on("autocompleteshow",function(){var resultsPane=$(".ui-autocomplete-results:not("+":has(.ui-autocomplete-footer))");if(resultsPane.length>0){$("<div/>").addClass("ui-autocomplete-footer").text(gettext("Press Tab to auto-complete.")).appendTo(resultsPane)}})},_checkResizeLayout:function(){if(this._$main.length!==0&&!this._blockResizeLayout){this._resizeLayout()}},_resizeLayout:function(){var $lastContent=this._$main.children(".content:last-child"),$lastFieldContainer=$lastContent.children(".field-container"),$lastEditable=$lastFieldContainer.children(".editable"),lastContentTop=Math.ceil($lastContent.position().top),editor=$lastEditable.inlineEditor("field").data("text-editor"),detailsWidth=300,detailsPadding=10,$detailsBody=$("#review_request_details tbody"),$detailsLabels=$detailsBody.find("th:first-child"),$detailsValues=$detailsBody.find("span"),contentHeight,newEditableHeight,height;this._blockResizeLayout=true;$detailsValues.css("max-width",detailsWidth-$detailsLabels.outerWidth()-detailsPadding*3+"px");this._$main.height("auto");$lastContent.height("auto");$lastEditable.height("auto");if(editor){editor.setSize(null,"auto")}this._$main.outerHeight(this._$extra.offset().top-this._$main.offset().top);height=this._$main.height();if($lastContent.outerHeight()+lastContentTop<height){$lastContent.outerHeight(height-lastContentTop);contentHeight=$lastContent.height()+$lastContent.getExtents("p","t")-Math.ceil($lastFieldContainer.position().top);if($lastEditable.inlineEditor("editing")&&editor){editor.setSize(null,contentHeight-$lastEditable.inlineEditor("buttons").outerHeight(true))}else{newEditableHeight=contentHeight+$lastEditable.getExtents("m","tb");if(newEditableHeight>$lastEditable.outerHeight()){$lastEditable.outerHeight(newEditableHeight)}}}this._blockResizeLayout=false},_scheduleResizeLayout:_.throttle(function(){_.defer(this._checkResizeLayout)},100),_formatField:function(fieldOptions){var formatter=fieldOptions.formatter,$el=this.$(fieldOptions.selector),value=this.model.getDraftField(fieldOptions.fieldName,fieldOptions);if(_.isFunction(formatter)){formatter.call(fieldOptions.context||this,this,value,$el,fieldOptions)}else{$el.text(value)}},_onCloseDiscardedClicked:function(){var confirmText=gettext("Are you sure you want to discard this review request?");if(confirm(confirmText)){this.model.get("reviewRequest").close({type:RB.ReviewRequest.CLOSE_DISCARDED,error:function(model,xhr){this.model.trigger("closeError",xhr.errorText)}},this)}return false},_onCloseSubmittedClicked:function(){var submit=true;if(this.banner){submit=confirm(gettext("You have an unpublished draft. If you close this review request, the draft will be discarded. Are you sure you want to close the review request?"))}if(submit){this.model.get("reviewRequest").close({type:RB.ReviewRequest.CLOSE_SUBMITTED,error:function(model,xhr){this.model.trigger("closeError",xhr.errorText)}},this)}return false},_onDeleteReviewRequestClicked:function(){var dlg=$("<p/>").text(gettext("This deletion cannot be undone. All diffs and reviews will be deleted as well.")).modalBox({title:gettext("Are you sure you want to delete this review request?"),buttons:[$('<input type="button" value="'+gettext("Cancel")+'"/>'),$('<input type="button" value="'+gettext("Delete")+'"/>').click(_.bind(function(){this.model.get("reviewRequest").destroy({buttons:$("input",dlg.modalBox("buttons")),success:function(){window.location=SITE_ROOT}})},this))]});return false},_refreshPage:function(){window.location=this.model.get("reviewRequest").get("reviewURL")}})})();RB.ScreenshotThumbnail=Backbone.View.extend({events:{"click a.delete":"_onDeleteClicked"},render:function(){var self=this;this.model.on("destroy",function(){this.$el.fadeOut(function(){self.remove()})},this);this.$caption=this.$el.find("a.edit").inlineEditor({editIconClass:"rb-icon rb-icon-edit",showButtons:false}).on({beginEdit:function(){self.trigger("beginEdit")},cancel:function(){self.trigger("endEdit")},complete:function(e,value){self.model.ready({ready:function(){self.model.set("caption",value);self.trigger("endEdit");self.model.save()}})}});return this},_onDeleteClicked:function(e){e.preventDefault();e.stopPropagation();this.model.destroy()}});(function(){var BaseImageView,ImageAttachmentView,ImageDifferenceDiffView,ImageOnionDiffView,ImageSplitDiffView,ImageTwoUpDiffView;BaseImageView=Backbone.View.extend({template:null,mode:null,name:null,initialize:function(){this.$commentRegion=null},className:function(){return"image-diff-"+this.mode},render:function(){if(this.template){this.$el.html(this.template(this.model.attributes))}this.loadImages(this.$("img"));return this},loadImages:function(images){var loadsRemaining=images.length;_.each(images,function(image){image.onload=_.bind(function(){loadsRemaining--;console.assert(loadsRemaining>=0);$(image).width(image.width).height(image.height);if(loadsRemaining===0){this.onImagesLoaded();this.trigger("regionChanged")}},this)},this)},getSelectionRegion:function(){var $region=this.$commentRegion,offset=$region.position();offset.left+=$region.getExtents("m","l");return{left:offset.left,top:offset.top,width:$region.width(),height:$region.height()}},onImagesLoaded:function(){}});ImageAttachmentView=BaseImageView.extend({mode:"attachment",tagName:"img",render:function(){this.$el.attr({caption:this.model.get("caption"),src:this.model.get("imageURL")});this.$commentRegion=this.$el;return this}});ImageDifferenceDiffView=BaseImageView.extend({mode:"difference",name:gettext("Difference"),template:_.template(['<div class="image-container">'," <canvas></canvas>","</div>"].join("")),initialize:function(){_super(this).initialize.call(this);this._origImage=null;this._modifiedImage=null},render:function(){this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$("canvas");this._origImage=new Image;this._origImage.src=this.model.get("diffAgainstImageURL");this._modifiedImage=new Image;this._modifiedImage.src=this.model.get("imageURL");this.loadImages([this._origImage,this._modifiedImage]);return this},onImagesLoaded:function(){var origImage=this._origImage,modifiedImage=this._modifiedImage,maxWidth=Math.max(origImage.width,modifiedImage.width),maxHeight=Math.max(origImage.height,modifiedImage.height),$origCanvas=this.$("canvas"),$modifiedCanvas=$("<canvas/>"),origContext=$origCanvas[0].getContext("2d"),modifiedContext=$modifiedCanvas[0].getContext("2d"),origImageData,origPixels,origPixelsLen,modifiedPixels,i;$origCanvas[0].width=maxWidth;$origCanvas[0].height=maxHeight;$modifiedCanvas[0].width=maxWidth;$modifiedCanvas[0].height=maxHeight;origContext.drawImage(origImage,0,0);modifiedContext.drawImage(modifiedImage,0,0);origImageData=origContext.getImageData(0,0,maxWidth,maxHeight);origPixels=origImageData.data;origPixelsLen=origPixels.length;modifiedPixels=modifiedContext.getImageData(0,0,maxWidth,maxHeight).data;for(i=0;i<origPixelsLen;i+=4){origPixels[i]+=modifiedPixels[i]-2*Math.min(origPixels[i],modifiedPixels[i]);origPixels[i+1]+=modifiedPixels[i+1]-2*Math.min(origPixels[i+1],modifiedPixels[i+1]);origPixels[i+2]+=modifiedPixels[i+2]-2*Math.min(origPixels[i+2],modifiedPixels[i+2]);origPixels[i+3]=modifiedPixels[i+3]}origContext.putImageData(origImageData,0,0)}});ImageOnionDiffView=BaseImageView.extend({mode:"onion",name:gettext("Onion Skin"),template:_.template(['<div class="image-containers">',' <div class="orig-image">','  <img caption="<%- caption %>" src="<%- diffAgainstImageURL %>" />'," </div>",' <div class="modified-image">','  <img caption="<%- caption %>" src="<%- imageURL %>" />'," </div>","</div>",'<div class="image-slider"></div>'].join("")),DEFAULT_OPACITY:.25,initialize:function(){_super(this).initialize.call(this);this._$origImage=null;this._$modifiedImage=null;this._$modifiedImageContainer=null},render:function(){_super(this).render.call(this);this.$commentRegion=this.$(".image-containers");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this._$modifiedImageContainer=this._$modifiedImage.parent();this.$(".image-slider").slider({value:this.DEFAULT_OPACITY*100,slide:_.bind(function(event,ui){this.setOpacity(ui.value/100)},this)});this.setOpacity(this.DEFAULT_OPACITY);return this},setOpacity:function(pct){this._$modifiedImageContainer.css("opacity",pct)},onImagesLoaded:function(){var origWidth=this._$origImage.width(),origHeight=this._$origImage.height(),modifiedWidth=this._$modifiedImage.width(),modifiedHeight=this._$modifiedImage.height();this._$origImage.parent().width(origWidth).height(origHeight);this._$modifiedImage.parent().width(modifiedWidth).height(modifiedHeight);this.$(".image-containers").width(Math.max(origWidth,modifiedWidth)).height(Math.max(origHeight,modifiedHeight))}});ImageSplitDiffView=BaseImageView.extend({mode:"split",name:gettext("Split"),template:_.template(['<div class="image-containers">',' <div class="image-diff-split-container-orig">','  <div class="orig-image">','   <img caption="<%- caption %>" src="<%- diffAgainstImageURL %>" />',"  </div>"," </div>",' <div class="image-diff-split-container-modified">','  <div class="modified-image">','   <img caption="<%- caption %>" src="<%- imageURL %>" />',"  </div>"," </div>","</div>",'<div class="image-slider"></div>'].join("")),DEFAULT_SPLIT_PCT:.25,initialize:function(){_super(this).initialize.call(this);this._$modifiedImage=null;this._$origImage=null;this._$origSplitContainer=null;this._$modifiedSplitContainer=null;this._$slider=null;this._maxWidth=0},render:function(){_super(this).render.call(this);this.$commentRegion=this.$(".image-containers");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this._$origSplitContainer=this.$(".image-diff-split-container-orig");this._$modifiedSplitContainer=this.$(".image-diff-split-container-modified");this._$slider=this.$(".image-slider").slider({value:this.DEFAULT_SPLIT_PCT*100,slide:_.bind(function(event,ui){this.setSplitPct(ui.value/100)},this)});return this},setSplitPct:function(pct){this._$origSplitContainer.outerWidth(this._maxWidth*pct);this._$modifiedSplitContainer.outerWidth(this._maxWidth*(1-pct))},onImagesLoaded:function(){var $origImageContainer=this._$origImage.parent(),origWidth=this._$origImage.outerWidth(),origHeight=this._$origImage.height(),modifiedWidth=this._$modifiedImage.outerWidth(),modifiedHeight=this._$modifiedImage.height(),maxHeight=Math.max(origHeight,modifiedHeight),maxOuterHeight=maxHeight+$origImageContainer.getExtents("b","tb");this._maxWidth=Math.max(origWidth,modifiedWidth);$origImageContainer.outerWidth(origWidth).height(origHeight);this._$modifiedImage.parent().outerWidth(modifiedWidth).height(modifiedHeight);this._$origSplitContainer.outerWidth(this._maxWidth).height(maxOuterHeight);this._$modifiedSplitContainer.outerWidth(this._maxWidth).height(maxOuterHeight);this.$(".image-containers").width(this._maxWidth).height(maxHeight);this._$slider.width(this._maxWidth);this.setSplitPct(this.DEFAULT_SPLIT_PCT)}});ImageTwoUpDiffView=BaseImageView.extend({mode:"two-up",name:gettext("Two-Up"),template:_.template(['<div class="image-container image-container-orig">',' <div class="orig-image">','  <img caption="<%- caption %>" src="<%- diffAgainstImageURL %>" />'," </div>","</div>",'<div class="image-container image-container-modified">',' <div class="modified-image">','  <img caption="<%- caption %>" src="<%- imageURL %>" />'," </div>","</div>"].join("")),render:function(){_super(this).render.call(this);this.$commentRegion=this.$(".modified-image img");return this}});RB.ImageReviewableView=RB.FileAttachmentReviewableView.extend({className:"image-review-ui",commentBlockView:RB.RegionCommentBlockView,events:{"click .image-diff-modes a":"_onImageModeClicked","mousedown .selection-container":"_onMouseDown","mouseup .selection-container":"_onMouseUp","mousemove .selection-container":"_onMouseMove"},modeItemTemplate:_.template('<li><a href="#" data-mode="<%- mode %>"><%- name %></a></li>'),ANIM_SPEED_MS:200,initialize:function(options){RB.FileAttachmentReviewableView.prototype.initialize.call(this,options);

_.bindAll(this,"_adjustPos");this._activeSelection={};this._diffModeSelectors={};this._diffModeViews={};this.on("commentBlockViewAdded",function(commentBlockView){this._$selectionArea.append(commentBlockView.$el)},this)},renderContent:function(){var self=this;this._$selectionArea=$("<div/>").addClass("selection-container").hide().proxyTouchEvents();this._$selectionRect=$("<div/>").addClass("selection-rect").prependTo(this._$selectionArea).proxyTouchEvents().hide();if(!this.renderedInline){this.$el.append($('<h1 class="caption"/>').text(this.model.get("caption")))}this.$el.hover(function(){self._$selectionArea.show();self._adjustPos()},function(){if(self._$selectionRect.is(":hidden")&&!self.commentDlg){self._$selectionArea.hide()}}).append(this._$selectionArea);if(this.model.get("diffAgainstFileAttachmentID")){this._$modeBar=$('<ul class="image-diff-modes"/>').appendTo(this.$el);this._$imageDiffs=$('<div class="image-diffs"/>');this._addDiffMode(ImageTwoUpDiffView);this._addDiffMode(ImageDifferenceDiffView);this._addDiffMode(ImageSplitDiffView);this._addDiffMode(ImageOnionDiffView);this.$el.append(this._$imageDiffs);this._setDiffMode(ImageTwoUpDiffView.prototype.mode)}else{this._imageView=new ImageAttachmentView({model:this.model});this._imageView.$el.appendTo(this.$el);this._imageView.render()}$(window).resize(this._adjustPos).load(this._adjustPos);return this},_addDiffMode:function(ViewClass){var mode=ViewClass.prototype.mode,view=new ViewClass({model:this.model}),$selector=$(this.modeItemTemplate({mode:mode,name:view.name})),selectorWidth;this._diffModeViews[mode]=view;view.$el.hide();this._$imageDiffs.append(view.$el);view.render();$selector.appendTo(this._$modeBar).addClass("selected");selectorWidth=$selector.width();$selector.removeClass("selected").width(selectorWidth);this._diffModeSelectors[mode]=$selector},_setDiffMode:function(mode){var newView=this._diffModeViews[mode],height;if(this._imageView){this._diffModeSelectors[this._imageView.mode].removeClass("selected");this._diffModeSelectors[newView.mode].addClass("selected");newView.$el.show();height=newView.$el.height();newView.$el.hide();this._$imageDiffs.animate({height:height,duration:this.ANIM_SPEED_MS});this._$selectionArea.fadeOut(this.ANIM_SPEED_MS);this._imageView.$el.fadeOut(this.ANIM_SPEED_MS,_.bind(function(){this._showDiffMode(newView,true)},this))}else{this._showDiffMode(newView)}},_showDiffMode:function(newView,animate){if(this._imageView){this.stopListening(this._imageView,"regionChanged")}this._imageView=newView;if(animate){this._imageView.$el.fadeIn(this.ANIM_SPEED_MS);this._$selectionArea.fadeIn(this.ANIM_SPEED_MS)}else{this._imageView.$el.show();this._$selectionArea.show()}this.listenTo(this._imageView,"regionChanged",this._adjustPos);this._adjustPos()},_onImageModeClicked:function(e){e.preventDefault();e.stopPropagation();this._setDiffMode($(e.target).data("mode"))},_onMouseDown:function(evt){if(evt.which===1&&!this.commentDlg&&!$(evt.target).hasClass("selection-flag")){var offset=this._$selectionArea.offset();this._activeSelection.beginX=evt.pageX-Math.floor(offset.left)-1;this._activeSelection.beginY=evt.pageY-Math.floor(offset.top)-1;this._$selectionRect.move(this._activeSelection.beginX,this._activeSelection.beginY).width(1).height(1).show();if(this._$selectionRect.is(":hidden")){this.commentDlg.close()}return false}},_onMouseUp:function(evt){if(!this.commentDlg&&this._$selectionRect.is(":visible")){var width=this._$selectionRect.width(),height=this._$selectionRect.height(),offset=this._$selectionRect.position();evt.stopPropagation();this._$selectionRect.hide();if(width>5&&height>5){this.createAndEditCommentBlock({x:Math.floor(offset.left),y:Math.floor(offset.top),width:width,height:height})}}},_onMouseMove:function(evt){if(!this.commentDlg&&this._$selectionRect.is(":visible")){var offset=this._$selectionArea.offset(),x=evt.pageX-Math.floor(offset.left)-1,y=evt.pageY-Math.floor(offset.top)-1;this._$selectionRect.css(this._activeSelection.beginX<=x?{left:this._activeSelection.beginX,width:x-this._activeSelection.beginX}:{left:x,width:this._activeSelection.beginX-x}).css(this._activeSelection.beginY<=y?{top:this._activeSelection.beginY,height:y-this._activeSelection.beginY}:{top:y,height:this._activeSelection.beginY-y});return false}},_adjustPos:function(){var region=this._imageView.getSelectionRegion();this._$selectionArea.width(region.width).height(region.height).css({left:region.left,top:region.top})}})})();RB.TextBasedCommentBlockView=RB.AbstractCommentBlockView.extend({tagName:"span",className:"commentflag",template:_.template(['<span class="commentflag-shadow"></span>','<span class="commentflag-inner">',' <span class="commentflag-count"></span>',"</span>",'<a name="<%= anchorName %>" class="commentflag-anchor"></a>'].join("")),initialize:function(){this.$beginRow=null;this.$endRow=null;_.bindAll(this,"_updateSize")},renderContent:function(){this.$el.html(this.template(_.defaults(this.model.attributes,{anchorName:this.buildAnchorName()})));this.$(".commentflag-count").bindProperty("text",this.model,"count",{elementToModel:false});$(window).on("resize",this._updateSize)},remove:function(){Backbone.View.prototype.remove.call(this);$(window).off("resize",this._updateSize)},setRows:function($beginRow,$endRow){this.$beginRow=$beginRow;this.$endRow=$endRow;this._updateSize()},positionCommentDlg:function(commentDlg){commentDlg.$el.css({left:$(document).scrollLeft()+($(window).width()-commentDlg.$el.width())/2,top:this.$endRow.offset().top+this.$endRow.height()})},positionNotifyBubble:function($bubble){$bubble.css({left:this.$el.width(),top:0})},buildAnchorName:function(){return"line"+this.model.get("beginLineNum")},_updateSize:function(){if(this.$beginRow&&this.$endRow){this.$el.height(this.$endRow.offset().top+this.$endRow.outerHeight()-this.$beginRow.offset().top-(this.$el.getExtents("m","t")||-4))}}});RB.TextBasedReviewableView=RB.FileAttachmentReviewableView.extend({commentBlockView:RB.TextBasedCommentBlockView,initialize:function(options){RB.FileAttachmentReviewableView.prototype.initialize.call(this,options);this._$viewTabs=null;this._$textTable=null;this._$renderedTable=null;this._textSelector=null;this._renderedSelector=null;this.on("commentBlockViewAdded",this._placeCommentBlockView,this);this.router=new Backbone.Router({routes:{":viewMode(/line:lineNum)":"viewMode"}});this.listenTo(this.router,"route:viewMode",function(viewMode,lineNum){if(viewMode.indexOf("line")===0){lineNum=viewMode.substr(4);viewMode=null}if(viewMode){this.model.set("viewMode",viewMode)}if(lineNum){this._scrollToLine(lineNum)}})},remove:function(){_super(this).remove.call(this);this._textSelector.remove();this._renderedSelector.remove()},renderContent:function(){this._$viewTabs=this.$(".text-review-ui-views li");this._$textTable=this.$(".text-review-ui-text-table");this._textSelector=new RB.TextCommentRowSelector({el:this._$textTable,reviewableView:this});this._textSelector.render();if(this.model.get("hasRenderedView")){this._$renderedTable=this.$(".text-review-ui-rendered-table");this._renderedSelector=new RB.TextCommentRowSelector({el:this._$renderedTable,reviewableView:this});this._renderedSelector.render()}this.listenTo(this.model,"change:viewMode",this._onViewChanged);Backbone.history.start({root:window.location})},_scrollToLine:function(lineNum){var $table=this._getTableForViewMode(this.model.get("viewMode")),rows=$table[0].tBodies[0].rows,$row;lineNum--;lineNum=Math.max(0,Math.min(lineNum,rows.length-1));$row=$($table[0].tBodies[0].rows[lineNum]);$(window).scrollTop($row.offset().top)},_getTableForViewMode:function(viewMode){if(viewMode==="source"){return this._$textTable}else if(viewMode==="rendered"&&this.model.get("hasRenderedView")){return this._$renderedTable}else{console.assert(false,"Unexpected viewMode "+viewMode);return null}},_placeCommentBlockView:function(commentBlockView){var commentBlock=commentBlockView.model,beginLineNum=commentBlock.get("beginLineNum"),endLineNum=commentBlock.get("endLineNum"),$table,viewMode,rows;if(beginLineNum&&endLineNum){viewMode=commentBlock.get("viewMode");$table=this._getTableForViewMode(viewMode);if($table!==null){rows=$table[0].tBodies[0].rows;commentBlockView.setRows($(rows[beginLineNum-1]),$(rows[endLineNum-1]));commentBlockView.$el.appendTo(commentBlockView.$beginRow[0].cells[0])}}},_onViewChanged:function(){var viewMode=this.model.get("viewMode");this._$viewTabs.removeClass("active").filter("[data-view-mode="+viewMode+"]").addClass("active");this._$textTable.setVisible(viewMode==="source");this._$renderedTable.setVisible(viewMode==="rendered");$(window).triggerHandler("resize")}});(function(){RB.TextCommentRowSelector=Backbone.View.extend({ghostCommentFlagTemplate:_.template(['<span class="commentflag ghost-commentflag">',' <span class="commentflag-shadow"></span>',' <span class="commentflag-inner"></span>',"</span>"].join("")),events:{copy:"_onCopy",mousedown:"_onMouseDown",mouseup:"_onMouseUp",mouseover:"_onMouseOver",mouseout:"_onMouseOut",touchmove:"_onTouchMove",touchcancel:"_onTouchCancel"},initialize:function(){this._$begin=null;this._$end=null;this._beginLineNum=0;this._endLineNum=0;this._lastSeenIndex=0;this._selectionClass=null;this._supportsSetClipboard=window.getSelection!==undefined&&window.Range!==undefined&&window.Range.prototype.cloneContents!==undefined;this._newlineChar=null;this._$ghostCommentFlag=null;this._$ghostCommentFlagCell=null},remove:function(){Backbone.View.prototype.remove.call(this);this._$ghostCommentFlag.remove()},render:function(){this._$ghostCommentFlag=$(this.ghostCommentFlagTemplate()).on({mousedown:_.bind(this._onMouseDown,this),mouseup:_.bind(this._onMouseUp,this),mouseover:_.bind(this._onMouseOver,this),mouseout:_.bind(this._onMouseOut,this)}).hide().appendTo("body");return this},createComment:function(beginLineNum,endLineNum,beginNode,endNode){this._beginLineNum=beginLineNum;this._endLineNum=endLineNum;this._$begin=this._getActualLineNumCell($(beginNode)).parent();this._$end=this._getActualLineNumCell($(endNode)).parent();if(this._isLineNumCell(endNode)){this._end(this._getActualLineNumCell($(endNode)).parent())}this._reset()},_begin:function($row){var lineNum=this.getLineNum($row[0]);this._$begin=$row;this._$end=$row;this._beginLineNum=lineNum;this._endLineNum=lineNum;this._lastSeenIndex=$row[0].rowIndex;$row.addClass("selected");this.$el.disableSelection()},_end:function($row){var $commentFlag;if(this._beginLineNum===this._endLineNum){$commentFlag=$row.find(".commentflag");if($commentFlag.length===1){$commentFlag.click();return}}this.options.reviewableView.createAndEditCommentBlock({beginLineNum:this._beginLineNum,endLineNum:this._endLineNum,$beginRow:this._$begin,$endRow:this._$end})},_addRow:function($row){var lineNum,min,max,i;lineNum=this.getLineNum($row[0]);if(lineNum<this._beginLineNum){this._$begin=$row;this._beginLineNum=lineNum}else if(lineNum>this._beginLineNum){this._$end=$row;this._endLineNum=lineNum}min=Math.min(this._lastSeenIndex,$row[0].rowIndex);max=Math.max(this._lastSeenIndex,$row[0].rowIndex);for(i=min;i<=max;i++){$(this.el.rows[i]).addClass("selected")}this._lastSeenIndex=$row[0].rowIndex},_highlightRow:function($row){var $lineNumCell=$($row[0].cells[0]);if($lineNumCell.find(".commentflag").length===0){this._$ghostCommentFlag.css("top",$row.offset().top-1).show().parent().removeClass("selected");this._$ghostCommentFlagCell=$lineNumCell}$row.addClass("selected")},_removeOldRows:function($row){var destRowIndex=$row[0].rowIndex;if(destRowIndex>=this._$begin[0].rowIndex){if(this._lastSeenIndex!==this._$end[0].rowIndex&&this._lastSeenIndex<destRowIndex){this._removeSelectionClasses(this._lastSeenIndex,destRowIndex);this._$begin=$row;this._beginLineNum=this.getLineNum($row[0])}else{this._removeSelectionClasses(destRowIndex,this._lastSeenIndex);this._$end=$row;this._endLineNum=this.getLineNum($row[0])}this._lastSeenIndex=destRowIndex}},_reset:function(){if(this._$begin){this._removeSelectionClasses(this._$begin[0].rowIndex,this._$end[0].rowIndex);this._$begin=null;this._$end=null;this._beginLineNum=0;this._endLineNum=0;this._lastSeenIndex=0}this._$ghostCommentFlagCell=null;this.$el.enableSelection()},_removeSelectionClasses:function(startRowIndex,endRowIndex){var i;for(i=startRowIndex;i<=endRowIndex;i++){$(this.el.rows[i]).removeClass("selected")}},_isLineNumCell:function(cell){return cell.tagName==="TH"&&cell.parentNode.getAttribute("line")},_getActualLineNumCell:function($node){if($node.hasClass("commentflag")){if($node[0]===this._$ghostCommentFlag[0]){$node=this._$ghostCommentFlagCell}else{$node=$node.parent()}}return $node},_onCopy:function(e){var clipboardData=e.originalEvent.clipboardData||window.clipboardData;if(clipboardData&&this._supportsSetClipboard&&this._copySelectionToClipboard(clipboardData)){return false}},_copySelectionToClipboard:function(clipboardData){var sel=window.getSelection(),s="",tdClass,range,doc,nodes,i,j;if(this._newlineChar===null){if(navigator.appVersion.indexOf("Win")!==-1){this._newlineChar="\r\n"}else{this._newlineChar="\n"}}if(this._selectedCellIndex===3||this.$el.hasClass("newfile")){tdClass="r"}else{tdClass="l"}for(i=0;i<sel.rangeCount;i++){range=sel.getRangeAt(i);if(range.collapsed){continue}doc=range.cloneContents();nodes=doc.querySelectorAll("td."+tdClass+" pre");if(nodes.length>0){for(j=0;j<nodes.length;j++){s+=nodes[j].textContent;if(j<nodes.length-1||range.endContainer.nodeType===Node.ELEMENT_NODE&&range.endOffset>0){s+=this._newlineChar}}}else if(sel.rangeCount===1){s=$(doc).text();break}}try{clipboardData.setData("text",s)}catch(e){this._supportsSetClipboard=false;return false}return true},_onMouseDown:function(e){var node=e.target,$node;if(this._selectionClass){this.$el.removeClass(this._selectionClass)}if(this._$ghostCommentFlagCell){node=this._$ghostCommentFlagCell[0]}if(this._isLineNumCell(node)){this._begin($(node.parentNode));return false}else{if(node.tagName==="TD"){$node=$(node)}else{$node=$(node).parentsUntil("tr","td")}if($node.length>0){this._selectionClass="selecting-col-"+$node[0].cellIndex;this._selectedCellIndex=$node[0].cellIndex;this.$el.addClass(this._selectionClass)}}return true},_onMouseUp:function(e){var node=e.target;e.preventDefault();if(this._$ghostCommentFlagCell){node=this._$ghostCommentFlagCell[0]}if(this._isLineNumCell(node)){this._end(this._getActualLineNumCell($(node)).parent());e.stopImmediatePropagation()}this._reset()},_onMouseOver:function(e){var $node=this._getActualLineNumCell($(e.target)),$row=$node.parent();if(this._isLineNumCell($node[0])){if(this._$begin){this._addRow($row)}else{this._highlightRow($row)}}else if(this._$ghostCommentFlagCell&&$node[0]!==this._$ghostCommentFlagCell[0]){$row.removeClass("selected")}},_onMouseOut:function(e){var relTarget=e.relatedTarget,$node=this._getActualLineNumCell($(e.target));if(relTarget!==this._$ghostCommentFlag[0]){this._$ghostCommentFlag.hide();this._$ghostCommentFlagCell=null}if(this._$begin){if(relTarget&&this._isLineNumCell(relTarget)){this._removeOldRows($(relTarget.parentNode))}}else if($node&&this._isLineNumCell($node[0])){$node.parent().removeClass("selected")}},_onTouchMove:function(e){var firstTouch=e.originalEvent.targetTouches[0],target=document.elementFromPoint(firstTouch.pageX,firstTouch.pageY),$node=this._getActualLineNumCell($(target)),$row=node.parent();if(this._lastSeenIndex!==$row[0].rowIndex&&this._isLineNumCell($node[0])){this._removeOldRows($row);this._addRow($row)}},_onTouchCancel:function(){this._reset()},getLineNum:function(row){return parseInt(row.getAttribute("line"),10)}})})();RB.MarkdownReviewableView=RB.TextBasedReviewableView.extend({className:"markdown-review-ui"});RB.DiffCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({fileDiffID:null,interFileDiffID:null,beginLineNum:null,endLineNum:null,$beginRow:null,$endRow:null},RB.AbstractCommentBlock.prototype.defaults),getNumLines:function(){return this.get("endLineNum")+this.get("beginLineNum")+1},createComment:function(id){return this.get("review").createDiffComment(id,this.get("fileDiffID"),this.get("interFileDiffID"),this.get("beginLineNum"),this.get("endLineNum"))}});RB.DiffCommentsHint=Backbone.Model.extend({defaults:{hasOtherComments:false,diffsetsWithComments:[],interdiffsWithComments:[]},parse:function(rsp){return{hasOtherComments:rsp.has_other_comments,diffsetsWithComments:_.map(rsp.diffsets_with_comments,function(diffset){return{revision:diffset.revision,isCurrent:diffset.is_current}}),interdiffsWithComments:_.map(rsp.interdiffs_with_comments,function(interdiff){return{oldRevision:interdiff.old_revision,newRevision:interdiff.new_revision,isCurrent:interdiff.is_current}})}}});RB.DiffFile=Backbone.Model.extend({defaults:{binary:false,commentCounts:null,deleted:false,depotFilename:null,destFilename:null,destRevision:null,filediff:null,index:null,interfilediff:null,newfile:false,forceInterdiff:null,forceInterdiffRevision:null},parse:function(rsp){return{binary:rsp.binary,commentCounts:rsp.comment_counts,deleted:rsp.deleted,depotFilename:rsp.depot_filename,destFilename:rsp.dest_filename,destRevision:rsp.dest_revision,filediff:rsp.filediff,id:rsp.id,index:rsp.index,interfilediff:rsp.interfilediff,newfile:rsp.newfile,revision:rsp.revision,forceInterdiff:rsp.force_interdiff,forceInterdiffRevision:rsp.interdiff_revision}}});RB.DiffReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({fileIndex:null,fileDiffID:null,interFileDiffID:null,revision:null,interdiffRevision:null},RB.AbstractReviewable.prototype.defaults),commentBlockModel:RB.DiffCommentBlock,defaultCommentBlockFields:["fileDiffID","interFileDiffID"],loadSerializedCommentBlock:function(serializedCommentBlock){this.createCommentBlock({reviewRequest:this.get("reviewRequest"),review:this.get("review"),fileDiffID:this.get("fileDiffID"),interFileDiffID:this.get("interFileDiffID"),beginLineNum:serializedCommentBlock.linenum,endLineNum:serializedCommentBlock.linenum+serializedCommentBlock.num_lines-1,serializedComments:serializedCommentBlock.comments||[]})},getRenderedDiff:function(callbacks,context){this._fetchFragment({url:this._buildRenderedDiffURL()+"?index="+this.get("fileIndex")+"&"+TEMPLATE_SERIAL,noActivityIndicator:true},callbacks,context)},getRenderedDiffFragment:function(options,callbacks,context){console.assert(options.chunkIndex!==undefined,"chunkIndex must be provided");this._fetchFragment({url:this._buildRenderedDiffURL()+"chunk/"+options.chunkIndex+"/",data:{index:this.get("fileIndex"),"lines-of-context":options.linesOfContext}},callbacks,context)},_fetchFragment:function(options,callbacks,context){RB.apiCall(_.defaults({type:"GET",dataType:"html"},options,_.bindCallbacks(callbacks,context)))},_buildRenderedDiffURL:function(){var revisionStr,interdiffRevision=this.get("interdiffRevision"),interFileDiffID=this.get("interFileDiffID");revisionStr=this.get("revision");if(interdiffRevision){revisionStr+="-"+interdiffRevision}return this.get("reviewRequest").get("reviewURL")+"diff/"+revisionStr+"/fragment/"+this.get("fileDiffID")+(interFileDiffID?"-"+interFileDiffID:"")+"/"}});RB.DiffRevision=Backbone.Model.extend({defaults:{revision:null,interdiffRevision:null,latestRevision:null,isInterdiff:false,isDraftDiff:false},parse:function(rsp){return{revision:rsp.revision,interdiffRevision:rsp.interdiff_revision,latestRevision:rsp.latest_revision,isInterdiff:rsp.is_interdiff,isDraftDiff:rsp.is_draft_diff}}});RB.Pagination=Backbone.Model.extend({defaults:{isPaginated:false,pages:0,hasPrevious:false,hasNext:false,pageNumbers:[],previousPage:null,nextPage:null,currentPage:null},parse:function(rsp){return{isPaginated:rsp.is_paginated,pages:rsp.pages,hasPrevious:rsp.has_previous,hasNext:rsp.has_next,pageNumbers:rsp.page_numbers,previousPage:rsp.previous_page,nextPage:rsp.next_page,currentPage:rsp.current_page}}});RB.DiffFileCollection=Backbone.Collection.extend({model:RB.DiffFile});RB.ChunkHighlighterView=Backbone.View.extend({className:"diff-highlight",initialize:function(){this._$top=null;this._$bottom=null;this._$left=null;this._$right=null;this._borderWidth=null;this._borderHeight=null;this._borderOffsetX=null;this._borderOffsetY=null;this._resetState();_.bindAll(this,"_queueUpdatePosition","_updatePosition")},render:function(){var $border=$('<div class="diff-highlight-border"/>');this._$top=$border.clone().appendTo(this.$el);this._$bottom=$border.clone().appendTo(this.$el);this._$left=$border.clone().appendTo(this.$el);this._$right=$border.clone().appendTo(this.$el);this._borderWidth=this._$left.width();this._borderHeight=this._$top.height();this._borderOffsetX=this._borderWidth/2;this._borderOffsetY=this._borderHeight/2;if($.browser.msie){if($.browser.version<=9){this._borderOffsetY=0}else{this._borderOffsetY=this._borderHeight}if($.browser.version===8){this._borderOffsetX=-this._borderOffsetX}}$(window).on("resize."+this.cid,_.bind(function(){_.defer(this._updatePosition)},this));return this},remove:function(){_super(this).remove.call(this);$(window).off(this.cid)},highlight:function($chunk){this._resetState();this._$chunk=$chunk;this._queueUpdatePosition()},_resetState:function(){this._$chunk=null;this._oldTop=null;this._oldWidth=null;this._oldHeight=null},_updatePosition:function(e){var $container,offset,top,width,height,outerHeight,outerWidth,outerTop;if(e&&e.target&&e.target!==window&&!e.target.getElementsByTagName){return}offset=this._$chunk.position();if(!offset){return}$container=this._$chunk.parents(".diff-container");this.$el.remove().appendTo($container);top=Math.floor(offset.top);width=$container.outerWidth();height=this._$chunk.outerHeight();if(top===this._oldTop&&width===this._oldWidth&&height===this._oldHeight){return}outerHeight=height+this._borderOffsetX;outerWidth=width-this._borderWidth;outerTop=top-this._borderOffsetY;this._$left.css({left:0,top:outerTop,height:outerHeight});this._$top.css({left:0,top:outerTop,width:outerWidth});this._$right.css({left:outerWidth,top:outerTop,height:outerHeight});this._$bottom.css({left:0,top:outerTop+outerHeight,width:outerWidth+this._borderWidth});this._oldTop=top;this._oldWidth=width;this._oldHeight=height},_queueUpdatePosition:_.debounce(function(e){this._updatePosition(e)},50)},{_instance:null,highlight:function($chunk){if(!$chunk||$chunk.length===0){return}if(!this._instance){this._instance=new RB.ChunkHighlighterView;this._instance.$el.appendTo($("#diffs"));this._instance.render()}this._instance.highlight($chunk)}});RB.DiffCommentBlockView=RB.TextBasedCommentBlockView.extend({buildAnchorName:function(){return"file"+this.model.get("fileDiffID")+"line"+this.model.get("beginLineNum")}});RB.DiffCommentsHintView=Backbone.View.extend({events:{"click .revision":"_onRevisionSelected","click .interdiff":"_onInterdiffSelected"},template:_.template(['<div class="box-container">',' <div class="box important">','  <div class="box-inner comments-hint">',"   <h1><%- unpublishedCommentsHeader %></h1>","   <p><%- unpublishedCommentsText %></p>","   <ul>","   </ul>","  </div>"," </div>","</div>"].join("")),initialize:function(){this.listenTo(this.model,"change",this.render)},render:function(){var revisionText=gettext("Revision %s"),interdiffText=gettext("Interdiff revision %(oldRevision)s - %(newRevision)s"),$ul,$li;if(this.model.get("hasOtherComments")){this.$el.html(this.template({unpublishedCommentsHeader:gettext("You have unpublished comments on other revisions"),unpublishedCommentsText:gettext("Your review consists of comments on the following revisions:")}));$ul=this.$("ul");_.each(this.model.get("diffsetsWithComments"),function(diffset){$li=$("<li/>").addClass("revision").data("revision",diffset.revision).text(interpolate(revisionText,[diffset.revision])).appendTo($ul);if(diffset.isCurrent){$li.addClass("current")}});_.each(this.model.get("interdiffsWithComments"),function(interdiff){$li=$("<li/>").addClass("interdiff").data({"first-revision":interdiff.oldRevision,"second-revision":interdiff.newRevision}).text(interpolate(interdiffText,{oldRevision:interdiff.oldRevision,newRevision:interdiff.newRevision},true)).appendTo($ul);if(interdiff.isCurrent){$li.addClass("current")}})}else{this.$el.empty()}return this},_onRevisionSelected:function(ev){var $target=$(ev.currentTarget);if(!$target.hasClass("current")){this.trigger("revisionSelected",0,$target.data("revision"))}},_onInterdiffSelected:function(ev){var $target=$(ev.currentTarget);if(!$target.hasClass("current")){this.trigger("revisionSelected",$target.data("first-revision"),$target.data("second-revision"))}}});RB.DiffComplexityIconView=Backbone.View.extend({initialize:function(options){this.numInserts=options.numInserts||0;this.numDeletes=options.numDeletes||0;this.numReplaces=options.numReplaces||0;this.totalLines=options.totalLines||null},render:function(){var numTotal=this.numInserts+this.numDeletes+this.numReplaces,minValue=numTotal*.15,innerRadius=.5*(this.totalLines===null?1:(this.totalLines-numTotal)/this.totalLines),iconColors=RB.DiffComplexityIconView.getIconColors();this.$el.width(20).height(20).plot([{color:iconColors.insertColor,data:this._clampValue(this.numInserts,minValue)},{color:iconColors.deleteColor,data:this._clampValue(this.numDeletes,minValue)},{color:iconColors.replaceColor,data:this._clampValue(this.numReplaces,minValue)}],{series:{pie:{show:true,innerRadius:innerRadius,radius:.8}}});return this},_clampValue:function(val,minValue){return val===0?0:Math.max(val,minValue)}},{_iconColors:null,getIconColors:function(){var $iconColor;if(!this._iconColors){this._iconColors={};$iconColor=$("<div/>").appendTo(document.body);$iconColor[0].className="diff-changes-icon-insert";this._iconColors.insertColor=$iconColor.css("color");$iconColor[0].className="diff-changes-icon-replace";this._iconColors.replaceColor=$iconColor.css("color");$iconColor[0].className="diff-changes-icon-delete";this._iconColors.deleteColor=$iconColor.css("color");$iconColor.remove()}return this._iconColors}});RB.DiffFileIndexView=Backbone.View.extend({chunkTemplate:_.template('<a href="#<%= chunkID %>" class="<%= className %>"> </a>'),events:{"click a":"_onAnchorClicked"},initialize:function(){this._$items=null;this._$itemsTable=null;this.collection=this.options.collection;this.listenTo(this.collection,"update",this.update)},render:function(){this._$itemsTable=$("<table/>").appendTo(this.el);this._$items=this.$("tr");this.update();return this},_itemTemplate:_.template(['<tr class="loading<%',' if (newfile) { print(" new-file"); }',' if (binary) { print(" binary-file"); }',' if (deleted) { print(" deleted-file"); }',' if (destFilename !== depotFilename) { print(" renamed-file"); }',' %>">',' <td class="diff-file-icon"></td>',' <td class="diff-file-info">','  <a href="#<%- index %>"><%- destFilename %></a>',"  <% if (destFilename !== depotFilename) { %>",'  <span class="diff-file-rename"><%- wasText %></span>',"  <% } %>"," </td>",' <td class="diff-chunks-cell">',"  <% if (binary) { %>","   <%- binaryFileText %>","  <% } else if (deleted) { %>","   <%- deletedFileText %>","  <% } else { %>",'   <div class="diff-chunks"></div>',"  <% } %>"," </td>","</tr>"].join("")),update:function(){this._$itemsTable.empty();this.collection.each(function(file){this._$itemsTable.append(this._itemTemplate(_.defaults({binaryFileText:gettext("Binary file"),deletedFileText:gettext("Deleted"),wasText:interpolate(gettext("Was %s"),[file.get("depotFilename")])},file.attributes)))},this);this._$items=this.$("tr")},addDiff:function(index,diffReviewableView){var $item=$(this._$items[index]).removeClass("loading");if(diffReviewableView.$el.hasClass("diff-error")){this._renderDiffError($item)}else{this._renderDiffEntry($item,diffReviewableView)}},_renderDiffError:function($item){var $fileIcon=$item.find(".diff-file-icon");$('<div class="rb-icon rb-icon-warning"/>').appendTo($fileIcon);$fileIcon.attr("title",gettext("There was an error loading this diff. See the details below."))},_renderDiffEntry:function($item,diffReviewableView){var $table=diffReviewableView.$el,fileDeleted=$item.hasClass("deleted-file"),fileAdded=$item.hasClass("new-file"),linesEqual=$table.data("lines-equal"),numDeletes=0,numInserts=0,numReplaces=0,chunksList=[],iconView,$fileIcon=$item.find(".diff-file-icon"),tooltip="",tooltipParts=[];if(fileAdded){numInserts=1}else if(fileDeleted){numDeletes=1}else if($item.hasClass("binary-file")){numReplaces=1}else{_.each($table.children("tbody"),function(chunk){var numRows=chunk.rows.length,$chunk=$(chunk);if($chunk.hasClass("delete")){numDeletes+=numRows}else if($chunk.hasClass("insert")){numInserts+=numRows}else if($chunk.hasClass("replace")){numReplaces+=numRows}else{return}chunksList.push(this.chunkTemplate({chunkID:chunk.id.substr(5),className:chunk.className}))},this);$item.find(".diff-chunks").html(chunksList.join(""))}iconView=new RB.DiffComplexityIconView({numInserts:numInserts,numDeletes:numDeletes,numReplaces:numReplaces,totalLines:linesEqual+numDeletes+numInserts+numReplaces});iconView.$el.appendTo($fileIcon);iconView.render();if(fileAdded){tooltip=gettext("New file")}else if(fileDeleted){tooltip=gettext("Deleted file")}else{if(numInserts>0){tooltipParts.push(interpolate(ngettext("%d new line","%d new lines",numInserts),[numInserts]))}if(numReplaces>0){tooltipParts.push(interpolate(ngettext("%d line changed","%d lines changed",numReplaces),[numReplaces]))}if(numDeletes>0){tooltipParts.push(interpolate(ngettext("%d line removed","%d lines removed",numDeletes),[numDeletes]))}tooltip=tooltipParts.join(", ")}$fileIcon.attr("title",tooltip);this.listenTo(diffReviewableView,"chunkDimmed chunkUndimmed",function(chunkID){this.$('a[href="#'+chunkID+'"]').toggleClass("dimmed")})},_onAnchorClicked:function(e){e.preventDefault();this.trigger("anchorClicked",e.target.href.split("#")[1])}});(function(){RB.DiffReviewableView=RB.AbstractReviewableView.extend({tagName:"table",commentBlockView:RB.DiffCommentBlockView,commentsListName:"diff_comments",cssTemplate:_.template(["#<%= id %> td pre,","#<%= id %> .revision-row th.revision-col {","    min-width: <%= minColWidth %>px;","    max-width: <%= maxColWidth %>px;","}","#<%= id %> .filename-row th {","    min-width: <%= minFilenameWidth %>px;","    max-width: <%= maxFilenameWidth %>px;","}"].join("\n")),events:{"click .download-link":"_onDownloadLinkClicked","click thead tr":"_onFileHeaderClicked","click .moved-to, .moved-from":"_onMovedLineClicked","click .diff-collapse-btn":"_onCollapseChunkClicked","click .diff-expand-btn":"_onExpandChunkClicked",mouseup:"_onMouseUp"},initialize:function(){_super(this).initialize.call(this);_.bindAll(this,"_updateCollapseButtonPos","_onWindowResize");this._selector=new RB.TextCommentRowSelector({el:this.el,reviewableView:this});this._hiddenCommentBlockViews=[];this._visibleCommentBlockViews=[];this._$collapseButtons=$();this._$filenameRow=null;this._$revisionRow=null;this._$css=null;this._filenameReservedWidths=0;this._colReservedWidths=0;this._numColumns=0;this._numFilenameColumns=0;this._prevContentWidth=null;this._$window=$(window);this._$parent=this.$el.parent();this.on("commentBlockViewAdded",this._placeCommentBlockView,this)},remove:function(){RB.AbstractReviewableView.prototype.remove.call(this);this._$window.off("scroll",this._updateCollapseButtonPos);this._$window.off("resize",this._onWindowResize);this._selector.remove()},render:function(){var $thead;_super(this).render.call(this);$thead=this.$("thead");this._$revisionRow=$thead.find(".revision-row");this._$filenameRow=$thead.find(".filename-row");this._$css=$("<style/>").appendTo(this.$el);this._selector.render();_.each(this.$el.children("tbody.binary"),function(thumbnailEl){var $thumbnail=$(thumbnailEl),id=$thumbnail.data("file-id"),$caption=$thumbnail.find(".file-caption .edit"),reviewRequest=this.model.get("reviewRequest"),fileAttachment=reviewRequest.createFileAttachment({id:id});if(!$caption.hasClass("empty-caption")){fileAttachment.set("caption",$caption.text())}},this);this._precalculateContentWidths();this._updateColumnSizes();

this._$window.on("scroll",this._updateCollapseButtonPos);this._$window.on("resize",this._onWindowResize);return this},toggleWhitespaceOnlyChunks:function(){this.$("tbody tr.whitespace-line").toggleClass("dimmed");_.each(this.$el.children("tbody.whitespace-chunk"),function(chunk){var $chunk=$(chunk),dimming=$chunk.hasClass("replace"),chunkID=chunk.id.split("chunk")[1],$children=$chunk.children();$chunk.toggleClass("replace");$($children[0]).toggleClass("first");$($children[$children.length-1]).toggleClass("last");if(dimming){this.trigger("chunkDimmed",chunkID)}else{this.trigger("chunkUndimmed",chunkID)}},this);this.$el.children("tbody.whitespace-file").siblings("tbody").addBack().toggle()},createComment:function(beginLineNum,endLineNum,beginNode,endNode){this._selector.createComment(beginLineNum,endLineNum,beginNode,endNode)},_findLineNumRow:function(lineNum,startRow,endRow){var row=null,table=this.el,rowOffset=1,guessRowNum,guessRow,oldHigh,oldLow,high,low,value,found,i,j;if(table.rows.length-rowOffset>lineNum){row=table.rows[rowOffset+lineNum];if(row&&this.getLineNum(row)===lineNum){return row}}if(startRow){startRow-=rowOffset}low=startRow||1;high=Math.min(endRow||table.rows.length,table.rows.length);if(endRow!==undefined&&endRow<table.rows.length){if(this.getLineNum(table.rows[endRow])===lineNum){return table.rows[endRow]}}else if(row){high=Math.min(high,rowOffset+lineNum)}for(i=Math.round((low+high)/2);low<high-1;){row=table.rows[rowOffset+i];if(!row){high--;i=Math.round((low+high)/2);continue}value=this.getLineNum(row);if(!value){found=false;for(j=1;j<=(high-low)/2;j++){row=table.rows[rowOffset+i+j];if(row&&this.getLineNum(row)){i=i+j;found=true;break}else{row=table.rows[rowOffset+i-j];if(row&&this.getLineNum(row)){i=i-j;found=true;break}}}if(found){value=this.getLineNum(row)}else{return null}}guessRowNum=lineNum-value+rowOffset+i;if(guessRowNum>=0&&guessRowNum<table.rows.length){guessRow=table.rows[guessRowNum];if(guessRow&&this.getLineNum(guessRow)===lineNum){return guessRow}}oldHigh=high;oldLow=low;if(value>lineNum){high=i}else if(value<lineNum){low=i}else{return row}if(oldHigh===high&&oldLow===low){break}i=Math.round((low+high)/2)}return null},_placeCommentBlockView:function(commentBlockView){var commentBlock=commentBlockView.model,numLines=commentBlock.getNumLines(),beginLineNum=commentBlock.get("beginLineNum"),endLineNum=commentBlock.get("endLineNum"),beginRowEl=this._findLineNumRow(beginLineNum),prevBeginRowIndex,endRowEl;if(beginRowEl){prevBeginRowIndex=beginRowEl.rowIndex;endRowEl=endLineNum===beginLineNum?beginRowEl:this._findLineNumRow(endLineNum,prevBeginRowIndex,prevBeginRowIndex+numLines-1);commentBlockView.setRows($(beginRowEl),$(endRowEl||beginRowEl));commentBlockView.$el.appendTo(commentBlockView.$beginRow[0].cells[0]);this._visibleCommentBlockViews.push(commentBlockView)}else{this._hiddenCommentBlockViews.push(commentBlockView)}return prevBeginRowIndex},_placeHiddenCommentBlockViews:function(){var hiddenCommentBlockViews=this._hiddenCommentBlockViews,prevBeginRowIndex;this._hiddenCommentBlockViews=[];_.each(hiddenCommentBlockViews,function(commentBlockView){prevBeginRowIndex=this._placeCommentBlockView(commentBlockView,prevBeginRowIndex)},this)},_hideRemovedCommentBlockViews:function(){var visibleCommentBlockViews=this._visibleCommentBlockViews;this._visibleCommentBlockViews=[];_.each(visibleCommentBlockViews,function(commentBlockView){if(commentBlockView.$el.is(":visible")){this._visibleCommentBlockViews.push(commentBlockView)}else{this._hiddenCommentBlockViews.push(commentBlockView)}},this);_.sortBy(this._hiddenCommentBlockViews,function(commentBlockView){return commentBlockView.model.get("beginLineNum")})},_updateCollapseButtonPos:function(){var windowTop,windowHeight,len=this._$collapseButtons.length,$button,$tbody,parentOffset,parentTop,parentHeight,i,y1,y2;if(len===0){return}windowTop=this._$window.scrollTop();windowHeight=this._$window.height();for(i=0;i<len;i++){$button=$(this._$collapseButtons[i]);$tbody=$button.parents("tbody");parentOffset=$tbody.offset();parentTop=parentOffset.top;parentHeight=$tbody.height();if(parentTop>=windowTop+windowHeight){break}else if(parentTop+parentHeight<=windowTop){}else{if(windowTop>=parentTop&&windowTop+windowHeight<=parentTop+parentHeight){if($button.css("position")!=="fixed"){$button.css({position:"fixed",left:$button.offset().left,top:Math.round((windowHeight-$button.outerHeight())/2)})}break}else{y1=Math.max(windowTop,parentTop);y2=Math.min(windowTop+windowHeight,parentTop+parentHeight);$button.css({position:"absolute",left:"",top:y1-parentTop+Math.round((y2-y1-$button.outerHeight())/2)})}}}},_expandOrCollapse:function($btn,expanding){var chunkIndex=$btn.data("chunk-index"),linesOfContext=$btn.data("lines-of-context");this.model.getRenderedDiffFragment({chunkIndex:chunkIndex,linesOfContext:linesOfContext},{success:function(html){var $tbody=$btn.parents("tbody"),$scrollAnchor,tbodyID,scrollAnchorID,scrollOffsetTop,newEl;if(expanding){$scrollAnchor=this.$el;scrollAnchorID=$scrollAnchor[0].id;if(linesOfContext===0){tbodyID=/collapsed-(.*)/.exec(scrollAnchorID)[1]}else{tbodyID=scrollAnchorID}}else{$scrollAnchor=$btn}scrollOffsetTop=$scrollAnchor.offset().top-this._$window.scrollTop();$tbody.prev(".diff-header, .loaded").remove();$tbody.next(".diff-header, .loaded").remove();$tbody.replaceWith(html);if(expanding){this._placeHiddenCommentBlockViews()}else{this._hideRemovedCommentBlockViews()}if(tbodyID){newEl=document.getElementById(tbodyID);if(newEl){$scrollAnchor=$(newEl);if($scrollAnchor.length>0){this._$window.scrollTop($scrollAnchor.offset().top-scrollOffsetTop)}}}this._$collapseButtons=this.$(".diff-collapse-btn");this._updateCollapseButtonPos();this._precalculateContentWidths();this._updateColumnSizes();this.trigger("chunkExpansionChanged")}},this)},_precalculateContentWidths:function(){var $cells,containerExtents,cellPadding;if(!this.$el.hasClass("diff-error")&&this._$revisionRow.length>0){containerExtents=this.$el.getExtents("p","lr");$cells=$(this._$revisionRow[0].cells);cellPadding=this.$("pre:first").parent().andSelf().getExtents("p","lr");this._colReservedWidths=$cells.eq(0).outerWidth()+cellPadding+containerExtents;this._numColumns=$cells.length;if(this._numColumns===4){this._colReservedWidths+=$cells.eq(2).outerWidth()+cellPadding}$cells=$(this._$filenameRow[0].cells);cellPadding=$cells.eq(0).getExtents("p","lr");this._numFilenameColumns=$cells.length;this._filenameReservedWidths=containerExtents+2*this._numFilenameColumns}else{this._colReservedWidths=0;this._filenameReservedWidths=0;this._numColumns=0;this._numFilenameColumns=0}},_updateColumnSizes:function(){var fullWidth,contentWidth,filenameWidth;if(this.$el.hasClass("diff-error")){return}fullWidth=this._$parent.width();contentWidth=fullWidth-this._colReservedWidths;if(this._numColumns===4){contentWidth/=2}filenameWidth=fullWidth-this._filenameReservedWidths;if(this._numFilenameColumns===2){filenameWidth/=2}if(contentWidth!==this._prevContentWidth||filenameWidth!==this._prevFilenameWidth){this._$css.html(this.cssTemplate({id:this.el.id,minColWidth:Math.ceil(contentWidth*.66),maxColWidth:Math.ceil(contentWidth),minFilenameWidth:Math.ceil(filenameWidth*.66),maxFilenameWidth:Math.ceil(filenameWidth)}));this._prevContentWidth=contentWidth;this._prevFilenameWidth=filenameWidth}},_onWindowResize:function(){this._updateColumnSizes();this._updateCollapseButtonPos()},_onDownloadLinkClicked:function(e){e.stopPropagation()},_onFileHeaderClicked:function(){this.trigger("fileClicked");return false},_onMovedLineClicked:function(e){e.preventDefault();e.stopPropagation();this.trigger("moveFlagClicked",$(e.target).data("line"))},_onMouseUp:function(e){var node=e.target,$tbody;$tbody=$(node).parents("tbody:first");if($tbody.length>0&&($tbody.hasClass("delete")||$tbody.hasClass("insert")||$tbody.hasClass("replace"))){this.trigger("chunkClicked",$tbody.find("a:first").attr("name"))}},_onExpandChunkClicked:function(e){var $target=$(e.target);if(!$target.hasClass("diff-expand-btn")){$target=$target.parents(".diff-expand-btn")}e.preventDefault();this._expandOrCollapse($target,true)},_onCollapseChunkClicked:function(e){var $target=$(e.target);if(!$target.hasClass("diff-collapse-btn")){$target=$target.parents(".diff-collapse-btn")}e.preventDefault();this._expandOrCollapse($target,false)},getLineNum:function(row){return parseInt(row.getAttribute("line"),10)}})})();RB.DiffRevisionLabelView=Backbone.View.extend({events:{"click .select-latest":"_onSelectLatest","click .select-changed":"_onSelectChanged"},template:_.template(["<h1><%- header %></h1>","<% if (detail) { %><p><%= detail %><% } %>"].join("")),_interdiffTemplate:_.template(gettext("Changes between revision <%- revision %> and <%- interdiffRevision %>")),_latestTemplate:_.template(gettext("Diff Revision <%- revision %> (Latest)")),_oldHeaderTemplate:_.template(gettext("Diff Revision <%- revision %>")),_oldDetailTemplate:_.template(gettext('This is not the most recent revision of the diff. The <a href="#" class="select-latest">latest diff</a> is revision <%- latestRevision %>. <a href="#" class="select-changed">See what\'s changed.</a>')),initialize:function(){this.listenTo(this.model,"change",this.render)},render:function(){var revision=this.model.get("revision"),interdiffRevision=this.model.get("interdiffRevision"),latestRevision=this.model.get("latestRevision"),header="",detail=null;if(this.model.get("isInterdiff")){header=this._interdiffTemplate({revision:revision,interdiffRevision:interdiffRevision})}else if(revision===latestRevision){header=this._latestTemplate({revision:revision})}else if(this.model.get("isDraftDiff")){header=gettext("Draft diff");detail=gettext("This diff is part of your current draft. Other users will not see this diff until you publish your draft.")}else{header=this._oldHeaderTemplate({revision:revision});detail=this._oldDetailTemplate({revision:revision,latestRevision:latestRevision})}this.$el.html(this.template({header:header,detail:detail}));return this},_onSelectLatest:function(ev){ev.preventDefault();this.trigger("revisionSelected",0,this.model.get("latestRevision"));return false},_onSelectChanged:function(ev){ev.preventDefault();this.trigger("revisionSelected",this.model.get("revision"),this.model.get("latestRevision"));return false}});RB.DiffRevisionSelectorView=Backbone.View.extend({template:_.template(['<div class="revision-selector">',' <div class="revision-selector-trough" />',' <div class="revision-selector-range" />',' <div class="revision-selector-ticks" />',' <div class="revision-selector-labels" />',' <div class="revision-selector-handles" />',"</div>"].join("")),events:{"mousedown .revision-selector-handle":"_onHandleMouseDown","mousedown .revision-selector-label":"_onLabelMouseDown","click .revision-selector-label":"_onLabelClick"},initialize:function(){this._rendered=false;this._mouseActive=false;this._activeHandle=null;this._values=[];this.listenTo(this.model,"change",this._update);_.bindAll(this,"_onHandleMouseUp","_onHandleMouseMove")},render:function(){var labels=["orig"],i;this.$el.html(this.template());this._positions=[0];for(i=1;i<=this.options.numDiffs;i++){this._positions.push(i*30);labels.push(i.toString())}this._$trough=this.$(".revision-selector-trough").width(this._positions[this.options.numDiffs]);this._$range=this.$(".revision-selector-range");this._$ticks=this.$(".revision-selector-ticks");this._$labels=this.$(".revision-selector-labels");_.each(labels,function(label,i){var $label;$("<div/>").addClass("revision-selector-tick").css("left",this._positions[i]+"px").appendTo(this._$ticks);$label=$("<div/>").text(label).addClass("revision-selector-label").appendTo(this._$labels);if(i>0){$label.data("revision",i).addClass("revision-selector-label-active")}$label.css("left",this._positions[i]-$label.width()/2+"px")},this);this._$handles=this.$(".revision-selector-handles");for(i=0;i<2;i++){$("<div/>").addClass("revision-selector-handle rb-icon rb-icon-range-slider").data("handle-id",i).appendTo(this._$handles)}this._rendered=true;this._update();return this},_update:function(){var revision=this.model.get("revision"),interdiffRevision=this.model.get("interdiffRevision");this._values=[interdiffRevision?revision:0,interdiffRevision?interdiffRevision:revision];if(!this._rendered){return}this._updateHandles()},_updateHandles:function(){var positions=this._positions,values;if(this._mouseActive){values=this._activeValues}else{values=this._values}this._$handles.children().each(function(i){$(this).css("left",positions[values[i]]-4+"px")});this._$range.css({left:positions[values[0]]+"px",width:positions[values[1]-values[0]]+"px"})},_onRevisionSelected:function(ev){var $target=$(ev.currentTarget);this.trigger("revisionSelected",0,$target.data("revision"))},_onInterdiffSelected:function(ev){var $target=$(ev.currentTarget);this.trigger("revisionSelected",$target.data("first-revision"),$target.data("second-revision"))},_onHandleMouseDown:function(ev){var $target=$(ev.currentTarget);this._mouseActive=true;this._activeHandle=$target.data("handle-id");this._activeValues=[this._values[0],this._values[1]];document.addEventListener("mouseup",this._onHandleMouseUp,true);document.addEventListener("mousemove",this._onHandleMouseMove,true);$("body").addClass("revision-selector-grabbed");ev.preventDefault();return false},_onHandleMouseUp:function(ev){console.assert(this._mouseActive);this._mouseActive=false;this._activeHandle=null;document.removeEventListener("mouseup",this._onHandleMouseUp,true);document.removeEventListener("mousemove",this._onHandleMouseMove,true);$("body").removeClass("revision-selector-grabbed");if(this._activeValues[0]!==this._values[0]||this._activeValues[1]!==this._values[1]){this.trigger("revisionSelected",this._activeValues[0],this._activeValues[1])}ev.stopPropagation();ev.preventDefault()},_onHandleMouseMove:function(ev){var positions=this._positions,positionsLen=positions.length,mouseX,i,closestPos,closestDist,dist;console.assert(this._mouseActive);mouseX=window.pageXOffset+ev.clientX-this._$trough.offset().left;for(i=0;i<positionsLen;i++){dist=Math.abs(positions[i]-mouseX);if(closestDist===undefined||dist<closestDist){closestDist=dist;closestPos=i}}if(this._activeHandle===0){this._activeValues[0]=Math.min(closestPos,positionsLen-2);if(this._values[1]<=this._activeValues[0]){this._activeValues[1]=this._activeValues[0]+1}else{this._activeValues[1]=this._values[1]}}else if(this._activeHandle===1){this._activeValues[1]=Math.max(closestPos,1);if(this._values[0]>=this._activeValues[1]){this._activeValues[0]=this._activeValues[1]-1}else{this._activeValues[0]=this._values[0]}}this._updateHandles()},_onLabelClick:function(ev){var $target=$(ev.currentTarget);this.trigger("revisionSelected",0,$target.data("revision"))}});RB.PaginationView=Backbone.View.extend({template:_.template(["<% if (isPaginated) { %>"," <%- splitText %>"," <% if (hasPrevious) { %>",'  <span class="paginate-link" data-page="<%- previousPage %>"><a href="?page=<%- previousPage %>" title="<%- previousPageText %>">&lt;</a></span>'," <% } %>"," <% _.each(pageNumbers, function(page) { %>","  <% if (page === currentPage) { %>",'   <span class="paginate-current" title="<%- currentPageText %>"><%- page %></span>',"  <% } else { %>",'   <span class="paginate-link" data-page="<%- page %>"><a href="?page=<%- page %>"','       title="<% print(interpolate(pageText, [page])); %>"',"       ><%- page %></a></span>","  <% } %>"," <% }); %>"," <% if (hasNext) { %>",'  <span class="paginate-link" data-page="<%- nextPage %>"><a href="?page=<%- nextPage %>" title="<%- nextPageText %>">&gt;</a></span>'," <% } %>","<% } %>"].join("")),events:{"click .paginate-link":"_onPageClicked"},initialize:function(){this.listenTo(this.model,"change",this.render)},render:function(){this.$el.empty().html(this.template(_.defaults({splitText:interpolate(gettext("This diff has been split across %s pages:"),[this.model.get("pages")]),previousPageText:gettext("Previous Page"),nextPageText:gettext("Next Page"),currentPageText:gettext("Current Page"),pageText:gettext("Page %s")},this.model.attributes)));return this},_onPageClicked:function(ev){var page=$(ev.currentTarget).data("page");if(page!==undefined){this.trigger("pageSelected",page);return false}}})}).call(this);