# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CacheExpirationActionParameters(Model):
    """Defines the parameters for the cache expiration action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters"
     .
    :vartype odatatype: str
    :param cache_behavior: Required. Caching behavior for the requests.
     Possible values include: 'BypassCache', 'Override', 'SetIfMissing'
    :type cache_behavior: str or ~azure.mgmt.cdn.models.CacheBehavior
    :ivar cache_type: Required. The level at which the content needs to be
     cached. Default value: "All" .
    :vartype cache_type: str
    :param cache_duration: The duration for which the content needs to be
     cached. Allowed format is [d.]hh:mm:ss
    :type cache_duration: str
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'cache_behavior': {'required': True},
        'cache_type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'cache_behavior': {'key': 'cacheBehavior', 'type': 'str'},
        'cache_type': {'key': 'cacheType', 'type': 'str'},
        'cache_duration': {'key': 'cacheDuration', 'type': 'str'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters"

    cache_type = "All"

    def __init__(self, **kwargs):
        super(CacheExpirationActionParameters, self).__init__(**kwargs)
        self.cache_behavior = kwargs.get('cache_behavior', None)
        self.cache_duration = kwargs.get('cache_duration', None)


class CacheKeyQueryStringActionParameters(Model):
    """Defines the parameters for the cache-key query string action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"
     .
    :vartype odatatype: str
    :param query_string_behavior: Required. Caching behavior for the requests.
     Possible values include: 'Include', 'IncludeAll', 'Exclude', 'ExcludeAll'
    :type query_string_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringBehavior
    :param query_parameters: query parameters to include or exclude (comma
     separated).
    :type query_parameters: str
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'query_string_behavior': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'query_string_behavior': {'key': 'queryStringBehavior', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': 'str'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"

    def __init__(self, **kwargs):
        super(CacheKeyQueryStringActionParameters, self).__init__(**kwargs)
        self.query_string_behavior = kwargs.get('query_string_behavior', None)
        self.query_parameters = kwargs.get('query_parameters', None)


class CdnCertificateSourceParameters(Model):
    """Defines the parameters for using CDN managed certificate for securing
    custom domain.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters" .
    :vartype odatatype: str
    :param certificate_type: Required. Type of certificate used. Possible
     values include: 'Shared', 'Dedicated'
    :type certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'certificate_type': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'certificate_type': {'key': 'certificateType', 'type': 'str'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters"

    def __init__(self, **kwargs):
        super(CdnCertificateSourceParameters, self).__init__(**kwargs)
        self.certificate_type = kwargs.get('certificate_type', None)


class CustomDomainHttpsParameters(Model):
    """The JSON object that contains the properties to secure a custom domain.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CdnManagedHttpsParameters, UserManagedHttpsParameters

    All required parameters must be populated in order to send to Azure.

    :param protocol_type: Required. Defines the TLS extension protocol that is
     used for secure delivery. Possible values include: 'ServerNameIndication',
     'IPBased'
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for
     Https. Possible values include: 'None', 'TLS10', 'TLS12'
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :param certificate_source: Required. Constant filled by server.
    :type certificate_source: str
    """

    _validation = {
        'protocol_type': {'required': True},
        'certificate_source': {'required': True},
    }

    _attribute_map = {
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'MinimumTlsVersion'},
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
    }

    _subtype_map = {
        'certificate_source': {'Cdn': 'CdnManagedHttpsParameters', 'AzureKeyVault': 'UserManagedHttpsParameters'}
    }

    def __init__(self, **kwargs):
        super(CustomDomainHttpsParameters, self).__init__(**kwargs)
        self.protocol_type = kwargs.get('protocol_type', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.certificate_source = None


class CdnManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using CDN managed certificate for
    enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :param protocol_type: Required. Defines the TLS extension protocol that is
     used for secure delivery. Possible values include: 'ServerNameIndication',
     'IPBased'
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for
     Https. Possible values include: 'None', 'TLS10', 'TLS12'
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :param certificate_source: Required. Constant filled by server.
    :type certificate_source: str
    :param certificate_source_parameters: Required. Defines the certificate
     source parameters using CDN managed certificate for enabling SSL.
    :type certificate_source_parameters:
     ~azure.mgmt.cdn.models.CdnCertificateSourceParameters
    """

    _validation = {
        'protocol_type': {'required': True},
        'certificate_source': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'MinimumTlsVersion'},
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'CdnCertificateSourceParameters'},
    }

    def __init__(self, **kwargs):
        super(CdnManagedHttpsParameters, self).__init__(**kwargs)
        self.certificate_source_parameters = kwargs.get('certificate_source_parameters', None)
        self.certificate_source = 'Cdn'


class CheckNameAvailabilityInput(Model):
    """Input of CheckNameAvailability API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The resource name to validate.
    :type name: str
    :ivar type: Required. The type of the resource whose name is to be
     validated. Default value: "Microsoft.Cdn/Profiles/Endpoints" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Cdn/Profiles/Endpoints"

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityInput, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CheckNameAvailabilityOutput(Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not
     available.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityOutput, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CidrIpAddress(Model):
    """CIDR Ip address.

    :param base_ip_address: Ip address itself.
    :type base_ip_address: str
    :param prefix_length: The length of the prefix of the ip address.
    :type prefix_length: int
    """

    _attribute_map = {
        'base_ip_address': {'key': 'baseIpAddress', 'type': 'str'},
        'prefix_length': {'key': 'prefixLength', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(CidrIpAddress, self).__init__(**kwargs)
        self.base_ip_address = kwargs.get('base_ip_address', None)
        self.prefix_length = kwargs.get('prefix_length', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CookiesMatchConditionParameters(Model):
    """Defines the parameters for Cookies match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCookiesConditionParameters" .
    :vartype odatatype: str
    :param selector: Required. Name of Cookies to be matched
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.CookiesOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'selector': {'required': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCookiesConditionParameters"

    def __init__(self, **kwargs):
        super(CookiesMatchConditionParameters, self).__init__(**kwargs)
        self.selector = kwargs.get('selector', None)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class Resource(Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class CustomDomain(ProxyResource):
    """Friendly domain name mapping to the endpoint hostname that the customer
    provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param host_name: Required. The host name of the custom domain. Must be a
     domain name.
    :type host_name: str
    :ivar resource_state: Resource status of the custom domain. Possible
     values include: 'Creating', 'Active', 'Deleting'
    :vartype resource_state: str or
     ~azure.mgmt.cdn.models.CustomDomainResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https
     of the custom domain. Possible values include: 'Enabling', 'Enabled',
     'Disabling', 'Disabled', 'Failed'
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the
     progress of custom HTTPS enabling/disabling process step by step. Possible
     values include: 'SubmittingDomainControlValidationRequest',
     'PendingDomainControlValidationREquestApproval',
     'DomainControlValidationRequestApproved',
     'DomainControlValidationRequestRejected',
     'DomainControlValidationRequestTimedOut', 'IssuingCertificate',
     'DeployingCertificate', 'CertificateDeployed', 'DeletingCertificate',
     'CertificateDeleted'
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningSubstate
    :param custom_https_parameters: Certificate parameters for securing custom
     HTTPS
    :type custom_https_parameters:
     ~azure.mgmt.cdn.models.CustomDomainHttpsParameters
    :param validation_data: Special validation or data may be required when
     delivering CDN to some regions due to local compliance reasons. E.g. ICP
     license number of a custom domain is required to deliver content in China.
    :type validation_data: str
    :ivar provisioning_state: Provisioning status of the custom domain.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'host_name': {'required': True},
        'resource_state': {'readonly': True},
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'properties.customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'properties.customHttpsProvisioningSubstate', 'type': 'str'},
        'custom_https_parameters': {'key': 'properties.customHttpsParameters', 'type': 'CustomDomainHttpsParameters'},
        'validation_data': {'key': 'properties.validationData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CustomDomain, self).__init__(**kwargs)
        self.host_name = kwargs.get('host_name', None)
        self.resource_state = None
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.custom_https_parameters = kwargs.get('custom_https_parameters', None)
        self.validation_data = kwargs.get('validation_data', None)
        self.provisioning_state = None


class CustomDomainParameters(Model):
    """The customDomain JSON object required for custom domain creation or update.

    All required parameters must be populated in order to send to Azure.

    :param host_name: Required. The host name of the custom domain. Must be a
     domain name.
    :type host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CustomDomainParameters, self).__init__(**kwargs)
        self.host_name = kwargs.get('host_name', None)


class DeepCreatedOrigin(Model):
    """The main origin of CDN content which is added when creating a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Origin name
    :type name: str
    :param host_name: Required. The address of the origin. It can be a domain
     name, IPv4 address, or IPv6 address.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and
     65535
    :type https_port: int
    """

    _validation = {
        'name': {'required': True},
        'host_name': {'required': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DeepCreatedOrigin, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.host_name = kwargs.get('host_name', None)
        self.http_port = kwargs.get('http_port', None)
        self.https_port = kwargs.get('https_port', None)


class DeliveryRule(Model):
    """A rule that specifies a set of actions and conditions.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule
    :type name: str
    :param order: Required. The order in which the rules are applied for the
     endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will
     be applied before a rule with a greater order. Rule with order 0 is a
     special rule. It does not require any condition and actions listed in it
     will always be applied.
    :type order: int
    :param conditions: A list of conditions that must be matched for the
     actions to be executed
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :param actions: Required. A list of actions that are executed when all the
     conditions of a rule are satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    """

    _validation = {
        'order': {'required': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.order = kwargs.get('order', None)
        self.conditions = kwargs.get('conditions', None)
        self.actions = kwargs.get('actions', None)


class DeliveryRuleAction(Model):
    """An action for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: UrlRedirectAction, UrlRewriteAction,
    DeliveryRuleRequestHeaderAction, DeliveryRuleResponseHeaderAction,
    DeliveryRuleCacheExpirationAction, DeliveryRuleCacheKeyQueryStringAction

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'UrlRedirect': 'UrlRedirectAction', 'UrlRewrite': 'UrlRewriteAction', 'ModifyRequestHeader': 'DeliveryRuleRequestHeaderAction', 'ModifyResponseHeader': 'DeliveryRuleResponseHeaderAction', 'CacheExpiration': 'DeliveryRuleCacheExpirationAction', 'CacheKeyQueryString': 'DeliveryRuleCacheKeyQueryStringAction'}
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleAction, self).__init__(**kwargs)
        self.name = None


class DeliveryRuleCacheExpirationAction(DeliveryRuleAction):
    """Defines the cache expiration action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.CacheExpirationActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheExpirationActionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleCacheExpirationAction, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'CacheExpiration'


class DeliveryRuleCacheKeyQueryStringAction(DeliveryRuleAction):
    """Defines the cache-key query string action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the action.
    :type parameters:
     ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheKeyQueryStringActionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleCacheKeyQueryStringAction, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'CacheKeyQueryString'


class DeliveryRuleCondition(Model):
    """A condition for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeliveryRuleRemoteAddressCondition,
    DeliveryRuleRequestMethodCondition, DeliveryRuleQueryStringCondition,
    DeliveryRulePostArgsCondition, DeliveryRuleRequestUriCondition,
    DeliveryRuleRequestHeaderCondition, DeliveryRuleRequestBodyCondition,
    DeliveryRuleRequestSchemeCondition, DeliveryRuleUrlPathCondition,
    DeliveryRuleUrlFileExtensionCondition, DeliveryRuleUrlFileNameCondition,
    DeliveryRuleHttpVersionCondition, DeliveryRuleCookiesCondition,
    DeliveryRuleIsDeviceCondition

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'RemoteAddress': 'DeliveryRuleRemoteAddressCondition', 'RequestMethod': 'DeliveryRuleRequestMethodCondition', 'QueryString': 'DeliveryRuleQueryStringCondition', 'PostArgs': 'DeliveryRulePostArgsCondition', 'RequestUri': 'DeliveryRuleRequestUriCondition', 'RequestHeader': 'DeliveryRuleRequestHeaderCondition', 'RequestBody': 'DeliveryRuleRequestBodyCondition', 'RequestScheme': 'DeliveryRuleRequestSchemeCondition', 'UrlPath': 'DeliveryRuleUrlPathCondition', 'UrlFileExtension': 'DeliveryRuleUrlFileExtensionCondition', 'UrlFileName': 'DeliveryRuleUrlFileNameCondition', 'HttpVersion': 'DeliveryRuleHttpVersionCondition', 'Cookies': 'DeliveryRuleCookiesCondition', 'IsDevice': 'DeliveryRuleIsDeviceCondition'}
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleCondition, self).__init__(**kwargs)
        self.name = None


class DeliveryRuleCookiesCondition(DeliveryRuleCondition):
    """Defines the Cookies condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.CookiesMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CookiesMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleCookiesCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'Cookies'


class DeliveryRuleHttpVersionCondition(DeliveryRuleCondition):
    """Defines the HttpVersion condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.HttpVersionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HttpVersionMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleHttpVersionCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'HttpVersion'


class DeliveryRuleIsDeviceCondition(DeliveryRuleCondition):
    """Defines the IsDevice condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.IsDeviceMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'IsDeviceMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleIsDeviceCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'IsDevice'


class DeliveryRulePostArgsCondition(DeliveryRuleCondition):
    """Defines the PostArgs condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.PostArgsMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'PostArgsMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRulePostArgsCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'PostArgs'


class DeliveryRuleQueryStringCondition(DeliveryRuleCondition):
    """Defines the QueryString condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.QueryStringMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'QueryStringMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleQueryStringCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'QueryString'


class DeliveryRuleRemoteAddressCondition(DeliveryRuleCondition):
    """Defines the RemoteAddress condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RemoteAddressMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleRemoteAddressCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'RemoteAddress'


class DeliveryRuleRequestBodyCondition(DeliveryRuleCondition):
    """Defines the RequestBody condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.RequestBodyMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestBodyMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleRequestBodyCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'RequestBody'


class DeliveryRuleRequestHeaderAction(DeliveryRuleAction):
    """Defines the request header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleRequestHeaderAction, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'ModifyRequestHeader'


class DeliveryRuleRequestHeaderCondition(DeliveryRuleCondition):
    """Defines the RequestHeader condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestHeaderMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleRequestHeaderCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'RequestHeader'


class DeliveryRuleRequestMethodCondition(DeliveryRuleCondition):
    """Defines the RequestMethod condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.RequestMethodMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestMethodMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleRequestMethodCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'RequestMethod'


class DeliveryRuleRequestSchemeCondition(DeliveryRuleCondition):
    """Defines the RequestScheme condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestSchemeMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleRequestSchemeCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'RequestScheme'


class DeliveryRuleRequestUriCondition(DeliveryRuleCondition):
    """Defines the RequestUri condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.RequestUriMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestUriMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleRequestUriCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'RequestUri'


class DeliveryRuleResponseHeaderAction(DeliveryRuleAction):
    """Defines the response header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleResponseHeaderAction, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'ModifyResponseHeader'


class DeliveryRuleUrlFileExtensionCondition(DeliveryRuleCondition):
    """Defines the UrlFileExtension condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileExtensionMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleUrlFileExtensionCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'UrlFileExtension'


class DeliveryRuleUrlFileNameCondition(DeliveryRuleCondition):
    """Defines the UrlFileName condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters:
     ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileNameMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleUrlFileNameCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'UrlFileName'


class DeliveryRuleUrlPathCondition(DeliveryRuleCondition):
    """Defines the UrlPath condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.UrlPathMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlPathMatchConditionParameters'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRuleUrlPathCondition, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'UrlPath'


class EdgeNode(ProxyResource):
    """Edgenode is a global Point of Presence (POP) location used to deliver CDN
    content to end users.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param ip_address_groups: Required. List of ip address groups.
    :type ip_address_groups: list[~azure.mgmt.cdn.models.IpAddressGroup]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'ip_address_groups': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ip_address_groups': {'key': 'properties.ipAddressGroups', 'type': '[IpAddressGroup]'},
    }

    def __init__(self, **kwargs):
        super(EdgeNode, self).__init__(**kwargs)
        self.ip_address_groups = kwargs.get('ip_address_groups', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Endpoint(TrackedResource):
    """CDN endpoint is the entity within a CDN profile containing configuration
    information such as origin, protocol, content caching and delivery
    behavior. The CDN endpoint uses the URL format
    <endpointname>.azureedge.net.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param origin_host_header: The host header value sent to the origin with
     each request. If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud
     Services require this host header value to match the origin hostname by
     default.
    :type origin_host_header: str
    :param origin_path: A directory path on the origin that CDN can use to
     retrieve content from, e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which
     compression applies. The value should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param is_compression_enabled: Indicates whether content compression is
     enabled on CDN. Default value is false. If compression is enabled, content
     will be served as compressed if user requests for a compressed version.
     Content won't be compressed on CDN when requested content is smaller than
     1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the
     endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
     must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the
     endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
     must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that
     include query strings. You can ignore any query strings when caching,
     bypass caching to prevent requests that contain query strings from being
     cached, or cache every request with a unique URL. Possible values include:
     'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
    :type query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this
     CDN endpoint to optimize for, e.g. Download, Media services. With this
     information, CDN can apply scenario driven optimization. Possible values
     include: 'GeneralWebDelivery', 'GeneralMediaStreaming',
     'VideoOnDemandMediaStreaming', 'LargeFileDownload',
     'DynamicSiteAcceleration'
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps
     accelerate delivery of the dynamic content and calculate the most optimal
     routes for the CDN. This is relative to the origin path.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a
     CDN endpoint. Each geo filter defines an access rule to a specified path
     or content, e.g. block APAC for path /pictures/
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param delivery_policy: A policy that specifies the delivery rules to be
     used for an endpoint.
    :type delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar host_name: The host name of the endpoint structured as
     {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
    :vartype host_name: str
    :param origins: Required. The source of the content being delivered via
     CDN.
    :type origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :ivar resource_state: Resource status of the endpoint. Possible values
     include: 'Creating', 'Deleting', 'Running', 'Starting', 'Stopped',
     'Stopping'
    :vartype resource_state: str or
     ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'host_name': {'readonly': True},
        'origins': {'required': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'QueryStringCachingBehavior'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'origins': {'key': 'properties.origins', 'type': '[DeepCreatedOrigin]'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Endpoint, self).__init__(**kwargs)
        self.origin_host_header = kwargs.get('origin_host_header', None)
        self.origin_path = kwargs.get('origin_path', None)
        self.content_types_to_compress = kwargs.get('content_types_to_compress', None)
        self.is_compression_enabled = kwargs.get('is_compression_enabled', None)
        self.is_http_allowed = kwargs.get('is_http_allowed', None)
        self.is_https_allowed = kwargs.get('is_https_allowed', None)
        self.query_string_caching_behavior = kwargs.get('query_string_caching_behavior', None)
        self.optimization_type = kwargs.get('optimization_type', None)
        self.probe_path = kwargs.get('probe_path', None)
        self.geo_filters = kwargs.get('geo_filters', None)
        self.delivery_policy = kwargs.get('delivery_policy', None)
        self.host_name = None
        self.origins = kwargs.get('origins', None)
        self.resource_state = None
        self.provisioning_state = None


class EndpointPropertiesUpdateParametersDeliveryPolicy(Model):
    """A policy that specifies the delivery rules to be used for an endpoint.

    All required parameters must be populated in order to send to Azure.

    :param description: User-friendly description of the policy.
    :type description: str
    :param rules: Required. A list of the delivery rules.
    :type rules: list[~azure.mgmt.cdn.models.DeliveryRule]
    """

    _validation = {
        'rules': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[DeliveryRule]'},
    }

    def __init__(self, **kwargs):
        super(EndpointPropertiesUpdateParametersDeliveryPolicy, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.rules = kwargs.get('rules', None)


class EndpointUpdateParameters(Model):
    """Properties required to create or update an endpoint.

    :param tags: Endpoint tags.
    :type tags: dict[str, str]
    :param origin_host_header: The host header value sent to the origin with
     each request. If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud
     Services require this host header value to match the origin hostname by
     default.
    :type origin_host_header: str
    :param origin_path: A directory path on the origin that CDN can use to
     retrieve content from, e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which
     compression applies. The value should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param is_compression_enabled: Indicates whether content compression is
     enabled on CDN. Default value is false. If compression is enabled, content
     will be served as compressed if user requests for a compressed version.
     Content won't be compressed on CDN when requested content is smaller than
     1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the
     endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
     must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the
     endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
     must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that
     include query strings. You can ignore any query strings when caching,
     bypass caching to prevent requests that contain query strings from being
     cached, or cache every request with a unique URL. Possible values include:
     'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
    :type query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this
     CDN endpoint to optimize for, e.g. Download, Media services. With this
     information, CDN can apply scenario driven optimization. Possible values
     include: 'GeneralWebDelivery', 'GeneralMediaStreaming',
     'VideoOnDemandMediaStreaming', 'LargeFileDownload',
     'DynamicSiteAcceleration'
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps
     accelerate delivery of the dynamic content and calculate the most optimal
     routes for the CDN. This is relative to the origin path.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a
     CDN endpoint. Each geo filter defines an access rule to a specified path
     or content, e.g. block APAC for path /pictures/
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param delivery_policy: A policy that specifies the delivery rules to be
     used for an endpoint.
    :type delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'QueryStringCachingBehavior'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
    }

    def __init__(self, **kwargs):
        super(EndpointUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.origin_host_header = kwargs.get('origin_host_header', None)
        self.origin_path = kwargs.get('origin_path', None)
        self.content_types_to_compress = kwargs.get('content_types_to_compress', None)
        self.is_compression_enabled = kwargs.get('is_compression_enabled', None)
        self.is_http_allowed = kwargs.get('is_http_allowed', None)
        self.is_https_allowed = kwargs.get('is_https_allowed', None)
        self.query_string_caching_behavior = kwargs.get('query_string_caching_behavior', None)
        self.optimization_type = kwargs.get('optimization_type', None)
        self.probe_path = kwargs.get('probe_path', None)
        self.geo_filters = kwargs.get('geo_filters', None)
        self.delivery_policy = kwargs.get('delivery_policy', None)


class ErrorResponse(Model):
    """Error response indicates CDN service is not able to process the incoming
    request. The reason is provided in the error message.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class GeoFilter(Model):
    """Rules defining user's geo access within a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :param relative_path: Required. Relative path applicable to geo filter.
     (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
    :type relative_path: str
    :param action: Required. Action of the geo filter, i.e. allow or block
     access. Possible values include: 'Block', 'Allow'
    :type action: str or ~azure.mgmt.cdn.models.GeoFilterActions
    :param country_codes: Required. Two letter country codes defining user
     country access in a geo filter, e.g. AU, MX, US.
    :type country_codes: list[str]
    """

    _validation = {
        'relative_path': {'required': True},
        'action': {'required': True},
        'country_codes': {'required': True},
    }

    _attribute_map = {
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'action': {'key': 'action', 'type': 'GeoFilterActions'},
        'country_codes': {'key': 'countryCodes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(GeoFilter, self).__init__(**kwargs)
        self.relative_path = kwargs.get('relative_path', None)
        self.action = kwargs.get('action', None)
        self.country_codes = kwargs.get('country_codes', None)


class HeaderActionParameters(Model):
    """Defines the parameters for the request header action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters" .
    :vartype odatatype: str
    :param header_action: Required. Action to perform. Possible values
     include: 'Append', 'Overwrite', 'Delete'
    :type header_action: str or ~azure.mgmt.cdn.models.HeaderAction
    :param header_name: Required. Name of the header to modify
    :type header_name: str
    :param value: Value for the specified action
    :type value: str
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'header_action': {'required': True},
        'header_name': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'header_action': {'key': 'headerAction', 'type': 'str'},
        'header_name': {'key': 'headerName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters"

    def __init__(self, **kwargs):
        super(HeaderActionParameters, self).__init__(**kwargs)
        self.header_action = kwargs.get('header_action', None)
        self.header_name = kwargs.get('header_name', None)
        self.value = kwargs.get('value', None)


class HttpVersionMatchConditionParameters(Model):
    """Defines the parameters for HttpVersion match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleHttpVersionConditionParameters" .
    :vartype odatatype: str
    :ivar operator: Required. Describes operator to be matched. Default value:
     "Equal" .
    :vartype operator: str
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True, 'constant': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHttpVersionConditionParameters"

    operator = "Equal"

    def __init__(self, **kwargs):
        super(HttpVersionMatchConditionParameters, self).__init__(**kwargs)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)


class IpAddressGroup(Model):
    """CDN Ip address group.

    :param delivery_region: The delivery region of the ip address group
    :type delivery_region: str
    :param ipv4_addresses: The list of ip v4 addresses.
    :type ipv4_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    :param ipv6_addresses: The list of ip v6 addresses.
    :type ipv6_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    """

    _attribute_map = {
        'delivery_region': {'key': 'deliveryRegion', 'type': 'str'},
        'ipv4_addresses': {'key': 'ipv4Addresses', 'type': '[CidrIpAddress]'},
        'ipv6_addresses': {'key': 'ipv6Addresses', 'type': '[CidrIpAddress]'},
    }

    def __init__(self, **kwargs):
        super(IpAddressGroup, self).__init__(**kwargs)
        self.delivery_region = kwargs.get('delivery_region', None)
        self.ipv4_addresses = kwargs.get('ipv4_addresses', None)
        self.ipv6_addresses = kwargs.get('ipv6_addresses', None)


class IsDeviceMatchConditionParameters(Model):
    """Defines the parameters for IsDevice match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleIsDeviceConditionParameters" .
    :vartype odatatype: str
    :ivar operator: Required. Describes operator to be matched. Default value:
     "Equal" .
    :vartype operator: str
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True, 'constant': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleIsDeviceConditionParameters"

    operator = "Equal"

    def __init__(self, **kwargs):
        super(IsDeviceMatchConditionParameters, self).__init__(**kwargs)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class KeyVaultCertificateSourceParameters(Model):
    """Describes the parameters for using a user's KeyVault certificate for
    securing custom domain.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.KeyVaultCertificateSourceParameters" .
    :vartype odatatype: str
    :param subscription_id: Required. Subscription Id of the user's Key Vault
     containing the SSL certificate
    :type subscription_id: str
    :param resource_group_name: Required. Resource group of the user's Key
     Vault containing the SSL certificate
    :type resource_group_name: str
    :param vault_name: Required. The name of the user's Key Vault containing
     the SSL certificate
    :type vault_name: str
    :param secret_name: Required. The name of Key Vault Secret (representing
     the full certificate PFX) in Key Vault.
    :type secret_name: str
    :param secret_version: Required. The version(GUID) of Key Vault Secret in
     Key Vault.
    :type secret_version: str
    :ivar update_rule: Required. Describes the action that shall be taken when
     the certificate is updated in Key Vault. Default value: "NoAction" .
    :vartype update_rule: str
    :ivar delete_rule: Required. Describes the action that shall be taken when
     the certificate is removed from Key Vault. Default value: "NoAction" .
    :vartype delete_rule: str
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'vault_name': {'required': True},
        'secret_name': {'required': True},
        'secret_version': {'required': True},
        'update_rule': {'required': True, 'constant': True},
        'delete_rule': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'update_rule': {'key': 'updateRule', 'type': 'str'},
        'delete_rule': {'key': 'deleteRule', 'type': 'str'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.KeyVaultCertificateSourceParameters"

    update_rule = "NoAction"

    delete_rule = "NoAction"

    def __init__(self, **kwargs):
        super(KeyVaultCertificateSourceParameters, self).__init__(**kwargs)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.vault_name = kwargs.get('vault_name', None)
        self.secret_name = kwargs.get('secret_name', None)
        self.secret_version = kwargs.get('secret_version', None)


class LoadParameters(Model):
    """Parameters required for content load.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be loaded. Path
     should be a relative file URL of the origin.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(LoadParameters, self).__init__(**kwargs)
        self.content_paths = kwargs.get('content_paths', None)


class Operation(Model):
    """CDN REST API operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.cdn.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Service provider: Microsoft.Cdn
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile,
     endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class Origin(TrackedResource):
    """CDN origin is the source of the content being delivered via CDN. When the
    edge nodes represented by an endpoint do not have the requested content
    cached, they attempt to fetch it from one or more of the configured
    origins.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param host_name: Required. The address of the origin. Domain names, IPv4
     addresses, and IPv6 addresses are supported.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the https port. Must be between 1 and
     65535.
    :type https_port: int
    :ivar resource_state: Resource status of the origin. Possible values
     include: 'Creating', 'Active', 'Deleting'
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'host_name': {'required': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Origin, self).__init__(**kwargs)
        self.host_name = kwargs.get('host_name', None)
        self.http_port = kwargs.get('http_port', None)
        self.https_port = kwargs.get('https_port', None)
        self.resource_state = None
        self.provisioning_state = None


class OriginUpdateParameters(Model):
    """Origin properties needed for origin creation or update.

    :param host_name: The address of the origin. Domain names, IPv4 addresses,
     and IPv6 addresses are supported.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and
     65535.
    :type https_port: int
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
    }

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(OriginUpdateParameters, self).__init__(**kwargs)
        self.host_name = kwargs.get('host_name', None)
        self.http_port = kwargs.get('http_port', None)
        self.https_port = kwargs.get('https_port', None)


class PostArgsMatchConditionParameters(Model):
    """Defines the parameters for PostArgs match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRulePostArgsConditionParameters" .
    :vartype odatatype: str
    :param selector: Required. Name of PostArg to be matched
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.PostArgsOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'selector': {'required': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRulePostArgsConditionParameters"

    def __init__(self, **kwargs):
        super(PostArgsMatchConditionParameters, self).__init__(**kwargs)
        self.selector = kwargs.get('selector', None)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class Profile(TrackedResource):
    """CDN profile is a logical grouping of endpoints that share the same
    settings, such as CDN provider and pricing tier.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. The pricing tier (defines a CDN provider, feature
     list and rate) of the CDN profile.
    :type sku: ~azure.mgmt.cdn.models.Sku
    :ivar resource_state: Resource status of the profile. Possible values
     include: 'Creating', 'Active', 'Deleting', 'Disabled'
    :vartype resource_state: str or
     ~azure.mgmt.cdn.models.ProfileResourceState
    :ivar provisioning_state: Provisioning status of the profile.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Profile, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.resource_state = None
        self.provisioning_state = None


class ProfileUpdateParameters(Model):
    """Properties required to update a profile.

    :param tags: Profile tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ProfileUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class PurgeParameters(Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be purged. Can
     describe a file path or a wild card directory.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PurgeParameters, self).__init__(**kwargs)
        self.content_paths = kwargs.get('content_paths', None)


class QueryStringMatchConditionParameters(Model):
    """Defines the parameters for QueryString match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters" .
    :vartype odatatype: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.QueryStringOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters"

    def __init__(self, **kwargs):
        super(QueryStringMatchConditionParameters, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class RemoteAddressMatchConditionParameters(Model):
    """Defines the parameters for RemoteAddress match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRemoteAddressConditionParameters"
     .
    :vartype odatatype: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'IPMatch', 'GeoMatch'
    :type operator: str or ~azure.mgmt.cdn.models.RemoteAddressOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. Match values to match against. The operator
     will apply to each value in here with OR semantics. If any of them match
     the variable with the given operator this match condition is considered a
     match.
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRemoteAddressConditionParameters"

    def __init__(self, **kwargs):
        super(RemoteAddressMatchConditionParameters, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class RequestBodyMatchConditionParameters(Model):
    """Defines the parameters for RequestBody match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestBodyConditionParameters" .
    :vartype odatatype: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.RequestBodyOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestBodyConditionParameters"

    def __init__(self, **kwargs):
        super(RequestBodyMatchConditionParameters, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class RequestHeaderMatchConditionParameters(Model):
    """Defines the parameters for RequestHeader match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestHeaderConditionParameters"
     .
    :vartype odatatype: str
    :param selector: Required. Name of Header to be matched
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.RequestHeaderOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'selector': {'required': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestHeaderConditionParameters"

    def __init__(self, **kwargs):
        super(RequestHeaderMatchConditionParameters, self).__init__(**kwargs)
        self.selector = kwargs.get('selector', None)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class RequestMethodMatchConditionParameters(Model):
    """Defines the parameters for RequestMethod match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestMethodConditionParameters"
     .
    :vartype odatatype: str
    :ivar operator: Required. Describes operator to be matched. Default value:
     "Equal" .
    :vartype operator: str
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True, 'constant': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestMethodConditionParameters"

    operator = "Equal"

    def __init__(self, **kwargs):
        super(RequestMethodMatchConditionParameters, self).__init__(**kwargs)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)


class RequestSchemeMatchConditionParameters(Model):
    """Defines the parameters for RequestScheme match conditions .

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestSchemeConditionParameters"
     .
    :vartype odatatype: str
    :ivar operator: Required. Describes operator to be matched. Default value:
     "Equal" .
    :vartype operator: str
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True, 'constant': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestSchemeConditionParameters"

    operator = "Equal"

    def __init__(self, **kwargs):
        super(RequestSchemeMatchConditionParameters, self).__init__(**kwargs)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)


class RequestUriMatchConditionParameters(Model):
    """Defines the parameters for RequestUri match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestUriConditionParameters" .
    :vartype odatatype: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.RequestUriOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestUriConditionParameters"

    def __init__(self, **kwargs):
        super(RequestUriMatchConditionParameters, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class ResourceUsage(Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: Resource type for which the usage is provided.
    :vartype resource_type: str
    :ivar unit: Unit of the usage. e.g. Count.
    :vartype unit: str
    :ivar current_value: Actual value of usage on the specified resource type.
    :vartype current_value: int
    :ivar limit: Quota of the specified resource type.
    :vartype limit: int
    """

    _validation = {
        'resource_type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ResourceUsage, self).__init__(**kwargs)
        self.resource_type = None
        self.unit = None
        self.current_value = None
        self.limit = None


class Sku(Model):
    """The pricing tier (defines a CDN provider, feature list and rate) of the CDN
    profile.

    :param name: Name of the pricing tier. Possible values include:
     'Standard_Verizon', 'Premium_Verizon', 'Custom_Verizon',
     'Standard_Akamai', 'Standard_ChinaCdn', 'Standard_Microsoft',
     'Premium_ChinaCdn'
    :type name: str or ~azure.mgmt.cdn.models.SkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class SsoUri(Model):
    """The URI required to login to the supplemental portal from the Azure portal.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar sso_uri_value: The URI used to login to the supplemental portal.
    :vartype sso_uri_value: str
    """

    _validation = {
        'sso_uri_value': {'readonly': True},
    }

    _attribute_map = {
        'sso_uri_value': {'key': 'ssoUriValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsoUri, self).__init__(**kwargs)
        self.sso_uri_value = None


class SupportedOptimizationTypesListResult(Model):
    """The result of the GetSupportedOptimizationTypes API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar supported_optimization_types: Supported optimization types for a
     profile.
    :vartype supported_optimization_types: list[str or
     ~azure.mgmt.cdn.models.OptimizationType]
    """

    _validation = {
        'supported_optimization_types': {'readonly': True},
    }

    _attribute_map = {
        'supported_optimization_types': {'key': 'supportedOptimizationTypes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SupportedOptimizationTypesListResult, self).__init__(**kwargs)
        self.supported_optimization_types = None


class UrlFileExtensionMatchConditionParameters(Model):
    """Defines the parameters for UrlFileExtension match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionMatchConditionParameters"
     .
    :vartype odatatype: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.UrlFileExtensionOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionMatchConditionParameters"

    def __init__(self, **kwargs):
        super(UrlFileExtensionMatchConditionParameters, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class UrlFileNameMatchConditionParameters(Model):
    """Defines the parameters for UrlFilename match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFilenameConditionParameters" .
    :vartype odatatype: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual'
    :type operator: str or ~azure.mgmt.cdn.models.UrlFileNameOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFilenameConditionParameters"

    def __init__(self, **kwargs):
        super(UrlFileNameMatchConditionParameters, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class UrlPathMatchConditionParameters(Model):
    """Defines the parameters for UrlPath match conditions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlPathMatchConditionParameters"
     .
    :vartype odatatype: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'Equal', 'Contains', 'BeginsWith', 'EndsWith',
     'LessThan', 'LessThanOrEqual', 'GreaterThan', 'GreaterThanOrEqual',
     'Wildcard'
    :type operator: str or ~azure.mgmt.cdn.models.UrlPathOperator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_values: Required. The match value for the condition of the
     delivery rule
    :type match_values: list[str]
    :param transforms: List of transforms
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlPathMatchConditionParameters"

    def __init__(self, **kwargs):
        super(UrlPathMatchConditionParameters, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_values = kwargs.get('match_values', None)
        self.transforms = kwargs.get('transforms', None)


class UrlRedirectAction(DeliveryRuleAction):
    """Defines the url redirect action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlRedirectActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRedirectActionParameters'},
    }

    def __init__(self, **kwargs):
        super(UrlRedirectAction, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'UrlRedirect'


class UrlRedirectActionParameters(Model):
    """Defines the parameters for the url redirect action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRedirectActionParameters" .
    :vartype odatatype: str
    :param redirect_type: Required. The redirect type the rule will use when
     redirecting traffic. Possible values include: 'Moved', 'Found',
     'TemporaryRedirect', 'PermanentRedirect'
    :type redirect_type: str or ~azure.mgmt.cdn.models.RedirectType
    :param destination_protocol: Protocol to use for the redirect. The default
     value is MatchRequest. Possible values include: 'MatchRequest', 'Http',
     'Https'
    :type destination_protocol: str or
     ~azure.mgmt.cdn.models.DestinationProtocol
    :param custom_path: The full path to redirect. Path cannot be empty and
     must start with /. Leave empty to use the incoming path as destination
     path.
    :type custom_path: str
    :param custom_hostname: Host to redirect. Leave empty to use the incoming
     host as the destination host.
    :type custom_hostname: str
    :param custom_query_string: The set of query strings to be placed in the
     redirect URL. Setting this value would replace any existing query string;
     leave empty to preserve the incoming query string. Query string must be in
     <key>=<value> format. ? and & will be added automatically so do not
     include them.
    :type custom_query_string: str
    :param custom_fragment: Fragment to add to the redirect URL. Fragment is
     the part of the URL that comes after #. Do not include the #.
    :type custom_fragment: str
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'redirect_type': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'redirect_type': {'key': 'redirectType', 'type': 'str'},
        'destination_protocol': {'key': 'destinationProtocol', 'type': 'str'},
        'custom_path': {'key': 'customPath', 'type': 'str'},
        'custom_hostname': {'key': 'customHostname', 'type': 'str'},
        'custom_query_string': {'key': 'customQueryString', 'type': 'str'},
        'custom_fragment': {'key': 'customFragment', 'type': 'str'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRedirectActionParameters"

    def __init__(self, **kwargs):
        super(UrlRedirectActionParameters, self).__init__(**kwargs)
        self.redirect_type = kwargs.get('redirect_type', None)
        self.destination_protocol = kwargs.get('destination_protocol', None)
        self.custom_path = kwargs.get('custom_path', None)
        self.custom_hostname = kwargs.get('custom_hostname', None)
        self.custom_query_string = kwargs.get('custom_query_string', None)
        self.custom_fragment = kwargs.get('custom_fragment', None)


class UrlRewriteAction(DeliveryRuleAction):
    """Defines the url rewrite action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Constant filled by server.
    :type name: str
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlRewriteActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRewriteActionParameters'},
    }

    def __init__(self, **kwargs):
        super(UrlRewriteAction, self).__init__(**kwargs)
        self.parameters = kwargs.get('parameters', None)
        self.name = 'UrlRewrite'


class UrlRewriteActionParameters(Model):
    """Defines the parameters for the url rewrite action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRewriteActionParameters" .
    :vartype odatatype: str
    :param source_pattern: Required. define a request URI pattern that
     identifies the type of requests that may be rewritten. Currently, source
     pattern uses a prefix-based match. To match all URL paths, use "/" as the
     source pattern value. To match only the root directory and re-write this
     path, use the origin path field
    :type source_pattern: str
    :param destination: Required. Define the destination path for be used in
     the rewrite. This will overwrite the source pattern
    :type destination: str
    :param preserve_unmatched_path: If True, the remaining path after the
     source pattern will be appended to the new destination path.
    :type preserve_unmatched_path: bool
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'source_pattern': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'source_pattern': {'key': 'sourcePattern', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
        'preserve_unmatched_path': {'key': 'preserveUnmatchedPath', 'type': 'bool'},
    }

    odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRewriteActionParameters"

    def __init__(self, **kwargs):
        super(UrlRewriteActionParameters, self).__init__(**kwargs)
        self.source_pattern = kwargs.get('source_pattern', None)
        self.destination = kwargs.get('destination', None)
        self.preserve_unmatched_path = kwargs.get('preserve_unmatched_path', None)


class UserManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using user's keyvault certificate
    for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :param protocol_type: Required. Defines the TLS extension protocol that is
     used for secure delivery. Possible values include: 'ServerNameIndication',
     'IPBased'
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for
     Https. Possible values include: 'None', 'TLS10', 'TLS12'
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :param certificate_source: Required. Constant filled by server.
    :type certificate_source: str
    :param certificate_source_parameters: Required. Defines the certificate
     source parameters using user's keyvault certificate for enabling SSL.
    :type certificate_source_parameters:
     ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParameters
    """

    _validation = {
        'protocol_type': {'required': True},
        'certificate_source': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'MinimumTlsVersion'},
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'KeyVaultCertificateSourceParameters'},
    }

    def __init__(self, **kwargs):
        super(UserManagedHttpsParameters, self).__init__(**kwargs)
        self.certificate_source_parameters = kwargs.get('certificate_source_parameters', None)
        self.certificate_source = 'AzureKeyVault'


class ValidateCustomDomainInput(Model):
    """Input of the custom domain to be validated for DNS mapping.

    All required parameters must be populated in order to send to Azure.

    :param host_name: Required. The host name of the custom domain. Must be a
     domain name.
    :type host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ValidateCustomDomainInput, self).__init__(**kwargs)
        self.host_name = kwargs.get('host_name', None)


class ValidateCustomDomainOutput(Model):
    """Output of custom domain validation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar custom_domain_validated: Indicates whether the custom domain is
     valid or not.
    :vartype custom_domain_validated: bool
    :ivar reason: The reason why the custom domain is not valid.
    :vartype reason: str
    :ivar message: Error message describing why the custom domain is not
     valid.
    :vartype message: str
    """

    _validation = {
        'custom_domain_validated': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'custom_domain_validated': {'key': 'customDomainValidated', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ValidateCustomDomainOutput, self).__init__(**kwargs)
        self.custom_domain_validated = None
        self.reason = None
        self.message = None


class ValidateProbeInput(Model):
    """Input of the validate probe API.

    All required parameters must be populated in order to send to Azure.

    :param probe_url: Required. The probe URL to validate.
    :type probe_url: str
    """

    _validation = {
        'probe_url': {'required': True},
    }

    _attribute_map = {
        'probe_url': {'key': 'probeURL', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ValidateProbeInput, self).__init__(**kwargs)
        self.probe_url = kwargs.get('probe_url', None)


class ValidateProbeOutput(Model):
    """Output of the validate probe API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar is_valid: Indicates whether the probe URL is accepted or not.
    :vartype is_valid: bool
    :ivar error_code: Specifies the error code when the probe url is not
     accepted.
    :vartype error_code: str
    :ivar message: The detailed error message describing why the probe URL is
     not accepted.
    :vartype message: str
    """

    _validation = {
        'is_valid': {'readonly': True},
        'error_code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ValidateProbeOutput, self).__init__(**kwargs)
        self.is_valid = None
        self.error_code = None
        self.message = None
