import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorDataCollectionRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_data_collection_rule#id DataAzurermMonitorDataCollectionRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_data_collection_rule#name DataAzurermMonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_data_collection_rule#resource_group_name DataAzurermMonitorDataCollectionRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_data_collection_rule#timeouts DataAzurermMonitorDataCollectionRule#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorDataCollectionRuleTimeouts;
}
export interface DataAzurermMonitorDataCollectionRuleDataFlow {
}
export declare function dataAzurermMonitorDataCollectionRuleDataFlowToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataFlow): any;
export declare class DataAzurermMonitorDataCollectionRuleDataFlowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataFlow | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataFlow | undefined);
    get destinations(): string[];
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataFlowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataFlowOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesExtension {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesExtensionToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesExtension): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesExtension | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesExtension | undefined);
    get extensionJson(): string;
    get extensionName(): string;
    get inputDataSources(): string[];
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesExtensionOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter | undefined);
    get counterSpecifiers(): string[];
    get name(): string;
    get samplingFrequencyInSeconds(): number;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesSyslog {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesSyslogToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesSyslog): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesSyslogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesSyslog | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesSyslog | undefined);
    get facilityNames(): string[];
    get logLevels(): string[];
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesSyslogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesSyslogOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog | undefined);
    get name(): string;
    get streams(): string[];
    get xPathQueries(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSources {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSources): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSources | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSources | undefined);
    private _extension;
    get extension(): DataAzurermMonitorDataCollectionRuleDataSourcesExtensionList;
    private _performanceCounter;
    get performanceCounter(): DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterList;
    private _syslog;
    get syslog(): DataAzurermMonitorDataCollectionRuleDataSourcesSyslogList;
    private _windowsEventLog;
    get windowsEventLog(): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogList;
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined);
    get name(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics | undefined);
    get name(): string;
    get workspaceResourceId(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinations {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinations): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinations | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinations | undefined);
    private _azureMonitorMetrics;
    get azureMonitorMetrics(): DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsList;
    private _logAnalytics;
    get logAnalytics(): DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsList;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_data_collection_rule#read DataAzurermMonitorDataCollectionRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorDataCollectionRuleTimeoutsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleTimeoutsOutputReference | DataAzurermMonitorDataCollectionRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorDataCollectionRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_data_collection_rule azurerm_monitor_data_collection_rule}
*/
export declare class DataAzurermMonitorDataCollectionRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_monitor_data_collection_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_data_collection_rule azurerm_monitor_data_collection_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorDataCollectionRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorDataCollectionRuleConfig);
    private _dataFlow;
    get dataFlow(): DataAzurermMonitorDataCollectionRuleDataFlowList;
    private _dataSources;
    get dataSources(): DataAzurermMonitorDataCollectionRuleDataSourcesList;
    get description(): string;
    private _destinations;
    get destinations(): DataAzurermMonitorDataCollectionRuleDestinationsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMonitorDataCollectionRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorDataCollectionRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMonitorDataCollectionRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
