import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorScheduledQueryRulesAlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#id DataAzurermMonitorScheduledQueryRulesAlert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#name DataAzurermMonitorScheduledQueryRulesAlert#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#resource_group_name DataAzurermMonitorScheduledQueryRulesAlert#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#timeouts DataAzurermMonitorScheduledQueryRulesAlert#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorScheduledQueryRulesAlertTimeouts;
}
export interface DataAzurermMonitorScheduledQueryRulesAlertAction {
}
export declare function dataAzurermMonitorScheduledQueryRulesAlertActionToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesAlertAction): any;
export declare class DataAzurermMonitorScheduledQueryRulesAlertActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesAlertAction | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesAlertAction | undefined);
    get actionGroup(): string[];
    get customWebhookPayload(): string;
    get emailSubject(): string;
}
export declare class DataAzurermMonitorScheduledQueryRulesAlertActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorScheduledQueryRulesAlertActionOutputReference;
}
export interface DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTrigger {
}
export declare function dataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTriggerToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTrigger): any;
export declare class DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTrigger | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTrigger | undefined);
    get metricColumn(): string;
    get metricTriggerType(): string;
    get operator(): string;
    get threshold(): number;
}
export declare class DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTriggerOutputReference;
}
export interface DataAzurermMonitorScheduledQueryRulesAlertTrigger {
}
export declare function dataAzurermMonitorScheduledQueryRulesAlertTriggerToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesAlertTrigger): any;
export declare class DataAzurermMonitorScheduledQueryRulesAlertTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesAlertTrigger | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesAlertTrigger | undefined);
    private _metricTrigger;
    get metricTrigger(): DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTriggerList;
    get operator(): string;
    get threshold(): number;
}
export declare class DataAzurermMonitorScheduledQueryRulesAlertTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorScheduledQueryRulesAlertTriggerOutputReference;
}
export interface DataAzurermMonitorScheduledQueryRulesAlertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#read DataAzurermMonitorScheduledQueryRulesAlert#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorScheduledQueryRulesAlertTimeoutsToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference | DataAzurermMonitorScheduledQueryRulesAlertTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesAlertTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesAlertTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert}
*/
export declare class DataAzurermMonitorScheduledQueryRulesAlert extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_monitor_scheduled_query_rules_alert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorScheduledQueryRulesAlertConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorScheduledQueryRulesAlertConfig);
    private _action;
    get action(): DataAzurermMonitorScheduledQueryRulesAlertActionList;
    get authorizedResourceIds(): string[];
    get dataSourceId(): string;
    get description(): string;
    get enabled(): cdktf.IResolvable;
    get frequency(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get query(): string;
    get queryType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get severity(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    get throttling(): number;
    get timeWindow(): number;
    private _trigger;
    get trigger(): DataAzurermMonitorScheduledQueryRulesAlertTriggerList;
    private _timeouts;
    get timeouts(): DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorScheduledQueryRulesAlertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMonitorScheduledQueryRulesAlertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
