import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LighthouseDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#description LighthouseDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#id LighthouseDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#lighthouse_definition_id LighthouseDefinition#lighthouse_definition_id}
    */
    readonly lighthouseDefinitionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#managing_tenant_id LighthouseDefinition#managing_tenant_id}
    */
    readonly managingTenantId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#name LighthouseDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#scope LighthouseDefinition#scope}
    */
    readonly scope: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#authorization LighthouseDefinition#authorization}
    */
    readonly authorization: LighthouseDefinitionAuthorization[] | cdktf.IResolvable;
    /**
    * eligible_authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#eligible_authorization LighthouseDefinition#eligible_authorization}
    */
    readonly eligibleAuthorization?: LighthouseDefinitionEligibleAuthorization[] | cdktf.IResolvable;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#plan LighthouseDefinition#plan}
    */
    readonly plan?: LighthouseDefinitionPlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#timeouts LighthouseDefinition#timeouts}
    */
    readonly timeouts?: LighthouseDefinitionTimeouts;
}
export interface LighthouseDefinitionAuthorization {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#delegated_role_definition_ids LighthouseDefinition#delegated_role_definition_ids}
    */
    readonly delegatedRoleDefinitionIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#principal_display_name LighthouseDefinition#principal_display_name}
    */
    readonly principalDisplayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#principal_id LighthouseDefinition#principal_id}
    */
    readonly principalId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#role_definition_id LighthouseDefinition#role_definition_id}
    */
    readonly roleDefinitionId: string;
}
export declare function lighthouseDefinitionAuthorizationToTerraform(struct?: LighthouseDefinitionAuthorization | cdktf.IResolvable): any;
export declare class LighthouseDefinitionAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LighthouseDefinitionAuthorization | cdktf.IResolvable | undefined;
    set internalValue(value: LighthouseDefinitionAuthorization | cdktf.IResolvable | undefined);
    private _delegatedRoleDefinitionIds?;
    get delegatedRoleDefinitionIds(): string[];
    set delegatedRoleDefinitionIds(value: string[]);
    resetDelegatedRoleDefinitionIds(): void;
    get delegatedRoleDefinitionIdsInput(): string[] | undefined;
    private _principalDisplayName?;
    get principalDisplayName(): string;
    set principalDisplayName(value: string);
    resetPrincipalDisplayName(): void;
    get principalDisplayNameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
}
export declare class LighthouseDefinitionAuthorizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LighthouseDefinitionAuthorization[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LighthouseDefinitionAuthorizationOutputReference;
}
export interface LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#principal_display_name LighthouseDefinition#principal_display_name}
    */
    readonly principalDisplayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#principal_id LighthouseDefinition#principal_id}
    */
    readonly principalId: string;
}
export declare function lighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApproverToTerraform(struct?: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover | cdktf.IResolvable): any;
export declare class LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApproverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover | cdktf.IResolvable | undefined;
    set internalValue(value: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover | cdktf.IResolvable | undefined);
    private _principalDisplayName?;
    get principalDisplayName(): string;
    set principalDisplayName(value: string);
    resetPrincipalDisplayName(): void;
    get principalDisplayNameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
}
export declare class LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApproverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApproverOutputReference;
}
export interface LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#maximum_activation_duration LighthouseDefinition#maximum_activation_duration}
    */
    readonly maximumActivationDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#multi_factor_auth_provider LighthouseDefinition#multi_factor_auth_provider}
    */
    readonly multiFactorAuthProvider?: string;
    /**
    * approver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#approver LighthouseDefinition#approver}
    */
    readonly approver?: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover[] | cdktf.IResolvable;
}
export declare function lighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyToTerraform(struct?: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyOutputReference | LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicy): any;
export declare class LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicy | undefined;
    set internalValue(value: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicy | undefined);
    private _maximumActivationDuration?;
    get maximumActivationDuration(): string;
    set maximumActivationDuration(value: string);
    resetMaximumActivationDuration(): void;
    get maximumActivationDurationInput(): string | undefined;
    private _multiFactorAuthProvider?;
    get multiFactorAuthProvider(): string;
    set multiFactorAuthProvider(value: string);
    resetMultiFactorAuthProvider(): void;
    get multiFactorAuthProviderInput(): string | undefined;
    private _approver;
    get approver(): LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApproverList;
    putApprover(value: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover[] | cdktf.IResolvable): void;
    resetApprover(): void;
    get approverInput(): cdktf.IResolvable | LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover[] | undefined;
}
export interface LighthouseDefinitionEligibleAuthorization {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#principal_display_name LighthouseDefinition#principal_display_name}
    */
    readonly principalDisplayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#principal_id LighthouseDefinition#principal_id}
    */
    readonly principalId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#role_definition_id LighthouseDefinition#role_definition_id}
    */
    readonly roleDefinitionId: string;
    /**
    * just_in_time_access_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#just_in_time_access_policy LighthouseDefinition#just_in_time_access_policy}
    */
    readonly justInTimeAccessPolicy?: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicy;
}
export declare function lighthouseDefinitionEligibleAuthorizationToTerraform(struct?: LighthouseDefinitionEligibleAuthorization | cdktf.IResolvable): any;
export declare class LighthouseDefinitionEligibleAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LighthouseDefinitionEligibleAuthorization | cdktf.IResolvable | undefined;
    set internalValue(value: LighthouseDefinitionEligibleAuthorization | cdktf.IResolvable | undefined);
    private _principalDisplayName?;
    get principalDisplayName(): string;
    set principalDisplayName(value: string);
    resetPrincipalDisplayName(): void;
    get principalDisplayNameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
    private _justInTimeAccessPolicy;
    get justInTimeAccessPolicy(): LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicyOutputReference;
    putJustInTimeAccessPolicy(value: LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicy): void;
    resetJustInTimeAccessPolicy(): void;
    get justInTimeAccessPolicyInput(): LighthouseDefinitionEligibleAuthorizationJustInTimeAccessPolicy | undefined;
}
export declare class LighthouseDefinitionEligibleAuthorizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LighthouseDefinitionEligibleAuthorization[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LighthouseDefinitionEligibleAuthorizationOutputReference;
}
export interface LighthouseDefinitionPlan {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#name LighthouseDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#product LighthouseDefinition#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#publisher LighthouseDefinition#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#version LighthouseDefinition#version}
    */
    readonly version: string;
}
export declare function lighthouseDefinitionPlanToTerraform(struct?: LighthouseDefinitionPlanOutputReference | LighthouseDefinitionPlan): any;
export declare class LighthouseDefinitionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LighthouseDefinitionPlan | undefined;
    set internalValue(value: LighthouseDefinitionPlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface LighthouseDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#create LighthouseDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#delete LighthouseDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#read LighthouseDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition#update LighthouseDefinition#update}
    */
    readonly update?: string;
}
export declare function lighthouseDefinitionTimeoutsToTerraform(struct?: LighthouseDefinitionTimeoutsOutputReference | LighthouseDefinitionTimeouts | cdktf.IResolvable): any;
export declare class LighthouseDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LighthouseDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LighthouseDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition azurerm_lighthouse_definition}
*/
export declare class LighthouseDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lighthouse_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lighthouse_definition azurerm_lighthouse_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LighthouseDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: LighthouseDefinitionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lighthouseDefinitionId?;
    get lighthouseDefinitionId(): string;
    set lighthouseDefinitionId(value: string);
    resetLighthouseDefinitionId(): void;
    get lighthouseDefinitionIdInput(): string | undefined;
    private _managingTenantId?;
    get managingTenantId(): string;
    set managingTenantId(value: string);
    get managingTenantIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _authorization;
    get authorization(): LighthouseDefinitionAuthorizationList;
    putAuthorization(value: LighthouseDefinitionAuthorization[] | cdktf.IResolvable): void;
    get authorizationInput(): cdktf.IResolvable | LighthouseDefinitionAuthorization[] | undefined;
    private _eligibleAuthorization;
    get eligibleAuthorization(): LighthouseDefinitionEligibleAuthorizationList;
    putEligibleAuthorization(value: LighthouseDefinitionEligibleAuthorization[] | cdktf.IResolvable): void;
    resetEligibleAuthorization(): void;
    get eligibleAuthorizationInput(): cdktf.IResolvable | LighthouseDefinitionEligibleAuthorization[] | undefined;
    private _plan;
    get plan(): LighthouseDefinitionPlanOutputReference;
    putPlan(value: LighthouseDefinitionPlan): void;
    resetPlan(): void;
    get planInput(): LighthouseDefinitionPlan | undefined;
    private _timeouts;
    get timeouts(): LighthouseDefinitionTimeoutsOutputReference;
    putTimeouts(value: LighthouseDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LighthouseDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
