import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#description NetworkManager#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#id NetworkManager#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#location NetworkManager#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#name NetworkManager#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#resource_group_name NetworkManager#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#scope_accesses NetworkManager#scope_accesses}
    */
    readonly scopeAccesses: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#tags NetworkManager#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * scope block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#scope NetworkManager#scope}
    */
    readonly scope: NetworkManagerScope;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#timeouts NetworkManager#timeouts}
    */
    readonly timeouts?: NetworkManagerTimeouts;
}
export interface NetworkManagerCrossTenantScopes {
}
export declare function networkManagerCrossTenantScopesToTerraform(struct?: NetworkManagerCrossTenantScopes): any;
export declare class NetworkManagerCrossTenantScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkManagerCrossTenantScopes | undefined;
    set internalValue(value: NetworkManagerCrossTenantScopes | undefined);
    get managementGroups(): string[];
    get subscriptions(): string[];
    get tenantId(): string;
}
export declare class NetworkManagerCrossTenantScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkManagerCrossTenantScopesOutputReference;
}
export interface NetworkManagerScope {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#management_group_ids NetworkManager#management_group_ids}
    */
    readonly managementGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#subscription_ids NetworkManager#subscription_ids}
    */
    readonly subscriptionIds?: string[];
}
export declare function networkManagerScopeToTerraform(struct?: NetworkManagerScopeOutputReference | NetworkManagerScope): any;
export declare class NetworkManagerScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerScope | undefined;
    set internalValue(value: NetworkManagerScope | undefined);
    private _managementGroupIds?;
    get managementGroupIds(): string[];
    set managementGroupIds(value: string[]);
    resetManagementGroupIds(): void;
    get managementGroupIdsInput(): string[] | undefined;
    private _subscriptionIds?;
    get subscriptionIds(): string[];
    set subscriptionIds(value: string[]);
    resetSubscriptionIds(): void;
    get subscriptionIdsInput(): string[] | undefined;
}
export interface NetworkManagerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#create NetworkManager#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#delete NetworkManager#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#read NetworkManager#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager#update NetworkManager#update}
    */
    readonly update?: string;
}
export declare function networkManagerTimeoutsToTerraform(struct?: NetworkManagerTimeoutsOutputReference | NetworkManagerTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager azurerm_network_manager}
*/
export declare class NetworkManager extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_manager";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_manager azurerm_network_manager} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagerConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagerConfig);
    private _crossTenantScopes;
    get crossTenantScopes(): NetworkManagerCrossTenantScopesList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopeAccesses?;
    get scopeAccesses(): string[];
    set scopeAccesses(value: string[]);
    get scopeAccessesInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _scope;
    get scope(): NetworkManagerScopeOutputReference;
    putScope(value: NetworkManagerScope): void;
    get scopeInput(): NetworkManagerScope | undefined;
    private _timeouts;
    get timeouts(): NetworkManagerTimeoutsOutputReference;
    putTimeouts(value: NetworkManagerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkManagerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
