# -*- coding: utf-8 -*-
"""Beautify the html documentation generated by `Sphinx`."""

import os
import sys
from typing import *

try:
    print("\nModify html files:")
    folder = os.path.join("doc", "build")
    paths = [
        os.path.join(folder, fn) for fn in os.listdir(folder) if fn.endswith(".html")
    ]
    for path in paths:
        path = os.path.abspath(path)
        print("  " + path)
        sys.stdout.flush()
        lines: List[str] = []
        with open(path) as file_:
            for line in file_.readlines():
                if line.startswith("<dd><p>alias of <a " 'class="reference external"'):
                    line = line.split("span")[1]
                    line = line.split(">")[1]
                    line = line.split("<")[0]
                    lines[-1] = lines[-1].replace(
                        "TYPE</code>",
                        'TYPE</code><em class="property"> = %s</em>' % line,
                    )
                else:
                    lines.append(line)
        with open(path, "w") as file_:
            file_.write("".join(lines))
except BaseException as exc:
    print(exc)
    sys.exit(1)
else:
    sys.exit(0)
