import datetime as dt


def get_queries(today: str | None = None):
    """Return query templates for Stock endpoints.

    Parameters
    ----------
    today : str, optional
        Date string in ``YYYY-MM-DD`` format used for historical queries.
        Defaults to ``datetime.date.today()``.
    """
    today = today or dt.date.today().strftime("%Y-%m-%d")
    return [{'name': 'company_profile',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/companyProfile/<STOCK_ID>?clientId=MDC&component=sal-company-profile&version=4.65.0'},
 {'name': 'dividends',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/dividends/v4/<STOCK_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-dividends&version=4.65.0'},
 {'name': 'equity_overview',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/equityOverview/<STOCK_ID>/data?showAnalystRating=true&hideesg=true&clientId=MDC&benchmarkId=undefined&component=sal-eqsv-overview&version=4.65.0'},
 {'name': 'esg_risk_rating_assessment',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/esgRisk/<STOCK_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-eqsv-risk-rating-assessment&version=4.65.0'},
 {'name': 'esg_risk_rating_breakdown',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/esgRisk/sustainability/<STOCK_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-eqsv-risk-rating-breakdown&version=4.65.0'},
 {'name': 'insiders_board_of_directors',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/insiders/boardOfDirectors/<STOCK_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-executive&version=4.65.0'},
 {'name': 'insiders_key_executives',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/insiders/keyExecutives/<STOCK_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-executive&version=4.65.0'},
 {'name': 'insiders_transaction_chart',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/insiders/transactionChart/<STOCK_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-transaction-history&version=4.65.0'},
 {'name': 'insiders_transaction_history',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/insiders/transactionHistory/<STOCK_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-transaction-history&version=4.65.0'},
 {'name': 'key_metrics_cashflow',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/keyMetrics/cashFlow/<STOCK_ID>?clientId=MDC&benchmarkId=undefined&component=sal-eqsv-key-metrics-cash-flow&version=4.65.0'},
 {'name': 'key_metrics_financial_health',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/keyMetrics/financialHealth/<STOCK_ID>?clientId=MDC&benchmarkId=undefined&component=sal-eqsv-key-metrics-financial-health&version=4.65.0'},
 {'name': 'key_metrics_profitability_and_efficiency',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/keyMetrics/profitabilityAndEfficiency/<STOCK_ID>?clientId=MDC&benchmarkId=undefined&component=sal-eqsv-key-metrics-profitability-efficiency&version=4.65.0'},
 {'name': 'key_metrics_summary',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/keyMetrics/summary/<STOCK_ID>?reportType=A&clientId=MDC&benchmarkId=undefined&component=sal-eqsv-key-metrics-financial-summary&version=4.65.0'},
 {'name': 'key_stats_growth_table',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/keyStats/growthTable/<STOCK_ID>?clientId=MDC&benchmarkId=undefined&component=sal-eqsv-key-metrics-growth&version=4.65.0'},
 {'name': 'quote_mini_chart_realtime_data',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/miniChartRealTimeData/v2/<STOCK_ID>/0?secExchangeList=&random=0.7512089206425743&clientId=MDC&benchmarkId=mstarorcat&component=sal-mini-quote-chart&version=4.65.0'},
 {'name': 'financials_balance_sheet_annual',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/newfinancials/<STOCK_ID>/balanceSheet/detail?dataType=A&reportType=A&locale=fr&clientId=MDC&benchmarkId=undefined&component=sal-equity-financials&version=4.65.0'},
 {'name': 'financials_balance_sheet_quarterly',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/newfinancials/<STOCK_ID>/balanceSheet/detail?dataType=Q&reportType=A&locale=fr&clientId=MDC&benchmarkId=undefined&component=sal-equity-financials&version=4.65.0'},
 {'name': 'financials_cash_flow_annual',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/newfinancials/<STOCK_ID>/cashFlow/detail?dataType=A&reportType=A&locale=fr&clientId=MDC&benchmarkId=undefined&component=sal-equity-financials&version=4.65.0'},
 {'name': 'financials_cash_flow_quarterly',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/newfinancials/<STOCK_ID>/cashFlow/detail?dataType=Q&reportType=A&locale=fr&clientId=MDC&benchmarkId=undefined&component=sal-equity-financials&version=4.65.0'},
 {'name': 'financials_income_statement_annual',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/newfinancials/<STOCK_ID>/incomeStatement/detail?dataType=A&reportType=A&locale=fr&clientId=MDC&benchmarkId=undefined&component=sal-equity-financials&version=4.65.0'},
 {'name': 'financials_income_statement_quarterly',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/newfinancials/<STOCK_ID>/incomeStatement/detail?dataType=Q&reportType=A&locale=fr&clientId=MDC&benchmarkId=undefined&component=sal-equity-financials&version=4.65.0'},
 {'name': 'ownership_institutional_buyers',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/Buyers/institution/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'ownership_mutual_fund_buyers',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/Buyers/mutualfund/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'ownership_concentrated_institutional_owners',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/ConcentratedOwners/institution/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'ownership_concentrated_mutual_fund_owners',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/ConcentratedOwners/mutualfund/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'ownership_institutional',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/OwnershipData/institution/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'ownership_mutual_fund',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/OwnershipData/mutualfund/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'ownership_institutional_sellers',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/Sellers/institution/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'ownership_mutual_fund_sellers',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/ownership/v1/<STOCK_ID>/Sellers/mutualfund/20/data?clientId=MDC&benchmarkId=undefined&component=sal-ownership&version=4.65.0'},
 {'name': 'realtime_quote',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/realTime/v3/<STOCK_ID>/data?secExchangeList=&random=0.5996806301492645&clientId=MDC&benchmarkId=undefined&component=sal-eqsv-quote&version=4.65.0'},
 {'name': 'splits',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/split/v1/<STOCK_ID>/data?locale=fr&clientId=MDC&benchmarkId=undefined&component=sal-dividends&version=4.65.0'},
 {'name': 'trading_information',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/tradingInformation/<STOCK_ID>/data?clientId=MDC&component=sal-eqsv-trading-information&version=4.65.0'},
 {'name': 'trailing_total_returns_daily',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/trailingTotalReturns/<STOCK_ID>/data?dataType=d&clientId=MDC&benchmarkId=undefined&component=sal-trailing-returns&version=4.65.0'},
 {'name': 'trailing_total_returns_monthly',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/trailingTotalReturns/<STOCK_ID>/data?dataType=m&clientId=MDC&benchmarkId=undefined&component=sal-trailing-returns&version=4.65.0'},
 {'name': 'trailing_total_returns_quarterly',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/trailingTotalReturns/<STOCK_ID>/data?dataType=q&clientId=MDC&benchmarkId=undefined&component=sal-trailing-returns&version=4.65.0'},
 {'name': 'valuation',
  'type': 'stock',
  'url': 'https://api-global.morningstar.com/sal-service/v1/stock/valuation/v3/<STOCK_ID>?clientId=MDC&benchmarkId=undefined&component=sal-valuation&version=4.65.0'},
 {'name': 'history_rolling_eps_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:EPSRolling&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_rolling_eps_short_interest_ratio_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:EPSRolling,shortInterestRatio&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_to_book_price_to_cash_flow_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:PB,PCF&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_to_cash_flow_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:PCF&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_pe_ratio_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:PE&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_pe_ratio_price_to_sales_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:PE,PS&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_to_sales_price_to_book_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:PS,PB&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_dividends_earnings_splits_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:dividend,earning,split&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_market_total_return_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:marketTotalReturn&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_daily',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:open,high,low,close,volume,previousClose&frequency=d&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:open,high,low,close,volume,previousClose&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_currency_var_monthly',
  'type': 'stock',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<STOCK_ID>:open,high,low,close,volume,previousClose&query=CU$$$$$EUR:marketTotalReturn&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'market_id_information',
  'type': 'stock',
  'url': 'https://www.us-api.morningstar.com/QS-markets/ra/idService?symbol=<STOCK_ID>&trackMarketData=3.6.3&instid=DOTCOM'}]
