/*
 * Decompiled with CFR 0.152.
 */
package bridge;

import bridge.CertoraConf;
import bridge.CertoraConfKt;
import bridge.SingleDeployedContract;
import bridge.VerificationQuery;
import bridge.VerificationQueryType;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.JsonKt;
import log.ArtifactManagerFactory;
import log.IArtifactsManager;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtils;
import utils.CertoraErrorType;
import utils.CertoraException;
import utils.CertoraFileCache;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u0006J\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J \u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J/\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00130\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u00a8\u0006\u001d"}, d2={"Lbridge/CertoraConf;", "", "()V", "copyInputs", "", "buildFilename", "", "verificationFilename", "cfgFileNames", "", "metadataFilename", "loadBuildConf", "", "Lbridge/SingleDeployedContract;", "Lbridge/BuildConf;", "filename", "loadBuildConfFromJsonStr", "jsonStr", "loadConf", "C", "fileName", "loader", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "loadVerificationConf", "Lbridge/VerificationQuery;", "loadVerificationConfFromJsonStr", "validateVerificationQueries", "verificationQuery", "Shared"})
@SourceDebugExtension(value={"SMAP\nCertoraConf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertoraConf.kt\nbridge/CertoraConf\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n1726#3,3:127\n1855#3,2:130\n*S KotlinDebug\n*F\n+ 1 CertoraConf.kt\nbridge/CertoraConf\n*L\n93#1:127,3\n119#1:130,2\n*E\n"})
public final class CertoraConf {
    @NotNull
    public static final CertoraConf INSTANCE = new CertoraConf();

    private CertoraConf() {
    }

    private final Map<String, SingleDeployedContract> loadBuildConfFromJsonStr(String jsonStr) {
        Map map2;
        try {
            map2 = (Map)JsonKt.Json$default(null, loadBuildConfFromJsonStr.1.INSTANCE, 1, null).decodeFromString((DeserializationStrategy)BuiltinSerializersKt.MapSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE), SingleDeployedContract.Companion.serializer()), jsonStr);
        }
        catch (SerializationException e) {
            throw new CertoraException(CertoraErrorType.INCOMPATIBLE_SERIALIZATION, "The Certora CLI version is incompatible with the Certora Cloud version. You may need to update your Certora CLI. Users running on a specific Prover branch may need to install a specific CLI release.", e);
        }
        return map2;
    }

    private final VerificationQuery loadVerificationConfFromJsonStr(String jsonStr) {
        VerificationQuery verificationQuery2;
        try {
            verificationQuery2 = (VerificationQuery)JsonKt.Json$default(null, loadVerificationConfFromJsonStr.verificationQuery.1.INSTANCE, 1, null).decodeFromString((DeserializationStrategy)VerificationQuery.Companion.serializer(), jsonStr);
        }
        catch (SerializationException e) {
            throw new CertoraException(CertoraErrorType.INCOMPATIBLE_SERIALIZATION, "The Certora CLI version is incompatible with the Certora Cloud version. You may need to update your Certora CLI. Users running on a specific Prover branch may need to install a specific CLI release.", e);
        }
        VerificationQuery verificationQuery3 = verificationQuery2;
        this.validateVerificationQueries(verificationQuery3);
        return verificationQuery3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <C> C loadConf(String fileName, Function1<? super String, ? extends C> loader) {
        String string;
        Object object = CertoraFileCache.INSTANCE.getContentReader(fileName);
        Throwable throwable = null;
        try {
            Reader it2 = (Reader)object;
            boolean bl = false;
            string = TextStreamsKt.readText(it2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        object = string;
        return loader.invoke((String)object);
    }

    @NotNull
    public final VerificationQuery loadVerificationConf(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return (VerificationQuery)this.loadConf(filename, (Function1)new Function1<String, VerificationQuery>((Object)this){

            @NotNull
            public final VerificationQuery invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return CertoraConf.access$loadVerificationConfFromJsonStr((CertoraConf)this.receiver, p0);
            }
        });
    }

    @NotNull
    public final Map<String, SingleDeployedContract> loadBuildConf(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return (Map)this.loadConf(filename, (Function1)new Function1<String, Map<String, ? extends SingleDeployedContract>>((Object)this){

            @NotNull
            public final Map<String, SingleDeployedContract> invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return CertoraConf.access$loadBuildConfFromJsonStr((CertoraConf)this.receiver, p0);
            }
        });
    }

    private final void validateVerificationQueries(VerificationQuery verificationQuery2) {
        block9: {
            block10: {
                boolean bl;
                block7: {
                    block8: {
                        if (verificationQuery2.getType() != VerificationQueryType.spec || !StringsKt.isBlank(verificationQuery2.getPrimary_contract())) break block8;
                        CertoraConfKt.access$getLogger$p().error("Primary contract for spec verification query " + verificationQuery2 + " is blank");
                        break block9;
                    }
                    if (verificationQuery2.getType() != VerificationQueryType.assertion) break block9;
                    Collection collection = verificationQuery2.getPrimaryContracts();
                    if (collection == null || collection.isEmpty()) break block10;
                    Iterable $this$all$iv = verificationQuery2.getPrimaryContracts();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it2 = (String)element$iv;
                            boolean bl2 = false;
                            if (StringsKt.isBlank(it2)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block9;
            }
            CertoraConfKt.access$getLogger$p().error("No primary contracts for assertion verification query " + verificationQuery2);
        }
    }

    public final void copyInputs(@NotNull String buildFilename, @NotNull String verificationFilename, @NotNull Set<String> cfgFileNames, @NotNull String metadataFilename) {
        Intrinsics.checkNotNullParameter(buildFilename, "buildFilename");
        Intrinsics.checkNotNullParameter(verificationFilename, "verificationFilename");
        Intrinsics.checkNotNullParameter(cfgFileNames, "cfgFileNames");
        Intrinsics.checkNotNullParameter(metadataFilename, "metadataFilename");
        IArtifactsManager manager = ArtifactManagerFactory.INSTANCE.invoke();
        manager.backup(buildFilename, CertoraConf.copyInputs$getBackupFileName(manager, CertoraConf.copyInputs$trimPath(buildFilename)));
        manager.backup(verificationFilename, CertoraConf.copyInputs$getBackupFileName(manager, CertoraConf.copyInputs$trimPath(verificationFilename)));
        Iterable $this$forEach$iv = cfgFileNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            manager.backup(it2, CertoraConf.copyInputs$getBackupFileName(manager, it2));
        }
        if (new File(metadataFilename).exists()) {
            manager.backup(metadataFilename, CertoraConf.copyInputs$getBackupFileName(manager, CertoraConf.copyInputs$trimPath(metadataFilename)));
        }
    }

    private static final String copyInputs$getBackupFileName(IArtifactsManager manager, String fileName) {
        return manager.getInputsDir() + File.separator + fileName;
    }

    private static final String copyInputs$trimPath(String fileName) {
        return ArtifactFileUtils.INSTANCE.getNameFromPath(fileName);
    }

    public static final /* synthetic */ VerificationQuery access$loadVerificationConfFromJsonStr(CertoraConf $this, String jsonStr) {
        return $this.loadVerificationConfFromJsonStr(jsonStr);
    }

    public static final /* synthetic */ Map access$loadBuildConfFromJsonStr(CertoraConf $this, String jsonStr) {
        return $this.loadBuildConfFromJsonStr(jsonStr);
    }
}

