/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.LabelledGraph;
import datastructures.MultiMapKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004BO\u0012(\u0010\u0005\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\b\u0012\u001e\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\n\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rJ#\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J*\u0010\u0014\u001a\u00020\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0016\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017R&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\n\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0005\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldatastructures/MutableLabelledGraph;", "V", "E", "", "()V", "relation", "", "", "Ldatastructures/MutableMultiMap;", "labelMapping", "Lkotlin/Pair;", "(Ljava/util/Map;Ljava/util/Map;)V", "freeze", "Ldatastructures/LabelledGraph;", "put", "", "src", "lab", "tgt", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "set", "pair", "label", "(Lkotlin/Pair;Ljava/lang/Object;)V", "GeneralUtils"})
public final class MutableLabelledGraph<V, E> {
    @NotNull
    private final Map<V, Set<V>> relation;
    @NotNull
    private final Map<Pair<V, V>, E> labelMapping;

    public MutableLabelledGraph(@NotNull Map<V, Set<V>> relation, @NotNull Map<Pair<V, V>, E> labelMapping) {
        Intrinsics.checkNotNullParameter(relation, "relation");
        Intrinsics.checkNotNullParameter(labelMapping, "labelMapping");
        this.relation = relation;
        this.labelMapping = labelMapping;
    }

    public MutableLabelledGraph() {
        this(MultiMapKt.mutableMultiMapOf(), new LinkedHashMap());
    }

    public final void set(@NotNull Pair<? extends V, ? extends V> pair2, E label) {
        Intrinsics.checkNotNullParameter(pair2, "pair");
        this.put(pair2.getFirst(), label, pair2.getSecond());
    }

    public final void put(V src, E lab, V tgt) {
        MultiMapKt.add(this.relation, src, tgt);
        this.labelMapping.put(TuplesKt.to(src, tgt), lab);
    }

    @NotNull
    public final LabelledGraph<V, E> freeze() {
        return new LabelledGraph<V, E>(this.relation, this.labelMapping);
    }
}

