/*
 * Decompiled with CFR 0.152.
 */
package evm;

import evm.EVMConstsKt;
import evm.EVMOpsKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J&\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u000f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0013\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\u0014\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J&\u0010\u0015\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0018\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0019\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u001a\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u001b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u001c\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u001f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010 \u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010!\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\"\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006$"}, d2={"Levm/EVMOps;", "", "()V", "add", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "a", "b", "addMod", "m", "and", "div", "eq", "exp", "ge", "gt", "isZero", "le", "lt", "mod", "mul", "mulMod", "not", "or", "sar", "sdiv", "sge", "sgt", "shl", "shr", "signExtend", "sle", "slt", "smod", "sub", "xor", "GeneralUtils"})
public final class EVMOps {
    @NotNull
    public static final EVMOps INSTANCE = new EVMOps();

    private EVMOps() {
    }

    public final BigInteger add(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger = a.add(b);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "add(...)");
        return bigInteger.mod(EVMConstsKt.getEVM_MOD_GROUP256());
    }

    public final BigInteger sub(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger = a.subtract(b);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "subtract(...)");
        return bigInteger.mod(EVMConstsKt.getEVM_MOD_GROUP256());
    }

    public final BigInteger mul(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger = a.multiply(b);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "multiply(...)");
        return bigInteger.mod(EVMConstsKt.getEVM_MOD_GROUP256());
    }

    public final BigInteger div(@NotNull BigInteger a, @NotNull BigInteger b) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (Intrinsics.areEqual(b, BigInteger.ZERO)) {
            bigInteger = BigInteger.ZERO;
        } else {
            BigInteger bigInteger2 = a.divide(b);
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "divide(...)");
        }
        return bigInteger;
    }

    public final BigInteger sdiv(@NotNull BigInteger a, @NotNull BigInteger b) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (Intrinsics.areEqual(a, BigInteger.ZERO) || Intrinsics.areEqual(b, BigInteger.ZERO)) {
            bigInteger = BigInteger.ZERO;
        } else if (EVMOps.sdiv$posSign(a) == EVMOps.sdiv$posSign(b)) {
            BigInteger bigInteger2 = EVMOps.sdiv$abs(a).divide(EVMOps.sdiv$abs(b));
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "divide(...)");
        } else {
            BigInteger bigInteger3 = EVMOps.sdiv$abs(a).divide(EVMOps.sdiv$abs(b));
            Intrinsics.checkNotNullExpressionValue(bigInteger3, "divide(...)");
            bigInteger = EVMOps.sdiv$neg(bigInteger3);
        }
        return bigInteger;
    }

    public final BigInteger exp(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.modPow(b, EVMConstsKt.getEVM_MOD_GROUP256());
    }

    public final BigInteger mod(@NotNull BigInteger a, @NotNull BigInteger m) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(m, "m");
        return a.mod(m).mod(EVMConstsKt.getEVM_MOD_GROUP256());
    }

    public final BigInteger smod(@NotNull BigInteger a, @NotNull BigInteger m) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(m, "m");
        BigInteger res2 = a.mod(m);
        boolean bl = false;
        if (a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) > 0) {
            Intrinsics.checkNotNull(res2);
            BigInteger bigInteger2 = res2.subtract(m);
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "subtract(...)");
        } else {
            bigInteger = res2;
        }
        return bigInteger;
    }

    @NotNull
    public final BigInteger signExtend(@NotNull BigInteger a, @NotNull BigInteger b) {
        BigInteger bigInteger;
        BigInteger bitLengthOfB;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (!(a.compareTo(BigInteger.ZERO) >= 0 && a.compareTo(EVMConstsKt.getEVM_WORD_SIZE()) < 0)) {
            boolean $i$a$-check-EVMOps$signExtend$22 = false;
            String $i$a$-check-EVMOps$signExtend$22 = "Expected a to be a byte offset at least 0 and less than " + EVMConstsKt.getEVM_WORD_SIZE() + ", but got a=" + a;
            throw new IllegalStateException($i$a$-check-EVMOps$signExtend$22.toString());
        }
        BigInteger $i$a$-check-EVMOps$signExtend$22 = a;
        BigInteger bigInteger2 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue(bigInteger2, "ONE");
        BigInteger bigInteger3 = $i$a$-check-EVMOps$signExtend$22.add(bigInteger2);
        Intrinsics.checkNotNullExpressionValue(bigInteger3, "add(...)");
        $i$a$-check-EVMOps$signExtend$22 = bigInteger3;
        BigInteger bigInteger4 = BigInteger.valueOf(8);
        Intrinsics.checkNotNullExpressionValue(bigInteger4, "valueOf(...)");
        BigInteger bigInteger5 = bigInteger4;
        BigInteger bigInteger6 = $i$a$-check-EVMOps$signExtend$22.multiply(bigInteger5);
        Intrinsics.checkNotNullExpressionValue(bigInteger6, "multiply(...)");
        bigInteger5 = bitLengthOfB = bigInteger6;
        BigInteger bigInteger7 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue(bigInteger7, "ONE");
        BigInteger bigInteger8 = bigInteger5.subtract(bigInteger7);
        Intrinsics.checkNotNullExpressionValue(bigInteger8, "subtract(...)");
        BigInteger bSignBitPos = bigInteger8;
        boolean bSignBitValue = !Intrinsics.areEqual(b.and(BigInteger.ZERO.setBit(bSignBitPos.intValueExact())), BigInteger.ZERO);
        BigInteger bigInteger9 = BigInteger.ZERO.setBit(bitLengthOfB.intValueExact());
        Intrinsics.checkNotNullExpressionValue(bigInteger9, "setBit(...)");
        BigInteger bigInteger10 = bigInteger9;
        BigInteger bigInteger11 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue(bigInteger11, "ONE");
        BigInteger bigInteger12 = bigInteger10.subtract(bigInteger11);
        Intrinsics.checkNotNullExpressionValue(bigInteger12, "subtract(...)");
        BigInteger bOnesMask = bigInteger12;
        if (!bSignBitValue) {
            bigInteger10 = b.and(bOnesMask.or(EVMConstsKt.getEVM_MOD_GROUP256()));
            Intrinsics.checkNotNull(bigInteger10);
            bigInteger = bigInteger10;
        } else {
            if (!bSignBitValue) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            BigInteger bigInteger13 = EVMConstsKt.getMAX_EVM_UINT256().subtract(bOnesMask);
            Intrinsics.checkNotNullExpressionValue(bigInteger13, "subtract(...)");
            bigInteger10 = b.or(bigInteger13);
            Intrinsics.checkNotNull(bigInteger10);
            bigInteger = bigInteger10;
        }
        return bigInteger;
    }

    public final BigInteger addMod(@NotNull BigInteger a, @NotNull BigInteger b, @NotNull BigInteger m) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(m, "m");
        return a.add(b).mod(m);
    }

    public final BigInteger mulMod(@NotNull BigInteger a, @NotNull BigInteger b, @NotNull BigInteger m) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(m, "m");
        return a.multiply(b).mod(m);
    }

    public final BigInteger isZero(@NotNull BigInteger a) {
        Intrinsics.checkNotNullParameter(a, "a");
        return Intrinsics.areEqual(a, BigInteger.ZERO) ? BigInteger.ONE : BigInteger.ZERO;
    }

    public final BigInteger not(@NotNull BigInteger a) {
        Intrinsics.checkNotNullParameter(a, "a");
        return EVMConstsKt.getMAX_EVM_UINT256().andNot(a);
    }

    @NotNull
    public final BigInteger and(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger = a.and(b);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "and(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger or(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger = a.or(b);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "or(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger xor(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger = a.xor(b);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "xor(...)");
        return bigInteger;
    }

    public final BigInteger shl(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.shiftLeft(b.intValueExact()).mod(EVMConstsKt.getEVM_MOD_GROUP256());
    }

    @NotNull
    public final BigInteger shr(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger = a;
        BigInteger bigInteger2 = BigInteger.TWO.pow(b.intValueExact());
        Intrinsics.checkNotNullExpressionValue(bigInteger2, "pow(...)");
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        Intrinsics.checkNotNullExpressionValue(bigInteger3, "divide(...)");
        return bigInteger3;
    }

    public final BigInteger sar(@NotNull BigInteger a, @NotNull BigInteger b) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        BigInteger bigInteger2 = BigInteger.valueOf(256);
        Intrinsics.checkNotNullExpressionValue(bigInteger2, "valueOf(...)");
        if (b.compareTo(bigInteger2) >= 0) {
            bigInteger = a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) < 0 ? EVMConstsKt.getMAX_EVM_UINT256() : BigInteger.ZERO;
        } else {
            int k = b.intValue();
            if (a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) < 0) {
                BigInteger bigInteger3 = a.shiftRight(k);
                bigInteger = bigInteger3;
                Intrinsics.checkNotNullExpressionValue(bigInteger3, "shiftRight(...)");
            } else {
                BigInteger bigInteger4 = a.shiftRight(k);
                Intrinsics.checkNotNullExpressionValue(bigInteger4, "shiftRight(...)");
                BigInteger bigInteger5 = bigInteger4.add(EVMOpsKt.highOnes(k));
                bigInteger = bigInteger5;
                Intrinsics.checkNotNullExpressionValue(bigInteger5, "add(...)");
            }
        }
        return bigInteger;
    }

    public final BigInteger eq(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return Intrinsics.areEqual(a, b) ? BigInteger.ONE : BigInteger.ZERO;
    }

    public final BigInteger lt(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.compareTo(b) < 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    public final BigInteger gt(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return this.lt(b, a);
    }

    public final BigInteger le(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return Intrinsics.areEqual(a, b) ? BigInteger.ONE : this.lt(a, b);
    }

    public final BigInteger ge(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return this.le(b, a);
    }

    public final BigInteger slt(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return EVMOpsKt.signedIntsWithSameSign(a, b) ? (a.compareTo(b) < 0 ? BigInteger.ONE : BigInteger.ZERO) : (a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) > 0 && b.compareTo(EVMConstsKt.getMAX_EVM_INT256()) <= 0 ? BigInteger.ONE : BigInteger.ZERO);
    }

    public final BigInteger sgt(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return this.slt(b, a);
    }

    public final BigInteger sle(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return Intrinsics.areEqual(a, b) ? BigInteger.ONE : this.slt(a, b);
    }

    public final BigInteger sge(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return this.sle(b, a);
    }

    private static final boolean sdiv$posSign(BigInteger i) {
        return BigInteger.ZERO.compareTo(i) <= 0 && i.compareTo(EVMConstsKt.getMAX_EVM_INT256()) <= 0;
    }

    private static final BigInteger sdiv$neg(BigInteger i) {
        BigInteger bigInteger = EVMConstsKt.getMAX_EVM_UINT256();
        BigInteger bigInteger2 = i;
        BigInteger bigInteger3 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue(bigInteger3, "ONE");
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
        Intrinsics.checkNotNullExpressionValue(bigInteger4, "subtract(...)");
        bigInteger2 = bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(bigInteger2);
        Intrinsics.checkNotNullExpressionValue(bigInteger5, "subtract(...)");
        return bigInteger5;
    }

    private static final BigInteger sdiv$abs(BigInteger i) {
        return EVMOps.sdiv$posSign(i) ? i : EVMOps.sdiv$neg(i);
    }
}

