/*
 * Decompiled with CFR 0.152.
 */
package evm;

import evm.EVMConstsKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"highOnes", "Ljava/math/BigInteger;", "width", "", "lowOnes", "end", "onesRange", "start", "signedIntsWithSameSign", "", "a", "b", "GeneralUtils"})
public final class EVMOpsKt {
    @NotNull
    public static final BigInteger highOnes(int width) {
        BigInteger bigInteger = EVMConstsKt.getMAX_EVM_UINT256().subtract(EVMOpsKt.lowOnes(256 - width));
        Intrinsics.checkNotNullExpressionValue(bigInteger, "subtract(...)");
        return bigInteger;
    }

    @NotNull
    public static final BigInteger lowOnes(int end) {
        BigInteger bigInteger = BigInteger.ONE.shiftLeft(end);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "shiftLeft(...)");
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue(bigInteger3, "ONE");
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
        Intrinsics.checkNotNullExpressionValue(bigInteger4, "subtract(...)");
        return bigInteger4;
    }

    @NotNull
    public static final BigInteger onesRange(int start, int end) {
        BigInteger bigInteger = EVMOpsKt.lowOnes(end).subtract(EVMOpsKt.lowOnes(start));
        Intrinsics.checkNotNullExpressionValue(bigInteger, "subtract(...)");
        return bigInteger;
    }

    public static final boolean signedIntsWithSameSign(@NotNull BigInteger a, @NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) > 0 && b.compareTo(EVMConstsKt.getMAX_EVM_INT256()) > 0 || a.compareTo(EVMConstsKt.getMAX_EVM_INT256()) <= 0 && b.compareTo(EVMConstsKt.getMAX_EVM_INT256()) <= 0;
    }
}

