/*
 * Decompiled with CFR 0.152.
 */
package log;

import config.Config;
import config.DevMode;
import java.io.OutputStreamWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import log.LoggerKt;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.OutPrinter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u000f\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u0012\u0010\u0012\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u0012\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u0012\u0010\u0013\u001a\u00020\t*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0018\u0010\u0014\u001a\u00020\t*\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u001a0\u0010\u0018\u001a\u00020\t*\u00020\n2$\u0010\u0019\u001a \u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\t0\u001a\u0012\u0004\u0012\u00020\t0\u001a\u001a\u0012\u0010\u001b\u001a\u00020\t*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\f\u001a\u0012\u0010\u001d\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a/\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f*\u0004\u0018\u0001H\u001f2\u0006\u0010 \u001a\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u0016\u00a2\u0006\u0002\u0010\"\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006#"}, d2={"alwaysLogger", "Llog/Logger;", "regressionFile", "Ljava/io/OutputStreamWriter;", "getRegressionFile", "()Ljava/io/OutputStreamWriter;", "regressionFile$delegate", "Lkotlin/Lazy;", "always", "", "Llog/Logger$Companion;", "s", "", "respectQuiet", "", "alwaysError", "t", "", "alwaysWarn", "devError", "regression", "str", "Lkotlin/Function0;", "", "regressionPrinter", "printer", "Lkotlin/Function1;", "reportOnEventInCode", "eventInCodeName", "toLogFile", "warnIfNull", "T", "logger", "f", "(Ljava/lang/Object;Llog/Logger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Shared"})
public final class LoggerKt {
    @NotNull
    private static final Logger alwaysLogger = Logger.Companion.invoke(LoggerTypes.ALWAYS);
    @NotNull
    private static final Lazy regressionFile$delegate = LazyKt.lazy(regressionFile.2.INSTANCE);

    public static final void reportOnEventInCode(@NotNull Logger $this$reportOnEventInCode, @NotNull String eventInCodeName) {
        Intrinsics.checkNotNullParameter($this$reportOnEventInCode, "<this>");
        Intrinsics.checkNotNullParameter(eventInCodeName, "eventInCodeName");
        if ($this$reportOnEventInCode.isTraceEnabled()) {
            try {
                throw new Exception(eventInCodeName){};
            }
            catch (Exception e) {
                $this$reportOnEventInCode.debug(e, (Function0<? extends Object>)new Function0<Object>(eventInCodeName){
                    final /* synthetic */ String $eventInCodeName;
                    {
                        this.$eventInCodeName = $eventInCodeName;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "convenience stack trace for " + this.$eventInCodeName;
                    }
                });
            }
        }
    }

    public static final void always(@NotNull Logger.Companion $this$always, @NotNull String s, boolean respectQuiet) {
        Intrinsics.checkNotNullParameter($this$always, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        boolean beQuiet = respectQuiet && (Boolean)Config.INSTANCE.getQuietMode().get() != false;
        OutPrinter.INSTANCE.print(s, !beQuiet);
        alwaysLogger.info((Function0<? extends Object>)new Function0<Object>(s){
            final /* synthetic */ String $s;
            {
                this.$s = $s;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return this.$s;
            }
        });
    }

    public static final void toLogFile(@NotNull Logger.Companion $this$toLogFile, @NotNull String s) {
        Intrinsics.checkNotNullParameter($this$toLogFile, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        OutPrinter.print$default(OutPrinter.INSTANCE, s, false, 2, null);
        alwaysLogger.info((Function0<? extends Object>)new Function0<Object>(s){
            final /* synthetic */ String $s;
            {
                this.$s = $s;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return this.$s;
            }
        });
    }

    public static final void alwaysError(@NotNull Logger.Companion $this$alwaysError, @NotNull String s) {
        Intrinsics.checkNotNullParameter($this$alwaysError, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        LoggerKt.alwaysError($this$alwaysError, s, null);
    }

    public static final void alwaysError(@NotNull Logger.Companion $this$alwaysError, @NotNull String s, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter($this$alwaysError, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        OutPrinter.INSTANCE.printErrorToScreen(s);
        alwaysLogger.error(t, s);
    }

    public static final void devError(@NotNull Logger.Companion $this$devError, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter($this$devError, "<this>");
        Intrinsics.checkNotNullParameter(t, "t");
        if (DevMode.INSTANCE.isDevMode()) {
            LoggerKt.alwaysError(Logger.Companion, "Exception details:", t);
        }
    }

    public static final void alwaysWarn(@NotNull Logger.Companion $this$alwaysWarn, @NotNull String s, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter($this$alwaysWarn, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        OutPrinter.INSTANCE.printWarningToScreen(s);
        alwaysLogger.warn(t, (Function0<? extends Object>)new Function0<Object>(s){
            final /* synthetic */ String $s;
            {
                this.$s = $s;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return this.$s;
            }
        });
    }

    public static final void alwaysWarn(@NotNull Logger.Companion $this$alwaysWarn, @NotNull String s) {
        Intrinsics.checkNotNullParameter($this$alwaysWarn, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        LoggerKt.alwaysWarn($this$alwaysWarn, s, null);
    }

    private static final OutputStreamWriter getRegressionFile() {
        Lazy lazy = regressionFile$delegate;
        return (OutputStreamWriter)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void regression(@NotNull Logger.Companion $this$regression, @NotNull Function0<? extends Object> str2) {
        Intrinsics.checkNotNullParameter($this$regression, "<this>");
        Intrinsics.checkNotNullParameter(str2, "str");
        OutputStreamWriter outputStreamWriter = LoggerKt.getRegressionFile();
        if (outputStreamWriter != null) {
            OutputStreamWriter file = outputStreamWriter;
            boolean bl = false;
            Logger.Companion companion = $this$regression;
            synchronized (companion) {
                boolean bl2 = false;
                Appendable appendable = ((Appendable)file).append(str2.invoke().toString());
                Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
                Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
                file.flush();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public static final void regressionPrinter(@NotNull Logger.Companion $this$regressionPrinter, @NotNull Function1<? super Function1<? super Function0<? extends Object>, Unit>, Unit> printer) {
        block0: {
            Intrinsics.checkNotNullParameter($this$regressionPrinter, "<this>");
            Intrinsics.checkNotNullParameter(printer, "printer");
            OutputStreamWriter outputStreamWriter = LoggerKt.getRegressionFile();
            if (outputStreamWriter == null) break block0;
            OutputStreamWriter file = outputStreamWriter;
            boolean bl = false;
            printer.invoke(new Function1<Function0<? extends Object>, Unit>($this$regressionPrinter, file){
                final /* synthetic */ Logger.Companion $this_regressionPrinter;
                final /* synthetic */ OutputStreamWriter $file;
                {
                    this.$this_regressionPrinter = $receiver;
                    this.$file = $file;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull Function0<? extends Object> msg) {
                    Intrinsics.checkNotNullParameter(msg, "msg");
                    Object toPrint = msg.invoke();
                    Logger.Companion companion = this.$this_regressionPrinter;
                    OutputStreamWriter outputStreamWriter = this.$file;
                    Logger.Companion companion2 = companion;
                    synchronized (companion2) {
                        boolean bl = false;
                        Appendable appendable = ((Appendable)outputStreamWriter).append(toPrint.toString());
                        Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
                        Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
                        outputStreamWriter.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                }
            });
        }
    }

    @Nullable
    public static final <T> T warnIfNull(@Nullable T $this$warnIfNull, @NotNull Logger logger2, @NotNull Function0<String> f) {
        Intrinsics.checkNotNullParameter(logger2, "logger");
        Intrinsics.checkNotNullParameter(f, "f");
        if ($this$warnIfNull == null) {
            logger2.warn(f);
        }
        return $this$warnIfNull;
    }
}

