/*
 * Decompiled with CFR 0.152.
 */
package log;

import allocator.Allocator;
import config.Config;
import config.ConfigType;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import log.ArtifactLocation;
import log.ArtifactManagerFactory;
import log.DynamicArtifactLocation;
import log.IArtifactsManager;
import log.Logger;
import log.LoggerKt;
import log.LoggerTypes;
import log.RuleOutputArtifactsKey;
import log.StaticArtifactLocation;
import log.VersionedArtifact;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tac.DebuggableProgram;
import tac.DumpTime;
import tac.DumpType;
import tac.TACFile;
import utils.ArtifactFileUtils;
import utils.CertoraFileCache;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0004H\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0016J\u0018\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0016\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+H\u0016J0\u0010,\u001a\u00020-\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.012\u0006\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0004H\u0016J=\u00104\u001a\u00020$\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.012\u0006\u00105\u001a\u0002H.2\u0006\u00102\u001a\u00020\u00182\u0006\u00106\u001a\u000207H\u0016\u00a2\u0006\u0002\u00108J5\u00104\u001a\u00020$\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.012\u0006\u00105\u001a\u0002H.2\u0006\u00106\u001a\u000207H\u0016\u00a2\u0006\u0002\u00109J(\u00104\u001a\u00020$\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.012\u0006\u00106\u001a\u000207H\u0016J=\u0010:\u001a\u00020$\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.012\u0006\u00105\u001a\u0002H.2\u0006\u00102\u001a\u00020\u00182\u0006\u00106\u001a\u000207H\u0016\u00a2\u0006\u0002\u00108J\u0016\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010 \u001a\u00020\u0004H\u0016J\u001a\u0010A\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\b\u0010B\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010C\u001a\u0004\u0018\u00010\u00042\u0006\u0010D\u001a\u00020\u001aH\u0016J(\u0010E\u001a\u00020\u0004\"\b\b\u0000\u0010.*\u00020F2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H.0>2\u0006\u0010G\u001a\u00020HH\u0016J\u0016\u0010E\u001a\u00020\u00042\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040>H\u0016J\u0010\u0010E\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0018\u0010E\u001a\u00020\u00042\u0006\u0010I\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010\u00042\u0006\u0010D\u001a\u00020\u001aH\u0016J\u001a\u0010J\u001a\u0004\u0018\u00010\u00042\u0006\u0010I\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010K\u001a\u00020\u00062\u0006\u0010L\u001a\u00020\u0018H\u0002J,\u0010M\u001a\u00020$2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040>2\u0014\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$\u0018\u00010OH\u0016J.\u0010M\u001a\u00020$2\u0006\u0010 \u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00182\u0014\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$\u0018\u00010OH\u0016J.\u0010M\u001a\u00020$2\u0006\u0010I\u001a\u00020F2\u0006\u00102\u001a\u00020\u00182\u0014\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$\u0018\u00010OH\u0016J\u0010\u0010P\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u001aH\u0016J\u0010\u0010Q\u001a\u00020$2\u0006\u0010R\u001a\u00020SH\u0016J*\u0010T\u001a\u00020$2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040>2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0OH\u0016J$\u0010T\u001a\u00020$2\u0006\u0010 \u001a\u00020\u00042\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0OH\u0016J$\u0010T\u001a\u00020$2\u0006\u0010D\u001a\u00020\u001a2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0OH\u0016J,\u0010T\u001a\u00020$2\u0006\u0010I\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0OH\u0016JH\u0010U\u001a\b\u0012\u0004\u0012\u0002H.0V\"\u0004\b\u0000\u0010.2\u0006\u0010 \u001a\u00020\u00042\u001d\u0010N\u001a\u0019\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H.0V0O\u00a2\u0006\u0002\bWH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bX\u0010YR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\b\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006Z"}, d2={"Llog/StandardArtifactManager;", "Llog/IArtifactsManager;", "()V", "RULE_OUTPUT_BASE_NAME", "", "debugDir", "Ljava/io/File;", "getDebugDir", "()Ljava/io/File;", "formulasDir", "getFormulasDir", "inputsDir", "getInputsDir", "logger", "Llog/Logger;", "mainPath", "getMainPath", "()Ljava/lang/String;", "mainReportsDir", "getMainReportsDir", "outputDir", "getOutputDir", "registeredArtifacts", "Ljava/util/concurrent/ConcurrentMap;", "Llog/ArtifactLocation;", "rulesToRegisteredOutputArtifacts", "Llog/RuleOutputArtifactsKey;", "treeViewReportsDir", "getTreeViewReportsDir$annotations", "getTreeViewReportsDir", "artifactPathOf", "loc", "name", "artifactPathOfOrNull", "locOrNull", "backup", "", "fileName", "backupFileName", "copyArtifact", "dstLoc", "copyInputsToRootOfOutputDir", "filenames", "", "dumpBinary", "Ltac/TACFile;", "T", "Ltac/DumpType;", "p", "Ltac/DebuggableProgram;", "location", "label", "dumpCodeArtifacts", "dumpType", "time", "Ltac/DumpTime;", "(Ltac/DebuggableProgram;Ltac/DumpType;Llog/ArtifactLocation;Ltac/DumpTime;)V", "(Ltac/DebuggableProgram;Ltac/DumpType;Ltac/DumpTime;)V", "dumpMandatoryCodeArtifacts", "getArtifactHandle", "Ljava/io/OutputStreamWriter;", "conf", "Lconfig/ConfigType;", "getArtifactHandleStream", "Ljava/io/OutputStream;", "getFilePathForSmtQuery", "subdir", "getRegisteredArtifactNameOrNull", "ruleOutputArtifactsKey", "getRegisteredArtifactPath", "Llog/VersionedArtifact;", "version", "", "versionedArtifact", "getRegisteredArtifactPathOrNull", "getWhere", "l", "registerArtifact", "action", "Lkotlin/Function1;", "registerRuleOutputArtifact", "registerRuleTestArtifact", "ruleTestArtifactsKey", "Llog/RuleOutputArtifactsKey$RuleTestArtifact;", "useArtifact", "withArtifact", "Lkotlin/Result;", "Lkotlin/ExtensionFunctionType;", "withArtifact-gIAlu-s", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Shared"})
@SourceDebugExtension(value={"SMAP\nArtifactManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactManager.kt\nlog/StandardArtifactManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,724:1\n1#2:725\n1855#3,2:726\n*S KotlinDebug\n*F\n+ 1 ArtifactManager.kt\nlog/StandardArtifactManager\n*L\n512#1:726,2\n*E\n"})
final class StandardArtifactManager
implements IArtifactsManager {
    @NotNull
    public static final StandardArtifactManager INSTANCE = new StandardArtifactManager();
    @NotNull
    private static final String mainPath = (String)ConfigType.ExecName.INSTANCE.get();
    @NotNull
    private static final ConcurrentMap<String, ArtifactLocation> registeredArtifacts = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentMap<RuleOutputArtifactsKey, String> rulesToRegisteredOutputArtifacts = new ConcurrentHashMap();
    @NotNull
    private static final String RULE_OUTPUT_BASE_NAME = "rule_output_";
    @NotNull
    private static final Logger logger = Logger.Companion.invoke(LoggerTypes.COMMON);

    private StandardArtifactManager() {
    }

    @Override
    @NotNull
    public String getMainPath() {
        return mainPath;
    }

    private final File getWhere(ArtifactLocation l) {
        return l.getResolvedPath(this.getMainPath());
    }

    @Override
    @NotNull
    public File getMainReportsDir() {
        return this.getWhere(StaticArtifactLocation.Reports.INSTANCE);
    }

    @NotNull
    public final File getTreeViewReportsDir() {
        return this.getWhere(StaticArtifactLocation.TreeViewReports.INSTANCE);
    }

    public static /* synthetic */ void getTreeViewReportsDir$annotations() {
    }

    @Override
    @NotNull
    public File getOutputDir() {
        return this.getWhere(StaticArtifactLocation.Outputs.INSTANCE);
    }

    @Override
    @NotNull
    public File getDebugDir() {
        return this.getWhere(StaticArtifactLocation.Debugs.INSTANCE);
    }

    @Override
    @NotNull
    public File getFormulasDir() {
        return this.getWhere(StaticArtifactLocation.Formulas.INSTANCE);
    }

    @Override
    @NotNull
    public File getInputsDir() {
        return this.getWhere(StaticArtifactLocation.Input.INSTANCE);
    }

    @Override
    public <T extends DumpType> void dumpCodeArtifacts(@NotNull DebuggableProgram<T> p3, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p3, "p");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        this.dumpCodeArtifacts(p3, p3.getDefaultType(), time);
    }

    @Override
    public <T extends DumpType> void dumpCodeArtifacts(@NotNull DebuggableProgram<T> p3, @NotNull T dumpType, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p3, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        this.dumpCodeArtifacts(p3, dumpType, StaticArtifactLocation.Debugs.INSTANCE, time);
    }

    @Override
    public <T extends DumpType> void dumpCodeArtifacts(@NotNull DebuggableProgram<T> p3, @NotNull T dumpType, @NotNull ArtifactLocation location, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p3, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        if (!((Boolean)Config.INSTANCE.getLowFootprint().get()).booleanValue() && dumpType.isEnabled()) {
            String string = this.getWhere(location).getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            p3.dump(dumpType, string, time);
        }
    }

    @Override
    public <T extends DumpType> void dumpMandatoryCodeArtifacts(@NotNull DebuggableProgram<T> p3, @NotNull T dumpType, @NotNull ArtifactLocation location, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p3, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        String string = this.getWhere(location).getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        p3.dump(dumpType, string, time);
    }

    @Override
    @NotNull
    public <T extends DumpType> TACFile dumpBinary(@NotNull DebuggableProgram<T> p3, @NotNull ArtifactLocation location, @NotNull String label) {
        Intrinsics.checkNotNullParameter(p3, "p");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(label, "label");
        String string = this.getWhere(location).getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        return p3.dumpBinary(string, label);
    }

    private final String artifactPathOf(ArtifactLocation loc, String name) {
        return this.getWhere(loc) + File.separator + name;
    }

    private final String artifactPathOfOrNull(ArtifactLocation locOrNull, String name) {
        String string;
        ArtifactLocation artifactLocation = locOrNull;
        if (artifactLocation != null) {
            ArtifactLocation loc = artifactLocation;
            boolean bl = false;
            string = INSTANCE.artifactPathOf(loc, name);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getRegisteredArtifactPathOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.artifactPathOfOrNull((ArtifactLocation)registeredArtifacts.get(name), name);
    }

    @Override
    @Nullable
    public String getRegisteredArtifactPathOrNull(@NotNull VersionedArtifact versionedArtifact, int version) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        return this.artifactPathOfOrNull((ArtifactLocation)registeredArtifacts.get(versionedArtifact.getUnversionedName()), versionedArtifact.getVersionedNameBuilder().invoke(version));
    }

    @Override
    @NotNull
    public String getRegisteredArtifactPath(@NotNull ConfigType<String> conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getRegisteredArtifactPath(conf.get());
    }

    @Override
    @NotNull
    public <T extends VersionedArtifact> String getRegisteredArtifactPath(@NotNull ConfigType<T> conf, int version) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getRegisteredArtifactPath((VersionedArtifact)conf.get(), version);
    }

    @Override
    @NotNull
    public String getRegisteredArtifactPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = this.getRegisteredArtifactPathOrNull(name);
        if (string == null) {
            string = "N/A";
        }
        return string;
    }

    @Override
    @NotNull
    public String getRegisteredArtifactPath(@NotNull VersionedArtifact versionedArtifact, int version) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        String string = this.getRegisteredArtifactPathOrNull(versionedArtifact, version);
        if (string == null) {
            string = "N/A";
        }
        return string;
    }

    @Override
    public void registerArtifact(@NotNull ConfigType<String> conf, @Nullable Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        this.registerArtifact(conf.get(), (ArtifactLocation)(conf.isDefault() ? (StaticArtifactLocation)StaticArtifactLocation.Reports.INSTANCE : (StaticArtifactLocation)StaticArtifactLocation.CWD.INSTANCE), action);
    }

    @Override
    public void registerArtifact(@NotNull String name, @NotNull ArtifactLocation location, @Nullable Function1<? super String, Unit> action) {
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            if (registeredArtifacts.containsKey(name)) {
                logger.info((Function0<? extends Object>)new Function0<Object>(name){
                    final /* synthetic */ String $name;
                    {
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Artifact " + this.$name + " already registered in " + StandardArtifactManager.access$getRegisteredArtifacts$p().get(this.$name);
                    }
                });
            }
            registeredArtifacts.putIfAbsent(name, location);
            Function1<? super String, Unit> function1 = action;
            if (function1 == null) break block1;
            Function1<? super String, Unit> it2 = function1;
            boolean bl = false;
            INSTANCE.useArtifact(name, it2);
        }
    }

    @Override
    public void registerArtifact(@NotNull VersionedArtifact versionedArtifact, @NotNull ArtifactLocation location, @Nullable Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        Intrinsics.checkNotNullParameter(location, "location");
        this.registerArtifact(versionedArtifact.getUnversionedName(), location, action);
    }

    @Override
    @NotNull
    public String registerRuleOutputArtifact(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey) {
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        String outputFilename = RULE_OUTPUT_BASE_NAME + Allocator.INSTANCE.getFreshId(Allocator.Id.RULE_OUTPUT) + ".json";
        ((Map)rulesToRegisteredOutputArtifacts).put(ruleOutputArtifactsKey, outputFilename);
        ((Map)registeredArtifacts).put(outputFilename, StaticArtifactLocation.TreeViewReports.INSTANCE);
        return outputFilename;
    }

    @Override
    public void registerRuleTestArtifact(@NotNull RuleOutputArtifactsKey.RuleTestArtifact ruleTestArtifactsKey) {
        Intrinsics.checkNotNullParameter(ruleTestArtifactsKey, "ruleTestArtifactsKey");
        String ruleNameSanitize = new ArtifactFileUtils.SanitizedPath(ruleTestArtifactsKey.getRule().getDeclarationId()).getSanitizedFileBaseName();
        String filename = ruleNameSanitize + "_" + ruleTestArtifactsKey.getSuffixFileName();
        rulesToRegisteredOutputArtifacts.putIfAbsent(ruleTestArtifactsKey, filename);
        registeredArtifacts.putIfAbsent(filename, new DynamicArtifactLocation(StaticArtifactLocation.VerifierResults.INSTANCE, new File(ruleNameSanitize)));
    }

    @Override
    @Nullable
    public String getRegisteredArtifactPathOrNull(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey) {
        String string;
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        String string2 = this.getRegisteredArtifactNameOrNull(ruleOutputArtifactsKey);
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            string = this.getRegisteredArtifactPathOrNull(p0);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getRegisteredArtifactNameOrNull(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey) {
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        return (String)rulesToRegisteredOutputArtifacts.get(ruleOutputArtifactsKey);
    }

    @Override
    public void useArtifact(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        Intrinsics.checkNotNullParameter(action, "action");
        String ruleOutputPath = this.getRegisteredArtifactPathOrNull(ruleOutputArtifactsKey);
        if (ruleOutputPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(ruleOutputArtifactsKey){
                final /* synthetic */ RuleOutputArtifactsKey $ruleOutputArtifactsKey;
                {
                    this.$ruleOutputArtifactsKey = $ruleOutputArtifactsKey;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use output artifact for rule " + this.$ruleOutputArtifactsKey.getRule().getDeclarationId() + ", since this rule has not been registered.";
                }
            });
            return;
        }
        action.invoke(ruleOutputPath);
    }

    @Override
    public void useArtifact(@NotNull ConfigType<String> conf, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        Intrinsics.checkNotNullParameter(action, "action");
        this.useArtifact(conf.get(), action);
    }

    @Override
    public void useArtifact(@NotNull VersionedArtifact versionedArtifact, int version, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        Intrinsics.checkNotNullParameter(action, "action");
        String fullPath = this.getRegisteredArtifactPathOrNull(versionedArtifact, version);
        if (fullPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(version, versionedArtifact){
                final /* synthetic */ int $version;
                final /* synthetic */ VersionedArtifact $versionedArtifact;
                {
                    this.$version = $version;
                    this.$versionedArtifact = $versionedArtifact;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use versioned artifact (version=" + this.$version + "), since " + this.$versionedArtifact.getUnversionedName() + " is not a valid file name.";
                }
            });
            return;
        }
        action.invoke(fullPath);
    }

    @Override
    public void useArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(action, "action");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use artifact, since " + this.$name + " is not a valid file name.";
                }
            });
            return;
        }
        action.invoke(fullPath);
    }

    @NotNull
    public <T> Object withArtifact-gIAlu-s(@NotNull String name, @NotNull Function1<? super String, ? extends Result<? extends T>> action) {
        Object object;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(action, "action");
        String string = this.getRegisteredArtifactPathOrNull(name);
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            object = action.invoke(it2).unbox-impl();
        } else {
            object = Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Non existing artifact " + name)));
        }
        return object;
    }

    @Override
    @NotNull
    public OutputStreamWriter getArtifactHandle(@NotNull ConfigType<String> conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getArtifactHandle(conf.get());
    }

    @Override
    @NotNull
    public OutputStreamWriter getArtifactHandle(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new OutputStreamWriter(this.getArtifactHandleStream(name));
    }

    @Override
    @NotNull
    public OutputStream getArtifactHandleStream(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            throw new IllegalStateException(("Non existing artifact " + name).toString());
        }
        return new FileOutputStream(fullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(@NotNull String fileName, @NotNull String backupFileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(backupFileName, "backupFileName");
        try {
            Reader reader = CertoraFileCache.INSTANCE.getContentReader(fileName);
            Closeable closeable = reader;
            Throwable throwable = null;
            try {
                long l;
                Reader it2 = (Reader)closeable;
                boolean bl = false;
                File backupFileDir = new File(FileUtils.dirname(backupFileName));
                backupFileDir.mkdirs();
                Object object = new File(backupFileName);
                Object object2 = Charsets.UTF_8;
                int n = 8192;
                Object object3 = object;
                object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
                BufferedWriter writer = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
                object = writer;
                object2 = null;
                try {
                    BufferedWriter it3 = (BufferedWriter)object;
                    boolean bl2 = false;
                    l = TextStreamsKt.copyTo$default(reader, writer, 0, 2, null);
                }
                catch (Throwable throwable2) {
                    object2 = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                long l2 = l;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            LoggerKt.alwaysError(Logger.Companion, "Received exception " + e + "; Failed to backup " + fileName, e);
        }
    }

    @Override
    public void copyArtifact(@NotNull ArtifactLocation dstLoc, @NotNull String name) {
        Intrinsics.checkNotNullParameter(dstLoc, "dstLoc");
        Intrinsics.checkNotNullParameter(name, "name");
        String src = this.getRegisteredArtifactPath(name);
        String dst = this.artifactPathOf(dstLoc, name);
        if (Intrinsics.areEqual(src, dst)) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(name, src, dst){
                final /* synthetic */ String $name;
                final /* synthetic */ String $src;
                final /* synthetic */ String $dst;
                {
                    this.$name = $name;
                    this.$src = $src;
                    this.$dst = $dst;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Trivial copy of an artifact " + this.$name + " from " + this.$src + " to " + this.$dst + ", skipping";
                }
            });
        }
        Files.copy(new File(src).toPath(), new File(dst).toPath(), new CopyOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInputsToRootOfOutputDir(@NotNull List<String> filenames) {
        Intrinsics.checkNotNullParameter(filenames, "filenames");
        String target = ArtifactManagerFactory.INSTANCE.invoke().getMainPath();
        try {
            Iterable $this$forEach$iv = filenames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String filename = (String)element$iv;
                boolean bl = false;
                String targetFile = target + File.separator + ArtifactFileUtils.INSTANCE.getBasenameOnly(filename) + "." + FileUtils.extension(filename);
                Reader reader = CertoraFileCache.INSTANCE.getContentReader(filename);
                Closeable closeable = reader;
                Throwable throwable = null;
                try {
                    Reader it2 = (Reader)closeable;
                    boolean bl2 = false;
                    Object object = new File(targetFile);
                    Object object2 = Charsets.UTF_8;
                    int n = 8192;
                    Object object3 = object;
                    object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
                    BufferedWriter writer = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
                    object = writer;
                    object2 = null;
                    try {
                        BufferedWriter it3 = (BufferedWriter)object;
                        boolean bl3 = false;
                        TextStreamsKt.copyTo$default(reader, it3, 0, 2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        object2 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to copy some inputs files " + filenames + ", got error: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    public String getFilePathForSmtQuery(@NotNull String name, @Nullable String subdir) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = subdir;
        if (string == null) {
            string = "";
        }
        String subdirString = string;
        File baseDir = FilesKt.resolve(ArtifactManagerFactory.INSTANCE.invoke().getFormulasDir(), subdirString);
        String basePathPrefix = baseDir.getPath() + File.separator + Config.INSTANCE.getFormulaFileBasename().get() + "_" + Allocator.INSTANCE.getFreshNumber() + "_";
        String smt2file = basePathPrefix + name + ".smt2";
        int fileLengthLimitWindows = 250;
        if (SystemUtils.IS_OS_WINDOWS && smt2file.length() > fileLengthLimitWindows) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(name, fileLengthLimitWindows){
                final /* synthetic */ String $name;
                final /* synthetic */ int $fileLengthLimitWindows;
                {
                    this.$name = $name;
                    this.$fileLengthLimitWindows = $fileLengthLimitWindows;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Cannot dump .smt2 file for " + this.$name + ", since we're on Windows and file namewould be too long. (assumed length limit: " + this.$fileLengthLimitWindows + ")";
                }
            });
            return "";
        }
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            logger.error("Failed to create formulas directory " + baseDir.getPath());
        }
        return smt2file;
    }

    @Override
    @NotNull
    public String getCmdErrorFilepath(@NotNull String name) {
        return IArtifactsManager.DefaultImpls.getCmdErrorFilepath(this, name);
    }

    @Override
    @NotNull
    public String getCmdOutputFilepath(@NotNull String name) {
        return IArtifactsManager.DefaultImpls.getCmdOutputFilepath(this, name);
    }

    @Override
    @NotNull
    public String useTempArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        return IArtifactsManager.DefaultImpls.useTempArtifact(this, name, action);
    }

    @Override
    @NotNull
    public String fitFileLength(@NotNull String name, @NotNull String suffix) {
        return IArtifactsManager.DefaultImpls.fitFileLength(this, name, suffix);
    }

    public static final /* synthetic */ ConcurrentMap access$getRegisteredArtifacts$p() {
        return registeredArtifacts;
    }
}

