/*
 * Decompiled with CFR 0.152.
 */
package scene;

import evm.EVMConstsKt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lscene/ContractUniverse;", "", "(Ljava/lang/String;I)V", "addresses", "", "Ljava/math/BigInteger;", "getAddresses", "()Ljava/util/List;", "getNameOfPrecompiledByAddress", "", "i", "isPrecompiled", "", "ETHEREUM", "CELO", "Shared"})
@SourceDebugExtension(value={"SMAP\nContractUniverse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractUniverse.kt\nscene/ContractUniverse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1549#2:44\n1620#2,3:45\n*S KotlinDebug\n*F\n+ 1 ContractUniverse.kt\nscene/ContractUniverse\n*L\n19#1:44\n19#1:45,3\n*E\n"})
public final class ContractUniverse
extends Enum<ContractUniverse> {
    public static final /* enum */ ContractUniverse ETHEREUM = new ContractUniverse();
    public static final /* enum */ ContractUniverse CELO = new ContractUniverse();
    private static final /* synthetic */ ContractUniverse[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BigInteger> getAddresses() {
        void $this$mapTo$iv$iv;
        Iterable iterable;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                iterable = CollectionsKt.plus((Iterable)RangesKt.until(1, 9), (Iterable)RangesKt.until(244, 255));
                break;
            }
            case 2: {
                iterable = RangesKt.until(1, 255);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BigInteger bigInteger = BigInteger.valueOf((long)it2);
            Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(...)");
            collection.add(bigInteger);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String getNameOfPrecompiledByAddress(@NotNull BigInteger i) {
        String string;
        Intrinsics.checkNotNullParameter(i, "i");
        BigInteger bigInteger = i;
        if (Intrinsics.areEqual(bigInteger, EVMConstsKt.getECRECOVER_PRECOMPILED_ADDRESS())) {
            string = "ecrecover";
        } else if (Intrinsics.areEqual(bigInteger, EVMConstsKt.getSHA256_PRECOMPILED_ADDRESS())) {
            string = "sha256";
        } else {
            BigInteger bigInteger2 = BigInteger.valueOf(3);
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "valueOf(...)");
            if (Intrinsics.areEqual(bigInteger, bigInteger2)) {
                string = "ripemd160";
            } else if (Intrinsics.areEqual(bigInteger, EVMConstsKt.getIDENTITY_PRECOMPILED_ADDRESS())) {
                string = "identity";
            } else {
                BigInteger bigInteger3 = BigInteger.valueOf(5);
                Intrinsics.checkNotNullExpressionValue(bigInteger3, "valueOf(...)");
                if (Intrinsics.areEqual(bigInteger, bigInteger3)) {
                    string = "bigmod";
                } else {
                    BigInteger bigInteger4 = BigInteger.valueOf(6);
                    Intrinsics.checkNotNullExpressionValue(bigInteger4, "valueOf(...)");
                    if (Intrinsics.areEqual(bigInteger, bigInteger4)) {
                        string = "bn256Add";
                    } else {
                        BigInteger bigInteger5 = BigInteger.valueOf(7);
                        Intrinsics.checkNotNullExpressionValue(bigInteger5, "valueOf(...)");
                        if (Intrinsics.areEqual(bigInteger, bigInteger5)) {
                            string = "bn256ScalarMul";
                        } else {
                            BigInteger bigInteger6 = BigInteger.valueOf(8);
                            Intrinsics.checkNotNullExpressionValue(bigInteger6, "valueOf(...)");
                            if (Intrinsics.areEqual(bigInteger, bigInteger6)) {
                                string = "bn256Pairing";
                            } else {
                                BigInteger bigInteger7 = BigInteger.valueOf(9);
                                Intrinsics.checkNotNullExpressionValue(bigInteger7, "valueOf(...)");
                                string = Intrinsics.areEqual(bigInteger, bigInteger7) ? "blake2b" : null;
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public final boolean isPrecompiled(@NotNull BigInteger i) {
        boolean bl;
        Intrinsics.checkNotNullParameter(i, "i");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                if (BigInteger.ONE.compareTo(i) <= 0 && i.compareTo(BigInteger.valueOf(9L)) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (BigInteger.ONE.compareTo(i) <= 0 && i.compareTo(BigInteger.valueOf(256L)) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static ContractUniverse[] values() {
        return (ContractUniverse[])$VALUES.clone();
    }

    public static ContractUniverse valueOf(String value2) {
        return Enum.valueOf(ContractUniverse.class, value2);
    }

    @NotNull
    public static EnumEntries<ContractUniverse> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = contractUniverseArray = new ContractUniverse[]{ContractUniverse.ETHEREUM, ContractUniverse.CELO};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContractUniverse.values().length];
            try {
                nArray[ContractUniverse.ETHEREUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContractUniverse.CELO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

