/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import datastructures.stdcollections.ListsKt;
import datastructures.stdcollections.SetsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import spec.CastType;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLAstAdditionalChecks;
import spec.cvlast.CVLCmdAddtionalChecks;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpFolder;
import spec.cvlast.CVLGhostAxiom;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.CVLType;
import spec.cvlast.MethodParamFilter;
import spec.cvlast.SingleRuleWithCode;
import spec.cvlast.transformer.CVLAstTransformer;
import spec.cvlast.transformer.CVLExpTransformer;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;
import utils.ErrorCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\b\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\r2\u0006\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J.\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lspec/cvlast/CVLAstAdditionalChecks;", "Lspec/cvlast/transformer/CVLAstTransformer;", "Lspec/cvlast/typechecker/CVLError;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "(Lspec/cvlast/CVLSymbolTable;)V", "getSymbolTable", "()Lspec/cvlast/CVLSymbolTable;", "ast", "Lutils/CollectingResult;", "Lspec/cvlast/CVLAst;", "checkNoContractOrCVLCalls", "", "Lutils/VoidResult;", "exp", "Lspec/cvlast/CVLExp;", "context", "", "filterExpMustBeBooleanAndClosed", "filterExp", "allowedVarsInUse", "", "ghost", "Lspec/cvlast/CVLGhostDeclaration;", "inv", "Lspec/cvlast/CVLInvariant;", "rule", "Lspec/cvlast/SingleRuleWithCode;", "validateGhostAxiomContents", "axiom", "Lspec/cvlast/CVLGhostAxiom;", "Shared"})
@SourceDebugExtension(value={"SMAP\nCVLAstAdditionalChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLAstAdditionalChecks.kt\nspec/cvlast/CVLAstAdditionalChecks\n+ 2 CVLAst.kt\nspec/cvlast/CVLExp\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n3634#2:253\n3647#2:254\n766#3:255\n857#3,2:256\n1549#3:258\n1620#3,3:259\n*S KotlinDebug\n*F\n+ 1 CVLAstAdditionalChecks.kt\nspec/cvlast/CVLAstAdditionalChecks\n*L\n230#1:253\n230#1:254\n230#1:255\n230#1:256,2\n234#1:258\n234#1:259,3\n*E\n"})
public final class CVLAstAdditionalChecks
extends CVLAstTransformer<CVLError> {
    @NotNull
    private final CVLSymbolTable symbolTable;

    public CVLAstAdditionalChecks(@NotNull CVLSymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        super(new CVLCmdAddtionalChecks(), null, 2, null);
        this.symbolTable = symbolTable;
    }

    @NotNull
    public final CVLSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @Override
    @NotNull
    public CollectingResult<CVLAst, CVLError> ast(@NotNull CVLAst ast2) {
        Intrinsics.checkNotNullParameter(ast2, "ast");
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, CVLAst>(ast2, this){
            final /* synthetic */ CVLAst $ast;
            final /* synthetic */ CVLAstAdditionalChecks this$0;
            {
                this.$ast = $ast;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CVLAst invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                if (!this.$ast.getDefinitions().isEmpty()) {
                    boolean bl = false;
                    String string = "The additional checks here assume all definitions were inlined and removed from the ast";
                    throw new IllegalStateException(string.toString());
                }
                return (CVLAst)$this$collectingErrors.bind(CVLAstAdditionalChecks.access$ast$s2004824016(this.this$0, this.$ast));
            }
        });
    }

    private final CollectingResult<Unit, CVLError> filterExpMustBeBooleanAndClosed(CVLExp filterExp, Set<String> allowedVarsInUse) {
        List nonDefinitionApplications2 = new CVLExpFolder<List<? extends CVLError>>(filterExp, allowedVarsInUse){
            final /* synthetic */ CVLExp $filterExp;
            final /* synthetic */ Set<String> $allowedVarsInUse;
            {
                this.$filterExp = $filterExp;
                this.$allowedVarsInUse = $allowedVarsInUse;
            }

            private final CVLError.Exp badInvokeError(CVLExp exp) {
                CVLRange range = exp.getRangeOrEmpty();
                boolean bl = false;
                Object invokeExpLocation = range instanceof CVLRange.Empty ? "" : " (at " + range + ")";
                return new CVLError.Exp(this.$filterExp, "The filter of the parameter " + CollectionsKt.first((Iterable)this.$allowedVarsInUse) + " uses the invoke expression " + exp + (String)invokeExpLocation + ". Filter expressions may only invoke definitions");
            }

            @NotNull
            public List<CVLError> applyExp(@NotNull List<? extends CVLError> acc, @NotNull CVLExp.ApplyExp exp) {
                Intrinsics.checkNotNullParameter(acc, "acc");
                Intrinsics.checkNotNullParameter(exp, "exp");
                if (!(!(this.$filterExp instanceof CVLExp.ApplyExp.Definition))) {
                    boolean bl = false;
                    String string = "unexpected definition expression " + exp + " after definition inlining";
                    throw new IllegalStateException(string.toString());
                }
                return ListsKt.plus((Collection)super.applyExp(acc, exp), this.badInvokeError(exp));
            }

            @NotNull
            public List<CVLError> unresolvedApply(@NotNull List<? extends CVLError> acc, @NotNull CVLExp.UnresolvedApplyExp exp) {
                Intrinsics.checkNotNullParameter(acc, "acc");
                Intrinsics.checkNotNullParameter(exp, "exp");
                return ListsKt.plus((Collection)super.unresolvedApply(acc, exp), this.badInvokeError(exp));
            }

            @NotNull
            public List<CVLError> variable(@NotNull List<? extends CVLError> acc, @NotNull CVLExp.VariableExp exp) {
                Intrinsics.checkNotNullParameter(acc, "acc");
                Intrinsics.checkNotNullParameter(exp, "exp");
                return acc;
            }
        }.expr(new ArrayList(), filterExp);
        return CollectingResult.Companion.bind(!((Collection)nonDefinitionApplications2).isEmpty() ? (CollectingResult)CollectingResult.Companion.asError(nonDefinitionApplications2) : (CollectingResult)CollectingResult.Companion.lift(filterExp), (Function1)new Function1<CVLExp, CollectingResult<? extends Unit, ? extends CVLError>>(allowedVarsInUse, this){
            final /* synthetic */ Set<String> $allowedVarsInUse;
            final /* synthetic */ CVLAstAdditionalChecks this$0;
            {
                this.$allowedVarsInUse = $allowedVarsInUse;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CollectingResult<Unit, CVLError> invoke(@NotNull CVLExp exp) {
                CollectingResult collectingResult;
                Intrinsics.checkNotNullParameter(exp, "exp");
                if (exp.getCVLType().isNotConvertibleTo(CVLType.PureCVLType.Primitive.Bool.INSTANCE)) {
                    collectingResult = CollectingResult.Companion.asError(new CVLError.Exp(exp, "Method parameter's filter expressions must be boolean (found " + exp.getCVLType() + " type)"));
                } else {
                    Set<T> symsInFilterExp2 = new CVLExpFolder<Set<? extends String>>(){

                        @NotNull
                        public Set<String> variable(@NotNull Set<String> acc, @NotNull CVLExp.VariableExp exp) {
                            Intrinsics.checkNotNullParameter(acc, "acc");
                            Intrinsics.checkNotNullParameter(exp, "exp");
                            return SetsKt.plus(acc, exp.getId());
                        }

                        @NotNull
                        public Set<String> invokeSymbolicExp(@NotNull Set<String> acc, @NotNull CVLExp.ApplyExp.ContractFunction.Symbolic exp) {
                            Intrinsics.checkNotNullParameter(acc, "acc");
                            Intrinsics.checkNotNullParameter(exp, "exp");
                            return SetsKt.plus(super.invokeSymbolicExp(acc, exp), exp.getMethodIdWithCallContext().getMethodId());
                        }
                    }.expr(kotlin.collections.SetsKt.emptySet(), exp);
                    Set<String> allAllowed = SetsKt.plus(this.$allowedVarsInUse, (Iterable)this.this$0.getSymbolTable().getAllContractAliases());
                    collectingResult = allAllowed.containsAll((Collection)symsInFilterExp2) ? (CollectingResult)CollectingResult.Companion.getOk() : (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp, "The method parameter's filter expression uses the symbols " + SetsKt.minus(symsInFilterExp2, (Iterable)allAllowed) + " while it may only use " + allAllowed));
                }
                return collectingResult;
            }
        });
    }

    @Override
    @NotNull
    public CollectingResult<CVLInvariant, CVLError> inv(@NotNull CVLInvariant inv2) {
        Intrinsics.checkNotNullParameter(inv2, "inv");
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, CVLInvariant>(inv2, this){
            final /* synthetic */ CVLInvariant $inv;
            final /* synthetic */ CVLAstAdditionalChecks this$0;
            {
                this.$inv = $inv;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CVLInvariant invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                Map<String, MethodParamFilter> map2 = this.$inv.getMethodParamFilters().getMethodParamToFilter();
                CVLAstAdditionalChecks cVLAstAdditionalChecks = this.this$0;
                ErrorCollector<CVLError> errorCollector = $this$collectingErrors;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String methodParamName = (String)entry.getKey();
                    MethodParamFilter filter2 = (MethodParamFilter)entry.getValue();
                    collection.add(CVLAstAdditionalChecks.access$filterExpMustBeBooleanAndClosed(cVLAstAdditionalChecks, filter2.getFilterExp(), SetsKt.setOf(methodParamName)));
                }
                errorCollector.collect((List)destination$iv$iv);
                return (CVLInvariant)$this$collectingErrors.bind(CVLAstAdditionalChecks.access$inv$s2004824016(this.this$0, this.$inv));
            }
        });
    }

    @Override
    @NotNull
    public CollectingResult<SingleRuleWithCode, CVLError> rule(@NotNull SingleRuleWithCode rule2) {
        Intrinsics.checkNotNullParameter(rule2, "rule");
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, SingleRuleWithCode>(rule2, this){
            final /* synthetic */ SingleRuleWithCode $rule;
            final /* synthetic */ CVLAstAdditionalChecks this$0;
            {
                this.$rule = $rule;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SingleRuleWithCode invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                Map<String, MethodParamFilter> map2 = this.$rule.getMethodParamFilters().getMethodParamToFilter();
                CVLAstAdditionalChecks cVLAstAdditionalChecks = this.this$0;
                ErrorCollector<CVLError> errorCollector = $this$collectingErrors;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String methodParamName = (String)entry.getKey();
                    MethodParamFilter filter2 = (MethodParamFilter)entry.getValue();
                    collection.add(CVLAstAdditionalChecks.access$filterExpMustBeBooleanAndClosed(cVLAstAdditionalChecks, filter2.getFilterExp(), SetsKt.setOf(methodParamName)));
                }
                errorCollector.collect((List)destination$iv$iv);
                return (SingleRuleWithCode)$this$collectingErrors.bind(CVLAstAdditionalChecks.access$rule$s2004824016(this.this$0, this.$rule));
            }
        });
    }

    private final CollectingResult<Unit, CVLError> checkNoContractOrCVLCalls(CVLExp exp, String context) {
        return CollectingResult.Companion.bind(new CVLExpTransformer<CVLError>(context){
            final /* synthetic */ String $context;
            {
                this.$context = $context;
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> applyExp(@NotNull CVLExp.ApplyExp exp) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                return CollectingResult.Companion.map(exp instanceof CVLExp.ApplyExp.ContractFunction || exp instanceof CVLExp.ApplyExp.CVLFunction || exp instanceof CVLExp.ApplyExp.Definition ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.General(exp.getTag().getCvlRange(), this.$context + " may not contain calls to contract or CVL functions, but found a call to " + exp.getMethodIdWithCallContext())) : (CollectingResult)CollectingResult.Companion.getOk(), CVLExpTransformer.DefaultImpls.applyExp(this, exp), (Function2)new Function2<Unit, CVLExp, CVLExp.ApplyExp>(exp){
                    final /* synthetic */ CVLExp.ApplyExp $exp;
                    {
                        this.$exp = $exp;
                        super(2);
                    }

                    @NotNull
                    public final CVLExp.ApplyExp invoke(@NotNull Unit unit, @NotNull CVLExp cVLExp) {
                        Intrinsics.checkNotNullParameter(unit, "<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter(cVLExp, "<anonymous parameter 1>");
                        return this.$exp;
                    }
                });
            }

            @NotNull
            public CollectingResult<CVLLhs, CVLError> lhs(@NotNull CVLLhs lhs) {
                return CVLExpTransformer.DefaultImpls.lhs(this, lhs);
            }

            @NotNull
            public CollectingResult<CVLLhs.Id, CVLError> idLhs(@NotNull CVLLhs.Id idLhs2) {
                return CVLExpTransformer.DefaultImpls.idLhs(this, idLhs2);
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> expr(@NotNull CVLExp exp) {
                return CVLExpTransformer.DefaultImpls.expr(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> application(@NotNull CVLExp.ApplicationExp exp) {
                return CVLExpTransformer.DefaultImpls.application(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.ApplyExp.CVLBuiltIn, CVLError> builtin(@NotNull CVLExp.ApplyExp.CVLBuiltIn exp) {
                return CVLExpTransformer.DefaultImpls.builtin(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp, CVLError> relop(@NotNull CVLExp.RelopExp exp) {
                return CVLExpTransformer.DefaultImpls.relop(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp, CVLError> arithRelop(@NotNull CVLExp.RelopExp.ArithRelopExp exp) {
                return CVLExpTransformer.DefaultImpls.arithRelop(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> const(@NotNull CVLExp.Constant exp) {
                return CVLExpTransformer.DefaultImpls.const(this, exp);
            }

            @NotNull
            public CollectingResult<CVLLhs.Array, CVLError> arrayLhs(@NotNull CVLLhs.Array arrayLhs2) {
                return CVLExpTransformer.DefaultImpls.arrayLhs(this, arrayLhs2);
            }

            @NotNull
            public CollectingResult<CVLExp.UnresolvedApplyExp, CVLError> unresolvedApplyExp(@NotNull CVLExp.UnresolvedApplyExp exp) {
                return CVLExpTransformer.DefaultImpls.unresolvedApplyExp(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.GeExp, CVLError> ge(@NotNull CVLExp.RelopExp.ArithRelopExp.GeExp exp) {
                return CVLExpTransformer.DefaultImpls.ge(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.GtExp, CVLError> gt(@NotNull CVLExp.RelopExp.ArithRelopExp.GtExp exp) {
                return CVLExpTransformer.DefaultImpls.gt(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.LeExp, CVLError> le(@NotNull CVLExp.RelopExp.ArithRelopExp.LeExp exp) {
                return CVLExpTransformer.DefaultImpls.le(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.LtExp, CVLError> lt(@NotNull CVLExp.RelopExp.ArithRelopExp.LtExp exp) {
                return CVLExpTransformer.DefaultImpls.lt(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp.EqExp, CVLError> eq(@NotNull CVLExp.RelopExp.EqExp exp) {
                return CVLExpTransformer.DefaultImpls.eq(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.RelopExp.NeExp, CVLError> ne(@NotNull CVLExp.RelopExp.NeExp exp) {
                return CVLExpTransformer.DefaultImpls.ne(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.AddExp, CVLError> add(@NotNull CVLExp.BinaryExp.AddExp exp) {
                return CVLExpTransformer.DefaultImpls.add(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> enumConstant(@NotNull CVLExp.Constant.EnumConstant exp) {
                return CVLExpTransformer.DefaultImpls.enumConstant(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.Constant.BoolLit, CVLError> boolLit(@NotNull CVLExp.Constant.BoolLit exp) {
                return CVLExpTransformer.DefaultImpls.boolLit(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.Constant.NumberLit, CVLError> numberLit(@NotNull CVLExp.Constant.NumberLit exp) {
                return CVLExpTransformer.DefaultImpls.numberLit(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.Constant.StringLit, CVLError> stringLit(@NotNull CVLExp.Constant.StringLit exp) {
                return CVLExpTransformer.DefaultImpls.stringLit(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.Constant.StructLit, CVLError> structLit(@NotNull CVLExp.Constant.StructLit exp) {
                return CVLExpTransformer.DefaultImpls.structLit(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.Constant.SignatureLiteralExp, CVLError> signatureLit(@NotNull CVLExp.Constant.SignatureLiteralExp exp) {
                return CVLExpTransformer.DefaultImpls.signatureLit(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.ApplyExp.Ghost, CVLError> ghost(@NotNull CVLExp.ApplyExp.Ghost exp) {
                return CVLExpTransformer.DefaultImpls.ghost(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.CastExpr, CVLError> castExpression(@NotNull CVLExp.CastExpr exp) {
                return CVLExpTransformer.DefaultImpls.castExpression(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> definition(@NotNull CVLExp.ApplyExp.Definition exp) {
                return CVLExpTransformer.DefaultImpls.definition(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.ApplyExp.CVLFunction, CVLError> call(@NotNull CVLExp.ApplyExp.CVLFunction exp) {
                return CVLExpTransformer.DefaultImpls.call(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.DivExp, CVLError> div(@NotNull CVLExp.BinaryExp.DivExp exp) {
                return CVLExpTransformer.DefaultImpls.div(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ModExp, CVLError> mod(@NotNull CVLExp.BinaryExp.ModExp exp) {
                return CVLExpTransformer.DefaultImpls.mod(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ExponentExp, CVLError> exponent(@NotNull CVLExp.BinaryExp.ExponentExp exp) {
                return CVLExpTransformer.DefaultImpls.exponent(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.IffExp, CVLError> iff(@NotNull CVLExp.BinaryExp.IffExp exp) {
                return CVLExpTransformer.DefaultImpls.iff(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ImpliesExp, CVLError> implies(@NotNull CVLExp.BinaryExp.ImpliesExp exp) {
                return CVLExpTransformer.DefaultImpls.implies(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwOrExp, CVLError> bwor(@NotNull CVLExp.BinaryExp.BwOrExp exp) {
                return CVLExpTransformer.DefaultImpls.bwor(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwXOrExp, CVLError> bwxor(@NotNull CVLExp.BinaryExp.BwXOrExp exp) {
                return CVLExpTransformer.DefaultImpls.bwxor(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwAndExp, CVLError> bwand(@NotNull CVLExp.BinaryExp.BwAndExp exp) {
                return CVLExpTransformer.DefaultImpls.bwand(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwLeftShiftExp, CVLError> bwlsh(@NotNull CVLExp.BinaryExp.BwLeftShiftExp exp) {
                return CVLExpTransformer.DefaultImpls.bwlsh(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwRightShiftExp, CVLError> bwrsh(@NotNull CVLExp.BinaryExp.BwRightShiftExp exp) {
                return CVLExpTransformer.DefaultImpls.bwrsh(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwRightShiftWithZerosExp, CVLError> bwrshwzeros(@NotNull CVLExp.BinaryExp.BwRightShiftWithZerosExp exp) {
                return CVLExpTransformer.DefaultImpls.bwrshwzeros(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.UnaryExp.BwNotExp, CVLError> bwnot(@NotNull CVLExp.UnaryExp.BwNotExp exp) {
                return CVLExpTransformer.DefaultImpls.bwnot(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.ApplyExp.ContractFunction, CVLError> invokeExp(@NotNull CVLExp.ApplyExp.ContractFunction exp) {
                return CVLExpTransformer.DefaultImpls.invokeExp(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.ArrayLitExp, CVLError> arrayexp(@NotNull CVLExp.ArrayLitExp exp) {
                return CVLExpTransformer.DefaultImpls.arrayexp(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.CondExp, CVLError> condexp(@NotNull CVLExp.CondExp exp) {
                return CVLExpTransformer.DefaultImpls.condexp(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.LandExp, CVLError> land(@NotNull CVLExp.BinaryExp.LandExp exp) {
                return CVLExpTransformer.DefaultImpls.land(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.LorExp, CVLError> lor(@NotNull CVLExp.BinaryExp.LorExp exp) {
                return CVLExpTransformer.DefaultImpls.lor(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.MulExp, CVLError> mul(@NotNull CVLExp.BinaryExp.MulExp exp) {
                return CVLExpTransformer.DefaultImpls.mul(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.UnaryExp.LNotExp, CVLError> neg(@NotNull CVLExp.UnaryExp.LNotExp exp) {
                return CVLExpTransformer.DefaultImpls.neg(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> quant(@NotNull CVLExp.QuantifierExp exp) {
                return CVLExpTransformer.DefaultImpls.quant(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.FieldSelectExp, CVLError> fieldSel(@NotNull CVLExp.FieldSelectExp exp) {
                return CVLExpTransformer.DefaultImpls.fieldSel(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.SetMemExp, CVLError> setmem(@NotNull CVLExp.SetMemExp exp) {
                return CVLExpTransformer.DefaultImpls.setmem(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.ArrayLengthExp, CVLError> arraylength(@NotNull CVLExp.ArrayLengthExp exp) {
                return CVLExpTransformer.DefaultImpls.arraylength(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.ArrayDerefExp, CVLError> arrayderef(@NotNull CVLExp.ArrayDerefExp exp) {
                return CVLExpTransformer.DefaultImpls.arrayderef(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.BinaryExp.SubExp, CVLError> sub(@NotNull CVLExp.BinaryExp.SubExp exp) {
                return CVLExpTransformer.DefaultImpls.sub(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp.UnaryExp.UnaryMinusExp, CVLError> unaryMinus(@NotNull CVLExp.UnaryExp.UnaryMinusExp exp) {
                return CVLExpTransformer.DefaultImpls.unaryMinus(this, exp);
            }

            @NotNull
            public CollectingResult<CVLExp, CVLError> variable(@NotNull CVLExp.VariableExp exp) {
                return CVLExpTransformer.DefaultImpls.variable(this, exp);
            }
        }.expr(exp), checkNoContractOrCVLCalls.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final CollectingResult<Unit, CVLError> validateGhostAxiomContents(CVLGhostAxiom axiom, CVLGhostDeclaration ghost2) {
        CollectingResult collectingResult;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        CollectingResult<Unit, CVLError> noContractCalls = this.checkNoContractOrCVLCalls(axiom.getExp(), "axiom for ghost " + ghost2.getId());
        Object this_$iv = axiom.getExp();
        boolean $i$f$subExprsOfType = false;
        var collector$iv = new CVLExpFolder<List<? extends CVLExp.CastExpr>>(){

            @NotNull
            public List<CVLExp.CastExpr> variable(@NotNull List<? extends CVLExp.CastExpr> acc, @NotNull CVLExp.VariableExp exp) {
                Intrinsics.checkNotNullParameter(acc, "acc");
                Intrinsics.checkNotNullParameter(exp, "exp");
                return acc;
            }

            @NotNull
            public List<CVLExp.CastExpr> expr(@NotNull List<? extends CVLExp.CastExpr> acc, @NotNull CVLExp exp) {
                Intrinsics.checkNotNullParameter(acc, "acc");
                Intrinsics.checkNotNullParameter(exp, "exp");
                return ListsKt.plus((Collection)super.expr(acc, exp), (Iterable)(exp instanceof CVLExp.CastExpr ? ListsKt.listOf(exp) : ListsKt.listOf()));
            }
        };
        this_$iv = collector$iv.expr(ListsKt.listOf(), (CVLExp)this_$iv);
        boolean $i$f$filter2 = false;
        collector$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CVLExp.CastExpr castExp = (CVLExp.CastExpr)element$iv$iv;
            boolean bl = false;
            if (!(castExp.getCastType() == CastType.ASSERT || castExp.getCastType() == CastType.REQUIRE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List castExps = (List)destination$iv$iv;
        if (!((Collection)castExps).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $i$f$filter2 = castExps;
            CollectingResult.Companion companion = CollectingResult.Companion;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void castExp;
                CVLExp.CastExpr bl = (CVLExp.CastExpr)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new CVLError.Exp((CVLExp)castExp, castExp.getCastType().getStr() + "-type casts have side effects! They cannot be used inside a ghost axiom. If casting is required, try upcasting all expressions to mathints"));
            }
            collectingResult = companion.asError((List)destination$iv$iv2);
        } else {
            collectingResult = CollectingResult.Companion.getOk();
        }
        CollectingResult castExpsInAxiom = collectingResult;
        CollectingResult[] collectingResultArray = new CollectingResult[]{noContractCalls, castExpsInAxiom};
        return CollectingResult.Companion.flattenToVoidVarArg(collectingResultArray);
    }

    @Override
    @NotNull
    public CollectingResult<CVLGhostDeclaration, CVLError> ghost(@NotNull CVLGhostDeclaration ghost2) {
        Intrinsics.checkNotNullParameter(ghost2, "ghost");
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, CVLGhostDeclaration>(ghost2, this){
            final /* synthetic */ CVLGhostDeclaration $ghost;
            final /* synthetic */ CVLAstAdditionalChecks this$0;
            {
                this.$ghost = $ghost;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CVLGhostDeclaration invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                Iterable iterable = this.$ghost.getAxioms();
                CVLAstAdditionalChecks cVLAstAdditionalChecks = this.this$0;
                CVLGhostDeclaration cVLGhostDeclaration = this.$ghost;
                ErrorCollector<CVLError> errorCollector = $this$collectingErrors;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    CVLGhostAxiom cVLGhostAxiom = (CVLGhostAxiom)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CVLAstAdditionalChecks.access$validateGhostAxiomContents(cVLAstAdditionalChecks, (CVLGhostAxiom)it2, cVLGhostDeclaration));
                }
                errorCollector.collect((List)destination$iv$iv);
                return (CVLGhostDeclaration)$this$collectingErrors.bind(CVLAstAdditionalChecks.access$ghost$s2004824016(this.this$0, this.$ghost));
            }
        });
    }

    public static final /* synthetic */ CollectingResult access$ast$s2004824016(CVLAstAdditionalChecks $this, CVLAst ast2) {
        return super.ast(ast2);
    }

    public static final /* synthetic */ CollectingResult access$inv$s2004824016(CVLAstAdditionalChecks $this, CVLInvariant inv2) {
        return super.inv(inv2);
    }

    public static final /* synthetic */ CollectingResult access$filterExpMustBeBooleanAndClosed(CVLAstAdditionalChecks $this, CVLExp filterExp, Set allowedVarsInUse) {
        return $this.filterExpMustBeBooleanAndClosed(filterExp, allowedVarsInUse);
    }

    public static final /* synthetic */ CollectingResult access$rule$s2004824016(CVLAstAdditionalChecks $this, SingleRuleWithCode rule2) {
        return super.rule(rule2);
    }

    public static final /* synthetic */ CollectingResult access$ghost$s2004824016(CVLAstAdditionalChecks $this, CVLGhostDeclaration ghost2) {
        return super.ghost(ghost2);
    }

    public static final /* synthetic */ CollectingResult access$validateGhostAxiomContents(CVLAstAdditionalChecks $this, CVLGhostAxiom axiom, CVLGhostDeclaration ghost2) {
        return $this.validateGhostAxiomContents(axiom, ghost2);
    }
}

