/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import algorithms.TopologicalOrderException;
import algorithms.TopologicalSortKt;
import datastructures.stdcollections.IterablesKt;
import datastructures.stdcollections.MapsKt;
import datastructures.stdcollections.SetsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpModifiesReads;
import spec.cvlast.CVLGhostFunction;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.ResolvedCallableName;
import spec.cvlast.transformer.CVLAstTransformer;
import spec.cvlast.transformer.CVLCmdTransformer;
import spec.cvlast.transformer.CVLExpTransformer;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lspec/cvlast/DefinitionDependencyChecker;", "Lspec/cvlast/transformer/CVLAstTransformer;", "Lspec/cvlast/typechecker/CVLError;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "(Lspec/cvlast/CVLSymbolTable;)V", "getSymbolTable", "()Lspec/cvlast/CVLSymbolTable;", "defs", "Lutils/CollectingResult;", "", "Lspec/cvlast/CVLDefinition;", "Shared"})
@SourceDebugExtension(value={"SMAP\nDefinitionDependencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefinitionDependencyChecker.kt\nspec/cvlast/DefinitionDependencyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1855#2,2:76\n1549#2:78\n1620#2,2:79\n1789#2,3:81\n1622#2:84\n*S KotlinDebug\n*F\n+ 1 DefinitionDependencyChecker.kt\nspec/cvlast/DefinitionDependencyChecker\n*L\n26#1:76,2\n48#1:78\n48#1:79,2\n53#1:81,3\n48#1:84\n*E\n"})
public final class DefinitionDependencyChecker
extends CVLAstTransformer<CVLError> {
    @NotNull
    private final CVLSymbolTable symbolTable;

    public DefinitionDependencyChecker(@NotNull CVLSymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        super(new CVLCmdTransformer(CVLExpTransformer.Companion.copyTransformer()), null, 2, null);
        this.symbolTable = symbolTable;
    }

    @NotNull
    public final CVLSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CollectingResult<List<CVLDefinition>, CVLError> defs(@NotNull List<CVLDefinition> defs2) {
        CollectingResult collectingResult;
        Intrinsics.checkNotNullParameter(defs2, "defs");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv2;
            Map definitionDependencies = MapsKt.mutableMapOf();
            Map<CVLDefinition, CVLDefinition> astDefinitionVersion = MapsKt.mutableMapOf();
            Iterable $this$forEach$iv = defs2;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                CVLDefinition definition2 = (CVLDefinition)element$iv2;
                boolean bl = false;
                String string = definition2.getId();
                CVLScope cVLScope = definition2.getScope();
                Intrinsics.checkNotNull(cVLScope);
                CVLSymbolTable.SymbolInfo symbolInfo = this.symbolTable.lookUpFunctionLikeSymbol(string, cVLScope);
                Object object = symbolInfo != null ? symbolInfo.getSymbolValue() : null;
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type spec.cvlast.CVLDefinition");
                CVLDefinition defInSymbolTable = (CVLDefinition)object;
                Set<CVLDefinition> deps = SetsKt.mutableSetOf();
                var transformer2 = new CVLExpTransformer(this, definition2, deps){
                    final /* synthetic */ DefinitionDependencyChecker this$0;
                    final /* synthetic */ CVLDefinition $definition;
                    final /* synthetic */ Set<CVLDefinition> $deps;
                    {
                        this.this$0 = $receiver;
                        this.$definition = $definition;
                        this.$deps = $deps;
                    }

                    @NotNull
                    public CollectingResult definition(@NotNull CVLExp.ApplyExp.Definition exp) {
                        CVLSymbolTable.SymbolInfo definitionInfo;
                        Intrinsics.checkNotNullParameter(exp, "exp");
                        CVLSymbolTable.SymbolInfo symbolInfo = definitionInfo = this.this$0.getSymbolTable().lookUpWithMethodIdWithCallContext((ResolvedCallableName)exp.getMethodIdWithCallContext(), this.$definition.getScope());
                        Object dep = symbolInfo != null ? symbolInfo.getSymbolValue() : null;
                        if (!(dep != null && dep instanceof CVLDefinition)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        this.$deps.add((CVLDefinition)dep);
                        return CollectingResult.Companion.lift(exp);
                    }

                    @NotNull
                    public CollectingResult lhs(@NotNull CVLLhs lhs) {
                        return CVLExpTransformer.DefaultImpls.lhs(this, lhs);
                    }

                    @NotNull
                    public CollectingResult idLhs(@NotNull CVLLhs.Id idLhs2) {
                        return CVLExpTransformer.DefaultImpls.idLhs(this, idLhs2);
                    }

                    @NotNull
                    public CollectingResult expr(@NotNull CVLExp exp) {
                        return CVLExpTransformer.DefaultImpls.expr(this, exp);
                    }

                    @NotNull
                    public CollectingResult application(@NotNull CVLExp.ApplicationExp exp) {
                        return CVLExpTransformer.DefaultImpls.application(this, exp);
                    }

                    @NotNull
                    public CollectingResult applyExp(@NotNull CVLExp.ApplyExp exp) {
                        return CVLExpTransformer.DefaultImpls.applyExp(this, exp);
                    }

                    @NotNull
                    public CollectingResult builtin(@NotNull CVLExp.ApplyExp.CVLBuiltIn exp) {
                        return CVLExpTransformer.DefaultImpls.builtin(this, exp);
                    }

                    @NotNull
                    public CollectingResult relop(@NotNull CVLExp.RelopExp exp) {
                        return CVLExpTransformer.DefaultImpls.relop(this, exp);
                    }

                    @NotNull
                    public CollectingResult arithRelop(@NotNull CVLExp.RelopExp.ArithRelopExp exp) {
                        return CVLExpTransformer.DefaultImpls.arithRelop(this, exp);
                    }

                    @NotNull
                    public CollectingResult const(@NotNull CVLExp.Constant exp) {
                        return CVLExpTransformer.DefaultImpls.const(this, exp);
                    }

                    @NotNull
                    public CollectingResult arrayLhs(@NotNull CVLLhs.Array arrayLhs2) {
                        return CVLExpTransformer.DefaultImpls.arrayLhs(this, arrayLhs2);
                    }

                    @NotNull
                    public CollectingResult unresolvedApplyExp(@NotNull CVLExp.UnresolvedApplyExp exp) {
                        return CVLExpTransformer.DefaultImpls.unresolvedApplyExp(this, exp);
                    }

                    @NotNull
                    public CollectingResult ge(@NotNull CVLExp.RelopExp.ArithRelopExp.GeExp exp) {
                        return CVLExpTransformer.DefaultImpls.ge(this, exp);
                    }

                    @NotNull
                    public CollectingResult gt(@NotNull CVLExp.RelopExp.ArithRelopExp.GtExp exp) {
                        return CVLExpTransformer.DefaultImpls.gt(this, exp);
                    }

                    @NotNull
                    public CollectingResult le(@NotNull CVLExp.RelopExp.ArithRelopExp.LeExp exp) {
                        return CVLExpTransformer.DefaultImpls.le(this, exp);
                    }

                    @NotNull
                    public CollectingResult lt(@NotNull CVLExp.RelopExp.ArithRelopExp.LtExp exp) {
                        return CVLExpTransformer.DefaultImpls.lt(this, exp);
                    }

                    @NotNull
                    public CollectingResult eq(@NotNull CVLExp.RelopExp.EqExp exp) {
                        return CVLExpTransformer.DefaultImpls.eq(this, exp);
                    }

                    @NotNull
                    public CollectingResult ne(@NotNull CVLExp.RelopExp.NeExp exp) {
                        return CVLExpTransformer.DefaultImpls.ne(this, exp);
                    }

                    @NotNull
                    public CollectingResult add(@NotNull CVLExp.BinaryExp.AddExp exp) {
                        return CVLExpTransformer.DefaultImpls.add(this, exp);
                    }

                    @NotNull
                    public CollectingResult enumConstant(@NotNull CVLExp.Constant.EnumConstant exp) {
                        return CVLExpTransformer.DefaultImpls.enumConstant(this, exp);
                    }

                    @NotNull
                    public CollectingResult boolLit(@NotNull CVLExp.Constant.BoolLit exp) {
                        return CVLExpTransformer.DefaultImpls.boolLit(this, exp);
                    }

                    @NotNull
                    public CollectingResult numberLit(@NotNull CVLExp.Constant.NumberLit exp) {
                        return CVLExpTransformer.DefaultImpls.numberLit(this, exp);
                    }

                    @NotNull
                    public CollectingResult stringLit(@NotNull CVLExp.Constant.StringLit exp) {
                        return CVLExpTransformer.DefaultImpls.stringLit(this, exp);
                    }

                    @NotNull
                    public CollectingResult structLit(@NotNull CVLExp.Constant.StructLit exp) {
                        return CVLExpTransformer.DefaultImpls.structLit(this, exp);
                    }

                    @NotNull
                    public CollectingResult signatureLit(@NotNull CVLExp.Constant.SignatureLiteralExp exp) {
                        return CVLExpTransformer.DefaultImpls.signatureLit(this, exp);
                    }

                    @NotNull
                    public CollectingResult ghost(@NotNull CVLExp.ApplyExp.Ghost exp) {
                        return CVLExpTransformer.DefaultImpls.ghost(this, exp);
                    }

                    @NotNull
                    public CollectingResult castExpression(@NotNull CVLExp.CastExpr exp) {
                        return CVLExpTransformer.DefaultImpls.castExpression(this, exp);
                    }

                    @NotNull
                    public CollectingResult call(@NotNull CVLExp.ApplyExp.CVLFunction exp) {
                        return CVLExpTransformer.DefaultImpls.call(this, exp);
                    }

                    @NotNull
                    public CollectingResult div(@NotNull CVLExp.BinaryExp.DivExp exp) {
                        return CVLExpTransformer.DefaultImpls.div(this, exp);
                    }

                    @NotNull
                    public CollectingResult mod(@NotNull CVLExp.BinaryExp.ModExp exp) {
                        return CVLExpTransformer.DefaultImpls.mod(this, exp);
                    }

                    @NotNull
                    public CollectingResult exponent(@NotNull CVLExp.BinaryExp.ExponentExp exp) {
                        return CVLExpTransformer.DefaultImpls.exponent(this, exp);
                    }

                    @NotNull
                    public CollectingResult iff(@NotNull CVLExp.BinaryExp.IffExp exp) {
                        return CVLExpTransformer.DefaultImpls.iff(this, exp);
                    }

                    @NotNull
                    public CollectingResult implies(@NotNull CVLExp.BinaryExp.ImpliesExp exp) {
                        return CVLExpTransformer.DefaultImpls.implies(this, exp);
                    }

                    @NotNull
                    public CollectingResult bwor(@NotNull CVLExp.BinaryExp.BwOrExp exp) {
                        return CVLExpTransformer.DefaultImpls.bwor(this, exp);
                    }

                    @NotNull
                    public CollectingResult bwxor(@NotNull CVLExp.BinaryExp.BwXOrExp exp) {
                        return CVLExpTransformer.DefaultImpls.bwxor(this, exp);
                    }

                    @NotNull
                    public CollectingResult bwand(@NotNull CVLExp.BinaryExp.BwAndExp exp) {
                        return CVLExpTransformer.DefaultImpls.bwand(this, exp);
                    }

                    @NotNull
                    public CollectingResult bwlsh(@NotNull CVLExp.BinaryExp.BwLeftShiftExp exp) {
                        return CVLExpTransformer.DefaultImpls.bwlsh(this, exp);
                    }

                    @NotNull
                    public CollectingResult bwrsh(@NotNull CVLExp.BinaryExp.BwRightShiftExp exp) {
                        return CVLExpTransformer.DefaultImpls.bwrsh(this, exp);
                    }

                    @NotNull
                    public CollectingResult bwrshwzeros(@NotNull CVLExp.BinaryExp.BwRightShiftWithZerosExp exp) {
                        return CVLExpTransformer.DefaultImpls.bwrshwzeros(this, exp);
                    }

                    @NotNull
                    public CollectingResult bwnot(@NotNull CVLExp.UnaryExp.BwNotExp exp) {
                        return CVLExpTransformer.DefaultImpls.bwnot(this, exp);
                    }

                    @NotNull
                    public CollectingResult invokeExp(@NotNull CVLExp.ApplyExp.ContractFunction exp) {
                        return CVLExpTransformer.DefaultImpls.invokeExp(this, exp);
                    }

                    @NotNull
                    public CollectingResult arrayexp(@NotNull CVLExp.ArrayLitExp exp) {
                        return CVLExpTransformer.DefaultImpls.arrayexp(this, exp);
                    }

                    @NotNull
                    public CollectingResult condexp(@NotNull CVLExp.CondExp exp) {
                        return CVLExpTransformer.DefaultImpls.condexp(this, exp);
                    }

                    @NotNull
                    public CollectingResult land(@NotNull CVLExp.BinaryExp.LandExp exp) {
                        return CVLExpTransformer.DefaultImpls.land(this, exp);
                    }

                    @NotNull
                    public CollectingResult lor(@NotNull CVLExp.BinaryExp.LorExp exp) {
                        return CVLExpTransformer.DefaultImpls.lor(this, exp);
                    }

                    @NotNull
                    public CollectingResult mul(@NotNull CVLExp.BinaryExp.MulExp exp) {
                        return CVLExpTransformer.DefaultImpls.mul(this, exp);
                    }

                    @NotNull
                    public CollectingResult neg(@NotNull CVLExp.UnaryExp.LNotExp exp) {
                        return CVLExpTransformer.DefaultImpls.neg(this, exp);
                    }

                    @NotNull
                    public CollectingResult quant(@NotNull CVLExp.QuantifierExp exp) {
                        return CVLExpTransformer.DefaultImpls.quant(this, exp);
                    }

                    @NotNull
                    public CollectingResult fieldSel(@NotNull CVLExp.FieldSelectExp exp) {
                        return CVLExpTransformer.DefaultImpls.fieldSel(this, exp);
                    }

                    @NotNull
                    public CollectingResult setmem(@NotNull CVLExp.SetMemExp exp) {
                        return CVLExpTransformer.DefaultImpls.setmem(this, exp);
                    }

                    @NotNull
                    public CollectingResult arraylength(@NotNull CVLExp.ArrayLengthExp exp) {
                        return CVLExpTransformer.DefaultImpls.arraylength(this, exp);
                    }

                    @NotNull
                    public CollectingResult arrayderef(@NotNull CVLExp.ArrayDerefExp exp) {
                        return CVLExpTransformer.DefaultImpls.arrayderef(this, exp);
                    }

                    @NotNull
                    public CollectingResult sub(@NotNull CVLExp.BinaryExp.SubExp exp) {
                        return CVLExpTransformer.DefaultImpls.sub(this, exp);
                    }

                    @NotNull
                    public CollectingResult unaryMinus(@NotNull CVLExp.UnaryExp.UnaryMinusExp exp) {
                        return CVLExpTransformer.DefaultImpls.unaryMinus(this, exp);
                    }

                    @NotNull
                    public CollectingResult variable(@NotNull CVLExp.VariableExp exp) {
                        return CVLExpTransformer.DefaultImpls.variable(this, exp);
                    }
                };
                transformer2.expr(definition2.getBody());
                definitionDependencies.put(defInSymbolTable, IterablesKt.toSet((Iterable)deps));
                astDefinitionVersion.put(defInSymbolTable, definition2);
            }
            List definitionTopoSort = CollectionsKt.reversed(TopologicalSortKt.topologicalOrder$default(definitionDependencies, false, 2, null));
            Map<void, Set<CVLGhostFunction>> modifiesMap = MapsKt.mutableMapOf();
            Map<void, Set<CVLGhostFunction>> readsMap = MapsKt.mutableMapOf();
            element$iv2 = CollectionsKt.reversed(definitionTopoSort);
            CollectingResult.Companion companion = CollectingResult.Companion;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$fold$iv;
                void defInSymbolTable;
                CVLDefinition cVLDefinition = (CVLDefinition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object v = astDefinitionVersion.get(defInSymbolTable);
                Intrinsics.checkNotNull(v);
                CVLDefinition definition3 = (CVLDefinition)v;
                CVLRange cVLRange = definition3.getCvlRange();
                CVLScope cVLScope = definition3.getScope();
                Intrinsics.checkNotNull(cVLScope);
                Pair<Set<CVLGhostFunction>, Set<CVLGhostFunction>> pair2 = CVLExpModifiesReads.Companion.getModifiedAndRead(this.symbolTable, cVLRange, cVLScope, definition3.getBody());
                Set<CVLGhostFunction> modified = pair2.component1();
                Set<CVLGhostFunction> read = pair2.component2();
                Object v2 = definitionDependencies.get(defInSymbolTable);
                Intrinsics.checkNotNull(v2);
                Iterable iterable = (Iterable)v2;
                Pair initial$iv = TuplesKt.to(SetsKt.setOf(), SetsKt.setOf());
                boolean $i$f$fold = false;
                Pair accumulator$iv = initial$iv;
                for (Object element$iv3 : $this$fold$iv) {
                    void el;
                    CVLDefinition cVLDefinition2 = (CVLDefinition)element$iv3;
                    Pair pair3 = accumulator$iv;
                    boolean bl3 = false;
                    Set modifiedAcc = pair3.component1();
                    Set readAcc = pair3.component2();
                    String string = el.getId();
                    CVLScope cVLScope2 = el.getScope();
                    Intrinsics.checkNotNull(cVLScope2);
                    CVLSymbolTable.SymbolInfo symbolInfo = this.symbolTable.lookUpFunctionLikeSymbol(string, cVLScope2);
                    Object object = symbolInfo != null ? symbolInfo.getSymbolValue() : null;
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type spec.cvlast.CVLDefinition");
                    CVLDefinition dep = (CVLDefinition)object;
                    Object v3 = modifiesMap.get(dep);
                    Intrinsics.checkNotNull(v3);
                    Set set2 = SetsKt.plus(modifiedAcc, (Iterable)v3);
                    Object v4 = readsMap.get(dep);
                    Intrinsics.checkNotNull(v4);
                    accumulator$iv = TuplesKt.to(set2, SetsKt.plus(readAcc, (Iterable)v4));
                }
                Pair pair4 = accumulator$iv;
                Set depsModified = pair4.component1();
                Set depsRead = pair4.component2();
                definition3.setModifies(SetsKt.plus(modified, depsModified));
                definition3.setReads(SetsKt.plus(read, depsRead));
                modifiesMap.put(defInSymbolTable, definition3.getModifies());
                readsMap.put(defInSymbolTable, definition3.getReads());
                collection.add(CollectingResult.Companion.lift(definition3));
            }
            collectingResult = companion.flatten((List)destination$iv$iv);
        }
        catch (TopologicalOrderException e) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.General(new CVLRange.Empty(null, 1, null), "A circular dependency was found in a definition: this is not allowed. Topo sort error: " + e.getMsg()));
        }
        return collectingResult;
    }
}

