from . import __version__, __name__ as prog


def banner():
    from chromatic import read_ans
    from base64 import b64decode
    import io

    art = read_ans(
        io.TextIOWrapper(
            io.BytesIO(
                b64decode(
                    b"""\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"""
                )
            ),
            encoding="cp437",
        )
    )

    return art.format(f"{prog} {__version__}")


def main():
    import argparse

    parser = argparse.ArgumentParser(
        prog=prog,
        description=banner(),
        formatter_class=argparse.RawDescriptionHelpFormatter,
    )
    parser.add_argument(
        "--version", action="version", version=f"%(prog)s {__version__}"
    )
    parser.parse_args()


if __name__ == '__main__':
    main()
