# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""

# Module PySide6.QtCore
import PySide6
try:
    import typing
except ImportError:
    from PySide6.support.signature import typing
from PySide6.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken6 as Shiboken
Shiboken.Object = Object

import PySide6.QtCore


class ClassInfo(object):

    @staticmethod
    def __init__(**info:typing.Dict) -> None: ...


class MetaFunction(object):
    @staticmethod
    def __call__(*args:typing.Any) -> typing.Any: ...


class MetaSignal(type):
    @staticmethod
    def __instancecheck__(object:object) -> bool: ...


class Property(object):

    def __init__(self, type:type, fget:typing.Optional[typing.Callable]=..., fset:typing.Optional[typing.Callable]=..., freset:typing.Optional[typing.Callable]=..., fdel:typing.Optional[typing.Callable]=..., doc:str=..., notify:typing.Optional[typing.Callable]=..., designable:bool=..., scriptable:bool=..., stored:bool=..., user:bool=..., constant:bool=..., final:bool=...) -> PySide6.QtCore.Property: ...

    def deleter(self, func:typing.Callable) -> None: ...
    def getter(self, func:typing.Callable) -> None: ...
    def read(self, func:typing.Callable) -> None: ...
    def setter(self, func:typing.Callable) -> None: ...
    def write(self, func:typing.Callable) -> None: ...


class QAbstractAnimation(PySide6.QtCore.QObject):
    Forward                  : QAbstractAnimation = ... # 0x0
    KeepWhenStopped          : QAbstractAnimation = ... # 0x0
    Stopped                  : QAbstractAnimation = ... # 0x0
    Backward                 : QAbstractAnimation = ... # 0x1
    DeleteWhenStopped        : QAbstractAnimation = ... # 0x1
    Paused                   : QAbstractAnimation = ... # 0x1
    Running                  : QAbstractAnimation = ... # 0x2

    class DeletionPolicy(object):
        KeepWhenStopped          : QAbstractAnimation.DeletionPolicy = ... # 0x0
        DeleteWhenStopped        : QAbstractAnimation.DeletionPolicy = ... # 0x1

    class Direction(object):
        Forward                  : QAbstractAnimation.Direction = ... # 0x0
        Backward                 : QAbstractAnimation.Direction = ... # 0x1

    class State(object):
        Stopped                  : QAbstractAnimation.State = ... # 0x0
        Paused                   : QAbstractAnimation.State = ... # 0x1
        Running                  : QAbstractAnimation.State = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def currentLoop(self) -> int: ...
    def currentLoopTime(self) -> int: ...
    def currentTime(self) -> int: ...
    def direction(self) -> PySide6.QtCore.QAbstractAnimation.Direction: ...
    def duration(self) -> int: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def group(self) -> PySide6.QtCore.QAnimationGroup: ...
    def loopCount(self) -> int: ...
    def pause(self) -> None: ...
    def resume(self) -> None: ...
    def setCurrentTime(self, msecs:int) -> None: ...
    def setDirection(self, direction:PySide6.QtCore.QAbstractAnimation.Direction) -> None: ...
    def setLoopCount(self, loopCount:int) -> None: ...
    def setPaused(self, arg__1:bool) -> None: ...
    def start(self, policy:PySide6.QtCore.QAbstractAnimation.DeletionPolicy=...) -> None: ...
    def state(self) -> PySide6.QtCore.QAbstractAnimation.State: ...
    def stop(self) -> None: ...
    def totalDuration(self) -> int: ...
    def updateCurrentTime(self, currentTime:int) -> None: ...
    def updateDirection(self, direction:PySide6.QtCore.QAbstractAnimation.Direction) -> None: ...
    def updateState(self, newState:PySide6.QtCore.QAbstractAnimation.State, oldState:PySide6.QtCore.QAbstractAnimation.State) -> None: ...


class QAbstractEventDispatcher(PySide6.QtCore.QObject):

    class TimerInfo(Shiboken.Object):

        def __init__(self, id:int, i:int, t:PySide6.QtCore.Qt.TimerType) -> None: ...


    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def closingDown(self) -> None: ...
    def filterNativeEvent(self, eventType:PySide6.QtCore.QByteArray, message:int) -> typing.Tuple: ...
    def installNativeEventFilter(self, filterObj:PySide6.QtCore.QAbstractNativeEventFilter) -> None: ...
    @staticmethod
    def instance(thread:typing.Optional[PySide6.QtCore.QThread]=...) -> PySide6.QtCore.QAbstractEventDispatcher: ...
    def interrupt(self) -> None: ...
    def processEvents(self, flags:PySide6.QtCore.QEventLoop.ProcessEventsFlags) -> bool: ...
    def registerSocketNotifier(self, notifier:PySide6.QtCore.QSocketNotifier) -> None: ...
    @typing.overload
    def registerTimer(self, interval:int, timerType:PySide6.QtCore.Qt.TimerType, object:PySide6.QtCore.QObject) -> int: ...
    @typing.overload
    def registerTimer(self, timerId:int, interval:int, timerType:PySide6.QtCore.Qt.TimerType, object:PySide6.QtCore.QObject) -> None: ...
    def registeredTimers(self, object:PySide6.QtCore.QObject) -> typing.List: ...
    def remainingTime(self, timerId:int) -> int: ...
    def removeNativeEventFilter(self, filterObj:PySide6.QtCore.QAbstractNativeEventFilter) -> None: ...
    def startingUp(self) -> None: ...
    def unregisterSocketNotifier(self, notifier:PySide6.QtCore.QSocketNotifier) -> None: ...
    def unregisterTimer(self, timerId:int) -> bool: ...
    def unregisterTimers(self, object:PySide6.QtCore.QObject) -> bool: ...
    def wakeUp(self) -> None: ...


class QAbstractItemModel(PySide6.QtCore.QObject):
    NoLayoutChangeHint       : QAbstractItemModel = ... # 0x0
    VerticalSortHint         : QAbstractItemModel = ... # 0x1
    HorizontalSortHint       : QAbstractItemModel = ... # 0x2

    class CheckIndexOption(object):
        NoOption                 : QAbstractItemModel.CheckIndexOption = ... # 0x0
        IndexIsValid             : QAbstractItemModel.CheckIndexOption = ... # 0x1
        DoNotUseParent           : QAbstractItemModel.CheckIndexOption = ... # 0x2
        ParentIsInvalid          : QAbstractItemModel.CheckIndexOption = ... # 0x4

    class CheckIndexOptions(object): ...

    class LayoutChangeHint(object):
        NoLayoutChangeHint       : QAbstractItemModel.LayoutChangeHint = ... # 0x0
        VerticalSortHint         : QAbstractItemModel.LayoutChangeHint = ... # 0x1
        HorizontalSortHint       : QAbstractItemModel.LayoutChangeHint = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def beginInsertColumns(self, parent:PySide6.QtCore.QModelIndex, first:int, last:int) -> None: ...
    def beginInsertRows(self, parent:PySide6.QtCore.QModelIndex, first:int, last:int) -> None: ...
    def beginMoveColumns(self, sourceParent:PySide6.QtCore.QModelIndex, sourceFirst:int, sourceLast:int, destinationParent:PySide6.QtCore.QModelIndex, destinationColumn:int) -> bool: ...
    def beginMoveRows(self, sourceParent:PySide6.QtCore.QModelIndex, sourceFirst:int, sourceLast:int, destinationParent:PySide6.QtCore.QModelIndex, destinationRow:int) -> bool: ...
    def beginRemoveColumns(self, parent:PySide6.QtCore.QModelIndex, first:int, last:int) -> None: ...
    def beginRemoveRows(self, parent:PySide6.QtCore.QModelIndex, first:int, last:int) -> None: ...
    def beginResetModel(self) -> None: ...
    def buddy(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def canDropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def canFetchMore(self, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def changePersistentIndex(self, from_:PySide6.QtCore.QModelIndex, to:PySide6.QtCore.QModelIndex) -> None: ...
    def changePersistentIndexList(self, from_:typing.List, to:typing.List) -> None: ...
    def checkIndex(self, index:PySide6.QtCore.QModelIndex, options:PySide6.QtCore.QAbstractItemModel.CheckIndexOptions=...) -> bool: ...
    def clearItemData(self, index:PySide6.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    @typing.overload
    def createIndex(self, row:int, column:int, id:int=...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def createIndex(self, row:int, column:int, ptr:object) -> PySide6.QtCore.QModelIndex: ...
    def data(self, index:PySide6.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def decodeData(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex, stream:PySide6.QtCore.QDataStream) -> bool: ...
    def dropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def encodeData(self, indexes:typing.List, stream:PySide6.QtCore.QDataStream) -> None: ...
    def endInsertColumns(self) -> None: ...
    def endInsertRows(self) -> None: ...
    def endMoveColumns(self) -> None: ...
    def endMoveRows(self) -> None: ...
    def endRemoveColumns(self) -> None: ...
    def endRemoveRows(self) -> None: ...
    def endResetModel(self) -> None: ...
    def fetchMore(self, parent:PySide6.QtCore.QModelIndex) -> None: ...
    def flags(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def hasIndex(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def headerData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def index(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumn(self, column:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def insertColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def insertRow(self, row:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def insertRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def itemData(self, index:PySide6.QtCore.QModelIndex) -> typing.Dict: ...
    def match(self, start:PySide6.QtCore.QModelIndex, role:int, value:typing.Any, hits:int=..., flags:PySide6.QtCore.Qt.MatchFlags=...) -> typing.List: ...
    def mimeData(self, indexes:typing.List) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    def moveColumn(self, sourceParent:PySide6.QtCore.QModelIndex, sourceColumn:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    def moveColumns(self, sourceParent:PySide6.QtCore.QModelIndex, sourceColumn:int, count:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    def moveRow(self, sourceParent:PySide6.QtCore.QModelIndex, sourceRow:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    def moveRows(self, sourceParent:PySide6.QtCore.QModelIndex, sourceRow:int, count:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def persistentIndexList(self) -> typing.List: ...
    def removeColumn(self, column:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def removeColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def removeRow(self, row:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def removeRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def resetInternalData(self) -> None: ...
    def revert(self) -> None: ...
    def roleNames(self) -> typing.Dict: ...
    def rowCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def setData(self, index:PySide6.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setHeaderData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, value:typing.Any, role:int=...) -> bool: ...
    def setItemData(self, index:PySide6.QtCore.QModelIndex, roles:typing.Dict) -> bool: ...
    def sibling(self, row:int, column:int, idx:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column:int, order:PySide6.QtCore.Qt.SortOrder=...) -> None: ...
    def span(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QSize: ...
    def submit(self) -> bool: ...
    def supportedDragActions(self) -> PySide6.QtCore.Qt.DropActions: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropActions: ...


class QAbstractListModel(PySide6.QtCore.QAbstractItemModel):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def columnCount(self, parent:PySide6.QtCore.QModelIndex) -> int: ...
    def dropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def flags(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def index(self, row:int, column:int=..., parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def sibling(self, row:int, column:int, idx:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...


class QAbstractNativeEventFilter(Shiboken.Object):

    def __init__(self) -> None: ...

    def nativeEventFilter(self, eventType:PySide6.QtCore.QByteArray, message:int) -> typing.Tuple: ...


class QAbstractProxyModel(PySide6.QtCore.QAbstractItemModel):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def buddy(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def canDropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def canFetchMore(self, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def clearItemData(self, index:PySide6.QtCore.QModelIndex) -> bool: ...
    def data(self, proxyIndex:PySide6.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def dropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def fetchMore(self, parent:PySide6.QtCore.QModelIndex) -> None: ...
    def flags(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def headerData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def itemData(self, index:PySide6.QtCore.QModelIndex) -> typing.Dict: ...
    def mapFromSource(self, sourceIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, selection:PySide6.QtCore.QItemSelection) -> PySide6.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, selection:PySide6.QtCore.QItemSelection) -> PySide6.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def mimeData(self, indexes:typing.List) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    def revert(self) -> None: ...
    def roleNames(self) -> typing.Dict: ...
    def setData(self, index:PySide6.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setHeaderData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, value:typing.Any, role:int=...) -> bool: ...
    def setItemData(self, index:PySide6.QtCore.QModelIndex, roles:typing.Dict) -> bool: ...
    def setSourceModel(self, sourceModel:PySide6.QtCore.QAbstractItemModel) -> None: ...
    def sibling(self, row:int, column:int, idx:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column:int, order:PySide6.QtCore.Qt.SortOrder=...) -> None: ...
    def sourceModel(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def span(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QSize: ...
    def submit(self) -> bool: ...
    def supportedDragActions(self) -> PySide6.QtCore.Qt.DropActions: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropActions: ...


class QAbstractTableModel(PySide6.QtCore.QAbstractItemModel):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def dropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def flags(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def index(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def sibling(self, row:int, column:int, idx:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...


class QAnimationGroup(PySide6.QtCore.QAbstractAnimation):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def addAnimation(self, animation:PySide6.QtCore.QAbstractAnimation) -> None: ...
    def animationAt(self, index:int) -> PySide6.QtCore.QAbstractAnimation: ...
    def animationCount(self) -> int: ...
    def clear(self) -> None: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def indexOfAnimation(self, animation:PySide6.QtCore.QAbstractAnimation) -> int: ...
    def insertAnimation(self, index:int, animation:PySide6.QtCore.QAbstractAnimation) -> None: ...
    def removeAnimation(self, animation:PySide6.QtCore.QAbstractAnimation) -> None: ...
    def takeAnimation(self, index:int) -> PySide6.QtCore.QAbstractAnimation: ...


class QBasicMutex(Shiboken.Object):

    def __init__(self) -> None: ...

    def lock(self) -> None: ...
    def tryLock(self) -> bool: ...
    def try_lock(self) -> bool: ...
    def unlock(self) -> None: ...


class QBasicTimer(Shiboken.Object):

    def __init__(self) -> None: ...

    def isActive(self) -> bool: ...
    @typing.overload
    def start(self, msec:int, obj:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def start(self, msec:int, timerType:PySide6.QtCore.Qt.TimerType, obj:PySide6.QtCore.QObject) -> None: ...
    def stop(self) -> None: ...
    def swap(self, other:PySide6.QtCore.QBasicTimer) -> None: ...
    def timerId(self) -> int: ...


class QBitArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QBitArray) -> None: ...
    @typing.overload
    def __init__(self, size:int, val:bool=...) -> None: ...

    def __and__(self, arg__2:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QBitArray: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iand__(self, arg__1:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QBitArray: ...
    def __invert__(self) -> PySide6.QtCore.QBitArray: ...
    def __ior__(self, arg__1:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QBitArray: ...
    def __ixor__(self, arg__1:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QBitArray: ...
    def __or__(self, arg__2:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QBitArray: ...
    def __xor__(self, arg__2:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QBitArray: ...
    def at(self, i:int) -> bool: ...
    def bits(self) -> bytes: ...
    def clear(self) -> None: ...
    def clearBit(self, i:int) -> None: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, on:bool) -> int: ...
    @typing.overload
    def fill(self, val:bool, first:int, last:int) -> None: ...
    @typing.overload
    def fill(self, val:bool, size:int=...) -> bool: ...
    @staticmethod
    def fromBits(data:bytes, len:int) -> PySide6.QtCore.QBitArray: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def resize(self, size:int) -> None: ...
    @typing.overload
    def setBit(self, i:int) -> None: ...
    @typing.overload
    def setBit(self, i:int, val:bool) -> None: ...
    def size(self) -> int: ...
    def swap(self, other:PySide6.QtCore.QBitArray) -> None: ...
    def testBit(self, i:int) -> bool: ...
    def toUInt32(self, endianness:PySide6.QtCore.QSysInfo.Endian) -> typing.Tuple: ...
    def toggleBit(self, i:int) -> bool: ...
    def truncate(self, pos:int) -> None: ...


class QBuffer(PySide6.QtCore.QIODevice):

    @typing.overload
    def __init__(self, buf:PySide6.QtCore.QByteArray, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def atEnd(self) -> bool: ...
    def buffer(self) -> PySide6.QtCore.QByteArray: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    def connectNotify(self, arg__1:PySide6.QtCore.QMetaMethod) -> None: ...
    def data(self) -> PySide6.QtCore.QByteArray: ...
    def disconnectNotify(self, arg__1:PySide6.QtCore.QMetaMethod) -> None: ...
    def open(self, openMode:PySide6.QtCore.QIODeviceBase.OpenMode) -> bool: ...
    def pos(self) -> int: ...
    def readData(self, data:bytes, maxlen:int) -> int: ...
    def seek(self, off:int) -> bool: ...
    def setBuffer(self, a:PySide6.QtCore.QByteArray) -> None: ...
    def setData(self, data:PySide6.QtCore.QByteArray) -> None: ...
    def size(self) -> int: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QByteArray(Shiboken.Object):
    Base64Encoding           : QByteArray = ... # 0x0
    IgnoreBase64DecodingErrors: QByteArray = ... # 0x0
    KeepTrailingEquals       : QByteArray = ... # 0x0
    Base64UrlEncoding        : QByteArray = ... # 0x1
    OmitTrailingEquals       : QByteArray = ... # 0x2
    AbortOnBase64DecodingErrors: QByteArray = ... # 0x4

    class Base64DecodingStatus(object):
        Ok                       : QByteArray.Base64DecodingStatus = ... # 0x0
        IllegalInputLength       : QByteArray.Base64DecodingStatus = ... # 0x1
        IllegalCharacter         : QByteArray.Base64DecodingStatus = ... # 0x2
        IllegalPadding           : QByteArray.Base64DecodingStatus = ... # 0x3

    class Base64Option(object):
        Base64Encoding           : QByteArray.Base64Option = ... # 0x0
        IgnoreBase64DecodingErrors: QByteArray.Base64Option = ... # 0x0
        KeepTrailingEquals       : QByteArray.Base64Option = ... # 0x0
        Base64UrlEncoding        : QByteArray.Base64Option = ... # 0x1
        OmitTrailingEquals       : QByteArray.Base64Option = ... # 0x2
        AbortOnBase64DecodingErrors: QByteArray.Base64Option = ... # 0x4

    class Base64Options(object): ...

    class FromBase64Result(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, FromBase64Result:PySide6.QtCore.QByteArray.FromBase64Result) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def swap(self, other:PySide6.QtCore.QByteArray.FromBase64Result) -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:bytearray) -> None: ...
    @typing.overload
    def __init__(self, arg__1:bytes) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, arg__1:bytes, size:int=...) -> None: ...
    @typing.overload
    def __init__(self, size:int, c:int) -> None: ...

    @typing.overload
    def __add__(self, a2:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, a2:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, arg__1:bytearray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, arg__1:bytes) -> None: ...
    @typing.overload
    def __add__(self, s:str) -> str: ...
    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def __iadd__(self, a:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __iadd__(self, arg__1:bytearray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __iadd__(self, c:int) -> PySide6.QtCore.QByteArray: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __str__(self) -> object: ...
    @typing.overload
    def append(self, a:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def append(self, c:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def append(self, count:int, c:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def append(self, s:bytes, len:int) -> PySide6.QtCore.QByteArray: ...
    def at(self, i:int) -> int: ...
    def back(self) -> int: ...
    def capacity(self) -> int: ...
    def cbegin(self) -> bytes: ...
    def cend(self) -> bytes: ...
    def chop(self, n:int) -> None: ...
    def chopped(self, len:int) -> PySide6.QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def compare(self, a:PySide6.QtCore.QByteArray, cs:PySide6.QtCore.Qt.CaseSensitivity=...) -> int: ...
    @typing.overload
    def contains(self, bv:PySide6.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def contains(self, c:int) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, bv:PySide6.QtCore.QByteArray) -> int: ...
    @typing.overload
    def count(self, c:int) -> int: ...
    def data(self) -> bytes: ...
    @typing.overload
    def endsWith(self, bv:PySide6.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def endsWith(self, c:int) -> bool: ...
    def fill(self, c:int, size:int=...) -> PySide6.QtCore.QByteArray: ...
    def first(self, n:int) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromBase64(base64:PySide6.QtCore.QByteArray, options:PySide6.QtCore.QByteArray.Base64Options=...) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromBase64Encoding(base64:PySide6.QtCore.QByteArray, options:PySide6.QtCore.QByteArray.Base64Options=...) -> PySide6.QtCore.QByteArray.FromBase64Result: ...
    @staticmethod
    def fromHex(hexEncoded:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromPercentEncoding(pctEncoded:PySide6.QtCore.QByteArray, percent:int=...) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromRawData(data:bytes, size:int) -> PySide6.QtCore.QByteArray: ...
    def front(self) -> int: ...
    @typing.overload
    def indexOf(self, bv:PySide6.QtCore.QByteArray, from_:int=...) -> int: ...
    @typing.overload
    def indexOf(self, c:int, from_:int=...) -> int: ...
    @typing.overload
    def insert(self, i:int, c:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i:int, count:int, c:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i:int, data:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i:int, s:bytes) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i:int, s:bytes, len:int) -> PySide6.QtCore.QByteArray: ...
    def isEmpty(self) -> bool: ...
    def isLower(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSharedWith(self, other:PySide6.QtCore.QByteArray) -> bool: ...
    def isUpper(self) -> bool: ...
    def last(self, n:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def lastIndexOf(self, bv:PySide6.QtCore.QByteArray, from_:int=...) -> int: ...
    @typing.overload
    def lastIndexOf(self, c:int, from_:int=...) -> int: ...
    def left(self, len:int) -> PySide6.QtCore.QByteArray: ...
    def leftJustified(self, width:int, fill:int=..., truncate:bool=...) -> PySide6.QtCore.QByteArray: ...
    def length(self) -> int: ...
    def mid(self, index:int, len:int=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1:float, f:int=..., prec:int=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1:int, base:int=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1:int, base:int=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, a:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, c:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, count:int, c:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, s:bytes, len:int) -> PySide6.QtCore.QByteArray: ...
    def push_back(self, a:PySide6.QtCore.QByteArray) -> None: ...
    def push_front(self, a:PySide6.QtCore.QByteArray) -> None: ...
    def remove(self, index:int, len:int) -> PySide6.QtCore.QByteArray: ...
    def repeated(self, times:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before:PySide6.QtCore.QByteArray, after:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before:bytes, bsize:int, after:bytes, asize:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before:int, after:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before:int, after:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, index:int, len:int, s:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, index:int, len:int, s:bytes, alen:int) -> PySide6.QtCore.QByteArray: ...
    def reserve(self, size:int) -> None: ...
    def resize(self, size:int) -> None: ...
    def right(self, len:int) -> PySide6.QtCore.QByteArray: ...
    def rightJustified(self, width:int, fill:int=..., truncate:bool=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1:float, f:int=..., prec:int=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1:int, base:int=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1:int, base:int=...) -> PySide6.QtCore.QByteArray: ...
    def setRawData(self, a:bytes, n:int) -> PySide6.QtCore.QByteArray: ...
    def shrink_to_fit(self) -> None: ...
    def simplified(self) -> PySide6.QtCore.QByteArray: ...
    def size(self) -> int: ...
    @typing.overload
    def sliced(self, pos:int) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def sliced(self, pos:int, n:int) -> PySide6.QtCore.QByteArray: ...
    def split(self, sep:int) -> typing.List: ...
    def squeeze(self) -> None: ...
    @typing.overload
    def startsWith(self, bv:PySide6.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def startsWith(self, c:int) -> bool: ...
    def swap(self, other:PySide6.QtCore.QByteArray) -> None: ...
    def toBase64(self, options:PySide6.QtCore.QByteArray.Base64Options=...) -> PySide6.QtCore.QByteArray: ...
    def toDouble(self) -> typing.Tuple: ...
    def toFloat(self) -> typing.Tuple: ...
    def toHex(self, separator:int=...) -> PySide6.QtCore.QByteArray: ...
    def toInt(self, base:int=...) -> typing.Tuple: ...
    def toLong(self, base:int=...) -> typing.Tuple: ...
    def toLongLong(self, base:int=...) -> typing.Tuple: ...
    def toLower(self) -> PySide6.QtCore.QByteArray: ...
    def toPercentEncoding(self, exclude:PySide6.QtCore.QByteArray=..., include:PySide6.QtCore.QByteArray=..., percent:int=...) -> PySide6.QtCore.QByteArray: ...
    def toShort(self, base:int=...) -> typing.Tuple: ...
    def toUInt(self, base:int=...) -> typing.Tuple: ...
    def toULong(self, base:int=...) -> typing.Tuple: ...
    def toULongLong(self, base:int=...) -> typing.Tuple: ...
    def toUShort(self, base:int=...) -> typing.Tuple: ...
    def toUpper(self) -> PySide6.QtCore.QByteArray: ...
    def trimmed(self) -> PySide6.QtCore.QByteArray: ...
    def truncate(self, pos:int) -> None: ...


class QByteArrayMatcher(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QByteArrayMatcher) -> None: ...
    @typing.overload
    def __init__(self, pattern:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, pattern:bytes, length:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def indexIn(self, ba:PySide6.QtCore.QByteArray, from_:int=...) -> int: ...
    @typing.overload
    def indexIn(self, str:bytes, len:int, from_:int=...) -> int: ...
    def pattern(self) -> PySide6.QtCore.QByteArray: ...
    def setPattern(self, pattern:PySide6.QtCore.QByteArray) -> None: ...


class QCalendar(Shiboken.Object):

    class System(object):
        User                     : QCalendar.System = ... # -0x1
        Gregorian                : QCalendar.System = ... # 0x0
        Julian                   : QCalendar.System = ... # 0x8
        Milankovic               : QCalendar.System = ... # 0x9
        Jalali                   : QCalendar.System = ... # 0xa
        IslamicCivil             : QCalendar.System = ... # 0xb
        Last                     : QCalendar.System = ... # 0xb

    class YearMonthDay(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, YearMonthDay:PySide6.QtCore.QCalendar.YearMonthDay) -> None: ...
        @typing.overload
        def __init__(self, y:int, m:int=..., d:int=...) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isValid(self) -> bool: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name:str) -> None: ...
    @typing.overload
    def __init__(self, system:PySide6.QtCore.QCalendar.System) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def availableCalendars() -> typing.List: ...
    @typing.overload
    def dateFromParts(self, parts:PySide6.QtCore.QCalendar.YearMonthDay) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def dateFromParts(self, year:int, month:int, day:int) -> PySide6.QtCore.QDate: ...
    def dateTimeToString(self, format:str, datetime:PySide6.QtCore.QDateTime, dateOnly:PySide6.QtCore.QDate, timeOnly:PySide6.QtCore.QTime, locale:PySide6.QtCore.QLocale) -> str: ...
    def dayOfWeek(self, date:PySide6.QtCore.QDate) -> int: ...
    def daysInMonth(self, month:int, year:typing.Optional[int]=...) -> int: ...
    def daysInYear(self, year:int) -> int: ...
    def hasYearZero(self) -> bool: ...
    def isDateValid(self, year:int, month:int, day:int) -> bool: ...
    def isGregorian(self) -> bool: ...
    def isLeapYear(self, year:int) -> bool: ...
    def isLunar(self) -> bool: ...
    def isLuniSolar(self) -> bool: ...
    def isProleptic(self) -> bool: ...
    def isSolar(self) -> bool: ...
    def isValid(self) -> bool: ...
    def maximumDaysInMonth(self) -> int: ...
    def maximumMonthsInYear(self) -> int: ...
    def minimumDaysInMonth(self) -> int: ...
    def monthName(self, locale:PySide6.QtCore.QLocale, month:int, year:typing.Optional[int]=..., format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def monthsInYear(self, year:int) -> int: ...
    def name(self) -> str: ...
    def partsFromDate(self, date:PySide6.QtCore.QDate) -> PySide6.QtCore.QCalendar.YearMonthDay: ...
    def standaloneMonthName(self, locale:PySide6.QtCore.QLocale, month:int, year:typing.Optional[int]=..., format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def standaloneWeekDayName(self, locale:PySide6.QtCore.QLocale, day:int, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def weekDayName(self, locale:PySide6.QtCore.QLocale, day:int, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...


class QCborArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QCborArray) -> None: ...

    def __add__(self, v:PySide6.QtCore.QCborValue) -> PySide6.QtCore.QCborArray: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, v:PySide6.QtCore.QCborValue) -> PySide6.QtCore.QCborArray: ...
    def __lshift__(self, v:PySide6.QtCore.QCborValue) -> PySide6.QtCore.QCborArray: ...
    def append(self, value:PySide6.QtCore.QCborValue) -> None: ...
    def at(self, i:int) -> PySide6.QtCore.QCborValue: ...
    def clear(self) -> None: ...
    def compare(self, other:PySide6.QtCore.QCborArray) -> int: ...
    def contains(self, value:PySide6.QtCore.QCborValue) -> bool: ...
    def empty(self) -> bool: ...
    def first(self) -> PySide6.QtCore.QCborValue: ...
    @staticmethod
    def fromJsonArray(array:PySide6.QtCore.QJsonArray) -> PySide6.QtCore.QCborArray: ...
    @staticmethod
    def fromStringList(list:typing.Sequence) -> PySide6.QtCore.QCborArray: ...
    @staticmethod
    def fromVariantList(list:typing.Sequence) -> PySide6.QtCore.QCborArray: ...
    def insert(self, i:int, value:PySide6.QtCore.QCborValue) -> None: ...
    def isEmpty(self) -> bool: ...
    def last(self) -> PySide6.QtCore.QCborValue: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, value:PySide6.QtCore.QCborValue) -> None: ...
    def push_back(self, t:PySide6.QtCore.QCborValue) -> None: ...
    def push_front(self, t:PySide6.QtCore.QCborValue) -> None: ...
    def removeAt(self, i:int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def size(self) -> int: ...
    def swap(self, other:PySide6.QtCore.QCborArray) -> None: ...
    def takeAt(self, i:int) -> PySide6.QtCore.QCborValue: ...
    def takeFirst(self) -> PySide6.QtCore.QCborValue: ...
    def takeLast(self) -> PySide6.QtCore.QCborValue: ...
    def toCborValue(self) -> PySide6.QtCore.QCborValue: ...
    def toJsonArray(self) -> PySide6.QtCore.QJsonArray: ...
    def toVariantList(self) -> typing.List: ...


class QCborError(Shiboken.Object):
    NoError                  : QCborError = ... # 0x0
    UnknownError             : QCborError = ... # 0x1
    AdvancePastEnd           : QCborError = ... # 0x3
    InputOutputError         : QCborError = ... # 0x4
    GarbageAtEnd             : QCborError = ... # 0x100
    EndOfFile                : QCborError = ... # 0x101
    UnexpectedBreak          : QCborError = ... # 0x102
    UnknownType              : QCborError = ... # 0x103
    IllegalType              : QCborError = ... # 0x104
    IllegalNumber            : QCborError = ... # 0x105
    IllegalSimpleType        : QCborError = ... # 0x106
    InvalidUtf8String        : QCborError = ... # 0x204
    DataTooLarge             : QCborError = ... # 0x400
    NestingTooDeep           : QCborError = ... # 0x401
    UnsupportedType          : QCborError = ... # 0x402

    class Code(object):
        NoError                  : QCborError.Code = ... # 0x0
        UnknownError             : QCborError.Code = ... # 0x1
        AdvancePastEnd           : QCborError.Code = ... # 0x3
        InputOutputError         : QCborError.Code = ... # 0x4
        GarbageAtEnd             : QCborError.Code = ... # 0x100
        EndOfFile                : QCborError.Code = ... # 0x101
        UnexpectedBreak          : QCborError.Code = ... # 0x102
        UnknownType              : QCborError.Code = ... # 0x103
        IllegalType              : QCborError.Code = ... # 0x104
        IllegalNumber            : QCborError.Code = ... # 0x105
        IllegalSimpleType        : QCborError.Code = ... # 0x106
        InvalidUtf8String        : QCborError.Code = ... # 0x204
        DataTooLarge             : QCborError.Code = ... # 0x400
        NestingTooDeep           : QCborError.Code = ... # 0x401
        UnsupportedType          : QCborError.Code = ... # 0x402

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborError:PySide6.QtCore.QCborError) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def toString(self) -> str: ...


class QCborKnownTags(object):
    DateTimeString           : QCborKnownTags = ... # 0x0
    UnixTime_t               : QCborKnownTags = ... # 0x1
    PositiveBignum           : QCborKnownTags = ... # 0x2
    NegativeBignum           : QCborKnownTags = ... # 0x3
    Decimal                  : QCborKnownTags = ... # 0x4
    Bigfloat                 : QCborKnownTags = ... # 0x5
    COSE_Encrypt0            : QCborKnownTags = ... # 0x10
    COSE_Mac0                : QCborKnownTags = ... # 0x11
    COSE_Sign1               : QCborKnownTags = ... # 0x12
    ExpectedBase64url        : QCborKnownTags = ... # 0x15
    ExpectedBase64           : QCborKnownTags = ... # 0x16
    ExpectedBase16           : QCborKnownTags = ... # 0x17
    EncodedCbor              : QCborKnownTags = ... # 0x18
    Url                      : QCborKnownTags = ... # 0x20
    Base64url                : QCborKnownTags = ... # 0x21
    Base64                   : QCborKnownTags = ... # 0x22
    RegularExpression        : QCborKnownTags = ... # 0x23
    MimeMessage              : QCborKnownTags = ... # 0x24
    Uuid                     : QCborKnownTags = ... # 0x25
    COSE_Encrypt             : QCborKnownTags = ... # 0x60
    COSE_Mac                 : QCborKnownTags = ... # 0x61
    COSE_Sign                : QCborKnownTags = ... # 0x62
    Signature                : QCborKnownTags = ... # 0xd9f7


class QCborMap(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QCborMap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    def compare(self, other:PySide6.QtCore.QCborMap) -> int: ...
    @typing.overload
    def contains(self, key:PySide6.QtCore.QCborValue) -> bool: ...
    @typing.overload
    def contains(self, key:str) -> bool: ...
    @typing.overload
    def contains(self, key:int) -> bool: ...
    def empty(self) -> bool: ...
    @staticmethod
    def fromJsonObject(o:typing.Dict) -> PySide6.QtCore.QCborMap: ...
    @staticmethod
    def fromVariantHash(hash:typing.Dict) -> PySide6.QtCore.QCborMap: ...
    @staticmethod
    def fromVariantMap(map:typing.Dict) -> PySide6.QtCore.QCborMap: ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> typing.List: ...
    @typing.overload
    def remove(self, key:PySide6.QtCore.QCborValue) -> None: ...
    @typing.overload
    def remove(self, key:str) -> None: ...
    @typing.overload
    def remove(self, key:int) -> None: ...
    def size(self) -> int: ...
    def swap(self, other:PySide6.QtCore.QCborMap) -> None: ...
    @typing.overload
    def take(self, key:PySide6.QtCore.QCborValue) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def take(self, key:str) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def take(self, key:int) -> PySide6.QtCore.QCborValue: ...
    def toCborValue(self) -> PySide6.QtCore.QCborValue: ...
    def toJsonObject(self) -> typing.Dict: ...
    def toVariantHash(self) -> typing.Dict: ...
    def toVariantMap(self) -> typing.Dict: ...
    @typing.overload
    def value(self, key:PySide6.QtCore.QCborValue) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def value(self, key:str) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def value(self, key:int) -> PySide6.QtCore.QCborValue: ...


class QCborParserError(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborParserError:PySide6.QtCore.QCborParserError) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def errorString(self) -> str: ...


class QCborSimpleType(object):
    False_                   : QCborSimpleType = ... # 0x14
    True_                    : QCborSimpleType = ... # 0x15
    Null                     : QCborSimpleType = ... # 0x16
    Undefined                : QCborSimpleType = ... # 0x17


class QCborStreamReader(Shiboken.Object):
    Error                    : QCborStreamReader = ... # -0x1
    EndOfString              : QCborStreamReader = ... # 0x0
    UnsignedInteger          : QCborStreamReader = ... # 0x0
    Ok                       : QCborStreamReader = ... # 0x1
    NegativeInteger          : QCborStreamReader = ... # 0x20
    ByteArray                : QCborStreamReader = ... # 0x40
    ByteString               : QCborStreamReader = ... # 0x40
    String                   : QCborStreamReader = ... # 0x60
    TextString               : QCborStreamReader = ... # 0x60
    Array                    : QCborStreamReader = ... # 0x80
    Map                      : QCborStreamReader = ... # 0xa0
    Tag                      : QCborStreamReader = ... # 0xc0
    SimpleType               : QCborStreamReader = ... # 0xe0
    Float16                  : QCborStreamReader = ... # 0xf9
    HalfFloat                : QCborStreamReader = ... # 0xf9
    Float                    : QCborStreamReader = ... # 0xfa
    Double                   : QCborStreamReader = ... # 0xfb
    Invalid                  : QCborStreamReader = ... # 0xff

    class StringResultCode(object):
        Error                    : QCborStreamReader.StringResultCode = ... # -0x1
        EndOfString              : QCborStreamReader.StringResultCode = ... # 0x0
        Ok                       : QCborStreamReader.StringResultCode = ... # 0x1

    class Type(object):
        UnsignedInteger          : QCborStreamReader.Type = ... # 0x0
        NegativeInteger          : QCborStreamReader.Type = ... # 0x20
        ByteArray                : QCborStreamReader.Type = ... # 0x40
        ByteString               : QCborStreamReader.Type = ... # 0x40
        String                   : QCborStreamReader.Type = ... # 0x60
        TextString               : QCborStreamReader.Type = ... # 0x60
        Array                    : QCborStreamReader.Type = ... # 0x80
        Map                      : QCborStreamReader.Type = ... # 0xa0
        Tag                      : QCborStreamReader.Type = ... # 0xc0
        SimpleType               : QCborStreamReader.Type = ... # 0xe0
        Float16                  : QCborStreamReader.Type = ... # 0xf9
        HalfFloat                : QCborStreamReader.Type = ... # 0xf9
        Float                    : QCborStreamReader.Type = ... # 0xfa
        Double                   : QCborStreamReader.Type = ... # 0xfb
        Invalid                  : QCborStreamReader.Type = ... # 0xff

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, data:bytes, len:int) -> None: ...
    @typing.overload
    def __init__(self, data:bytearray, len:int) -> None: ...
    @typing.overload
    def __init__(self, device:PySide6.QtCore.QIODevice) -> None: ...

    @typing.overload
    def addData(self, data:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def addData(self, data:bytes, len:int) -> None: ...
    @typing.overload
    def addData(self, data:bytearray, len:int) -> None: ...
    def clear(self) -> None: ...
    def containerDepth(self) -> int: ...
    def currentOffset(self) -> int: ...
    def currentStringChunkSize(self) -> int: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def enterContainer(self) -> bool: ...
    def hasNext(self) -> bool: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isByteArray(self) -> bool: ...
    def isContainer(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isFalse(self) -> bool: ...
    def isFloat(self) -> bool: ...
    def isFloat16(self) -> bool: ...
    def isInteger(self) -> bool: ...
    def isInvalid(self) -> bool: ...
    def isLengthKnown(self) -> bool: ...
    def isMap(self) -> bool: ...
    def isNegativeInteger(self) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def isSimpleType(self) -> bool: ...
    @typing.overload
    def isSimpleType(self, st:PySide6.QtCore.QCborSimpleType) -> bool: ...
    def isString(self) -> bool: ...
    def isTag(self) -> bool: ...
    def isTrue(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isUnsignedInteger(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastError(self) -> PySide6.QtCore.QCborError: ...
    def leaveContainer(self) -> bool: ...
    def length(self) -> int: ...
    def next(self, maxRecursion:int=...) -> bool: ...
    def parentContainerType(self) -> PySide6.QtCore.QCborStreamReader.Type: ...
    def readByteArray(self) -> PySide6.QtCore.QCborStringResultByteArray: ...
    def readString(self) -> PySide6.QtCore.QCborStringResultString: ...
    def reparse(self) -> None: ...
    def reset(self) -> None: ...
    def setDevice(self, device:PySide6.QtCore.QIODevice) -> None: ...
    def toBool(self) -> bool: ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toInteger(self) -> int: ...
    def toSimpleType(self) -> PySide6.QtCore.QCborSimpleType: ...
    def toUnsignedInteger(self) -> int: ...
    def type(self) -> PySide6.QtCore.QCborStreamReader.Type: ...


class QCborStreamWriter(Shiboken.Object):

    @typing.overload
    def __init__(self, data:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, device:PySide6.QtCore.QIODevice) -> None: ...

    @typing.overload
    def append(self, b:bool) -> None: ...
    @typing.overload
    def append(self, ba:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def append(self, d:float) -> None: ...
    @typing.overload
    def append(self, f:float) -> None: ...
    @typing.overload
    def append(self, i:int) -> None: ...
    @typing.overload
    def append(self, i:int) -> None: ...
    @typing.overload
    def append(self, st:PySide6.QtCore.QCborSimpleType) -> None: ...
    @typing.overload
    def append(self, str:str) -> None: ...
    @typing.overload
    def append(self, str:bytes, size:int=...) -> None: ...
    @typing.overload
    def append(self, tag:PySide6.QtCore.QCborKnownTags) -> None: ...
    @typing.overload
    def append(self, u:int) -> None: ...
    @typing.overload
    def append(self, u:int) -> None: ...
    def appendByteString(self, data:bytes, len:int) -> None: ...
    def appendNull(self) -> None: ...
    def appendTextString(self, utf8:bytes, len:int) -> None: ...
    def appendUndefined(self) -> None: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def endArray(self) -> bool: ...
    def endMap(self) -> bool: ...
    def setDevice(self, device:PySide6.QtCore.QIODevice) -> None: ...
    @typing.overload
    def startArray(self) -> None: ...
    @typing.overload
    def startArray(self, count:int) -> None: ...
    @typing.overload
    def startMap(self) -> None: ...
    @typing.overload
    def startMap(self, count:int) -> None: ...


class QCborStringResultByteArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborStringResultByteArray:PySide6.QtCore.QCborStringResultByteArray) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QCborStringResultString(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QCborStringResultString:PySide6.QtCore.QCborStringResultString) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QCborValue(Shiboken.Object):
    Invalid                  : QCborValue = ... # -0x1
    Compact                  : QCborValue = ... # 0x0
    Integer                  : QCborValue = ... # 0x0
    NoTransformation         : QCborValue = ... # 0x0
    LineWrapped              : QCborValue = ... # 0x1
    SortKeysInMaps           : QCborValue = ... # 0x1
    ExtendedFormat           : QCborValue = ... # 0x2
    UseFloat                 : QCborValue = ... # 0x2
    UseFloat16               : QCborValue = ... # 0x6
    UseIntegers              : QCborValue = ... # 0x8
    ByteArray                : QCborValue = ... # 0x40
    String                   : QCborValue = ... # 0x60
    Array                    : QCborValue = ... # 0x80
    Map                      : QCborValue = ... # 0xa0
    Tag                      : QCborValue = ... # 0xc0
    SimpleType               : QCborValue = ... # 0x100
    False_                   : QCborValue = ... # 0x114
    True_                    : QCborValue = ... # 0x115
    Null                     : QCborValue = ... # 0x116
    Undefined                : QCborValue = ... # 0x117
    Double                   : QCborValue = ... # 0x202
    DateTime                 : QCborValue = ... # 0x10000
    Url                      : QCborValue = ... # 0x10020
    RegularExpression        : QCborValue = ... # 0x10023
    Uuid                     : QCborValue = ... # 0x10025

    class DiagnosticNotationOption(object):
        Compact                  : QCborValue.DiagnosticNotationOption = ... # 0x0
        LineWrapped              : QCborValue.DiagnosticNotationOption = ... # 0x1
        ExtendedFormat           : QCborValue.DiagnosticNotationOption = ... # 0x2

    class DiagnosticNotationOptions(object): ...

    class EncodingOption(object):
        NoTransformation         : QCborValue.EncodingOption = ... # 0x0
        SortKeysInMaps           : QCborValue.EncodingOption = ... # 0x1
        UseFloat                 : QCborValue.EncodingOption = ... # 0x2
        UseFloat16               : QCborValue.EncodingOption = ... # 0x6
        UseIntegers              : QCborValue.EncodingOption = ... # 0x8

    class EncodingOptions(object): ...

    class Type(object):
        Invalid                  : QCborValue.Type = ... # -0x1
        Integer                  : QCborValue.Type = ... # 0x0
        ByteArray                : QCborValue.Type = ... # 0x40
        String                   : QCborValue.Type = ... # 0x60
        Array                    : QCborValue.Type = ... # 0x80
        Map                      : QCborValue.Type = ... # 0xa0
        Tag                      : QCborValue.Type = ... # 0xc0
        SimpleType               : QCborValue.Type = ... # 0x100
        False_                   : QCborValue.Type = ... # 0x114
        True_                    : QCborValue.Type = ... # 0x115
        Null                     : QCborValue.Type = ... # 0x116
        Undefined                : QCborValue.Type = ... # 0x117
        Double                   : QCborValue.Type = ... # 0x202
        DateTime                 : QCborValue.Type = ... # 0x10000
        Url                      : QCborValue.Type = ... # 0x10020
        RegularExpression        : QCborValue.Type = ... # 0x10023
        Uuid                     : QCborValue.Type = ... # 0x10025

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a:PySide6.QtCore.QCborArray) -> None: ...
    @typing.overload
    def __init__(self, b_:bool) -> None: ...
    @typing.overload
    def __init__(self, ba:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, dt:PySide6.QtCore.QDateTime) -> None: ...
    @typing.overload
    def __init__(self, i:int) -> None: ...
    @typing.overload
    def __init__(self, i:int) -> None: ...
    @typing.overload
    def __init__(self, m:PySide6.QtCore.QCborMap) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QCborValue) -> None: ...
    @typing.overload
    def __init__(self, rx:PySide6.QtCore.QRegularExpression) -> None: ...
    @typing.overload
    def __init__(self, s:str) -> None: ...
    @typing.overload
    def __init__(self, s:bytes) -> None: ...
    @typing.overload
    def __init__(self, st:PySide6.QtCore.QCborSimpleType) -> None: ...
    @typing.overload
    def __init__(self, t_:PySide6.QtCore.QCborKnownTags, tv:PySide6.QtCore.QCborValue=...) -> None: ...
    @typing.overload
    def __init__(self, t_:PySide6.QtCore.QCborValue.Type) -> None: ...
    @typing.overload
    def __init__(self, u:int) -> None: ...
    @typing.overload
    def __init__(self, url:PySide6.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, uuid:PySide6.QtCore.QUuid) -> None: ...
    @typing.overload
    def __init__(self, v:float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def compare(self, other:PySide6.QtCore.QCborValue) -> int: ...
    @typing.overload
    @staticmethod
    def fromCbor(ba:PySide6.QtCore.QByteArray, error:typing.Optional[PySide6.QtCore.QCborParserError]=...) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(data:bytes, len:int, error:typing.Optional[PySide6.QtCore.QCborParserError]=...) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(data:bytearray, len:int, error:typing.Optional[PySide6.QtCore.QCborParserError]=...) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(reader:PySide6.QtCore.QCborStreamReader) -> PySide6.QtCore.QCborValue: ...
    @staticmethod
    def fromJsonValue(v:PySide6.QtCore.QJsonValue) -> PySide6.QtCore.QCborValue: ...
    @staticmethod
    def fromVariant(variant:typing.Any) -> PySide6.QtCore.QCborValue: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isByteArray(self) -> bool: ...
    def isContainer(self) -> bool: ...
    def isDateTime(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isFalse(self) -> bool: ...
    def isInteger(self) -> bool: ...
    def isInvalid(self) -> bool: ...
    def isMap(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isRegularExpression(self) -> bool: ...
    @typing.overload
    def isSimpleType(self) -> bool: ...
    @typing.overload
    def isSimpleType(self, st:PySide6.QtCore.QCborSimpleType) -> bool: ...
    def isString(self) -> bool: ...
    def isTag(self) -> bool: ...
    def isTrue(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isUrl(self) -> bool: ...
    def isUuid(self) -> bool: ...
    def swap(self, other:PySide6.QtCore.QCborValue) -> None: ...
    def taggedValue(self, defaultValue:PySide6.QtCore.QCborValue=...) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def toArray(self) -> PySide6.QtCore.QCborArray: ...
    @typing.overload
    def toArray(self, defaultValue:PySide6.QtCore.QCborArray) -> PySide6.QtCore.QCborArray: ...
    def toBool(self, defaultValue:bool=...) -> bool: ...
    def toByteArray(self, defaultValue:PySide6.QtCore.QByteArray=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def toCbor(self, opt:PySide6.QtCore.QCborValue.EncodingOptions=...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def toCbor(self, writer:PySide6.QtCore.QCborStreamWriter, opt:PySide6.QtCore.QCborValue.EncodingOptions=...) -> None: ...
    def toDateTime(self, defaultValue:PySide6.QtCore.QDateTime=...) -> PySide6.QtCore.QDateTime: ...
    def toDiagnosticNotation(self, opts:PySide6.QtCore.QCborValue.DiagnosticNotationOptions=...) -> str: ...
    def toDouble(self, defaultValue:float=...) -> float: ...
    def toInteger(self, defaultValue:int=...) -> int: ...
    def toJsonValue(self) -> PySide6.QtCore.QJsonValue: ...
    @typing.overload
    def toMap(self) -> PySide6.QtCore.QCborMap: ...
    @typing.overload
    def toMap(self, defaultValue:PySide6.QtCore.QCborMap) -> PySide6.QtCore.QCborMap: ...
    def toRegularExpression(self, defaultValue:PySide6.QtCore.QRegularExpression=...) -> PySide6.QtCore.QRegularExpression: ...
    def toSimpleType(self, defaultValue:PySide6.QtCore.QCborSimpleType=...) -> PySide6.QtCore.QCborSimpleType: ...
    def toString(self, defaultValue:str=...) -> str: ...
    def toUrl(self, defaultValue:PySide6.QtCore.QUrl=...) -> PySide6.QtCore.QUrl: ...
    def toUuid(self, defaultValue:PySide6.QtCore.QUuid=...) -> PySide6.QtCore.QUuid: ...
    def toVariant(self) -> typing.Any: ...
    def type(self) -> PySide6.QtCore.QCborValue.Type: ...


class QChildEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QChildEvent) -> None: ...
    @typing.overload
    def __init__(self, type:PySide6.QtCore.QEvent.Type, child:PySide6.QtCore.QObject) -> None: ...

    def added(self) -> bool: ...
    def child(self) -> PySide6.QtCore.QObject: ...
    def clone(self) -> PySide6.QtCore.QChildEvent: ...
    def polished(self) -> bool: ...
    def removed(self) -> bool: ...


class QCollator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QCollator) -> None: ...
    @typing.overload
    def __init__(self, locale:PySide6.QtCore.QLocale) -> None: ...

    def __call__(self, s1:str, s2:str) -> bool: ...
    def caseSensitivity(self) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    @typing.overload
    def compare(self, s1:bytes, len1:int, s2:bytes, len2:int) -> int: ...
    @typing.overload
    def compare(self, s1:str, s2:str) -> int: ...
    def ignorePunctuation(self) -> bool: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    def numericMode(self) -> bool: ...
    def setCaseSensitivity(self, cs:PySide6.QtCore.Qt.CaseSensitivity) -> None: ...
    def setIgnorePunctuation(self, on:bool) -> None: ...
    def setLocale(self, locale:PySide6.QtCore.QLocale) -> None: ...
    def setNumericMode(self, on:bool) -> None: ...
    def sortKey(self, string:str) -> PySide6.QtCore.QCollatorSortKey: ...
    def swap(self, other:PySide6.QtCore.QCollator) -> None: ...


class QCollatorSortKey(Shiboken.Object):

    def __init__(self, other:PySide6.QtCore.QCollatorSortKey) -> None: ...

    def compare(self, key:PySide6.QtCore.QCollatorSortKey) -> int: ...
    def swap(self, other:PySide6.QtCore.QCollatorSortKey) -> None: ...


class QCommandLineOption(Shiboken.Object):
    HiddenFromHelp           : QCommandLineOption = ... # 0x1
    ShortOptionStyle         : QCommandLineOption = ... # 0x2

    class Flag(object):
        HiddenFromHelp           : QCommandLineOption.Flag = ... # 0x1
        ShortOptionStyle         : QCommandLineOption.Flag = ... # 0x2

    class Flags(object): ...

    @typing.overload
    def __init__(self, name:str) -> None: ...
    @typing.overload
    def __init__(self, name:str, description:str, valueName:str=..., defaultValue:str=...) -> None: ...
    @typing.overload
    def __init__(self, names:typing.Sequence) -> None: ...
    @typing.overload
    def __init__(self, names:typing.Sequence, description:str, valueName:str=..., defaultValue:str=...) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QCommandLineOption) -> None: ...

    def defaultValues(self) -> typing.List: ...
    def description(self) -> str: ...
    def flags(self) -> PySide6.QtCore.QCommandLineOption.Flags: ...
    def names(self) -> typing.List: ...
    def setDefaultValue(self, defaultValue:str) -> None: ...
    def setDefaultValues(self, defaultValues:typing.Sequence) -> None: ...
    def setDescription(self, description:str) -> None: ...
    def setFlags(self, aflags:PySide6.QtCore.QCommandLineOption.Flags) -> None: ...
    def setValueName(self, name:str) -> None: ...
    def swap(self, other:PySide6.QtCore.QCommandLineOption) -> None: ...
    def valueName(self) -> str: ...


class QCommandLineParser(Shiboken.Object):
    ParseAsCompactedShortOptions: QCommandLineParser = ... # 0x0
    ParseAsOptions           : QCommandLineParser = ... # 0x0
    ParseAsLongOptions       : QCommandLineParser = ... # 0x1
    ParseAsPositionalArguments: QCommandLineParser = ... # 0x1

    class OptionsAfterPositionalArgumentsMode(object):
        ParseAsOptions           : QCommandLineParser.OptionsAfterPositionalArgumentsMode = ... # 0x0
        ParseAsPositionalArguments: QCommandLineParser.OptionsAfterPositionalArgumentsMode = ... # 0x1

    class SingleDashWordOptionMode(object):
        ParseAsCompactedShortOptions: QCommandLineParser.SingleDashWordOptionMode = ... # 0x0
        ParseAsLongOptions       : QCommandLineParser.SingleDashWordOptionMode = ... # 0x1

    def __init__(self) -> None: ...

    def addHelpOption(self) -> PySide6.QtCore.QCommandLineOption: ...
    def addOption(self, commandLineOption:PySide6.QtCore.QCommandLineOption) -> bool: ...
    def addOptions(self, options:typing.Sequence) -> bool: ...
    def addPositionalArgument(self, name:str, description:str, syntax:str=...) -> None: ...
    def addVersionOption(self) -> PySide6.QtCore.QCommandLineOption: ...
    def applicationDescription(self) -> str: ...
    def clearPositionalArguments(self) -> None: ...
    def errorText(self) -> str: ...
    def helpText(self) -> str: ...
    @typing.overload
    def isSet(self, name:str) -> bool: ...
    @typing.overload
    def isSet(self, option:PySide6.QtCore.QCommandLineOption) -> bool: ...
    def optionNames(self) -> typing.List: ...
    def parse(self, arguments:typing.Sequence) -> bool: ...
    def positionalArguments(self) -> typing.List: ...
    @typing.overload
    def process(self, app:PySide6.QtCore.QCoreApplication) -> None: ...
    @typing.overload
    def process(self, arguments:typing.Sequence) -> None: ...
    def setApplicationDescription(self, description:str) -> None: ...
    def setOptionsAfterPositionalArgumentsMode(self, mode:PySide6.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode) -> None: ...
    def setSingleDashWordOptionMode(self, parsingMode:PySide6.QtCore.QCommandLineParser.SingleDashWordOptionMode) -> None: ...
    def showHelp(self, exitCode:int=...) -> None: ...
    def showVersion(self) -> None: ...
    def unknownOptionNames(self) -> typing.List: ...
    @typing.overload
    def value(self, name:str) -> str: ...
    @typing.overload
    def value(self, option:PySide6.QtCore.QCommandLineOption) -> str: ...
    @typing.overload
    def values(self, name:str) -> typing.List: ...
    @typing.overload
    def values(self, option:PySide6.QtCore.QCommandLineOption) -> typing.List: ...


class QConcatenateTablesProxyModel(PySide6.QtCore.QAbstractItemModel):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def addSourceModel(self, sourceModel:PySide6.QtCore.QAbstractItemModel) -> None: ...
    def canDropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def data(self, index:PySide6.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def dropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def flags(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.Qt.ItemFlags: ...
    def headerData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def index(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    def itemData(self, proxyIndex:PySide6.QtCore.QModelIndex) -> typing.Dict: ...
    def mapFromSource(self, sourceIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def mimeData(self, indexes:typing.List) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def removeSourceModel(self, sourceModel:PySide6.QtCore.QAbstractItemModel) -> None: ...
    def rowCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def setData(self, index:PySide6.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setItemData(self, index:PySide6.QtCore.QModelIndex, roles:typing.Dict) -> bool: ...
    def sourceModels(self) -> typing.List: ...
    def span(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QSize: ...


class QCoreApplication(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Sequence) -> None: ...

    @staticmethod
    def addLibraryPath(arg__1:str) -> None: ...
    @staticmethod
    def applicationDirPath() -> str: ...
    @staticmethod
    def applicationFilePath() -> str: ...
    @staticmethod
    def applicationName() -> str: ...
    @staticmethod
    def applicationPid() -> int: ...
    @staticmethod
    def applicationVersion() -> str: ...
    @staticmethod
    def arguments() -> typing.List: ...
    @staticmethod
    def closingDown() -> bool: ...
    def event(self, arg__1:PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def eventDispatcher() -> PySide6.QtCore.QAbstractEventDispatcher: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def exit(retcode:int=...) -> None: ...
    def installNativeEventFilter(self, filterObj:PySide6.QtCore.QAbstractNativeEventFilter) -> None: ...
    @staticmethod
    def installTranslator(messageFile:PySide6.QtCore.QTranslator) -> bool: ...
    @staticmethod
    def instance() -> PySide6.QtCore.QCoreApplication: ...
    @staticmethod
    def isQuitLockEnabled() -> bool: ...
    @staticmethod
    def isSetuidAllowed() -> bool: ...
    @staticmethod
    def libraryPaths() -> typing.List: ...
    def notify(self, arg__1:PySide6.QtCore.QObject, arg__2:PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def organizationDomain() -> str: ...
    @staticmethod
    def organizationName() -> str: ...
    @staticmethod
    def postEvent(receiver:PySide6.QtCore.QObject, event:PySide6.QtCore.QEvent, priority:int=...) -> None: ...
    @typing.overload
    @staticmethod
    def processEvents(flags:PySide6.QtCore.QEventLoop.ProcessEventsFlags, maxtime:int) -> None: ...
    @typing.overload
    @staticmethod
    def processEvents(flags:PySide6.QtCore.QEventLoop.ProcessEventsFlags=...) -> None: ...
    @staticmethod
    def quit() -> None: ...
    @staticmethod
    def removeLibraryPath(arg__1:str) -> None: ...
    def removeNativeEventFilter(self, filterObj:PySide6.QtCore.QAbstractNativeEventFilter) -> None: ...
    @staticmethod
    def removePostedEvents(receiver:PySide6.QtCore.QObject, eventType:int=...) -> None: ...
    @staticmethod
    def removeTranslator(messageFile:PySide6.QtCore.QTranslator) -> bool: ...
    @staticmethod
    def sendEvent(receiver:PySide6.QtCore.QObject, event:PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def sendPostedEvents(receiver:typing.Optional[PySide6.QtCore.QObject]=..., event_type:int=...) -> None: ...
    @staticmethod
    def setApplicationName(application:str) -> None: ...
    @staticmethod
    def setApplicationVersion(version:str) -> None: ...
    @staticmethod
    def setAttribute(attribute:PySide6.QtCore.Qt.ApplicationAttribute, on:bool=...) -> None: ...
    @staticmethod
    def setEventDispatcher(eventDispatcher:PySide6.QtCore.QAbstractEventDispatcher) -> None: ...
    @staticmethod
    def setLibraryPaths(arg__1:typing.Sequence) -> None: ...
    @staticmethod
    def setOrganizationDomain(orgDomain:str) -> None: ...
    @staticmethod
    def setOrganizationName(orgName:str) -> None: ...
    @staticmethod
    def setQuitLockEnabled(enabled:bool) -> None: ...
    @staticmethod
    def setSetuidAllowed(allow:bool) -> None: ...
    def shutdown(self) -> None: ...
    @staticmethod
    def startingUp() -> bool: ...
    @staticmethod
    def testAttribute(attribute:PySide6.QtCore.Qt.ApplicationAttribute) -> bool: ...
    @staticmethod
    def translate(context:bytes, key:bytes, disambiguation:typing.Optional[bytes]=..., n:int=...) -> str: ...


class QCryptographicHash(Shiboken.Object):
    Md4                      : QCryptographicHash = ... # 0x0
    Md5                      : QCryptographicHash = ... # 0x1
    Sha1                     : QCryptographicHash = ... # 0x2
    Sha224                   : QCryptographicHash = ... # 0x3
    Sha256                   : QCryptographicHash = ... # 0x4
    Sha384                   : QCryptographicHash = ... # 0x5
    Sha512                   : QCryptographicHash = ... # 0x6
    Keccak_224               : QCryptographicHash = ... # 0x7
    Keccak_256               : QCryptographicHash = ... # 0x8
    Keccak_384               : QCryptographicHash = ... # 0x9
    Keccak_512               : QCryptographicHash = ... # 0xa
    RealSha3_224             : QCryptographicHash = ... # 0xb
    Sha3_224                 : QCryptographicHash = ... # 0xb
    RealSha3_256             : QCryptographicHash = ... # 0xc
    Sha3_256                 : QCryptographicHash = ... # 0xc
    RealSha3_384             : QCryptographicHash = ... # 0xd
    Sha3_384                 : QCryptographicHash = ... # 0xd
    RealSha3_512             : QCryptographicHash = ... # 0xe
    Sha3_512                 : QCryptographicHash = ... # 0xe
    Blake2b_160              : QCryptographicHash = ... # 0xf
    Blake2b_256              : QCryptographicHash = ... # 0x10
    Blake2b_384              : QCryptographicHash = ... # 0x11
    Blake2b_512              : QCryptographicHash = ... # 0x12
    Blake2s_128              : QCryptographicHash = ... # 0x13
    Blake2s_160              : QCryptographicHash = ... # 0x14
    Blake2s_224              : QCryptographicHash = ... # 0x15
    Blake2s_256              : QCryptographicHash = ... # 0x16

    class Algorithm(object):
        Md4                      : QCryptographicHash.Algorithm = ... # 0x0
        Md5                      : QCryptographicHash.Algorithm = ... # 0x1
        Sha1                     : QCryptographicHash.Algorithm = ... # 0x2
        Sha224                   : QCryptographicHash.Algorithm = ... # 0x3
        Sha256                   : QCryptographicHash.Algorithm = ... # 0x4
        Sha384                   : QCryptographicHash.Algorithm = ... # 0x5
        Sha512                   : QCryptographicHash.Algorithm = ... # 0x6
        Keccak_224               : QCryptographicHash.Algorithm = ... # 0x7
        Keccak_256               : QCryptographicHash.Algorithm = ... # 0x8
        Keccak_384               : QCryptographicHash.Algorithm = ... # 0x9
        Keccak_512               : QCryptographicHash.Algorithm = ... # 0xa
        RealSha3_224             : QCryptographicHash.Algorithm = ... # 0xb
        Sha3_224                 : QCryptographicHash.Algorithm = ... # 0xb
        RealSha3_256             : QCryptographicHash.Algorithm = ... # 0xc
        Sha3_256                 : QCryptographicHash.Algorithm = ... # 0xc
        RealSha3_384             : QCryptographicHash.Algorithm = ... # 0xd
        Sha3_384                 : QCryptographicHash.Algorithm = ... # 0xd
        RealSha3_512             : QCryptographicHash.Algorithm = ... # 0xe
        Sha3_512                 : QCryptographicHash.Algorithm = ... # 0xe
        Blake2b_160              : QCryptographicHash.Algorithm = ... # 0xf
        Blake2b_256              : QCryptographicHash.Algorithm = ... # 0x10
        Blake2b_384              : QCryptographicHash.Algorithm = ... # 0x11
        Blake2b_512              : QCryptographicHash.Algorithm = ... # 0x12
        Blake2s_128              : QCryptographicHash.Algorithm = ... # 0x13
        Blake2s_160              : QCryptographicHash.Algorithm = ... # 0x14
        Blake2s_224              : QCryptographicHash.Algorithm = ... # 0x15
        Blake2s_256              : QCryptographicHash.Algorithm = ... # 0x16

    def __init__(self, method:PySide6.QtCore.QCryptographicHash.Algorithm) -> None: ...

    @typing.overload
    def addData(self, data:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def addData(self, data:bytes, length:int) -> None: ...
    @typing.overload
    def addData(self, device:PySide6.QtCore.QIODevice) -> bool: ...
    @staticmethod
    def hash(data:PySide6.QtCore.QByteArray, method:PySide6.QtCore.QCryptographicHash.Algorithm) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def hashLength(method:PySide6.QtCore.QCryptographicHash.Algorithm) -> int: ...
    def reset(self) -> None: ...
    def result(self) -> PySide6.QtCore.QByteArray: ...


class QDataStream(PySide6.QtCore.QIODeviceBase):
    BigEndian                : QDataStream = ... # 0x0
    Ok                       : QDataStream = ... # 0x0
    SinglePrecision          : QDataStream = ... # 0x0
    DoublePrecision          : QDataStream = ... # 0x1
    LittleEndian             : QDataStream = ... # 0x1
    Qt_1_0                   : QDataStream = ... # 0x1
    ReadPastEnd              : QDataStream = ... # 0x1
    Qt_2_0                   : QDataStream = ... # 0x2
    ReadCorruptData          : QDataStream = ... # 0x2
    Qt_2_1                   : QDataStream = ... # 0x3
    WriteFailed              : QDataStream = ... # 0x3
    Qt_3_0                   : QDataStream = ... # 0x4
    Qt_3_1                   : QDataStream = ... # 0x5
    Qt_3_3                   : QDataStream = ... # 0x6
    Qt_4_0                   : QDataStream = ... # 0x7
    Qt_4_1                   : QDataStream = ... # 0x7
    Qt_4_2                   : QDataStream = ... # 0x8
    Qt_4_3                   : QDataStream = ... # 0x9
    Qt_4_4                   : QDataStream = ... # 0xa
    Qt_4_5                   : QDataStream = ... # 0xb
    Qt_4_6                   : QDataStream = ... # 0xc
    Qt_4_7                   : QDataStream = ... # 0xc
    Qt_4_8                   : QDataStream = ... # 0xc
    Qt_4_9                   : QDataStream = ... # 0xc
    Qt_5_0                   : QDataStream = ... # 0xd
    Qt_5_1                   : QDataStream = ... # 0xe
    Qt_5_2                   : QDataStream = ... # 0xf
    Qt_5_3                   : QDataStream = ... # 0xf
    Qt_5_4                   : QDataStream = ... # 0x10
    Qt_5_5                   : QDataStream = ... # 0x10
    Qt_5_10                  : QDataStream = ... # 0x11
    Qt_5_11                  : QDataStream = ... # 0x11
    Qt_5_6                   : QDataStream = ... # 0x11
    Qt_5_7                   : QDataStream = ... # 0x11
    Qt_5_8                   : QDataStream = ... # 0x11
    Qt_5_9                   : QDataStream = ... # 0x11
    Qt_5_12                  : QDataStream = ... # 0x12
    Qt_5_13                  : QDataStream = ... # 0x13
    Qt_5_14                  : QDataStream = ... # 0x13
    Qt_5_15                  : QDataStream = ... # 0x13
    Qt_6_0                   : QDataStream = ... # 0x14
    Qt_DefaultCompiledVersion: QDataStream = ... # 0x14

    class ByteOrder(object):
        BigEndian                : QDataStream.ByteOrder = ... # 0x0
        LittleEndian             : QDataStream.ByteOrder = ... # 0x1

    class FloatingPointPrecision(object):
        SinglePrecision          : QDataStream.FloatingPointPrecision = ... # 0x0
        DoublePrecision          : QDataStream.FloatingPointPrecision = ... # 0x1

    class Status(object):
        Ok                       : QDataStream.Status = ... # 0x0
        ReadPastEnd              : QDataStream.Status = ... # 0x1
        ReadCorruptData          : QDataStream.Status = ... # 0x2
        WriteFailed              : QDataStream.Status = ... # 0x3

    class Version(object):
        Qt_1_0                   : QDataStream.Version = ... # 0x1
        Qt_2_0                   : QDataStream.Version = ... # 0x2
        Qt_2_1                   : QDataStream.Version = ... # 0x3
        Qt_3_0                   : QDataStream.Version = ... # 0x4
        Qt_3_1                   : QDataStream.Version = ... # 0x5
        Qt_3_3                   : QDataStream.Version = ... # 0x6
        Qt_4_0                   : QDataStream.Version = ... # 0x7
        Qt_4_1                   : QDataStream.Version = ... # 0x7
        Qt_4_2                   : QDataStream.Version = ... # 0x8
        Qt_4_3                   : QDataStream.Version = ... # 0x9
        Qt_4_4                   : QDataStream.Version = ... # 0xa
        Qt_4_5                   : QDataStream.Version = ... # 0xb
        Qt_4_6                   : QDataStream.Version = ... # 0xc
        Qt_4_7                   : QDataStream.Version = ... # 0xc
        Qt_4_8                   : QDataStream.Version = ... # 0xc
        Qt_4_9                   : QDataStream.Version = ... # 0xc
        Qt_5_0                   : QDataStream.Version = ... # 0xd
        Qt_5_1                   : QDataStream.Version = ... # 0xe
        Qt_5_2                   : QDataStream.Version = ... # 0xf
        Qt_5_3                   : QDataStream.Version = ... # 0xf
        Qt_5_4                   : QDataStream.Version = ... # 0x10
        Qt_5_5                   : QDataStream.Version = ... # 0x10
        Qt_5_10                  : QDataStream.Version = ... # 0x11
        Qt_5_11                  : QDataStream.Version = ... # 0x11
        Qt_5_6                   : QDataStream.Version = ... # 0x11
        Qt_5_7                   : QDataStream.Version = ... # 0x11
        Qt_5_8                   : QDataStream.Version = ... # 0x11
        Qt_5_9                   : QDataStream.Version = ... # 0x11
        Qt_5_12                  : QDataStream.Version = ... # 0x12
        Qt_5_13                  : QDataStream.Version = ... # 0x13
        Qt_5_14                  : QDataStream.Version = ... # 0x13
        Qt_5_15                  : QDataStream.Version = ... # 0x13
        Qt_6_0                   : QDataStream.Version = ... # 0x14
        Qt_DefaultCompiledVersion: QDataStream.Version = ... # 0x14

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QByteArray, flags:PySide6.QtCore.QIODeviceBase.OpenMode) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QIODevice) -> None: ...

    @typing.overload
    def __lshift__(self, arg__1:str) -> None: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QCborArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QCborMap) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QCborValue) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QDate) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QDateTime) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QEasingCurve) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QJsonArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QJsonDocument) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QJsonValue) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QLine) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QLineF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QLocale) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QMargins) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QPoint) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QPointF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QRect) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QRectF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QSize) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QTime) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QUrl) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2:PySide6.QtCore.QUuid) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, i:int) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, re:PySide6.QtCore.QRegularExpression) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, tz:PySide6.QtCore.QTimeZone) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, version:PySide6.QtCore.QVersionNumber) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QBitArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QCborArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QCborMap) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QCborValue) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QDate) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QDateTime) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QEasingCurve) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QJsonArray) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QJsonDocument) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QJsonValue) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QLine) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QLineF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QLocale) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QMargins) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QPoint) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QPointF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QRect) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QRectF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QSize) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QTime) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QUrl) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2:PySide6.QtCore.QUuid) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, i:int) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, re:PySide6.QtCore.QRegularExpression) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, tz:PySide6.QtCore.QTimeZone) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, version:PySide6.QtCore.QVersionNumber) -> PySide6.QtCore.QDataStream: ...
    def abortTransaction(self) -> None: ...
    def atEnd(self) -> bool: ...
    def byteOrder(self) -> PySide6.QtCore.QDataStream.ByteOrder: ...
    def commitTransaction(self) -> bool: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def floatingPointPrecision(self) -> PySide6.QtCore.QDataStream.FloatingPointPrecision: ...
    def isDeviceTransactionStarted(self) -> bool: ...
    def readBool(self) -> bool: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    def readInt16(self) -> int: ...
    def readInt32(self) -> int: ...
    def readInt64(self) -> int: ...
    def readInt8(self) -> int: ...
    def readQChar(self) -> str: ...
    def readQString(self) -> str: ...
    def readQStringList(self) -> typing.List: ...
    def readQVariant(self) -> typing.Any: ...
    def readRawData(self, arg__1:bytes, len:int) -> int: ...
    def readString(self) -> str: ...
    def readUInt16(self) -> int: ...
    def readUInt32(self) -> int: ...
    def readUInt64(self) -> int: ...
    def readUInt8(self) -> int: ...
    def resetStatus(self) -> None: ...
    def rollbackTransaction(self) -> None: ...
    def setByteOrder(self, arg__1:PySide6.QtCore.QDataStream.ByteOrder) -> None: ...
    def setDevice(self, arg__1:PySide6.QtCore.QIODevice) -> None: ...
    def setFloatingPointPrecision(self, precision:PySide6.QtCore.QDataStream.FloatingPointPrecision) -> None: ...
    def setStatus(self, status:PySide6.QtCore.QDataStream.Status) -> None: ...
    def setVersion(self, arg__1:int) -> None: ...
    def skipRawData(self, len:int) -> int: ...
    def startTransaction(self) -> None: ...
    def status(self) -> PySide6.QtCore.QDataStream.Status: ...
    def version(self) -> int: ...
    def writeBool(self, arg__1:bool) -> None: ...
    def writeDouble(self, arg__1:float) -> None: ...
    def writeFloat(self, arg__1:float) -> None: ...
    def writeInt16(self, arg__1:int) -> None: ...
    def writeInt32(self, arg__1:int) -> None: ...
    def writeInt64(self, arg__1:int) -> None: ...
    def writeInt8(self, arg__1:int) -> None: ...
    def writeQChar(self, arg__1:str) -> None: ...
    def writeQString(self, arg__1:str) -> None: ...
    def writeQStringList(self, arg__1:typing.Sequence) -> None: ...
    def writeQVariant(self, arg__1:typing.Any) -> None: ...
    def writeRawData(self, arg__1:bytes, len:int) -> int: ...
    def writeString(self, arg__1:str) -> None: ...
    def writeUInt16(self, arg__1:int) -> None: ...
    def writeUInt32(self, arg__1:int) -> None: ...
    def writeUInt64(self, arg__1:int) -> None: ...
    def writeUInt8(self, arg__1:int) -> None: ...


class QDate(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QDate:PySide6.QtCore.QDate) -> None: ...
    @typing.overload
    def __init__(self, y:int, m:int, d:int) -> None: ...
    @typing.overload
    def __init__(self, y:int, m:int, d:int, cal:PySide6.QtCore.QCalendar) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def addDays(self, days:int) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addMonths(self, months:int) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addMonths(self, months:int, cal:PySide6.QtCore.QCalendar) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addYears(self, years:int) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addYears(self, years:int, cal:PySide6.QtCore.QCalendar) -> PySide6.QtCore.QDate: ...
    @staticmethod
    def currentDate() -> PySide6.QtCore.QDate: ...
    @typing.overload
    def day(self) -> int: ...
    @typing.overload
    def day(self, cal:PySide6.QtCore.QCalendar) -> int: ...
    @typing.overload
    def dayOfWeek(self) -> int: ...
    @typing.overload
    def dayOfWeek(self, cal:PySide6.QtCore.QCalendar) -> int: ...
    @typing.overload
    def dayOfYear(self) -> int: ...
    @typing.overload
    def dayOfYear(self, cal:PySide6.QtCore.QCalendar) -> int: ...
    @typing.overload
    def daysInMonth(self) -> int: ...
    @typing.overload
    def daysInMonth(self, cal:PySide6.QtCore.QCalendar) -> int: ...
    @typing.overload
    def daysInYear(self) -> int: ...
    @typing.overload
    def daysInYear(self, cal:PySide6.QtCore.QCalendar) -> int: ...
    def daysTo(self, d:PySide6.QtCore.QDate) -> int: ...
    @typing.overload
    def endOfDay(self, spec:PySide6.QtCore.Qt.TimeSpec=..., offsetSeconds:int=...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def endOfDay(self, zone:PySide6.QtCore.QTimeZone) -> PySide6.QtCore.QDateTime: ...
    @staticmethod
    def fromJulianDay(jd_:int) -> PySide6.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(string:str, format:PySide6.QtCore.Qt.DateFormat=...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(string:str, format:str, cal:PySide6.QtCore.QCalendar=...) -> PySide6.QtCore.QDate: ...
    def getDate(self) -> typing.Tuple: ...
    @staticmethod
    def isLeapYear(year:int) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def isValid(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isValid(y:int, m:int, d:int) -> bool: ...
    @typing.overload
    def month(self) -> int: ...
    @typing.overload
    def month(self, cal:PySide6.QtCore.QCalendar) -> int: ...
    @typing.overload
    def setDate(self, year:int, month:int, day:int) -> bool: ...
    @typing.overload
    def setDate(self, year:int, month:int, day:int, cal:PySide6.QtCore.QCalendar) -> bool: ...
    @typing.overload
    def startOfDay(self, spec:PySide6.QtCore.Qt.TimeSpec=..., offsetSeconds:int=...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def startOfDay(self, zone:PySide6.QtCore.QTimeZone) -> PySide6.QtCore.QDateTime: ...
    def toJulianDay(self) -> int: ...
    def toPython(self) -> object: ...
    @typing.overload
    def toString(self, format:PySide6.QtCore.Qt.DateFormat=...) -> str: ...
    @typing.overload
    def toString(self, format:str, cal:PySide6.QtCore.QCalendar=...) -> str: ...
    def weekNumber(self) -> typing.Tuple: ...
    @typing.overload
    def year(self) -> int: ...
    @typing.overload
    def year(self, cal:PySide6.QtCore.QCalendar) -> int: ...


class QDateTime(Shiboken.Object):

    class YearRange(object):
        First                    : QDateTime.YearRange = ... # -0x116bc370
        Last                     : QDateTime.YearRange = ... # 0x116bd2d2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:int, arg__2:int, arg__3:int, arg__4:int, arg__5:int, arg__6:int) -> None: ...
    @typing.overload
    def __init__(self, arg__1:int, arg__2:int, arg__3:int, arg__4:int, arg__5:int, arg__6:int, arg__7:int, arg__8:int=...) -> None: ...
    @typing.overload
    def __init__(self, date:PySide6.QtCore.QDate, time:PySide6.QtCore.QTime, spec:PySide6.QtCore.Qt.TimeSpec=..., offsetSeconds:int=...) -> None: ...
    @typing.overload
    def __init__(self, date:PySide6.QtCore.QDate, time:PySide6.QtCore.QTime, timeZone:PySide6.QtCore.QTimeZone) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QDateTime) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def addDays(self, days:int) -> PySide6.QtCore.QDateTime: ...
    def addMSecs(self, msecs:int) -> PySide6.QtCore.QDateTime: ...
    def addMonths(self, months:int) -> PySide6.QtCore.QDateTime: ...
    def addSecs(self, secs:int) -> PySide6.QtCore.QDateTime: ...
    def addYears(self, years:int) -> PySide6.QtCore.QDateTime: ...
    @staticmethod
    def currentDateTime() -> PySide6.QtCore.QDateTime: ...
    @staticmethod
    def currentDateTimeUtc() -> PySide6.QtCore.QDateTime: ...
    @staticmethod
    def currentMSecsSinceEpoch() -> int: ...
    @staticmethod
    def currentSecsSinceEpoch() -> int: ...
    def date(self) -> PySide6.QtCore.QDate: ...
    def daysTo(self, arg__1:PySide6.QtCore.QDateTime) -> int: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs:int, spec:PySide6.QtCore.Qt.TimeSpec=..., offsetFromUtc:int=...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs:int, timeZone:PySide6.QtCore.QTimeZone) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs:int, spec:PySide6.QtCore.Qt.TimeSpec=..., offsetFromUtc:int=...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs:int, timeZone:PySide6.QtCore.QTimeZone) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(string:str, format:PySide6.QtCore.Qt.DateFormat=...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(string:str, format:str, cal:PySide6.QtCore.QCalendar=...) -> PySide6.QtCore.QDateTime: ...
    def isDaylightTime(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def msecsTo(self, arg__1:PySide6.QtCore.QDateTime) -> int: ...
    def offsetFromUtc(self) -> int: ...
    def secsTo(self, arg__1:PySide6.QtCore.QDateTime) -> int: ...
    def setDate(self, date:PySide6.QtCore.QDate) -> None: ...
    def setMSecsSinceEpoch(self, msecs:int) -> None: ...
    def setOffsetFromUtc(self, offsetSeconds:int) -> None: ...
    def setSecsSinceEpoch(self, secs:int) -> None: ...
    def setTime(self, time:PySide6.QtCore.QTime) -> None: ...
    def setTimeSpec(self, spec:PySide6.QtCore.Qt.TimeSpec) -> None: ...
    def setTimeZone(self, toZone:PySide6.QtCore.QTimeZone) -> None: ...
    def swap(self, other:PySide6.QtCore.QDateTime) -> None: ...
    def time(self) -> PySide6.QtCore.QTime: ...
    def timeSpec(self) -> PySide6.QtCore.Qt.TimeSpec: ...
    def timeZone(self) -> PySide6.QtCore.QTimeZone: ...
    def timeZoneAbbreviation(self) -> str: ...
    def toLocalTime(self) -> PySide6.QtCore.QDateTime: ...
    def toMSecsSinceEpoch(self) -> int: ...
    def toOffsetFromUtc(self, offsetSeconds:int) -> PySide6.QtCore.QDateTime: ...
    def toPython(self) -> object: ...
    def toSecsSinceEpoch(self) -> int: ...
    @typing.overload
    def toString(self, format:PySide6.QtCore.Qt.DateFormat=...) -> str: ...
    @typing.overload
    def toString(self, format:str, cal:PySide6.QtCore.QCalendar=...) -> str: ...
    def toTimeSpec(self, spec:PySide6.QtCore.Qt.TimeSpec) -> PySide6.QtCore.QDateTime: ...
    def toTimeZone(self, toZone:PySide6.QtCore.QTimeZone) -> PySide6.QtCore.QDateTime: ...
    def toUTC(self) -> PySide6.QtCore.QDateTime: ...


class QDeadlineTimer(Shiboken.Object):
    Forever                  : QDeadlineTimer = ... # 0x0

    class ForeverConstant(object):
        Forever                  : QDeadlineTimer.ForeverConstant = ... # 0x0

    @typing.overload
    def __init__(self, QDeadlineTimer:PySide6.QtCore.QDeadlineTimer) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QDeadlineTimer.ForeverConstant, type_:PySide6.QtCore.Qt.TimerType=...) -> None: ...
    @typing.overload
    def __init__(self, msecs:int, type:PySide6.QtCore.Qt.TimerType=...) -> None: ...
    @typing.overload
    def __init__(self, type_:PySide6.QtCore.Qt.TimerType=...) -> None: ...

    def __add__(self, msecs:int) -> PySide6.QtCore.QDeadlineTimer: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, msecs:int) -> PySide6.QtCore.QDeadlineTimer: ...
    def __isub__(self, msecs:int) -> PySide6.QtCore.QDeadlineTimer: ...
    @typing.overload
    def __sub__(self, dt2:PySide6.QtCore.QDeadlineTimer) -> int: ...
    @typing.overload
    def __sub__(self, msecs:int) -> PySide6.QtCore.QDeadlineTimer: ...
    def _q_data(self) -> typing.Tuple: ...
    @staticmethod
    def addNSecs(dt:PySide6.QtCore.QDeadlineTimer, nsecs:int) -> PySide6.QtCore.QDeadlineTimer: ...
    @staticmethod
    def current(timerType:PySide6.QtCore.Qt.TimerType=...) -> PySide6.QtCore.QDeadlineTimer: ...
    def deadline(self) -> int: ...
    def deadlineNSecs(self) -> int: ...
    def hasExpired(self) -> bool: ...
    def isForever(self) -> bool: ...
    def remainingTime(self) -> int: ...
    def remainingTimeNSecs(self) -> int: ...
    def setDeadline(self, msecs:int, timerType:PySide6.QtCore.Qt.TimerType=...) -> None: ...
    def setPreciseDeadline(self, secs:int, nsecs:int=..., type:PySide6.QtCore.Qt.TimerType=...) -> None: ...
    def setPreciseRemainingTime(self, secs:int, nsecs:int=..., type:PySide6.QtCore.Qt.TimerType=...) -> None: ...
    def setRemainingTime(self, msecs:int, type:PySide6.QtCore.Qt.TimerType=...) -> None: ...
    def setTimerType(self, type:PySide6.QtCore.Qt.TimerType) -> None: ...
    def swap(self, other:PySide6.QtCore.QDeadlineTimer) -> None: ...
    def timerType(self) -> PySide6.QtCore.Qt.TimerType: ...


class QDir(Shiboken.Object):
    NoFilter                 : QDir = ... # -0x1
    NoSort                   : QDir = ... # -0x1
    Name                     : QDir = ... # 0x0
    Dirs                     : QDir = ... # 0x1
    Time                     : QDir = ... # 0x1
    Files                    : QDir = ... # 0x2
    Size                     : QDir = ... # 0x2
    SortByMask               : QDir = ... # 0x3
    Unsorted                 : QDir = ... # 0x3
    DirsFirst                : QDir = ... # 0x4
    Drives                   : QDir = ... # 0x4
    AllEntries               : QDir = ... # 0x7
    NoSymLinks               : QDir = ... # 0x8
    Reversed                 : QDir = ... # 0x8
    TypeMask                 : QDir = ... # 0xf
    IgnoreCase               : QDir = ... # 0x10
    Readable                 : QDir = ... # 0x10
    DirsLast                 : QDir = ... # 0x20
    Writable                 : QDir = ... # 0x20
    Executable               : QDir = ... # 0x40
    LocaleAware              : QDir = ... # 0x40
    PermissionMask           : QDir = ... # 0x70
    Modified                 : QDir = ... # 0x80
    Type                     : QDir = ... # 0x80
    Hidden                   : QDir = ... # 0x100
    System                   : QDir = ... # 0x200
    AccessMask               : QDir = ... # 0x3f0
    AllDirs                  : QDir = ... # 0x400
    CaseSensitive            : QDir = ... # 0x800
    NoDot                    : QDir = ... # 0x2000
    NoDotDot                 : QDir = ... # 0x4000
    NoDotAndDotDot           : QDir = ... # 0x6000

    class Filter(object):
        NoFilter                 : QDir.Filter = ... # -0x1
        Dirs                     : QDir.Filter = ... # 0x1
        Files                    : QDir.Filter = ... # 0x2
        Drives                   : QDir.Filter = ... # 0x4
        AllEntries               : QDir.Filter = ... # 0x7
        NoSymLinks               : QDir.Filter = ... # 0x8
        TypeMask                 : QDir.Filter = ... # 0xf
        Readable                 : QDir.Filter = ... # 0x10
        Writable                 : QDir.Filter = ... # 0x20
        Executable               : QDir.Filter = ... # 0x40
        PermissionMask           : QDir.Filter = ... # 0x70
        Modified                 : QDir.Filter = ... # 0x80
        Hidden                   : QDir.Filter = ... # 0x100
        System                   : QDir.Filter = ... # 0x200
        AccessMask               : QDir.Filter = ... # 0x3f0
        AllDirs                  : QDir.Filter = ... # 0x400
        CaseSensitive            : QDir.Filter = ... # 0x800
        NoDot                    : QDir.Filter = ... # 0x2000
        NoDotDot                 : QDir.Filter = ... # 0x4000
        NoDotAndDotDot           : QDir.Filter = ... # 0x6000

    class Filters(object): ...

    class SortFlag(object):
        NoSort                   : QDir.SortFlag = ... # -0x1
        Name                     : QDir.SortFlag = ... # 0x0
        Time                     : QDir.SortFlag = ... # 0x1
        Size                     : QDir.SortFlag = ... # 0x2
        SortByMask               : QDir.SortFlag = ... # 0x3
        Unsorted                 : QDir.SortFlag = ... # 0x3
        DirsFirst                : QDir.SortFlag = ... # 0x4
        Reversed                 : QDir.SortFlag = ... # 0x8
        IgnoreCase               : QDir.SortFlag = ... # 0x10
        DirsLast                 : QDir.SortFlag = ... # 0x20
        LocaleAware              : QDir.SortFlag = ... # 0x40
        Type                     : QDir.SortFlag = ... # 0x80

    class SortFlags(object): ...

    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QDir) -> None: ...
    @typing.overload
    def __init__(self, path:str, nameFilter:str, sort:PySide6.QtCore.QDir.SortFlags=..., filter:PySide6.QtCore.QDir.Filters=...) -> None: ...
    @typing.overload
    def __init__(self, path:str=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def absoluteFilePath(self, fileName:str) -> str: ...
    def absolutePath(self) -> str: ...
    @staticmethod
    def addSearchPath(prefix:str, path:str) -> None: ...
    def canonicalPath(self) -> str: ...
    def cd(self, dirName:str) -> bool: ...
    def cdUp(self) -> bool: ...
    @staticmethod
    def cleanPath(path:str) -> str: ...
    def count(self) -> int: ...
    @staticmethod
    def current() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def currentPath() -> str: ...
    def dirName(self) -> str: ...
    @staticmethod
    def drives() -> typing.List: ...
    @typing.overload
    def entryInfoList(self, filters:PySide6.QtCore.QDir.Filters=..., sort:PySide6.QtCore.QDir.SortFlags=...) -> typing.List: ...
    @typing.overload
    def entryInfoList(self, nameFilters:typing.Sequence, filters:PySide6.QtCore.QDir.Filters=..., sort:PySide6.QtCore.QDir.SortFlags=...) -> typing.List: ...
    @typing.overload
    def entryList(self, filters:PySide6.QtCore.QDir.Filters=..., sort:PySide6.QtCore.QDir.SortFlags=...) -> typing.List: ...
    @typing.overload
    def entryList(self, nameFilters:typing.Sequence, filters:PySide6.QtCore.QDir.Filters=..., sort:PySide6.QtCore.QDir.SortFlags=...) -> typing.List: ...
    @typing.overload
    def exists(self) -> bool: ...
    @typing.overload
    def exists(self, name:str) -> bool: ...
    def filePath(self, fileName:str) -> str: ...
    def filter(self) -> PySide6.QtCore.QDir.Filters: ...
    @staticmethod
    def fromNativeSeparators(pathName:str) -> str: ...
    @staticmethod
    def home() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def homePath() -> str: ...
    def isAbsolute(self) -> bool: ...
    @staticmethod
    def isAbsolutePath(path:str) -> bool: ...
    def isEmpty(self, filters:PySide6.QtCore.QDir.Filters=...) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRelative(self) -> bool: ...
    @staticmethod
    def isRelativePath(path:str) -> bool: ...
    def isRoot(self) -> bool: ...
    @staticmethod
    def listSeparator() -> str: ...
    def makeAbsolute(self) -> bool: ...
    @typing.overload
    @staticmethod
    def match(filter:str, fileName:str) -> bool: ...
    @typing.overload
    @staticmethod
    def match(filters:typing.Sequence, fileName:str) -> bool: ...
    def mkdir(self, dirName:str) -> bool: ...
    def mkpath(self, dirPath:str) -> bool: ...
    def nameFilters(self) -> typing.List: ...
    @staticmethod
    def nameFiltersFromString(nameFilter:str) -> typing.List: ...
    def path(self) -> str: ...
    def refresh(self) -> None: ...
    def relativeFilePath(self, fileName:str) -> str: ...
    def remove(self, fileName:str) -> bool: ...
    def removeRecursively(self) -> bool: ...
    def rename(self, oldName:str, newName:str) -> bool: ...
    def rmdir(self, dirName:str) -> bool: ...
    def rmpath(self, dirPath:str) -> bool: ...
    @staticmethod
    def root() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def rootPath() -> str: ...
    @staticmethod
    def searchPaths(prefix:str) -> typing.List: ...
    @staticmethod
    def separator() -> str: ...
    @staticmethod
    def setCurrent(path:str) -> bool: ...
    def setFilter(self, filter:PySide6.QtCore.QDir.Filters) -> None: ...
    def setNameFilters(self, nameFilters:typing.Sequence) -> None: ...
    def setPath(self, path:str) -> None: ...
    @staticmethod
    def setSearchPaths(prefix:str, searchPaths:typing.Sequence) -> None: ...
    def setSorting(self, sort:PySide6.QtCore.QDir.SortFlags) -> None: ...
    def sorting(self) -> PySide6.QtCore.QDir.SortFlags: ...
    def swap(self, other:PySide6.QtCore.QDir) -> None: ...
    @staticmethod
    def temp() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def tempPath() -> str: ...
    @staticmethod
    def toNativeSeparators(pathName:str) -> str: ...


class QDirIterator(Shiboken.Object):
    NoIteratorFlags          : QDirIterator = ... # 0x0
    FollowSymlinks           : QDirIterator = ... # 0x1
    Subdirectories           : QDirIterator = ... # 0x2

    class IteratorFlag(object):
        NoIteratorFlags          : QDirIterator.IteratorFlag = ... # 0x0
        FollowSymlinks           : QDirIterator.IteratorFlag = ... # 0x1
        Subdirectories           : QDirIterator.IteratorFlag = ... # 0x2

    class IteratorFlags(object): ...

    @typing.overload
    def __init__(self, dir:PySide6.QtCore.QDir, flags:PySide6.QtCore.QDirIterator.IteratorFlags=...) -> None: ...
    @typing.overload
    def __init__(self, path:str, filter:PySide6.QtCore.QDir.Filters, flags:PySide6.QtCore.QDirIterator.IteratorFlags=...) -> None: ...
    @typing.overload
    def __init__(self, path:str, flags:PySide6.QtCore.QDirIterator.IteratorFlags=...) -> None: ...
    @typing.overload
    def __init__(self, path:str, nameFilters:typing.Sequence, filters:PySide6.QtCore.QDir.Filters=..., flags:PySide6.QtCore.QDirIterator.IteratorFlags=...) -> None: ...

    def fileInfo(self) -> PySide6.QtCore.QFileInfo: ...
    def fileName(self) -> str: ...
    def filePath(self) -> str: ...
    def hasNext(self) -> bool: ...
    def next(self) -> str: ...
    def path(self) -> str: ...


class QDynamicPropertyChangeEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QDynamicPropertyChangeEvent) -> None: ...
    @typing.overload
    def __init__(self, name:PySide6.QtCore.QByteArray) -> None: ...

    def clone(self) -> PySide6.QtCore.QDynamicPropertyChangeEvent: ...
    def propertyName(self) -> PySide6.QtCore.QByteArray: ...


class QEasingCurve(Shiboken.Object):
    Linear                   : QEasingCurve = ... # 0x0
    InQuad                   : QEasingCurve = ... # 0x1
    OutQuad                  : QEasingCurve = ... # 0x2
    InOutQuad                : QEasingCurve = ... # 0x3
    OutInQuad                : QEasingCurve = ... # 0x4
    InCubic                  : QEasingCurve = ... # 0x5
    OutCubic                 : QEasingCurve = ... # 0x6
    InOutCubic               : QEasingCurve = ... # 0x7
    OutInCubic               : QEasingCurve = ... # 0x8
    InQuart                  : QEasingCurve = ... # 0x9
    OutQuart                 : QEasingCurve = ... # 0xa
    InOutQuart               : QEasingCurve = ... # 0xb
    OutInQuart               : QEasingCurve = ... # 0xc
    InQuint                  : QEasingCurve = ... # 0xd
    OutQuint                 : QEasingCurve = ... # 0xe
    InOutQuint               : QEasingCurve = ... # 0xf
    OutInQuint               : QEasingCurve = ... # 0x10
    InSine                   : QEasingCurve = ... # 0x11
    OutSine                  : QEasingCurve = ... # 0x12
    InOutSine                : QEasingCurve = ... # 0x13
    OutInSine                : QEasingCurve = ... # 0x14
    InExpo                   : QEasingCurve = ... # 0x15
    OutExpo                  : QEasingCurve = ... # 0x16
    InOutExpo                : QEasingCurve = ... # 0x17
    OutInExpo                : QEasingCurve = ... # 0x18
    InCirc                   : QEasingCurve = ... # 0x19
    OutCirc                  : QEasingCurve = ... # 0x1a
    InOutCirc                : QEasingCurve = ... # 0x1b
    OutInCirc                : QEasingCurve = ... # 0x1c
    InElastic                : QEasingCurve = ... # 0x1d
    OutElastic               : QEasingCurve = ... # 0x1e
    InOutElastic             : QEasingCurve = ... # 0x1f
    OutInElastic             : QEasingCurve = ... # 0x20
    InBack                   : QEasingCurve = ... # 0x21
    OutBack                  : QEasingCurve = ... # 0x22
    InOutBack                : QEasingCurve = ... # 0x23
    OutInBack                : QEasingCurve = ... # 0x24
    InBounce                 : QEasingCurve = ... # 0x25
    OutBounce                : QEasingCurve = ... # 0x26
    InOutBounce              : QEasingCurve = ... # 0x27
    OutInBounce              : QEasingCurve = ... # 0x28
    InCurve                  : QEasingCurve = ... # 0x29
    OutCurve                 : QEasingCurve = ... # 0x2a
    SineCurve                : QEasingCurve = ... # 0x2b
    CosineCurve              : QEasingCurve = ... # 0x2c
    BezierSpline             : QEasingCurve = ... # 0x2d
    TCBSpline                : QEasingCurve = ... # 0x2e
    Custom                   : QEasingCurve = ... # 0x2f
    NCurveTypes              : QEasingCurve = ... # 0x30

    class Type(object):
        Linear                   : QEasingCurve.Type = ... # 0x0
        InQuad                   : QEasingCurve.Type = ... # 0x1
        OutQuad                  : QEasingCurve.Type = ... # 0x2
        InOutQuad                : QEasingCurve.Type = ... # 0x3
        OutInQuad                : QEasingCurve.Type = ... # 0x4
        InCubic                  : QEasingCurve.Type = ... # 0x5
        OutCubic                 : QEasingCurve.Type = ... # 0x6
        InOutCubic               : QEasingCurve.Type = ... # 0x7
        OutInCubic               : QEasingCurve.Type = ... # 0x8
        InQuart                  : QEasingCurve.Type = ... # 0x9
        OutQuart                 : QEasingCurve.Type = ... # 0xa
        InOutQuart               : QEasingCurve.Type = ... # 0xb
        OutInQuart               : QEasingCurve.Type = ... # 0xc
        InQuint                  : QEasingCurve.Type = ... # 0xd
        OutQuint                 : QEasingCurve.Type = ... # 0xe
        InOutQuint               : QEasingCurve.Type = ... # 0xf
        OutInQuint               : QEasingCurve.Type = ... # 0x10
        InSine                   : QEasingCurve.Type = ... # 0x11
        OutSine                  : QEasingCurve.Type = ... # 0x12
        InOutSine                : QEasingCurve.Type = ... # 0x13
        OutInSine                : QEasingCurve.Type = ... # 0x14
        InExpo                   : QEasingCurve.Type = ... # 0x15
        OutExpo                  : QEasingCurve.Type = ... # 0x16
        InOutExpo                : QEasingCurve.Type = ... # 0x17
        OutInExpo                : QEasingCurve.Type = ... # 0x18
        InCirc                   : QEasingCurve.Type = ... # 0x19
        OutCirc                  : QEasingCurve.Type = ... # 0x1a
        InOutCirc                : QEasingCurve.Type = ... # 0x1b
        OutInCirc                : QEasingCurve.Type = ... # 0x1c
        InElastic                : QEasingCurve.Type = ... # 0x1d
        OutElastic               : QEasingCurve.Type = ... # 0x1e
        InOutElastic             : QEasingCurve.Type = ... # 0x1f
        OutInElastic             : QEasingCurve.Type = ... # 0x20
        InBack                   : QEasingCurve.Type = ... # 0x21
        OutBack                  : QEasingCurve.Type = ... # 0x22
        InOutBack                : QEasingCurve.Type = ... # 0x23
        OutInBack                : QEasingCurve.Type = ... # 0x24
        InBounce                 : QEasingCurve.Type = ... # 0x25
        OutBounce                : QEasingCurve.Type = ... # 0x26
        InOutBounce              : QEasingCurve.Type = ... # 0x27
        OutInBounce              : QEasingCurve.Type = ... # 0x28
        InCurve                  : QEasingCurve.Type = ... # 0x29
        OutCurve                 : QEasingCurve.Type = ... # 0x2a
        SineCurve                : QEasingCurve.Type = ... # 0x2b
        CosineCurve              : QEasingCurve.Type = ... # 0x2c
        BezierSpline             : QEasingCurve.Type = ... # 0x2d
        TCBSpline                : QEasingCurve.Type = ... # 0x2e
        Custom                   : QEasingCurve.Type = ... # 0x2f
        NCurveTypes              : QEasingCurve.Type = ... # 0x30

    @typing.overload
    def __init__(self, other:PySide6.QtCore.QEasingCurve) -> None: ...
    @typing.overload
    def __init__(self, type:PySide6.QtCore.QEasingCurve.Type=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def addCubicBezierSegment(self, c1:PySide6.QtCore.QPointF, c2:PySide6.QtCore.QPointF, endPoint:PySide6.QtCore.QPointF) -> None: ...
    def addTCBSegment(self, nextPoint:PySide6.QtCore.QPointF, t:float, c:float, b:float) -> None: ...
    def amplitude(self) -> float: ...
    def customType(self) -> object: ...
    def overshoot(self) -> float: ...
    def period(self) -> float: ...
    def setAmplitude(self, amplitude:float) -> None: ...
    def setCustomType(self, arg__1:object) -> None: ...
    def setOvershoot(self, overshoot:float) -> None: ...
    def setPeriod(self, period:float) -> None: ...
    def setType(self, type:PySide6.QtCore.QEasingCurve.Type) -> None: ...
    def swap(self, other:PySide6.QtCore.QEasingCurve) -> None: ...
    def toCubicSpline(self) -> typing.List: ...
    def type(self) -> PySide6.QtCore.QEasingCurve.Type: ...
    def valueForProgress(self, progress:float) -> float: ...


class QElapsedTimer(Shiboken.Object):
    SystemTime               : QElapsedTimer = ... # 0x0
    MonotonicClock           : QElapsedTimer = ... # 0x1
    TickCounter              : QElapsedTimer = ... # 0x2
    MachAbsoluteTime         : QElapsedTimer = ... # 0x3
    PerformanceCounter       : QElapsedTimer = ... # 0x4

    class ClockType(object):
        SystemTime               : QElapsedTimer.ClockType = ... # 0x0
        MonotonicClock           : QElapsedTimer.ClockType = ... # 0x1
        TickCounter              : QElapsedTimer.ClockType = ... # 0x2
        MachAbsoluteTime         : QElapsedTimer.ClockType = ... # 0x3
        PerformanceCounter       : QElapsedTimer.ClockType = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QElapsedTimer:PySide6.QtCore.QElapsedTimer) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def clockType() -> PySide6.QtCore.QElapsedTimer.ClockType: ...
    def elapsed(self) -> int: ...
    def hasExpired(self, timeout:int) -> bool: ...
    def invalidate(self) -> None: ...
    @staticmethod
    def isMonotonic() -> bool: ...
    def isValid(self) -> bool: ...
    def msecsSinceReference(self) -> int: ...
    def msecsTo(self, other:PySide6.QtCore.QElapsedTimer) -> int: ...
    def nsecsElapsed(self) -> int: ...
    def restart(self) -> int: ...
    def secsTo(self, other:PySide6.QtCore.QElapsedTimer) -> int: ...
    def start(self) -> None: ...


class QEvent(Shiboken.Object):
    None_                    : QEvent = ... # 0x0
    Timer                    : QEvent = ... # 0x1
    MouseButtonPress         : QEvent = ... # 0x2
    MouseButtonRelease       : QEvent = ... # 0x3
    MouseButtonDblClick      : QEvent = ... # 0x4
    MouseMove                : QEvent = ... # 0x5
    KeyPress                 : QEvent = ... # 0x6
    KeyRelease               : QEvent = ... # 0x7
    FocusIn                  : QEvent = ... # 0x8
    FocusOut                 : QEvent = ... # 0x9
    Enter                    : QEvent = ... # 0xa
    Leave                    : QEvent = ... # 0xb
    Paint                    : QEvent = ... # 0xc
    Move                     : QEvent = ... # 0xd
    Resize                   : QEvent = ... # 0xe
    Create                   : QEvent = ... # 0xf
    Destroy                  : QEvent = ... # 0x10
    Show                     : QEvent = ... # 0x11
    Hide                     : QEvent = ... # 0x12
    Close                    : QEvent = ... # 0x13
    Quit                     : QEvent = ... # 0x14
    ParentChange             : QEvent = ... # 0x15
    ThreadChange             : QEvent = ... # 0x16
    FocusAboutToChange       : QEvent = ... # 0x17
    WindowActivate           : QEvent = ... # 0x18
    WindowDeactivate         : QEvent = ... # 0x19
    ShowToParent             : QEvent = ... # 0x1a
    HideToParent             : QEvent = ... # 0x1b
    Wheel                    : QEvent = ... # 0x1f
    WindowTitleChange        : QEvent = ... # 0x21
    WindowIconChange         : QEvent = ... # 0x22
    ApplicationWindowIconChange: QEvent = ... # 0x23
    ApplicationFontChange    : QEvent = ... # 0x24
    ApplicationLayoutDirectionChange: QEvent = ... # 0x25
    ApplicationPaletteChange : QEvent = ... # 0x26
    PaletteChange            : QEvent = ... # 0x27
    Clipboard                : QEvent = ... # 0x28
    Speech                   : QEvent = ... # 0x2a
    MetaCall                 : QEvent = ... # 0x2b
    SockAct                  : QEvent = ... # 0x32
    ShortcutOverride         : QEvent = ... # 0x33
    DeferredDelete           : QEvent = ... # 0x34
    DragEnter                : QEvent = ... # 0x3c
    DragMove                 : QEvent = ... # 0x3d
    DragLeave                : QEvent = ... # 0x3e
    Drop                     : QEvent = ... # 0x3f
    DragResponse             : QEvent = ... # 0x40
    ChildAdded               : QEvent = ... # 0x44
    ChildPolished            : QEvent = ... # 0x45
    ChildRemoved             : QEvent = ... # 0x47
    ShowWindowRequest        : QEvent = ... # 0x49
    PolishRequest            : QEvent = ... # 0x4a
    Polish                   : QEvent = ... # 0x4b
    LayoutRequest            : QEvent = ... # 0x4c
    UpdateRequest            : QEvent = ... # 0x4d
    UpdateLater              : QEvent = ... # 0x4e
    EmbeddingControl         : QEvent = ... # 0x4f
    ActivateControl          : QEvent = ... # 0x50
    DeactivateControl        : QEvent = ... # 0x51
    ContextMenu              : QEvent = ... # 0x52
    InputMethod              : QEvent = ... # 0x53
    TabletMove               : QEvent = ... # 0x57
    LocaleChange             : QEvent = ... # 0x58
    LanguageChange           : QEvent = ... # 0x59
    LayoutDirectionChange    : QEvent = ... # 0x5a
    Style                    : QEvent = ... # 0x5b
    TabletPress              : QEvent = ... # 0x5c
    TabletRelease            : QEvent = ... # 0x5d
    OkRequest                : QEvent = ... # 0x5e
    HelpRequest              : QEvent = ... # 0x5f
    IconDrag                 : QEvent = ... # 0x60
    FontChange               : QEvent = ... # 0x61
    EnabledChange            : QEvent = ... # 0x62
    ActivationChange         : QEvent = ... # 0x63
    StyleChange              : QEvent = ... # 0x64
    IconTextChange           : QEvent = ... # 0x65
    ModifiedChange           : QEvent = ... # 0x66
    WindowBlocked            : QEvent = ... # 0x67
    WindowUnblocked          : QEvent = ... # 0x68
    WindowStateChange        : QEvent = ... # 0x69
    ReadOnlyChange           : QEvent = ... # 0x6a
    MouseTrackingChange      : QEvent = ... # 0x6d
    ToolTip                  : QEvent = ... # 0x6e
    WhatsThis                : QEvent = ... # 0x6f
    StatusTip                : QEvent = ... # 0x70
    ActionChanged            : QEvent = ... # 0x71
    ActionAdded              : QEvent = ... # 0x72
    ActionRemoved            : QEvent = ... # 0x73
    FileOpen                 : QEvent = ... # 0x74
    Shortcut                 : QEvent = ... # 0x75
    WhatsThisClicked         : QEvent = ... # 0x76
    ToolBarChange            : QEvent = ... # 0x78
    ApplicationActivate      : QEvent = ... # 0x79
    ApplicationActivated     : QEvent = ... # 0x79
    ApplicationDeactivate    : QEvent = ... # 0x7a
    ApplicationDeactivated   : QEvent = ... # 0x7a
    QueryWhatsThis           : QEvent = ... # 0x7b
    EnterWhatsThisMode       : QEvent = ... # 0x7c
    LeaveWhatsThisMode       : QEvent = ... # 0x7d
    ZOrderChange             : QEvent = ... # 0x7e
    HoverEnter               : QEvent = ... # 0x7f
    HoverLeave               : QEvent = ... # 0x80
    HoverMove                : QEvent = ... # 0x81
    ParentAboutToChange      : QEvent = ... # 0x83
    WinEventAct              : QEvent = ... # 0x84
    AcceptDropsChange        : QEvent = ... # 0x98
    ZeroTimerEvent           : QEvent = ... # 0x9a
    GraphicsSceneMouseMove   : QEvent = ... # 0x9b
    GraphicsSceneMousePress  : QEvent = ... # 0x9c
    GraphicsSceneMouseRelease: QEvent = ... # 0x9d
    GraphicsSceneMouseDoubleClick: QEvent = ... # 0x9e
    GraphicsSceneContextMenu : QEvent = ... # 0x9f
    GraphicsSceneHoverEnter  : QEvent = ... # 0xa0
    GraphicsSceneHoverMove   : QEvent = ... # 0xa1
    GraphicsSceneHoverLeave  : QEvent = ... # 0xa2
    GraphicsSceneHelp        : QEvent = ... # 0xa3
    GraphicsSceneDragEnter   : QEvent = ... # 0xa4
    GraphicsSceneDragMove    : QEvent = ... # 0xa5
    GraphicsSceneDragLeave   : QEvent = ... # 0xa6
    GraphicsSceneDrop        : QEvent = ... # 0xa7
    GraphicsSceneWheel       : QEvent = ... # 0xa8
    KeyboardLayoutChange     : QEvent = ... # 0xa9
    DynamicPropertyChange    : QEvent = ... # 0xaa
    TabletEnterProximity     : QEvent = ... # 0xab
    TabletLeaveProximity     : QEvent = ... # 0xac
    NonClientAreaMouseMove   : QEvent = ... # 0xad
    NonClientAreaMouseButtonPress: QEvent = ... # 0xae
    NonClientAreaMouseButtonRelease: QEvent = ... # 0xaf
    NonClientAreaMouseButtonDblClick: QEvent = ... # 0xb0
    MacSizeChange            : QEvent = ... # 0xb1
    ContentsRectChange       : QEvent = ... # 0xb2
    MacGLWindowChange        : QEvent = ... # 0xb3
    FutureCallOut            : QEvent = ... # 0xb4
    GraphicsSceneResize      : QEvent = ... # 0xb5
    GraphicsSceneMove        : QEvent = ... # 0xb6
    CursorChange             : QEvent = ... # 0xb7
    ToolTipChange            : QEvent = ... # 0xb8
    NetworkReplyUpdated      : QEvent = ... # 0xb9
    GrabMouse                : QEvent = ... # 0xba
    UngrabMouse              : QEvent = ... # 0xbb
    GrabKeyboard             : QEvent = ... # 0xbc
    UngrabKeyboard           : QEvent = ... # 0xbd
    StateMachineSignal       : QEvent = ... # 0xc0
    StateMachineWrapped      : QEvent = ... # 0xc1
    TouchBegin               : QEvent = ... # 0xc2
    TouchUpdate              : QEvent = ... # 0xc3
    TouchEnd                 : QEvent = ... # 0xc4
    NativeGesture            : QEvent = ... # 0xc5
    Gesture                  : QEvent = ... # 0xc6
    RequestSoftwareInputPanel: QEvent = ... # 0xc7
    CloseSoftwareInputPanel  : QEvent = ... # 0xc8
    GestureOverride          : QEvent = ... # 0xca
    WinIdChange              : QEvent = ... # 0xcb
    ScrollPrepare            : QEvent = ... # 0xcc
    Scroll                   : QEvent = ... # 0xcd
    Expose                   : QEvent = ... # 0xce
    InputMethodQuery         : QEvent = ... # 0xcf
    OrientationChange        : QEvent = ... # 0xd0
    TouchCancel              : QEvent = ... # 0xd1
    ThemeChange              : QEvent = ... # 0xd2
    SockClose                : QEvent = ... # 0xd3
    PlatformPanel            : QEvent = ... # 0xd4
    StyleAnimationUpdate     : QEvent = ... # 0xd5
    ApplicationStateChange   : QEvent = ... # 0xd6
    WindowChangeInternal     : QEvent = ... # 0xd7
    ScreenChangeInternal     : QEvent = ... # 0xd8
    PlatformSurface          : QEvent = ... # 0xd9
    Pointer                  : QEvent = ... # 0xda
    TabletTrackingChange     : QEvent = ... # 0xdb
    GraphicsSceneLeave       : QEvent = ... # 0xdc
    User                     : QEvent = ... # 0x3e8
    MaxUser                  : QEvent = ... # 0xffff

    class Type(object):
        None_                    : QEvent.Type = ... # 0x0
        Timer                    : QEvent.Type = ... # 0x1
        MouseButtonPress         : QEvent.Type = ... # 0x2
        MouseButtonRelease       : QEvent.Type = ... # 0x3
        MouseButtonDblClick      : QEvent.Type = ... # 0x4
        MouseMove                : QEvent.Type = ... # 0x5
        KeyPress                 : QEvent.Type = ... # 0x6
        KeyRelease               : QEvent.Type = ... # 0x7
        FocusIn                  : QEvent.Type = ... # 0x8
        FocusOut                 : QEvent.Type = ... # 0x9
        Enter                    : QEvent.Type = ... # 0xa
        Leave                    : QEvent.Type = ... # 0xb
        Paint                    : QEvent.Type = ... # 0xc
        Move                     : QEvent.Type = ... # 0xd
        Resize                   : QEvent.Type = ... # 0xe
        Create                   : QEvent.Type = ... # 0xf
        Destroy                  : QEvent.Type = ... # 0x10
        Show                     : QEvent.Type = ... # 0x11
        Hide                     : QEvent.Type = ... # 0x12
        Close                    : QEvent.Type = ... # 0x13
        Quit                     : QEvent.Type = ... # 0x14
        ParentChange             : QEvent.Type = ... # 0x15
        ThreadChange             : QEvent.Type = ... # 0x16
        FocusAboutToChange       : QEvent.Type = ... # 0x17
        WindowActivate           : QEvent.Type = ... # 0x18
        WindowDeactivate         : QEvent.Type = ... # 0x19
        ShowToParent             : QEvent.Type = ... # 0x1a
        HideToParent             : QEvent.Type = ... # 0x1b
        Wheel                    : QEvent.Type = ... # 0x1f
        WindowTitleChange        : QEvent.Type = ... # 0x21
        WindowIconChange         : QEvent.Type = ... # 0x22
        ApplicationWindowIconChange: QEvent.Type = ... # 0x23
        ApplicationFontChange    : QEvent.Type = ... # 0x24
        ApplicationLayoutDirectionChange: QEvent.Type = ... # 0x25
        ApplicationPaletteChange : QEvent.Type = ... # 0x26
        PaletteChange            : QEvent.Type = ... # 0x27
        Clipboard                : QEvent.Type = ... # 0x28
        Speech                   : QEvent.Type = ... # 0x2a
        MetaCall                 : QEvent.Type = ... # 0x2b
        SockAct                  : QEvent.Type = ... # 0x32
        ShortcutOverride         : QEvent.Type = ... # 0x33
        DeferredDelete           : QEvent.Type = ... # 0x34
        DragEnter                : QEvent.Type = ... # 0x3c
        DragMove                 : QEvent.Type = ... # 0x3d
        DragLeave                : QEvent.Type = ... # 0x3e
        Drop                     : QEvent.Type = ... # 0x3f
        DragResponse             : QEvent.Type = ... # 0x40
        ChildAdded               : QEvent.Type = ... # 0x44
        ChildPolished            : QEvent.Type = ... # 0x45
        ChildRemoved             : QEvent.Type = ... # 0x47
        ShowWindowRequest        : QEvent.Type = ... # 0x49
        PolishRequest            : QEvent.Type = ... # 0x4a
        Polish                   : QEvent.Type = ... # 0x4b
        LayoutRequest            : QEvent.Type = ... # 0x4c
        UpdateRequest            : QEvent.Type = ... # 0x4d
        UpdateLater              : QEvent.Type = ... # 0x4e
        EmbeddingControl         : QEvent.Type = ... # 0x4f
        ActivateControl          : QEvent.Type = ... # 0x50
        DeactivateControl        : QEvent.Type = ... # 0x51
        ContextMenu              : QEvent.Type = ... # 0x52
        InputMethod              : QEvent.Type = ... # 0x53
        TabletMove               : QEvent.Type = ... # 0x57
        LocaleChange             : QEvent.Type = ... # 0x58
        LanguageChange           : QEvent.Type = ... # 0x59
        LayoutDirectionChange    : QEvent.Type = ... # 0x5a
        Style                    : QEvent.Type = ... # 0x5b
        TabletPress              : QEvent.Type = ... # 0x5c
        TabletRelease            : QEvent.Type = ... # 0x5d
        OkRequest                : QEvent.Type = ... # 0x5e
        HelpRequest              : QEvent.Type = ... # 0x5f
        IconDrag                 : QEvent.Type = ... # 0x60
        FontChange               : QEvent.Type = ... # 0x61
        EnabledChange            : QEvent.Type = ... # 0x62
        ActivationChange         : QEvent.Type = ... # 0x63
        StyleChange              : QEvent.Type = ... # 0x64
        IconTextChange           : QEvent.Type = ... # 0x65
        ModifiedChange           : QEvent.Type = ... # 0x66
        WindowBlocked            : QEvent.Type = ... # 0x67
        WindowUnblocked          : QEvent.Type = ... # 0x68
        WindowStateChange        : QEvent.Type = ... # 0x69
        ReadOnlyChange           : QEvent.Type = ... # 0x6a
        MouseTrackingChange      : QEvent.Type = ... # 0x6d
        ToolTip                  : QEvent.Type = ... # 0x6e
        WhatsThis                : QEvent.Type = ... # 0x6f
        StatusTip                : QEvent.Type = ... # 0x70
        ActionChanged            : QEvent.Type = ... # 0x71
        ActionAdded              : QEvent.Type = ... # 0x72
        ActionRemoved            : QEvent.Type = ... # 0x73
        FileOpen                 : QEvent.Type = ... # 0x74
        Shortcut                 : QEvent.Type = ... # 0x75
        WhatsThisClicked         : QEvent.Type = ... # 0x76
        ToolBarChange            : QEvent.Type = ... # 0x78
        ApplicationActivate      : QEvent.Type = ... # 0x79
        ApplicationActivated     : QEvent.Type = ... # 0x79
        ApplicationDeactivate    : QEvent.Type = ... # 0x7a
        ApplicationDeactivated   : QEvent.Type = ... # 0x7a
        QueryWhatsThis           : QEvent.Type = ... # 0x7b
        EnterWhatsThisMode       : QEvent.Type = ... # 0x7c
        LeaveWhatsThisMode       : QEvent.Type = ... # 0x7d
        ZOrderChange             : QEvent.Type = ... # 0x7e
        HoverEnter               : QEvent.Type = ... # 0x7f
        HoverLeave               : QEvent.Type = ... # 0x80
        HoverMove                : QEvent.Type = ... # 0x81
        ParentAboutToChange      : QEvent.Type = ... # 0x83
        WinEventAct              : QEvent.Type = ... # 0x84
        AcceptDropsChange        : QEvent.Type = ... # 0x98
        ZeroTimerEvent           : QEvent.Type = ... # 0x9a
        GraphicsSceneMouseMove   : QEvent.Type = ... # 0x9b
        GraphicsSceneMousePress  : QEvent.Type = ... # 0x9c
        GraphicsSceneMouseRelease: QEvent.Type = ... # 0x9d
        GraphicsSceneMouseDoubleClick: QEvent.Type = ... # 0x9e
        GraphicsSceneContextMenu : QEvent.Type = ... # 0x9f
        GraphicsSceneHoverEnter  : QEvent.Type = ... # 0xa0
        GraphicsSceneHoverMove   : QEvent.Type = ... # 0xa1
        GraphicsSceneHoverLeave  : QEvent.Type = ... # 0xa2
        GraphicsSceneHelp        : QEvent.Type = ... # 0xa3
        GraphicsSceneDragEnter   : QEvent.Type = ... # 0xa4
        GraphicsSceneDragMove    : QEvent.Type = ... # 0xa5
        GraphicsSceneDragLeave   : QEvent.Type = ... # 0xa6
        GraphicsSceneDrop        : QEvent.Type = ... # 0xa7
        GraphicsSceneWheel       : QEvent.Type = ... # 0xa8
        KeyboardLayoutChange     : QEvent.Type = ... # 0xa9
        DynamicPropertyChange    : QEvent.Type = ... # 0xaa
        TabletEnterProximity     : QEvent.Type = ... # 0xab
        TabletLeaveProximity     : QEvent.Type = ... # 0xac
        NonClientAreaMouseMove   : QEvent.Type = ... # 0xad
        NonClientAreaMouseButtonPress: QEvent.Type = ... # 0xae
        NonClientAreaMouseButtonRelease: QEvent.Type = ... # 0xaf
        NonClientAreaMouseButtonDblClick: QEvent.Type = ... # 0xb0
        MacSizeChange            : QEvent.Type = ... # 0xb1
        ContentsRectChange       : QEvent.Type = ... # 0xb2
        MacGLWindowChange        : QEvent.Type = ... # 0xb3
        FutureCallOut            : QEvent.Type = ... # 0xb4
        GraphicsSceneResize      : QEvent.Type = ... # 0xb5
        GraphicsSceneMove        : QEvent.Type = ... # 0xb6
        CursorChange             : QEvent.Type = ... # 0xb7
        ToolTipChange            : QEvent.Type = ... # 0xb8
        NetworkReplyUpdated      : QEvent.Type = ... # 0xb9
        GrabMouse                : QEvent.Type = ... # 0xba
        UngrabMouse              : QEvent.Type = ... # 0xbb
        GrabKeyboard             : QEvent.Type = ... # 0xbc
        UngrabKeyboard           : QEvent.Type = ... # 0xbd
        StateMachineSignal       : QEvent.Type = ... # 0xc0
        StateMachineWrapped      : QEvent.Type = ... # 0xc1
        TouchBegin               : QEvent.Type = ... # 0xc2
        TouchUpdate              : QEvent.Type = ... # 0xc3
        TouchEnd                 : QEvent.Type = ... # 0xc4
        NativeGesture            : QEvent.Type = ... # 0xc5
        Gesture                  : QEvent.Type = ... # 0xc6
        RequestSoftwareInputPanel: QEvent.Type = ... # 0xc7
        CloseSoftwareInputPanel  : QEvent.Type = ... # 0xc8
        GestureOverride          : QEvent.Type = ... # 0xca
        WinIdChange              : QEvent.Type = ... # 0xcb
        ScrollPrepare            : QEvent.Type = ... # 0xcc
        Scroll                   : QEvent.Type = ... # 0xcd
        Expose                   : QEvent.Type = ... # 0xce
        InputMethodQuery         : QEvent.Type = ... # 0xcf
        OrientationChange        : QEvent.Type = ... # 0xd0
        TouchCancel              : QEvent.Type = ... # 0xd1
        ThemeChange              : QEvent.Type = ... # 0xd2
        SockClose                : QEvent.Type = ... # 0xd3
        PlatformPanel            : QEvent.Type = ... # 0xd4
        StyleAnimationUpdate     : QEvent.Type = ... # 0xd5
        ApplicationStateChange   : QEvent.Type = ... # 0xd6
        WindowChangeInternal     : QEvent.Type = ... # 0xd7
        ScreenChangeInternal     : QEvent.Type = ... # 0xd8
        PlatformSurface          : QEvent.Type = ... # 0xd9
        Pointer                  : QEvent.Type = ... # 0xda
        TabletTrackingChange     : QEvent.Type = ... # 0xdb
        GraphicsSceneLeave       : QEvent.Type = ... # 0xdc
        User                     : QEvent.Type = ... # 0x3e8
        MaxUser                  : QEvent.Type = ... # 0xffff

    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QEvent) -> None: ...
    @typing.overload
    def __init__(self, type:PySide6.QtCore.QEvent.Type) -> None: ...

    def accept(self) -> None: ...
    def clone(self) -> PySide6.QtCore.QEvent: ...
    def ignore(self) -> None: ...
    def isAccepted(self) -> bool: ...
    def isInputEvent(self) -> bool: ...
    def isPointerEvent(self) -> bool: ...
    def isSinglePointEvent(self) -> bool: ...
    @staticmethod
    def registerEventType(hint:int=...) -> int: ...
    def setAccepted(self, accepted:bool) -> None: ...
    def spontaneous(self) -> bool: ...
    def type(self) -> PySide6.QtCore.QEvent.Type: ...


class QEventLoop(PySide6.QtCore.QObject):
    AllEvents                : QEventLoop = ... # 0x0
    ExcludeUserInputEvents   : QEventLoop = ... # 0x1
    ExcludeSocketNotifiers   : QEventLoop = ... # 0x2
    WaitForMoreEvents        : QEventLoop = ... # 0x4
    X11ExcludeTimers         : QEventLoop = ... # 0x8
    EventLoopExec            : QEventLoop = ... # 0x20
    DialogExec               : QEventLoop = ... # 0x40

    class ProcessEventsFlag(object):
        AllEvents                : QEventLoop.ProcessEventsFlag = ... # 0x0
        ExcludeUserInputEvents   : QEventLoop.ProcessEventsFlag = ... # 0x1
        ExcludeSocketNotifiers   : QEventLoop.ProcessEventsFlag = ... # 0x2
        WaitForMoreEvents        : QEventLoop.ProcessEventsFlag = ... # 0x4
        X11ExcludeTimers         : QEventLoop.ProcessEventsFlag = ... # 0x8
        EventLoopExec            : QEventLoop.ProcessEventsFlag = ... # 0x20
        DialogExec               : QEventLoop.ProcessEventsFlag = ... # 0x40

    class ProcessEventsFlags(object): ...

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def exec_(self, flags:PySide6.QtCore.QEventLoop.ProcessEventsFlags=...) -> int: ...
    def exit(self, returnCode:int=...) -> None: ...
    def isRunning(self) -> bool: ...
    @typing.overload
    def processEvents(self, flags:PySide6.QtCore.QEventLoop.ProcessEventsFlags, maximumTime:int) -> None: ...
    @typing.overload
    def processEvents(self, flags:PySide6.QtCore.QEventLoop.ProcessEventsFlags=...) -> bool: ...
    def quit(self) -> None: ...
    def wakeUp(self) -> None: ...


class QFactoryInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def keys(self) -> typing.List: ...


class QFile(PySide6.QtCore.QFileDevice):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name:str) -> None: ...
    @typing.overload
    def __init__(self, name:str, parent:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, parent:PySide6.QtCore.QObject) -> None: ...

    @typing.overload
    @staticmethod
    def copy(fileName:str, newName:str) -> bool: ...
    @typing.overload
    def copy(self, newName:str) -> bool: ...
    @typing.overload
    @staticmethod
    def decodeName(localFileName:PySide6.QtCore.QByteArray) -> str: ...
    @typing.overload
    @staticmethod
    def decodeName(localFileName:bytes) -> str: ...
    @staticmethod
    def encodeName(fileName:str) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def exists(fileName:str) -> bool: ...
    @typing.overload
    def exists(self) -> bool: ...
    def fileName(self) -> str: ...
    @typing.overload
    @staticmethod
    def link(oldname:str, newName:str) -> bool: ...
    @typing.overload
    def link(self, newName:str) -> bool: ...
    @typing.overload
    @staticmethod
    def moveToTrash(fileName:str) -> typing.Tuple: ...
    @typing.overload
    def moveToTrash(self) -> bool: ...
    @typing.overload
    def open(self, fd:int, ioFlags:PySide6.QtCore.QIODeviceBase.OpenMode, handleFlags:PySide6.QtCore.QFileDevice.FileHandleFlags=...) -> bool: ...
    @typing.overload
    def open(self, flags:PySide6.QtCore.QIODeviceBase.OpenMode) -> bool: ...
    @typing.overload
    @staticmethod
    def permissions(filename:str) -> PySide6.QtCore.QFileDevice.Permissions: ...
    @typing.overload
    def permissions(self) -> PySide6.QtCore.QFileDevice.Permissions: ...
    @typing.overload
    @staticmethod
    def remove(fileName:str) -> bool: ...
    @typing.overload
    def remove(self) -> bool: ...
    @typing.overload
    @staticmethod
    def rename(oldName:str, newName:str) -> bool: ...
    @typing.overload
    def rename(self, newName:str) -> bool: ...
    @typing.overload
    @staticmethod
    def resize(filename:str, sz:int) -> bool: ...
    @typing.overload
    def resize(self, sz:int) -> bool: ...
    def setFileName(self, name:str) -> None: ...
    @typing.overload
    @staticmethod
    def setPermissions(filename:str, permissionSpec:PySide6.QtCore.QFileDevice.Permissions) -> bool: ...
    @typing.overload
    def setPermissions(self, permissionSpec:PySide6.QtCore.QFileDevice.Permissions) -> bool: ...
    def size(self) -> int: ...
    @typing.overload
    @staticmethod
    def symLinkTarget(fileName:str) -> str: ...
    @typing.overload
    def symLinkTarget(self) -> str: ...


class QFileDevice(PySide6.QtCore.QIODevice):
    DontCloseHandle          : QFileDevice = ... # 0x0
    FileAccessTime           : QFileDevice = ... # 0x0
    NoError                  : QFileDevice = ... # 0x0
    NoOptions                : QFileDevice = ... # 0x0
    AutoCloseHandle          : QFileDevice = ... # 0x1
    ExeOther                 : QFileDevice = ... # 0x1
    FileBirthTime            : QFileDevice = ... # 0x1
    MapPrivateOption         : QFileDevice = ... # 0x1
    ReadError                : QFileDevice = ... # 0x1
    FileMetadataChangeTime   : QFileDevice = ... # 0x2
    WriteError               : QFileDevice = ... # 0x2
    WriteOther               : QFileDevice = ... # 0x2
    FatalError               : QFileDevice = ... # 0x3
    FileModificationTime     : QFileDevice = ... # 0x3
    ReadOther                : QFileDevice = ... # 0x4
    ResourceError            : QFileDevice = ... # 0x4
    OpenError                : QFileDevice = ... # 0x5
    AbortError               : QFileDevice = ... # 0x6
    TimeOutError             : QFileDevice = ... # 0x7
    UnspecifiedError         : QFileDevice = ... # 0x8
    RemoveError              : QFileDevice = ... # 0x9
    RenameError              : QFileDevice = ... # 0xa
    PositionError            : QFileDevice = ... # 0xb
    ResizeError              : QFileDevice = ... # 0xc
    PermissionsError         : QFileDevice = ... # 0xd
    CopyError                : QFileDevice = ... # 0xe
    ExeGroup                 : QFileDevice = ... # 0x10
    WriteGroup               : QFileDevice = ... # 0x20
    ReadGroup                : QFileDevice = ... # 0x40
    ExeUser                  : QFileDevice = ... # 0x100
    WriteUser                : QFileDevice = ... # 0x200
    ReadUser                 : QFileDevice = ... # 0x400
    ExeOwner                 : QFileDevice = ... # 0x1000
    WriteOwner               : QFileDevice = ... # 0x2000
    ReadOwner                : QFileDevice = ... # 0x4000

    class FileError(object):
        NoError                  : QFileDevice.FileError = ... # 0x0
        ReadError                : QFileDevice.FileError = ... # 0x1
        WriteError               : QFileDevice.FileError = ... # 0x2
        FatalError               : QFileDevice.FileError = ... # 0x3
        ResourceError            : QFileDevice.FileError = ... # 0x4
        OpenError                : QFileDevice.FileError = ... # 0x5
        AbortError               : QFileDevice.FileError = ... # 0x6
        TimeOutError             : QFileDevice.FileError = ... # 0x7
        UnspecifiedError         : QFileDevice.FileError = ... # 0x8
        RemoveError              : QFileDevice.FileError = ... # 0x9
        RenameError              : QFileDevice.FileError = ... # 0xa
        PositionError            : QFileDevice.FileError = ... # 0xb
        ResizeError              : QFileDevice.FileError = ... # 0xc
        PermissionsError         : QFileDevice.FileError = ... # 0xd
        CopyError                : QFileDevice.FileError = ... # 0xe

    class FileHandleFlag(object):
        DontCloseHandle          : QFileDevice.FileHandleFlag = ... # 0x0
        AutoCloseHandle          : QFileDevice.FileHandleFlag = ... # 0x1

    class FileHandleFlags(object): ...

    class FileTime(object):
        FileAccessTime           : QFileDevice.FileTime = ... # 0x0
        FileBirthTime            : QFileDevice.FileTime = ... # 0x1
        FileMetadataChangeTime   : QFileDevice.FileTime = ... # 0x2
        FileModificationTime     : QFileDevice.FileTime = ... # 0x3

    class MemoryMapFlag(object):
        NoOptions                : QFileDevice.MemoryMapFlag = ... # 0x0
        MapPrivateOption         : QFileDevice.MemoryMapFlag = ... # 0x1

    class MemoryMapFlags(object): ...

    class Permission(object):
        ExeOther                 : QFileDevice.Permission = ... # 0x1
        WriteOther               : QFileDevice.Permission = ... # 0x2
        ReadOther                : QFileDevice.Permission = ... # 0x4
        ExeGroup                 : QFileDevice.Permission = ... # 0x10
        WriteGroup               : QFileDevice.Permission = ... # 0x20
        ReadGroup                : QFileDevice.Permission = ... # 0x40
        ExeUser                  : QFileDevice.Permission = ... # 0x100
        WriteUser                : QFileDevice.Permission = ... # 0x200
        ReadUser                 : QFileDevice.Permission = ... # 0x400
        ExeOwner                 : QFileDevice.Permission = ... # 0x1000
        WriteOwner               : QFileDevice.Permission = ... # 0x2000
        ReadOwner                : QFileDevice.Permission = ... # 0x4000

    class Permissions(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent:PySide6.QtCore.QObject) -> None: ...

    def atEnd(self) -> bool: ...
    def close(self) -> None: ...
    def error(self) -> PySide6.QtCore.QFileDevice.FileError: ...
    def fileName(self) -> str: ...
    def fileTime(self, time:PySide6.QtCore.QFileDevice.FileTime) -> PySide6.QtCore.QDateTime: ...
    def flush(self) -> bool: ...
    def handle(self) -> int: ...
    def isSequential(self) -> bool: ...
    def map(self, offset:int, size:int, flags:PySide6.QtCore.QFileDevice.MemoryMapFlags=...) -> bytes: ...
    def permissions(self) -> PySide6.QtCore.QFileDevice.Permissions: ...
    def pos(self) -> int: ...
    def readData(self, data:bytes, maxlen:int) -> int: ...
    def readLineData(self, data:bytes, maxlen:int) -> int: ...
    def resize(self, sz:int) -> bool: ...
    def seek(self, offset:int) -> bool: ...
    def setFileTime(self, newDate:PySide6.QtCore.QDateTime, fileTime:PySide6.QtCore.QFileDevice.FileTime) -> bool: ...
    def setPermissions(self, permissionSpec:PySide6.QtCore.QFileDevice.Permissions) -> bool: ...
    def size(self) -> int: ...
    def unmap(self, address:bytes) -> bool: ...
    def unsetError(self) -> None: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QFileInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, dir:PySide6.QtCore.QDir, file:str) -> None: ...
    @typing.overload
    def __init__(self, file:PySide6.QtCore.QFileDevice) -> None: ...
    @typing.overload
    def __init__(self, file:str) -> None: ...
    @typing.overload
    def __init__(self, fileinfo:PySide6.QtCore.QFileInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def absoluteDir(self) -> PySide6.QtCore.QDir: ...
    def absoluteFilePath(self) -> str: ...
    def absolutePath(self) -> str: ...
    def baseName(self) -> str: ...
    def birthTime(self) -> PySide6.QtCore.QDateTime: ...
    def bundleName(self) -> str: ...
    def caching(self) -> bool: ...
    def canonicalFilePath(self) -> str: ...
    def canonicalPath(self) -> str: ...
    def completeBaseName(self) -> str: ...
    def completeSuffix(self) -> str: ...
    def dir(self) -> PySide6.QtCore.QDir: ...
    @typing.overload
    @staticmethod
    def exists(file:str) -> bool: ...
    @typing.overload
    def exists(self) -> bool: ...
    def fileName(self) -> str: ...
    def filePath(self) -> str: ...
    def group(self) -> str: ...
    def groupId(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isBundle(self) -> bool: ...
    def isDir(self) -> bool: ...
    def isExecutable(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isJunction(self) -> bool: ...
    def isNativePath(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRelative(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isShortcut(self) -> bool: ...
    def isSymLink(self) -> bool: ...
    def isSymbolicLink(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def lastModified(self) -> PySide6.QtCore.QDateTime: ...
    def lastRead(self) -> PySide6.QtCore.QDateTime: ...
    def makeAbsolute(self) -> bool: ...
    def metadataChangeTime(self) -> PySide6.QtCore.QDateTime: ...
    def owner(self) -> str: ...
    def ownerId(self) -> int: ...
    def path(self) -> str: ...
    def refresh(self) -> None: ...
    def setCaching(self, on:bool) -> None: ...
    @typing.overload
    def setFile(self, dir:PySide6.QtCore.QDir, file:str) -> None: ...
    @typing.overload
    def setFile(self, file:PySide6.QtCore.QFileDevice) -> None: ...
    @typing.overload
    def setFile(self, file:str) -> None: ...
    def size(self) -> int: ...
    def stat(self) -> None: ...
    def suffix(self) -> str: ...
    def swap(self, other:PySide6.QtCore.QFileInfo) -> None: ...
    def symLinkTarget(self) -> str: ...


class QFileSelector(PySide6.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def allSelectors(self) -> typing.List: ...
    def extraSelectors(self) -> typing.List: ...
    @typing.overload
    def select(self, filePath:PySide6.QtCore.QUrl) -> PySide6.QtCore.QUrl: ...
    @typing.overload
    def select(self, filePath:str) -> str: ...
    def setExtraSelectors(self, list:typing.Sequence) -> None: ...


class QFileSystemWatcher(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, paths:typing.Sequence, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def addPath(self, file:str) -> bool: ...
    def addPaths(self, files:typing.Sequence) -> typing.List: ...
    def directories(self) -> typing.List: ...
    def files(self) -> typing.List: ...
    def removePath(self, file:str) -> bool: ...
    def removePaths(self, files:typing.Sequence) -> typing.List: ...


class QFutureInterfaceBase(Shiboken.Object):
    NoState                  : QFutureInterfaceBase = ... # 0x0
    Running                  : QFutureInterfaceBase = ... # 0x1
    Started                  : QFutureInterfaceBase = ... # 0x2
    Finished                 : QFutureInterfaceBase = ... # 0x4
    Canceled                 : QFutureInterfaceBase = ... # 0x8
    Suspending               : QFutureInterfaceBase = ... # 0x10
    Suspended                : QFutureInterfaceBase = ... # 0x20
    Throttled                : QFutureInterfaceBase = ... # 0x40
    Pending                  : QFutureInterfaceBase = ... # 0x80

    class State(object):
        NoState                  : QFutureInterfaceBase.State = ... # 0x0
        Running                  : QFutureInterfaceBase.State = ... # 0x1
        Started                  : QFutureInterfaceBase.State = ... # 0x2
        Finished                 : QFutureInterfaceBase.State = ... # 0x4
        Canceled                 : QFutureInterfaceBase.State = ... # 0x8
        Suspending               : QFutureInterfaceBase.State = ... # 0x10
        Suspended                : QFutureInterfaceBase.State = ... # 0x20
        Throttled                : QFutureInterfaceBase.State = ... # 0x40
        Pending                  : QFutureInterfaceBase.State = ... # 0x80

    @typing.overload
    def __init__(self, initialState:PySide6.QtCore.QFutureInterfaceBase.State=...) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QFutureInterfaceBase) -> None: ...

    def cancel(self) -> None: ...
    def derefT(self) -> bool: ...
    def expectedResultCount(self) -> int: ...
    def isCanceled(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def isProgressUpdateNeeded(self) -> bool: ...
    def isResultReadyAt(self, index:int) -> bool: ...
    def isRunning(self) -> bool: ...
    def isRunningOrPending(self) -> bool: ...
    def isStarted(self) -> bool: ...
    def isSuspended(self) -> bool: ...
    def isSuspending(self) -> bool: ...
    def isThrottled(self) -> bool: ...
    def isValid(self) -> bool: ...
    def launchAsync(self) -> bool: ...
    def loadState(self) -> int: ...
    def mutex(self) -> PySide6.QtCore.QMutex: ...
    def progressMaximum(self) -> int: ...
    def progressMinimum(self) -> int: ...
    def progressText(self) -> str: ...
    def progressValue(self) -> int: ...
    def queryState(self, state:PySide6.QtCore.QFutureInterfaceBase.State) -> bool: ...
    def refT(self) -> bool: ...
    def reportCanceled(self) -> None: ...
    def reportFinished(self) -> None: ...
    def reportResultsReady(self, beginIndex:int, endIndex:int) -> None: ...
    def reportStarted(self) -> None: ...
    def reportSuspended(self) -> None: ...
    def reset(self) -> None: ...
    def resultCount(self) -> int: ...
    def runContinuation(self) -> None: ...
    def setExpectedResultCount(self, resultCount:int) -> None: ...
    def setFilterMode(self, enable:bool) -> None: ...
    def setLaunchAsync(self, value:bool) -> None: ...
    def setPaused(self, paused:bool) -> None: ...
    def setProgressRange(self, minimum:int, maximum:int) -> None: ...
    def setProgressValue(self, progressValue:int) -> None: ...
    def setProgressValueAndText(self, progressValue:int, progressText:str) -> None: ...
    def setRunnable(self, runnable:PySide6.QtCore.QRunnable) -> None: ...
    def setSuspended(self, suspend:bool) -> None: ...
    def setThreadPool(self, pool:PySide6.QtCore.QThreadPool) -> None: ...
    def setThrottled(self, enable:bool) -> None: ...
    def suspendIfRequested(self) -> None: ...
    def swap(self, other:PySide6.QtCore.QFutureInterfaceBase) -> None: ...
    def threadPool(self) -> PySide6.QtCore.QThreadPool: ...
    def togglePaused(self) -> None: ...
    def toggleSuspended(self) -> None: ...
    def waitForFinished(self) -> None: ...
    def waitForNextResult(self) -> bool: ...
    def waitForResult(self, resultIndex:int) -> None: ...
    def waitForResume(self) -> None: ...


class QGenericArgument(Shiboken.Object):

    @typing.overload
    def __init__(self, QGenericArgument:PySide6.QtCore.QGenericArgument) -> None: ...
    @typing.overload
    def __init__(self, aName:typing.Optional[bytes]=..., aData:typing.Optional[int]=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def data(self) -> int: ...
    def name(self) -> bytes: ...


class QGenericReturnArgument(PySide6.QtCore.QGenericArgument):

    @typing.overload
    def __init__(self, QGenericReturnArgument:PySide6.QtCore.QGenericReturnArgument) -> None: ...
    @typing.overload
    def __init__(self, aName:typing.Optional[bytes]=..., aData:typing.Optional[int]=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QIODevice(PySide6.QtCore.QObject, PySide6.QtCore.QIODeviceBase):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent:PySide6.QtCore.QObject) -> None: ...

    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    def commitTransaction(self) -> None: ...
    def currentReadChannel(self) -> int: ...
    def currentWriteChannel(self) -> int: ...
    def errorString(self) -> str: ...
    def getChar(self, c:bytes) -> bool: ...
    def isOpen(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def isTextModeEnabled(self) -> bool: ...
    def isTransactionStarted(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def open(self, mode:PySide6.QtCore.QIODeviceBase.OpenMode) -> bool: ...
    def openMode(self) -> PySide6.QtCore.QIODeviceBase.OpenMode: ...
    def peek(self, maxlen:int) -> PySide6.QtCore.QByteArray: ...
    def pos(self) -> int: ...
    def putChar(self, c:int) -> bool: ...
    def read(self, maxlen:int) -> PySide6.QtCore.QByteArray: ...
    def readAll(self) -> PySide6.QtCore.QByteArray: ...
    def readChannelCount(self) -> int: ...
    def readData(self, data:bytes, maxlen:int) -> int: ...
    def readLine(self, maxlen:int=...) -> PySide6.QtCore.QByteArray: ...
    def readLineData(self, data:bytes, maxlen:int) -> int: ...
    def reset(self) -> bool: ...
    def rollbackTransaction(self) -> None: ...
    def seek(self, pos:int) -> bool: ...
    def setCurrentReadChannel(self, channel:int) -> None: ...
    def setCurrentWriteChannel(self, channel:int) -> None: ...
    def setErrorString(self, errorString:str) -> None: ...
    def setOpenMode(self, openMode:PySide6.QtCore.QIODeviceBase.OpenMode) -> None: ...
    def setTextModeEnabled(self, enabled:bool) -> None: ...
    def size(self) -> int: ...
    def skip(self, maxSize:int) -> int: ...
    def skipData(self, maxSize:int) -> int: ...
    def startTransaction(self) -> None: ...
    def ungetChar(self, c:int) -> None: ...
    def waitForBytesWritten(self, msecs:int) -> bool: ...
    def waitForReadyRead(self, msecs:int) -> bool: ...
    def write(self, data:PySide6.QtCore.QByteArray) -> int: ...
    def writeChannelCount(self) -> int: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QIODeviceBase(Shiboken.Object):
    NotOpen                  : QIODeviceBase = ... # 0x0
    ReadOnly                 : QIODeviceBase = ... # 0x1
    WriteOnly                : QIODeviceBase = ... # 0x2
    ReadWrite                : QIODeviceBase = ... # 0x3
    Append                   : QIODeviceBase = ... # 0x4
    Truncate                 : QIODeviceBase = ... # 0x8
    Text                     : QIODeviceBase = ... # 0x10
    Unbuffered               : QIODeviceBase = ... # 0x20
    NewOnly                  : QIODeviceBase = ... # 0x40
    ExistingOnly             : QIODeviceBase = ... # 0x80

    class OpenMode(object): ...

    class OpenModeFlag(object):
        NotOpen                  : QIODeviceBase.OpenModeFlag = ... # 0x0
        ReadOnly                 : QIODeviceBase.OpenModeFlag = ... # 0x1
        WriteOnly                : QIODeviceBase.OpenModeFlag = ... # 0x2
        ReadWrite                : QIODeviceBase.OpenModeFlag = ... # 0x3
        Append                   : QIODeviceBase.OpenModeFlag = ... # 0x4
        Truncate                 : QIODeviceBase.OpenModeFlag = ... # 0x8
        Text                     : QIODeviceBase.OpenModeFlag = ... # 0x10
        Unbuffered               : QIODeviceBase.OpenModeFlag = ... # 0x20
        NewOnly                  : QIODeviceBase.OpenModeFlag = ... # 0x40
        ExistingOnly             : QIODeviceBase.OpenModeFlag = ... # 0x80

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QIODeviceBase:PySide6.QtCore.QIODeviceBase) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QIdentityProxyModel(PySide6.QtCore.QAbstractProxyModel):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def columnCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def dropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def headerData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def index(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def insertRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def mapFromSource(self, sourceIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, selection:PySide6.QtCore.QItemSelection) -> PySide6.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, selection:PySide6.QtCore.QItemSelection) -> PySide6.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def match(self, start:PySide6.QtCore.QModelIndex, role:int, value:typing.Any, hits:int=..., flags:PySide6.QtCore.Qt.MatchFlags=...) -> typing.List: ...
    def moveColumns(self, sourceParent:PySide6.QtCore.QModelIndex, sourceColumn:int, count:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    def moveRows(self, sourceParent:PySide6.QtCore.QModelIndex, sourceRow:int, count:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def removeRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def rowCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def setSourceModel(self, sourceModel:PySide6.QtCore.QAbstractItemModel) -> None: ...
    def sibling(self, row:int, column:int, idx:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...


class QItemSelection(Shiboken.Object):

    @typing.overload
    def __init__(self, QItemSelection:PySide6.QtCore.QItemSelection) -> None: ...
    @typing.overload
    def __init__(self, topLeft:PySide6.QtCore.QModelIndex, bottomRight:PySide6.QtCore.QModelIndex) -> None: ...

    def __add__(self, l:typing.Sequence) -> typing.List: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, l:typing.Sequence) -> typing.List: ...
    def __lshift__(self, l:typing.Sequence) -> typing.List: ...
    @typing.overload
    def append(self, arg__1:PySide6.QtCore.QItemSelectionRange) -> None: ...
    @typing.overload
    def append(self, l:typing.Sequence) -> None: ...
    def at(self, i:int) -> PySide6.QtCore.QItemSelectionRange: ...
    def back(self) -> PySide6.QtCore.QItemSelectionRange: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide6.QtCore.QItemSelectionRange: ...
    def constFirst(self) -> PySide6.QtCore.QItemSelectionRange: ...
    def constLast(self) -> PySide6.QtCore.QItemSelectionRange: ...
    def contains(self, index:PySide6.QtCore.QModelIndex) -> bool: ...
    def count(self) -> int: ...
    def data(self) -> PySide6.QtCore.QItemSelectionRange: ...
    def empty(self) -> bool: ...
    @typing.overload
    def first(self) -> PySide6.QtCore.QItemSelectionRange: ...
    @typing.overload
    def first(self, n:int) -> typing.List: ...
    @staticmethod
    def fromList(list:typing.Sequence) -> typing.List: ...
    @staticmethod
    def fromVector(vector:typing.Sequence) -> typing.List: ...
    def front(self) -> PySide6.QtCore.QItemSelectionRange: ...
    def indexes(self) -> typing.List: ...
    def insert(self, arg__1:int, arg__2:PySide6.QtCore.QItemSelectionRange) -> None: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other:typing.Sequence) -> bool: ...
    @typing.overload
    def last(self) -> PySide6.QtCore.QItemSelectionRange: ...
    @typing.overload
    def last(self, n:int) -> typing.List: ...
    def length(self) -> int: ...
    def merge(self, other:PySide6.QtCore.QItemSelection, command:PySide6.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def mid(self, pos:int, len:int=...) -> typing.List: ...
    def move(self, from_:int, to:int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, arg__1:PySide6.QtCore.QItemSelectionRange) -> None: ...
    def push_back(self, arg__1:PySide6.QtCore.QItemSelectionRange) -> None: ...
    def push_front(self, arg__1:PySide6.QtCore.QItemSelectionRange) -> None: ...
    def remove(self, i:int, n:int=...) -> None: ...
    def removeAll(self, arg__1:PySide6.QtCore.QItemSelectionRange) -> None: ...
    def removeAt(self, i:int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, arg__1:PySide6.QtCore.QItemSelectionRange) -> None: ...
    def reserve(self, size:int) -> None: ...
    def resize(self, size:int) -> None: ...
    def select(self, topLeft:PySide6.QtCore.QModelIndex, bottomRight:PySide6.QtCore.QModelIndex) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    @typing.overload
    def sliced(self, pos:int) -> typing.List: ...
    @typing.overload
    def sliced(self, pos:int, n:int) -> typing.List: ...
    @staticmethod
    def split(range:PySide6.QtCore.QItemSelectionRange, other:PySide6.QtCore.QItemSelectionRange, result:PySide6.QtCore.QItemSelection) -> None: ...
    def squeeze(self) -> None: ...
    def swap(self, other:typing.Sequence) -> None: ...
    def swapItemsAt(self, i:int, j:int) -> None: ...
    def takeAt(self, i:int) -> PySide6.QtCore.QItemSelectionRange: ...
    def toList(self) -> typing.List: ...
    def toVector(self) -> typing.List: ...
    def value(self, i:int) -> PySide6.QtCore.QItemSelectionRange: ...


class QItemSelectionModel(PySide6.QtCore.QObject):
    NoUpdate                 : QItemSelectionModel = ... # 0x0
    Clear                    : QItemSelectionModel = ... # 0x1
    Select                   : QItemSelectionModel = ... # 0x2
    ClearAndSelect           : QItemSelectionModel = ... # 0x3
    Deselect                 : QItemSelectionModel = ... # 0x4
    Toggle                   : QItemSelectionModel = ... # 0x8
    Current                  : QItemSelectionModel = ... # 0x10
    SelectCurrent            : QItemSelectionModel = ... # 0x12
    ToggleCurrent            : QItemSelectionModel = ... # 0x18
    Rows                     : QItemSelectionModel = ... # 0x20
    Columns                  : QItemSelectionModel = ... # 0x40

    class SelectionFlag(object):
        NoUpdate                 : QItemSelectionModel.SelectionFlag = ... # 0x0
        Clear                    : QItemSelectionModel.SelectionFlag = ... # 0x1
        Select                   : QItemSelectionModel.SelectionFlag = ... # 0x2
        ClearAndSelect           : QItemSelectionModel.SelectionFlag = ... # 0x3
        Deselect                 : QItemSelectionModel.SelectionFlag = ... # 0x4
        Toggle                   : QItemSelectionModel.SelectionFlag = ... # 0x8
        Current                  : QItemSelectionModel.SelectionFlag = ... # 0x10
        SelectCurrent            : QItemSelectionModel.SelectionFlag = ... # 0x12
        ToggleCurrent            : QItemSelectionModel.SelectionFlag = ... # 0x18
        Rows                     : QItemSelectionModel.SelectionFlag = ... # 0x20
        Columns                  : QItemSelectionModel.SelectionFlag = ... # 0x40

    class SelectionFlags(object): ...

    @typing.overload
    def __init__(self, model:PySide6.QtCore.QAbstractItemModel, parent:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, model:typing.Optional[PySide6.QtCore.QAbstractItemModel]=...) -> None: ...

    def clear(self) -> None: ...
    def clearCurrentIndex(self) -> None: ...
    def clearSelection(self) -> None: ...
    def columnIntersectsSelection(self, column:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def currentIndex(self) -> PySide6.QtCore.QModelIndex: ...
    def emitSelectionChanged(self, newSelection:PySide6.QtCore.QItemSelection, oldSelection:PySide6.QtCore.QItemSelection) -> None: ...
    def hasSelection(self) -> bool: ...
    def isColumnSelected(self, column:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def isRowSelected(self, row:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def isSelected(self, index:PySide6.QtCore.QModelIndex) -> bool: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def reset(self) -> None: ...
    def rowIntersectsSelection(self, row:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    @typing.overload
    def select(self, index:PySide6.QtCore.QModelIndex, command:PySide6.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    @typing.overload
    def select(self, selection:PySide6.QtCore.QItemSelection, command:PySide6.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def selectedColumns(self, row:int=...) -> typing.List: ...
    def selectedIndexes(self) -> typing.List: ...
    def selectedRows(self, column:int=...) -> typing.List: ...
    def selection(self) -> PySide6.QtCore.QItemSelection: ...
    def setCurrentIndex(self, index:PySide6.QtCore.QModelIndex, command:PySide6.QtCore.QItemSelectionModel.SelectionFlags) -> None: ...
    def setModel(self, model:PySide6.QtCore.QAbstractItemModel) -> None: ...


class QItemSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QItemSelectionRange:PySide6.QtCore.QItemSelectionRange) -> None: ...
    @typing.overload
    def __init__(self, index:PySide6.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def __init__(self, topL:PySide6.QtCore.QModelIndex, bottomR:PySide6.QtCore.QModelIndex) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bottom(self) -> int: ...
    def bottomRight(self) -> PySide6.QtCore.QPersistentModelIndex: ...
    @typing.overload
    def contains(self, index:PySide6.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def contains(self, row:int, column:int, parentIndex:PySide6.QtCore.QModelIndex) -> bool: ...
    def height(self) -> int: ...
    def indexes(self) -> typing.List: ...
    def intersected(self, other:PySide6.QtCore.QItemSelectionRange) -> PySide6.QtCore.QItemSelectionRange: ...
    def intersects(self, other:PySide6.QtCore.QItemSelectionRange) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> int: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def parent(self) -> PySide6.QtCore.QModelIndex: ...
    def right(self) -> int: ...
    def swap(self, other:PySide6.QtCore.QItemSelectionRange) -> None: ...
    def top(self) -> int: ...
    def topLeft(self) -> PySide6.QtCore.QPersistentModelIndex: ...
    def width(self) -> int: ...


class QJsonArray(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QJsonArray) -> None: ...

    def __add__(self, v:PySide6.QtCore.QJsonValue) -> PySide6.QtCore.QJsonArray: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, v:PySide6.QtCore.QJsonValue) -> PySide6.QtCore.QJsonArray: ...
    def __lshift__(self, v:PySide6.QtCore.QJsonValue) -> PySide6.QtCore.QJsonArray: ...
    def append(self, value:PySide6.QtCore.QJsonValue) -> None: ...
    def at(self, i:int) -> PySide6.QtCore.QJsonValue: ...
    def contains(self, element:PySide6.QtCore.QJsonValue) -> bool: ...
    def count(self) -> int: ...
    def empty(self) -> bool: ...
    def first(self) -> PySide6.QtCore.QJsonValue: ...
    @staticmethod
    def fromStringList(list:typing.Sequence) -> PySide6.QtCore.QJsonArray: ...
    @staticmethod
    def fromVariantList(list:typing.Sequence) -> PySide6.QtCore.QJsonArray: ...
    def insert(self, i:int, value:PySide6.QtCore.QJsonValue) -> None: ...
    def isEmpty(self) -> bool: ...
    def last(self) -> PySide6.QtCore.QJsonValue: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, value:PySide6.QtCore.QJsonValue) -> None: ...
    def push_back(self, t:PySide6.QtCore.QJsonValue) -> None: ...
    def push_front(self, t:PySide6.QtCore.QJsonValue) -> None: ...
    def removeAt(self, i:int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def replace(self, i:int, value:PySide6.QtCore.QJsonValue) -> None: ...
    def size(self) -> int: ...
    def swap(self, other:PySide6.QtCore.QJsonArray) -> None: ...
    def takeAt(self, i:int) -> PySide6.QtCore.QJsonValue: ...
    def toVariantList(self) -> typing.List: ...


class QJsonDocument(Shiboken.Object):
    Indented                 : QJsonDocument = ... # 0x0
    Compact                  : QJsonDocument = ... # 0x1

    class JsonFormat(object):
        Indented                 : QJsonDocument.JsonFormat = ... # 0x0
        Compact                  : QJsonDocument.JsonFormat = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, array:PySide6.QtCore.QJsonArray) -> None: ...
    @typing.overload
    def __init__(self, object:typing.Dict) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QJsonDocument) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def array(self) -> PySide6.QtCore.QJsonArray: ...
    @staticmethod
    def fromJson(json:PySide6.QtCore.QByteArray, error:typing.Optional[PySide6.QtCore.QJsonParseError]=...) -> PySide6.QtCore.QJsonDocument: ...
    @staticmethod
    def fromVariant(variant:typing.Any) -> PySide6.QtCore.QJsonDocument: ...
    def isArray(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isObject(self) -> bool: ...
    def object(self) -> typing.Dict: ...
    def setArray(self, array:PySide6.QtCore.QJsonArray) -> None: ...
    def setObject(self, object:typing.Dict) -> None: ...
    def swap(self, other:PySide6.QtCore.QJsonDocument) -> None: ...
    def toJson(self, format:PySide6.QtCore.QJsonDocument.JsonFormat=...) -> PySide6.QtCore.QByteArray: ...
    def toVariant(self) -> typing.Any: ...


class QJsonParseError(Shiboken.Object):
    NoError                  : QJsonParseError = ... # 0x0
    UnterminatedObject       : QJsonParseError = ... # 0x1
    MissingNameSeparator     : QJsonParseError = ... # 0x2
    UnterminatedArray        : QJsonParseError = ... # 0x3
    MissingValueSeparator    : QJsonParseError = ... # 0x4
    IllegalValue             : QJsonParseError = ... # 0x5
    TerminationByNumber      : QJsonParseError = ... # 0x6
    IllegalNumber            : QJsonParseError = ... # 0x7
    IllegalEscapeSequence    : QJsonParseError = ... # 0x8
    IllegalUTF8String        : QJsonParseError = ... # 0x9
    UnterminatedString       : QJsonParseError = ... # 0xa
    MissingObject            : QJsonParseError = ... # 0xb
    DeepNesting              : QJsonParseError = ... # 0xc
    DocumentTooLarge         : QJsonParseError = ... # 0xd
    GarbageAtEnd             : QJsonParseError = ... # 0xe

    class ParseError(object):
        NoError                  : QJsonParseError.ParseError = ... # 0x0
        UnterminatedObject       : QJsonParseError.ParseError = ... # 0x1
        MissingNameSeparator     : QJsonParseError.ParseError = ... # 0x2
        UnterminatedArray        : QJsonParseError.ParseError = ... # 0x3
        MissingValueSeparator    : QJsonParseError.ParseError = ... # 0x4
        IllegalValue             : QJsonParseError.ParseError = ... # 0x5
        TerminationByNumber      : QJsonParseError.ParseError = ... # 0x6
        IllegalNumber            : QJsonParseError.ParseError = ... # 0x7
        IllegalEscapeSequence    : QJsonParseError.ParseError = ... # 0x8
        IllegalUTF8String        : QJsonParseError.ParseError = ... # 0x9
        UnterminatedString       : QJsonParseError.ParseError = ... # 0xa
        MissingObject            : QJsonParseError.ParseError = ... # 0xb
        DeepNesting              : QJsonParseError.ParseError = ... # 0xc
        DocumentTooLarge         : QJsonParseError.ParseError = ... # 0xd
        GarbageAtEnd             : QJsonParseError.ParseError = ... # 0xe

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QJsonParseError:PySide6.QtCore.QJsonParseError) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def errorString(self) -> str: ...


class QJsonValue(Shiboken.Object):
    Null                     : QJsonValue = ... # 0x0
    Bool                     : QJsonValue = ... # 0x1
    Double                   : QJsonValue = ... # 0x2
    String                   : QJsonValue = ... # 0x3
    Array                    : QJsonValue = ... # 0x4
    Object                   : QJsonValue = ... # 0x5
    Undefined                : QJsonValue = ... # 0x80

    class Type(object):
        Null                     : QJsonValue.Type = ... # 0x0
        Bool                     : QJsonValue.Type = ... # 0x1
        Double                   : QJsonValue.Type = ... # 0x2
        String                   : QJsonValue.Type = ... # 0x3
        Array                    : QJsonValue.Type = ... # 0x4
        Object                   : QJsonValue.Type = ... # 0x5
        Undefined                : QJsonValue.Type = ... # 0x80

    @typing.overload
    def __init__(self, a:PySide6.QtCore.QJsonArray) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QJsonValue.Type=...) -> None: ...
    @typing.overload
    def __init__(self, b:bool) -> None: ...
    @typing.overload
    def __init__(self, n:float) -> None: ...
    @typing.overload
    def __init__(self, n:int) -> None: ...
    @typing.overload
    def __init__(self, o:typing.Dict) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QJsonValue) -> None: ...
    @typing.overload
    def __init__(self, s:str) -> None: ...
    @typing.overload
    def __init__(self, s:bytes) -> None: ...
    @typing.overload
    def __init__(self, v:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromVariant(variant:typing.Any) -> PySide6.QtCore.QJsonValue: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isObject(self) -> bool: ...
    def isString(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def swap(self, other:PySide6.QtCore.QJsonValue) -> None: ...
    @typing.overload
    def toArray(self) -> PySide6.QtCore.QJsonArray: ...
    @typing.overload
    def toArray(self, defaultValue:PySide6.QtCore.QJsonArray) -> PySide6.QtCore.QJsonArray: ...
    def toBool(self, defaultValue:bool=...) -> bool: ...
    def toDouble(self, defaultValue:float=...) -> float: ...
    def toInt(self, defaultValue:int=...) -> int: ...
    def toInteger(self, defaultValue:int=...) -> int: ...
    @typing.overload
    def toObject(self) -> typing.Dict: ...
    @typing.overload
    def toObject(self, defaultValue:typing.Dict) -> typing.Dict: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    def toString(self, defaultValue:str) -> str: ...
    def toVariant(self) -> typing.Any: ...
    def type(self) -> PySide6.QtCore.QJsonValue.Type: ...


class QLibraryInfo(Shiboken.Object):
    PrefixPath               : QLibraryInfo = ... # 0x0
    DocumentationPath        : QLibraryInfo = ... # 0x1
    HeadersPath              : QLibraryInfo = ... # 0x2
    LibrariesPath            : QLibraryInfo = ... # 0x3
    LibraryExecutablesPath   : QLibraryInfo = ... # 0x4
    BinariesPath             : QLibraryInfo = ... # 0x5
    PluginsPath              : QLibraryInfo = ... # 0x6
    Qml2ImportsPath          : QLibraryInfo = ... # 0x7
    ArchDataPath             : QLibraryInfo = ... # 0x8
    DataPath                 : QLibraryInfo = ... # 0x9
    TranslationsPath         : QLibraryInfo = ... # 0xa
    ExamplesPath             : QLibraryInfo = ... # 0xb
    TestsPath                : QLibraryInfo = ... # 0xc
    SettingsPath             : QLibraryInfo = ... # 0x64

    class LibraryPath(object):
        PrefixPath               : QLibraryInfo.LibraryPath = ... # 0x0
        DocumentationPath        : QLibraryInfo.LibraryPath = ... # 0x1
        HeadersPath              : QLibraryInfo.LibraryPath = ... # 0x2
        LibrariesPath            : QLibraryInfo.LibraryPath = ... # 0x3
        LibraryExecutablesPath   : QLibraryInfo.LibraryPath = ... # 0x4
        BinariesPath             : QLibraryInfo.LibraryPath = ... # 0x5
        PluginsPath              : QLibraryInfo.LibraryPath = ... # 0x6
        Qml2ImportsPath          : QLibraryInfo.LibraryPath = ... # 0x7
        ArchDataPath             : QLibraryInfo.LibraryPath = ... # 0x8
        DataPath                 : QLibraryInfo.LibraryPath = ... # 0x9
        TranslationsPath         : QLibraryInfo.LibraryPath = ... # 0xa
        ExamplesPath             : QLibraryInfo.LibraryPath = ... # 0xb
        TestsPath                : QLibraryInfo.LibraryPath = ... # 0xc
        SettingsPath             : QLibraryInfo.LibraryPath = ... # 0x64
    @staticmethod
    def build() -> bytes: ...
    @staticmethod
    def isDebugBuild() -> bool: ...
    @staticmethod
    def location(location:PySide6.QtCore.QLibraryInfo.LibraryPath) -> str: ...
    @staticmethod
    def path(p:PySide6.QtCore.QLibraryInfo.LibraryPath) -> str: ...
    @staticmethod
    def platformPluginArguments(platformName:str) -> typing.List: ...
    @staticmethod
    def version() -> PySide6.QtCore.QVersionNumber: ...


class QLine(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QLine:PySide6.QtCore.QLine) -> None: ...
    @typing.overload
    def __init__(self, pt1:PySide6.QtCore.QPoint, pt2:PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, x1:int, y1:int, x2:int, y2:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def center(self) -> PySide6.QtCore.QPoint: ...
    def dx(self) -> int: ...
    def dy(self) -> int: ...
    def isNull(self) -> bool: ...
    def p1(self) -> PySide6.QtCore.QPoint: ...
    def p2(self) -> PySide6.QtCore.QPoint: ...
    def setLine(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def setP1(self, p1:PySide6.QtCore.QPoint) -> None: ...
    def setP2(self, p2:PySide6.QtCore.QPoint) -> None: ...
    def setPoints(self, p1:PySide6.QtCore.QPoint, p2:PySide6.QtCore.QPoint) -> None: ...
    def toTuple(self) -> object: ...
    @typing.overload
    def translate(self, dx:int, dy:int) -> None: ...
    @typing.overload
    def translate(self, p:PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def translated(self, dx:int, dy:int) -> PySide6.QtCore.QLine: ...
    @typing.overload
    def translated(self, p:PySide6.QtCore.QPoint) -> PySide6.QtCore.QLine: ...
    def x1(self) -> int: ...
    def x2(self) -> int: ...
    def y1(self) -> int: ...
    def y2(self) -> int: ...


class QLineF(Shiboken.Object):
    NoIntersection           : QLineF = ... # 0x0
    BoundedIntersection      : QLineF = ... # 0x1
    UnboundedIntersection    : QLineF = ... # 0x2

    class IntersectionType(object):
        NoIntersection           : QLineF.IntersectionType = ... # 0x0
        BoundedIntersection      : QLineF.IntersectionType = ... # 0x1
        UnboundedIntersection    : QLineF.IntersectionType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QLineF:PySide6.QtCore.QLineF) -> None: ...
    @typing.overload
    def __init__(self, line:PySide6.QtCore.QLine) -> None: ...
    @typing.overload
    def __init__(self, pt1:PySide6.QtCore.QPointF, pt2:PySide6.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, x1:float, y1:float, x2:float, y2:float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def angle(self) -> float: ...
    def angleTo(self, l:PySide6.QtCore.QLineF) -> float: ...
    def center(self) -> PySide6.QtCore.QPointF: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @staticmethod
    def fromPolar(length:float, angle:float) -> PySide6.QtCore.QLineF: ...
    def intersects(self, l:PySide6.QtCore.QLineF, intersectionPoint:typing.Optional[PySide6.QtCore.QPointF]=...) -> PySide6.QtCore.QLineF.IntersectionType: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def normalVector(self) -> PySide6.QtCore.QLineF: ...
    def p1(self) -> PySide6.QtCore.QPointF: ...
    def p2(self) -> PySide6.QtCore.QPointF: ...
    def pointAt(self, t:float) -> PySide6.QtCore.QPointF: ...
    def setAngle(self, angle:float) -> None: ...
    def setLength(self, len:float) -> None: ...
    def setLine(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def setP1(self, p1:PySide6.QtCore.QPointF) -> None: ...
    def setP2(self, p2:PySide6.QtCore.QPointF) -> None: ...
    def setPoints(self, p1:PySide6.QtCore.QPointF, p2:PySide6.QtCore.QPointF) -> None: ...
    def toLine(self) -> PySide6.QtCore.QLine: ...
    def toTuple(self) -> object: ...
    @typing.overload
    def translate(self, dx:float, dy:float) -> None: ...
    @typing.overload
    def translate(self, p:PySide6.QtCore.QPointF) -> None: ...
    @typing.overload
    def translated(self, dx:float, dy:float) -> PySide6.QtCore.QLineF: ...
    @typing.overload
    def translated(self, p:PySide6.QtCore.QPointF) -> PySide6.QtCore.QLineF: ...
    def unitVector(self) -> PySide6.QtCore.QLineF: ...
    def x1(self) -> float: ...
    def x2(self) -> float: ...
    def y1(self) -> float: ...
    def y2(self) -> float: ...


class QLocale(Shiboken.Object):
    FloatingPointShortest    : QLocale = ... # -0x80
    AnyCountry               : QLocale = ... # 0x0
    AnyLanguage              : QLocale = ... # 0x0
    AnyScript                : QLocale = ... # 0x0
    CurrencyIsoCode          : QLocale = ... # 0x0
    DataSizeIecFormat        : QLocale = ... # 0x0
    DefaultNumberOptions     : QLocale = ... # 0x0
    LongFormat               : QLocale = ... # 0x0
    MetricSystem             : QLocale = ... # 0x0
    StandardQuotation        : QLocale = ... # 0x0
    AdlamScript              : QLocale = ... # 0x1
    Afghanistan              : QLocale = ... # 0x1
    AlternateQuotation       : QLocale = ... # 0x1
    C                        : QLocale = ... # 0x1
    CurrencySymbol           : QLocale = ... # 0x1
    DataSizeBase1000         : QLocale = ... # 0x1
    ImperialSystem           : QLocale = ... # 0x1
    ImperialUSSystem         : QLocale = ... # 0x1
    OmitGroupSeparator       : QLocale = ... # 0x1
    ShortFormat              : QLocale = ... # 0x1
    Abkhazian                : QLocale = ... # 0x2
    AhomScript               : QLocale = ... # 0x2
    AlandIslands             : QLocale = ... # 0x2
    CurrencyDisplayName      : QLocale = ... # 0x2
    DataSizeSIQuantifiers    : QLocale = ... # 0x2
    DataSizeTraditionalFormat: QLocale = ... # 0x2
    ImperialUKSystem         : QLocale = ... # 0x2
    NarrowFormat             : QLocale = ... # 0x2
    RejectGroupSeparator     : QLocale = ... # 0x2
    Afar                     : QLocale = ... # 0x3
    Albania                  : QLocale = ... # 0x3
    AnatolianHieroglyphsScript: QLocale = ... # 0x3
    DataSizeSIFormat         : QLocale = ... # 0x3
    Afrikaans                : QLocale = ... # 0x4
    Algeria                  : QLocale = ... # 0x4
    ArabicScript             : QLocale = ... # 0x4
    OmitLeadingZeroInExponent: QLocale = ... # 0x4
    Aghem                    : QLocale = ... # 0x5
    AmericanSamoa            : QLocale = ... # 0x5
    ArmenianScript           : QLocale = ... # 0x5
    Akan                     : QLocale = ... # 0x6
    Andorra                  : QLocale = ... # 0x6
    AvestanScript            : QLocale = ... # 0x6
    Akkadian                 : QLocale = ... # 0x7
    Angola                   : QLocale = ... # 0x7
    BalineseScript           : QLocale = ... # 0x7
    Akoose                   : QLocale = ... # 0x8
    Anguilla                 : QLocale = ... # 0x8
    BamumScript              : QLocale = ... # 0x8
    RejectLeadingZeroInExponent: QLocale = ... # 0x8
    Albanian                 : QLocale = ... # 0x9
    Antarctica               : QLocale = ... # 0x9
    BanglaScript             : QLocale = ... # 0x9
    BengaliScript            : QLocale = ... # 0x9
    AmericanSignLanguage     : QLocale = ... # 0xa
    AntiguaAndBarbuda        : QLocale = ... # 0xa
    BassaVahScript           : QLocale = ... # 0xa
    Amharic                  : QLocale = ... # 0xb
    Argentina                : QLocale = ... # 0xb
    BatakScript              : QLocale = ... # 0xb
    AncientEgyptian          : QLocale = ... # 0xc
    Armenia                  : QLocale = ... # 0xc
    BhaiksukiScript          : QLocale = ... # 0xc
    AncientGreek             : QLocale = ... # 0xd
    Aruba                    : QLocale = ... # 0xd
    BopomofoScript           : QLocale = ... # 0xd
    Arabic                   : QLocale = ... # 0xe
    AscensionIsland          : QLocale = ... # 0xe
    BrahmiScript             : QLocale = ... # 0xe
    Aragonese                : QLocale = ... # 0xf
    Australia                : QLocale = ... # 0xf
    BrailleScript            : QLocale = ... # 0xf
    Aramaic                  : QLocale = ... # 0x10
    Austria                  : QLocale = ... # 0x10
    BugineseScript           : QLocale = ... # 0x10
    IncludeTrailingZeroesAfterDot: QLocale = ... # 0x10
    Armenian                 : QLocale = ... # 0x11
    Azerbaijan               : QLocale = ... # 0x11
    BuhidScript              : QLocale = ... # 0x11
    Assamese                 : QLocale = ... # 0x12
    Bahamas                  : QLocale = ... # 0x12
    CanadianAboriginalScript : QLocale = ... # 0x12
    Asturian                 : QLocale = ... # 0x13
    Bahrain                  : QLocale = ... # 0x13
    CarianScript             : QLocale = ... # 0x13
    Asu                      : QLocale = ... # 0x14
    Bangladesh               : QLocale = ... # 0x14
    CaucasianAlbanianScript  : QLocale = ... # 0x14
    Atsam                    : QLocale = ... # 0x15
    Barbados                 : QLocale = ... # 0x15
    ChakmaScript             : QLocale = ... # 0x15
    Avaric                   : QLocale = ... # 0x16
    Belarus                  : QLocale = ... # 0x16
    ChamScript               : QLocale = ... # 0x16
    Avestan                  : QLocale = ... # 0x17
    Belgium                  : QLocale = ... # 0x17
    CherokeeScript           : QLocale = ... # 0x17
    Aymara                   : QLocale = ... # 0x18
    Belize                   : QLocale = ... # 0x18
    CopticScript             : QLocale = ... # 0x18
    Azerbaijani              : QLocale = ... # 0x19
    Benin                    : QLocale = ... # 0x19
    CuneiformScript          : QLocale = ... # 0x19
    Bafia                    : QLocale = ... # 0x1a
    Bermuda                  : QLocale = ... # 0x1a
    CypriotScript            : QLocale = ... # 0x1a
    Balinese                 : QLocale = ... # 0x1b
    Bhutan                   : QLocale = ... # 0x1b
    CyrillicScript           : QLocale = ... # 0x1b
    Bambara                  : QLocale = ... # 0x1c
    Bolivia                  : QLocale = ... # 0x1c
    DeseretScript            : QLocale = ... # 0x1c
    Bamun                    : QLocale = ... # 0x1d
    BosniaAndHerzegovina     : QLocale = ... # 0x1d
    BosniaAndHerzegowina     : QLocale = ... # 0x1d
    DevanagariScript         : QLocale = ... # 0x1d
    Bangla                   : QLocale = ... # 0x1e
    Bengali                  : QLocale = ... # 0x1e
    Botswana                 : QLocale = ... # 0x1e
    DuployanScript           : QLocale = ... # 0x1e
    Basaa                    : QLocale = ... # 0x1f
    BouvetIsland             : QLocale = ... # 0x1f
    EgyptianHieroglyphsScript: QLocale = ... # 0x1f
    Bashkir                  : QLocale = ... # 0x20
    Brazil                   : QLocale = ... # 0x20
    ElbasanScript            : QLocale = ... # 0x20
    RejectTrailingZeroesAfterDot: QLocale = ... # 0x20
    Basque                   : QLocale = ... # 0x21
    BritishIndianOceanTerritory: QLocale = ... # 0x21
    EthiopicScript           : QLocale = ... # 0x21
    BatakToba                : QLocale = ... # 0x22
    BritishVirginIslands     : QLocale = ... # 0x22
    FraserScript             : QLocale = ... # 0x22
    Belarusian               : QLocale = ... # 0x23
    Brunei                   : QLocale = ... # 0x23
    Byelorussian             : QLocale = ... # 0x23
    GeorgianScript           : QLocale = ... # 0x23
    Bemba                    : QLocale = ... # 0x24
    Bulgaria                 : QLocale = ... # 0x24
    GlagoliticScript         : QLocale = ... # 0x24
    Bena                     : QLocale = ... # 0x25
    BurkinaFaso              : QLocale = ... # 0x25
    GothicScript             : QLocale = ... # 0x25
    Bhojpuri                 : QLocale = ... # 0x26
    Burundi                  : QLocale = ... # 0x26
    GranthaScript            : QLocale = ... # 0x26
    Bislama                  : QLocale = ... # 0x27
    Cambodia                 : QLocale = ... # 0x27
    GreekScript              : QLocale = ... # 0x27
    Blin                     : QLocale = ... # 0x28
    Cameroon                 : QLocale = ... # 0x28
    GujaratiScript           : QLocale = ... # 0x28
    Bodo                     : QLocale = ... # 0x29
    Canada                   : QLocale = ... # 0x29
    GurmukhiScript           : QLocale = ... # 0x29
    Bosnian                  : QLocale = ... # 0x2a
    CanaryIslands            : QLocale = ... # 0x2a
    HangulScript             : QLocale = ... # 0x2a
    Breton                   : QLocale = ... # 0x2b
    CapeVerde                : QLocale = ... # 0x2b
    HanScript                : QLocale = ... # 0x2b
    Bonaire                  : QLocale = ... # 0x2c
    Buginese                 : QLocale = ... # 0x2c
    CaribbeanNetherlands     : QLocale = ... # 0x2c
    HanunooScript            : QLocale = ... # 0x2c
    Bulgarian                : QLocale = ... # 0x2d
    CaymanIslands            : QLocale = ... # 0x2d
    HanWithBopomofoScript    : QLocale = ... # 0x2d
    Burmese                  : QLocale = ... # 0x2e
    CentralAfricanRepublic   : QLocale = ... # 0x2e
    HatranScript             : QLocale = ... # 0x2e
    Cantonese                : QLocale = ... # 0x2f
    CeutaAndMelilla          : QLocale = ... # 0x2f
    HebrewScript             : QLocale = ... # 0x2f
    Catalan                  : QLocale = ... # 0x30
    Chad                     : QLocale = ... # 0x30
    HiraganaScript           : QLocale = ... # 0x30
    Cebuano                  : QLocale = ... # 0x31
    Chile                    : QLocale = ... # 0x31
    ImperialAramaicScript    : QLocale = ... # 0x31
    CentralAtlasTamazight    : QLocale = ... # 0x32
    CentralMoroccoTamazight  : QLocale = ... # 0x32
    China                    : QLocale = ... # 0x32
    InscriptionalPahlaviScript: QLocale = ... # 0x32
    CentralKurdish           : QLocale = ... # 0x33
    ChristmasIsland          : QLocale = ... # 0x33
    InscriptionalParthianScript: QLocale = ... # 0x33
    Chakma                   : QLocale = ... # 0x34
    ClippertonIsland         : QLocale = ... # 0x34
    JamoScript               : QLocale = ... # 0x34
    Chamorro                 : QLocale = ... # 0x35
    CocosIslands             : QLocale = ... # 0x35
    JapaneseScript           : QLocale = ... # 0x35
    Chechen                  : QLocale = ... # 0x36
    Colombia                 : QLocale = ... # 0x36
    JavaneseScript           : QLocale = ... # 0x36
    Cherokee                 : QLocale = ... # 0x37
    Comoros                  : QLocale = ... # 0x37
    KaithiScript             : QLocale = ... # 0x37
    Chickasaw                : QLocale = ... # 0x38
    CongoBrazzaville         : QLocale = ... # 0x38
    KannadaScript            : QLocale = ... # 0x38
    PeoplesRepublicOfCongo   : QLocale = ... # 0x38
    Chiga                    : QLocale = ... # 0x39
    CongoKinshasa            : QLocale = ... # 0x39
    DemocraticRepublicOfCongo: QLocale = ... # 0x39
    KatakanaScript           : QLocale = ... # 0x39
    Chinese                  : QLocale = ... # 0x3a
    CookIslands              : QLocale = ... # 0x3a
    KayahLiScript            : QLocale = ... # 0x3a
    Church                   : QLocale = ... # 0x3b
    CostaRica                : QLocale = ... # 0x3b
    KharoshthiScript         : QLocale = ... # 0x3b
    Chuvash                  : QLocale = ... # 0x3c
    Croatia                  : QLocale = ... # 0x3c
    KhmerScript              : QLocale = ... # 0x3c
    Colognian                : QLocale = ... # 0x3d
    Cuba                     : QLocale = ... # 0x3d
    KhojkiScript             : QLocale = ... # 0x3d
    Coptic                   : QLocale = ... # 0x3e
    CuraSao                  : QLocale = ... # 0x3e
    Curacao                  : QLocale = ... # 0x3e
    KhudawadiScript          : QLocale = ... # 0x3e
    Cornish                  : QLocale = ... # 0x3f
    Cyprus                   : QLocale = ... # 0x3f
    KoreanScript             : QLocale = ... # 0x3f
    Corsican                 : QLocale = ... # 0x40
    CzechRepublic            : QLocale = ... # 0x40
    Czechia                  : QLocale = ... # 0x40
    LannaScript              : QLocale = ... # 0x40
    Cree                     : QLocale = ... # 0x41
    Denmark                  : QLocale = ... # 0x41
    LaoScript                : QLocale = ... # 0x41
    Croatian                 : QLocale = ... # 0x42
    DiegoGarcia              : QLocale = ... # 0x42
    LatinScript              : QLocale = ... # 0x42
    Czech                    : QLocale = ... # 0x43
    Djibouti                 : QLocale = ... # 0x43
    LepchaScript             : QLocale = ... # 0x43
    Danish                   : QLocale = ... # 0x44
    Dominica                 : QLocale = ... # 0x44
    LimbuScript              : QLocale = ... # 0x44
    Divehi                   : QLocale = ... # 0x45
    DominicanRepublic        : QLocale = ... # 0x45
    LinearAScript            : QLocale = ... # 0x45
    Dogri                    : QLocale = ... # 0x46
    Ecuador                  : QLocale = ... # 0x46
    LinearBScript            : QLocale = ... # 0x46
    Duala                    : QLocale = ... # 0x47
    Egypt                    : QLocale = ... # 0x47
    LycianScript             : QLocale = ... # 0x47
    Dutch                    : QLocale = ... # 0x48
    ElSalvador               : QLocale = ... # 0x48
    LydianScript             : QLocale = ... # 0x48
    Bhutani                  : QLocale = ... # 0x49
    Dzongkha                 : QLocale = ... # 0x49
    EquatorialGuinea         : QLocale = ... # 0x49
    MahajaniScript           : QLocale = ... # 0x49
    Embu                     : QLocale = ... # 0x4a
    Eritrea                  : QLocale = ... # 0x4a
    MalayalamScript          : QLocale = ... # 0x4a
    English                  : QLocale = ... # 0x4b
    Estonia                  : QLocale = ... # 0x4b
    MandaeanScript           : QLocale = ... # 0x4b
    Erzya                    : QLocale = ... # 0x4c
    Eswatini                 : QLocale = ... # 0x4c
    ManichaeanScript         : QLocale = ... # 0x4c
    Swaziland                : QLocale = ... # 0x4c
    Esperanto                : QLocale = ... # 0x4d
    Ethiopia                 : QLocale = ... # 0x4d
    MarchenScript            : QLocale = ... # 0x4d
    Estonian                 : QLocale = ... # 0x4e
    Europe                   : QLocale = ... # 0x4e
    MeiteiMayekScript        : QLocale = ... # 0x4e
    EuropeanUnion            : QLocale = ... # 0x4f
    Ewe                      : QLocale = ... # 0x4f
    MendeKikakuiScript       : QLocale = ... # 0x4f
    MendeScript              : QLocale = ... # 0x4f
    Ewondo                   : QLocale = ... # 0x50
    FalklandIslands          : QLocale = ... # 0x50
    MeroiticCursiveScript    : QLocale = ... # 0x50
    FaroeIslands             : QLocale = ... # 0x51
    Faroese                  : QLocale = ... # 0x51
    MeroiticScript           : QLocale = ... # 0x51
    Fiji                     : QLocale = ... # 0x52
    Fijian                   : QLocale = ... # 0x52
    ModiScript               : QLocale = ... # 0x52
    Filipino                 : QLocale = ... # 0x53
    Finland                  : QLocale = ... # 0x53
    MongolianScript          : QLocale = ... # 0x53
    Finnish                  : QLocale = ... # 0x54
    France                   : QLocale = ... # 0x54
    MroScript                : QLocale = ... # 0x54
    French                   : QLocale = ... # 0x55
    FrenchGuiana             : QLocale = ... # 0x55
    MultaniScript            : QLocale = ... # 0x55
    FrenchPolynesia          : QLocale = ... # 0x56
    Friulian                 : QLocale = ... # 0x56
    MyanmarScript            : QLocale = ... # 0x56
    FrenchSouthernTerritories: QLocale = ... # 0x57
    Fulah                    : QLocale = ... # 0x57
    NabataeanScript          : QLocale = ... # 0x57
    Gabon                    : QLocale = ... # 0x58
    Gaelic                   : QLocale = ... # 0x58
    NewaScript               : QLocale = ... # 0x58
    Ga                       : QLocale = ... # 0x59
    Gambia                   : QLocale = ... # 0x59
    NewTaiLueScript          : QLocale = ... # 0x59
    Galician                 : QLocale = ... # 0x5a
    Georgia                  : QLocale = ... # 0x5a
    NkoScript                : QLocale = ... # 0x5a
    Ganda                    : QLocale = ... # 0x5b
    Germany                  : QLocale = ... # 0x5b
    OdiaScript               : QLocale = ... # 0x5b
    OriyaScript              : QLocale = ... # 0x5b
    Geez                     : QLocale = ... # 0x5c
    Ghana                    : QLocale = ... # 0x5c
    OghamScript              : QLocale = ... # 0x5c
    Georgian                 : QLocale = ... # 0x5d
    Gibraltar                : QLocale = ... # 0x5d
    OlChikiScript            : QLocale = ... # 0x5d
    German                   : QLocale = ... # 0x5e
    Greece                   : QLocale = ... # 0x5e
    OldHungarianScript       : QLocale = ... # 0x5e
    Gothic                   : QLocale = ... # 0x5f
    Greenland                : QLocale = ... # 0x5f
    OldItalicScript          : QLocale = ... # 0x5f
    Greek                    : QLocale = ... # 0x60
    Grenada                  : QLocale = ... # 0x60
    OldNorthArabianScript    : QLocale = ... # 0x60
    Guadeloupe               : QLocale = ... # 0x61
    Guarani                  : QLocale = ... # 0x61
    OldPermicScript          : QLocale = ... # 0x61
    Guam                     : QLocale = ... # 0x62
    Gujarati                 : QLocale = ... # 0x62
    OldPersianScript         : QLocale = ... # 0x62
    Guatemala                : QLocale = ... # 0x63
    Gusii                    : QLocale = ... # 0x63
    OldSouthArabianScript    : QLocale = ... # 0x63
    Guernsey                 : QLocale = ... # 0x64
    Haitian                  : QLocale = ... # 0x64
    OrkhonScript             : QLocale = ... # 0x64
    GuineaBissau             : QLocale = ... # 0x65
    Hausa                    : QLocale = ... # 0x65
    OsageScript              : QLocale = ... # 0x65
    Guinea                   : QLocale = ... # 0x66
    Hawaiian                 : QLocale = ... # 0x66
    OsmanyaScript            : QLocale = ... # 0x66
    Guyana                   : QLocale = ... # 0x67
    Hebrew                   : QLocale = ... # 0x67
    PahawhHmongScript        : QLocale = ... # 0x67
    Haiti                    : QLocale = ... # 0x68
    Herero                   : QLocale = ... # 0x68
    PalmyreneScript          : QLocale = ... # 0x68
    HeardAndMcDonaldIslands  : QLocale = ... # 0x69
    Hindi                    : QLocale = ... # 0x69
    PauCinHauScript          : QLocale = ... # 0x69
    HiriMotu                 : QLocale = ... # 0x6a
    Honduras                 : QLocale = ... # 0x6a
    PhagsPaScript            : QLocale = ... # 0x6a
    HongKong                 : QLocale = ... # 0x6b
    Hungarian                : QLocale = ... # 0x6b
    PhoenicianScript         : QLocale = ... # 0x6b
    Hungary                  : QLocale = ... # 0x6c
    Icelandic                : QLocale = ... # 0x6c
    PollardPhoneticScript    : QLocale = ... # 0x6c
    Iceland                  : QLocale = ... # 0x6d
    Ido                      : QLocale = ... # 0x6d
    PsalterPahlaviScript     : QLocale = ... # 0x6d
    Igbo                     : QLocale = ... # 0x6e
    India                    : QLocale = ... # 0x6e
    RejangScript             : QLocale = ... # 0x6e
    InariSami                : QLocale = ... # 0x6f
    Indonesia                : QLocale = ... # 0x6f
    RunicScript              : QLocale = ... # 0x6f
    Indonesian               : QLocale = ... # 0x70
    Iran                     : QLocale = ... # 0x70
    SamaritanScript          : QLocale = ... # 0x70
    Ingush                   : QLocale = ... # 0x71
    Iraq                     : QLocale = ... # 0x71
    SaurashtraScript         : QLocale = ... # 0x71
    Interlingua              : QLocale = ... # 0x72
    Ireland                  : QLocale = ... # 0x72
    SharadaScript            : QLocale = ... # 0x72
    Interlingue              : QLocale = ... # 0x73
    IsleOfMan                : QLocale = ... # 0x73
    ShavianScript            : QLocale = ... # 0x73
    Inuktitut                : QLocale = ... # 0x74
    Israel                   : QLocale = ... # 0x74
    SiddhamScript            : QLocale = ... # 0x74
    Inupiak                  : QLocale = ... # 0x75
    Inupiaq                  : QLocale = ... # 0x75
    Italy                    : QLocale = ... # 0x75
    SignWritingScript        : QLocale = ... # 0x75
    Irish                    : QLocale = ... # 0x76
    IvoryCoast               : QLocale = ... # 0x76
    SimplifiedChineseScript  : QLocale = ... # 0x76
    SimplifiedHanScript      : QLocale = ... # 0x76
    Italian                  : QLocale = ... # 0x77
    Jamaica                  : QLocale = ... # 0x77
    SinhalaScript            : QLocale = ... # 0x77
    Japan                    : QLocale = ... # 0x78
    Japanese                 : QLocale = ... # 0x78
    SoraSompengScript        : QLocale = ... # 0x78
    Javanese                 : QLocale = ... # 0x79
    Jersey                   : QLocale = ... # 0x79
    SundaneseScript          : QLocale = ... # 0x79
    Jju                      : QLocale = ... # 0x7a
    Jordan                   : QLocale = ... # 0x7a
    SylotiNagriScript        : QLocale = ... # 0x7a
    JolaFonyi                : QLocale = ... # 0x7b
    Kazakhstan               : QLocale = ... # 0x7b
    SyriacScript             : QLocale = ... # 0x7b
    Kabuverdianu             : QLocale = ... # 0x7c
    Kenya                    : QLocale = ... # 0x7c
    TagalogScript            : QLocale = ... # 0x7c
    Kabyle                   : QLocale = ... # 0x7d
    Kiribati                 : QLocale = ... # 0x7d
    TagbanwaScript           : QLocale = ... # 0x7d
    Kako                     : QLocale = ... # 0x7e
    Kosovo                   : QLocale = ... # 0x7e
    TaiLeScript              : QLocale = ... # 0x7e
    Greenlandic              : QLocale = ... # 0x7f
    Kalaallisut              : QLocale = ... # 0x7f
    Kuwait                   : QLocale = ... # 0x7f
    TaiVietScript            : QLocale = ... # 0x7f
    Kalenjin                 : QLocale = ... # 0x80
    Kyrgyzstan               : QLocale = ... # 0x80
    TakriScript              : QLocale = ... # 0x80
    Kamba                    : QLocale = ... # 0x81
    Laos                     : QLocale = ... # 0x81
    TamilScript              : QLocale = ... # 0x81
    Kannada                  : QLocale = ... # 0x82
    LatinAmerica             : QLocale = ... # 0x82
    LatinAmericaAndTheCaribbean: QLocale = ... # 0x82
    TangutScript             : QLocale = ... # 0x82
    Kanuri                   : QLocale = ... # 0x83
    Latvia                   : QLocale = ... # 0x83
    TeluguScript             : QLocale = ... # 0x83
    Kashmiri                 : QLocale = ... # 0x84
    Lebanon                  : QLocale = ... # 0x84
    ThaanaScript             : QLocale = ... # 0x84
    Kazakh                   : QLocale = ... # 0x85
    Lesotho                  : QLocale = ... # 0x85
    ThaiScript               : QLocale = ... # 0x85
    Kenyang                  : QLocale = ... # 0x86
    Liberia                  : QLocale = ... # 0x86
    TibetanScript            : QLocale = ... # 0x86
    Cambodian                : QLocale = ... # 0x87
    Khmer                    : QLocale = ... # 0x87
    Libya                    : QLocale = ... # 0x87
    TifinaghScript           : QLocale = ... # 0x87
    Kiche                    : QLocale = ... # 0x88
    Liechtenstein            : QLocale = ... # 0x88
    TirhutaScript            : QLocale = ... # 0x88
    Kikuyu                   : QLocale = ... # 0x89
    Lithuania                : QLocale = ... # 0x89
    TraditionalChineseScript : QLocale = ... # 0x89
    TraditionalHanScript     : QLocale = ... # 0x89
    Kinyarwanda              : QLocale = ... # 0x8a
    Luxembourg               : QLocale = ... # 0x8a
    UgariticScript           : QLocale = ... # 0x8a
    Komi                     : QLocale = ... # 0x8b
    Macao                    : QLocale = ... # 0x8b
    Macau                    : QLocale = ... # 0x8b
    VaiScript                : QLocale = ... # 0x8b
    Kongo                    : QLocale = ... # 0x8c
    Macedonia                : QLocale = ... # 0x8c
    VarangKshitiScript       : QLocale = ... # 0x8c
    Konkani                  : QLocale = ... # 0x8d
    LastScript               : QLocale = ... # 0x8d
    Madagascar               : QLocale = ... # 0x8d
    YiScript                 : QLocale = ... # 0x8d
    Korean                   : QLocale = ... # 0x8e
    Malawi                   : QLocale = ... # 0x8e
    Koro                     : QLocale = ... # 0x8f
    Malaysia                 : QLocale = ... # 0x8f
    KoyraboroSenni           : QLocale = ... # 0x90
    Maldives                 : QLocale = ... # 0x90
    KoyraChiini              : QLocale = ... # 0x91
    Mali                     : QLocale = ... # 0x91
    Kpelle                   : QLocale = ... # 0x92
    Malta                    : QLocale = ... # 0x92
    Kuanyama                 : QLocale = ... # 0x93
    Kwanyama                 : QLocale = ... # 0x93
    MarshallIslands          : QLocale = ... # 0x93
    Kurdish                  : QLocale = ... # 0x94
    Martinique               : QLocale = ... # 0x94
    Kwasio                   : QLocale = ... # 0x95
    Mauritania               : QLocale = ... # 0x95
    Kirghiz                  : QLocale = ... # 0x96
    Kyrgyz                   : QLocale = ... # 0x96
    Mauritius                : QLocale = ... # 0x96
    Lakota                   : QLocale = ... # 0x97
    Mayotte                  : QLocale = ... # 0x97
    Langi                    : QLocale = ... # 0x98
    Mexico                   : QLocale = ... # 0x98
    Lao                      : QLocale = ... # 0x99
    Micronesia               : QLocale = ... # 0x99
    Latin                    : QLocale = ... # 0x9a
    Moldova                  : QLocale = ... # 0x9a
    Latvian                  : QLocale = ... # 0x9b
    Monaco                   : QLocale = ... # 0x9b
    Lezghian                 : QLocale = ... # 0x9c
    Mongolia                 : QLocale = ... # 0x9c
    Limburgish               : QLocale = ... # 0x9d
    Montenegro               : QLocale = ... # 0x9d
    Lingala                  : QLocale = ... # 0x9e
    Montserrat               : QLocale = ... # 0x9e
    LiteraryChinese          : QLocale = ... # 0x9f
    Morocco                  : QLocale = ... # 0x9f
    Lithuanian               : QLocale = ... # 0xa0
    Mozambique               : QLocale = ... # 0xa0
    Lojban                   : QLocale = ... # 0xa1
    Myanmar                  : QLocale = ... # 0xa1
    LowerSorbian             : QLocale = ... # 0xa2
    Namibia                  : QLocale = ... # 0xa2
    LowGerman                : QLocale = ... # 0xa3
    NauruCountry             : QLocale = ... # 0xa3
    LubaKatanga              : QLocale = ... # 0xa4
    Nepal                    : QLocale = ... # 0xa4
    LuleSami                 : QLocale = ... # 0xa5
    Netherlands              : QLocale = ... # 0xa5
    Luo                      : QLocale = ... # 0xa6
    NewCaledonia             : QLocale = ... # 0xa6
    Luxembourgish            : QLocale = ... # 0xa7
    NewZealand               : QLocale = ... # 0xa7
    Luyia                    : QLocale = ... # 0xa8
    Nicaragua                : QLocale = ... # 0xa8
    Macedonian               : QLocale = ... # 0xa9
    Nigeria                  : QLocale = ... # 0xa9
    Machame                  : QLocale = ... # 0xaa
    Niger                    : QLocale = ... # 0xaa
    Maithili                 : QLocale = ... # 0xab
    Niue                     : QLocale = ... # 0xab
    MakhuwaMeetto            : QLocale = ... # 0xac
    NorfolkIsland            : QLocale = ... # 0xac
    Makonde                  : QLocale = ... # 0xad
    NorthernMarianaIslands   : QLocale = ... # 0xad
    DemocraticRepublicOfKorea: QLocale = ... # 0xae
    Malagasy                 : QLocale = ... # 0xae
    NorthKorea               : QLocale = ... # 0xae
    Malayalam                : QLocale = ... # 0xaf
    Norway                   : QLocale = ... # 0xaf
    Malay                    : QLocale = ... # 0xb0
    Oman                     : QLocale = ... # 0xb0
    Maltese                  : QLocale = ... # 0xb1
    OutlyingOceania          : QLocale = ... # 0xb1
    Mandingo                 : QLocale = ... # 0xb2
    Pakistan                 : QLocale = ... # 0xb2
    Manipuri                 : QLocale = ... # 0xb3
    Palau                    : QLocale = ... # 0xb3
    Manx                     : QLocale = ... # 0xb4
    PalestinianTerritories   : QLocale = ... # 0xb4
    Maori                    : QLocale = ... # 0xb5
    Panama                   : QLocale = ... # 0xb5
    Mapuche                  : QLocale = ... # 0xb6
    PapuaNewGuinea           : QLocale = ... # 0xb6
    Marathi                  : QLocale = ... # 0xb7
    Paraguay                 : QLocale = ... # 0xb7
    Marshallese              : QLocale = ... # 0xb8
    Peru                     : QLocale = ... # 0xb8
    Masai                    : QLocale = ... # 0xb9
    Philippines              : QLocale = ... # 0xb9
    Mazanderani              : QLocale = ... # 0xba
    Pitcairn                 : QLocale = ... # 0xba
    Mende                    : QLocale = ... # 0xbb
    Poland                   : QLocale = ... # 0xbb
    Meru                     : QLocale = ... # 0xbc
    Portugal                 : QLocale = ... # 0xbc
    Meta                     : QLocale = ... # 0xbd
    PuertoRico               : QLocale = ... # 0xbd
    Mohawk                   : QLocale = ... # 0xbe
    Qatar                    : QLocale = ... # 0xbe
    Mongolian                : QLocale = ... # 0xbf
    Reunion                  : QLocale = ... # 0xbf
    Morisyen                 : QLocale = ... # 0xc0
    Romania                  : QLocale = ... # 0xc0
    Mundang                  : QLocale = ... # 0xc1
    Russia                   : QLocale = ... # 0xc1
    RussianFederation        : QLocale = ... # 0xc1
    Muscogee                 : QLocale = ... # 0xc2
    Rwanda                   : QLocale = ... # 0xc2
    Nama                     : QLocale = ... # 0xc3
    SaintBarthelemy          : QLocale = ... # 0xc3
    NauruLanguage            : QLocale = ... # 0xc4
    SaintHelena              : QLocale = ... # 0xc4
    Navaho                   : QLocale = ... # 0xc5
    Navajo                   : QLocale = ... # 0xc5
    SaintKittsAndNevis       : QLocale = ... # 0xc5
    Ndonga                   : QLocale = ... # 0xc6
    SaintLucia               : QLocale = ... # 0xc6
    Nepali                   : QLocale = ... # 0xc7
    SaintMartin              : QLocale = ... # 0xc7
    Newari                   : QLocale = ... # 0xc8
    SaintPierreAndMiquelon   : QLocale = ... # 0xc8
    Ngiemboon                : QLocale = ... # 0xc9
    SaintVincentAndGrenadines: QLocale = ... # 0xc9
    SaintVincentAndTheGrenadines: QLocale = ... # 0xc9
    Ngomba                   : QLocale = ... # 0xca
    Samoa                    : QLocale = ... # 0xca
    NigerianPidgin           : QLocale = ... # 0xcb
    SanMarino                : QLocale = ... # 0xcb
    Nko                      : QLocale = ... # 0xcc
    SaoTomeAndPrincipe       : QLocale = ... # 0xcc
    NorthernLuri             : QLocale = ... # 0xcd
    SaudiArabia              : QLocale = ... # 0xcd
    NorthernSami             : QLocale = ... # 0xce
    Senegal                  : QLocale = ... # 0xce
    NorthernSotho            : QLocale = ... # 0xcf
    Serbia                   : QLocale = ... # 0xcf
    NorthNdebele             : QLocale = ... # 0xd0
    Seychelles               : QLocale = ... # 0xd0
    NorwegianBokmal          : QLocale = ... # 0xd1
    SierraLeone              : QLocale = ... # 0xd1
    NorwegianNynorsk         : QLocale = ... # 0xd2
    Singapore                : QLocale = ... # 0xd2
    Nuer                     : QLocale = ... # 0xd3
    SintMaarten              : QLocale = ... # 0xd3
    Chewa                    : QLocale = ... # 0xd4
    Nyanja                   : QLocale = ... # 0xd4
    Slovakia                 : QLocale = ... # 0xd4
    Nyankole                 : QLocale = ... # 0xd5
    Slovenia                 : QLocale = ... # 0xd5
    Occitan                  : QLocale = ... # 0xd6
    SolomonIslands           : QLocale = ... # 0xd6
    Odia                     : QLocale = ... # 0xd7
    Oriya                    : QLocale = ... # 0xd7
    Somalia                  : QLocale = ... # 0xd7
    Ojibwa                   : QLocale = ... # 0xd8
    SouthAfrica              : QLocale = ... # 0xd8
    OldIrish                 : QLocale = ... # 0xd9
    SouthGeorgiaAndSouthSandwichIslands: QLocale = ... # 0xd9
    SouthGeorgiaAndTheSouthSandwichIslands: QLocale = ... # 0xd9
    OldNorse                 : QLocale = ... # 0xda
    RepublicOfKorea          : QLocale = ... # 0xda
    SouthKorea               : QLocale = ... # 0xda
    OldPersian               : QLocale = ... # 0xdb
    SouthSudan               : QLocale = ... # 0xdb
    Afan                     : QLocale = ... # 0xdc
    Oromo                    : QLocale = ... # 0xdc
    Spain                    : QLocale = ... # 0xdc
    Osage                    : QLocale = ... # 0xdd
    SriLanka                 : QLocale = ... # 0xdd
    Ossetic                  : QLocale = ... # 0xde
    Sudan                    : QLocale = ... # 0xde
    Pahlavi                  : QLocale = ... # 0xdf
    Suriname                 : QLocale = ... # 0xdf
    Palauan                  : QLocale = ... # 0xe0
    SvalbardAndJanMayen      : QLocale = ... # 0xe0
    SvalbardAndJanMayenIslands: QLocale = ... # 0xe0
    Pali                     : QLocale = ... # 0xe1
    Sweden                   : QLocale = ... # 0xe1
    Papiamento               : QLocale = ... # 0xe2
    Switzerland              : QLocale = ... # 0xe2
    Pashto                   : QLocale = ... # 0xe3
    Syria                    : QLocale = ... # 0xe3
    SyrianArabRepublic       : QLocale = ... # 0xe3
    Persian                  : QLocale = ... # 0xe4
    Taiwan                   : QLocale = ... # 0xe4
    Phoenician               : QLocale = ... # 0xe5
    Tajikistan               : QLocale = ... # 0xe5
    Polish                   : QLocale = ... # 0xe6
    Tanzania                 : QLocale = ... # 0xe6
    Portuguese               : QLocale = ... # 0xe7
    Thailand                 : QLocale = ... # 0xe7
    EastTimor                : QLocale = ... # 0xe8
    Prussian                 : QLocale = ... # 0xe8
    TimorLeste               : QLocale = ... # 0xe8
    Punjabi                  : QLocale = ... # 0xe9
    Togo                     : QLocale = ... # 0xe9
    Quechua                  : QLocale = ... # 0xea
    TokelauCountry           : QLocale = ... # 0xea
    Romanian                 : QLocale = ... # 0xeb
    Tonga                    : QLocale = ... # 0xeb
    RhaetoRomance            : QLocale = ... # 0xec
    Romansh                  : QLocale = ... # 0xec
    TrinidadAndTobago        : QLocale = ... # 0xec
    Rombo                    : QLocale = ... # 0xed
    TristanDaCunha           : QLocale = ... # 0xed
    Kurundi                  : QLocale = ... # 0xee
    Rundi                    : QLocale = ... # 0xee
    Tunisia                  : QLocale = ... # 0xee
    Russian                  : QLocale = ... # 0xef
    Turkey                   : QLocale = ... # 0xef
    Rwa                      : QLocale = ... # 0xf0
    Turkmenistan             : QLocale = ... # 0xf0
    Saho                     : QLocale = ... # 0xf1
    TurksAndCaicosIslands    : QLocale = ... # 0xf1
    Sakha                    : QLocale = ... # 0xf2
    TuvaluCountry            : QLocale = ... # 0xf2
    Samburu                  : QLocale = ... # 0xf3
    Uganda                   : QLocale = ... # 0xf3
    Samoan                   : QLocale = ... # 0xf4
    Ukraine                  : QLocale = ... # 0xf4
    Sango                    : QLocale = ... # 0xf5
    UnitedArabEmirates       : QLocale = ... # 0xf5
    Sangu                    : QLocale = ... # 0xf6
    UnitedKingdom            : QLocale = ... # 0xf6
    Sanskrit                 : QLocale = ... # 0xf7
    UnitedStatesMinorOutlyingIslands: QLocale = ... # 0xf7
    UnitedStatesOutlyingIslands: QLocale = ... # 0xf7
    Santali                  : QLocale = ... # 0xf8
    UnitedStates             : QLocale = ... # 0xf8
    Sardinian                : QLocale = ... # 0xf9
    UnitedStatesVirginIslands: QLocale = ... # 0xf9
    Saurashtra               : QLocale = ... # 0xfa
    Uruguay                  : QLocale = ... # 0xfa
    Sena                     : QLocale = ... # 0xfb
    Uzbekistan               : QLocale = ... # 0xfb
    Serbian                  : QLocale = ... # 0xfc
    Vanuatu                  : QLocale = ... # 0xfc
    Shambala                 : QLocale = ... # 0xfd
    VaticanCity              : QLocale = ... # 0xfd
    VaticanCityState         : QLocale = ... # 0xfd
    Shona                    : QLocale = ... # 0xfe
    Venezuela                : QLocale = ... # 0xfe
    SichuanYi                : QLocale = ... # 0xff
    Vietnam                  : QLocale = ... # 0xff
    Sicilian                 : QLocale = ... # 0x100
    WallisAndFutuna          : QLocale = ... # 0x100
    WallisAndFutunaIslands   : QLocale = ... # 0x100
    Sidamo                   : QLocale = ... # 0x101
    WesternSahara            : QLocale = ... # 0x101
    Silesian                 : QLocale = ... # 0x102
    World                    : QLocale = ... # 0x102
    Sindhi                   : QLocale = ... # 0x103
    Yemen                    : QLocale = ... # 0x103
    Sinhala                  : QLocale = ... # 0x104
    Zambia                   : QLocale = ... # 0x104
    LastCountry              : QLocale = ... # 0x105
    SkoltSami                : QLocale = ... # 0x105
    Zimbabwe                 : QLocale = ... # 0x105
    Slovak                   : QLocale = ... # 0x106
    Slovenian                : QLocale = ... # 0x107
    Soga                     : QLocale = ... # 0x108
    Somali                   : QLocale = ... # 0x109
    SouthernKurdish          : QLocale = ... # 0x10a
    SouthernSami             : QLocale = ... # 0x10b
    SouthernSotho            : QLocale = ... # 0x10c
    SouthNdebele             : QLocale = ... # 0x10d
    Spanish                  : QLocale = ... # 0x10e
    StandardMoroccanTamazight: QLocale = ... # 0x10f
    Sundanese                : QLocale = ... # 0x110
    Swahili                  : QLocale = ... # 0x111
    Swati                    : QLocale = ... # 0x112
    Swedish                  : QLocale = ... # 0x113
    SwissGerman              : QLocale = ... # 0x114
    Syriac                   : QLocale = ... # 0x115
    Tachelhit                : QLocale = ... # 0x116
    Tahitian                 : QLocale = ... # 0x117
    TaiDam                   : QLocale = ... # 0x118
    Taita                    : QLocale = ... # 0x119
    Tajik                    : QLocale = ... # 0x11a
    Tamil                    : QLocale = ... # 0x11b
    Taroko                   : QLocale = ... # 0x11c
    Tasawaq                  : QLocale = ... # 0x11d
    Tatar                    : QLocale = ... # 0x11e
    Telugu                   : QLocale = ... # 0x11f
    Teso                     : QLocale = ... # 0x120
    Thai                     : QLocale = ... # 0x121
    Tibetan                  : QLocale = ... # 0x122
    Tigre                    : QLocale = ... # 0x123
    Tigrinya                 : QLocale = ... # 0x124
    TokelauLanguage          : QLocale = ... # 0x125
    TokPisin                 : QLocale = ... # 0x126
    Tongan                   : QLocale = ... # 0x127
    Tsonga                   : QLocale = ... # 0x128
    Tswana                   : QLocale = ... # 0x129
    Turkish                  : QLocale = ... # 0x12a
    Turkmen                  : QLocale = ... # 0x12b
    TuvaluLanguage           : QLocale = ... # 0x12c
    Tyap                     : QLocale = ... # 0x12d
    Ugaritic                 : QLocale = ... # 0x12e
    Ukrainian                : QLocale = ... # 0x12f
    UpperSorbian             : QLocale = ... # 0x130
    Urdu                     : QLocale = ... # 0x131
    Uighur                   : QLocale = ... # 0x132
    Uigur                    : QLocale = ... # 0x132
    Uyghur                   : QLocale = ... # 0x132
    Uzbek                    : QLocale = ... # 0x133
    Vai                      : QLocale = ... # 0x134
    Venda                    : QLocale = ... # 0x135
    Vietnamese               : QLocale = ... # 0x136
    Volapuk                  : QLocale = ... # 0x137
    Vunjo                    : QLocale = ... # 0x138
    Walloon                  : QLocale = ... # 0x139
    Walser                   : QLocale = ... # 0x13a
    Warlpiri                 : QLocale = ... # 0x13b
    Welsh                    : QLocale = ... # 0x13c
    WesternBalochi           : QLocale = ... # 0x13d
    Frisian                  : QLocale = ... # 0x13e
    WesternFrisian           : QLocale = ... # 0x13e
    Walamo                   : QLocale = ... # 0x13f
    Wolaytta                 : QLocale = ... # 0x13f
    Wolof                    : QLocale = ... # 0x140
    Xhosa                    : QLocale = ... # 0x141
    Yangben                  : QLocale = ... # 0x142
    Yiddish                  : QLocale = ... # 0x143
    Yoruba                   : QLocale = ... # 0x144
    Zarma                    : QLocale = ... # 0x145
    Zhuang                   : QLocale = ... # 0x146
    LastLanguage             : QLocale = ... # 0x147
    Zulu                     : QLocale = ... # 0x147

    class Country(object):
        AnyCountry               : QLocale.Country = ... # 0x0
        Afghanistan              : QLocale.Country = ... # 0x1
        AlandIslands             : QLocale.Country = ... # 0x2
        Albania                  : QLocale.Country = ... # 0x3
        Algeria                  : QLocale.Country = ... # 0x4
        AmericanSamoa            : QLocale.Country = ... # 0x5
        Andorra                  : QLocale.Country = ... # 0x6
        Angola                   : QLocale.Country = ... # 0x7
        Anguilla                 : QLocale.Country = ... # 0x8
        Antarctica               : QLocale.Country = ... # 0x9
        AntiguaAndBarbuda        : QLocale.Country = ... # 0xa
        Argentina                : QLocale.Country = ... # 0xb
        Armenia                  : QLocale.Country = ... # 0xc
        Aruba                    : QLocale.Country = ... # 0xd
        AscensionIsland          : QLocale.Country = ... # 0xe
        Australia                : QLocale.Country = ... # 0xf
        Austria                  : QLocale.Country = ... # 0x10
        Azerbaijan               : QLocale.Country = ... # 0x11
        Bahamas                  : QLocale.Country = ... # 0x12
        Bahrain                  : QLocale.Country = ... # 0x13
        Bangladesh               : QLocale.Country = ... # 0x14
        Barbados                 : QLocale.Country = ... # 0x15
        Belarus                  : QLocale.Country = ... # 0x16
        Belgium                  : QLocale.Country = ... # 0x17
        Belize                   : QLocale.Country = ... # 0x18
        Benin                    : QLocale.Country = ... # 0x19
        Bermuda                  : QLocale.Country = ... # 0x1a
        Bhutan                   : QLocale.Country = ... # 0x1b
        Bolivia                  : QLocale.Country = ... # 0x1c
        BosniaAndHerzegovina     : QLocale.Country = ... # 0x1d
        BosniaAndHerzegowina     : QLocale.Country = ... # 0x1d
        Botswana                 : QLocale.Country = ... # 0x1e
        BouvetIsland             : QLocale.Country = ... # 0x1f
        Brazil                   : QLocale.Country = ... # 0x20
        BritishIndianOceanTerritory: QLocale.Country = ... # 0x21
        BritishVirginIslands     : QLocale.Country = ... # 0x22
        Brunei                   : QLocale.Country = ... # 0x23
        Bulgaria                 : QLocale.Country = ... # 0x24
        BurkinaFaso              : QLocale.Country = ... # 0x25
        Burundi                  : QLocale.Country = ... # 0x26
        Cambodia                 : QLocale.Country = ... # 0x27
        Cameroon                 : QLocale.Country = ... # 0x28
        Canada                   : QLocale.Country = ... # 0x29
        CanaryIslands            : QLocale.Country = ... # 0x2a
        CapeVerde                : QLocale.Country = ... # 0x2b
        Bonaire                  : QLocale.Country = ... # 0x2c
        CaribbeanNetherlands     : QLocale.Country = ... # 0x2c
        CaymanIslands            : QLocale.Country = ... # 0x2d
        CentralAfricanRepublic   : QLocale.Country = ... # 0x2e
        CeutaAndMelilla          : QLocale.Country = ... # 0x2f
        Chad                     : QLocale.Country = ... # 0x30
        Chile                    : QLocale.Country = ... # 0x31
        China                    : QLocale.Country = ... # 0x32
        ChristmasIsland          : QLocale.Country = ... # 0x33
        ClippertonIsland         : QLocale.Country = ... # 0x34
        CocosIslands             : QLocale.Country = ... # 0x35
        Colombia                 : QLocale.Country = ... # 0x36
        Comoros                  : QLocale.Country = ... # 0x37
        CongoBrazzaville         : QLocale.Country = ... # 0x38
        PeoplesRepublicOfCongo   : QLocale.Country = ... # 0x38
        CongoKinshasa            : QLocale.Country = ... # 0x39
        DemocraticRepublicOfCongo: QLocale.Country = ... # 0x39
        CookIslands              : QLocale.Country = ... # 0x3a
        CostaRica                : QLocale.Country = ... # 0x3b
        Croatia                  : QLocale.Country = ... # 0x3c
        Cuba                     : QLocale.Country = ... # 0x3d
        CuraSao                  : QLocale.Country = ... # 0x3e
        Curacao                  : QLocale.Country = ... # 0x3e
        Cyprus                   : QLocale.Country = ... # 0x3f
        CzechRepublic            : QLocale.Country = ... # 0x40
        Czechia                  : QLocale.Country = ... # 0x40
        Denmark                  : QLocale.Country = ... # 0x41
        DiegoGarcia              : QLocale.Country = ... # 0x42
        Djibouti                 : QLocale.Country = ... # 0x43
        Dominica                 : QLocale.Country = ... # 0x44
        DominicanRepublic        : QLocale.Country = ... # 0x45
        Ecuador                  : QLocale.Country = ... # 0x46
        Egypt                    : QLocale.Country = ... # 0x47
        ElSalvador               : QLocale.Country = ... # 0x48
        EquatorialGuinea         : QLocale.Country = ... # 0x49
        Eritrea                  : QLocale.Country = ... # 0x4a
        Estonia                  : QLocale.Country = ... # 0x4b
        Eswatini                 : QLocale.Country = ... # 0x4c
        Swaziland                : QLocale.Country = ... # 0x4c
        Ethiopia                 : QLocale.Country = ... # 0x4d
        Europe                   : QLocale.Country = ... # 0x4e
        EuropeanUnion            : QLocale.Country = ... # 0x4f
        FalklandIslands          : QLocale.Country = ... # 0x50
        FaroeIslands             : QLocale.Country = ... # 0x51
        Fiji                     : QLocale.Country = ... # 0x52
        Finland                  : QLocale.Country = ... # 0x53
        France                   : QLocale.Country = ... # 0x54
        FrenchGuiana             : QLocale.Country = ... # 0x55
        FrenchPolynesia          : QLocale.Country = ... # 0x56
        FrenchSouthernTerritories: QLocale.Country = ... # 0x57
        Gabon                    : QLocale.Country = ... # 0x58
        Gambia                   : QLocale.Country = ... # 0x59
        Georgia                  : QLocale.Country = ... # 0x5a
        Germany                  : QLocale.Country = ... # 0x5b
        Ghana                    : QLocale.Country = ... # 0x5c
        Gibraltar                : QLocale.Country = ... # 0x5d
        Greece                   : QLocale.Country = ... # 0x5e
        Greenland                : QLocale.Country = ... # 0x5f
        Grenada                  : QLocale.Country = ... # 0x60
        Guadeloupe               : QLocale.Country = ... # 0x61
        Guam                     : QLocale.Country = ... # 0x62
        Guatemala                : QLocale.Country = ... # 0x63
        Guernsey                 : QLocale.Country = ... # 0x64
        GuineaBissau             : QLocale.Country = ... # 0x65
        Guinea                   : QLocale.Country = ... # 0x66
        Guyana                   : QLocale.Country = ... # 0x67
        Haiti                    : QLocale.Country = ... # 0x68
        HeardAndMcDonaldIslands  : QLocale.Country = ... # 0x69
        Honduras                 : QLocale.Country = ... # 0x6a
        HongKong                 : QLocale.Country = ... # 0x6b
        Hungary                  : QLocale.Country = ... # 0x6c
        Iceland                  : QLocale.Country = ... # 0x6d
        India                    : QLocale.Country = ... # 0x6e
        Indonesia                : QLocale.Country = ... # 0x6f
        Iran                     : QLocale.Country = ... # 0x70
        Iraq                     : QLocale.Country = ... # 0x71
        Ireland                  : QLocale.Country = ... # 0x72
        IsleOfMan                : QLocale.Country = ... # 0x73
        Israel                   : QLocale.Country = ... # 0x74
        Italy                    : QLocale.Country = ... # 0x75
        IvoryCoast               : QLocale.Country = ... # 0x76
        Jamaica                  : QLocale.Country = ... # 0x77
        Japan                    : QLocale.Country = ... # 0x78
        Jersey                   : QLocale.Country = ... # 0x79
        Jordan                   : QLocale.Country = ... # 0x7a
        Kazakhstan               : QLocale.Country = ... # 0x7b
        Kenya                    : QLocale.Country = ... # 0x7c
        Kiribati                 : QLocale.Country = ... # 0x7d
        Kosovo                   : QLocale.Country = ... # 0x7e
        Kuwait                   : QLocale.Country = ... # 0x7f
        Kyrgyzstan               : QLocale.Country = ... # 0x80
        Laos                     : QLocale.Country = ... # 0x81
        LatinAmerica             : QLocale.Country = ... # 0x82
        LatinAmericaAndTheCaribbean: QLocale.Country = ... # 0x82
        Latvia                   : QLocale.Country = ... # 0x83
        Lebanon                  : QLocale.Country = ... # 0x84
        Lesotho                  : QLocale.Country = ... # 0x85
        Liberia                  : QLocale.Country = ... # 0x86
        Libya                    : QLocale.Country = ... # 0x87
        Liechtenstein            : QLocale.Country = ... # 0x88
        Lithuania                : QLocale.Country = ... # 0x89
        Luxembourg               : QLocale.Country = ... # 0x8a
        Macao                    : QLocale.Country = ... # 0x8b
        Macau                    : QLocale.Country = ... # 0x8b
        Macedonia                : QLocale.Country = ... # 0x8c
        Madagascar               : QLocale.Country = ... # 0x8d
        Malawi                   : QLocale.Country = ... # 0x8e
        Malaysia                 : QLocale.Country = ... # 0x8f
        Maldives                 : QLocale.Country = ... # 0x90
        Mali                     : QLocale.Country = ... # 0x91
        Malta                    : QLocale.Country = ... # 0x92
        MarshallIslands          : QLocale.Country = ... # 0x93
        Martinique               : QLocale.Country = ... # 0x94
        Mauritania               : QLocale.Country = ... # 0x95
        Mauritius                : QLocale.Country = ... # 0x96
        Mayotte                  : QLocale.Country = ... # 0x97
        Mexico                   : QLocale.Country = ... # 0x98
        Micronesia               : QLocale.Country = ... # 0x99
        Moldova                  : QLocale.Country = ... # 0x9a
        Monaco                   : QLocale.Country = ... # 0x9b
        Mongolia                 : QLocale.Country = ... # 0x9c
        Montenegro               : QLocale.Country = ... # 0x9d
        Montserrat               : QLocale.Country = ... # 0x9e
        Morocco                  : QLocale.Country = ... # 0x9f
        Mozambique               : QLocale.Country = ... # 0xa0
        Myanmar                  : QLocale.Country = ... # 0xa1
        Namibia                  : QLocale.Country = ... # 0xa2
        NauruCountry             : QLocale.Country = ... # 0xa3
        Nepal                    : QLocale.Country = ... # 0xa4
        Netherlands              : QLocale.Country = ... # 0xa5
        NewCaledonia             : QLocale.Country = ... # 0xa6
        NewZealand               : QLocale.Country = ... # 0xa7
        Nicaragua                : QLocale.Country = ... # 0xa8
        Nigeria                  : QLocale.Country = ... # 0xa9
        Niger                    : QLocale.Country = ... # 0xaa
        Niue                     : QLocale.Country = ... # 0xab
        NorfolkIsland            : QLocale.Country = ... # 0xac
        NorthernMarianaIslands   : QLocale.Country = ... # 0xad
        DemocraticRepublicOfKorea: QLocale.Country = ... # 0xae
        NorthKorea               : QLocale.Country = ... # 0xae
        Norway                   : QLocale.Country = ... # 0xaf
        Oman                     : QLocale.Country = ... # 0xb0
        OutlyingOceania          : QLocale.Country = ... # 0xb1
        Pakistan                 : QLocale.Country = ... # 0xb2
        Palau                    : QLocale.Country = ... # 0xb3
        PalestinianTerritories   : QLocale.Country = ... # 0xb4
        Panama                   : QLocale.Country = ... # 0xb5
        PapuaNewGuinea           : QLocale.Country = ... # 0xb6
        Paraguay                 : QLocale.Country = ... # 0xb7
        Peru                     : QLocale.Country = ... # 0xb8
        Philippines              : QLocale.Country = ... # 0xb9
        Pitcairn                 : QLocale.Country = ... # 0xba
        Poland                   : QLocale.Country = ... # 0xbb
        Portugal                 : QLocale.Country = ... # 0xbc
        PuertoRico               : QLocale.Country = ... # 0xbd
        Qatar                    : QLocale.Country = ... # 0xbe
        Reunion                  : QLocale.Country = ... # 0xbf
        Romania                  : QLocale.Country = ... # 0xc0
        Russia                   : QLocale.Country = ... # 0xc1
        RussianFederation        : QLocale.Country = ... # 0xc1
        Rwanda                   : QLocale.Country = ... # 0xc2
        SaintBarthelemy          : QLocale.Country = ... # 0xc3
        SaintHelena              : QLocale.Country = ... # 0xc4
        SaintKittsAndNevis       : QLocale.Country = ... # 0xc5
        SaintLucia               : QLocale.Country = ... # 0xc6
        SaintMartin              : QLocale.Country = ... # 0xc7
        SaintPierreAndMiquelon   : QLocale.Country = ... # 0xc8
        SaintVincentAndGrenadines: QLocale.Country = ... # 0xc9
        SaintVincentAndTheGrenadines: QLocale.Country = ... # 0xc9
        Samoa                    : QLocale.Country = ... # 0xca
        SanMarino                : QLocale.Country = ... # 0xcb
        SaoTomeAndPrincipe       : QLocale.Country = ... # 0xcc
        SaudiArabia              : QLocale.Country = ... # 0xcd
        Senegal                  : QLocale.Country = ... # 0xce
        Serbia                   : QLocale.Country = ... # 0xcf
        Seychelles               : QLocale.Country = ... # 0xd0
        SierraLeone              : QLocale.Country = ... # 0xd1
        Singapore                : QLocale.Country = ... # 0xd2
        SintMaarten              : QLocale.Country = ... # 0xd3
        Slovakia                 : QLocale.Country = ... # 0xd4
        Slovenia                 : QLocale.Country = ... # 0xd5
        SolomonIslands           : QLocale.Country = ... # 0xd6
        Somalia                  : QLocale.Country = ... # 0xd7
        SouthAfrica              : QLocale.Country = ... # 0xd8
        SouthGeorgiaAndSouthSandwichIslands: QLocale.Country = ... # 0xd9
        SouthGeorgiaAndTheSouthSandwichIslands: QLocale.Country = ... # 0xd9
        RepublicOfKorea          : QLocale.Country = ... # 0xda
        SouthKorea               : QLocale.Country = ... # 0xda
        SouthSudan               : QLocale.Country = ... # 0xdb
        Spain                    : QLocale.Country = ... # 0xdc
        SriLanka                 : QLocale.Country = ... # 0xdd
        Sudan                    : QLocale.Country = ... # 0xde
        Suriname                 : QLocale.Country = ... # 0xdf
        SvalbardAndJanMayen      : QLocale.Country = ... # 0xe0
        SvalbardAndJanMayenIslands: QLocale.Country = ... # 0xe0
        Sweden                   : QLocale.Country = ... # 0xe1
        Switzerland              : QLocale.Country = ... # 0xe2
        Syria                    : QLocale.Country = ... # 0xe3
        SyrianArabRepublic       : QLocale.Country = ... # 0xe3
        Taiwan                   : QLocale.Country = ... # 0xe4
        Tajikistan               : QLocale.Country = ... # 0xe5
        Tanzania                 : QLocale.Country = ... # 0xe6
        Thailand                 : QLocale.Country = ... # 0xe7
        EastTimor                : QLocale.Country = ... # 0xe8
        TimorLeste               : QLocale.Country = ... # 0xe8
        Togo                     : QLocale.Country = ... # 0xe9
        TokelauCountry           : QLocale.Country = ... # 0xea
        Tonga                    : QLocale.Country = ... # 0xeb
        TrinidadAndTobago        : QLocale.Country = ... # 0xec
        TristanDaCunha           : QLocale.Country = ... # 0xed
        Tunisia                  : QLocale.Country = ... # 0xee
        Turkey                   : QLocale.Country = ... # 0xef
        Turkmenistan             : QLocale.Country = ... # 0xf0
        TurksAndCaicosIslands    : QLocale.Country = ... # 0xf1
        TuvaluCountry            : QLocale.Country = ... # 0xf2
        Uganda                   : QLocale.Country = ... # 0xf3
        Ukraine                  : QLocale.Country = ... # 0xf4
        UnitedArabEmirates       : QLocale.Country = ... # 0xf5
        UnitedKingdom            : QLocale.Country = ... # 0xf6
        UnitedStatesMinorOutlyingIslands: QLocale.Country = ... # 0xf7
        UnitedStatesOutlyingIslands: QLocale.Country = ... # 0xf7
        UnitedStates             : QLocale.Country = ... # 0xf8
        UnitedStatesVirginIslands: QLocale.Country = ... # 0xf9
        Uruguay                  : QLocale.Country = ... # 0xfa
        Uzbekistan               : QLocale.Country = ... # 0xfb
        Vanuatu                  : QLocale.Country = ... # 0xfc
        VaticanCity              : QLocale.Country = ... # 0xfd
        VaticanCityState         : QLocale.Country = ... # 0xfd
        Venezuela                : QLocale.Country = ... # 0xfe
        Vietnam                  : QLocale.Country = ... # 0xff
        WallisAndFutuna          : QLocale.Country = ... # 0x100
        WallisAndFutunaIslands   : QLocale.Country = ... # 0x100
        WesternSahara            : QLocale.Country = ... # 0x101
        World                    : QLocale.Country = ... # 0x102
        Yemen                    : QLocale.Country = ... # 0x103
        Zambia                   : QLocale.Country = ... # 0x104
        LastCountry              : QLocale.Country = ... # 0x105
        Zimbabwe                 : QLocale.Country = ... # 0x105

    class CurrencySymbolFormat(object):
        CurrencyIsoCode          : QLocale.CurrencySymbolFormat = ... # 0x0
        CurrencySymbol           : QLocale.CurrencySymbolFormat = ... # 0x1
        CurrencyDisplayName      : QLocale.CurrencySymbolFormat = ... # 0x2

    class DataSizeFormat(object):
        DataSizeIecFormat        : QLocale.DataSizeFormat = ... # 0x0
        DataSizeBase1000         : QLocale.DataSizeFormat = ... # 0x1
        DataSizeSIQuantifiers    : QLocale.DataSizeFormat = ... # 0x2
        DataSizeTraditionalFormat: QLocale.DataSizeFormat = ... # 0x2
        DataSizeSIFormat         : QLocale.DataSizeFormat = ... # 0x3

    class DataSizeFormats(object): ...

    class FloatingPointPrecisionOption(object):
        FloatingPointShortest    : QLocale.FloatingPointPrecisionOption = ... # -0x80

    class FormatType(object):
        LongFormat               : QLocale.FormatType = ... # 0x0
        ShortFormat              : QLocale.FormatType = ... # 0x1
        NarrowFormat             : QLocale.FormatType = ... # 0x2

    class Language(object):
        AnyLanguage              : QLocale.Language = ... # 0x0
        C                        : QLocale.Language = ... # 0x1
        Abkhazian                : QLocale.Language = ... # 0x2
        Afar                     : QLocale.Language = ... # 0x3
        Afrikaans                : QLocale.Language = ... # 0x4
        Aghem                    : QLocale.Language = ... # 0x5
        Akan                     : QLocale.Language = ... # 0x6
        Akkadian                 : QLocale.Language = ... # 0x7
        Akoose                   : QLocale.Language = ... # 0x8
        Albanian                 : QLocale.Language = ... # 0x9
        AmericanSignLanguage     : QLocale.Language = ... # 0xa
        Amharic                  : QLocale.Language = ... # 0xb
        AncientEgyptian          : QLocale.Language = ... # 0xc
        AncientGreek             : QLocale.Language = ... # 0xd
        Arabic                   : QLocale.Language = ... # 0xe
        Aragonese                : QLocale.Language = ... # 0xf
        Aramaic                  : QLocale.Language = ... # 0x10
        Armenian                 : QLocale.Language = ... # 0x11
        Assamese                 : QLocale.Language = ... # 0x12
        Asturian                 : QLocale.Language = ... # 0x13
        Asu                      : QLocale.Language = ... # 0x14
        Atsam                    : QLocale.Language = ... # 0x15
        Avaric                   : QLocale.Language = ... # 0x16
        Avestan                  : QLocale.Language = ... # 0x17
        Aymara                   : QLocale.Language = ... # 0x18
        Azerbaijani              : QLocale.Language = ... # 0x19
        Bafia                    : QLocale.Language = ... # 0x1a
        Balinese                 : QLocale.Language = ... # 0x1b
        Bambara                  : QLocale.Language = ... # 0x1c
        Bamun                    : QLocale.Language = ... # 0x1d
        Bangla                   : QLocale.Language = ... # 0x1e
        Bengali                  : QLocale.Language = ... # 0x1e
        Basaa                    : QLocale.Language = ... # 0x1f
        Bashkir                  : QLocale.Language = ... # 0x20
        Basque                   : QLocale.Language = ... # 0x21
        BatakToba                : QLocale.Language = ... # 0x22
        Belarusian               : QLocale.Language = ... # 0x23
        Byelorussian             : QLocale.Language = ... # 0x23
        Bemba                    : QLocale.Language = ... # 0x24
        Bena                     : QLocale.Language = ... # 0x25
        Bhojpuri                 : QLocale.Language = ... # 0x26
        Bislama                  : QLocale.Language = ... # 0x27
        Blin                     : QLocale.Language = ... # 0x28
        Bodo                     : QLocale.Language = ... # 0x29
        Bosnian                  : QLocale.Language = ... # 0x2a
        Breton                   : QLocale.Language = ... # 0x2b
        Buginese                 : QLocale.Language = ... # 0x2c
        Bulgarian                : QLocale.Language = ... # 0x2d
        Burmese                  : QLocale.Language = ... # 0x2e
        Cantonese                : QLocale.Language = ... # 0x2f
        Catalan                  : QLocale.Language = ... # 0x30
        Cebuano                  : QLocale.Language = ... # 0x31
        CentralAtlasTamazight    : QLocale.Language = ... # 0x32
        CentralMoroccoTamazight  : QLocale.Language = ... # 0x32
        CentralKurdish           : QLocale.Language = ... # 0x33
        Chakma                   : QLocale.Language = ... # 0x34
        Chamorro                 : QLocale.Language = ... # 0x35
        Chechen                  : QLocale.Language = ... # 0x36
        Cherokee                 : QLocale.Language = ... # 0x37
        Chickasaw                : QLocale.Language = ... # 0x38
        Chiga                    : QLocale.Language = ... # 0x39
        Chinese                  : QLocale.Language = ... # 0x3a
        Church                   : QLocale.Language = ... # 0x3b
        Chuvash                  : QLocale.Language = ... # 0x3c
        Colognian                : QLocale.Language = ... # 0x3d
        Coptic                   : QLocale.Language = ... # 0x3e
        Cornish                  : QLocale.Language = ... # 0x3f
        Corsican                 : QLocale.Language = ... # 0x40
        Cree                     : QLocale.Language = ... # 0x41
        Croatian                 : QLocale.Language = ... # 0x42
        Czech                    : QLocale.Language = ... # 0x43
        Danish                   : QLocale.Language = ... # 0x44
        Divehi                   : QLocale.Language = ... # 0x45
        Dogri                    : QLocale.Language = ... # 0x46
        Duala                    : QLocale.Language = ... # 0x47
        Dutch                    : QLocale.Language = ... # 0x48
        Bhutani                  : QLocale.Language = ... # 0x49
        Dzongkha                 : QLocale.Language = ... # 0x49
        Embu                     : QLocale.Language = ... # 0x4a
        English                  : QLocale.Language = ... # 0x4b
        Erzya                    : QLocale.Language = ... # 0x4c
        Esperanto                : QLocale.Language = ... # 0x4d
        Estonian                 : QLocale.Language = ... # 0x4e
        Ewe                      : QLocale.Language = ... # 0x4f
        Ewondo                   : QLocale.Language = ... # 0x50
        Faroese                  : QLocale.Language = ... # 0x51
        Fijian                   : QLocale.Language = ... # 0x52
        Filipino                 : QLocale.Language = ... # 0x53
        Finnish                  : QLocale.Language = ... # 0x54
        French                   : QLocale.Language = ... # 0x55
        Friulian                 : QLocale.Language = ... # 0x56
        Fulah                    : QLocale.Language = ... # 0x57
        Gaelic                   : QLocale.Language = ... # 0x58
        Ga                       : QLocale.Language = ... # 0x59
        Galician                 : QLocale.Language = ... # 0x5a
        Ganda                    : QLocale.Language = ... # 0x5b
        Geez                     : QLocale.Language = ... # 0x5c
        Georgian                 : QLocale.Language = ... # 0x5d
        German                   : QLocale.Language = ... # 0x5e
        Gothic                   : QLocale.Language = ... # 0x5f
        Greek                    : QLocale.Language = ... # 0x60
        Guarani                  : QLocale.Language = ... # 0x61
        Gujarati                 : QLocale.Language = ... # 0x62
        Gusii                    : QLocale.Language = ... # 0x63
        Haitian                  : QLocale.Language = ... # 0x64
        Hausa                    : QLocale.Language = ... # 0x65
        Hawaiian                 : QLocale.Language = ... # 0x66
        Hebrew                   : QLocale.Language = ... # 0x67
        Herero                   : QLocale.Language = ... # 0x68
        Hindi                    : QLocale.Language = ... # 0x69
        HiriMotu                 : QLocale.Language = ... # 0x6a
        Hungarian                : QLocale.Language = ... # 0x6b
        Icelandic                : QLocale.Language = ... # 0x6c
        Ido                      : QLocale.Language = ... # 0x6d
        Igbo                     : QLocale.Language = ... # 0x6e
        InariSami                : QLocale.Language = ... # 0x6f
        Indonesian               : QLocale.Language = ... # 0x70
        Ingush                   : QLocale.Language = ... # 0x71
        Interlingua              : QLocale.Language = ... # 0x72
        Interlingue              : QLocale.Language = ... # 0x73
        Inuktitut                : QLocale.Language = ... # 0x74
        Inupiak                  : QLocale.Language = ... # 0x75
        Inupiaq                  : QLocale.Language = ... # 0x75
        Irish                    : QLocale.Language = ... # 0x76
        Italian                  : QLocale.Language = ... # 0x77
        Japanese                 : QLocale.Language = ... # 0x78
        Javanese                 : QLocale.Language = ... # 0x79
        Jju                      : QLocale.Language = ... # 0x7a
        JolaFonyi                : QLocale.Language = ... # 0x7b
        Kabuverdianu             : QLocale.Language = ... # 0x7c
        Kabyle                   : QLocale.Language = ... # 0x7d
        Kako                     : QLocale.Language = ... # 0x7e
        Greenlandic              : QLocale.Language = ... # 0x7f
        Kalaallisut              : QLocale.Language = ... # 0x7f
        Kalenjin                 : QLocale.Language = ... # 0x80
        Kamba                    : QLocale.Language = ... # 0x81
        Kannada                  : QLocale.Language = ... # 0x82
        Kanuri                   : QLocale.Language = ... # 0x83
        Kashmiri                 : QLocale.Language = ... # 0x84
        Kazakh                   : QLocale.Language = ... # 0x85
        Kenyang                  : QLocale.Language = ... # 0x86
        Cambodian                : QLocale.Language = ... # 0x87
        Khmer                    : QLocale.Language = ... # 0x87
        Kiche                    : QLocale.Language = ... # 0x88
        Kikuyu                   : QLocale.Language = ... # 0x89
        Kinyarwanda              : QLocale.Language = ... # 0x8a
        Komi                     : QLocale.Language = ... # 0x8b
        Kongo                    : QLocale.Language = ... # 0x8c
        Konkani                  : QLocale.Language = ... # 0x8d
        Korean                   : QLocale.Language = ... # 0x8e
        Koro                     : QLocale.Language = ... # 0x8f
        KoyraboroSenni           : QLocale.Language = ... # 0x90
        KoyraChiini              : QLocale.Language = ... # 0x91
        Kpelle                   : QLocale.Language = ... # 0x92
        Kuanyama                 : QLocale.Language = ... # 0x93
        Kwanyama                 : QLocale.Language = ... # 0x93
        Kurdish                  : QLocale.Language = ... # 0x94
        Kwasio                   : QLocale.Language = ... # 0x95
        Kirghiz                  : QLocale.Language = ... # 0x96
        Kyrgyz                   : QLocale.Language = ... # 0x96
        Lakota                   : QLocale.Language = ... # 0x97
        Langi                    : QLocale.Language = ... # 0x98
        Lao                      : QLocale.Language = ... # 0x99
        Latin                    : QLocale.Language = ... # 0x9a
        Latvian                  : QLocale.Language = ... # 0x9b
        Lezghian                 : QLocale.Language = ... # 0x9c
        Limburgish               : QLocale.Language = ... # 0x9d
        Lingala                  : QLocale.Language = ... # 0x9e
        LiteraryChinese          : QLocale.Language = ... # 0x9f
        Lithuanian               : QLocale.Language = ... # 0xa0
        Lojban                   : QLocale.Language = ... # 0xa1
        LowerSorbian             : QLocale.Language = ... # 0xa2
        LowGerman                : QLocale.Language = ... # 0xa3
        LubaKatanga              : QLocale.Language = ... # 0xa4
        LuleSami                 : QLocale.Language = ... # 0xa5
        Luo                      : QLocale.Language = ... # 0xa6
        Luxembourgish            : QLocale.Language = ... # 0xa7
        Luyia                    : QLocale.Language = ... # 0xa8
        Macedonian               : QLocale.Language = ... # 0xa9
        Machame                  : QLocale.Language = ... # 0xaa
        Maithili                 : QLocale.Language = ... # 0xab
        MakhuwaMeetto            : QLocale.Language = ... # 0xac
        Makonde                  : QLocale.Language = ... # 0xad
        Malagasy                 : QLocale.Language = ... # 0xae
        Malayalam                : QLocale.Language = ... # 0xaf
        Malay                    : QLocale.Language = ... # 0xb0
        Maltese                  : QLocale.Language = ... # 0xb1
        Mandingo                 : QLocale.Language = ... # 0xb2
        Manipuri                 : QLocale.Language = ... # 0xb3
        Manx                     : QLocale.Language = ... # 0xb4
        Maori                    : QLocale.Language = ... # 0xb5
        Mapuche                  : QLocale.Language = ... # 0xb6
        Marathi                  : QLocale.Language = ... # 0xb7
        Marshallese              : QLocale.Language = ... # 0xb8
        Masai                    : QLocale.Language = ... # 0xb9
        Mazanderani              : QLocale.Language = ... # 0xba
        Mende                    : QLocale.Language = ... # 0xbb
        Meru                     : QLocale.Language = ... # 0xbc
        Meta                     : QLocale.Language = ... # 0xbd
        Mohawk                   : QLocale.Language = ... # 0xbe
        Mongolian                : QLocale.Language = ... # 0xbf
        Morisyen                 : QLocale.Language = ... # 0xc0
        Mundang                  : QLocale.Language = ... # 0xc1
        Muscogee                 : QLocale.Language = ... # 0xc2
        Nama                     : QLocale.Language = ... # 0xc3
        NauruLanguage            : QLocale.Language = ... # 0xc4
        Navaho                   : QLocale.Language = ... # 0xc5
        Navajo                   : QLocale.Language = ... # 0xc5
        Ndonga                   : QLocale.Language = ... # 0xc6
        Nepali                   : QLocale.Language = ... # 0xc7
        Newari                   : QLocale.Language = ... # 0xc8
        Ngiemboon                : QLocale.Language = ... # 0xc9
        Ngomba                   : QLocale.Language = ... # 0xca
        NigerianPidgin           : QLocale.Language = ... # 0xcb
        Nko                      : QLocale.Language = ... # 0xcc
        NorthernLuri             : QLocale.Language = ... # 0xcd
        NorthernSami             : QLocale.Language = ... # 0xce
        NorthernSotho            : QLocale.Language = ... # 0xcf
        NorthNdebele             : QLocale.Language = ... # 0xd0
        NorwegianBokmal          : QLocale.Language = ... # 0xd1
        NorwegianNynorsk         : QLocale.Language = ... # 0xd2
        Nuer                     : QLocale.Language = ... # 0xd3
        Chewa                    : QLocale.Language = ... # 0xd4
        Nyanja                   : QLocale.Language = ... # 0xd4
        Nyankole                 : QLocale.Language = ... # 0xd5
        Occitan                  : QLocale.Language = ... # 0xd6
        Odia                     : QLocale.Language = ... # 0xd7
        Oriya                    : QLocale.Language = ... # 0xd7
        Ojibwa                   : QLocale.Language = ... # 0xd8
        OldIrish                 : QLocale.Language = ... # 0xd9
        OldNorse                 : QLocale.Language = ... # 0xda
        OldPersian               : QLocale.Language = ... # 0xdb
        Afan                     : QLocale.Language = ... # 0xdc
        Oromo                    : QLocale.Language = ... # 0xdc
        Osage                    : QLocale.Language = ... # 0xdd
        Ossetic                  : QLocale.Language = ... # 0xde
        Pahlavi                  : QLocale.Language = ... # 0xdf
        Palauan                  : QLocale.Language = ... # 0xe0
        Pali                     : QLocale.Language = ... # 0xe1
        Papiamento               : QLocale.Language = ... # 0xe2
        Pashto                   : QLocale.Language = ... # 0xe3
        Persian                  : QLocale.Language = ... # 0xe4
        Phoenician               : QLocale.Language = ... # 0xe5
        Polish                   : QLocale.Language = ... # 0xe6
        Portuguese               : QLocale.Language = ... # 0xe7
        Prussian                 : QLocale.Language = ... # 0xe8
        Punjabi                  : QLocale.Language = ... # 0xe9
        Quechua                  : QLocale.Language = ... # 0xea
        Romanian                 : QLocale.Language = ... # 0xeb
        RhaetoRomance            : QLocale.Language = ... # 0xec
        Romansh                  : QLocale.Language = ... # 0xec
        Rombo                    : QLocale.Language = ... # 0xed
        Kurundi                  : QLocale.Language = ... # 0xee
        Rundi                    : QLocale.Language = ... # 0xee
        Russian                  : QLocale.Language = ... # 0xef
        Rwa                      : QLocale.Language = ... # 0xf0
        Saho                     : QLocale.Language = ... # 0xf1
        Sakha                    : QLocale.Language = ... # 0xf2
        Samburu                  : QLocale.Language = ... # 0xf3
        Samoan                   : QLocale.Language = ... # 0xf4
        Sango                    : QLocale.Language = ... # 0xf5
        Sangu                    : QLocale.Language = ... # 0xf6
        Sanskrit                 : QLocale.Language = ... # 0xf7
        Santali                  : QLocale.Language = ... # 0xf8
        Sardinian                : QLocale.Language = ... # 0xf9
        Saurashtra               : QLocale.Language = ... # 0xfa
        Sena                     : QLocale.Language = ... # 0xfb
        Serbian                  : QLocale.Language = ... # 0xfc
        Shambala                 : QLocale.Language = ... # 0xfd
        Shona                    : QLocale.Language = ... # 0xfe
        SichuanYi                : QLocale.Language = ... # 0xff
        Sicilian                 : QLocale.Language = ... # 0x100
        Sidamo                   : QLocale.Language = ... # 0x101
        Silesian                 : QLocale.Language = ... # 0x102
        Sindhi                   : QLocale.Language = ... # 0x103
        Sinhala                  : QLocale.Language = ... # 0x104
        SkoltSami                : QLocale.Language = ... # 0x105
        Slovak                   : QLocale.Language = ... # 0x106
        Slovenian                : QLocale.Language = ... # 0x107
        Soga                     : QLocale.Language = ... # 0x108
        Somali                   : QLocale.Language = ... # 0x109
        SouthernKurdish          : QLocale.Language = ... # 0x10a
        SouthernSami             : QLocale.Language = ... # 0x10b
        SouthernSotho            : QLocale.Language = ... # 0x10c
        SouthNdebele             : QLocale.Language = ... # 0x10d
        Spanish                  : QLocale.Language = ... # 0x10e
        StandardMoroccanTamazight: QLocale.Language = ... # 0x10f
        Sundanese                : QLocale.Language = ... # 0x110
        Swahili                  : QLocale.Language = ... # 0x111
        Swati                    : QLocale.Language = ... # 0x112
        Swedish                  : QLocale.Language = ... # 0x113
        SwissGerman              : QLocale.Language = ... # 0x114
        Syriac                   : QLocale.Language = ... # 0x115
        Tachelhit                : QLocale.Language = ... # 0x116
        Tahitian                 : QLocale.Language = ... # 0x117
        TaiDam                   : QLocale.Language = ... # 0x118
        Taita                    : QLocale.Language = ... # 0x119
        Tajik                    : QLocale.Language = ... # 0x11a
        Tamil                    : QLocale.Language = ... # 0x11b
        Taroko                   : QLocale.Language = ... # 0x11c
        Tasawaq                  : QLocale.Language = ... # 0x11d
        Tatar                    : QLocale.Language = ... # 0x11e
        Telugu                   : QLocale.Language = ... # 0x11f
        Teso                     : QLocale.Language = ... # 0x120
        Thai                     : QLocale.Language = ... # 0x121
        Tibetan                  : QLocale.Language = ... # 0x122
        Tigre                    : QLocale.Language = ... # 0x123
        Tigrinya                 : QLocale.Language = ... # 0x124
        TokelauLanguage          : QLocale.Language = ... # 0x125
        TokPisin                 : QLocale.Language = ... # 0x126
        Tongan                   : QLocale.Language = ... # 0x127
        Tsonga                   : QLocale.Language = ... # 0x128
        Tswana                   : QLocale.Language = ... # 0x129
        Turkish                  : QLocale.Language = ... # 0x12a
        Turkmen                  : QLocale.Language = ... # 0x12b
        TuvaluLanguage           : QLocale.Language = ... # 0x12c
        Tyap                     : QLocale.Language = ... # 0x12d
        Ugaritic                 : QLocale.Language = ... # 0x12e
        Ukrainian                : QLocale.Language = ... # 0x12f
        UpperSorbian             : QLocale.Language = ... # 0x130
        Urdu                     : QLocale.Language = ... # 0x131
        Uighur                   : QLocale.Language = ... # 0x132
        Uigur                    : QLocale.Language = ... # 0x132
        Uyghur                   : QLocale.Language = ... # 0x132
        Uzbek                    : QLocale.Language = ... # 0x133
        Vai                      : QLocale.Language = ... # 0x134
        Venda                    : QLocale.Language = ... # 0x135
        Vietnamese               : QLocale.Language = ... # 0x136
        Volapuk                  : QLocale.Language = ... # 0x137
        Vunjo                    : QLocale.Language = ... # 0x138
        Walloon                  : QLocale.Language = ... # 0x139
        Walser                   : QLocale.Language = ... # 0x13a
        Warlpiri                 : QLocale.Language = ... # 0x13b
        Welsh                    : QLocale.Language = ... # 0x13c
        WesternBalochi           : QLocale.Language = ... # 0x13d
        Frisian                  : QLocale.Language = ... # 0x13e
        WesternFrisian           : QLocale.Language = ... # 0x13e
        Walamo                   : QLocale.Language = ... # 0x13f
        Wolaytta                 : QLocale.Language = ... # 0x13f
        Wolof                    : QLocale.Language = ... # 0x140
        Xhosa                    : QLocale.Language = ... # 0x141
        Yangben                  : QLocale.Language = ... # 0x142
        Yiddish                  : QLocale.Language = ... # 0x143
        Yoruba                   : QLocale.Language = ... # 0x144
        Zarma                    : QLocale.Language = ... # 0x145
        Zhuang                   : QLocale.Language = ... # 0x146
        LastLanguage             : QLocale.Language = ... # 0x147
        Zulu                     : QLocale.Language = ... # 0x147

    class MeasurementSystem(object):
        MetricSystem             : QLocale.MeasurementSystem = ... # 0x0
        ImperialSystem           : QLocale.MeasurementSystem = ... # 0x1
        ImperialUSSystem         : QLocale.MeasurementSystem = ... # 0x1
        ImperialUKSystem         : QLocale.MeasurementSystem = ... # 0x2

    class NumberOption(object):
        DefaultNumberOptions     : QLocale.NumberOption = ... # 0x0
        OmitGroupSeparator       : QLocale.NumberOption = ... # 0x1
        RejectGroupSeparator     : QLocale.NumberOption = ... # 0x2
        OmitLeadingZeroInExponent: QLocale.NumberOption = ... # 0x4
        RejectLeadingZeroInExponent: QLocale.NumberOption = ... # 0x8
        IncludeTrailingZeroesAfterDot: QLocale.NumberOption = ... # 0x10
        RejectTrailingZeroesAfterDot: QLocale.NumberOption = ... # 0x20

    class NumberOptions(object): ...

    class QuotationStyle(object):
        StandardQuotation        : QLocale.QuotationStyle = ... # 0x0
        AlternateQuotation       : QLocale.QuotationStyle = ... # 0x1

    class Script(object):
        AnyScript                : QLocale.Script = ... # 0x0
        AdlamScript              : QLocale.Script = ... # 0x1
        AhomScript               : QLocale.Script = ... # 0x2
        AnatolianHieroglyphsScript: QLocale.Script = ... # 0x3
        ArabicScript             : QLocale.Script = ... # 0x4
        ArmenianScript           : QLocale.Script = ... # 0x5
        AvestanScript            : QLocale.Script = ... # 0x6
        BalineseScript           : QLocale.Script = ... # 0x7
        BamumScript              : QLocale.Script = ... # 0x8
        BanglaScript             : QLocale.Script = ... # 0x9
        BengaliScript            : QLocale.Script = ... # 0x9
        BassaVahScript           : QLocale.Script = ... # 0xa
        BatakScript              : QLocale.Script = ... # 0xb
        BhaiksukiScript          : QLocale.Script = ... # 0xc
        BopomofoScript           : QLocale.Script = ... # 0xd
        BrahmiScript             : QLocale.Script = ... # 0xe
        BrailleScript            : QLocale.Script = ... # 0xf
        BugineseScript           : QLocale.Script = ... # 0x10
        BuhidScript              : QLocale.Script = ... # 0x11
        CanadianAboriginalScript : QLocale.Script = ... # 0x12
        CarianScript             : QLocale.Script = ... # 0x13
        CaucasianAlbanianScript  : QLocale.Script = ... # 0x14
        ChakmaScript             : QLocale.Script = ... # 0x15
        ChamScript               : QLocale.Script = ... # 0x16
        CherokeeScript           : QLocale.Script = ... # 0x17
        CopticScript             : QLocale.Script = ... # 0x18
        CuneiformScript          : QLocale.Script = ... # 0x19
        CypriotScript            : QLocale.Script = ... # 0x1a
        CyrillicScript           : QLocale.Script = ... # 0x1b
        DeseretScript            : QLocale.Script = ... # 0x1c
        DevanagariScript         : QLocale.Script = ... # 0x1d
        DuployanScript           : QLocale.Script = ... # 0x1e
        EgyptianHieroglyphsScript: QLocale.Script = ... # 0x1f
        ElbasanScript            : QLocale.Script = ... # 0x20
        EthiopicScript           : QLocale.Script = ... # 0x21
        FraserScript             : QLocale.Script = ... # 0x22
        GeorgianScript           : QLocale.Script = ... # 0x23
        GlagoliticScript         : QLocale.Script = ... # 0x24
        GothicScript             : QLocale.Script = ... # 0x25
        GranthaScript            : QLocale.Script = ... # 0x26
        GreekScript              : QLocale.Script = ... # 0x27
        GujaratiScript           : QLocale.Script = ... # 0x28
        GurmukhiScript           : QLocale.Script = ... # 0x29
        HangulScript             : QLocale.Script = ... # 0x2a
        HanScript                : QLocale.Script = ... # 0x2b
        HanunooScript            : QLocale.Script = ... # 0x2c
        HanWithBopomofoScript    : QLocale.Script = ... # 0x2d
        HatranScript             : QLocale.Script = ... # 0x2e
        HebrewScript             : QLocale.Script = ... # 0x2f
        HiraganaScript           : QLocale.Script = ... # 0x30
        ImperialAramaicScript    : QLocale.Script = ... # 0x31
        InscriptionalPahlaviScript: QLocale.Script = ... # 0x32
        InscriptionalParthianScript: QLocale.Script = ... # 0x33
        JamoScript               : QLocale.Script = ... # 0x34
        JapaneseScript           : QLocale.Script = ... # 0x35
        JavaneseScript           : QLocale.Script = ... # 0x36
        KaithiScript             : QLocale.Script = ... # 0x37
        KannadaScript            : QLocale.Script = ... # 0x38
        KatakanaScript           : QLocale.Script = ... # 0x39
        KayahLiScript            : QLocale.Script = ... # 0x3a
        KharoshthiScript         : QLocale.Script = ... # 0x3b
        KhmerScript              : QLocale.Script = ... # 0x3c
        KhojkiScript             : QLocale.Script = ... # 0x3d
        KhudawadiScript          : QLocale.Script = ... # 0x3e
        KoreanScript             : QLocale.Script = ... # 0x3f
        LannaScript              : QLocale.Script = ... # 0x40
        LaoScript                : QLocale.Script = ... # 0x41
        LatinScript              : QLocale.Script = ... # 0x42
        LepchaScript             : QLocale.Script = ... # 0x43
        LimbuScript              : QLocale.Script = ... # 0x44
        LinearAScript            : QLocale.Script = ... # 0x45
        LinearBScript            : QLocale.Script = ... # 0x46
        LycianScript             : QLocale.Script = ... # 0x47
        LydianScript             : QLocale.Script = ... # 0x48
        MahajaniScript           : QLocale.Script = ... # 0x49
        MalayalamScript          : QLocale.Script = ... # 0x4a
        MandaeanScript           : QLocale.Script = ... # 0x4b
        ManichaeanScript         : QLocale.Script = ... # 0x4c
        MarchenScript            : QLocale.Script = ... # 0x4d
        MeiteiMayekScript        : QLocale.Script = ... # 0x4e
        MendeKikakuiScript       : QLocale.Script = ... # 0x4f
        MendeScript              : QLocale.Script = ... # 0x4f
        MeroiticCursiveScript    : QLocale.Script = ... # 0x50
        MeroiticScript           : QLocale.Script = ... # 0x51
        ModiScript               : QLocale.Script = ... # 0x52
        MongolianScript          : QLocale.Script = ... # 0x53
        MroScript                : QLocale.Script = ... # 0x54
        MultaniScript            : QLocale.Script = ... # 0x55
        MyanmarScript            : QLocale.Script = ... # 0x56
        NabataeanScript          : QLocale.Script = ... # 0x57
        NewaScript               : QLocale.Script = ... # 0x58
        NewTaiLueScript          : QLocale.Script = ... # 0x59
        NkoScript                : QLocale.Script = ... # 0x5a
        OdiaScript               : QLocale.Script = ... # 0x5b
        OriyaScript              : QLocale.Script = ... # 0x5b
        OghamScript              : QLocale.Script = ... # 0x5c
        OlChikiScript            : QLocale.Script = ... # 0x5d
        OldHungarianScript       : QLocale.Script = ... # 0x5e
        OldItalicScript          : QLocale.Script = ... # 0x5f
        OldNorthArabianScript    : QLocale.Script = ... # 0x60
        OldPermicScript          : QLocale.Script = ... # 0x61
        OldPersianScript         : QLocale.Script = ... # 0x62
        OldSouthArabianScript    : QLocale.Script = ... # 0x63
        OrkhonScript             : QLocale.Script = ... # 0x64
        OsageScript              : QLocale.Script = ... # 0x65
        OsmanyaScript            : QLocale.Script = ... # 0x66
        PahawhHmongScript        : QLocale.Script = ... # 0x67
        PalmyreneScript          : QLocale.Script = ... # 0x68
        PauCinHauScript          : QLocale.Script = ... # 0x69
        PhagsPaScript            : QLocale.Script = ... # 0x6a
        PhoenicianScript         : QLocale.Script = ... # 0x6b
        PollardPhoneticScript    : QLocale.Script = ... # 0x6c
        PsalterPahlaviScript     : QLocale.Script = ... # 0x6d
        RejangScript             : QLocale.Script = ... # 0x6e
        RunicScript              : QLocale.Script = ... # 0x6f
        SamaritanScript          : QLocale.Script = ... # 0x70
        SaurashtraScript         : QLocale.Script = ... # 0x71
        SharadaScript            : QLocale.Script = ... # 0x72
        ShavianScript            : QLocale.Script = ... # 0x73
        SiddhamScript            : QLocale.Script = ... # 0x74
        SignWritingScript        : QLocale.Script = ... # 0x75
        SimplifiedChineseScript  : QLocale.Script = ... # 0x76
        SimplifiedHanScript      : QLocale.Script = ... # 0x76
        SinhalaScript            : QLocale.Script = ... # 0x77
        SoraSompengScript        : QLocale.Script = ... # 0x78
        SundaneseScript          : QLocale.Script = ... # 0x79
        SylotiNagriScript        : QLocale.Script = ... # 0x7a
        SyriacScript             : QLocale.Script = ... # 0x7b
        TagalogScript            : QLocale.Script = ... # 0x7c
        TagbanwaScript           : QLocale.Script = ... # 0x7d
        TaiLeScript              : QLocale.Script = ... # 0x7e
        TaiVietScript            : QLocale.Script = ... # 0x7f
        TakriScript              : QLocale.Script = ... # 0x80
        TamilScript              : QLocale.Script = ... # 0x81
        TangutScript             : QLocale.Script = ... # 0x82
        TeluguScript             : QLocale.Script = ... # 0x83
        ThaanaScript             : QLocale.Script = ... # 0x84
        ThaiScript               : QLocale.Script = ... # 0x85
        TibetanScript            : QLocale.Script = ... # 0x86
        TifinaghScript           : QLocale.Script = ... # 0x87
        TirhutaScript            : QLocale.Script = ... # 0x88
        TraditionalChineseScript : QLocale.Script = ... # 0x89
        TraditionalHanScript     : QLocale.Script = ... # 0x89
        UgariticScript           : QLocale.Script = ... # 0x8a
        VaiScript                : QLocale.Script = ... # 0x8b
        VarangKshitiScript       : QLocale.Script = ... # 0x8c
        LastScript               : QLocale.Script = ... # 0x8d
        YiScript                 : QLocale.Script = ... # 0x8d

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, language:PySide6.QtCore.QLocale.Language, country:PySide6.QtCore.QLocale.Country=...) -> None: ...
    @typing.overload
    def __init__(self, language:PySide6.QtCore.QLocale.Language, script:PySide6.QtCore.QLocale.Script, country:PySide6.QtCore.QLocale.Country) -> None: ...
    @typing.overload
    def __init__(self, name:str) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QLocale) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def amText(self) -> str: ...
    def bcp47Name(self) -> str: ...
    @staticmethod
    def c() -> PySide6.QtCore.QLocale: ...
    def collation(self) -> PySide6.QtCore.QLocale: ...
    @staticmethod
    def countriesForLanguage(lang:PySide6.QtCore.QLocale.Language) -> typing.List: ...
    def country(self) -> PySide6.QtCore.QLocale.Country: ...
    @staticmethod
    def countryToString(country:PySide6.QtCore.QLocale.Country) -> str: ...
    def createSeparatedList(self, strl:typing.Sequence) -> str: ...
    def currencySymbol(self, arg__1:PySide6.QtCore.QLocale.CurrencySymbolFormat=...) -> str: ...
    def dateFormat(self, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def dateTimeFormat(self, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def dayName(self, arg__1:int, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def decimalPoint(self) -> str: ...
    def exponential(self) -> str: ...
    def firstDayOfWeek(self) -> PySide6.QtCore.Qt.DayOfWeek: ...
    def formattedDataSize(self, bytes:int, precision:int=..., format:PySide6.QtCore.QLocale.DataSizeFormats=...) -> str: ...
    def groupSeparator(self) -> str: ...
    def language(self) -> PySide6.QtCore.QLocale.Language: ...
    @staticmethod
    def languageToString(language:PySide6.QtCore.QLocale.Language) -> str: ...
    @staticmethod
    def matchingLocales(language:PySide6.QtCore.QLocale.Language, script:PySide6.QtCore.QLocale.Script, country:PySide6.QtCore.QLocale.Country) -> typing.List: ...
    def measurementSystem(self) -> PySide6.QtCore.QLocale.MeasurementSystem: ...
    def monthName(self, arg__1:int, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def name(self) -> str: ...
    def nativeCountryName(self) -> str: ...
    def nativeLanguageName(self) -> str: ...
    def negativeSign(self) -> str: ...
    def numberOptions(self) -> PySide6.QtCore.QLocale.NumberOptions: ...
    def percent(self) -> str: ...
    def pmText(self) -> str: ...
    def positiveSign(self) -> str: ...
    def quoteString(self, str:str, style:PySide6.QtCore.QLocale.QuotationStyle=...) -> str: ...
    def script(self) -> PySide6.QtCore.QLocale.Script: ...
    @staticmethod
    def scriptToString(script:PySide6.QtCore.QLocale.Script) -> str: ...
    @staticmethod
    def setDefault(locale:PySide6.QtCore.QLocale) -> None: ...
    def setNumberOptions(self, options:PySide6.QtCore.QLocale.NumberOptions) -> None: ...
    def standaloneDayName(self, arg__1:int, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def standaloneMonthName(self, arg__1:int, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    def swap(self, other:PySide6.QtCore.QLocale) -> None: ...
    @staticmethod
    def system() -> PySide6.QtCore.QLocale: ...
    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def timeFormat(self, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1:float, symbol:str=..., precision:int=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1:int, symbol:str=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1:int, symbol:str=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, i:float, symbol:str=..., precision:int=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, i:int, symbol:str=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, i:int, symbol:str=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, i:int, symbol:str=...) -> str: ...
    @typing.overload
    def toCurrencyString(self, i:int, symbol:str=...) -> str: ...
    @typing.overload
    def toDate(self, string:str, format:PySide6.QtCore.QLocale.FormatType, cal:PySide6.QtCore.QCalendar) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDate(self, string:str, format:PySide6.QtCore.QLocale.FormatType=...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDate(self, string:str, format:str) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDate(self, string:str, format:str, cal:PySide6.QtCore.QCalendar) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDateTime(self, string:str, format:PySide6.QtCore.QLocale.FormatType, cal:PySide6.QtCore.QCalendar) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def toDateTime(self, string:str, format:PySide6.QtCore.QLocale.FormatType=...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def toDateTime(self, string:str, format:str) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def toDateTime(self, string:str, format:str, cal:PySide6.QtCore.QCalendar) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def toDouble(self, s:str) -> typing.Tuple: ...
    @typing.overload
    def toDouble(self, s:str) -> typing.Tuple: ...
    @typing.overload
    def toFloat(self, s:str) -> typing.Tuple: ...
    @typing.overload
    def toFloat(self, s:str) -> typing.Tuple: ...
    def toInt(self, s:str) -> typing.Tuple: ...
    def toLong(self, s:str) -> typing.Tuple: ...
    def toLongLong(self, s:str) -> typing.Tuple: ...
    def toLower(self, str:str) -> str: ...
    def toShort(self, s:str) -> typing.Tuple: ...
    @typing.overload
    def toString(self, date:PySide6.QtCore.QDate, format:PySide6.QtCore.QLocale.FormatType, cal:PySide6.QtCore.QCalendar) -> str: ...
    @typing.overload
    def toString(self, date:PySide6.QtCore.QDate, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    @typing.overload
    def toString(self, date:PySide6.QtCore.QDate, format:str) -> str: ...
    @typing.overload
    def toString(self, date:PySide6.QtCore.QDate, format:str, cal:PySide6.QtCore.QCalendar) -> str: ...
    @typing.overload
    def toString(self, dateTime:PySide6.QtCore.QDateTime, format:PySide6.QtCore.QLocale.FormatType, cal:PySide6.QtCore.QCalendar) -> str: ...
    @typing.overload
    def toString(self, dateTime:PySide6.QtCore.QDateTime, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    @typing.overload
    def toString(self, dateTime:PySide6.QtCore.QDateTime, format:str) -> str: ...
    @typing.overload
    def toString(self, dateTime:PySide6.QtCore.QDateTime, format:str, cal:PySide6.QtCore.QCalendar) -> str: ...
    @typing.overload
    def toString(self, i:float, f:int=..., prec:int=...) -> str: ...
    @typing.overload
    def toString(self, i:float, f:int=..., prec:int=...) -> str: ...
    @typing.overload
    def toString(self, i:int) -> str: ...
    @typing.overload
    def toString(self, i:int) -> str: ...
    @typing.overload
    def toString(self, i:int) -> str: ...
    @typing.overload
    def toString(self, i:int) -> str: ...
    @typing.overload
    def toString(self, i:int) -> str: ...
    @typing.overload
    def toString(self, time:PySide6.QtCore.QTime, format:PySide6.QtCore.QLocale.FormatType=...) -> str: ...
    @typing.overload
    def toString(self, time:PySide6.QtCore.QTime, format:str) -> str: ...
    @typing.overload
    def toTime(self, string:str, format:PySide6.QtCore.QLocale.FormatType=...) -> PySide6.QtCore.QTime: ...
    @typing.overload
    def toTime(self, string:str, format:str) -> PySide6.QtCore.QTime: ...
    @typing.overload
    def toUInt(self, s:str) -> typing.Tuple: ...
    @typing.overload
    def toUInt(self, s:str) -> typing.Tuple: ...
    def toULong(self, s:str) -> typing.Tuple: ...
    @typing.overload
    def toULongLong(self, s:str) -> typing.Tuple: ...
    @typing.overload
    def toULongLong(self, s:str) -> typing.Tuple: ...
    def toUShort(self, s:str) -> typing.Tuple: ...
    def toUpper(self, str:str) -> str: ...
    def uiLanguages(self) -> typing.List: ...
    def weekdays(self) -> typing.List: ...
    def zeroDigit(self) -> str: ...


class QLockFile(Shiboken.Object):
    NoError                  : QLockFile = ... # 0x0
    LockFailedError          : QLockFile = ... # 0x1
    PermissionError          : QLockFile = ... # 0x2
    UnknownError             : QLockFile = ... # 0x3

    class LockError(object):
        NoError                  : QLockFile.LockError = ... # 0x0
        LockFailedError          : QLockFile.LockError = ... # 0x1
        PermissionError          : QLockFile.LockError = ... # 0x2
        UnknownError             : QLockFile.LockError = ... # 0x3

    def __init__(self, fileName:str) -> None: ...

    def error(self) -> PySide6.QtCore.QLockFile.LockError: ...
    def fileName(self) -> str: ...
    def getLockInfo(self) -> typing.Tuple: ...
    def isLocked(self) -> bool: ...
    def lock(self) -> bool: ...
    def removeStaleLockFile(self) -> bool: ...
    def setStaleLockTime(self, arg__1:int) -> None: ...
    def staleLockTime(self) -> int: ...
    def tryLock(self, timeout:int=...) -> bool: ...
    def unlock(self) -> None: ...


class QMargins(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMargins:PySide6.QtCore.QMargins) -> None: ...
    @typing.overload
    def __init__(self, left:int, top:int, right:int, bottom:int) -> None: ...

    @typing.overload
    def __add__(self, lhs:int) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __add__(self, m2:PySide6.QtCore.QMargins) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __add__(self, rhs:int) -> PySide6.QtCore.QMargins: ...
    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def __iadd__(self, arg__1:int) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __iadd__(self, margins:PySide6.QtCore.QMargins) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __imul__(self, arg__1:int) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __imul__(self, arg__1:float) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __isub__(self, arg__1:int) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __isub__(self, margins:PySide6.QtCore.QMargins) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __mul__(self, factor:int) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide6.QtCore.QMargins: ...
    def __neg__(self) -> PySide6.QtCore.QMargins: ...
    def __or__(self, m2:PySide6.QtCore.QMargins) -> PySide6.QtCore.QMargins: ...
    def __pos__(self) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __sub__(self, m2:PySide6.QtCore.QMargins) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __sub__(self, rhs:int) -> PySide6.QtCore.QMargins: ...
    def bottom(self) -> int: ...
    def isNull(self) -> bool: ...
    def left(self) -> int: ...
    def right(self) -> int: ...
    def setBottom(self, bottom:int) -> None: ...
    def setLeft(self, left:int) -> None: ...
    def setRight(self, right:int) -> None: ...
    def setTop(self, top:int) -> None: ...
    def top(self) -> int: ...


class QMarginsF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMarginsF:PySide6.QtCore.QMarginsF) -> None: ...
    @typing.overload
    def __init__(self, left:float, top:float, right:float, bottom:float) -> None: ...
    @typing.overload
    def __init__(self, margins:PySide6.QtCore.QMargins) -> None: ...

    @typing.overload
    def __add__(self, lhs:float) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __add__(self, rhs:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __add__(self, rhs:float) -> PySide6.QtCore.QMarginsF: ...
    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def __iadd__(self, addend:float) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __iadd__(self, margins:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QMarginsF: ...
    def __imul__(self, factor:float) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __isub__(self, margins:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __isub__(self, subtrahend:float) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __mul__(self, lhs:float) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __mul__(self, rhs:float) -> PySide6.QtCore.QMarginsF: ...
    def __neg__(self) -> PySide6.QtCore.QMarginsF: ...
    def __or__(self, m2:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QMarginsF: ...
    def __pos__(self) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __sub__(self, rhs:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __sub__(self, rhs:float) -> PySide6.QtCore.QMarginsF: ...
    def bottom(self) -> float: ...
    def isNull(self) -> bool: ...
    def left(self) -> float: ...
    def right(self) -> float: ...
    def setBottom(self, bottom:float) -> None: ...
    def setLeft(self, left:float) -> None: ...
    def setRight(self, right:float) -> None: ...
    def setTop(self, top:float) -> None: ...
    def toMargins(self) -> PySide6.QtCore.QMargins: ...
    def top(self) -> float: ...


class QMessageAuthenticationCode(Shiboken.Object):

    def __init__(self, method:PySide6.QtCore.QCryptographicHash.Algorithm, key:PySide6.QtCore.QByteArray=...) -> None: ...

    @typing.overload
    def addData(self, data:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def addData(self, data:bytes, length:int) -> None: ...
    @typing.overload
    def addData(self, device:PySide6.QtCore.QIODevice) -> bool: ...
    @staticmethod
    def hash(message:PySide6.QtCore.QByteArray, key:PySide6.QtCore.QByteArray, method:PySide6.QtCore.QCryptographicHash.Algorithm) -> PySide6.QtCore.QByteArray: ...
    def reset(self) -> None: ...
    def result(self) -> PySide6.QtCore.QByteArray: ...
    def setKey(self, key:PySide6.QtCore.QByteArray) -> None: ...


class QMessageLogContext(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName:bytes, lineNumber:int, functionName:bytes, categoryName:bytes) -> None: ...


class QMetaClassInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMetaClassInfo:PySide6.QtCore.QMetaClassInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> bytes: ...
    def value(self) -> bytes: ...


class QMetaEnum(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMetaEnum:PySide6.QtCore.QMetaEnum) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def enumName(self) -> bytes: ...
    def isFlag(self) -> bool: ...
    def isScoped(self) -> bool: ...
    def isValid(self) -> bool: ...
    def key(self, index:int) -> bytes: ...
    def keyCount(self) -> int: ...
    def keyToValue(self, key:bytes) -> typing.Tuple: ...
    def keysToValue(self, keys:bytes) -> typing.Tuple: ...
    def name(self) -> bytes: ...
    def scope(self) -> bytes: ...
    def value(self, index:int) -> int: ...
    def valueToKey(self, value:int) -> bytes: ...
    def valueToKeys(self, value:int) -> PySide6.QtCore.QByteArray: ...


class QMetaMethod(Shiboken.Object):
    Method                   : QMetaMethod = ... # 0x0
    Private                  : QMetaMethod = ... # 0x0
    Protected                : QMetaMethod = ... # 0x1
    Signal                   : QMetaMethod = ... # 0x1
    Public                   : QMetaMethod = ... # 0x2
    Slot                     : QMetaMethod = ... # 0x2
    Constructor              : QMetaMethod = ... # 0x3

    class Access(object):
        Private                  : QMetaMethod.Access = ... # 0x0
        Protected                : QMetaMethod.Access = ... # 0x1
        Public                   : QMetaMethod.Access = ... # 0x2

    class MethodType(object):
        Method                   : QMetaMethod.MethodType = ... # 0x0
        Signal                   : QMetaMethod.MethodType = ... # 0x1
        Slot                     : QMetaMethod.MethodType = ... # 0x2
        Constructor              : QMetaMethod.MethodType = ... # 0x3

    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def access(self) -> PySide6.QtCore.QMetaMethod.Access: ...
    def enclosingMetaObject(self) -> PySide6.QtCore.QMetaObject: ...
    @typing.overload
    def invoke(self, object:PySide6.QtCore.QObject, connectionType:PySide6.QtCore.Qt.ConnectionType, returnValue:PySide6.QtCore.QGenericReturnArgument, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    def invoke(self, object:PySide6.QtCore.QObject, connectionType:PySide6.QtCore.Qt.ConnectionType, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    def invoke(self, object:PySide6.QtCore.QObject, returnValue:PySide6.QtCore.QGenericReturnArgument, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    def invoke(self, object:PySide6.QtCore.QObject, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    def invokeOnGadget(self, gadget:int, returnValue:PySide6.QtCore.QGenericReturnArgument, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    def invokeOnGadget(self, gadget:int, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    def isValid(self) -> bool: ...
    def methodIndex(self) -> int: ...
    def methodSignature(self) -> PySide6.QtCore.QByteArray: ...
    def methodType(self) -> PySide6.QtCore.QMetaMethod.MethodType: ...
    def name(self) -> PySide6.QtCore.QByteArray: ...
    def parameterCount(self) -> int: ...
    def parameterMetaType(self, index:int) -> PySide6.QtCore.QMetaType: ...
    def parameterNames(self) -> typing.List: ...
    def parameterType(self, index:int) -> int: ...
    def parameterTypeName(self, index:int) -> PySide6.QtCore.QByteArray: ...
    def parameterTypes(self) -> typing.List: ...
    def relativeMethodIndex(self) -> int: ...
    def returnMetaType(self) -> PySide6.QtCore.QMetaType: ...
    def returnType(self) -> int: ...
    def revision(self) -> int: ...
    def tag(self) -> bytes: ...
    def typeName(self) -> bytes: ...


class QMetaObject(Shiboken.Object):
    InvokeMetaMethod         : QMetaObject = ... # 0x0
    ReadProperty             : QMetaObject = ... # 0x1
    WriteProperty            : QMetaObject = ... # 0x2
    ResetProperty            : QMetaObject = ... # 0x3
    CreateInstance           : QMetaObject = ... # 0x4
    IndexOfMethod            : QMetaObject = ... # 0x5
    RegisterPropertyMetaType : QMetaObject = ... # 0x6
    RegisterMethodArgumentMetaType: QMetaObject = ... # 0x7
    BindableProperty         : QMetaObject = ... # 0x8

    class Call(object):
        InvokeMetaMethod         : QMetaObject.Call = ... # 0x0
        ReadProperty             : QMetaObject.Call = ... # 0x1
        WriteProperty            : QMetaObject.Call = ... # 0x2
        ResetProperty            : QMetaObject.Call = ... # 0x3
        CreateInstance           : QMetaObject.Call = ... # 0x4
        IndexOfMethod            : QMetaObject.Call = ... # 0x5
        RegisterPropertyMetaType : QMetaObject.Call = ... # 0x6
        RegisterMethodArgumentMetaType: QMetaObject.Call = ... # 0x7
        BindableProperty         : QMetaObject.Call = ... # 0x8

    class Connection(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other:PySide6.QtCore.QMetaObject.Connection) -> None: ...

        def swap(self, other:PySide6.QtCore.QMetaObject.Connection) -> None: ...

    def __init__(self) -> None: ...

    def cast(self, obj:PySide6.QtCore.QObject) -> PySide6.QtCore.QObject: ...
    @typing.overload
    @staticmethod
    def checkConnectArgs(signal:PySide6.QtCore.QMetaMethod, method:PySide6.QtCore.QMetaMethod) -> bool: ...
    @typing.overload
    @staticmethod
    def checkConnectArgs(signal:bytes, method:bytes) -> bool: ...
    def classInfo(self, index:int) -> PySide6.QtCore.QMetaClassInfo: ...
    def classInfoCount(self) -> int: ...
    def classInfoOffset(self) -> int: ...
    def className(self) -> bytes: ...
    @staticmethod
    def connectSlotsByName(o:PySide6.QtCore.QObject) -> None: ...
    def constructor(self, index:int) -> PySide6.QtCore.QMetaMethod: ...
    def constructorCount(self) -> int: ...
    @staticmethod
    def disconnect(sender:PySide6.QtCore.QObject, signal_index:int, receiver:PySide6.QtCore.QObject, method_index:int) -> bool: ...
    @staticmethod
    def disconnectOne(sender:PySide6.QtCore.QObject, signal_index:int, receiver:PySide6.QtCore.QObject, method_index:int) -> bool: ...
    def enumerator(self, index:int) -> PySide6.QtCore.QMetaEnum: ...
    def enumeratorCount(self) -> int: ...
    def enumeratorOffset(self) -> int: ...
    def indexOfClassInfo(self, name:bytes) -> int: ...
    def indexOfConstructor(self, constructor:bytes) -> int: ...
    def indexOfEnumerator(self, name:bytes) -> int: ...
    def indexOfMethod(self, method:bytes) -> int: ...
    def indexOfProperty(self, name:bytes) -> int: ...
    def indexOfSignal(self, signal:bytes) -> int: ...
    def indexOfSlot(self, slot:bytes) -> int: ...
    def inherits(self, metaObject:PySide6.QtCore.QMetaObject) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj:PySide6.QtCore.QObject, member:bytes, arg__3:PySide6.QtCore.Qt.ConnectionType, ret:PySide6.QtCore.QGenericReturnArgument, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj:PySide6.QtCore.QObject, member:bytes, ret:PySide6.QtCore.QGenericReturnArgument, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj:PySide6.QtCore.QObject, member:bytes, type:PySide6.QtCore.Qt.ConnectionType, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj:PySide6.QtCore.QObject, member:bytes, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> bool: ...
    def method(self, index:int) -> PySide6.QtCore.QMetaMethod: ...
    def methodCount(self) -> int: ...
    def methodOffset(self) -> int: ...
    def newInstance(self, val0:PySide6.QtCore.QGenericArgument=..., val1:PySide6.QtCore.QGenericArgument=..., val2:PySide6.QtCore.QGenericArgument=..., val3:PySide6.QtCore.QGenericArgument=..., val4:PySide6.QtCore.QGenericArgument=..., val5:PySide6.QtCore.QGenericArgument=..., val6:PySide6.QtCore.QGenericArgument=..., val7:PySide6.QtCore.QGenericArgument=..., val8:PySide6.QtCore.QGenericArgument=..., val9:PySide6.QtCore.QGenericArgument=...) -> PySide6.QtCore.QObject: ...
    @staticmethod
    def normalizedSignature(method:bytes) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def normalizedType(type:bytes) -> PySide6.QtCore.QByteArray: ...
    def property(self, index:int) -> PySide6.QtCore.QMetaProperty: ...
    def propertyCount(self) -> int: ...
    def propertyOffset(self) -> int: ...
    def superClass(self) -> PySide6.QtCore.QMetaObject: ...
    def userProperty(self) -> PySide6.QtCore.QMetaProperty: ...


class QMetaProperty(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMetaProperty:PySide6.QtCore.QMetaProperty) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def enumerator(self) -> PySide6.QtCore.QMetaEnum: ...
    def hasNotifySignal(self) -> bool: ...
    def hasStdCppSet(self) -> bool: ...
    def isAlias(self) -> bool: ...
    def isBindable(self) -> bool: ...
    def isConstant(self) -> bool: ...
    def isDesignable(self) -> bool: ...
    def isEnumType(self) -> bool: ...
    def isFinal(self) -> bool: ...
    def isFlagType(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRequired(self) -> bool: ...
    def isResettable(self) -> bool: ...
    def isScriptable(self) -> bool: ...
    def isStored(self) -> bool: ...
    def isUser(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def metaType(self) -> PySide6.QtCore.QMetaType: ...
    def name(self) -> bytes: ...
    def notifySignal(self) -> PySide6.QtCore.QMetaMethod: ...
    def notifySignalIndex(self) -> int: ...
    def propertyIndex(self) -> int: ...
    def read(self, obj:PySide6.QtCore.QObject) -> typing.Any: ...
    def readOnGadget(self, gadget:int) -> typing.Any: ...
    def relativePropertyIndex(self) -> int: ...
    def reset(self, obj:PySide6.QtCore.QObject) -> bool: ...
    def resetOnGadget(self, gadget:int) -> bool: ...
    def revision(self) -> int: ...
    def typeId(self) -> int: ...
    def typeName(self) -> bytes: ...
    def userType(self) -> int: ...
    def write(self, obj:PySide6.QtCore.QObject, value:typing.Any) -> bool: ...
    def writeOnGadget(self, gadget:int, value:typing.Any) -> bool: ...


class QMetaType(Shiboken.Object):
    UnknownType              : QMetaType = ... # 0x0
    Bool                     : QMetaType = ... # 0x1
    FirstCoreType            : QMetaType = ... # 0x1
    NeedsConstruction        : QMetaType = ... # 0x1
    Int                      : QMetaType = ... # 0x2
    NeedsDestruction         : QMetaType = ... # 0x2
    UInt                     : QMetaType = ... # 0x3
    LongLong                 : QMetaType = ... # 0x4
    MovableType              : QMetaType = ... # 0x4
    RelocatableType          : QMetaType = ... # 0x4
    ULongLong                : QMetaType = ... # 0x5
    Double                   : QMetaType = ... # 0x6
    QReal                    : QMetaType = ... # 0x6
    QChar                    : QMetaType = ... # 0x7
    PointerToQObject         : QMetaType = ... # 0x8
    QVariantMap              : QMetaType = ... # 0x8
    QVariantList             : QMetaType = ... # 0x9
    QString                  : QMetaType = ... # 0xa
    QStringList              : QMetaType = ... # 0xb
    QByteArray               : QMetaType = ... # 0xc
    QBitArray                : QMetaType = ... # 0xd
    QDate                    : QMetaType = ... # 0xe
    QTime                    : QMetaType = ... # 0xf
    IsEnumeration            : QMetaType = ... # 0x10
    QDateTime                : QMetaType = ... # 0x10
    QUrl                     : QMetaType = ... # 0x11
    QLocale                  : QMetaType = ... # 0x12
    QRect                    : QMetaType = ... # 0x13
    QRectF                   : QMetaType = ... # 0x14
    QSize                    : QMetaType = ... # 0x15
    QSizeF                   : QMetaType = ... # 0x16
    QLine                    : QMetaType = ... # 0x17
    QLineF                   : QMetaType = ... # 0x18
    QPoint                   : QMetaType = ... # 0x19
    QPointF                  : QMetaType = ... # 0x1a
    QVariantHash             : QMetaType = ... # 0x1c
    QEasingCurve             : QMetaType = ... # 0x1d
    QUuid                    : QMetaType = ... # 0x1e
    VoidStar                 : QMetaType = ... # 0x1f
    Long                     : QMetaType = ... # 0x20
    SharedPointerToQObject   : QMetaType = ... # 0x20
    Short                    : QMetaType = ... # 0x21
    Char                     : QMetaType = ... # 0x22
    ULong                    : QMetaType = ... # 0x23
    UShort                   : QMetaType = ... # 0x24
    UChar                    : QMetaType = ... # 0x25
    Float                    : QMetaType = ... # 0x26
    QObjectStar              : QMetaType = ... # 0x27
    SChar                    : QMetaType = ... # 0x28
    QVariant                 : QMetaType = ... # 0x29
    QModelIndex              : QMetaType = ... # 0x2a
    Void                     : QMetaType = ... # 0x2b
    QRegularExpression       : QMetaType = ... # 0x2c
    QJsonValue               : QMetaType = ... # 0x2d
    QJsonObject              : QMetaType = ... # 0x2e
    QJsonArray               : QMetaType = ... # 0x2f
    QJsonDocument            : QMetaType = ... # 0x30
    QByteArrayList           : QMetaType = ... # 0x31
    QPersistentModelIndex    : QMetaType = ... # 0x32
    Nullptr                  : QMetaType = ... # 0x33
    QCborSimpleType          : QMetaType = ... # 0x34
    QCborValue               : QMetaType = ... # 0x35
    QCborArray               : QMetaType = ... # 0x36
    QCborMap                 : QMetaType = ... # 0x37
    Char16                   : QMetaType = ... # 0x38
    Char32                   : QMetaType = ... # 0x39
    LastCoreType             : QMetaType = ... # 0x3a
    QVariantPair             : QMetaType = ... # 0x3a
    WeakPointerToQObject     : QMetaType = ... # 0x40
    TrackingPointerToQObject : QMetaType = ... # 0x80
    IsUnsignedEnumeration    : QMetaType = ... # 0x100
    IsGadget                 : QMetaType = ... # 0x200
    PointerToGadget          : QMetaType = ... # 0x400
    IsPointer                : QMetaType = ... # 0x800
    FirstGuiType             : QMetaType = ... # 0x1000
    IsQmlList                : QMetaType = ... # 0x1000
    QFont                    : QMetaType = ... # 0x1000
    QPixmap                  : QMetaType = ... # 0x1001
    QBrush                   : QMetaType = ... # 0x1002
    QColor                   : QMetaType = ... # 0x1003
    QPalette                 : QMetaType = ... # 0x1004
    QIcon                    : QMetaType = ... # 0x1005
    QImage                   : QMetaType = ... # 0x1006
    QPolygon                 : QMetaType = ... # 0x1007
    QRegion                  : QMetaType = ... # 0x1008
    QBitmap                  : QMetaType = ... # 0x1009
    QCursor                  : QMetaType = ... # 0x100a
    QKeySequence             : QMetaType = ... # 0x100b
    QPen                     : QMetaType = ... # 0x100c
    QTextLength              : QMetaType = ... # 0x100d
    QTextFormat              : QMetaType = ... # 0x100e
    QTransform               : QMetaType = ... # 0x1010
    QMatrix4x4               : QMetaType = ... # 0x1011
    QVector2D                : QMetaType = ... # 0x1012
    QVector3D                : QMetaType = ... # 0x1013
    QVector4D                : QMetaType = ... # 0x1014
    QQuaternion              : QMetaType = ... # 0x1015
    QPolygonF                : QMetaType = ... # 0x1016
    LastGuiType              : QMetaType = ... # 0x1017
    QColorSpace              : QMetaType = ... # 0x1017
    FirstWidgetsType         : QMetaType = ... # 0x2000
    HighestInternalId        : QMetaType = ... # 0x2000
    LastWidgetsType          : QMetaType = ... # 0x2000
    QSizePolicy              : QMetaType = ... # 0x2000
    User                     : QMetaType = ... # 0x10000

    class Type(object):
        UnknownType              : QMetaType.Type = ... # 0x0
        Bool                     : QMetaType.Type = ... # 0x1
        FirstCoreType            : QMetaType.Type = ... # 0x1
        Int                      : QMetaType.Type = ... # 0x2
        UInt                     : QMetaType.Type = ... # 0x3
        LongLong                 : QMetaType.Type = ... # 0x4
        ULongLong                : QMetaType.Type = ... # 0x5
        Double                   : QMetaType.Type = ... # 0x6
        QReal                    : QMetaType.Type = ... # 0x6
        QChar                    : QMetaType.Type = ... # 0x7
        QVariantMap              : QMetaType.Type = ... # 0x8
        QVariantList             : QMetaType.Type = ... # 0x9
        QString                  : QMetaType.Type = ... # 0xa
        QStringList              : QMetaType.Type = ... # 0xb
        QByteArray               : QMetaType.Type = ... # 0xc
        QBitArray                : QMetaType.Type = ... # 0xd
        QDate                    : QMetaType.Type = ... # 0xe
        QTime                    : QMetaType.Type = ... # 0xf
        QDateTime                : QMetaType.Type = ... # 0x10
        QUrl                     : QMetaType.Type = ... # 0x11
        QLocale                  : QMetaType.Type = ... # 0x12
        QRect                    : QMetaType.Type = ... # 0x13
        QRectF                   : QMetaType.Type = ... # 0x14
        QSize                    : QMetaType.Type = ... # 0x15
        QSizeF                   : QMetaType.Type = ... # 0x16
        QLine                    : QMetaType.Type = ... # 0x17
        QLineF                   : QMetaType.Type = ... # 0x18
        QPoint                   : QMetaType.Type = ... # 0x19
        QPointF                  : QMetaType.Type = ... # 0x1a
        QVariantHash             : QMetaType.Type = ... # 0x1c
        QEasingCurve             : QMetaType.Type = ... # 0x1d
        QUuid                    : QMetaType.Type = ... # 0x1e
        VoidStar                 : QMetaType.Type = ... # 0x1f
        Long                     : QMetaType.Type = ... # 0x20
        Short                    : QMetaType.Type = ... # 0x21
        Char                     : QMetaType.Type = ... # 0x22
        ULong                    : QMetaType.Type = ... # 0x23
        UShort                   : QMetaType.Type = ... # 0x24
        UChar                    : QMetaType.Type = ... # 0x25
        Float                    : QMetaType.Type = ... # 0x26
        QObjectStar              : QMetaType.Type = ... # 0x27
        SChar                    : QMetaType.Type = ... # 0x28
        QVariant                 : QMetaType.Type = ... # 0x29
        QModelIndex              : QMetaType.Type = ... # 0x2a
        Void                     : QMetaType.Type = ... # 0x2b
        QRegularExpression       : QMetaType.Type = ... # 0x2c
        QJsonValue               : QMetaType.Type = ... # 0x2d
        QJsonObject              : QMetaType.Type = ... # 0x2e
        QJsonArray               : QMetaType.Type = ... # 0x2f
        QJsonDocument            : QMetaType.Type = ... # 0x30
        QByteArrayList           : QMetaType.Type = ... # 0x31
        QPersistentModelIndex    : QMetaType.Type = ... # 0x32
        Nullptr                  : QMetaType.Type = ... # 0x33
        QCborSimpleType          : QMetaType.Type = ... # 0x34
        QCborValue               : QMetaType.Type = ... # 0x35
        QCborArray               : QMetaType.Type = ... # 0x36
        QCborMap                 : QMetaType.Type = ... # 0x37
        Char16                   : QMetaType.Type = ... # 0x38
        Char32                   : QMetaType.Type = ... # 0x39
        LastCoreType             : QMetaType.Type = ... # 0x3a
        QVariantPair             : QMetaType.Type = ... # 0x3a
        FirstGuiType             : QMetaType.Type = ... # 0x1000
        QFont                    : QMetaType.Type = ... # 0x1000
        QPixmap                  : QMetaType.Type = ... # 0x1001
        QBrush                   : QMetaType.Type = ... # 0x1002
        QColor                   : QMetaType.Type = ... # 0x1003
        QPalette                 : QMetaType.Type = ... # 0x1004
        QIcon                    : QMetaType.Type = ... # 0x1005
        QImage                   : QMetaType.Type = ... # 0x1006
        QPolygon                 : QMetaType.Type = ... # 0x1007
        QRegion                  : QMetaType.Type = ... # 0x1008
        QBitmap                  : QMetaType.Type = ... # 0x1009
        QCursor                  : QMetaType.Type = ... # 0x100a
        QKeySequence             : QMetaType.Type = ... # 0x100b
        QPen                     : QMetaType.Type = ... # 0x100c
        QTextLength              : QMetaType.Type = ... # 0x100d
        QTextFormat              : QMetaType.Type = ... # 0x100e
        QTransform               : QMetaType.Type = ... # 0x1010
        QMatrix4x4               : QMetaType.Type = ... # 0x1011
        QVector2D                : QMetaType.Type = ... # 0x1012
        QVector3D                : QMetaType.Type = ... # 0x1013
        QVector4D                : QMetaType.Type = ... # 0x1014
        QQuaternion              : QMetaType.Type = ... # 0x1015
        QPolygonF                : QMetaType.Type = ... # 0x1016
        LastGuiType              : QMetaType.Type = ... # 0x1017
        QColorSpace              : QMetaType.Type = ... # 0x1017
        FirstWidgetsType         : QMetaType.Type = ... # 0x2000
        HighestInternalId        : QMetaType.Type = ... # 0x2000
        LastWidgetsType          : QMetaType.Type = ... # 0x2000
        QSizePolicy              : QMetaType.Type = ... # 0x2000
        User                     : QMetaType.Type = ... # 0x10000

    class TypeFlag(object):
        NeedsConstruction        : QMetaType.TypeFlag = ... # 0x1
        NeedsDestruction         : QMetaType.TypeFlag = ... # 0x2
        MovableType              : QMetaType.TypeFlag = ... # 0x4
        RelocatableType          : QMetaType.TypeFlag = ... # 0x4
        PointerToQObject         : QMetaType.TypeFlag = ... # 0x8
        IsEnumeration            : QMetaType.TypeFlag = ... # 0x10
        SharedPointerToQObject   : QMetaType.TypeFlag = ... # 0x20
        WeakPointerToQObject     : QMetaType.TypeFlag = ... # 0x40
        TrackingPointerToQObject : QMetaType.TypeFlag = ... # 0x80
        IsUnsignedEnumeration    : QMetaType.TypeFlag = ... # 0x100
        IsGadget                 : QMetaType.TypeFlag = ... # 0x200
        PointerToGadget          : QMetaType.TypeFlag = ... # 0x400
        IsPointer                : QMetaType.TypeFlag = ... # 0x800
        IsQmlList                : QMetaType.TypeFlag = ... # 0x1000

    class TypeFlags(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignOf(self) -> int: ...
    @staticmethod
    def canConvert(fromType:PySide6.QtCore.QMetaType, toType:PySide6.QtCore.QMetaType) -> bool: ...
    @staticmethod
    def canView(fromType:PySide6.QtCore.QMetaType, toType:PySide6.QtCore.QMetaType) -> bool: ...
    @staticmethod
    def compare(lhs:int, rhs:int, typeId:int) -> typing.Tuple: ...
    @typing.overload
    def construct(self, where:int, copy:typing.Optional[int]=...) -> int: ...
    @typing.overload
    @staticmethod
    def construct(type:int, where:int, copy:int) -> int: ...
    @typing.overload
    @staticmethod
    def convert(from_:int, fromTypeId:int, to:int, toTypeId:int) -> bool: ...
    @typing.overload
    @staticmethod
    def convert(fromType:PySide6.QtCore.QMetaType, from_:int, toType:PySide6.QtCore.QMetaType, to:int) -> bool: ...
    @typing.overload
    def create(self, copy:typing.Optional[int]=...) -> int: ...
    @typing.overload
    @staticmethod
    def create(type:int, copy:typing.Optional[int]=...) -> int: ...
    @typing.overload
    def destroy(self, data:int) -> None: ...
    @typing.overload
    @staticmethod
    def destroy(type:int, data:int) -> None: ...
    @typing.overload
    def destruct(self, data:int) -> None: ...
    @typing.overload
    @staticmethod
    def destruct(type:int, where:int) -> None: ...
    @typing.overload
    @staticmethod
    def equals(lhs:int, rhs:int, typeId:int) -> typing.Tuple: ...
    @typing.overload
    def equals(self, lhs:int, rhs:int) -> bool: ...
    def flags(self) -> PySide6.QtCore.QMetaType.TypeFlags: ...
    @staticmethod
    def fromName(name:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QMetaType: ...
    @staticmethod
    def hasRegisteredConverterFunction(fromType:PySide6.QtCore.QMetaType, toType:PySide6.QtCore.QMetaType) -> bool: ...
    @typing.overload
    def hasRegisteredDebugStreamOperator(self) -> bool: ...
    @typing.overload
    @staticmethod
    def hasRegisteredDebugStreamOperator(typeId:int) -> bool: ...
    @staticmethod
    def hasRegisteredMutableViewFunction(fromType:PySide6.QtCore.QMetaType, toType:PySide6.QtCore.QMetaType) -> bool: ...
    def id(self) -> int: ...
    def isEqualityComparable(self) -> bool: ...
    def isOrdered(self) -> bool: ...
    @typing.overload
    def isRegistered(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isRegistered(type:int) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def load(self, stream:PySide6.QtCore.QDataStream, data:int) -> bool: ...
    @typing.overload
    @staticmethod
    def load(stream:PySide6.QtCore.QDataStream, type:int, data:int) -> bool: ...
    @staticmethod
    def metaObjectForType(type:int) -> PySide6.QtCore.QMetaObject: ...
    def name(self) -> bytes: ...
    @typing.overload
    def save(self, stream:PySide6.QtCore.QDataStream, data:int) -> bool: ...
    @typing.overload
    @staticmethod
    def save(stream:PySide6.QtCore.QDataStream, type:int, data:int) -> bool: ...
    @typing.overload
    def sizeOf(self) -> int: ...
    @typing.overload
    @staticmethod
    def sizeOf(type:int) -> int: ...
    @staticmethod
    def type(typeName:bytes) -> int: ...
    @staticmethod
    def typeFlags(type:int) -> PySide6.QtCore.QMetaType.TypeFlags: ...
    @staticmethod
    def typeName(type:int) -> bytes: ...
    @staticmethod
    def unregisterConverterFunction(from_:PySide6.QtCore.QMetaType, to:PySide6.QtCore.QMetaType) -> None: ...
    @staticmethod
    def unregisterMetaType(type:PySide6.QtCore.QMetaType) -> None: ...
    @staticmethod
    def unregisterMutableViewFunction(from_:PySide6.QtCore.QMetaType, to:PySide6.QtCore.QMetaType) -> None: ...
    @staticmethod
    def view(fromType:PySide6.QtCore.QMetaType, from_:int, toType:PySide6.QtCore.QMetaType, to:int) -> bool: ...


class QMimeData(PySide6.QtCore.QObject):

    def __init__(self) -> None: ...

    def clear(self) -> None: ...
    def colorData(self) -> typing.Any: ...
    def data(self, mimetype:str) -> PySide6.QtCore.QByteArray: ...
    def formats(self) -> typing.List: ...
    def hasColor(self) -> bool: ...
    def hasFormat(self, mimetype:str) -> bool: ...
    def hasHtml(self) -> bool: ...
    def hasImage(self) -> bool: ...
    def hasText(self) -> bool: ...
    def hasUrls(self) -> bool: ...
    def html(self) -> str: ...
    def imageData(self) -> typing.Any: ...
    def removeFormat(self, mimetype:str) -> None: ...
    def retrieveData(self, mimetype:str, preferredType:PySide6.QtCore.QMetaType) -> typing.Any: ...
    def setColorData(self, color:typing.Any) -> None: ...
    def setData(self, mimetype:str, data:PySide6.QtCore.QByteArray) -> None: ...
    def setHtml(self, html:str) -> None: ...
    def setImageData(self, image:typing.Any) -> None: ...
    def setText(self, text:str) -> None: ...
    def setUrls(self, urls:typing.Sequence) -> None: ...
    def text(self) -> str: ...
    def urls(self) -> typing.List: ...


class QMimeDatabase(Shiboken.Object):
    MatchDefault             : QMimeDatabase = ... # 0x0
    MatchExtension           : QMimeDatabase = ... # 0x1
    MatchContent             : QMimeDatabase = ... # 0x2

    class MatchMode(object):
        MatchDefault             : QMimeDatabase.MatchMode = ... # 0x0
        MatchExtension           : QMimeDatabase.MatchMode = ... # 0x1
        MatchContent             : QMimeDatabase.MatchMode = ... # 0x2

    def __init__(self) -> None: ...

    def allMimeTypes(self) -> typing.List: ...
    @typing.overload
    def mimeTypeForData(self, data:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForData(self, device:PySide6.QtCore.QIODevice) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFile(self, fileInfo:PySide6.QtCore.QFileInfo, mode:PySide6.QtCore.QMimeDatabase.MatchMode=...) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFile(self, fileName:str, mode:PySide6.QtCore.QMimeDatabase.MatchMode=...) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFileNameAndData(self, fileName:str, data:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFileNameAndData(self, fileName:str, device:PySide6.QtCore.QIODevice) -> PySide6.QtCore.QMimeType: ...
    def mimeTypeForName(self, nameOrAlias:str) -> PySide6.QtCore.QMimeType: ...
    def mimeTypeForUrl(self, url:PySide6.QtCore.QUrl) -> PySide6.QtCore.QMimeType: ...
    def mimeTypesForFileName(self, fileName:str) -> typing.List: ...
    def suffixForFileName(self, fileName:str) -> str: ...


class QMimeType(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QMimeType) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def aliases(self) -> typing.List: ...
    def allAncestors(self) -> typing.List: ...
    def comment(self) -> str: ...
    def filterString(self) -> str: ...
    def genericIconName(self) -> str: ...
    def globPatterns(self) -> typing.List: ...
    def iconName(self) -> str: ...
    def inherits(self, mimeTypeName:str) -> bool: ...
    def isDefault(self) -> bool: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def parentMimeTypes(self) -> typing.List: ...
    def preferredSuffix(self) -> str: ...
    def suffixes(self) -> typing.List: ...
    def swap(self, other:PySide6.QtCore.QMimeType) -> None: ...


class QModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QModelIndex:PySide6.QtCore.QModelIndex) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def column(self) -> int: ...
    def constInternalPointer(self) -> int: ...
    def data(self, role:int=...) -> typing.Any: ...
    def flags(self) -> PySide6.QtCore.Qt.ItemFlags: ...
    def internalId(self) -> int: ...
    def internalPointer(self) -> int: ...
    def isValid(self) -> bool: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def parent(self) -> PySide6.QtCore.QModelIndex: ...
    def row(self) -> int: ...
    def sibling(self, row:int, column:int) -> PySide6.QtCore.QModelIndex: ...
    def siblingAtColumn(self, column:int) -> PySide6.QtCore.QModelIndex: ...
    def siblingAtRow(self, row:int) -> PySide6.QtCore.QModelIndex: ...


class QMutex(PySide6.QtCore.QBasicMutex):

    def __init__(self) -> None: ...

    @typing.overload
    def tryLock(self) -> bool: ...
    @typing.overload
    def tryLock(self, timeout:int) -> bool: ...
    def try_lock(self) -> bool: ...


class QMutexLocker(Shiboken.Object):

    @typing.overload
    def __init__(self, m:PySide6.QtCore.QMutex) -> None: ...
    @typing.overload
    def __init__(self, m:PySide6.QtCore.QRecursiveMutex) -> None: ...

    def __enter__(self) -> None: ...
    def __exit__(self, arg__1:object, arg__2:object, arg__3:object) -> None: ...
    def mutex(self) -> PySide6.QtCore.QMutex: ...
    def recursiveMutex(self) -> PySide6.QtCore.QRecursiveMutex: ...
    def relock(self) -> None: ...
    def unlock(self) -> None: ...


class QObject(Shiboken.Object):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def blockSignals(self, b:bool) -> bool: ...
    def childEvent(self, event:PySide6.QtCore.QChildEvent) -> None: ...
    def children(self) -> typing.List: ...
    @typing.overload
    @staticmethod
    def connect(arg__1:PySide6.QtCore.QObject, arg__2:bytes, arg__3:typing.Callable, type:PySide6.QtCore.Qt.ConnectionType=...) -> bool: ...
    @typing.overload
    def connect(self, arg__1:bytes, arg__2:typing.Callable, type:PySide6.QtCore.Qt.ConnectionType=...) -> bool: ...
    @typing.overload
    def connect(self, arg__1:bytes, arg__2:PySide6.QtCore.QObject, arg__3:bytes, type:PySide6.QtCore.Qt.ConnectionType=...) -> bool: ...
    @typing.overload
    def connect(self, sender:PySide6.QtCore.QObject, signal:bytes, member:bytes, type:PySide6.QtCore.Qt.ConnectionType=...) -> PySide6.QtCore.QMetaObject.Connection: ...
    @typing.overload
    @staticmethod
    def connect(sender:PySide6.QtCore.QObject, signal:PySide6.QtCore.QMetaMethod, receiver:PySide6.QtCore.QObject, method:PySide6.QtCore.QMetaMethod, type:PySide6.QtCore.Qt.ConnectionType=...) -> PySide6.QtCore.QMetaObject.Connection: ...
    @typing.overload
    @staticmethod
    def connect(sender:PySide6.QtCore.QObject, signal:bytes, receiver:PySide6.QtCore.QObject, member:bytes, type:PySide6.QtCore.Qt.ConnectionType=...) -> PySide6.QtCore.QMetaObject.Connection: ...
    def connectNotify(self, signal:PySide6.QtCore.QMetaMethod) -> None: ...
    def customEvent(self, event:PySide6.QtCore.QEvent) -> None: ...
    def deleteLater(self) -> None: ...
    @typing.overload
    @staticmethod
    def disconnect(arg__1:PySide6.QtCore.QMetaObject.Connection) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(arg__1:PySide6.QtCore.QObject, arg__2:bytes, arg__3:typing.Callable) -> bool: ...
    @typing.overload
    def disconnect(self, arg__1:bytes, arg__2:typing.Callable) -> bool: ...
    @typing.overload
    def disconnect(self, receiver:PySide6.QtCore.QObject, member:typing.Optional[bytes]=...) -> bool: ...
    @typing.overload
    def disconnect(self, signal:bytes, receiver:PySide6.QtCore.QObject, member:bytes) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(sender:PySide6.QtCore.QObject, signal:PySide6.QtCore.QMetaMethod, receiver:PySide6.QtCore.QObject, member:PySide6.QtCore.QMetaMethod) -> bool: ...
    @typing.overload
    @staticmethod
    def disconnect(sender:PySide6.QtCore.QObject, signal:bytes, receiver:PySide6.QtCore.QObject, member:bytes) -> bool: ...
    def disconnectNotify(self, signal:PySide6.QtCore.QMetaMethod) -> None: ...
    def dumpObjectInfo(self) -> None: ...
    def dumpObjectTree(self) -> None: ...
    def dynamicPropertyNames(self) -> typing.List: ...
    def emit(self, arg__1:bytes, *args:None) -> bool: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched:PySide6.QtCore.QObject, event:PySide6.QtCore.QEvent) -> bool: ...
    def findChild(self, arg__1:type, arg__2:str=...) -> object: ...
    @typing.overload
    def findChildren(self, arg__1:type, arg__2:PySide6.QtCore.QRegularExpression) -> typing.Iterable: ...
    @typing.overload
    def findChildren(self, arg__1:type, arg__2:str=...) -> typing.Iterable: ...
    def inherits(self, classname:bytes) -> bool: ...
    def installEventFilter(self, filterObj:PySide6.QtCore.QObject) -> None: ...
    def isSignalConnected(self, signal:PySide6.QtCore.QMetaMethod) -> bool: ...
    def isWidgetType(self) -> bool: ...
    def isWindowType(self) -> bool: ...
    def killTimer(self, id:int) -> None: ...
    def metaObject(self) -> PySide6.QtCore.QMetaObject: ...
    def moveToThread(self, thread:PySide6.QtCore.QThread) -> None: ...
    def objectName(self) -> str: ...
    def parent(self) -> PySide6.QtCore.QObject: ...
    def property(self, name:bytes) -> typing.Any: ...
    def receivers(self, signal:bytes) -> int: ...
    def removeEventFilter(self, obj:PySide6.QtCore.QObject) -> None: ...
    def sender(self) -> PySide6.QtCore.QObject: ...
    def senderSignalIndex(self) -> int: ...
    def setObjectName(self, name:str) -> None: ...
    def setParent(self, parent:PySide6.QtCore.QObject) -> None: ...
    def setProperty(self, name:bytes, value:typing.Any) -> bool: ...
    def signalsBlocked(self) -> bool: ...
    def startTimer(self, interval:int, timerType:PySide6.QtCore.Qt.TimerType=...) -> int: ...
    def thread(self) -> PySide6.QtCore.QThread: ...
    def timerEvent(self, event:PySide6.QtCore.QTimerEvent) -> None: ...
    def tr(self, arg__1:bytes, arg__2:bytes=..., arg__3:int=...) -> str: ...


class QOperatingSystemVersion(Shiboken.Object):
    Unknown                  : QOperatingSystemVersion = ... # 0x0
    Windows                  : QOperatingSystemVersion = ... # 0x1
    MacOS                    : QOperatingSystemVersion = ... # 0x2
    IOS                      : QOperatingSystemVersion = ... # 0x3
    TvOS                     : QOperatingSystemVersion = ... # 0x4
    WatchOS                  : QOperatingSystemVersion = ... # 0x5
    Android                  : QOperatingSystemVersion = ... # 0x6

    class OSType(object):
        Unknown                  : QOperatingSystemVersion.OSType = ... # 0x0
        Windows                  : QOperatingSystemVersion.OSType = ... # 0x1
        MacOS                    : QOperatingSystemVersion.OSType = ... # 0x2
        IOS                      : QOperatingSystemVersion.OSType = ... # 0x3
        TvOS                     : QOperatingSystemVersion.OSType = ... # 0x4
        WatchOS                  : QOperatingSystemVersion.OSType = ... # 0x5
        Android                  : QOperatingSystemVersion.OSType = ... # 0x6

    @typing.overload
    def __init__(self, QOperatingSystemVersion:PySide6.QtCore.QOperatingSystemVersion) -> None: ...
    @typing.overload
    def __init__(self, osType:PySide6.QtCore.QOperatingSystemVersion.OSType, vmajor:int, vminor:int=..., vmicro:int=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def current() -> PySide6.QtCore.QOperatingSystemVersion: ...
    @staticmethod
    def currentType() -> PySide6.QtCore.QOperatingSystemVersion.OSType: ...
    def majorVersion(self) -> int: ...
    def microVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def name(self) -> str: ...
    def segmentCount(self) -> int: ...
    def type(self) -> PySide6.QtCore.QOperatingSystemVersion.OSType: ...


class QParallelAnimationGroup(PySide6.QtCore.QAnimationGroup):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def duration(self) -> int: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def updateCurrentTime(self, currentTime:int) -> None: ...
    def updateDirection(self, direction:PySide6.QtCore.QAbstractAnimation.Direction) -> None: ...
    def updateState(self, newState:PySide6.QtCore.QAbstractAnimation.State, oldState:PySide6.QtCore.QAbstractAnimation.State) -> None: ...


class QPauseAnimation(PySide6.QtCore.QAbstractAnimation):

    @typing.overload
    def __init__(self, msecs:int, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def duration(self) -> int: ...
    def event(self, e:PySide6.QtCore.QEvent) -> bool: ...
    def setDuration(self, msecs:int) -> None: ...
    def updateCurrentTime(self, arg__1:int) -> None: ...


class QPersistentModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, index:PySide6.QtCore.QModelIndex) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QPersistentModelIndex) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def column(self) -> int: ...
    def constInternalPointer(self) -> int: ...
    def data(self, role:int=...) -> typing.Any: ...
    def flags(self) -> PySide6.QtCore.Qt.ItemFlags: ...
    def internalId(self) -> int: ...
    def internalPointer(self) -> int: ...
    def isValid(self) -> bool: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def parent(self) -> PySide6.QtCore.QModelIndex: ...
    def row(self) -> int: ...
    def sibling(self, row:int, column:int) -> PySide6.QtCore.QModelIndex: ...
    def swap(self, other:PySide6.QtCore.QPersistentModelIndex) -> None: ...


class QPluginLoader(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self, fileName:str, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def instance(self) -> PySide6.QtCore.QObject: ...
    def isLoaded(self) -> bool: ...
    def load(self) -> bool: ...
    def metaData(self) -> typing.Dict: ...
    def setFileName(self, fileName:str) -> None: ...
    @staticmethod
    def staticInstances() -> typing.List: ...
    def unload(self) -> bool: ...


class QPoint(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPoint:PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, xpos:int, ypos:int) -> None: ...

    def __add__(self, p2:PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, p:PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __imul__(self, factor:float) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __imul__(self, factor:float) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __imul__(self, factor:int) -> PySide6.QtCore.QPoint: ...
    def __isub__(self, p:PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, factor:int) -> PySide6.QtCore.QPoint: ...
    def __neg__(self) -> PySide6.QtCore.QPoint: ...
    def __pos__(self) -> PySide6.QtCore.QPoint: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, p2:PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @staticmethod
    def dotProduct(p1:PySide6.QtCore.QPoint, p2:PySide6.QtCore.QPoint) -> int: ...
    def isNull(self) -> bool: ...
    def manhattanLength(self) -> int: ...
    def setX(self, x:int) -> None: ...
    def setY(self, y:int) -> None: ...
    def toTuple(self) -> object: ...
    def transposed(self) -> PySide6.QtCore.QPoint: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QPointF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPointF:PySide6.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, p:PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, xpos:float, ypos:float) -> None: ...

    def __add__(self, p2:PySide6.QtCore.QPointF) -> PySide6.QtCore.QPointF: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, p:PySide6.QtCore.QPointF) -> PySide6.QtCore.QPointF: ...
    def __imul__(self, c:float) -> PySide6.QtCore.QPointF: ...
    def __isub__(self, p:PySide6.QtCore.QPointF) -> PySide6.QtCore.QPointF: ...
    def __mul__(self, c:float) -> PySide6.QtCore.QPointF: ...
    def __neg__(self) -> PySide6.QtCore.QPointF: ...
    def __pos__(self) -> PySide6.QtCore.QPointF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, p2:PySide6.QtCore.QPointF) -> PySide6.QtCore.QPointF: ...
    @staticmethod
    def dotProduct(p1:PySide6.QtCore.QPointF, p2:PySide6.QtCore.QPointF) -> float: ...
    def isNull(self) -> bool: ...
    def manhattanLength(self) -> float: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def toPoint(self) -> PySide6.QtCore.QPoint: ...
    def toTuple(self) -> object: ...
    def transposed(self) -> PySide6.QtCore.QPointF: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QProcess(PySide6.QtCore.QIODevice):
    FailedToStart            : QProcess = ... # 0x0
    ManagedInputChannel      : QProcess = ... # 0x0
    NormalExit               : QProcess = ... # 0x0
    NotRunning               : QProcess = ... # 0x0
    SeparateChannels         : QProcess = ... # 0x0
    StandardOutput           : QProcess = ... # 0x0
    CrashExit                : QProcess = ... # 0x1
    Crashed                  : QProcess = ... # 0x1
    ForwardedInputChannel    : QProcess = ... # 0x1
    MergedChannels           : QProcess = ... # 0x1
    StandardError            : QProcess = ... # 0x1
    Starting                 : QProcess = ... # 0x1
    ForwardedChannels        : QProcess = ... # 0x2
    Running                  : QProcess = ... # 0x2
    Timedout                 : QProcess = ... # 0x2
    ForwardedOutputChannel   : QProcess = ... # 0x3
    ReadError                : QProcess = ... # 0x3
    ForwardedErrorChannel    : QProcess = ... # 0x4
    WriteError               : QProcess = ... # 0x4
    UnknownError             : QProcess = ... # 0x5

    class ExitStatus(object):
        NormalExit               : QProcess.ExitStatus = ... # 0x0
        CrashExit                : QProcess.ExitStatus = ... # 0x1

    class InputChannelMode(object):
        ManagedInputChannel      : QProcess.InputChannelMode = ... # 0x0
        ForwardedInputChannel    : QProcess.InputChannelMode = ... # 0x1

    class ProcessChannel(object):
        StandardOutput           : QProcess.ProcessChannel = ... # 0x0
        StandardError            : QProcess.ProcessChannel = ... # 0x1

    class ProcessChannelMode(object):
        SeparateChannels         : QProcess.ProcessChannelMode = ... # 0x0
        MergedChannels           : QProcess.ProcessChannelMode = ... # 0x1
        ForwardedChannels        : QProcess.ProcessChannelMode = ... # 0x2
        ForwardedOutputChannel   : QProcess.ProcessChannelMode = ... # 0x3
        ForwardedErrorChannel    : QProcess.ProcessChannelMode = ... # 0x4

    class ProcessError(object):
        FailedToStart            : QProcess.ProcessError = ... # 0x0
        Crashed                  : QProcess.ProcessError = ... # 0x1
        Timedout                 : QProcess.ProcessError = ... # 0x2
        ReadError                : QProcess.ProcessError = ... # 0x3
        WriteError               : QProcess.ProcessError = ... # 0x4
        UnknownError             : QProcess.ProcessError = ... # 0x5

    class ProcessState(object):
        NotRunning               : QProcess.ProcessState = ... # 0x0
        Starting                 : QProcess.ProcessState = ... # 0x1
        Running                  : QProcess.ProcessState = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def arguments(self) -> typing.List: ...
    def bytesToWrite(self) -> int: ...
    def close(self) -> None: ...
    def closeReadChannel(self, channel:PySide6.QtCore.QProcess.ProcessChannel) -> None: ...
    def closeWriteChannel(self) -> None: ...
    def environment(self) -> typing.List: ...
    def error(self) -> PySide6.QtCore.QProcess.ProcessError: ...
    @staticmethod
    def execute(program:str, arguments:typing.Sequence=...) -> int: ...
    def exitCode(self) -> int: ...
    def exitStatus(self) -> PySide6.QtCore.QProcess.ExitStatus: ...
    def inputChannelMode(self) -> PySide6.QtCore.QProcess.InputChannelMode: ...
    def isSequential(self) -> bool: ...
    def kill(self) -> None: ...
    def nativeArguments(self) -> str: ...
    @staticmethod
    def nullDevice() -> str: ...
    def open(self, mode:PySide6.QtCore.QIODeviceBase.OpenMode=...) -> bool: ...
    def processChannelMode(self) -> PySide6.QtCore.QProcess.ProcessChannelMode: ...
    def processEnvironment(self) -> PySide6.QtCore.QProcessEnvironment: ...
    def processId(self) -> int: ...
    def program(self) -> str: ...
    def readAllStandardError(self) -> PySide6.QtCore.QByteArray: ...
    def readAllStandardOutput(self) -> PySide6.QtCore.QByteArray: ...
    def readChannel(self) -> PySide6.QtCore.QProcess.ProcessChannel: ...
    def readData(self, data:bytes, maxlen:int) -> int: ...
    def setArguments(self, arguments:typing.Sequence) -> None: ...
    def setEnvironment(self, environment:typing.Sequence) -> None: ...
    def setInputChannelMode(self, mode:PySide6.QtCore.QProcess.InputChannelMode) -> None: ...
    def setNativeArguments(self, arguments:str) -> None: ...
    def setProcessChannelMode(self, mode:PySide6.QtCore.QProcess.ProcessChannelMode) -> None: ...
    def setProcessEnvironment(self, environment:PySide6.QtCore.QProcessEnvironment) -> None: ...
    def setProcessState(self, state:PySide6.QtCore.QProcess.ProcessState) -> None: ...
    def setProgram(self, program:str) -> None: ...
    def setReadChannel(self, channel:PySide6.QtCore.QProcess.ProcessChannel) -> None: ...
    def setStandardErrorFile(self, fileName:str, mode:PySide6.QtCore.QIODeviceBase.OpenMode=...) -> None: ...
    def setStandardInputFile(self, fileName:str) -> None: ...
    def setStandardOutputFile(self, fileName:str, mode:PySide6.QtCore.QIODeviceBase.OpenMode=...) -> None: ...
    def setStandardOutputProcess(self, destination:PySide6.QtCore.QProcess) -> None: ...
    def setWorkingDirectory(self, dir:str) -> None: ...
    @staticmethod
    def splitCommand(command:str) -> typing.List: ...
    @typing.overload
    def start(self, mode:PySide6.QtCore.QIODeviceBase.OpenMode=...) -> None: ...
    @typing.overload
    def start(self, program:str, arguments:typing.Sequence=..., mode:PySide6.QtCore.QIODeviceBase.OpenMode=...) -> None: ...
    def startCommand(self, command:str, mode:PySide6.QtCore.QIODeviceBase.OpenMode=...) -> None: ...
    @typing.overload
    @staticmethod
    def startDetached(program:str, arguments:typing.Sequence=..., workingDirectory:str=...) -> typing.Tuple: ...
    @typing.overload
    def startDetached(self) -> typing.Tuple: ...
    def state(self) -> PySide6.QtCore.QProcess.ProcessState: ...
    @staticmethod
    def systemEnvironment() -> typing.List: ...
    def terminate(self) -> None: ...
    def waitForBytesWritten(self, msecs:int=...) -> bool: ...
    def waitForFinished(self, msecs:int=...) -> bool: ...
    def waitForReadyRead(self, msecs:int=...) -> bool: ...
    def waitForStarted(self, msecs:int=...) -> bool: ...
    def workingDirectory(self) -> str: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QProcessEnvironment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QProcessEnvironment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    def contains(self, name:str) -> bool: ...
    @typing.overload
    def insert(self, e:PySide6.QtCore.QProcessEnvironment) -> None: ...
    @typing.overload
    def insert(self, name:str, value:str) -> None: ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> typing.List: ...
    def remove(self, name:str) -> None: ...
    def swap(self, other:PySide6.QtCore.QProcessEnvironment) -> None: ...
    @staticmethod
    def systemEnvironment() -> PySide6.QtCore.QProcessEnvironment: ...
    def toStringList(self) -> typing.List: ...
    def value(self, name:str, defaultValue:str=...) -> str: ...


class QPropertyAnimation(PySide6.QtCore.QVariantAnimation):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, target:PySide6.QtCore.QObject, propertyName:PySide6.QtCore.QByteArray, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def propertyName(self) -> PySide6.QtCore.QByteArray: ...
    def setPropertyName(self, propertyName:PySide6.QtCore.QByteArray) -> None: ...
    def setTargetObject(self, target:PySide6.QtCore.QObject) -> None: ...
    def targetObject(self) -> PySide6.QtCore.QObject: ...
    def updateCurrentValue(self, value:typing.Any) -> None: ...
    def updateState(self, newState:PySide6.QtCore.QAbstractAnimation.State, oldState:PySide6.QtCore.QAbstractAnimation.State) -> None: ...


class QRandomGenerator(Shiboken.Object):

    @typing.overload
    def __init__(self, begin:int, end:int) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QRandomGenerator) -> None: ...
    @typing.overload
    def __init__(self, seedBuffer:int, len:int) -> None: ...
    @typing.overload
    def __init__(self, seedValue:int=...) -> None: ...

    @typing.overload
    def bounded(self, highest:float) -> float: ...
    @typing.overload
    def bounded(self, highest:int) -> int: ...
    @typing.overload
    def bounded(self, highest:int) -> int: ...
    @typing.overload
    def bounded(self, highest:int) -> int: ...
    @typing.overload
    def bounded(self, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    @typing.overload
    def bounded(self, lowest:int, highest:int) -> int: ...
    def discard(self, z:int) -> None: ...
    def generate(self) -> int: ...
    def generate64(self) -> int: ...
    def generateDouble(self) -> float: ...
    @staticmethod
    def global_() -> PySide6.QtCore.QRandomGenerator: ...
    @staticmethod
    def max() -> int: ...
    @staticmethod
    def min() -> int: ...
    @staticmethod
    def securelySeeded() -> PySide6.QtCore.QRandomGenerator: ...
    def seed(self, s:int=...) -> None: ...
    @staticmethod
    def system() -> PySide6.QtCore.QRandomGenerator: ...


class QRandomGenerator64(PySide6.QtCore.QRandomGenerator):

    @typing.overload
    def __init__(self, begin:int, end:int) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QRandomGenerator) -> None: ...
    @typing.overload
    def __init__(self, seedBuffer:int, len:int) -> None: ...
    @typing.overload
    def __init__(self, seedValue:int=...) -> None: ...

    def discard(self, z:int) -> None: ...
    def generate(self) -> int: ...
    @staticmethod
    def global_() -> PySide6.QtCore.QRandomGenerator64: ...
    @staticmethod
    def max() -> int: ...
    @staticmethod
    def min() -> int: ...
    @staticmethod
    def securelySeeded() -> PySide6.QtCore.QRandomGenerator64: ...
    @staticmethod
    def system() -> PySide6.QtCore.QRandomGenerator64: ...


class QReadLocker(Shiboken.Object):

    def __init__(self, readWriteLock:PySide6.QtCore.QReadWriteLock) -> None: ...

    def __enter__(self) -> None: ...
    def __exit__(self, arg__1:object, arg__2:object, arg__3:object) -> None: ...
    def readWriteLock(self) -> PySide6.QtCore.QReadWriteLock: ...
    def relock(self) -> None: ...
    def unlock(self) -> None: ...


class QReadWriteLock(Shiboken.Object):
    NonRecursive             : QReadWriteLock = ... # 0x0
    Recursive                : QReadWriteLock = ... # 0x1

    class RecursionMode(object):
        NonRecursive             : QReadWriteLock.RecursionMode = ... # 0x0
        Recursive                : QReadWriteLock.RecursionMode = ... # 0x1

    def __init__(self, recursionMode:PySide6.QtCore.QReadWriteLock.RecursionMode=...) -> None: ...

    def lockForRead(self) -> None: ...
    def lockForWrite(self) -> None: ...
    @typing.overload
    def tryLockForRead(self) -> bool: ...
    @typing.overload
    def tryLockForRead(self, timeout:int) -> bool: ...
    @typing.overload
    def tryLockForWrite(self) -> bool: ...
    @typing.overload
    def tryLockForWrite(self, timeout:int) -> bool: ...
    def unlock(self) -> None: ...


class QRect(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRect:PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, left:int, top:int, width:int, height:int) -> None: ...
    @typing.overload
    def __init__(self, topleft:PySide6.QtCore.QPoint, bottomright:PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, topleft:PySide6.QtCore.QPoint, size:PySide6.QtCore.QSize) -> None: ...

    def __add__(self, margins:PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect: ...
    def __and__(self, r:PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, margins:PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect: ...
    def __iand__(self, r:PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def __ior__(self, r:PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def __isub__(self, margins:PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect: ...
    def __or__(self, r:PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, rhs:PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect: ...
    def adjust(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def adjusted(self, x1:int, y1:int, x2:int, y2:int) -> PySide6.QtCore.QRect: ...
    def bottom(self) -> int: ...
    def bottomLeft(self) -> PySide6.QtCore.QPoint: ...
    def bottomRight(self) -> PySide6.QtCore.QPoint: ...
    def center(self) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def contains(self, p:PySide6.QtCore.QPoint, proper:bool=...) -> bool: ...
    @typing.overload
    def contains(self, r:PySide6.QtCore.QRect, proper:bool=...) -> bool: ...
    @typing.overload
    def contains(self, x:int, y:int) -> bool: ...
    @typing.overload
    def contains(self, x:int, y:int, proper:bool) -> bool: ...
    def getCoords(self) -> typing.Tuple: ...
    def getRect(self) -> typing.Tuple: ...
    def height(self) -> int: ...
    def intersected(self, other:PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def intersects(self, r:PySide6.QtCore.QRect) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> int: ...
    def marginsAdded(self, margins:PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect: ...
    def marginsRemoved(self, margins:PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect: ...
    def moveBottom(self, pos:int) -> None: ...
    def moveBottomLeft(self, p:PySide6.QtCore.QPoint) -> None: ...
    def moveBottomRight(self, p:PySide6.QtCore.QPoint) -> None: ...
    def moveCenter(self, p:PySide6.QtCore.QPoint) -> None: ...
    def moveLeft(self, pos:int) -> None: ...
    def moveRight(self, pos:int) -> None: ...
    @typing.overload
    def moveTo(self, p:PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def moveTo(self, x:int, t:int) -> None: ...
    def moveTop(self, pos:int) -> None: ...
    def moveTopLeft(self, p:PySide6.QtCore.QPoint) -> None: ...
    def moveTopRight(self, p:PySide6.QtCore.QPoint) -> None: ...
    def normalized(self) -> PySide6.QtCore.QRect: ...
    def right(self) -> int: ...
    def setBottom(self, pos:int) -> None: ...
    def setBottomLeft(self, p:PySide6.QtCore.QPoint) -> None: ...
    def setBottomRight(self, p:PySide6.QtCore.QPoint) -> None: ...
    def setCoords(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def setHeight(self, h:int) -> None: ...
    def setLeft(self, pos:int) -> None: ...
    def setRect(self, x:int, y:int, w:int, h:int) -> None: ...
    def setRight(self, pos:int) -> None: ...
    def setSize(self, s:PySide6.QtCore.QSize) -> None: ...
    def setTop(self, pos:int) -> None: ...
    def setTopLeft(self, p:PySide6.QtCore.QPoint) -> None: ...
    def setTopRight(self, p:PySide6.QtCore.QPoint) -> None: ...
    def setWidth(self, w:int) -> None: ...
    def setX(self, x:int) -> None: ...
    def setY(self, y:int) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    @staticmethod
    def span(p1:PySide6.QtCore.QPoint, p2:PySide6.QtCore.QPoint) -> PySide6.QtCore.QRect: ...
    def top(self) -> int: ...
    def topLeft(self) -> PySide6.QtCore.QPoint: ...
    def topRight(self) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def translate(self, dx:int, dy:int) -> None: ...
    @typing.overload
    def translate(self, p:PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def translated(self, dx:int, dy:int) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def translated(self, p:PySide6.QtCore.QPoint) -> PySide6.QtCore.QRect: ...
    def transposed(self) -> PySide6.QtCore.QRect: ...
    def united(self, other:PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def width(self) -> int: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QRectF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRectF:PySide6.QtCore.QRectF) -> None: ...
    @typing.overload
    def __init__(self, left:float, top:float, width:float, height:float) -> None: ...
    @typing.overload
    def __init__(self, rect:PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, topleft:PySide6.QtCore.QPointF, bottomRight:PySide6.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, topleft:PySide6.QtCore.QPointF, size:PySide6.QtCore.QSizeF) -> None: ...

    @typing.overload
    def __add__(self, lhs:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def __add__(self, rhs:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QRectF: ...
    def __and__(self, r:PySide6.QtCore.QRectF) -> PySide6.QtCore.QRectF: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, margins:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QRectF: ...
    def __iand__(self, r:PySide6.QtCore.QRectF) -> PySide6.QtCore.QRectF: ...
    def __ior__(self, r:PySide6.QtCore.QRectF) -> PySide6.QtCore.QRectF: ...
    def __isub__(self, margins:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QRectF: ...
    def __or__(self, r:PySide6.QtCore.QRectF) -> PySide6.QtCore.QRectF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, rhs:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QRectF: ...
    def adjust(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def adjusted(self, x1:float, y1:float, x2:float, y2:float) -> PySide6.QtCore.QRectF: ...
    def bottom(self) -> float: ...
    def bottomLeft(self) -> PySide6.QtCore.QPointF: ...
    def bottomRight(self) -> PySide6.QtCore.QPointF: ...
    def center(self) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def contains(self, p:PySide6.QtCore.QPointF) -> bool: ...
    @typing.overload
    def contains(self, r:PySide6.QtCore.QRectF) -> bool: ...
    @typing.overload
    def contains(self, x:float, y:float) -> bool: ...
    def getCoords(self) -> typing.Tuple: ...
    def getRect(self) -> typing.Tuple: ...
    def height(self) -> float: ...
    def intersected(self, other:PySide6.QtCore.QRectF) -> PySide6.QtCore.QRectF: ...
    def intersects(self, r:PySide6.QtCore.QRectF) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> float: ...
    def marginsAdded(self, margins:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QRectF: ...
    def marginsRemoved(self, margins:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QRectF: ...
    def moveBottom(self, pos:float) -> None: ...
    def moveBottomLeft(self, p:PySide6.QtCore.QPointF) -> None: ...
    def moveBottomRight(self, p:PySide6.QtCore.QPointF) -> None: ...
    def moveCenter(self, p:PySide6.QtCore.QPointF) -> None: ...
    def moveLeft(self, pos:float) -> None: ...
    def moveRight(self, pos:float) -> None: ...
    @typing.overload
    def moveTo(self, p:PySide6.QtCore.QPointF) -> None: ...
    @typing.overload
    def moveTo(self, x:float, y:float) -> None: ...
    def moveTop(self, pos:float) -> None: ...
    def moveTopLeft(self, p:PySide6.QtCore.QPointF) -> None: ...
    def moveTopRight(self, p:PySide6.QtCore.QPointF) -> None: ...
    def normalized(self) -> PySide6.QtCore.QRectF: ...
    def right(self) -> float: ...
    def setBottom(self, pos:float) -> None: ...
    def setBottomLeft(self, p:PySide6.QtCore.QPointF) -> None: ...
    def setBottomRight(self, p:PySide6.QtCore.QPointF) -> None: ...
    def setCoords(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def setHeight(self, h:float) -> None: ...
    def setLeft(self, pos:float) -> None: ...
    def setRect(self, x:float, y:float, w:float, h:float) -> None: ...
    def setRight(self, pos:float) -> None: ...
    def setSize(self, s:PySide6.QtCore.QSizeF) -> None: ...
    def setTop(self, pos:float) -> None: ...
    def setTopLeft(self, p:PySide6.QtCore.QPointF) -> None: ...
    def setTopRight(self, p:PySide6.QtCore.QPointF) -> None: ...
    def setWidth(self, w:float) -> None: ...
    def setX(self, pos:float) -> None: ...
    def setY(self, pos:float) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def toAlignedRect(self) -> PySide6.QtCore.QRect: ...
    def toRect(self) -> PySide6.QtCore.QRect: ...
    def top(self) -> float: ...
    def topLeft(self) -> PySide6.QtCore.QPointF: ...
    def topRight(self) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def translate(self, dx:float, dy:float) -> None: ...
    @typing.overload
    def translate(self, p:PySide6.QtCore.QPointF) -> None: ...
    @typing.overload
    def translated(self, dx:float, dy:float) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def translated(self, p:PySide6.QtCore.QPointF) -> PySide6.QtCore.QRectF: ...
    def transposed(self) -> PySide6.QtCore.QRectF: ...
    def united(self, other:PySide6.QtCore.QRectF) -> PySide6.QtCore.QRectF: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QRecursiveMutex(Shiboken.Object):

    def __init__(self) -> None: ...

    def lock(self) -> None: ...
    def tryLock(self, timeout:int=...) -> bool: ...
    def try_lock(self) -> bool: ...
    def unlock(self) -> None: ...


class QRegularExpression(Shiboken.Object):
    DefaultWildcardConversion: QRegularExpression = ... # 0x0
    NoMatchOption            : QRegularExpression = ... # 0x0
    NoPatternOption          : QRegularExpression = ... # 0x0
    NormalMatch              : QRegularExpression = ... # 0x0
    AnchorAtOffsetMatchOption: QRegularExpression = ... # 0x1
    AnchoredMatchOption      : QRegularExpression = ... # 0x1
    CaseInsensitiveOption    : QRegularExpression = ... # 0x1
    PartialPreferCompleteMatch: QRegularExpression = ... # 0x1
    UnanchoredWildcardConversion: QRegularExpression = ... # 0x1
    DontCheckSubjectStringMatchOption: QRegularExpression = ... # 0x2
    DotMatchesEverythingOption: QRegularExpression = ... # 0x2
    PartialPreferFirstMatch  : QRegularExpression = ... # 0x2
    NoMatch                  : QRegularExpression = ... # 0x3
    MultilineOption          : QRegularExpression = ... # 0x4
    ExtendedPatternSyntaxOption: QRegularExpression = ... # 0x8
    InvertedGreedinessOption : QRegularExpression = ... # 0x10
    DontCaptureOption        : QRegularExpression = ... # 0x20
    UseUnicodePropertiesOption: QRegularExpression = ... # 0x40

    class MatchOption(object):
        NoMatchOption            : QRegularExpression.MatchOption = ... # 0x0
        AnchorAtOffsetMatchOption: QRegularExpression.MatchOption = ... # 0x1
        AnchoredMatchOption      : QRegularExpression.MatchOption = ... # 0x1
        DontCheckSubjectStringMatchOption: QRegularExpression.MatchOption = ... # 0x2

    class MatchOptions(object): ...

    class MatchType(object):
        NormalMatch              : QRegularExpression.MatchType = ... # 0x0
        PartialPreferCompleteMatch: QRegularExpression.MatchType = ... # 0x1
        PartialPreferFirstMatch  : QRegularExpression.MatchType = ... # 0x2
        NoMatch                  : QRegularExpression.MatchType = ... # 0x3

    class PatternOption(object):
        NoPatternOption          : QRegularExpression.PatternOption = ... # 0x0
        CaseInsensitiveOption    : QRegularExpression.PatternOption = ... # 0x1
        DotMatchesEverythingOption: QRegularExpression.PatternOption = ... # 0x2
        MultilineOption          : QRegularExpression.PatternOption = ... # 0x4
        ExtendedPatternSyntaxOption: QRegularExpression.PatternOption = ... # 0x8
        InvertedGreedinessOption : QRegularExpression.PatternOption = ... # 0x10
        DontCaptureOption        : QRegularExpression.PatternOption = ... # 0x20
        UseUnicodePropertiesOption: QRegularExpression.PatternOption = ... # 0x40

    class PatternOptions(object): ...

    class WildcardConversionOption(object):
        DefaultWildcardConversion: QRegularExpression.WildcardConversionOption = ... # 0x0
        UnanchoredWildcardConversion: QRegularExpression.WildcardConversionOption = ... # 0x1

    class WildcardConversionOptions(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pattern:str, options:PySide6.QtCore.QRegularExpression.PatternOptions=...) -> None: ...
    @typing.overload
    def __init__(self, re:PySide6.QtCore.QRegularExpression) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def anchoredPattern(expression:str) -> str: ...
    def captureCount(self) -> int: ...
    def errorString(self) -> str: ...
    @staticmethod
    def escape(str:str) -> str: ...
    @staticmethod
    def fromWildcard(pattern:str, cs:PySide6.QtCore.Qt.CaseSensitivity=..., options:PySide6.QtCore.QRegularExpression.WildcardConversionOptions=...) -> PySide6.QtCore.QRegularExpression: ...
    @typing.overload
    def globalMatch(self, subject:str, offset:int=..., matchType:PySide6.QtCore.QRegularExpression.MatchType=..., matchOptions:PySide6.QtCore.QRegularExpression.MatchOptions=...) -> PySide6.QtCore.QRegularExpressionMatchIterator: ...
    @typing.overload
    def globalMatch(self, subjectView:str, offset:int=..., matchType:PySide6.QtCore.QRegularExpression.MatchType=..., matchOptions:PySide6.QtCore.QRegularExpression.MatchOptions=...) -> PySide6.QtCore.QRegularExpressionMatchIterator: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def match(self, subject:str, offset:int=..., matchType:PySide6.QtCore.QRegularExpression.MatchType=..., matchOptions:PySide6.QtCore.QRegularExpression.MatchOptions=...) -> PySide6.QtCore.QRegularExpressionMatch: ...
    @typing.overload
    def match(self, subjectView:str, offset:int=..., matchType:PySide6.QtCore.QRegularExpression.MatchType=..., matchOptions:PySide6.QtCore.QRegularExpression.MatchOptions=...) -> PySide6.QtCore.QRegularExpressionMatch: ...
    def namedCaptureGroups(self) -> typing.List: ...
    def optimize(self) -> None: ...
    def pattern(self) -> str: ...
    def patternErrorOffset(self) -> int: ...
    def patternOptions(self) -> PySide6.QtCore.QRegularExpression.PatternOptions: ...
    def setPattern(self, pattern:str) -> None: ...
    def setPatternOptions(self, options:PySide6.QtCore.QRegularExpression.PatternOptions) -> None: ...
    def swap(self, other:PySide6.QtCore.QRegularExpression) -> None: ...
    @staticmethod
    def wildcardToRegularExpression(str:str, options:PySide6.QtCore.QRegularExpression.WildcardConversionOptions=...) -> str: ...


class QRegularExpressionMatch(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, match:PySide6.QtCore.QRegularExpressionMatch) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def captured(self, name:str) -> str: ...
    @typing.overload
    def captured(self, nth:int=...) -> str: ...
    @typing.overload
    def capturedEnd(self, name:str) -> int: ...
    @typing.overload
    def capturedEnd(self, nth:int=...) -> int: ...
    @typing.overload
    def capturedLength(self, name:str) -> int: ...
    @typing.overload
    def capturedLength(self, nth:int=...) -> int: ...
    @typing.overload
    def capturedStart(self, name:str) -> int: ...
    @typing.overload
    def capturedStart(self, nth:int=...) -> int: ...
    def capturedTexts(self) -> typing.List: ...
    @typing.overload
    def capturedView(self, name:str) -> str: ...
    @typing.overload
    def capturedView(self, nth:int=...) -> str: ...
    def hasMatch(self) -> bool: ...
    def hasPartialMatch(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastCapturedIndex(self) -> int: ...
    def matchOptions(self) -> PySide6.QtCore.QRegularExpression.MatchOptions: ...
    def matchType(self) -> PySide6.QtCore.QRegularExpression.MatchType: ...
    def regularExpression(self) -> PySide6.QtCore.QRegularExpression: ...
    def swap(self, other:PySide6.QtCore.QRegularExpressionMatch) -> None: ...


class QRegularExpressionMatchIterator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, iterator:PySide6.QtCore.QRegularExpressionMatchIterator) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def hasNext(self) -> bool: ...
    def isValid(self) -> bool: ...
    def matchOptions(self) -> PySide6.QtCore.QRegularExpression.MatchOptions: ...
    def matchType(self) -> PySide6.QtCore.QRegularExpression.MatchType: ...
    def next(self) -> PySide6.QtCore.QRegularExpressionMatch: ...
    def peekNext(self) -> PySide6.QtCore.QRegularExpressionMatch: ...
    def regularExpression(self) -> PySide6.QtCore.QRegularExpression: ...
    def swap(self, other:PySide6.QtCore.QRegularExpressionMatchIterator) -> None: ...


class QResource(Shiboken.Object):
    NoCompression            : QResource = ... # 0x0
    ZlibCompression          : QResource = ... # 0x1
    ZstdCompression          : QResource = ... # 0x2

    class Compression(object):
        NoCompression            : QResource.Compression = ... # 0x0
        ZlibCompression          : QResource.Compression = ... # 0x1
        ZstdCompression          : QResource.Compression = ... # 0x2

    def __init__(self, file:str=..., locale:PySide6.QtCore.QLocale=...) -> None: ...

    def absoluteFilePath(self) -> str: ...
    def children(self) -> typing.List: ...
    def compressionAlgorithm(self) -> PySide6.QtCore.QResource.Compression: ...
    def data(self) -> bytes: ...
    def fileName(self) -> str: ...
    def isDir(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastModified(self) -> PySide6.QtCore.QDateTime: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    @staticmethod
    def registerResource(rccFilename:str, resourceRoot:str=...) -> bool: ...
    @staticmethod
    def registerResourceData(rccData:bytes, resourceRoot:str=...) -> bool: ...
    def setFileName(self, file:str) -> None: ...
    def setLocale(self, locale:PySide6.QtCore.QLocale) -> None: ...
    def size(self) -> int: ...
    def uncompressedData(self) -> PySide6.QtCore.QByteArray: ...
    def uncompressedSize(self) -> int: ...
    @staticmethod
    def unregisterResource(rccFilename:str, resourceRoot:str=...) -> bool: ...
    @staticmethod
    def unregisterResourceData(rccData:bytes, resourceRoot:str=...) -> bool: ...


class QRunnable(Shiboken.Object):

    def __init__(self) -> None: ...

    def autoDelete(self) -> bool: ...
    def run(self) -> None: ...
    def setAutoDelete(self, autoDelete:bool) -> None: ...


class QSaveFile(PySide6.QtCore.QFileDevice):

    @typing.overload
    def __init__(self, name:str) -> None: ...
    @typing.overload
    def __init__(self, name:str, parent:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def cancelWriting(self) -> None: ...
    def close(self) -> None: ...
    def commit(self) -> bool: ...
    def directWriteFallback(self) -> bool: ...
    def fileName(self) -> str: ...
    def open(self, flags:PySide6.QtCore.QIODeviceBase.OpenMode) -> bool: ...
    def setDirectWriteFallback(self, enabled:bool) -> None: ...
    def setFileName(self, name:str) -> None: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QSemaphore(Shiboken.Object):

    def __init__(self, n:int=...) -> None: ...

    def acquire(self, n:int=...) -> None: ...
    def available(self) -> int: ...
    def release(self, n:int=...) -> None: ...
    @typing.overload
    def tryAcquire(self, n:int, timeout:int) -> bool: ...
    @typing.overload
    def tryAcquire(self, n:int=...) -> bool: ...


class QSemaphoreReleaser(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, sem:PySide6.QtCore.QSemaphore, n:int=...) -> None: ...

    def cancel(self) -> PySide6.QtCore.QSemaphore: ...
    def semaphore(self) -> PySide6.QtCore.QSemaphore: ...
    def swap(self, other:PySide6.QtCore.QSemaphoreReleaser) -> None: ...


class QSequentialAnimationGroup(PySide6.QtCore.QAnimationGroup):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def addPause(self, msecs:int) -> PySide6.QtCore.QPauseAnimation: ...
    def currentAnimation(self) -> PySide6.QtCore.QAbstractAnimation: ...
    def duration(self) -> int: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def insertPause(self, index:int, msecs:int) -> PySide6.QtCore.QPauseAnimation: ...
    def updateCurrentTime(self, arg__1:int) -> None: ...
    def updateDirection(self, direction:PySide6.QtCore.QAbstractAnimation.Direction) -> None: ...
    def updateState(self, newState:PySide6.QtCore.QAbstractAnimation.State, oldState:PySide6.QtCore.QAbstractAnimation.State) -> None: ...


class QSettings(PySide6.QtCore.QObject):
    NativeFormat             : QSettings = ... # 0x0
    NoError                  : QSettings = ... # 0x0
    UserScope                : QSettings = ... # 0x0
    AccessError              : QSettings = ... # 0x1
    IniFormat                : QSettings = ... # 0x1
    SystemScope              : QSettings = ... # 0x1
    FormatError              : QSettings = ... # 0x2
    Registry32Format         : QSettings = ... # 0x2
    Registry64Format         : QSettings = ... # 0x3
    InvalidFormat            : QSettings = ... # 0x10
    CustomFormat1            : QSettings = ... # 0x11
    CustomFormat2            : QSettings = ... # 0x12
    CustomFormat3            : QSettings = ... # 0x13
    CustomFormat4            : QSettings = ... # 0x14
    CustomFormat5            : QSettings = ... # 0x15
    CustomFormat6            : QSettings = ... # 0x16
    CustomFormat7            : QSettings = ... # 0x17
    CustomFormat8            : QSettings = ... # 0x18
    CustomFormat9            : QSettings = ... # 0x19
    CustomFormat10           : QSettings = ... # 0x1a
    CustomFormat11           : QSettings = ... # 0x1b
    CustomFormat12           : QSettings = ... # 0x1c
    CustomFormat13           : QSettings = ... # 0x1d
    CustomFormat14           : QSettings = ... # 0x1e
    CustomFormat15           : QSettings = ... # 0x1f
    CustomFormat16           : QSettings = ... # 0x20

    class Format(object):
        NativeFormat             : QSettings.Format = ... # 0x0
        IniFormat                : QSettings.Format = ... # 0x1
        Registry32Format         : QSettings.Format = ... # 0x2
        Registry64Format         : QSettings.Format = ... # 0x3
        InvalidFormat            : QSettings.Format = ... # 0x10
        CustomFormat1            : QSettings.Format = ... # 0x11
        CustomFormat2            : QSettings.Format = ... # 0x12
        CustomFormat3            : QSettings.Format = ... # 0x13
        CustomFormat4            : QSettings.Format = ... # 0x14
        CustomFormat5            : QSettings.Format = ... # 0x15
        CustomFormat6            : QSettings.Format = ... # 0x16
        CustomFormat7            : QSettings.Format = ... # 0x17
        CustomFormat8            : QSettings.Format = ... # 0x18
        CustomFormat9            : QSettings.Format = ... # 0x19
        CustomFormat10           : QSettings.Format = ... # 0x1a
        CustomFormat11           : QSettings.Format = ... # 0x1b
        CustomFormat12           : QSettings.Format = ... # 0x1c
        CustomFormat13           : QSettings.Format = ... # 0x1d
        CustomFormat14           : QSettings.Format = ... # 0x1e
        CustomFormat15           : QSettings.Format = ... # 0x1f
        CustomFormat16           : QSettings.Format = ... # 0x20

    class Scope(object):
        UserScope                : QSettings.Scope = ... # 0x0
        SystemScope              : QSettings.Scope = ... # 0x1

    class Status(object):
        NoError                  : QSettings.Status = ... # 0x0
        AccessError              : QSettings.Status = ... # 0x1
        FormatError              : QSettings.Status = ... # 0x2

    @typing.overload
    def __init__(self, fileName:str, format:PySide6.QtCore.QSettings.Format, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, format:PySide6.QtCore.QSettings.Format, scope:PySide6.QtCore.QSettings.Scope, organization:str, application:str=..., parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, organization:str, application:str=..., parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, scope:PySide6.QtCore.QSettings.Scope, organization:str, application:str=..., parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, scope:PySide6.QtCore.QSettings.Scope, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def allKeys(self) -> typing.List: ...
    def applicationName(self) -> str: ...
    def beginGroup(self, prefix:str) -> None: ...
    def beginReadArray(self, prefix:str) -> int: ...
    def beginWriteArray(self, prefix:str, size:int=...) -> None: ...
    def childGroups(self) -> typing.List: ...
    def childKeys(self) -> typing.List: ...
    def clear(self) -> None: ...
    def contains(self, key:str) -> bool: ...
    @staticmethod
    def defaultFormat() -> PySide6.QtCore.QSettings.Format: ...
    def endArray(self) -> None: ...
    def endGroup(self) -> None: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def fallbacksEnabled(self) -> bool: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QSettings.Format: ...
    def group(self) -> str: ...
    def isAtomicSyncRequired(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def organizationName(self) -> str: ...
    def remove(self, key:str) -> None: ...
    def scope(self) -> PySide6.QtCore.QSettings.Scope: ...
    def setArrayIndex(self, i:int) -> None: ...
    def setAtomicSyncRequired(self, enable:bool) -> None: ...
    @staticmethod
    def setDefaultFormat(format:PySide6.QtCore.QSettings.Format) -> None: ...
    def setFallbacksEnabled(self, b:bool) -> None: ...
    @staticmethod
    def setPath(format:PySide6.QtCore.QSettings.Format, scope:PySide6.QtCore.QSettings.Scope, path:str) -> None: ...
    def setValue(self, key:str, value:typing.Any) -> None: ...
    def status(self) -> PySide6.QtCore.QSettings.Status: ...
    def sync(self) -> None: ...
    def value(self, arg__1:str, defaultValue:typing.Optional[typing.Any]=..., type:object=...) -> object: ...


class QSignalBlocker(Shiboken.Object):

    def __init__(self, o:PySide6.QtCore.QObject) -> None: ...

    def reblock(self) -> None: ...
    def unblock(self) -> None: ...


class QSignalMapper(PySide6.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    @typing.overload
    def map(self) -> None: ...
    @typing.overload
    def map(self, sender:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def mapping(self, id:int) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def mapping(self, object:PySide6.QtCore.QObject) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def mapping(self, text:str) -> PySide6.QtCore.QObject: ...
    def removeMappings(self, sender:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def setMapping(self, sender:PySide6.QtCore.QObject, id:int) -> None: ...
    @typing.overload
    def setMapping(self, sender:PySide6.QtCore.QObject, object:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def setMapping(self, sender:PySide6.QtCore.QObject, text:str) -> None: ...


class QSize(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QSize:PySide6.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, w:int, h:int) -> None: ...

    def __add__(self, s2:PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, arg__1:PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    def __imul__(self, c:float) -> PySide6.QtCore.QSize: ...
    def __isub__(self, arg__1:PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    def __mul__(self, c:float) -> PySide6.QtCore.QSize: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, s2:PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    def boundedTo(self, arg__1:PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    def expandedTo(self, arg__1:PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    def grownBy(self, m:PySide6.QtCore.QMargins) -> PySide6.QtCore.QSize: ...
    def height(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def scale(self, s:PySide6.QtCore.QSize, mode:PySide6.QtCore.Qt.AspectRatioMode) -> None: ...
    @typing.overload
    def scale(self, w:int, h:int, mode:PySide6.QtCore.Qt.AspectRatioMode) -> None: ...
    @typing.overload
    def scaled(self, s:PySide6.QtCore.QSize, mode:PySide6.QtCore.Qt.AspectRatioMode) -> PySide6.QtCore.QSize: ...
    @typing.overload
    def scaled(self, w:int, h:int, mode:PySide6.QtCore.Qt.AspectRatioMode) -> PySide6.QtCore.QSize: ...
    def setHeight(self, h:int) -> None: ...
    def setWidth(self, w:int) -> None: ...
    def shrunkBy(self, m:PySide6.QtCore.QMargins) -> PySide6.QtCore.QSize: ...
    def toTuple(self) -> object: ...
    def transpose(self) -> None: ...
    def transposed(self) -> PySide6.QtCore.QSize: ...
    def width(self) -> int: ...


class QSizeF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QSizeF:PySide6.QtCore.QSizeF) -> None: ...
    @typing.overload
    def __init__(self, sz:PySide6.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, w:float, h:float) -> None: ...

    def __add__(self, s2:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QSizeF: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, arg__1:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QSizeF: ...
    def __imul__(self, c:float) -> PySide6.QtCore.QSizeF: ...
    def __isub__(self, arg__1:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QSizeF: ...
    def __mul__(self, c:float) -> PySide6.QtCore.QSizeF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __sub__(self, s2:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QSizeF: ...
    def boundedTo(self, arg__1:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QSizeF: ...
    def expandedTo(self, arg__1:PySide6.QtCore.QSizeF) -> PySide6.QtCore.QSizeF: ...
    def grownBy(self, m:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QSizeF: ...
    def height(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def scale(self, s:PySide6.QtCore.QSizeF, mode:PySide6.QtCore.Qt.AspectRatioMode) -> None: ...
    @typing.overload
    def scale(self, w:float, h:float, mode:PySide6.QtCore.Qt.AspectRatioMode) -> None: ...
    @typing.overload
    def scaled(self, s:PySide6.QtCore.QSizeF, mode:PySide6.QtCore.Qt.AspectRatioMode) -> PySide6.QtCore.QSizeF: ...
    @typing.overload
    def scaled(self, w:float, h:float, mode:PySide6.QtCore.Qt.AspectRatioMode) -> PySide6.QtCore.QSizeF: ...
    def setHeight(self, h:float) -> None: ...
    def setWidth(self, w:float) -> None: ...
    def shrunkBy(self, m:PySide6.QtCore.QMarginsF) -> PySide6.QtCore.QSizeF: ...
    def toSize(self) -> PySide6.QtCore.QSize: ...
    def toTuple(self) -> object: ...
    def transpose(self) -> None: ...
    def transposed(self) -> PySide6.QtCore.QSizeF: ...
    def width(self) -> float: ...


class QSocketDescriptor(Shiboken.Object):

    @typing.overload
    def __init__(self, QSocketDescriptor:PySide6.QtCore.QSocketDescriptor) -> None: ...
    @typing.overload
    def __init__(self, desc:int) -> None: ...
    @typing.overload
    def __init__(self, descriptor:int=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isValid(self) -> bool: ...
    def winHandle(self) -> int: ...


class QSocketNotifier(PySide6.QtCore.QObject):
    Read                     : QSocketNotifier = ... # 0x0
    Write                    : QSocketNotifier = ... # 0x1
    Exception                : QSocketNotifier = ... # 0x2

    class Type(object):
        Read                     : QSocketNotifier.Type = ... # 0x0
        Write                    : QSocketNotifier.Type = ... # 0x1
        Exception                : QSocketNotifier.Type = ... # 0x2

    @typing.overload
    def __init__(self, arg__1:object, arg__2:PySide6.QtCore.QSocketNotifier.Type, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, socket:int, arg__2:PySide6.QtCore.QSocketNotifier.Type, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def event(self, arg__1:PySide6.QtCore.QEvent) -> bool: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, arg__1:bool) -> None: ...
    def socket(self) -> int: ...
    def type(self) -> PySide6.QtCore.QSocketNotifier.Type: ...


class QSortFilterProxyModel(PySide6.QtCore.QAbstractProxyModel):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def autoAcceptChildRows(self) -> bool: ...
    def buddy(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def canFetchMore(self, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def data(self, index:PySide6.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def dropMimeData(self, data:PySide6.QtCore.QMimeData, action:PySide6.QtCore.Qt.DropAction, row:int, column:int, parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def dynamicSortFilter(self) -> bool: ...
    def fetchMore(self, parent:PySide6.QtCore.QModelIndex) -> None: ...
    def filterAcceptsColumn(self, source_column:int, source_parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row:int, source_parent:PySide6.QtCore.QModelIndex) -> bool: ...
    def filterCaseSensitivity(self) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    def filterKeyColumn(self) -> int: ...
    def filterRegularExpression(self) -> PySide6.QtCore.QRegularExpression: ...
    def filterRole(self) -> int: ...
    def flags(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def headerData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def index(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def insertRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def invalidate(self) -> None: ...
    def invalidateColumnsFilter(self) -> None: ...
    def invalidateFilter(self) -> None: ...
    def invalidateRowsFilter(self) -> None: ...
    def isRecursiveFilteringEnabled(self) -> bool: ...
    def isSortLocaleAware(self) -> bool: ...
    def lessThan(self, source_left:PySide6.QtCore.QModelIndex, source_right:PySide6.QtCore.QModelIndex) -> bool: ...
    def mapFromSource(self, sourceIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, sourceSelection:PySide6.QtCore.QItemSelection) -> PySide6.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, proxySelection:PySide6.QtCore.QItemSelection) -> PySide6.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def match(self, start:PySide6.QtCore.QModelIndex, role:int, value:typing.Any, hits:int=..., flags:PySide6.QtCore.Qt.MatchFlags=...) -> typing.List: ...
    def mimeData(self, indexes:typing.List) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def removeRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def rowCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def setAutoAcceptChildRows(self, accept:bool) -> None: ...
    def setData(self, index:PySide6.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setDynamicSortFilter(self, enable:bool) -> None: ...
    def setFilterCaseSensitivity(self, cs:PySide6.QtCore.Qt.CaseSensitivity) -> None: ...
    def setFilterFixedString(self, pattern:str) -> None: ...
    def setFilterKeyColumn(self, column:int) -> None: ...
    @typing.overload
    def setFilterRegularExpression(self, pattern:str) -> None: ...
    @typing.overload
    def setFilterRegularExpression(self, regularExpression:PySide6.QtCore.QRegularExpression) -> None: ...
    def setFilterRole(self, role:int) -> None: ...
    def setFilterWildcard(self, pattern:str) -> None: ...
    def setHeaderData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, value:typing.Any, role:int=...) -> bool: ...
    def setRecursiveFilteringEnabled(self, recursive:bool) -> None: ...
    def setSortCaseSensitivity(self, cs:PySide6.QtCore.Qt.CaseSensitivity) -> None: ...
    def setSortLocaleAware(self, on:bool) -> None: ...
    def setSortRole(self, role:int) -> None: ...
    def setSourceModel(self, sourceModel:PySide6.QtCore.QAbstractItemModel) -> None: ...
    def sibling(self, row:int, column:int, idx:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column:int, order:PySide6.QtCore.Qt.SortOrder=...) -> None: ...
    def sortCaseSensitivity(self) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    def sortColumn(self) -> int: ...
    def sortOrder(self) -> PySide6.QtCore.Qt.SortOrder: ...
    def sortRole(self) -> int: ...
    def span(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QSize: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropActions: ...


class QStandardPaths(Shiboken.Object):
    DesktopLocation          : QStandardPaths = ... # 0x0
    LocateFile               : QStandardPaths = ... # 0x0
    DocumentsLocation        : QStandardPaths = ... # 0x1
    LocateDirectory          : QStandardPaths = ... # 0x1
    FontsLocation            : QStandardPaths = ... # 0x2
    ApplicationsLocation     : QStandardPaths = ... # 0x3
    MusicLocation            : QStandardPaths = ... # 0x4
    MoviesLocation           : QStandardPaths = ... # 0x5
    PicturesLocation         : QStandardPaths = ... # 0x6
    TempLocation             : QStandardPaths = ... # 0x7
    HomeLocation             : QStandardPaths = ... # 0x8
    AppLocalDataLocation     : QStandardPaths = ... # 0x9
    CacheLocation            : QStandardPaths = ... # 0xa
    GenericDataLocation      : QStandardPaths = ... # 0xb
    RuntimeLocation          : QStandardPaths = ... # 0xc
    ConfigLocation           : QStandardPaths = ... # 0xd
    DownloadLocation         : QStandardPaths = ... # 0xe
    GenericCacheLocation     : QStandardPaths = ... # 0xf
    GenericConfigLocation    : QStandardPaths = ... # 0x10
    AppDataLocation          : QStandardPaths = ... # 0x11
    AppConfigLocation        : QStandardPaths = ... # 0x12

    class LocateOption(object):
        LocateFile               : QStandardPaths.LocateOption = ... # 0x0
        LocateDirectory          : QStandardPaths.LocateOption = ... # 0x1

    class LocateOptions(object): ...

    class StandardLocation(object):
        DesktopLocation          : QStandardPaths.StandardLocation = ... # 0x0
        DocumentsLocation        : QStandardPaths.StandardLocation = ... # 0x1
        FontsLocation            : QStandardPaths.StandardLocation = ... # 0x2
        ApplicationsLocation     : QStandardPaths.StandardLocation = ... # 0x3
        MusicLocation            : QStandardPaths.StandardLocation = ... # 0x4
        MoviesLocation           : QStandardPaths.StandardLocation = ... # 0x5
        PicturesLocation         : QStandardPaths.StandardLocation = ... # 0x6
        TempLocation             : QStandardPaths.StandardLocation = ... # 0x7
        HomeLocation             : QStandardPaths.StandardLocation = ... # 0x8
        AppLocalDataLocation     : QStandardPaths.StandardLocation = ... # 0x9
        CacheLocation            : QStandardPaths.StandardLocation = ... # 0xa
        GenericDataLocation      : QStandardPaths.StandardLocation = ... # 0xb
        RuntimeLocation          : QStandardPaths.StandardLocation = ... # 0xc
        ConfigLocation           : QStandardPaths.StandardLocation = ... # 0xd
        DownloadLocation         : QStandardPaths.StandardLocation = ... # 0xe
        GenericCacheLocation     : QStandardPaths.StandardLocation = ... # 0xf
        GenericConfigLocation    : QStandardPaths.StandardLocation = ... # 0x10
        AppDataLocation          : QStandardPaths.StandardLocation = ... # 0x11
        AppConfigLocation        : QStandardPaths.StandardLocation = ... # 0x12
    @staticmethod
    def displayName(type:PySide6.QtCore.QStandardPaths.StandardLocation) -> str: ...
    @staticmethod
    def findExecutable(executableName:str, paths:typing.Sequence=...) -> str: ...
    @staticmethod
    def isTestModeEnabled() -> bool: ...
    @staticmethod
    def locate(type:PySide6.QtCore.QStandardPaths.StandardLocation, fileName:str, options:PySide6.QtCore.QStandardPaths.LocateOptions=...) -> str: ...
    @staticmethod
    def locateAll(type:PySide6.QtCore.QStandardPaths.StandardLocation, fileName:str, options:PySide6.QtCore.QStandardPaths.LocateOptions=...) -> typing.List: ...
    @staticmethod
    def setTestModeEnabled(testMode:bool) -> None: ...
    @staticmethod
    def standardLocations(type:PySide6.QtCore.QStandardPaths.StandardLocation) -> typing.List: ...
    @staticmethod
    def writableLocation(type:PySide6.QtCore.QStandardPaths.StandardLocation) -> str: ...


class QStorageInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, dir:PySide6.QtCore.QDir) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QStorageInfo) -> None: ...
    @typing.overload
    def __init__(self, path:str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def blockSize(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def bytesFree(self) -> int: ...
    def bytesTotal(self) -> int: ...
    def device(self) -> PySide6.QtCore.QByteArray: ...
    def displayName(self) -> str: ...
    def fileSystemType(self) -> PySide6.QtCore.QByteArray: ...
    def isReadOnly(self) -> bool: ...
    def isReady(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def mountedVolumes() -> typing.List: ...
    def name(self) -> str: ...
    def refresh(self) -> None: ...
    @staticmethod
    def root() -> PySide6.QtCore.QStorageInfo: ...
    def rootPath(self) -> str: ...
    def setPath(self, path:str) -> None: ...
    def subvolume(self) -> PySide6.QtCore.QByteArray: ...
    def swap(self, other:PySide6.QtCore.QStorageInfo) -> None: ...


class QStringListModel(PySide6.QtCore.QAbstractListModel):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, strings:typing.Sequence, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def clearItemData(self, index:PySide6.QtCore.QModelIndex) -> bool: ...
    def data(self, index:PySide6.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def flags(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.Qt.ItemFlags: ...
    def insertRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def itemData(self, index:PySide6.QtCore.QModelIndex) -> typing.Dict: ...
    def moveRows(self, sourceParent:PySide6.QtCore.QModelIndex, sourceRow:int, count:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    def removeRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def rowCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def setData(self, index:PySide6.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setItemData(self, index:PySide6.QtCore.QModelIndex, roles:typing.Dict) -> bool: ...
    def setStringList(self, strings:typing.Sequence) -> None: ...
    def sibling(self, row:int, column:int, idx:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column:int, order:PySide6.QtCore.Qt.SortOrder=...) -> None: ...
    def stringList(self) -> typing.List: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropActions: ...


class QSysInfo(Shiboken.Object):
    BigEndian                : QSysInfo = ... # 0x0
    ByteOrder                : QSysInfo = ... # 0x1
    LittleEndian             : QSysInfo = ... # 0x1
    WordSize                 : QSysInfo = ... # 0x40

    class Endian(object):
        BigEndian                : QSysInfo.Endian = ... # 0x0
        ByteOrder                : QSysInfo.Endian = ... # 0x1
        LittleEndian             : QSysInfo.Endian = ... # 0x1

    class Sizes(object):
        WordSize                 : QSysInfo.Sizes = ... # 0x40

    def __init__(self) -> None: ...

    @staticmethod
    def bootUniqueId() -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def buildAbi() -> str: ...
    @staticmethod
    def buildCpuArchitecture() -> str: ...
    @staticmethod
    def currentCpuArchitecture() -> str: ...
    @staticmethod
    def kernelType() -> str: ...
    @staticmethod
    def kernelVersion() -> str: ...
    @staticmethod
    def machineHostName() -> str: ...
    @staticmethod
    def machineUniqueId() -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def prettyProductName() -> str: ...
    @staticmethod
    def productType() -> str: ...
    @staticmethod
    def productVersion() -> str: ...


class QSystemSemaphore(Shiboken.Object):
    NoError                  : QSystemSemaphore = ... # 0x0
    Open                     : QSystemSemaphore = ... # 0x0
    Create                   : QSystemSemaphore = ... # 0x1
    PermissionDenied         : QSystemSemaphore = ... # 0x1
    KeyError                 : QSystemSemaphore = ... # 0x2
    AlreadyExists            : QSystemSemaphore = ... # 0x3
    NotFound                 : QSystemSemaphore = ... # 0x4
    OutOfResources           : QSystemSemaphore = ... # 0x5
    UnknownError             : QSystemSemaphore = ... # 0x6

    class AccessMode(object):
        Open                     : QSystemSemaphore.AccessMode = ... # 0x0
        Create                   : QSystemSemaphore.AccessMode = ... # 0x1

    class SystemSemaphoreError(object):
        NoError                  : QSystemSemaphore.SystemSemaphoreError = ... # 0x0
        PermissionDenied         : QSystemSemaphore.SystemSemaphoreError = ... # 0x1
        KeyError                 : QSystemSemaphore.SystemSemaphoreError = ... # 0x2
        AlreadyExists            : QSystemSemaphore.SystemSemaphoreError = ... # 0x3
        NotFound                 : QSystemSemaphore.SystemSemaphoreError = ... # 0x4
        OutOfResources           : QSystemSemaphore.SystemSemaphoreError = ... # 0x5
        UnknownError             : QSystemSemaphore.SystemSemaphoreError = ... # 0x6

    def __init__(self, key:str, initialValue:int=..., mode:PySide6.QtCore.QSystemSemaphore.AccessMode=...) -> None: ...

    def acquire(self) -> bool: ...
    def error(self) -> PySide6.QtCore.QSystemSemaphore.SystemSemaphoreError: ...
    def errorString(self) -> str: ...
    def key(self) -> str: ...
    def release(self, n:int=...) -> bool: ...
    def setKey(self, key:str, initialValue:int=..., mode:PySide6.QtCore.QSystemSemaphore.AccessMode=...) -> None: ...


class QTemporaryDir(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, templateName:str) -> None: ...

    def autoRemove(self) -> bool: ...
    def errorString(self) -> str: ...
    def filePath(self, fileName:str) -> str: ...
    def isValid(self) -> bool: ...
    def path(self) -> str: ...
    def remove(self) -> bool: ...
    def setAutoRemove(self, b:bool) -> None: ...


class QTemporaryFile(PySide6.QtCore.QFile):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, templateName:str) -> None: ...
    @typing.overload
    def __init__(self, templateName:str, parent:PySide6.QtCore.QObject) -> None: ...

    def autoRemove(self) -> bool: ...
    @typing.overload
    @staticmethod
    def createNativeFile(file:PySide6.QtCore.QFile) -> PySide6.QtCore.QTemporaryFile: ...
    @typing.overload
    @staticmethod
    def createNativeFile(fileName:str) -> PySide6.QtCore.QTemporaryFile: ...
    def fileName(self) -> str: ...
    def fileTemplate(self) -> str: ...
    @typing.overload
    def open(self) -> bool: ...
    @typing.overload
    def open(self, flags:PySide6.QtCore.QIODeviceBase.OpenMode) -> bool: ...
    def rename(self, newName:str) -> bool: ...
    def setAutoRemove(self, b:bool) -> None: ...
    def setFileTemplate(self, name:str) -> None: ...


class QTextBoundaryFinder(Shiboken.Object):
    Grapheme                 : QTextBoundaryFinder = ... # 0x0
    NotAtBoundary            : QTextBoundaryFinder = ... # 0x0
    Word                     : QTextBoundaryFinder = ... # 0x1
    Sentence                 : QTextBoundaryFinder = ... # 0x2
    Line                     : QTextBoundaryFinder = ... # 0x3
    BreakOpportunity         : QTextBoundaryFinder = ... # 0x1f
    StartOfItem              : QTextBoundaryFinder = ... # 0x20
    EndOfItem                : QTextBoundaryFinder = ... # 0x40
    MandatoryBreak           : QTextBoundaryFinder = ... # 0x80
    SoftHyphen               : QTextBoundaryFinder = ... # 0x100

    class BoundaryReason(object):
        NotAtBoundary            : QTextBoundaryFinder.BoundaryReason = ... # 0x0
        BreakOpportunity         : QTextBoundaryFinder.BoundaryReason = ... # 0x1f
        StartOfItem              : QTextBoundaryFinder.BoundaryReason = ... # 0x20
        EndOfItem                : QTextBoundaryFinder.BoundaryReason = ... # 0x40
        MandatoryBreak           : QTextBoundaryFinder.BoundaryReason = ... # 0x80
        SoftHyphen               : QTextBoundaryFinder.BoundaryReason = ... # 0x100

    class BoundaryReasons(object): ...

    class BoundaryType(object):
        Grapheme                 : QTextBoundaryFinder.BoundaryType = ... # 0x0
        Word                     : QTextBoundaryFinder.BoundaryType = ... # 0x1
        Sentence                 : QTextBoundaryFinder.BoundaryType = ... # 0x2
        Line                     : QTextBoundaryFinder.BoundaryType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QTextBoundaryFinder) -> None: ...
    @typing.overload
    def __init__(self, type:PySide6.QtCore.QTextBoundaryFinder.BoundaryType, str:str, buffer:typing.Optional[bytes]=..., bufferSize:int=...) -> None: ...
    @typing.overload
    def __init__(self, type:PySide6.QtCore.QTextBoundaryFinder.BoundaryType, string:str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def boundaryReasons(self) -> PySide6.QtCore.QTextBoundaryFinder.BoundaryReasons: ...
    def isAtBoundary(self) -> bool: ...
    def isValid(self) -> bool: ...
    def position(self) -> int: ...
    def setPosition(self, position:int) -> None: ...
    def string(self) -> str: ...
    def toEnd(self) -> None: ...
    def toNextBoundary(self) -> int: ...
    def toPreviousBoundary(self) -> int: ...
    def toStart(self) -> None: ...
    def type(self) -> PySide6.QtCore.QTextBoundaryFinder.BoundaryType: ...


class QTextStream(PySide6.QtCore.QIODeviceBase):
    AlignLeft                : QTextStream = ... # 0x0
    Ok                       : QTextStream = ... # 0x0
    SmartNotation            : QTextStream = ... # 0x0
    AlignRight               : QTextStream = ... # 0x1
    FixedNotation            : QTextStream = ... # 0x1
    ReadPastEnd              : QTextStream = ... # 0x1
    ShowBase                 : QTextStream = ... # 0x1
    AlignCenter              : QTextStream = ... # 0x2
    ForcePoint               : QTextStream = ... # 0x2
    ReadCorruptData          : QTextStream = ... # 0x2
    ScientificNotation       : QTextStream = ... # 0x2
    AlignAccountingStyle     : QTextStream = ... # 0x3
    WriteFailed              : QTextStream = ... # 0x3
    ForceSign                : QTextStream = ... # 0x4
    UppercaseBase            : QTextStream = ... # 0x8
    UppercaseDigits          : QTextStream = ... # 0x10

    class FieldAlignment(object):
        AlignLeft                : QTextStream.FieldAlignment = ... # 0x0
        AlignRight               : QTextStream.FieldAlignment = ... # 0x1
        AlignCenter              : QTextStream.FieldAlignment = ... # 0x2
        AlignAccountingStyle     : QTextStream.FieldAlignment = ... # 0x3

    class NumberFlag(object):
        ShowBase                 : QTextStream.NumberFlag = ... # 0x1
        ForcePoint               : QTextStream.NumberFlag = ... # 0x2
        ForceSign                : QTextStream.NumberFlag = ... # 0x4
        UppercaseBase            : QTextStream.NumberFlag = ... # 0x8
        UppercaseDigits          : QTextStream.NumberFlag = ... # 0x10

    class NumberFlags(object): ...

    class RealNumberNotation(object):
        SmartNotation            : QTextStream.RealNumberNotation = ... # 0x0
        FixedNotation            : QTextStream.RealNumberNotation = ... # 0x1
        ScientificNotation       : QTextStream.RealNumberNotation = ... # 0x2

    class Status(object):
        Ok                       : QTextStream.Status = ... # 0x0
        ReadPastEnd              : QTextStream.Status = ... # 0x1
        ReadCorruptData          : QTextStream.Status = ... # 0x2
        WriteFailed              : QTextStream.Status = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, array:PySide6.QtCore.QByteArray, openMode:PySide6.QtCore.QIODeviceBase.OpenMode=...) -> None: ...
    @typing.overload
    def __init__(self, device:PySide6.QtCore.QIODevice) -> None: ...

    @typing.overload
    def __lshift__(self, array:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, ch:str) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, ch:int) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, f:float) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, i:int) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, i:int) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, m:PySide6.QtCore.QTextStreamManipulator) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, s:str) -> PySide6.QtCore.QTextStream: ...
    def __rshift__(self, array:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QTextStream: ...
    def atEnd(self) -> bool: ...
    def autoDetectUnicode(self) -> bool: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def fieldAlignment(self) -> PySide6.QtCore.QTextStream.FieldAlignment: ...
    def fieldWidth(self) -> int: ...
    def flush(self) -> None: ...
    def generateByteOrderMark(self) -> bool: ...
    def integerBase(self) -> int: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    def numberFlags(self) -> PySide6.QtCore.QTextStream.NumberFlags: ...
    def padChar(self) -> str: ...
    def pos(self) -> int: ...
    def read(self, maxlen:int) -> str: ...
    def readAll(self) -> str: ...
    def readLine(self, maxlen:int=...) -> str: ...
    def realNumberNotation(self) -> PySide6.QtCore.QTextStream.RealNumberNotation: ...
    def realNumberPrecision(self) -> int: ...
    def reset(self) -> None: ...
    def resetStatus(self) -> None: ...
    def seek(self, pos:int) -> bool: ...
    def setAutoDetectUnicode(self, enabled:bool) -> None: ...
    def setDevice(self, device:PySide6.QtCore.QIODevice) -> None: ...
    def setFieldAlignment(self, alignment:PySide6.QtCore.QTextStream.FieldAlignment) -> None: ...
    def setFieldWidth(self, width:int) -> None: ...
    def setGenerateByteOrderMark(self, generate:bool) -> None: ...
    def setIntegerBase(self, base:int) -> None: ...
    def setLocale(self, locale:PySide6.QtCore.QLocale) -> None: ...
    def setNumberFlags(self, flags:PySide6.QtCore.QTextStream.NumberFlags) -> None: ...
    def setPadChar(self, ch:str) -> None: ...
    def setRealNumberNotation(self, notation:PySide6.QtCore.QTextStream.RealNumberNotation) -> None: ...
    def setRealNumberPrecision(self, precision:int) -> None: ...
    def setStatus(self, status:PySide6.QtCore.QTextStream.Status) -> None: ...
    def skipWhiteSpace(self) -> None: ...
    def status(self) -> PySide6.QtCore.QTextStream.Status: ...
    def string(self) -> typing.List: ...


class QTextStreamManipulator(Shiboken.Object):
    @staticmethod
    def __copy__() -> None: ...
    def exec_(self, s:PySide6.QtCore.QTextStream) -> None: ...


class QThread(PySide6.QtCore.QObject):
    IdlePriority             : QThread = ... # 0x0
    LowestPriority           : QThread = ... # 0x1
    LowPriority              : QThread = ... # 0x2
    NormalPriority           : QThread = ... # 0x3
    HighPriority             : QThread = ... # 0x4
    HighestPriority          : QThread = ... # 0x5
    TimeCriticalPriority     : QThread = ... # 0x6
    InheritPriority          : QThread = ... # 0x7

    class Priority(object):
        IdlePriority             : QThread.Priority = ... # 0x0
        LowestPriority           : QThread.Priority = ... # 0x1
        LowPriority              : QThread.Priority = ... # 0x2
        NormalPriority           : QThread.Priority = ... # 0x3
        HighPriority             : QThread.Priority = ... # 0x4
        HighestPriority          : QThread.Priority = ... # 0x5
        TimeCriticalPriority     : QThread.Priority = ... # 0x6
        InheritPriority          : QThread.Priority = ... # 0x7

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    @staticmethod
    def currentThread() -> PySide6.QtCore.QThread: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def eventDispatcher(self) -> PySide6.QtCore.QAbstractEventDispatcher: ...
    def exec_(self) -> int: ...
    def exit(self, retcode:int=...) -> None: ...
    @staticmethod
    def idealThreadCount() -> int: ...
    def isFinished(self) -> bool: ...
    def isInterruptionRequested(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def loopLevel(self) -> int: ...
    @staticmethod
    def msleep(arg__1:int) -> None: ...
    def priority(self) -> PySide6.QtCore.QThread.Priority: ...
    def quit(self) -> None: ...
    def requestInterruption(self) -> None: ...
    def run(self) -> None: ...
    def setEventDispatcher(self, eventDispatcher:PySide6.QtCore.QAbstractEventDispatcher) -> None: ...
    def setPriority(self, priority:PySide6.QtCore.QThread.Priority) -> None: ...
    def setStackSize(self, stackSize:int) -> None: ...
    @staticmethod
    def setTerminationEnabled(enabled:bool=...) -> None: ...
    @staticmethod
    def sleep(arg__1:int) -> None: ...
    def stackSize(self) -> int: ...
    def start(self, priority:PySide6.QtCore.QThread.Priority=...) -> None: ...
    def terminate(self) -> None: ...
    @staticmethod
    def usleep(arg__1:int) -> None: ...
    @typing.overload
    def wait(self, deadline:PySide6.QtCore.QDeadlineTimer=...) -> bool: ...
    @typing.overload
    def wait(self, time:int) -> bool: ...
    @staticmethod
    def yieldCurrentThread() -> None: ...


class QThreadPool(PySide6.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def activeThreadCount(self) -> int: ...
    def clear(self) -> None: ...
    def contains(self, thread:PySide6.QtCore.QThread) -> bool: ...
    def expiryTimeout(self) -> int: ...
    @staticmethod
    def globalInstance() -> PySide6.QtCore.QThreadPool: ...
    def maxThreadCount(self) -> int: ...
    def releaseThread(self) -> None: ...
    def reserveThread(self) -> None: ...
    def setExpiryTimeout(self, expiryTimeout:int) -> None: ...
    def setMaxThreadCount(self, maxThreadCount:int) -> None: ...
    def setStackSize(self, stackSize:int) -> None: ...
    def stackSize(self) -> int: ...
    def start(self, runnable:PySide6.QtCore.QRunnable, priority:int=...) -> None: ...
    def tryStart(self, runnable:PySide6.QtCore.QRunnable) -> bool: ...
    def tryTake(self, runnable:PySide6.QtCore.QRunnable) -> bool: ...
    def waitForDone(self, msecs:int=...) -> bool: ...


class QTime(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTime:PySide6.QtCore.QTime) -> None: ...
    @typing.overload
    def __init__(self, h:int, m:int, s:int=..., ms:int=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def addMSecs(self, ms:int) -> PySide6.QtCore.QTime: ...
    def addSecs(self, secs:int) -> PySide6.QtCore.QTime: ...
    @staticmethod
    def currentTime() -> PySide6.QtCore.QTime: ...
    @staticmethod
    def fromMSecsSinceStartOfDay(msecs:int) -> PySide6.QtCore.QTime: ...
    @typing.overload
    @staticmethod
    def fromString(string:str, format:PySide6.QtCore.Qt.DateFormat=...) -> PySide6.QtCore.QTime: ...
    @typing.overload
    @staticmethod
    def fromString(string:str, format:str) -> PySide6.QtCore.QTime: ...
    def hour(self) -> int: ...
    def isNull(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isValid(h:int, m:int, s:int, ms:int=...) -> bool: ...
    @typing.overload
    def isValid(self) -> bool: ...
    def minute(self) -> int: ...
    def msec(self) -> int: ...
    def msecsSinceStartOfDay(self) -> int: ...
    def msecsTo(self, t:PySide6.QtCore.QTime) -> int: ...
    def second(self) -> int: ...
    def secsTo(self, t:PySide6.QtCore.QTime) -> int: ...
    def setHMS(self, h:int, m:int, s:int, ms:int=...) -> bool: ...
    def toPython(self) -> object: ...
    @typing.overload
    def toString(self, f:PySide6.QtCore.Qt.DateFormat=...) -> str: ...
    @typing.overload
    def toString(self, format:str) -> str: ...


class QTimeLine(PySide6.QtCore.QObject):
    Forward                  : QTimeLine = ... # 0x0
    NotRunning               : QTimeLine = ... # 0x0
    Backward                 : QTimeLine = ... # 0x1
    Paused                   : QTimeLine = ... # 0x1
    Running                  : QTimeLine = ... # 0x2

    class Direction(object):
        Forward                  : QTimeLine.Direction = ... # 0x0
        Backward                 : QTimeLine.Direction = ... # 0x1

    class State(object):
        NotRunning               : QTimeLine.State = ... # 0x0
        Paused                   : QTimeLine.State = ... # 0x1
        Running                  : QTimeLine.State = ... # 0x2

    def __init__(self, duration:int=..., parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def currentFrame(self) -> int: ...
    def currentTime(self) -> int: ...
    def currentValue(self) -> float: ...
    def direction(self) -> PySide6.QtCore.QTimeLine.Direction: ...
    def duration(self) -> int: ...
    def easingCurve(self) -> PySide6.QtCore.QEasingCurve: ...
    def endFrame(self) -> int: ...
    def frameForTime(self, msec:int) -> int: ...
    def loopCount(self) -> int: ...
    def resume(self) -> None: ...
    def setCurrentTime(self, msec:int) -> None: ...
    def setDirection(self, direction:PySide6.QtCore.QTimeLine.Direction) -> None: ...
    def setDuration(self, duration:int) -> None: ...
    def setEasingCurve(self, curve:PySide6.QtCore.QEasingCurve) -> None: ...
    def setEndFrame(self, frame:int) -> None: ...
    def setFrameRange(self, startFrame:int, endFrame:int) -> None: ...
    def setLoopCount(self, count:int) -> None: ...
    def setPaused(self, paused:bool) -> None: ...
    def setStartFrame(self, frame:int) -> None: ...
    def setUpdateInterval(self, interval:int) -> None: ...
    def start(self) -> None: ...
    def startFrame(self) -> int: ...
    def state(self) -> PySide6.QtCore.QTimeLine.State: ...
    def stop(self) -> None: ...
    def timerEvent(self, event:PySide6.QtCore.QTimerEvent) -> None: ...
    def toggleDirection(self) -> None: ...
    def updateInterval(self) -> int: ...
    def valueForTime(self, msec:int) -> float: ...


class QTimeZone(Shiboken.Object):
    DefaultName              : QTimeZone = ... # 0x0
    StandardTime             : QTimeZone = ... # 0x0
    DaylightTime             : QTimeZone = ... # 0x1
    LongName                 : QTimeZone = ... # 0x1
    GenericTime              : QTimeZone = ... # 0x2
    ShortName                : QTimeZone = ... # 0x2
    OffsetName               : QTimeZone = ... # 0x3

    class NameType(object):
        DefaultName              : QTimeZone.NameType = ... # 0x0
        LongName                 : QTimeZone.NameType = ... # 0x1
        ShortName                : QTimeZone.NameType = ... # 0x2
        OffsetName               : QTimeZone.NameType = ... # 0x3

    class OffsetData(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, OffsetData:PySide6.QtCore.QTimeZone.OffsetData) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class TimeType(object):
        StandardTime             : QTimeZone.TimeType = ... # 0x0
        DaylightTime             : QTimeZone.TimeType = ... # 0x1
        GenericTime              : QTimeZone.TimeType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ianaId:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, offsetSeconds:int) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QTimeZone) -> None: ...
    @typing.overload
    def __init__(self, zoneId:PySide6.QtCore.QByteArray, offsetSeconds:int, name:str, abbreviation:str, country:PySide6.QtCore.QLocale.Country=..., comment:str=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def abbreviation(self, atDateTime:PySide6.QtCore.QDateTime) -> str: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds() -> typing.List: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds(country:PySide6.QtCore.QLocale.Country) -> typing.List: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds(offsetSeconds:int) -> typing.List: ...
    def comment(self) -> str: ...
    def country(self) -> PySide6.QtCore.QLocale.Country: ...
    def daylightTimeOffset(self, atDateTime:PySide6.QtCore.QDateTime) -> int: ...
    @typing.overload
    def displayName(self, atDateTime:PySide6.QtCore.QDateTime, nameType:PySide6.QtCore.QTimeZone.NameType=..., locale:PySide6.QtCore.QLocale=...) -> str: ...
    @typing.overload
    def displayName(self, timeType:PySide6.QtCore.QTimeZone.TimeType, nameType:PySide6.QtCore.QTimeZone.NameType=..., locale:PySide6.QtCore.QLocale=...) -> str: ...
    def hasDaylightTime(self) -> bool: ...
    def hasTransitions(self) -> bool: ...
    @staticmethod
    def ianaIdToWindowsId(ianaId:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    def id(self) -> PySide6.QtCore.QByteArray: ...
    def isDaylightTime(self, atDateTime:PySide6.QtCore.QDateTime) -> bool: ...
    @staticmethod
    def isTimeZoneIdAvailable(ianaId:PySide6.QtCore.QByteArray) -> bool: ...
    def isValid(self) -> bool: ...
    def nextTransition(self, afterDateTime:PySide6.QtCore.QDateTime) -> PySide6.QtCore.QTimeZone.OffsetData: ...
    def offsetData(self, forDateTime:PySide6.QtCore.QDateTime) -> PySide6.QtCore.QTimeZone.OffsetData: ...
    def offsetFromUtc(self, atDateTime:PySide6.QtCore.QDateTime) -> int: ...
    def previousTransition(self, beforeDateTime:PySide6.QtCore.QDateTime) -> PySide6.QtCore.QTimeZone.OffsetData: ...
    def standardTimeOffset(self, atDateTime:PySide6.QtCore.QDateTime) -> int: ...
    def swap(self, other:PySide6.QtCore.QTimeZone) -> None: ...
    @staticmethod
    def systemTimeZone() -> PySide6.QtCore.QTimeZone: ...
    @staticmethod
    def systemTimeZoneId() -> PySide6.QtCore.QByteArray: ...
    def transitions(self, fromDateTime:PySide6.QtCore.QDateTime, toDateTime:PySide6.QtCore.QDateTime) -> typing.List: ...
    @staticmethod
    def utc() -> PySide6.QtCore.QTimeZone: ...
    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(windowsId:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(windowsId:PySide6.QtCore.QByteArray, country:PySide6.QtCore.QLocale.Country) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(windowsId:PySide6.QtCore.QByteArray) -> typing.List: ...
    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(windowsId:PySide6.QtCore.QByteArray, country:PySide6.QtCore.QLocale.Country) -> typing.List: ...


class QTimer(PySide6.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def interval(self) -> int: ...
    def isActive(self) -> bool: ...
    def isSingleShot(self) -> bool: ...
    def killTimer(self, arg__1:int) -> None: ...
    def remainingTime(self) -> int: ...
    def setInterval(self, msec:int) -> None: ...
    def setSingleShot(self, singleShot:bool) -> None: ...
    def setTimerType(self, atype:PySide6.QtCore.Qt.TimerType) -> None: ...
    @typing.overload
    @staticmethod
    def singleShot(arg__1:int, arg__2:typing.Callable) -> None: ...
    @typing.overload
    @staticmethod
    def singleShot(msec:int, receiver:PySide6.QtCore.QObject, member:bytes) -> None: ...
    @typing.overload
    @staticmethod
    def singleShot(msec:int, timerType:PySide6.QtCore.Qt.TimerType, receiver:PySide6.QtCore.QObject, member:bytes) -> None: ...
    @typing.overload
    def start(self) -> None: ...
    @typing.overload
    def start(self, msec:int) -> None: ...
    def stop(self) -> None: ...
    def timerEvent(self, arg__1:PySide6.QtCore.QTimerEvent) -> None: ...
    def timerId(self) -> int: ...
    def timerType(self) -> PySide6.QtCore.Qt.TimerType: ...


class QTimerEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QTimerEvent) -> None: ...
    @typing.overload
    def __init__(self, timerId:int) -> None: ...

    def clone(self) -> PySide6.QtCore.QTimerEvent: ...
    def timerId(self) -> int: ...


class QTranslator(PySide6.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def filePath(self) -> str: ...
    def isEmpty(self) -> bool: ...
    def language(self) -> str: ...
    @typing.overload
    def load(self, data:bytes, len:int, directory:str=...) -> bool: ...
    @typing.overload
    def load(self, filename:str, directory:str=..., search_delimiters:str=..., suffix:str=...) -> bool: ...
    @typing.overload
    def load(self, locale:PySide6.QtCore.QLocale, filename:str, prefix:str=..., directory:str=..., suffix:str=...) -> bool: ...
    def translate(self, context:bytes, sourceText:bytes, disambiguation:typing.Optional[bytes]=..., n:int=...) -> str: ...


class QTransposeProxyModel(PySide6.QtCore.QAbstractProxyModel):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def columnCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def headerData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def index(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def insertRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def itemData(self, index:PySide6.QtCore.QModelIndex) -> typing.Dict: ...
    def mapFromSource(self, sourceIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def moveColumns(self, sourceParent:PySide6.QtCore.QModelIndex, sourceColumn:int, count:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    def moveRows(self, sourceParent:PySide6.QtCore.QModelIndex, sourceRow:int, count:int, destinationParent:PySide6.QtCore.QModelIndex, destinationChild:int) -> bool: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def removeRows(self, row:int, count:int, parent:PySide6.QtCore.QModelIndex=...) -> bool: ...
    def rowCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def setHeaderData(self, section:int, orientation:PySide6.QtCore.Qt.Orientation, value:typing.Any, role:int=...) -> bool: ...
    def setItemData(self, index:PySide6.QtCore.QModelIndex, roles:typing.Dict) -> bool: ...
    def setSourceModel(self, newSourceModel:PySide6.QtCore.QAbstractItemModel) -> None: ...
    def sort(self, column:int, order:PySide6.QtCore.Qt.SortOrder=...) -> None: ...
    def span(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QSize: ...


class QUrl(Shiboken.Object):
    DefaultResolution        : QUrl = ... # 0x0
    None_                    : QUrl = ... # 0x0
    PrettyDecoded            : QUrl = ... # 0x0
    TolerantMode             : QUrl = ... # 0x0
    AssumeLocalFile          : QUrl = ... # 0x1
    RemoveScheme             : QUrl = ... # 0x1
    StrictMode               : QUrl = ... # 0x1
    DecodedMode              : QUrl = ... # 0x2
    RemovePassword           : QUrl = ... # 0x2
    RemoveUserInfo           : QUrl = ... # 0x6
    RemovePort               : QUrl = ... # 0x8
    RemoveAuthority          : QUrl = ... # 0x1e
    RemovePath               : QUrl = ... # 0x20
    RemoveQuery              : QUrl = ... # 0x40
    RemoveFragment           : QUrl = ... # 0x80
    PreferLocalFile          : QUrl = ... # 0x200
    StripTrailingSlash       : QUrl = ... # 0x400
    RemoveFilename           : QUrl = ... # 0x800
    NormalizePathSegments    : QUrl = ... # 0x1000
    EncodeSpaces             : QUrl = ... # 0x100000
    EncodeUnicode            : QUrl = ... # 0x200000
    EncodeDelimiters         : QUrl = ... # 0xc00000
    EncodeReserved           : QUrl = ... # 0x1000000
    FullyEncoded             : QUrl = ... # 0x1f00000
    DecodeReserved           : QUrl = ... # 0x2000000
    FullyDecoded             : QUrl = ... # 0x7f00000

    class ComponentFormattingOption(object):
        PrettyDecoded            : QUrl.ComponentFormattingOption = ... # 0x0
        EncodeSpaces             : QUrl.ComponentFormattingOption = ... # 0x100000
        EncodeUnicode            : QUrl.ComponentFormattingOption = ... # 0x200000
        EncodeDelimiters         : QUrl.ComponentFormattingOption = ... # 0xc00000
        EncodeReserved           : QUrl.ComponentFormattingOption = ... # 0x1000000
        FullyEncoded             : QUrl.ComponentFormattingOption = ... # 0x1f00000
        DecodeReserved           : QUrl.ComponentFormattingOption = ... # 0x2000000
        FullyDecoded             : QUrl.ComponentFormattingOption = ... # 0x7f00000

    class FormattingOptions(object): ...

    class ParsingMode(object):
        TolerantMode             : QUrl.ParsingMode = ... # 0x0
        StrictMode               : QUrl.ParsingMode = ... # 0x1
        DecodedMode              : QUrl.ParsingMode = ... # 0x2

    class UrlFormattingOption(object):
        None_                    : QUrl.UrlFormattingOption = ... # 0x0
        RemoveScheme             : QUrl.UrlFormattingOption = ... # 0x1
        RemovePassword           : QUrl.UrlFormattingOption = ... # 0x2
        RemoveUserInfo           : QUrl.UrlFormattingOption = ... # 0x6
        RemovePort               : QUrl.UrlFormattingOption = ... # 0x8
        RemoveAuthority          : QUrl.UrlFormattingOption = ... # 0x1e
        RemovePath               : QUrl.UrlFormattingOption = ... # 0x20
        RemoveQuery              : QUrl.UrlFormattingOption = ... # 0x40
        RemoveFragment           : QUrl.UrlFormattingOption = ... # 0x80
        PreferLocalFile          : QUrl.UrlFormattingOption = ... # 0x200
        StripTrailingSlash       : QUrl.UrlFormattingOption = ... # 0x400
        RemoveFilename           : QUrl.UrlFormattingOption = ... # 0x800
        NormalizePathSegments    : QUrl.UrlFormattingOption = ... # 0x1000

    class UserInputResolutionOption(object):
        DefaultResolution        : QUrl.UserInputResolutionOption = ... # 0x0
        AssumeLocalFile          : QUrl.UserInputResolutionOption = ... # 0x1

    class UserInputResolutionOptions(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, copy:PySide6.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, url:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def adjusted(self, options:PySide6.QtCore.QUrl.FormattingOptions) -> PySide6.QtCore.QUrl: ...
    def authority(self, options:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def clear(self) -> None: ...
    def errorString(self) -> str: ...
    def fileName(self, options:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def fragment(self, options:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    @staticmethod
    def fromAce(arg__1:PySide6.QtCore.QByteArray) -> str: ...
    @staticmethod
    def fromEncoded(url:PySide6.QtCore.QByteArray, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> PySide6.QtCore.QUrl: ...
    @staticmethod
    def fromLocalFile(localfile:str) -> PySide6.QtCore.QUrl: ...
    @staticmethod
    def fromPercentEncoding(arg__1:PySide6.QtCore.QByteArray) -> str: ...
    @staticmethod
    def fromStringList(uris:typing.Sequence, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> typing.List: ...
    @staticmethod
    def fromUserInput(userInput:str, workingDirectory:str=..., options:PySide6.QtCore.QUrl.UserInputResolutionOptions=...) -> PySide6.QtCore.QUrl: ...
    def hasFragment(self) -> bool: ...
    def hasQuery(self) -> bool: ...
    def host(self, arg__1:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    @staticmethod
    def idnWhitelist() -> typing.List: ...
    def isEmpty(self) -> bool: ...
    def isLocalFile(self) -> bool: ...
    def isParentOf(self, url:PySide6.QtCore.QUrl) -> bool: ...
    def isRelative(self) -> bool: ...
    def isValid(self) -> bool: ...
    def matches(self, url:PySide6.QtCore.QUrl, options:PySide6.QtCore.QUrl.FormattingOptions) -> bool: ...
    def password(self, arg__1:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def path(self, options:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def port(self, defaultPort:int=...) -> int: ...
    def query(self, arg__1:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def resolved(self, relative:PySide6.QtCore.QUrl) -> PySide6.QtCore.QUrl: ...
    def scheme(self) -> str: ...
    def setAuthority(self, authority:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def setFragment(self, fragment:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def setHost(self, host:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    @staticmethod
    def setIdnWhitelist(arg__1:typing.Sequence) -> None: ...
    def setPassword(self, password:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def setPath(self, path:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def setPort(self, port:int) -> None: ...
    @typing.overload
    def setQuery(self, query:PySide6.QtCore.QUrlQuery) -> None: ...
    @typing.overload
    def setQuery(self, query:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def setScheme(self, scheme:str) -> None: ...
    def setUrl(self, url:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def setUserInfo(self, userInfo:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def setUserName(self, userName:str, mode:PySide6.QtCore.QUrl.ParsingMode=...) -> None: ...
    def swap(self, other:PySide6.QtCore.QUrl) -> None: ...
    @staticmethod
    def toAce(arg__1:str) -> PySide6.QtCore.QByteArray: ...
    def toDisplayString(self, options:PySide6.QtCore.QUrl.FormattingOptions=...) -> str: ...
    def toEncoded(self, options:PySide6.QtCore.QUrl.FormattingOptions=...) -> PySide6.QtCore.QByteArray: ...
    def toLocalFile(self) -> str: ...
    @staticmethod
    def toPercentEncoding(arg__1:str, exclude:PySide6.QtCore.QByteArray=..., include:PySide6.QtCore.QByteArray=...) -> PySide6.QtCore.QByteArray: ...
    def toString(self, options:PySide6.QtCore.QUrl.FormattingOptions=...) -> str: ...
    @staticmethod
    def toStringList(uris:typing.Sequence, options:PySide6.QtCore.QUrl.FormattingOptions=...) -> typing.List: ...
    def url(self, options:PySide6.QtCore.QUrl.FormattingOptions=...) -> str: ...
    def userInfo(self, options:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def userName(self, options:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...


class QUrlQuery(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtCore.QUrlQuery) -> None: ...
    @typing.overload
    def __init__(self, queryString:str) -> None: ...
    @typing.overload
    def __init__(self, url:PySide6.QtCore.QUrl) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def addQueryItem(self, key:str, value:str) -> None: ...
    def allQueryItemValues(self, key:str, encoding:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> typing.List: ...
    def clear(self) -> None: ...
    def hasQueryItem(self, key:str) -> bool: ...
    def isEmpty(self) -> bool: ...
    def query(self, encoding:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def queryItemValue(self, key:str, encoding:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def queryItems(self, encoding:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> typing.List: ...
    def queryPairDelimiter(self) -> str: ...
    def queryValueDelimiter(self) -> str: ...
    def removeAllQueryItems(self, key:str) -> None: ...
    def removeQueryItem(self, key:str) -> None: ...
    def setQuery(self, queryString:str) -> None: ...
    def setQueryDelimiters(self, valueDelimiter:str, pairDelimiter:str) -> None: ...
    def setQueryItems(self, query:typing.Sequence) -> None: ...
    def swap(self, other:PySide6.QtCore.QUrlQuery) -> None: ...
    def toString(self, encoding:PySide6.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...


class QUuid(Shiboken.Object):
    VarUnknown               : QUuid = ... # -0x1
    VerUnknown               : QUuid = ... # -0x1
    NCS                      : QUuid = ... # 0x0
    WithBraces               : QUuid = ... # 0x0
    Time                     : QUuid = ... # 0x1
    WithoutBraces            : QUuid = ... # 0x1
    DCE                      : QUuid = ... # 0x2
    EmbeddedPOSIX            : QUuid = ... # 0x2
    Id128                    : QUuid = ... # 0x3
    Md5                      : QUuid = ... # 0x3
    Name                     : QUuid = ... # 0x3
    Random                   : QUuid = ... # 0x4
    Sha1                     : QUuid = ... # 0x5
    Microsoft                : QUuid = ... # 0x6
    Reserved                 : QUuid = ... # 0x7

    class StringFormat(object):
        WithBraces               : QUuid.StringFormat = ... # 0x0
        WithoutBraces            : QUuid.StringFormat = ... # 0x1
        Id128                    : QUuid.StringFormat = ... # 0x3

    class Variant(object):
        VarUnknown               : QUuid.Variant = ... # -0x1
        NCS                      : QUuid.Variant = ... # 0x0
        DCE                      : QUuid.Variant = ... # 0x2
        Microsoft                : QUuid.Variant = ... # 0x6
        Reserved                 : QUuid.Variant = ... # 0x7

    class Version(object):
        VerUnknown               : QUuid.Version = ... # -0x1
        Time                     : QUuid.Version = ... # 0x1
        EmbeddedPOSIX            : QUuid.Version = ... # 0x2
        Md5                      : QUuid.Version = ... # 0x3
        Name                     : QUuid.Version = ... # 0x3
        Random                   : QUuid.Version = ... # 0x4
        Sha1                     : QUuid.Version = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, arg__1:str) -> None: ...
    @typing.overload
    def __init__(self, arg__1:bytes) -> None: ...
    @typing.overload
    def __init__(self, l:int, w1:int, w2:int, b1:int, b2:int, b3:int, b4:int, b5:int, b6:int, b7:int, b8:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    @staticmethod
    def createUuid() -> PySide6.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV3(ns:PySide6.QtCore.QUuid, baseData:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV3(ns:PySide6.QtCore.QUuid, baseData:str) -> PySide6.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV5(ns:PySide6.QtCore.QUuid, baseData:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QUuid: ...
    @typing.overload
    @staticmethod
    def createUuidV5(ns:PySide6.QtCore.QUuid, baseData:str) -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def fromRfc4122(arg__1:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def fromString(string:str) -> PySide6.QtCore.QUuid: ...
    def isNull(self) -> bool: ...
    def toByteArray(self, mode:PySide6.QtCore.QUuid.StringFormat=...) -> PySide6.QtCore.QByteArray: ...
    def toRfc4122(self) -> PySide6.QtCore.QByteArray: ...
    def toString(self, mode:PySide6.QtCore.QUuid.StringFormat=...) -> str: ...
    def variant(self) -> PySide6.QtCore.QUuid.Variant: ...
    def version(self) -> PySide6.QtCore.QUuid.Version: ...


class QVariantAnimation(PySide6.QtCore.QAbstractAnimation):

    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def currentValue(self) -> typing.Any: ...
    def duration(self) -> int: ...
    def easingCurve(self) -> PySide6.QtCore.QEasingCurve: ...
    def endValue(self) -> typing.Any: ...
    def event(self, event:PySide6.QtCore.QEvent) -> bool: ...
    def interpolated(self, from_:typing.Any, to:typing.Any, progress:float) -> typing.Any: ...
    def keyValueAt(self, step:float) -> typing.Any: ...
    def setDuration(self, msecs:int) -> None: ...
    def setEasingCurve(self, easing:PySide6.QtCore.QEasingCurve) -> None: ...
    def setEndValue(self, value:typing.Any) -> None: ...
    def setKeyValueAt(self, step:float, value:typing.Any) -> None: ...
    def setStartValue(self, value:typing.Any) -> None: ...
    def startValue(self) -> typing.Any: ...
    def updateCurrentTime(self, arg__1:int) -> None: ...
    def updateCurrentValue(self, value:typing.Any) -> None: ...
    def updateState(self, newState:PySide6.QtCore.QAbstractAnimation.State, oldState:PySide6.QtCore.QAbstractAnimation.State) -> None: ...


class QVersionNumber(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, maj:int) -> None: ...
    @typing.overload
    def __init__(self, maj:int, min:int) -> None: ...
    @typing.overload
    def __init__(self, maj:int, min:int, mic:int) -> None: ...
    @typing.overload
    def __init__(self, seg:typing.Sequence) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def commonPrefix(v1:PySide6.QtCore.QVersionNumber, v2:PySide6.QtCore.QVersionNumber) -> PySide6.QtCore.QVersionNumber: ...
    @staticmethod
    def compare(v1:PySide6.QtCore.QVersionNumber, v2:PySide6.QtCore.QVersionNumber) -> int: ...
    @staticmethod
    def fromString(string:str) -> typing.Tuple: ...
    def isNormalized(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isPrefixOf(self, other:PySide6.QtCore.QVersionNumber) -> bool: ...
    def majorVersion(self) -> int: ...
    def microVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def normalized(self) -> PySide6.QtCore.QVersionNumber: ...
    def segmentAt(self, index:int) -> int: ...
    def segmentCount(self) -> int: ...
    def segments(self) -> typing.List: ...
    def toString(self) -> str: ...


class QWaitCondition(Shiboken.Object):

    def __init__(self) -> None: ...

    def notify_all(self) -> None: ...
    def notify_one(self) -> None: ...
    @typing.overload
    def wait(self, lockedMutex:PySide6.QtCore.QMutex, deadline:PySide6.QtCore.QDeadlineTimer=...) -> bool: ...
    @typing.overload
    def wait(self, lockedMutex:PySide6.QtCore.QMutex, time:int) -> bool: ...
    @typing.overload
    def wait(self, lockedReadWriteLock:PySide6.QtCore.QReadWriteLock, deadline:PySide6.QtCore.QDeadlineTimer=...) -> bool: ...
    @typing.overload
    def wait(self, lockedReadWriteLock:PySide6.QtCore.QReadWriteLock, time:int) -> bool: ...
    def wakeAll(self) -> None: ...
    def wakeOne(self) -> None: ...


class QWinEventNotifier(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self, hEvent:int, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def event(self, e:PySide6.QtCore.QEvent) -> bool: ...
    def handle(self) -> int: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable:bool) -> None: ...
    def setHandle(self, hEvent:int) -> None: ...


class QWriteLocker(Shiboken.Object):

    def __init__(self, readWriteLock:PySide6.QtCore.QReadWriteLock) -> None: ...

    def __enter__(self) -> None: ...
    def __exit__(self, arg__1:object, arg__2:object, arg__3:object) -> None: ...
    def readWriteLock(self) -> PySide6.QtCore.QReadWriteLock: ...
    def relock(self) -> None: ...
    def unlock(self) -> None: ...


class QXmlStreamAttribute(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamAttribute:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    @typing.overload
    def __init__(self, namespaceUri:str, name:str, value:str) -> None: ...
    @typing.overload
    def __init__(self, qualifiedName:str, value:str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isDefault(self) -> bool: ...
    def name(self) -> str: ...
    def namespaceUri(self) -> str: ...
    def prefix(self) -> str: ...
    def qualifiedName(self) -> str: ...
    def value(self) -> str: ...


class QXmlStreamAttributes(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamAttributes:PySide6.QtCore.QXmlStreamAttributes) -> None: ...

    def __add__(self, l:typing.Sequence) -> typing.List: ...
    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, l:typing.Sequence) -> typing.List: ...
    @typing.overload
    def append(self, namespaceUri:str, name:str, value:str) -> None: ...
    @typing.overload
    def append(self, qualifiedName:str, value:str) -> None: ...
    def at(self, i:int) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def back(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def constFirst(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def constLast(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def count(self) -> int: ...
    def data(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def empty(self) -> bool: ...
    @typing.overload
    def first(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def first(self, n:int) -> typing.List: ...
    @staticmethod
    def fromVector(vector:typing.Sequence) -> typing.List: ...
    def front(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def hasAttribute(self, namespaceUri:str, name:str) -> bool: ...
    @typing.overload
    def hasAttribute(self, qualifiedName:str) -> bool: ...
    def insert(self, arg__1:int, arg__2:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other:typing.Sequence) -> bool: ...
    @typing.overload
    def last(self) -> PySide6.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def last(self, n:int) -> typing.List: ...
    def length(self) -> int: ...
    def mid(self, pos:int, len:int=...) -> typing.List: ...
    def move(self, from_:int, to:int) -> None: ...
    def prepend(self, arg__1:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    def push_back(self, arg__1:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    def push_front(self, arg__1:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    def remove(self, i:int, n:int=...) -> None: ...
    def removeAll(self, arg__1:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    def removeAt(self, i:int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, arg__1:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    def reserve(self, size:int) -> None: ...
    def resize(self, size:int) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    @typing.overload
    def sliced(self, pos:int) -> typing.List: ...
    @typing.overload
    def sliced(self, pos:int, n:int) -> typing.List: ...
    def squeeze(self) -> None: ...
    def swap(self, other:typing.Sequence) -> None: ...
    def swapItemsAt(self, i:int, j:int) -> None: ...
    def takeAt(self, i:int) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def toVector(self) -> typing.List: ...
    @typing.overload
    def value(self, namespaceUri:str, name:str) -> str: ...
    @typing.overload
    def value(self, qualifiedName:str) -> str: ...


class QXmlStreamEntityDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamEntityDeclaration:PySide6.QtCore.QXmlStreamEntityDeclaration) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> str: ...
    def notationName(self) -> str: ...
    def publicId(self) -> str: ...
    def systemId(self) -> str: ...
    def value(self) -> str: ...


class QXmlStreamEntityResolver(Shiboken.Object):

    def __init__(self) -> None: ...

    def resolveEntity(self, publicId:str, systemId:str) -> str: ...
    def resolveUndeclaredEntity(self, name:str) -> str: ...


class QXmlStreamNamespaceDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamNamespaceDeclaration:PySide6.QtCore.QXmlStreamNamespaceDeclaration) -> None: ...
    @typing.overload
    def __init__(self, prefix:str, namespaceUri:str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def namespaceUri(self) -> str: ...
    def prefix(self) -> str: ...


class QXmlStreamNotationDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamNotationDeclaration:PySide6.QtCore.QXmlStreamNotationDeclaration) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> str: ...
    def publicId(self) -> str: ...
    def systemId(self) -> str: ...


class QXmlStreamReader(Shiboken.Object):
    ErrorOnUnexpectedElement : QXmlStreamReader = ... # 0x0
    NoError                  : QXmlStreamReader = ... # 0x0
    NoToken                  : QXmlStreamReader = ... # 0x0
    IncludeChildElements     : QXmlStreamReader = ... # 0x1
    Invalid                  : QXmlStreamReader = ... # 0x1
    UnexpectedElementError   : QXmlStreamReader = ... # 0x1
    CustomError              : QXmlStreamReader = ... # 0x2
    SkipChildElements        : QXmlStreamReader = ... # 0x2
    StartDocument            : QXmlStreamReader = ... # 0x2
    EndDocument              : QXmlStreamReader = ... # 0x3
    NotWellFormedError       : QXmlStreamReader = ... # 0x3
    PrematureEndOfDocumentError: QXmlStreamReader = ... # 0x4
    StartElement             : QXmlStreamReader = ... # 0x4
    EndElement               : QXmlStreamReader = ... # 0x5
    Characters               : QXmlStreamReader = ... # 0x6
    Comment                  : QXmlStreamReader = ... # 0x7
    DTD                      : QXmlStreamReader = ... # 0x8
    EntityReference          : QXmlStreamReader = ... # 0x9
    ProcessingInstruction    : QXmlStreamReader = ... # 0xa

    class Error(object):
        NoError                  : QXmlStreamReader.Error = ... # 0x0
        UnexpectedElementError   : QXmlStreamReader.Error = ... # 0x1
        CustomError              : QXmlStreamReader.Error = ... # 0x2
        NotWellFormedError       : QXmlStreamReader.Error = ... # 0x3
        PrematureEndOfDocumentError: QXmlStreamReader.Error = ... # 0x4

    class ReadElementTextBehaviour(object):
        ErrorOnUnexpectedElement : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x0
        IncludeChildElements     : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x1
        SkipChildElements        : QXmlStreamReader.ReadElementTextBehaviour = ... # 0x2

    class TokenType(object):
        NoToken                  : QXmlStreamReader.TokenType = ... # 0x0
        Invalid                  : QXmlStreamReader.TokenType = ... # 0x1
        StartDocument            : QXmlStreamReader.TokenType = ... # 0x2
        EndDocument              : QXmlStreamReader.TokenType = ... # 0x3
        StartElement             : QXmlStreamReader.TokenType = ... # 0x4
        EndElement               : QXmlStreamReader.TokenType = ... # 0x5
        Characters               : QXmlStreamReader.TokenType = ... # 0x6
        Comment                  : QXmlStreamReader.TokenType = ... # 0x7
        DTD                      : QXmlStreamReader.TokenType = ... # 0x8
        EntityReference          : QXmlStreamReader.TokenType = ... # 0x9
        ProcessingInstruction    : QXmlStreamReader.TokenType = ... # 0xa

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, data:str) -> None: ...
    @typing.overload
    def __init__(self, data:bytes) -> None: ...
    @typing.overload
    def __init__(self, device:PySide6.QtCore.QIODevice) -> None: ...

    @typing.overload
    def addData(self, data:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def addData(self, data:str) -> None: ...
    @typing.overload
    def addData(self, data:bytes) -> None: ...
    def addExtraNamespaceDeclaration(self, extraNamespaceDeclaraction:PySide6.QtCore.QXmlStreamNamespaceDeclaration) -> None: ...
    def addExtraNamespaceDeclarations(self, extraNamespaceDeclaractions:typing.Sequence) -> None: ...
    def atEnd(self) -> bool: ...
    def attributes(self) -> PySide6.QtCore.QXmlStreamAttributes: ...
    def characterOffset(self) -> int: ...
    def clear(self) -> None: ...
    def columnNumber(self) -> int: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def documentEncoding(self) -> str: ...
    def documentVersion(self) -> str: ...
    def dtdName(self) -> str: ...
    def dtdPublicId(self) -> str: ...
    def dtdSystemId(self) -> str: ...
    def entityDeclarations(self) -> typing.List: ...
    def entityExpansionLimit(self) -> int: ...
    def entityResolver(self) -> PySide6.QtCore.QXmlStreamEntityResolver: ...
    def error(self) -> PySide6.QtCore.QXmlStreamReader.Error: ...
    def errorString(self) -> str: ...
    def hasError(self) -> bool: ...
    def isCDATA(self) -> bool: ...
    def isCharacters(self) -> bool: ...
    def isComment(self) -> bool: ...
    def isDTD(self) -> bool: ...
    def isEndDocument(self) -> bool: ...
    def isEndElement(self) -> bool: ...
    def isEntityReference(self) -> bool: ...
    def isProcessingInstruction(self) -> bool: ...
    def isStandaloneDocument(self) -> bool: ...
    def isStartDocument(self) -> bool: ...
    def isStartElement(self) -> bool: ...
    def isWhitespace(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def name(self) -> str: ...
    def namespaceDeclarations(self) -> typing.List: ...
    def namespaceProcessing(self) -> bool: ...
    def namespaceUri(self) -> str: ...
    def notationDeclarations(self) -> typing.List: ...
    def prefix(self) -> str: ...
    def processingInstructionData(self) -> str: ...
    def processingInstructionTarget(self) -> str: ...
    def qualifiedName(self) -> str: ...
    def raiseError(self, message:str=...) -> None: ...
    def readElementText(self, behaviour:PySide6.QtCore.QXmlStreamReader.ReadElementTextBehaviour=...) -> str: ...
    def readNext(self) -> PySide6.QtCore.QXmlStreamReader.TokenType: ...
    def readNextStartElement(self) -> bool: ...
    def setDevice(self, device:PySide6.QtCore.QIODevice) -> None: ...
    def setEntityExpansionLimit(self, limit:int) -> None: ...
    def setEntityResolver(self, resolver:PySide6.QtCore.QXmlStreamEntityResolver) -> None: ...
    def setNamespaceProcessing(self, arg__1:bool) -> None: ...
    def skipCurrentElement(self) -> None: ...
    def text(self) -> str: ...
    def tokenString(self) -> str: ...
    def tokenType(self) -> PySide6.QtCore.QXmlStreamReader.TokenType: ...


class QXmlStreamWriter(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, array:PySide6.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, device:PySide6.QtCore.QIODevice) -> None: ...

    def autoFormatting(self) -> bool: ...
    def autoFormattingIndent(self) -> int: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def hasError(self) -> bool: ...
    def setAutoFormatting(self, arg__1:bool) -> None: ...
    def setAutoFormattingIndent(self, spacesOrTabs:int) -> None: ...
    def setDevice(self, device:PySide6.QtCore.QIODevice) -> None: ...
    @typing.overload
    def writeAttribute(self, attribute:PySide6.QtCore.QXmlStreamAttribute) -> None: ...
    @typing.overload
    def writeAttribute(self, namespaceUri:str, name:str, value:str) -> None: ...
    @typing.overload
    def writeAttribute(self, qualifiedName:str, value:str) -> None: ...
    def writeAttributes(self, attributes:PySide6.QtCore.QXmlStreamAttributes) -> None: ...
    def writeCDATA(self, text:str) -> None: ...
    def writeCharacters(self, text:str) -> None: ...
    def writeComment(self, text:str) -> None: ...
    def writeCurrentToken(self, reader:PySide6.QtCore.QXmlStreamReader) -> None: ...
    def writeDTD(self, dtd:str) -> None: ...
    def writeDefaultNamespace(self, namespaceUri:str) -> None: ...
    @typing.overload
    def writeEmptyElement(self, namespaceUri:str, name:str) -> None: ...
    @typing.overload
    def writeEmptyElement(self, qualifiedName:str) -> None: ...
    def writeEndDocument(self) -> None: ...
    def writeEndElement(self) -> None: ...
    def writeEntityReference(self, name:str) -> None: ...
    def writeNamespace(self, namespaceUri:str, prefix:str=...) -> None: ...
    def writeProcessingInstruction(self, target:str, data:str=...) -> None: ...
    @typing.overload
    def writeStartDocument(self) -> None: ...
    @typing.overload
    def writeStartDocument(self, version:str) -> None: ...
    @typing.overload
    def writeStartDocument(self, version:str, standalone:bool) -> None: ...
    @typing.overload
    def writeStartElement(self, namespaceUri:str, name:str) -> None: ...
    @typing.overload
    def writeStartElement(self, qualifiedName:str) -> None: ...
    @typing.overload
    def writeTextElement(self, namespaceUri:str, name:str, text:str) -> None: ...
    @typing.overload
    def writeTextElement(self, qualifiedName:str, text:str) -> None: ...


class Qt(Shiboken.Object):
    ImPlatformData           : Qt = ... # -0x80000000
    WindowFullscreenButtonHint: Qt = ... # -0x80000000
    KeyboardModifierMask     : Qt = ... # -0x2000000
    MODIFIER_MASK            : Qt = ... # -0x2000000
    ImhExclusiveInputMask    : Qt = ... # -0x10000
    ImQueryAll               : Qt = ... # -0x1
    LastGestureType          : Qt = ... # -0x1
    LowEventPriority         : Qt = ... # -0x1
    MouseButtonMask          : Qt = ... # -0x1
    WhiteSpaceModeUndefined  : Qt = ... # -0x1
    AbsoluteSize             : Qt = ... # 0x0
    AnchorLeft               : Qt = ... # 0x0
    ApplicationSuspended     : Qt = ... # 0x0
    ArrowCursor              : Qt = ... # 0x0
    AscendingOrder           : Qt = ... # 0x0
    AutoColor                : Qt = ... # 0x0
    AutoConnection           : Qt = ... # 0x0
    AutoDither               : Qt = ... # 0x0
    BeginNativeGesture       : Qt = ... # 0x0
    CaseInsensitive          : Qt = ... # 0x0
    ChecksumIso3309          : Qt = ... # 0x0
    ContainsItemShape        : Qt = ... # 0x0
    DeviceCoordinates        : Qt = ... # 0x0
    DiffuseDither            : Qt = ... # 0x0
    DisplayRole              : Qt = ... # 0x0
    ElideLeft                : Qt = ... # 0x0
    EnterKeyDefault          : Qt = ... # 0x0
    ExactHit                 : Qt = ... # 0x0
    FastTransformation       : Qt = ... # 0x0
    FindDirectChildrenOnly   : Qt = ... # 0x0
    FlatCap                  : Qt = ... # 0x0
    IgnoreAction             : Qt = ... # 0x0
    IgnoreAspectRatio        : Qt = ... # 0x0
    ImhNone                  : Qt = ... # 0x0
    KeepEmptyParts           : Qt = ... # 0x0
    LeftToRight              : Qt = ... # 0x0
    LocalTime                : Qt = ... # 0x0
    LogicalMoveStyle         : Qt = ... # 0x0
    MaskInColor              : Qt = ... # 0x0
    MatchExactly             : Qt = ... # 0x0
    MinimumSize              : Qt = ... # 0x0
    MiterJoin                : Qt = ... # 0x0
    MouseEventNotSynthesized : Qt = ... # 0x0
    MouseFocusReason         : Qt = ... # 0x0
    NavigationModeNone       : Qt = ... # 0x0
    NoArrow                  : Qt = ... # 0x0
    NoBrush                  : Qt = ... # 0x0
    NoButton                 : Qt = ... # 0x0
    NoClip                   : Qt = ... # 0x0
    NoContextMenu            : Qt = ... # 0x0
    NoDockWidgetArea         : Qt = ... # 0x0
    NoFocus                  : Qt = ... # 0x0
    NoGesture                : Qt = ... # 0x0
    NoItemFlags              : Qt = ... # 0x0
    NoModifier               : Qt = ... # 0x0
    NoMouseEventFlag         : Qt = ... # 0x0
    NoPen                    : Qt = ... # 0x0
    NoScrollPhase            : Qt = ... # 0x0
    NoSection                : Qt = ... # 0x0
    NoTabFocus               : Qt = ... # 0x0
    NoTextInteraction        : Qt = ... # 0x0
    NoToolBarArea            : Qt = ... # 0x0
    NonModal                 : Qt = ... # 0x0
    NormalEventPriority      : Qt = ... # 0x0
    OddEvenFill              : Qt = ... # 0x0
    PlainText                : Qt = ... # 0x0
    PreciseTimer             : Qt = ... # 0x0
    PrimaryOrientation       : Qt = ... # 0x0
    ReplaceSelection         : Qt = ... # 0x0
    ReturnByValue            : Qt = ... # 0x0
    ScrollBarAsNeeded        : Qt = ... # 0x0
    StretchTile              : Qt = ... # 0x0
    TextDate                 : Qt = ... # 0x0
    ThresholdAlphaDither     : Qt = ... # 0x0
    ToolButtonIconOnly       : Qt = ... # 0x0
    TopLeftCorner            : Qt = ... # 0x0
    TouchPointUnknownState   : Qt = ... # 0x0
    TransparentMode          : Qt = ... # 0x0
    UI_General               : Qt = ... # 0x0
    Unchecked                : Qt = ... # 0x0
    WA_Disabled              : Qt = ... # 0x0
    WhiteSpaceNormal         : Qt = ... # 0x0
    Widget                   : Qt = ... # 0x0
    WidgetShortcut           : Qt = ... # 0x0
    WindowNoState            : Qt = ... # 0x0
    XAxis                    : Qt = ... # 0x0
    color0                   : Qt = ... # 0x0
    AddToSelection           : Qt = ... # 0x1
    AlignLeading             : Qt = ... # 0x1
    AlignLeft                : Qt = ... # 0x1
    AnchorHorizontalCenter   : Qt = ... # 0x1
    ApplicationHidden        : Qt = ... # 0x1
    CaseSensitive            : Qt = ... # 0x1
    ChecksumItuV41           : Qt = ... # 0x1
    CoarseTimer              : Qt = ... # 0x1
    CopyAction               : Qt = ... # 0x1
    DecorationRole           : Qt = ... # 0x1
    DefaultContextMenu       : Qt = ... # 0x1
    DescendingOrder          : Qt = ... # 0x1
    DirectConnection         : Qt = ... # 0x1
    DontStartGestureOnChildren: Qt = ... # 0x1
    ElideRight               : Qt = ... # 0x1
    EndNativeGesture         : Qt = ... # 0x1
    EnterKeyReturn           : Qt = ... # 0x1
    FindChildrenRecursively  : Qt = ... # 0x1
    FuzzyHit                 : Qt = ... # 0x1
    GestureStarted           : Qt = ... # 0x1
    HighEventPriority        : Qt = ... # 0x1
    Horizontal               : Qt = ... # 0x1
    ISODate                  : Qt = ... # 0x1
    ImEnabled                : Qt = ... # 0x1
    ImhHiddenText            : Qt = ... # 0x1
    IntersectsItemShape      : Qt = ... # 0x1
    ItemIsSelectable         : Qt = ... # 0x1
    KeepAspectRatio          : Qt = ... # 0x1
    LeftButton               : Qt = ... # 0x1
    LeftDockWidgetArea       : Qt = ... # 0x1
    LeftSection              : Qt = ... # 0x1
    LeftToolBarArea          : Qt = ... # 0x1
    LogicalCoordinates       : Qt = ... # 0x1
    MaskOutColor             : Qt = ... # 0x1
    MatchContains            : Qt = ... # 0x1
    Monday                   : Qt = ... # 0x1
    MouseEventCreatedDoubleClick: Qt = ... # 0x1
    MouseEventSynthesizedBySystem: Qt = ... # 0x1
    NavigationModeKeypadTabOrder: Qt = ... # 0x1
    OpaqueMode               : Qt = ... # 0x1
    PartiallyChecked         : Qt = ... # 0x1
    PortraitOrientation      : Qt = ... # 0x1
    PreferredSize            : Qt = ... # 0x1
    RelativeSize             : Qt = ... # 0x1
    RepeatTile               : Qt = ... # 0x1
    ReplaceClip              : Qt = ... # 0x1
    RichText                 : Qt = ... # 0x1
    RightToLeft              : Qt = ... # 0x1
    ScrollBarAlwaysOff       : Qt = ... # 0x1
    ScrollBegin              : Qt = ... # 0x1
    SkipEmptyParts           : Qt = ... # 0x1
    SmoothTransformation     : Qt = ... # 0x1
    SolidLine                : Qt = ... # 0x1
    SolidPattern             : Qt = ... # 0x1
    TabFocus                 : Qt = ... # 0x1
    TabFocusReason           : Qt = ... # 0x1
    TabFocusTextControls     : Qt = ... # 0x1
    TapGesture               : Qt = ... # 0x1
    TextSelectableByMouse    : Qt = ... # 0x1
    ToolButtonTextOnly       : Qt = ... # 0x1
    TopEdge                  : Qt = ... # 0x1
    TopRightCorner           : Qt = ... # 0x1
    TouchPointPressed        : Qt = ... # 0x1
    UI_AnimateMenu           : Qt = ... # 0x1
    UTC                      : Qt = ... # 0x1
    UpArrow                  : Qt = ... # 0x1
    UpArrowCursor            : Qt = ... # 0x1
    VisualMoveStyle          : Qt = ... # 0x1
    WA_UnderMouse            : Qt = ... # 0x1
    WhiteSpacePre            : Qt = ... # 0x1
    WindingFill              : Qt = ... # 0x1
    Window                   : Qt = ... # 0x1
    WindowMinimized          : Qt = ... # 0x1
    WindowModal              : Qt = ... # 0x1
    WindowShortcut           : Qt = ... # 0x1
    YAxis                    : Qt = ... # 0x1
    color1                   : Qt = ... # 0x1
    AA_DontShowIconsInMenus  : Qt = ... # 0x2
    ActionsContextMenu       : Qt = ... # 0x2
    AlignRight               : Qt = ... # 0x2
    AlignTrailing            : Qt = ... # 0x2
    AnchorRight              : Qt = ... # 0x2
    ApplicationInactive      : Qt = ... # 0x2
    ApplicationModal         : Qt = ... # 0x2
    ApplicationShortcut      : Qt = ... # 0x2
    AutoText                 : Qt = ... # 0x2
    BacktabFocusReason       : Qt = ... # 0x2
    BottomLeftCorner         : Qt = ... # 0x2
    Checked                  : Qt = ... # 0x2
    ClickFocus               : Qt = ... # 0x2
    ContainsItemBoundingRect : Qt = ... # 0x2
    CrossCursor              : Qt = ... # 0x2
    DashLine                 : Qt = ... # 0x2
    Dense1Pattern            : Qt = ... # 0x2
    DownArrow                : Qt = ... # 0x2
    EditRole                 : Qt = ... # 0x2
    ElideMiddle              : Qt = ... # 0x2
    EnterKeyDone             : Qt = ... # 0x2
    GestureUpdated           : Qt = ... # 0x2
    ImCursorRectangle        : Qt = ... # 0x2
    ImhSensitiveData         : Qt = ... # 0x2
    IntersectClip            : Qt = ... # 0x2
    ItemIsEditable           : Qt = ... # 0x2
    KeepAspectRatioByExpanding: Qt = ... # 0x2
    LandscapeOrientation     : Qt = ... # 0x2
    LayoutDirectionAuto      : Qt = ... # 0x2
    LeftEdge                 : Qt = ... # 0x2
    MatchStartsWith          : Qt = ... # 0x2
    MaximumSize              : Qt = ... # 0x2
    MonoOnly                 : Qt = ... # 0x2
    MouseEventSynthesizedByQt: Qt = ... # 0x2
    MoveAction               : Qt = ... # 0x2
    NavigationModeKeypadDirectional: Qt = ... # 0x2
    OffsetFromUTC            : Qt = ... # 0x2
    PanNativeGesture         : Qt = ... # 0x2
    QueuedConnection         : Qt = ... # 0x2
    ReceivePartialGestures   : Qt = ... # 0x2
    RightButton              : Qt = ... # 0x2
    RightDockWidgetArea      : Qt = ... # 0x2
    RightToolBarArea         : Qt = ... # 0x2
    RoundTile                : Qt = ... # 0x2
    ScrollBarAlwaysOn        : Qt = ... # 0x2
    ScrollUpdate             : Qt = ... # 0x2
    TabFocusListControls     : Qt = ... # 0x2
    TapAndHoldGesture        : Qt = ... # 0x2
    TextSelectableByKeyboard : Qt = ... # 0x2
    ToolButtonTextBesideIcon : Qt = ... # 0x2
    TopLeftSection           : Qt = ... # 0x2
    TouchPointMoved          : Qt = ... # 0x2
    Tuesday                  : Qt = ... # 0x2
    UI_FadeMenu              : Qt = ... # 0x2
    Vertical                 : Qt = ... # 0x2
    VeryCoarseTimer          : Qt = ... # 0x2
    WA_MouseTracking         : Qt = ... # 0x2
    WhiteSpaceNoWrap         : Qt = ... # 0x2
    WindowMaximized          : Qt = ... # 0x2
    ZAxis                    : Qt = ... # 0x2
    black                    : Qt = ... # 0x2
    AA_NativeWindows         : Qt = ... # 0x3
    ActiveWindowFocusReason  : Qt = ... # 0x3
    AnchorTop                : Qt = ... # 0x3
    BlockingQueuedConnection : Qt = ... # 0x3
    BottomRightCorner        : Qt = ... # 0x3
    ColorMode_Mask           : Qt = ... # 0x3
    ColorOnly                : Qt = ... # 0x3
    CustomContextMenu        : Qt = ... # 0x3
    Dense2Pattern            : Qt = ... # 0x3
    Dialog                   : Qt = ... # 0x3
    DotLine                  : Qt = ... # 0x3
    ElideNone                : Qt = ... # 0x3
    EnterKeyGo               : Qt = ... # 0x3
    GestureFinished          : Qt = ... # 0x3
    IntersectsItemBoundingRect: Qt = ... # 0x3
    LeftArrow                : Qt = ... # 0x3
    MarkdownText             : Qt = ... # 0x3
    MatchEndsWith            : Qt = ... # 0x3
    MinimumDescent           : Qt = ... # 0x3
    MouseEventSynthesizedByApplication: Qt = ... # 0x3
    NavigationModeCursorAuto : Qt = ... # 0x3
    PanGesture               : Qt = ... # 0x3
    ScrollEnd                : Qt = ... # 0x3
    TimeZone                 : Qt = ... # 0x3
    ToolButtonTextUnderIcon  : Qt = ... # 0x3
    ToolTipRole              : Qt = ... # 0x3
    TopSection               : Qt = ... # 0x3
    UI_AnimateCombo          : Qt = ... # 0x3
    WaitCursor               : Qt = ... # 0x3
    Wednesday                : Qt = ... # 0x3
    WidgetWithChildrenShortcut: Qt = ... # 0x3
    ZoomNativeGesture        : Qt = ... # 0x3
    white                    : Qt = ... # 0x3
    AA_DontCreateNativeWidgetSiblings: Qt = ... # 0x4
    AlignHCenter             : Qt = ... # 0x4
    AnchorVerticalCenter     : Qt = ... # 0x4
    ApplicationActive        : Qt = ... # 0x4
    DashDotLine              : Qt = ... # 0x4
    Dense3Pattern            : Qt = ... # 0x4
    EnterKeySend             : Qt = ... # 0x4
    GestureCanceled          : Qt = ... # 0x4
    IBeamCursor              : Qt = ... # 0x4
    IgnoredGesturesPropagateToParent: Qt = ... # 0x4
    ImFont                   : Qt = ... # 0x4
    ImhNoAutoUppercase       : Qt = ... # 0x4
    InvertedPortraitOrientation: Qt = ... # 0x4
    ItemIsDragEnabled        : Qt = ... # 0x4
    LinkAction               : Qt = ... # 0x4
    LinksAccessibleByMouse   : Qt = ... # 0x4
    MatchRegularExpression   : Qt = ... # 0x4
    MiddleButton             : Qt = ... # 0x4
    NDockWidgetAreas         : Qt = ... # 0x4
    NSizeHints               : Qt = ... # 0x4
    NToolBarAreas            : Qt = ... # 0x4
    NavigationModeCursorForceVisible: Qt = ... # 0x4
    OrderedAlphaDither       : Qt = ... # 0x4
    PinchGesture             : Qt = ... # 0x4
    PopupFocusReason         : Qt = ... # 0x4
    PreventContextMenu       : Qt = ... # 0x4
    RightArrow               : Qt = ... # 0x4
    RightEdge                : Qt = ... # 0x4
    ScrollMomentum           : Qt = ... # 0x4
    SmartZoomNativeGesture   : Qt = ... # 0x4
    StatusTipRole            : Qt = ... # 0x4
    Thursday                 : Qt = ... # 0x4
    ToolButtonFollowStyle    : Qt = ... # 0x4
    TopDockWidgetArea        : Qt = ... # 0x4
    TopRightSection          : Qt = ... # 0x4
    TopToolBarArea           : Qt = ... # 0x4
    TouchPointStationary     : Qt = ... # 0x4
    UI_AnimateTooltip        : Qt = ... # 0x4
    WA_OpaquePaintEvent      : Qt = ... # 0x4
    WindowFullScreen         : Qt = ... # 0x4
    darkGray                 : Qt = ... # 0x4
    AA_PluginApplication     : Qt = ... # 0x5
    AnchorBottom             : Qt = ... # 0x5
    DashDotDotLine           : Qt = ... # 0x5
    Dense4Pattern            : Qt = ... # 0x5
    EnterKeySearch           : Qt = ... # 0x5
    Friday                   : Qt = ... # 0x5
    MatchWildcard            : Qt = ... # 0x5
    RightSection             : Qt = ... # 0x5
    RotateNativeGesture      : Qt = ... # 0x5
    Sheet                    : Qt = ... # 0x5
    ShortcutFocusReason      : Qt = ... # 0x5
    SizeVerCursor            : Qt = ... # 0x5
    SwipeGesture             : Qt = ... # 0x5
    UI_FadeTooltip           : Qt = ... # 0x5
    WA_StaticContents        : Qt = ... # 0x5
    WhatsThisRole            : Qt = ... # 0x5
    gray                     : Qt = ... # 0x5
    AA_DontUseNativeMenuBar  : Qt = ... # 0x6
    BottomRightSection       : Qt = ... # 0x6
    CustomDashLine           : Qt = ... # 0x6
    Dense5Pattern            : Qt = ... # 0x6
    EnterKeyNext             : Qt = ... # 0x6
    FontRole                 : Qt = ... # 0x6
    MenuBarFocusReason       : Qt = ... # 0x6
    Saturday                 : Qt = ... # 0x6
    SizeHorCursor            : Qt = ... # 0x6
    SwipeNativeGesture       : Qt = ... # 0x6
    UI_AnimateToolBox        : Qt = ... # 0x6
    lightGray                : Qt = ... # 0x6
    AA_MacDontSwapCtrlAndMeta: Qt = ... # 0x7
    BottomSection            : Qt = ... # 0x7
    Dense6Pattern            : Qt = ... # 0x7
    Drawer                   : Qt = ... # 0x7
    EnterKeyPrevious         : Qt = ... # 0x7
    OtherFocusReason         : Qt = ... # 0x7
    SizeBDiagCursor          : Qt = ... # 0x7
    Sunday                   : Qt = ... # 0x7
    TextAlignmentRole        : Qt = ... # 0x7
    WA_LaidOut               : Qt = ... # 0x7
    red                      : Qt = ... # 0x7
    AA_Use96Dpi              : Qt = ... # 0x8
    AlignJustify             : Qt = ... # 0x8
    BackButton               : Qt = ... # 0x8
    BackgroundRole           : Qt = ... # 0x8
    BottomDockWidgetArea     : Qt = ... # 0x8
    BottomEdge               : Qt = ... # 0x8
    BottomLeftSection        : Qt = ... # 0x8
    BottomToolBarArea        : Qt = ... # 0x8
    Dense7Pattern            : Qt = ... # 0x8
    DiffuseAlphaDither       : Qt = ... # 0x8
    ExtraButton1             : Qt = ... # 0x8
    ImCursorPosition         : Qt = ... # 0x8
    ImhPreferNumbers         : Qt = ... # 0x8
    InvertedLandscapeOrientation: Qt = ... # 0x8
    ItemIsDropEnabled        : Qt = ... # 0x8
    LinksAccessibleByKeyboard: Qt = ... # 0x8
    MatchFixedString         : Qt = ... # 0x8
    NoFocusReason            : Qt = ... # 0x8
    RFC2822Date              : Qt = ... # 0x8
    SizeFDiagCursor          : Qt = ... # 0x8
    TouchPointReleased       : Qt = ... # 0x8
    WA_PaintOnScreen         : Qt = ... # 0x8
    WindowActive             : Qt = ... # 0x8
    XButton1                 : Qt = ... # 0x8
    green                    : Qt = ... # 0x8
    AA_DisableNativeVirtualKeyboard: Qt = ... # 0x9
    ForegroundRole           : Qt = ... # 0x9
    HorPattern               : Qt = ... # 0x9
    ISODateWithMs            : Qt = ... # 0x9
    Popup                    : Qt = ... # 0x9
    SizeAllCursor            : Qt = ... # 0x9
    TitleBarArea             : Qt = ... # 0x9
    WA_NoSystemBackground    : Qt = ... # 0x9
    blue                     : Qt = ... # 0x9
    BlankCursor              : Qt = ... # 0xa
    CheckStateRole           : Qt = ... # 0xa
    VerPattern               : Qt = ... # 0xa
    WA_UpdatesDisabled       : Qt = ... # 0xa
    cyan                     : Qt = ... # 0xa
    AA_SynthesizeTouchForUnhandledMouseEvents: Qt = ... # 0xb
    AccessibleTextRole       : Qt = ... # 0xb
    CrossPattern             : Qt = ... # 0xb
    SplitVCursor             : Qt = ... # 0xb
    StrongFocus              : Qt = ... # 0xb
    Tool                     : Qt = ... # 0xb
    WA_Mapped                : Qt = ... # 0xb
    magenta                  : Qt = ... # 0xb
    AA_SynthesizeMouseForUnhandledTouchEvents: Qt = ... # 0xc
    AccessibleDescriptionRole: Qt = ... # 0xc
    AlphaDither_Mask         : Qt = ... # 0xc
    BDiagPattern             : Qt = ... # 0xc
    NoAlpha                  : Qt = ... # 0xc
    SplitHCursor             : Qt = ... # 0xc
    yellow                   : Qt = ... # 0xc
    AA_UseHighDpiPixmaps     : Qt = ... # 0xd
    FDiagPattern             : Qt = ... # 0xd
    PointingHandCursor       : Qt = ... # 0xd
    SizeHintRole             : Qt = ... # 0xd
    TextBrowserInteraction   : Qt = ... # 0xd
    ToolTip                  : Qt = ... # 0xd
    darkRed                  : Qt = ... # 0xd
    AA_ForceRasterWidgets    : Qt = ... # 0xe
    DiagCrossPattern         : Qt = ... # 0xe
    ForbiddenCursor          : Qt = ... # 0xe
    InitialSortOrderRole     : Qt = ... # 0xe
    WA_InputMethodEnabled    : Qt = ... # 0xe
    darkGreen                : Qt = ... # 0xe
    AA_UseDesktopOpenGL      : Qt = ... # 0xf
    AllDockWidgetAreas       : Qt = ... # 0xf
    AllToolBarAreas          : Qt = ... # 0xf
    DockWidgetArea_Mask      : Qt = ... # 0xf
    LinearGradientPattern    : Qt = ... # 0xf
    MPenStyle                : Qt = ... # 0xf
    SplashScreen             : Qt = ... # 0xf
    ToolBarArea_Mask         : Qt = ... # 0xf
    WA_WState_Visible        : Qt = ... # 0xf
    WhatsThisCursor          : Qt = ... # 0xf
    WheelFocus               : Qt = ... # 0xf
    darkBlue                 : Qt = ... # 0xf
    AA_UseOpenGLES           : Qt = ... # 0x10
    AlignAbsolute            : Qt = ... # 0x10
    BusyCursor               : Qt = ... # 0x10
    ExtraButton2             : Qt = ... # 0x10
    ForwardButton            : Qt = ... # 0x10
    ImSurroundingText        : Qt = ... # 0x10
    ImhPreferUppercase       : Qt = ... # 0x10
    ItemIsUserCheckable      : Qt = ... # 0x10
    MatchCaseSensitive       : Qt = ... # 0x10
    OrderedDither            : Qt = ... # 0x10
    RadialGradientPattern    : Qt = ... # 0x10
    SquareCap                : Qt = ... # 0x10
    TextEditable             : Qt = ... # 0x10
    WA_WState_Hidden         : Qt = ... # 0x10
    XButton2                 : Qt = ... # 0x10
    darkCyan                 : Qt = ... # 0x10
    AA_UseSoftwareOpenGL     : Qt = ... # 0x11
    ConicalGradientPattern   : Qt = ... # 0x11
    Desktop                  : Qt = ... # 0x11
    OpenHandCursor           : Qt = ... # 0x11
    darkMagenta              : Qt = ... # 0x11
    AA_ShareOpenGLContexts   : Qt = ... # 0x12
    ClosedHandCursor         : Qt = ... # 0x12
    SubWindow                : Qt = ... # 0x12
    darkYellow               : Qt = ... # 0x12
    AA_SetPalette            : Qt = ... # 0x13
    DragCopyCursor           : Qt = ... # 0x13
    TextEditorInteraction    : Qt = ... # 0x13
    transparent              : Qt = ... # 0x13
    AA_EnableHighDpiScaling  : Qt = ... # 0x14
    DragMoveCursor           : Qt = ... # 0x14
    AA_DisableHighDpiScaling : Qt = ... # 0x15
    DragLinkCursor           : Qt = ... # 0x15
    LastCursor               : Qt = ... # 0x15
    AA_UseStyleSheetPropagationInWidgetStyles: Qt = ... # 0x16
    AA_DontUseNativeDialogs  : Qt = ... # 0x17
    AA_SynthesizeMouseForUnhandledTabletEvents: Qt = ... # 0x18
    BitmapCursor             : Qt = ... # 0x18
    TexturePattern           : Qt = ... # 0x18
    AA_CompressHighFrequencyEvents: Qt = ... # 0x19
    CustomCursor             : Qt = ... # 0x19
    AA_DontCheckOpenGLContextThreadAffinity: Qt = ... # 0x1a
    AA_DisableShaderDiskCache: Qt = ... # 0x1b
    DisplayPropertyRole      : Qt = ... # 0x1b
    AA_DontShowShortcutsInContextMenus: Qt = ... # 0x1c
    DecorationPropertyRole   : Qt = ... # 0x1c
    AA_CompressTabletEvents  : Qt = ... # 0x1d
    ToolTipPropertyRole      : Qt = ... # 0x1d
    StatusTipPropertyRole    : Qt = ... # 0x1e
    AA_DisableSessionManager : Qt = ... # 0x1f
    AlignHorizontal_Mask     : Qt = ... # 0x1f
    WhatsThisPropertyRole    : Qt = ... # 0x1f
    AA_AttributeCount        : Qt = ... # 0x20
    AlignTop                 : Qt = ... # 0x20
    ExtraButton3             : Qt = ... # 0x20
    ImCurrentSelection       : Qt = ... # 0x20
    ImhPreferLowercase       : Qt = ... # 0x20
    ItemIsEnabled            : Qt = ... # 0x20
    Key_Any                  : Qt = ... # 0x20
    Key_Space                : Qt = ... # 0x20
    MatchWrap                : Qt = ... # 0x20
    RoundCap                 : Qt = ... # 0x20
    TaskButton               : Qt = ... # 0x20
    ThresholdDither          : Qt = ... # 0x20
    WA_ForceDisabled         : Qt = ... # 0x20
    ForeignWindow            : Qt = ... # 0x21
    Key_Exclam               : Qt = ... # 0x21
    WA_KeyCompression        : Qt = ... # 0x21
    Key_QuoteDbl             : Qt = ... # 0x22
    WA_PendingMoveEvent      : Qt = ... # 0x22
    Key_NumberSign           : Qt = ... # 0x23
    WA_PendingResizeEvent    : Qt = ... # 0x23
    Key_Dollar               : Qt = ... # 0x24
    WA_SetPalette            : Qt = ... # 0x24
    Key_Percent              : Qt = ... # 0x25
    WA_SetFont               : Qt = ... # 0x25
    Key_Ampersand            : Qt = ... # 0x26
    WA_SetCursor             : Qt = ... # 0x26
    Key_Apostrophe           : Qt = ... # 0x27
    WA_NoChildEventsFromChildren: Qt = ... # 0x27
    Key_ParenLeft            : Qt = ... # 0x28
    Key_ParenRight           : Qt = ... # 0x29
    WA_WindowModified        : Qt = ... # 0x29
    Key_Asterisk             : Qt = ... # 0x2a
    WA_Resized               : Qt = ... # 0x2a
    Key_Plus                 : Qt = ... # 0x2b
    WA_Moved                 : Qt = ... # 0x2b
    Key_Comma                : Qt = ... # 0x2c
    WA_PendingUpdate         : Qt = ... # 0x2c
    Key_Minus                : Qt = ... # 0x2d
    WA_InvalidSize           : Qt = ... # 0x2d
    Key_Period               : Qt = ... # 0x2e
    Key_Slash                : Qt = ... # 0x2f
    WA_CustomWhatsThis       : Qt = ... # 0x2f
    Dither_Mask              : Qt = ... # 0x30
    Key_0                    : Qt = ... # 0x30
    MPenCapStyle             : Qt = ... # 0x30
    WA_LayoutOnEntireRect    : Qt = ... # 0x30
    Key_1                    : Qt = ... # 0x31
    WA_OutsideWSRange        : Qt = ... # 0x31
    Key_2                    : Qt = ... # 0x32
    WA_GrabbedShortcut       : Qt = ... # 0x32
    Key_3                    : Qt = ... # 0x33
    WA_TransparentForMouseEvents: Qt = ... # 0x33
    Key_4                    : Qt = ... # 0x34
    WA_PaintUnclipped        : Qt = ... # 0x34
    Key_5                    : Qt = ... # 0x35
    WA_SetWindowIcon         : Qt = ... # 0x35
    Key_6                    : Qt = ... # 0x36
    WA_NoMouseReplay         : Qt = ... # 0x36
    Key_7                    : Qt = ... # 0x37
    WA_DeleteOnClose         : Qt = ... # 0x37
    Key_8                    : Qt = ... # 0x38
    WA_RightToLeft           : Qt = ... # 0x38
    Key_9                    : Qt = ... # 0x39
    WA_SetLayoutDirection    : Qt = ... # 0x39
    Key_Colon                : Qt = ... # 0x3a
    WA_NoChildEventsForParent: Qt = ... # 0x3a
    Key_Semicolon            : Qt = ... # 0x3b
    WA_ForceUpdatesDisabled  : Qt = ... # 0x3b
    Key_Less                 : Qt = ... # 0x3c
    WA_WState_Created        : Qt = ... # 0x3c
    Key_Equal                : Qt = ... # 0x3d
    WA_WState_CompressKeys   : Qt = ... # 0x3d
    Key_Greater              : Qt = ... # 0x3e
    WA_WState_InPaintEvent   : Qt = ... # 0x3e
    Key_Question             : Qt = ... # 0x3f
    WA_WState_Reparented     : Qt = ... # 0x3f
    AlignBottom              : Qt = ... # 0x40
    BevelJoin                : Qt = ... # 0x40
    ExtraButton4             : Qt = ... # 0x40
    ImMaximumTextLength      : Qt = ... # 0x40
    ImhNoPredictiveText      : Qt = ... # 0x40
    ItemIsAutoTristate       : Qt = ... # 0x40
    Key_At                   : Qt = ... # 0x40
    MatchRecursive           : Qt = ... # 0x40
    PreferDither             : Qt = ... # 0x40
    WA_WState_ConfigPending  : Qt = ... # 0x40
    CoverWindow              : Qt = ... # 0x41
    Key_A                    : Qt = ... # 0x41
    Key_B                    : Qt = ... # 0x42
    WA_WState_Polished       : Qt = ... # 0x42
    Key_C                    : Qt = ... # 0x43
    Key_D                    : Qt = ... # 0x44
    WA_WState_OwnSizePolicy  : Qt = ... # 0x44
    Key_E                    : Qt = ... # 0x45
    WA_WState_ExplicitShowHide: Qt = ... # 0x45
    Key_F                    : Qt = ... # 0x46
    WA_ShowModal             : Qt = ... # 0x46
    Key_G                    : Qt = ... # 0x47
    WA_MouseNoMask           : Qt = ... # 0x47
    Key_H                    : Qt = ... # 0x48
    Key_I                    : Qt = ... # 0x49
    WA_NoMousePropagation    : Qt = ... # 0x49
    Key_J                    : Qt = ... # 0x4a
    WA_Hover                 : Qt = ... # 0x4a
    Key_K                    : Qt = ... # 0x4b
    WA_InputMethodTransparent: Qt = ... # 0x4b
    Key_L                    : Qt = ... # 0x4c
    WA_QuitOnClose           : Qt = ... # 0x4c
    Key_M                    : Qt = ... # 0x4d
    WA_KeyboardFocusChange   : Qt = ... # 0x4d
    Key_N                    : Qt = ... # 0x4e
    WA_AcceptDrops           : Qt = ... # 0x4e
    Key_O                    : Qt = ... # 0x4f
    WA_DropSiteRegistered    : Qt = ... # 0x4f
    Key_P                    : Qt = ... # 0x50
    WA_WindowPropagation     : Qt = ... # 0x50
    Key_Q                    : Qt = ... # 0x51
    WA_NoX11EventCompression : Qt = ... # 0x51
    Key_R                    : Qt = ... # 0x52
    WA_TintedBackground      : Qt = ... # 0x52
    Key_S                    : Qt = ... # 0x53
    WA_X11OpenGLOverlay      : Qt = ... # 0x53
    Key_T                    : Qt = ... # 0x54
    WA_AlwaysShowToolTips    : Qt = ... # 0x54
    Key_U                    : Qt = ... # 0x55
    WA_MacOpaqueSizeGrip     : Qt = ... # 0x55
    Key_V                    : Qt = ... # 0x56
    WA_SetStyle              : Qt = ... # 0x56
    Key_W                    : Qt = ... # 0x57
    WA_SetLocale             : Qt = ... # 0x57
    Key_X                    : Qt = ... # 0x58
    WA_MacShowFocusRect      : Qt = ... # 0x58
    Key_Y                    : Qt = ... # 0x59
    WA_MacNormalSize         : Qt = ... # 0x59
    Key_Z                    : Qt = ... # 0x5a
    WA_MacSmallSize          : Qt = ... # 0x5a
    Key_BracketLeft          : Qt = ... # 0x5b
    WA_MacMiniSize           : Qt = ... # 0x5b
    Key_Backslash            : Qt = ... # 0x5c
    WA_LayoutUsesWidgetRect  : Qt = ... # 0x5c
    Key_BracketRight         : Qt = ... # 0x5d
    WA_StyledBackground      : Qt = ... # 0x5d
    Key_AsciiCircum          : Qt = ... # 0x5e
    Key_Underscore           : Qt = ... # 0x5f
    WA_CanHostQMdiSubWindowTitleBar: Qt = ... # 0x5f
    Key_QuoteLeft            : Qt = ... # 0x60
    WA_MacAlwaysShowToolWindow: Qt = ... # 0x60
    WA_StyleSheet            : Qt = ... # 0x61
    WA_ShowWithoutActivating : Qt = ... # 0x62
    WA_X11BypassTransientForHint: Qt = ... # 0x63
    WA_NativeWindow          : Qt = ... # 0x64
    WA_DontCreateNativeAncestors: Qt = ... # 0x65
    WA_DontShowOnScreen      : Qt = ... # 0x67
    WA_X11NetWmWindowTypeDesktop: Qt = ... # 0x68
    WA_X11NetWmWindowTypeDock: Qt = ... # 0x69
    WA_X11NetWmWindowTypeToolBar: Qt = ... # 0x6a
    WA_X11NetWmWindowTypeMenu: Qt = ... # 0x6b
    WA_X11NetWmWindowTypeUtility: Qt = ... # 0x6c
    WA_X11NetWmWindowTypeSplash: Qt = ... # 0x6d
    WA_X11NetWmWindowTypeDialog: Qt = ... # 0x6e
    WA_X11NetWmWindowTypeDropDownMenu: Qt = ... # 0x6f
    WA_X11NetWmWindowTypePopupMenu: Qt = ... # 0x70
    WA_X11NetWmWindowTypeToolTip: Qt = ... # 0x71
    WA_X11NetWmWindowTypeNotification: Qt = ... # 0x72
    WA_X11NetWmWindowTypeCombo: Qt = ... # 0x73
    WA_X11NetWmWindowTypeDND : Qt = ... # 0x74
    WA_SetWindowModality     : Qt = ... # 0x76
    WA_WState_WindowOpacitySet: Qt = ... # 0x77
    WA_TranslucentBackground : Qt = ... # 0x78
    WA_AcceptTouchEvents     : Qt = ... # 0x79
    WA_WState_AcceptedTouchBeginEvent: Qt = ... # 0x7a
    Key_BraceLeft            : Qt = ... # 0x7b
    WA_TouchPadAcceptSingleTouchEvents: Qt = ... # 0x7b
    Key_Bar                  : Qt = ... # 0x7c
    Key_BraceRight           : Qt = ... # 0x7d
    Key_AsciiTilde           : Qt = ... # 0x7e
    WA_X11DoNotAcceptFocus   : Qt = ... # 0x7e
    AlignVCenter             : Qt = ... # 0x80
    AvoidDither              : Qt = ... # 0x80
    ExtraButton5             : Qt = ... # 0x80
    ImAnchorPosition         : Qt = ... # 0x80
    ImhDate                  : Qt = ... # 0x80
    ItemNeverHasChildren     : Qt = ... # 0x80
    RoundJoin                : Qt = ... # 0x80
    UniqueConnection         : Qt = ... # 0x80
    WA_AlwaysStackOnTop      : Qt = ... # 0x80
    WA_TabletTracking        : Qt = ... # 0x81
    WA_ContentsMarginsRespectsSafeArea: Qt = ... # 0x82
    WA_StyleSheetTarget      : Qt = ... # 0x83
    AlignCenter              : Qt = ... # 0x84
    WA_AttributeCount        : Qt = ... # 0x84
    Key_nobreakspace         : Qt = ... # 0xa0
    Key_exclamdown           : Qt = ... # 0xa1
    Key_cent                 : Qt = ... # 0xa2
    Key_sterling             : Qt = ... # 0xa3
    Key_currency             : Qt = ... # 0xa4
    Key_yen                  : Qt = ... # 0xa5
    Key_brokenbar            : Qt = ... # 0xa6
    Key_section              : Qt = ... # 0xa7
    Key_diaeresis            : Qt = ... # 0xa8
    Key_copyright            : Qt = ... # 0xa9
    Key_ordfeminine          : Qt = ... # 0xaa
    Key_guillemotleft        : Qt = ... # 0xab
    Key_notsign              : Qt = ... # 0xac
    Key_hyphen               : Qt = ... # 0xad
    Key_registered           : Qt = ... # 0xae
    Key_macron               : Qt = ... # 0xaf
    Key_degree               : Qt = ... # 0xb0
    Key_plusminus            : Qt = ... # 0xb1
    Key_twosuperior          : Qt = ... # 0xb2
    Key_threesuperior        : Qt = ... # 0xb3
    Key_acute                : Qt = ... # 0xb4
    Key_mu                   : Qt = ... # 0xb5
    Key_paragraph            : Qt = ... # 0xb6
    Key_periodcentered       : Qt = ... # 0xb7
    Key_cedilla              : Qt = ... # 0xb8
    Key_onesuperior          : Qt = ... # 0xb9
    Key_masculine            : Qt = ... # 0xba
    Key_guillemotright       : Qt = ... # 0xbb
    Key_onequarter           : Qt = ... # 0xbc
    Key_onehalf              : Qt = ... # 0xbd
    Key_threequarters        : Qt = ... # 0xbe
    Key_questiondown         : Qt = ... # 0xbf
    DitherMode_Mask          : Qt = ... # 0xc0
    Key_Agrave               : Qt = ... # 0xc0
    Key_Aacute               : Qt = ... # 0xc1
    Key_Acircumflex          : Qt = ... # 0xc2
    Key_Atilde               : Qt = ... # 0xc3
    Key_Adiaeresis           : Qt = ... # 0xc4
    Key_Aring                : Qt = ... # 0xc5
    Key_AE                   : Qt = ... # 0xc6
    Key_Ccedilla             : Qt = ... # 0xc7
    Key_Egrave               : Qt = ... # 0xc8
    Key_Eacute               : Qt = ... # 0xc9
    Key_Ecircumflex          : Qt = ... # 0xca
    Key_Ediaeresis           : Qt = ... # 0xcb
    Key_Igrave               : Qt = ... # 0xcc
    Key_Iacute               : Qt = ... # 0xcd
    Key_Icircumflex          : Qt = ... # 0xce
    Key_Idiaeresis           : Qt = ... # 0xcf
    Key_ETH                  : Qt = ... # 0xd0
    Key_Ntilde               : Qt = ... # 0xd1
    Key_Ograve               : Qt = ... # 0xd2
    Key_Oacute               : Qt = ... # 0xd3
    Key_Ocircumflex          : Qt = ... # 0xd4
    Key_Otilde               : Qt = ... # 0xd5
    Key_Odiaeresis           : Qt = ... # 0xd6
    Key_multiply             : Qt = ... # 0xd7
    Key_Ooblique             : Qt = ... # 0xd8
    Key_Ugrave               : Qt = ... # 0xd9
    Key_Uacute               : Qt = ... # 0xda
    Key_Ucircumflex          : Qt = ... # 0xdb
    Key_Udiaeresis           : Qt = ... # 0xdc
    Key_Yacute               : Qt = ... # 0xdd
    Key_THORN                : Qt = ... # 0xde
    Key_ssharp               : Qt = ... # 0xdf
    Key_division             : Qt = ... # 0xf7
    ActionMask               : Qt = ... # 0xff
    Key_ydiaeresis           : Qt = ... # 0xff
    MouseEventFlagMask       : Qt = ... # 0xff
    TabFocusAllControls      : Qt = ... # 0xff
    WindowType_Mask          : Qt = ... # 0xff
    AlignBaseline            : Qt = ... # 0x100
    CustomGesture            : Qt = ... # 0x100
    ExtraButton6             : Qt = ... # 0x100
    ImHints                  : Qt = ... # 0x100
    ImhTime                  : Qt = ... # 0x100
    ItemIsUserTristate       : Qt = ... # 0x100
    MSWindowsFixedSizeDialogHint: Qt = ... # 0x100
    NoOpaqueDetection        : Qt = ... # 0x100
    SingleShotConnection     : Qt = ... # 0x100
    SvgMiterJoin             : Qt = ... # 0x100
    TextSingleLine           : Qt = ... # 0x100
    UserRole                 : Qt = ... # 0x100
    MPenJoinStyle            : Qt = ... # 0x1c0
    AlignVertical_Mask       : Qt = ... # 0x1e0
    ExtraButton7             : Qt = ... # 0x200
    ImPreferredLanguage      : Qt = ... # 0x200
    ImhPreferLatin           : Qt = ... # 0x200
    MSWindowsOwnDC           : Qt = ... # 0x200
    NoFormatConversion       : Qt = ... # 0x200
    TextDontClip             : Qt = ... # 0x200
    BypassWindowManagerHint  : Qt = ... # 0x400
    ExtraButton8             : Qt = ... # 0x400
    ImAbsolutePosition       : Qt = ... # 0x400
    ImhMultiLine             : Qt = ... # 0x400
    TextExpandTabs           : Qt = ... # 0x400
    X11BypassWindowManagerHint: Qt = ... # 0x400
    ExtraButton9             : Qt = ... # 0x800
    FramelessWindowHint      : Qt = ... # 0x800
    ImTextBeforeCursor       : Qt = ... # 0x800
    ImhNoEditMenu            : Qt = ... # 0x800
    TextShowMnemonic         : Qt = ... # 0x800
    ExtraButton10            : Qt = ... # 0x1000
    ImTextAfterCursor        : Qt = ... # 0x1000
    ImhNoTextHandles         : Qt = ... # 0x1000
    TextWordWrap             : Qt = ... # 0x1000
    WindowTitleHint          : Qt = ... # 0x1000
    ExtraButton11            : Qt = ... # 0x2000
    ImEnterKeyType           : Qt = ... # 0x2000
    TextWrapAnywhere         : Qt = ... # 0x2000
    WindowSystemMenuHint     : Qt = ... # 0x2000
    ExtraButton12            : Qt = ... # 0x4000
    ImAnchorRectangle        : Qt = ... # 0x4000
    TextDontPrint            : Qt = ... # 0x4000
    WindowMinimizeButtonHint : Qt = ... # 0x4000
    ImQueryInput             : Qt = ... # 0x40ba
    ExtraButton13            : Qt = ... # 0x8000
    ImInputItemClipRectangle : Qt = ... # 0x8000
    TextHideMnemonic         : Qt = ... # 0x8000
    WindowMaximizeButtonHint : Qt = ... # 0x8000
    TargetMoveAction         : Qt = ... # 0x8002
    WindowMinMaxButtonsHint  : Qt = ... # 0xc000
    ExtraButton14            : Qt = ... # 0x10000
    ImhDigitsOnly            : Qt = ... # 0x10000
    TextJustificationForced  : Qt = ... # 0x10000
    WindowContextHelpButtonHint: Qt = ... # 0x10000
    ExtraButton15            : Qt = ... # 0x20000
    ImhFormattedNumbersOnly  : Qt = ... # 0x20000
    TextForceLeftToRight     : Qt = ... # 0x20000
    WindowShadeButtonHint    : Qt = ... # 0x20000
    ExtraButton16            : Qt = ... # 0x40000
    ImhUppercaseOnly         : Qt = ... # 0x40000
    TextForceRightToLeft     : Qt = ... # 0x40000
    WindowStaysOnTopHint     : Qt = ... # 0x40000
    ExtraButton17            : Qt = ... # 0x80000
    ImhLowercaseOnly         : Qt = ... # 0x80000
    TextLongestVariant       : Qt = ... # 0x80000
    WindowTransparentForInput: Qt = ... # 0x80000
    ExtraButton18            : Qt = ... # 0x100000
    ImhDialableCharactersOnly: Qt = ... # 0x100000
    WindowOverridesSystemGestures: Qt = ... # 0x100000
    ExtraButton19            : Qt = ... # 0x200000
    ImhEmailCharactersOnly   : Qt = ... # 0x200000
    WindowDoesNotAcceptFocus : Qt = ... # 0x200000
    ExtraButton20            : Qt = ... # 0x400000
    ImhUrlCharactersOnly     : Qt = ... # 0x400000
    MaximizeUsingFullscreenGeometryHint: Qt = ... # 0x400000
    ExtraButton21            : Qt = ... # 0x800000
    ImhLatinOnly             : Qt = ... # 0x800000
    ExtraButton22            : Qt = ... # 0x1000000
    Key_Escape               : Qt = ... # 0x1000000
    Key_Tab                  : Qt = ... # 0x1000001
    Key_Backtab              : Qt = ... # 0x1000002
    Key_Backspace            : Qt = ... # 0x1000003
    Key_Return               : Qt = ... # 0x1000004
    Key_Enter                : Qt = ... # 0x1000005
    Key_Insert               : Qt = ... # 0x1000006
    Key_Delete               : Qt = ... # 0x1000007
    Key_Pause                : Qt = ... # 0x1000008
    Key_Print                : Qt = ... # 0x1000009
    Key_SysReq               : Qt = ... # 0x100000a
    Key_Clear                : Qt = ... # 0x100000b
    Key_Home                 : Qt = ... # 0x1000010
    Key_End                  : Qt = ... # 0x1000011
    Key_Left                 : Qt = ... # 0x1000012
    Key_Up                   : Qt = ... # 0x1000013
    Key_Right                : Qt = ... # 0x1000014
    Key_Down                 : Qt = ... # 0x1000015
    Key_PageUp               : Qt = ... # 0x1000016
    Key_PageDown             : Qt = ... # 0x1000017
    Key_Shift                : Qt = ... # 0x1000020
    Key_Control              : Qt = ... # 0x1000021
    Key_Meta                 : Qt = ... # 0x1000022
    Key_Alt                  : Qt = ... # 0x1000023
    Key_CapsLock             : Qt = ... # 0x1000024
    Key_NumLock              : Qt = ... # 0x1000025
    Key_ScrollLock           : Qt = ... # 0x1000026
    Key_F1                   : Qt = ... # 0x1000030
    Key_F2                   : Qt = ... # 0x1000031
    Key_F3                   : Qt = ... # 0x1000032
    Key_F4                   : Qt = ... # 0x1000033
    Key_F5                   : Qt = ... # 0x1000034
    Key_F6                   : Qt = ... # 0x1000035
    Key_F7                   : Qt = ... # 0x1000036
    Key_F8                   : Qt = ... # 0x1000037
    Key_F9                   : Qt = ... # 0x1000038
    Key_F10                  : Qt = ... # 0x1000039
    Key_F11                  : Qt = ... # 0x100003a
    Key_F12                  : Qt = ... # 0x100003b
    Key_F13                  : Qt = ... # 0x100003c
    Key_F14                  : Qt = ... # 0x100003d
    Key_F15                  : Qt = ... # 0x100003e
    Key_F16                  : Qt = ... # 0x100003f
    Key_F17                  : Qt = ... # 0x1000040
    Key_F18                  : Qt = ... # 0x1000041
    Key_F19                  : Qt = ... # 0x1000042
    Key_F20                  : Qt = ... # 0x1000043
    Key_F21                  : Qt = ... # 0x1000044
    Key_F22                  : Qt = ... # 0x1000045
    Key_F23                  : Qt = ... # 0x1000046
    Key_F24                  : Qt = ... # 0x1000047
    Key_F25                  : Qt = ... # 0x1000048
    Key_F26                  : Qt = ... # 0x1000049
    Key_F27                  : Qt = ... # 0x100004a
    Key_F28                  : Qt = ... # 0x100004b
    Key_F29                  : Qt = ... # 0x100004c
    Key_F30                  : Qt = ... # 0x100004d
    Key_F31                  : Qt = ... # 0x100004e
    Key_F32                  : Qt = ... # 0x100004f
    Key_F33                  : Qt = ... # 0x1000050
    Key_F34                  : Qt = ... # 0x1000051
    Key_F35                  : Qt = ... # 0x1000052
    Key_Super_L              : Qt = ... # 0x1000053
    Key_Super_R              : Qt = ... # 0x1000054
    Key_Menu                 : Qt = ... # 0x1000055
    Key_Hyper_L              : Qt = ... # 0x1000056
    Key_Hyper_R              : Qt = ... # 0x1000057
    Key_Help                 : Qt = ... # 0x1000058
    Key_Direction_L          : Qt = ... # 0x1000059
    Key_Direction_R          : Qt = ... # 0x1000060
    Key_Back                 : Qt = ... # 0x1000061
    Key_Forward              : Qt = ... # 0x1000062
    Key_Stop                 : Qt = ... # 0x1000063
    Key_Refresh              : Qt = ... # 0x1000064
    Key_VolumeDown           : Qt = ... # 0x1000070
    Key_VolumeMute           : Qt = ... # 0x1000071
    Key_VolumeUp             : Qt = ... # 0x1000072
    Key_BassBoost            : Qt = ... # 0x1000073
    Key_BassUp               : Qt = ... # 0x1000074
    Key_BassDown             : Qt = ... # 0x1000075
    Key_TrebleUp             : Qt = ... # 0x1000076
    Key_TrebleDown           : Qt = ... # 0x1000077
    Key_MediaPlay            : Qt = ... # 0x1000080
    Key_MediaStop            : Qt = ... # 0x1000081
    Key_MediaPrevious        : Qt = ... # 0x1000082
    Key_MediaNext            : Qt = ... # 0x1000083
    Key_MediaRecord          : Qt = ... # 0x1000084
    Key_MediaPause           : Qt = ... # 0x1000085
    Key_MediaTogglePlayPause : Qt = ... # 0x1000086
    Key_HomePage             : Qt = ... # 0x1000090
    Key_Favorites            : Qt = ... # 0x1000091
    Key_Search               : Qt = ... # 0x1000092
    Key_Standby              : Qt = ... # 0x1000093
    Key_OpenUrl              : Qt = ... # 0x1000094
    Key_LaunchMail           : Qt = ... # 0x10000a0
    Key_LaunchMedia          : Qt = ... # 0x10000a1
    Key_Launch0              : Qt = ... # 0x10000a2
    Key_Launch1              : Qt = ... # 0x10000a3
    Key_Launch2              : Qt = ... # 0x10000a4
    Key_Launch3              : Qt = ... # 0x10000a5
    Key_Launch4              : Qt = ... # 0x10000a6
    Key_Launch5              : Qt = ... # 0x10000a7
    Key_Launch6              : Qt = ... # 0x10000a8
    Key_Launch7              : Qt = ... # 0x10000a9
    Key_Launch8              : Qt = ... # 0x10000aa
    Key_Launch9              : Qt = ... # 0x10000ab
    Key_LaunchA              : Qt = ... # 0x10000ac
    Key_LaunchB              : Qt = ... # 0x10000ad
    Key_LaunchC              : Qt = ... # 0x10000ae
    Key_LaunchD              : Qt = ... # 0x10000af
    Key_LaunchE              : Qt = ... # 0x10000b0
    Key_LaunchF              : Qt = ... # 0x10000b1
    Key_MonBrightnessUp      : Qt = ... # 0x10000b2
    Key_MonBrightnessDown    : Qt = ... # 0x10000b3
    Key_KeyboardLightOnOff   : Qt = ... # 0x10000b4
    Key_KeyboardBrightnessUp : Qt = ... # 0x10000b5
    Key_KeyboardBrightnessDown: Qt = ... # 0x10000b6
    Key_PowerOff             : Qt = ... # 0x10000b7
    Key_WakeUp               : Qt = ... # 0x10000b8
    Key_Eject                : Qt = ... # 0x10000b9
    Key_ScreenSaver          : Qt = ... # 0x10000ba
    Key_WWW                  : Qt = ... # 0x10000bb
    Key_Memo                 : Qt = ... # 0x10000bc
    Key_LightBulb            : Qt = ... # 0x10000bd
    Key_Shop                 : Qt = ... # 0x10000be
    Key_History              : Qt = ... # 0x10000bf
    Key_AddFavorite          : Qt = ... # 0x10000c0
    Key_HotLinks             : Qt = ... # 0x10000c1
    Key_BrightnessAdjust     : Qt = ... # 0x10000c2
    Key_Finance              : Qt = ... # 0x10000c3
    Key_Community            : Qt = ... # 0x10000c4
    Key_AudioRewind          : Qt = ... # 0x10000c5
    Key_BackForward          : Qt = ... # 0x10000c6
    Key_ApplicationLeft      : Qt = ... # 0x10000c7
    Key_ApplicationRight     : Qt = ... # 0x10000c8
    Key_Book                 : Qt = ... # 0x10000c9
    Key_CD                   : Qt = ... # 0x10000ca
    Key_Calculator           : Qt = ... # 0x10000cb
    Key_ToDoList             : Qt = ... # 0x10000cc
    Key_ClearGrab            : Qt = ... # 0x10000cd
    Key_Close                : Qt = ... # 0x10000ce
    Key_Copy                 : Qt = ... # 0x10000cf
    Key_Cut                  : Qt = ... # 0x10000d0
    Key_Display              : Qt = ... # 0x10000d1
    Key_DOS                  : Qt = ... # 0x10000d2
    Key_Documents            : Qt = ... # 0x10000d3
    Key_Excel                : Qt = ... # 0x10000d4
    Key_Explorer             : Qt = ... # 0x10000d5
    Key_Game                 : Qt = ... # 0x10000d6
    Key_Go                   : Qt = ... # 0x10000d7
    Key_iTouch               : Qt = ... # 0x10000d8
    Key_LogOff               : Qt = ... # 0x10000d9
    Key_Market               : Qt = ... # 0x10000da
    Key_Meeting              : Qt = ... # 0x10000db
    Key_MenuKB               : Qt = ... # 0x10000dc
    Key_MenuPB               : Qt = ... # 0x10000dd
    Key_MySites              : Qt = ... # 0x10000de
    Key_News                 : Qt = ... # 0x10000df
    Key_OfficeHome           : Qt = ... # 0x10000e0
    Key_Option               : Qt = ... # 0x10000e1
    Key_Paste                : Qt = ... # 0x10000e2
    Key_Phone                : Qt = ... # 0x10000e3
    Key_Calendar             : Qt = ... # 0x10000e4
    Key_Reply                : Qt = ... # 0x10000e5
    Key_Reload               : Qt = ... # 0x10000e6
    Key_RotateWindows        : Qt = ... # 0x10000e7
    Key_RotationPB           : Qt = ... # 0x10000e8
    Key_RotationKB           : Qt = ... # 0x10000e9
    Key_Save                 : Qt = ... # 0x10000ea
    Key_Send                 : Qt = ... # 0x10000eb
    Key_Spell                : Qt = ... # 0x10000ec
    Key_SplitScreen          : Qt = ... # 0x10000ed
    Key_Support              : Qt = ... # 0x10000ee
    Key_TaskPane             : Qt = ... # 0x10000ef
    Key_Terminal             : Qt = ... # 0x10000f0
    Key_Tools                : Qt = ... # 0x10000f1
    Key_Travel               : Qt = ... # 0x10000f2
    Key_Video                : Qt = ... # 0x10000f3
    Key_Word                 : Qt = ... # 0x10000f4
    Key_Xfer                 : Qt = ... # 0x10000f5
    Key_ZoomIn               : Qt = ... # 0x10000f6
    Key_ZoomOut              : Qt = ... # 0x10000f7
    Key_Away                 : Qt = ... # 0x10000f8
    Key_Messenger            : Qt = ... # 0x10000f9
    Key_WebCam               : Qt = ... # 0x10000fa
    Key_MailForward          : Qt = ... # 0x10000fb
    Key_Pictures             : Qt = ... # 0x10000fc
    Key_Music                : Qt = ... # 0x10000fd
    Key_Battery              : Qt = ... # 0x10000fe
    Key_Bluetooth            : Qt = ... # 0x10000ff
    Key_WLAN                 : Qt = ... # 0x1000100
    Key_UWB                  : Qt = ... # 0x1000101
    Key_AudioForward         : Qt = ... # 0x1000102
    Key_AudioRepeat          : Qt = ... # 0x1000103
    Key_AudioRandomPlay      : Qt = ... # 0x1000104
    Key_Subtitle             : Qt = ... # 0x1000105
    Key_AudioCycleTrack      : Qt = ... # 0x1000106
    Key_Time                 : Qt = ... # 0x1000107
    Key_Hibernate            : Qt = ... # 0x1000108
    Key_View                 : Qt = ... # 0x1000109
    Key_TopMenu              : Qt = ... # 0x100010a
    Key_PowerDown            : Qt = ... # 0x100010b
    Key_Suspend              : Qt = ... # 0x100010c
    Key_ContrastAdjust       : Qt = ... # 0x100010d
    Key_LaunchG              : Qt = ... # 0x100010e
    Key_LaunchH              : Qt = ... # 0x100010f
    Key_TouchpadToggle       : Qt = ... # 0x1000110
    Key_TouchpadOn           : Qt = ... # 0x1000111
    Key_TouchpadOff          : Qt = ... # 0x1000112
    Key_MicMute              : Qt = ... # 0x1000113
    Key_Red                  : Qt = ... # 0x1000114
    Key_Green                : Qt = ... # 0x1000115
    Key_Yellow               : Qt = ... # 0x1000116
    Key_Blue                 : Qt = ... # 0x1000117
    Key_ChannelUp            : Qt = ... # 0x1000118
    Key_ChannelDown          : Qt = ... # 0x1000119
    Key_Guide                : Qt = ... # 0x100011a
    Key_Info                 : Qt = ... # 0x100011b
    Key_Settings             : Qt = ... # 0x100011c
    Key_MicVolumeUp          : Qt = ... # 0x100011d
    Key_MicVolumeDown        : Qt = ... # 0x100011e
    Key_New                  : Qt = ... # 0x1000120
    Key_Open                 : Qt = ... # 0x1000121
    Key_Find                 : Qt = ... # 0x1000122
    Key_Undo                 : Qt = ... # 0x1000123
    Key_Redo                 : Qt = ... # 0x1000124
    Key_AltGr                : Qt = ... # 0x1001103
    Key_Multi_key            : Qt = ... # 0x1001120
    Key_Kanji                : Qt = ... # 0x1001121
    Key_Muhenkan             : Qt = ... # 0x1001122
    Key_Henkan               : Qt = ... # 0x1001123
    Key_Romaji               : Qt = ... # 0x1001124
    Key_Hiragana             : Qt = ... # 0x1001125
    Key_Katakana             : Qt = ... # 0x1001126
    Key_Hiragana_Katakana    : Qt = ... # 0x1001127
    Key_Zenkaku              : Qt = ... # 0x1001128
    Key_Hankaku              : Qt = ... # 0x1001129
    Key_Zenkaku_Hankaku      : Qt = ... # 0x100112a
    Key_Touroku              : Qt = ... # 0x100112b
    Key_Massyo               : Qt = ... # 0x100112c
    Key_Kana_Lock            : Qt = ... # 0x100112d
    Key_Kana_Shift           : Qt = ... # 0x100112e
    Key_Eisu_Shift           : Qt = ... # 0x100112f
    Key_Eisu_toggle          : Qt = ... # 0x1001130
    Key_Hangul               : Qt = ... # 0x1001131
    Key_Hangul_Start         : Qt = ... # 0x1001132
    Key_Hangul_End           : Qt = ... # 0x1001133
    Key_Hangul_Hanja         : Qt = ... # 0x1001134
    Key_Hangul_Jamo          : Qt = ... # 0x1001135
    Key_Hangul_Romaja        : Qt = ... # 0x1001136
    Key_Codeinput            : Qt = ... # 0x1001137
    Key_Hangul_Jeonja        : Qt = ... # 0x1001138
    Key_Hangul_Banja         : Qt = ... # 0x1001139
    Key_Hangul_PreHanja      : Qt = ... # 0x100113a
    Key_Hangul_PostHanja     : Qt = ... # 0x100113b
    Key_SingleCandidate      : Qt = ... # 0x100113c
    Key_MultipleCandidate    : Qt = ... # 0x100113d
    Key_PreviousCandidate    : Qt = ... # 0x100113e
    Key_Hangul_Special       : Qt = ... # 0x100113f
    Key_Mode_switch          : Qt = ... # 0x100117e
    Key_Dead_Grave           : Qt = ... # 0x1001250
    Key_Dead_Acute           : Qt = ... # 0x1001251
    Key_Dead_Circumflex      : Qt = ... # 0x1001252
    Key_Dead_Tilde           : Qt = ... # 0x1001253
    Key_Dead_Macron          : Qt = ... # 0x1001254
    Key_Dead_Breve           : Qt = ... # 0x1001255
    Key_Dead_Abovedot        : Qt = ... # 0x1001256
    Key_Dead_Diaeresis       : Qt = ... # 0x1001257
    Key_Dead_Abovering       : Qt = ... # 0x1001258
    Key_Dead_Doubleacute     : Qt = ... # 0x1001259
    Key_Dead_Caron           : Qt = ... # 0x100125a
    Key_Dead_Cedilla         : Qt = ... # 0x100125b
    Key_Dead_Ogonek          : Qt = ... # 0x100125c
    Key_Dead_Iota            : Qt = ... # 0x100125d
    Key_Dead_Voiced_Sound    : Qt = ... # 0x100125e
    Key_Dead_Semivoiced_Sound: Qt = ... # 0x100125f
    Key_Dead_Belowdot        : Qt = ... # 0x1001260
    Key_Dead_Hook            : Qt = ... # 0x1001261
    Key_Dead_Horn            : Qt = ... # 0x1001262
    Key_Dead_Stroke          : Qt = ... # 0x1001263
    Key_Dead_Abovecomma      : Qt = ... # 0x1001264
    Key_Dead_Abovereversedcomma: Qt = ... # 0x1001265
    Key_Dead_Doublegrave     : Qt = ... # 0x1001266
    Key_Dead_Belowring       : Qt = ... # 0x1001267
    Key_Dead_Belowmacron     : Qt = ... # 0x1001268
    Key_Dead_Belowcircumflex : Qt = ... # 0x1001269
    Key_Dead_Belowtilde      : Qt = ... # 0x100126a
    Key_Dead_Belowbreve      : Qt = ... # 0x100126b
    Key_Dead_Belowdiaeresis  : Qt = ... # 0x100126c
    Key_Dead_Invertedbreve   : Qt = ... # 0x100126d
    Key_Dead_Belowcomma      : Qt = ... # 0x100126e
    Key_Dead_Currency        : Qt = ... # 0x100126f
    Key_Dead_a               : Qt = ... # 0x1001280
    Key_Dead_A               : Qt = ... # 0x1001281
    Key_Dead_e               : Qt = ... # 0x1001282
    Key_Dead_E               : Qt = ... # 0x1001283
    Key_Dead_i               : Qt = ... # 0x1001284
    Key_Dead_I               : Qt = ... # 0x1001285
    Key_Dead_o               : Qt = ... # 0x1001286
    Key_Dead_O               : Qt = ... # 0x1001287
    Key_Dead_u               : Qt = ... # 0x1001288
    Key_Dead_U               : Qt = ... # 0x1001289
    Key_Dead_Small_Schwa     : Qt = ... # 0x100128a
    Key_Dead_Capital_Schwa   : Qt = ... # 0x100128b
    Key_Dead_Greek           : Qt = ... # 0x100128c
    Key_Dead_Lowline         : Qt = ... # 0x1001290
    Key_Dead_Aboveverticalline: Qt = ... # 0x1001291
    Key_Dead_Belowverticalline: Qt = ... # 0x1001292
    Key_Dead_Longsolidusoverlay: Qt = ... # 0x1001293
    Key_MediaLast            : Qt = ... # 0x100ffff
    Key_Select               : Qt = ... # 0x1010000
    Key_Yes                  : Qt = ... # 0x1010001
    Key_No                   : Qt = ... # 0x1010002
    Key_Cancel               : Qt = ... # 0x1020001
    Key_Printer              : Qt = ... # 0x1020002
    Key_Execute              : Qt = ... # 0x1020003
    Key_Sleep                : Qt = ... # 0x1020004
    Key_Play                 : Qt = ... # 0x1020005
    Key_Zoom                 : Qt = ... # 0x1020006
    Key_Exit                 : Qt = ... # 0x102000a
    Key_Context1             : Qt = ... # 0x1100000
    Key_Context2             : Qt = ... # 0x1100001
    Key_Context3             : Qt = ... # 0x1100002
    Key_Context4             : Qt = ... # 0x1100003
    Key_Call                 : Qt = ... # 0x1100004
    Key_Hangup               : Qt = ... # 0x1100005
    Key_Flip                 : Qt = ... # 0x1100006
    Key_ToggleCallHangup     : Qt = ... # 0x1100007
    Key_VoiceDial            : Qt = ... # 0x1100008
    Key_LastNumberRedial     : Qt = ... # 0x1100009
    Key_Camera               : Qt = ... # 0x1100020
    Key_CameraFocus          : Qt = ... # 0x1100021
    Key_unknown              : Qt = ... # 0x1ffffff
    CustomizeWindowHint      : Qt = ... # 0x2000000
    ExtraButton23            : Qt = ... # 0x2000000
    SHIFT                    : Qt = ... # 0x2000000
    ShiftModifier            : Qt = ... # 0x2000000
    CTRL                     : Qt = ... # 0x4000000
    ControlModifier          : Qt = ... # 0x4000000
    ExtraButton24            : Qt = ... # 0x4000000
    MaxMouseButton           : Qt = ... # 0x4000000
    WindowStaysOnBottomHint  : Qt = ... # 0x4000000
    AllButtons               : Qt = ... # 0x7ffffff
    ALT                      : Qt = ... # 0x8000000
    AltModifier              : Qt = ... # 0x8000000
    TextIncludeTrailingSpaces: Qt = ... # 0x8000000
    WindowCloseButtonHint    : Qt = ... # 0x8000000
    META                     : Qt = ... # 0x10000000
    MacWindowToolBarButtonHint: Qt = ... # 0x10000000
    MetaModifier             : Qt = ... # 0x10000000
    BypassGraphicsProxyWidget: Qt = ... # 0x20000000
    KeypadModifier           : Qt = ... # 0x20000000
    GroupSwitchModifier      : Qt = ... # 0x40000000
    NoDropShadowWindowHint   : Qt = ... # 0x40000000

    class Alignment(object): ...

    class AlignmentFlag(object):
        AlignLeading             : Qt.AlignmentFlag = ... # 0x1
        AlignLeft                : Qt.AlignmentFlag = ... # 0x1
        AlignRight               : Qt.AlignmentFlag = ... # 0x2
        AlignTrailing            : Qt.AlignmentFlag = ... # 0x2
        AlignHCenter             : Qt.AlignmentFlag = ... # 0x4
        AlignJustify             : Qt.AlignmentFlag = ... # 0x8
        AlignAbsolute            : Qt.AlignmentFlag = ... # 0x10
        AlignHorizontal_Mask     : Qt.AlignmentFlag = ... # 0x1f
        AlignTop                 : Qt.AlignmentFlag = ... # 0x20
        AlignBottom              : Qt.AlignmentFlag = ... # 0x40
        AlignVCenter             : Qt.AlignmentFlag = ... # 0x80
        AlignCenter              : Qt.AlignmentFlag = ... # 0x84
        AlignBaseline            : Qt.AlignmentFlag = ... # 0x100
        AlignVertical_Mask       : Qt.AlignmentFlag = ... # 0x1e0

    class AnchorPoint(object):
        AnchorLeft               : Qt.AnchorPoint = ... # 0x0
        AnchorHorizontalCenter   : Qt.AnchorPoint = ... # 0x1
        AnchorRight              : Qt.AnchorPoint = ... # 0x2
        AnchorTop                : Qt.AnchorPoint = ... # 0x3
        AnchorVerticalCenter     : Qt.AnchorPoint = ... # 0x4
        AnchorBottom             : Qt.AnchorPoint = ... # 0x5

    class ApplicationAttribute(object):
        AA_DontShowIconsInMenus  : Qt.ApplicationAttribute = ... # 0x2
        AA_NativeWindows         : Qt.ApplicationAttribute = ... # 0x3
        AA_DontCreateNativeWidgetSiblings: Qt.ApplicationAttribute = ... # 0x4
        AA_PluginApplication     : Qt.ApplicationAttribute = ... # 0x5
        AA_DontUseNativeMenuBar  : Qt.ApplicationAttribute = ... # 0x6
        AA_MacDontSwapCtrlAndMeta: Qt.ApplicationAttribute = ... # 0x7
        AA_Use96Dpi              : Qt.ApplicationAttribute = ... # 0x8
        AA_DisableNativeVirtualKeyboard: Qt.ApplicationAttribute = ... # 0x9
        AA_SynthesizeTouchForUnhandledMouseEvents: Qt.ApplicationAttribute = ... # 0xb
        AA_SynthesizeMouseForUnhandledTouchEvents: Qt.ApplicationAttribute = ... # 0xc
        AA_UseHighDpiPixmaps     : Qt.ApplicationAttribute = ... # 0xd
        AA_ForceRasterWidgets    : Qt.ApplicationAttribute = ... # 0xe
        AA_UseDesktopOpenGL      : Qt.ApplicationAttribute = ... # 0xf
        AA_UseOpenGLES           : Qt.ApplicationAttribute = ... # 0x10
        AA_UseSoftwareOpenGL     : Qt.ApplicationAttribute = ... # 0x11
        AA_ShareOpenGLContexts   : Qt.ApplicationAttribute = ... # 0x12
        AA_SetPalette            : Qt.ApplicationAttribute = ... # 0x13
        AA_EnableHighDpiScaling  : Qt.ApplicationAttribute = ... # 0x14
        AA_DisableHighDpiScaling : Qt.ApplicationAttribute = ... # 0x15
        AA_UseStyleSheetPropagationInWidgetStyles: Qt.ApplicationAttribute = ... # 0x16
        AA_DontUseNativeDialogs  : Qt.ApplicationAttribute = ... # 0x17
        AA_SynthesizeMouseForUnhandledTabletEvents: Qt.ApplicationAttribute = ... # 0x18
        AA_CompressHighFrequencyEvents: Qt.ApplicationAttribute = ... # 0x19
        AA_DontCheckOpenGLContextThreadAffinity: Qt.ApplicationAttribute = ... # 0x1a
        AA_DisableShaderDiskCache: Qt.ApplicationAttribute = ... # 0x1b
        AA_DontShowShortcutsInContextMenus: Qt.ApplicationAttribute = ... # 0x1c
        AA_CompressTabletEvents  : Qt.ApplicationAttribute = ... # 0x1d
        AA_DisableSessionManager : Qt.ApplicationAttribute = ... # 0x1f
        AA_AttributeCount        : Qt.ApplicationAttribute = ... # 0x20

    class ApplicationState(object):
        ApplicationSuspended     : Qt.ApplicationState = ... # 0x0
        ApplicationHidden        : Qt.ApplicationState = ... # 0x1
        ApplicationInactive      : Qt.ApplicationState = ... # 0x2
        ApplicationActive        : Qt.ApplicationState = ... # 0x4

    class ApplicationStates(object): ...

    class ArrowType(object):
        NoArrow                  : Qt.ArrowType = ... # 0x0
        UpArrow                  : Qt.ArrowType = ... # 0x1
        DownArrow                : Qt.ArrowType = ... # 0x2
        LeftArrow                : Qt.ArrowType = ... # 0x3
        RightArrow               : Qt.ArrowType = ... # 0x4

    class AspectRatioMode(object):
        IgnoreAspectRatio        : Qt.AspectRatioMode = ... # 0x0
        KeepAspectRatio          : Qt.AspectRatioMode = ... # 0x1
        KeepAspectRatioByExpanding: Qt.AspectRatioMode = ... # 0x2

    class Axis(object):
        XAxis                    : Qt.Axis = ... # 0x0
        YAxis                    : Qt.Axis = ... # 0x1
        ZAxis                    : Qt.Axis = ... # 0x2

    class BGMode(object):
        TransparentMode          : Qt.BGMode = ... # 0x0
        OpaqueMode               : Qt.BGMode = ... # 0x1

    class BrushStyle(object):
        NoBrush                  : Qt.BrushStyle = ... # 0x0
        SolidPattern             : Qt.BrushStyle = ... # 0x1
        Dense1Pattern            : Qt.BrushStyle = ... # 0x2
        Dense2Pattern            : Qt.BrushStyle = ... # 0x3
        Dense3Pattern            : Qt.BrushStyle = ... # 0x4
        Dense4Pattern            : Qt.BrushStyle = ... # 0x5
        Dense5Pattern            : Qt.BrushStyle = ... # 0x6
        Dense6Pattern            : Qt.BrushStyle = ... # 0x7
        Dense7Pattern            : Qt.BrushStyle = ... # 0x8
        HorPattern               : Qt.BrushStyle = ... # 0x9
        VerPattern               : Qt.BrushStyle = ... # 0xa
        CrossPattern             : Qt.BrushStyle = ... # 0xb
        BDiagPattern             : Qt.BrushStyle = ... # 0xc
        FDiagPattern             : Qt.BrushStyle = ... # 0xd
        DiagCrossPattern         : Qt.BrushStyle = ... # 0xe
        LinearGradientPattern    : Qt.BrushStyle = ... # 0xf
        RadialGradientPattern    : Qt.BrushStyle = ... # 0x10
        ConicalGradientPattern   : Qt.BrushStyle = ... # 0x11
        TexturePattern           : Qt.BrushStyle = ... # 0x18

    class CaseSensitivity(object):
        CaseInsensitive          : Qt.CaseSensitivity = ... # 0x0
        CaseSensitive            : Qt.CaseSensitivity = ... # 0x1

    class CheckState(object):
        Unchecked                : Qt.CheckState = ... # 0x0
        PartiallyChecked         : Qt.CheckState = ... # 0x1
        Checked                  : Qt.CheckState = ... # 0x2

    class ChecksumType(object):
        ChecksumIso3309          : Qt.ChecksumType = ... # 0x0
        ChecksumItuV41           : Qt.ChecksumType = ... # 0x1

    class ClipOperation(object):
        NoClip                   : Qt.ClipOperation = ... # 0x0
        ReplaceClip              : Qt.ClipOperation = ... # 0x1
        IntersectClip            : Qt.ClipOperation = ... # 0x2

    class ConnectionType(object):
        AutoConnection           : Qt.ConnectionType = ... # 0x0
        DirectConnection         : Qt.ConnectionType = ... # 0x1
        QueuedConnection         : Qt.ConnectionType = ... # 0x2
        BlockingQueuedConnection : Qt.ConnectionType = ... # 0x3
        UniqueConnection         : Qt.ConnectionType = ... # 0x80
        SingleShotConnection     : Qt.ConnectionType = ... # 0x100

    class ContextMenuPolicy(object):
        NoContextMenu            : Qt.ContextMenuPolicy = ... # 0x0
        DefaultContextMenu       : Qt.ContextMenuPolicy = ... # 0x1
        ActionsContextMenu       : Qt.ContextMenuPolicy = ... # 0x2
        CustomContextMenu        : Qt.ContextMenuPolicy = ... # 0x3
        PreventContextMenu       : Qt.ContextMenuPolicy = ... # 0x4

    class CoordinateSystem(object):
        DeviceCoordinates        : Qt.CoordinateSystem = ... # 0x0
        LogicalCoordinates       : Qt.CoordinateSystem = ... # 0x1

    class Corner(object):
        TopLeftCorner            : Qt.Corner = ... # 0x0
        TopRightCorner           : Qt.Corner = ... # 0x1
        BottomLeftCorner         : Qt.Corner = ... # 0x2
        BottomRightCorner        : Qt.Corner = ... # 0x3

    class CursorMoveStyle(object):
        LogicalMoveStyle         : Qt.CursorMoveStyle = ... # 0x0
        VisualMoveStyle          : Qt.CursorMoveStyle = ... # 0x1

    class CursorShape(object):
        ArrowCursor              : Qt.CursorShape = ... # 0x0
        UpArrowCursor            : Qt.CursorShape = ... # 0x1
        CrossCursor              : Qt.CursorShape = ... # 0x2
        WaitCursor               : Qt.CursorShape = ... # 0x3
        IBeamCursor              : Qt.CursorShape = ... # 0x4
        SizeVerCursor            : Qt.CursorShape = ... # 0x5
        SizeHorCursor            : Qt.CursorShape = ... # 0x6
        SizeBDiagCursor          : Qt.CursorShape = ... # 0x7
        SizeFDiagCursor          : Qt.CursorShape = ... # 0x8
        SizeAllCursor            : Qt.CursorShape = ... # 0x9
        BlankCursor              : Qt.CursorShape = ... # 0xa
        SplitVCursor             : Qt.CursorShape = ... # 0xb
        SplitHCursor             : Qt.CursorShape = ... # 0xc
        PointingHandCursor       : Qt.CursorShape = ... # 0xd
        ForbiddenCursor          : Qt.CursorShape = ... # 0xe
        WhatsThisCursor          : Qt.CursorShape = ... # 0xf
        BusyCursor               : Qt.CursorShape = ... # 0x10
        OpenHandCursor           : Qt.CursorShape = ... # 0x11
        ClosedHandCursor         : Qt.CursorShape = ... # 0x12
        DragCopyCursor           : Qt.CursorShape = ... # 0x13
        DragMoveCursor           : Qt.CursorShape = ... # 0x14
        DragLinkCursor           : Qt.CursorShape = ... # 0x15
        LastCursor               : Qt.CursorShape = ... # 0x15
        BitmapCursor             : Qt.CursorShape = ... # 0x18
        CustomCursor             : Qt.CursorShape = ... # 0x19

    class DateFormat(object):
        TextDate                 : Qt.DateFormat = ... # 0x0
        ISODate                  : Qt.DateFormat = ... # 0x1
        RFC2822Date              : Qt.DateFormat = ... # 0x8
        ISODateWithMs            : Qt.DateFormat = ... # 0x9

    class DayOfWeek(object):
        Monday                   : Qt.DayOfWeek = ... # 0x1
        Tuesday                  : Qt.DayOfWeek = ... # 0x2
        Wednesday                : Qt.DayOfWeek = ... # 0x3
        Thursday                 : Qt.DayOfWeek = ... # 0x4
        Friday                   : Qt.DayOfWeek = ... # 0x5
        Saturday                 : Qt.DayOfWeek = ... # 0x6
        Sunday                   : Qt.DayOfWeek = ... # 0x7

    class DockWidgetArea(object):
        NoDockWidgetArea         : Qt.DockWidgetArea = ... # 0x0
        LeftDockWidgetArea       : Qt.DockWidgetArea = ... # 0x1
        RightDockWidgetArea      : Qt.DockWidgetArea = ... # 0x2
        TopDockWidgetArea        : Qt.DockWidgetArea = ... # 0x4
        BottomDockWidgetArea     : Qt.DockWidgetArea = ... # 0x8
        AllDockWidgetAreas       : Qt.DockWidgetArea = ... # 0xf
        DockWidgetArea_Mask      : Qt.DockWidgetArea = ... # 0xf

    class DockWidgetAreaSizes(object):
        NDockWidgetAreas         : Qt.DockWidgetAreaSizes = ... # 0x4

    class DockWidgetAreas(object): ...

    class DropAction(object):
        IgnoreAction             : Qt.DropAction = ... # 0x0
        CopyAction               : Qt.DropAction = ... # 0x1
        MoveAction               : Qt.DropAction = ... # 0x2
        LinkAction               : Qt.DropAction = ... # 0x4
        ActionMask               : Qt.DropAction = ... # 0xff
        TargetMoveAction         : Qt.DropAction = ... # 0x8002

    class DropActions(object): ...

    class Edge(object):
        TopEdge                  : Qt.Edge = ... # 0x1
        LeftEdge                 : Qt.Edge = ... # 0x2
        RightEdge                : Qt.Edge = ... # 0x4
        BottomEdge               : Qt.Edge = ... # 0x8

    class Edges(object): ...

    class EnterKeyType(object):
        EnterKeyDefault          : Qt.EnterKeyType = ... # 0x0
        EnterKeyReturn           : Qt.EnterKeyType = ... # 0x1
        EnterKeyDone             : Qt.EnterKeyType = ... # 0x2
        EnterKeyGo               : Qt.EnterKeyType = ... # 0x3
        EnterKeySend             : Qt.EnterKeyType = ... # 0x4
        EnterKeySearch           : Qt.EnterKeyType = ... # 0x5
        EnterKeyNext             : Qt.EnterKeyType = ... # 0x6
        EnterKeyPrevious         : Qt.EnterKeyType = ... # 0x7

    class EventPriority(object):
        LowEventPriority         : Qt.EventPriority = ... # -0x1
        NormalEventPriority      : Qt.EventPriority = ... # 0x0
        HighEventPriority        : Qt.EventPriority = ... # 0x1

    class FillRule(object):
        OddEvenFill              : Qt.FillRule = ... # 0x0
        WindingFill              : Qt.FillRule = ... # 0x1

    class FindChildOption(object):
        FindDirectChildrenOnly   : Qt.FindChildOption = ... # 0x0
        FindChildrenRecursively  : Qt.FindChildOption = ... # 0x1

    class FindChildOptions(object): ...

    class FocusPolicy(object):
        NoFocus                  : Qt.FocusPolicy = ... # 0x0
        TabFocus                 : Qt.FocusPolicy = ... # 0x1
        ClickFocus               : Qt.FocusPolicy = ... # 0x2
        StrongFocus              : Qt.FocusPolicy = ... # 0xb
        WheelFocus               : Qt.FocusPolicy = ... # 0xf

    class FocusReason(object):
        MouseFocusReason         : Qt.FocusReason = ... # 0x0
        TabFocusReason           : Qt.FocusReason = ... # 0x1
        BacktabFocusReason       : Qt.FocusReason = ... # 0x2
        ActiveWindowFocusReason  : Qt.FocusReason = ... # 0x3
        PopupFocusReason         : Qt.FocusReason = ... # 0x4
        ShortcutFocusReason      : Qt.FocusReason = ... # 0x5
        MenuBarFocusReason       : Qt.FocusReason = ... # 0x6
        OtherFocusReason         : Qt.FocusReason = ... # 0x7
        NoFocusReason            : Qt.FocusReason = ... # 0x8

    class GestureFlag(object):
        DontStartGestureOnChildren: Qt.GestureFlag = ... # 0x1
        ReceivePartialGestures   : Qt.GestureFlag = ... # 0x2
        IgnoredGesturesPropagateToParent: Qt.GestureFlag = ... # 0x4

    class GestureFlags(object): ...

    class GestureState(object):
        NoGesture                : Qt.GestureState = ... # 0x0
        GestureStarted           : Qt.GestureState = ... # 0x1
        GestureUpdated           : Qt.GestureState = ... # 0x2
        GestureFinished          : Qt.GestureState = ... # 0x3
        GestureCanceled          : Qt.GestureState = ... # 0x4

    class GestureType(object):
        LastGestureType          : Qt.GestureType = ... # -0x1
        TapGesture               : Qt.GestureType = ... # 0x1
        TapAndHoldGesture        : Qt.GestureType = ... # 0x2
        PanGesture               : Qt.GestureType = ... # 0x3
        PinchGesture             : Qt.GestureType = ... # 0x4
        SwipeGesture             : Qt.GestureType = ... # 0x5
        CustomGesture            : Qt.GestureType = ... # 0x100

    class GlobalColor(object):
        color0                   : Qt.GlobalColor = ... # 0x0
        color1                   : Qt.GlobalColor = ... # 0x1
        black                    : Qt.GlobalColor = ... # 0x2
        white                    : Qt.GlobalColor = ... # 0x3
        darkGray                 : Qt.GlobalColor = ... # 0x4
        gray                     : Qt.GlobalColor = ... # 0x5
        lightGray                : Qt.GlobalColor = ... # 0x6
        red                      : Qt.GlobalColor = ... # 0x7
        green                    : Qt.GlobalColor = ... # 0x8
        blue                     : Qt.GlobalColor = ... # 0x9
        cyan                     : Qt.GlobalColor = ... # 0xa
        magenta                  : Qt.GlobalColor = ... # 0xb
        yellow                   : Qt.GlobalColor = ... # 0xc
        darkRed                  : Qt.GlobalColor = ... # 0xd
        darkGreen                : Qt.GlobalColor = ... # 0xe
        darkBlue                 : Qt.GlobalColor = ... # 0xf
        darkCyan                 : Qt.GlobalColor = ... # 0x10
        darkMagenta              : Qt.GlobalColor = ... # 0x11
        darkYellow               : Qt.GlobalColor = ... # 0x12
        transparent              : Qt.GlobalColor = ... # 0x13

    class HighDpiScaleFactorRoundingPolicy(object):
        Unset                    : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x0
        Round                    : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x1
        Ceil                     : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x2
        Floor                    : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x3
        RoundPreferFloor         : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x4
        PassThrough              : Qt.HighDpiScaleFactorRoundingPolicy = ... # 0x5

    class HitTestAccuracy(object):
        ExactHit                 : Qt.HitTestAccuracy = ... # 0x0
        FuzzyHit                 : Qt.HitTestAccuracy = ... # 0x1

    class ImageConversionFlag(object):
        AutoColor                : Qt.ImageConversionFlag = ... # 0x0
        AutoDither               : Qt.ImageConversionFlag = ... # 0x0
        DiffuseDither            : Qt.ImageConversionFlag = ... # 0x0
        ThresholdAlphaDither     : Qt.ImageConversionFlag = ... # 0x0
        MonoOnly                 : Qt.ImageConversionFlag = ... # 0x2
        ColorMode_Mask           : Qt.ImageConversionFlag = ... # 0x3
        ColorOnly                : Qt.ImageConversionFlag = ... # 0x3
        OrderedAlphaDither       : Qt.ImageConversionFlag = ... # 0x4
        DiffuseAlphaDither       : Qt.ImageConversionFlag = ... # 0x8
        AlphaDither_Mask         : Qt.ImageConversionFlag = ... # 0xc
        NoAlpha                  : Qt.ImageConversionFlag = ... # 0xc
        OrderedDither            : Qt.ImageConversionFlag = ... # 0x10
        ThresholdDither          : Qt.ImageConversionFlag = ... # 0x20
        Dither_Mask              : Qt.ImageConversionFlag = ... # 0x30
        PreferDither             : Qt.ImageConversionFlag = ... # 0x40
        AvoidDither              : Qt.ImageConversionFlag = ... # 0x80
        DitherMode_Mask          : Qt.ImageConversionFlag = ... # 0xc0
        NoOpaqueDetection        : Qt.ImageConversionFlag = ... # 0x100
        NoFormatConversion       : Qt.ImageConversionFlag = ... # 0x200

    class ImageConversionFlags(object): ...

    class InputMethodHint(object):
        ImhExclusiveInputMask    : Qt.InputMethodHint = ... # -0x10000
        ImhNone                  : Qt.InputMethodHint = ... # 0x0
        ImhHiddenText            : Qt.InputMethodHint = ... # 0x1
        ImhSensitiveData         : Qt.InputMethodHint = ... # 0x2
        ImhNoAutoUppercase       : Qt.InputMethodHint = ... # 0x4
        ImhPreferNumbers         : Qt.InputMethodHint = ... # 0x8
        ImhPreferUppercase       : Qt.InputMethodHint = ... # 0x10
        ImhPreferLowercase       : Qt.InputMethodHint = ... # 0x20
        ImhNoPredictiveText      : Qt.InputMethodHint = ... # 0x40
        ImhDate                  : Qt.InputMethodHint = ... # 0x80
        ImhTime                  : Qt.InputMethodHint = ... # 0x100
        ImhPreferLatin           : Qt.InputMethodHint = ... # 0x200
        ImhMultiLine             : Qt.InputMethodHint = ... # 0x400
        ImhNoEditMenu            : Qt.InputMethodHint = ... # 0x800
        ImhNoTextHandles         : Qt.InputMethodHint = ... # 0x1000
        ImhDigitsOnly            : Qt.InputMethodHint = ... # 0x10000
        ImhFormattedNumbersOnly  : Qt.InputMethodHint = ... # 0x20000
        ImhUppercaseOnly         : Qt.InputMethodHint = ... # 0x40000
        ImhLowercaseOnly         : Qt.InputMethodHint = ... # 0x80000
        ImhDialableCharactersOnly: Qt.InputMethodHint = ... # 0x100000
        ImhEmailCharactersOnly   : Qt.InputMethodHint = ... # 0x200000
        ImhUrlCharactersOnly     : Qt.InputMethodHint = ... # 0x400000
        ImhLatinOnly             : Qt.InputMethodHint = ... # 0x800000

    class InputMethodHints(object): ...

    class InputMethodQueries(object): ...

    class InputMethodQuery(object):
        ImPlatformData           : Qt.InputMethodQuery = ... # -0x80000000
        ImQueryAll               : Qt.InputMethodQuery = ... # -0x1
        ImEnabled                : Qt.InputMethodQuery = ... # 0x1
        ImCursorRectangle        : Qt.InputMethodQuery = ... # 0x2
        ImFont                   : Qt.InputMethodQuery = ... # 0x4
        ImCursorPosition         : Qt.InputMethodQuery = ... # 0x8
        ImSurroundingText        : Qt.InputMethodQuery = ... # 0x10
        ImCurrentSelection       : Qt.InputMethodQuery = ... # 0x20
        ImMaximumTextLength      : Qt.InputMethodQuery = ... # 0x40
        ImAnchorPosition         : Qt.InputMethodQuery = ... # 0x80
        ImHints                  : Qt.InputMethodQuery = ... # 0x100
        ImPreferredLanguage      : Qt.InputMethodQuery = ... # 0x200
        ImAbsolutePosition       : Qt.InputMethodQuery = ... # 0x400
        ImTextBeforeCursor       : Qt.InputMethodQuery = ... # 0x800
        ImTextAfterCursor        : Qt.InputMethodQuery = ... # 0x1000
        ImEnterKeyType           : Qt.InputMethodQuery = ... # 0x2000
        ImAnchorRectangle        : Qt.InputMethodQuery = ... # 0x4000
        ImQueryInput             : Qt.InputMethodQuery = ... # 0x40ba
        ImInputItemClipRectangle : Qt.InputMethodQuery = ... # 0x8000

    class ItemDataRole(object):
        DisplayRole              : Qt.ItemDataRole = ... # 0x0
        DecorationRole           : Qt.ItemDataRole = ... # 0x1
        EditRole                 : Qt.ItemDataRole = ... # 0x2
        ToolTipRole              : Qt.ItemDataRole = ... # 0x3
        StatusTipRole            : Qt.ItemDataRole = ... # 0x4
        WhatsThisRole            : Qt.ItemDataRole = ... # 0x5
        FontRole                 : Qt.ItemDataRole = ... # 0x6
        TextAlignmentRole        : Qt.ItemDataRole = ... # 0x7
        BackgroundRole           : Qt.ItemDataRole = ... # 0x8
        ForegroundRole           : Qt.ItemDataRole = ... # 0x9
        CheckStateRole           : Qt.ItemDataRole = ... # 0xa
        AccessibleTextRole       : Qt.ItemDataRole = ... # 0xb
        AccessibleDescriptionRole: Qt.ItemDataRole = ... # 0xc
        SizeHintRole             : Qt.ItemDataRole = ... # 0xd
        InitialSortOrderRole     : Qt.ItemDataRole = ... # 0xe
        DisplayPropertyRole      : Qt.ItemDataRole = ... # 0x1b
        DecorationPropertyRole   : Qt.ItemDataRole = ... # 0x1c
        ToolTipPropertyRole      : Qt.ItemDataRole = ... # 0x1d
        StatusTipPropertyRole    : Qt.ItemDataRole = ... # 0x1e
        WhatsThisPropertyRole    : Qt.ItemDataRole = ... # 0x1f
        UserRole                 : Qt.ItemDataRole = ... # 0x100

    class ItemFlag(object):
        NoItemFlags              : Qt.ItemFlag = ... # 0x0
        ItemIsSelectable         : Qt.ItemFlag = ... # 0x1
        ItemIsEditable           : Qt.ItemFlag = ... # 0x2
        ItemIsDragEnabled        : Qt.ItemFlag = ... # 0x4
        ItemIsDropEnabled        : Qt.ItemFlag = ... # 0x8
        ItemIsUserCheckable      : Qt.ItemFlag = ... # 0x10
        ItemIsEnabled            : Qt.ItemFlag = ... # 0x20
        ItemIsAutoTristate       : Qt.ItemFlag = ... # 0x40
        ItemNeverHasChildren     : Qt.ItemFlag = ... # 0x80
        ItemIsUserTristate       : Qt.ItemFlag = ... # 0x100

    class ItemFlags(object): ...

    class ItemSelectionMode(object):
        ContainsItemShape        : Qt.ItemSelectionMode = ... # 0x0
        IntersectsItemShape      : Qt.ItemSelectionMode = ... # 0x1
        ContainsItemBoundingRect : Qt.ItemSelectionMode = ... # 0x2
        IntersectsItemBoundingRect: Qt.ItemSelectionMode = ... # 0x3

    class ItemSelectionOperation(object):
        ReplaceSelection         : Qt.ItemSelectionOperation = ... # 0x0
        AddToSelection           : Qt.ItemSelectionOperation = ... # 0x1

    class Key(object):
        Key_Any                  : Qt.Key = ... # 0x20
        Key_Space                : Qt.Key = ... # 0x20
        Key_Exclam               : Qt.Key = ... # 0x21
        Key_QuoteDbl             : Qt.Key = ... # 0x22
        Key_NumberSign           : Qt.Key = ... # 0x23
        Key_Dollar               : Qt.Key = ... # 0x24
        Key_Percent              : Qt.Key = ... # 0x25
        Key_Ampersand            : Qt.Key = ... # 0x26
        Key_Apostrophe           : Qt.Key = ... # 0x27
        Key_ParenLeft            : Qt.Key = ... # 0x28
        Key_ParenRight           : Qt.Key = ... # 0x29
        Key_Asterisk             : Qt.Key = ... # 0x2a
        Key_Plus                 : Qt.Key = ... # 0x2b
        Key_Comma                : Qt.Key = ... # 0x2c
        Key_Minus                : Qt.Key = ... # 0x2d
        Key_Period               : Qt.Key = ... # 0x2e
        Key_Slash                : Qt.Key = ... # 0x2f
        Key_0                    : Qt.Key = ... # 0x30
        Key_1                    : Qt.Key = ... # 0x31
        Key_2                    : Qt.Key = ... # 0x32
        Key_3                    : Qt.Key = ... # 0x33
        Key_4                    : Qt.Key = ... # 0x34
        Key_5                    : Qt.Key = ... # 0x35
        Key_6                    : Qt.Key = ... # 0x36
        Key_7                    : Qt.Key = ... # 0x37
        Key_8                    : Qt.Key = ... # 0x38
        Key_9                    : Qt.Key = ... # 0x39
        Key_Colon                : Qt.Key = ... # 0x3a
        Key_Semicolon            : Qt.Key = ... # 0x3b
        Key_Less                 : Qt.Key = ... # 0x3c
        Key_Equal                : Qt.Key = ... # 0x3d
        Key_Greater              : Qt.Key = ... # 0x3e
        Key_Question             : Qt.Key = ... # 0x3f
        Key_At                   : Qt.Key = ... # 0x40
        Key_A                    : Qt.Key = ... # 0x41
        Key_B                    : Qt.Key = ... # 0x42
        Key_C                    : Qt.Key = ... # 0x43
        Key_D                    : Qt.Key = ... # 0x44
        Key_E                    : Qt.Key = ... # 0x45
        Key_F                    : Qt.Key = ... # 0x46
        Key_G                    : Qt.Key = ... # 0x47
        Key_H                    : Qt.Key = ... # 0x48
        Key_I                    : Qt.Key = ... # 0x49
        Key_J                    : Qt.Key = ... # 0x4a
        Key_K                    : Qt.Key = ... # 0x4b
        Key_L                    : Qt.Key = ... # 0x4c
        Key_M                    : Qt.Key = ... # 0x4d
        Key_N                    : Qt.Key = ... # 0x4e
        Key_O                    : Qt.Key = ... # 0x4f
        Key_P                    : Qt.Key = ... # 0x50
        Key_Q                    : Qt.Key = ... # 0x51
        Key_R                    : Qt.Key = ... # 0x52
        Key_S                    : Qt.Key = ... # 0x53
        Key_T                    : Qt.Key = ... # 0x54
        Key_U                    : Qt.Key = ... # 0x55
        Key_V                    : Qt.Key = ... # 0x56
        Key_W                    : Qt.Key = ... # 0x57
        Key_X                    : Qt.Key = ... # 0x58
        Key_Y                    : Qt.Key = ... # 0x59
        Key_Z                    : Qt.Key = ... # 0x5a
        Key_BracketLeft          : Qt.Key = ... # 0x5b
        Key_Backslash            : Qt.Key = ... # 0x5c
        Key_BracketRight         : Qt.Key = ... # 0x5d
        Key_AsciiCircum          : Qt.Key = ... # 0x5e
        Key_Underscore           : Qt.Key = ... # 0x5f
        Key_QuoteLeft            : Qt.Key = ... # 0x60
        Key_BraceLeft            : Qt.Key = ... # 0x7b
        Key_Bar                  : Qt.Key = ... # 0x7c
        Key_BraceRight           : Qt.Key = ... # 0x7d
        Key_AsciiTilde           : Qt.Key = ... # 0x7e
        Key_nobreakspace         : Qt.Key = ... # 0xa0
        Key_exclamdown           : Qt.Key = ... # 0xa1
        Key_cent                 : Qt.Key = ... # 0xa2
        Key_sterling             : Qt.Key = ... # 0xa3
        Key_currency             : Qt.Key = ... # 0xa4
        Key_yen                  : Qt.Key = ... # 0xa5
        Key_brokenbar            : Qt.Key = ... # 0xa6
        Key_section              : Qt.Key = ... # 0xa7
        Key_diaeresis            : Qt.Key = ... # 0xa8
        Key_copyright            : Qt.Key = ... # 0xa9
        Key_ordfeminine          : Qt.Key = ... # 0xaa
        Key_guillemotleft        : Qt.Key = ... # 0xab
        Key_notsign              : Qt.Key = ... # 0xac
        Key_hyphen               : Qt.Key = ... # 0xad
        Key_registered           : Qt.Key = ... # 0xae
        Key_macron               : Qt.Key = ... # 0xaf
        Key_degree               : Qt.Key = ... # 0xb0
        Key_plusminus            : Qt.Key = ... # 0xb1
        Key_twosuperior          : Qt.Key = ... # 0xb2
        Key_threesuperior        : Qt.Key = ... # 0xb3
        Key_acute                : Qt.Key = ... # 0xb4
        Key_mu                   : Qt.Key = ... # 0xb5
        Key_paragraph            : Qt.Key = ... # 0xb6
        Key_periodcentered       : Qt.Key = ... # 0xb7
        Key_cedilla              : Qt.Key = ... # 0xb8
        Key_onesuperior          : Qt.Key = ... # 0xb9
        Key_masculine            : Qt.Key = ... # 0xba
        Key_guillemotright       : Qt.Key = ... # 0xbb
        Key_onequarter           : Qt.Key = ... # 0xbc
        Key_onehalf              : Qt.Key = ... # 0xbd
        Key_threequarters        : Qt.Key = ... # 0xbe
        Key_questiondown         : Qt.Key = ... # 0xbf
        Key_Agrave               : Qt.Key = ... # 0xc0
        Key_Aacute               : Qt.Key = ... # 0xc1
        Key_Acircumflex          : Qt.Key = ... # 0xc2
        Key_Atilde               : Qt.Key = ... # 0xc3
        Key_Adiaeresis           : Qt.Key = ... # 0xc4
        Key_Aring                : Qt.Key = ... # 0xc5
        Key_AE                   : Qt.Key = ... # 0xc6
        Key_Ccedilla             : Qt.Key = ... # 0xc7
        Key_Egrave               : Qt.Key = ... # 0xc8
        Key_Eacute               : Qt.Key = ... # 0xc9
        Key_Ecircumflex          : Qt.Key = ... # 0xca
        Key_Ediaeresis           : Qt.Key = ... # 0xcb
        Key_Igrave               : Qt.Key = ... # 0xcc
        Key_Iacute               : Qt.Key = ... # 0xcd
        Key_Icircumflex          : Qt.Key = ... # 0xce
        Key_Idiaeresis           : Qt.Key = ... # 0xcf
        Key_ETH                  : Qt.Key = ... # 0xd0
        Key_Ntilde               : Qt.Key = ... # 0xd1
        Key_Ograve               : Qt.Key = ... # 0xd2
        Key_Oacute               : Qt.Key = ... # 0xd3
        Key_Ocircumflex          : Qt.Key = ... # 0xd4
        Key_Otilde               : Qt.Key = ... # 0xd5
        Key_Odiaeresis           : Qt.Key = ... # 0xd6
        Key_multiply             : Qt.Key = ... # 0xd7
        Key_Ooblique             : Qt.Key = ... # 0xd8
        Key_Ugrave               : Qt.Key = ... # 0xd9
        Key_Uacute               : Qt.Key = ... # 0xda
        Key_Ucircumflex          : Qt.Key = ... # 0xdb
        Key_Udiaeresis           : Qt.Key = ... # 0xdc
        Key_Yacute               : Qt.Key = ... # 0xdd
        Key_THORN                : Qt.Key = ... # 0xde
        Key_ssharp               : Qt.Key = ... # 0xdf
        Key_division             : Qt.Key = ... # 0xf7
        Key_ydiaeresis           : Qt.Key = ... # 0xff
        Key_Escape               : Qt.Key = ... # 0x1000000
        Key_Tab                  : Qt.Key = ... # 0x1000001
        Key_Backtab              : Qt.Key = ... # 0x1000002
        Key_Backspace            : Qt.Key = ... # 0x1000003
        Key_Return               : Qt.Key = ... # 0x1000004
        Key_Enter                : Qt.Key = ... # 0x1000005
        Key_Insert               : Qt.Key = ... # 0x1000006
        Key_Delete               : Qt.Key = ... # 0x1000007
        Key_Pause                : Qt.Key = ... # 0x1000008
        Key_Print                : Qt.Key = ... # 0x1000009
        Key_SysReq               : Qt.Key = ... # 0x100000a
        Key_Clear                : Qt.Key = ... # 0x100000b
        Key_Home                 : Qt.Key = ... # 0x1000010
        Key_End                  : Qt.Key = ... # 0x1000011
        Key_Left                 : Qt.Key = ... # 0x1000012
        Key_Up                   : Qt.Key = ... # 0x1000013
        Key_Right                : Qt.Key = ... # 0x1000014
        Key_Down                 : Qt.Key = ... # 0x1000015
        Key_PageUp               : Qt.Key = ... # 0x1000016
        Key_PageDown             : Qt.Key = ... # 0x1000017
        Key_Shift                : Qt.Key = ... # 0x1000020
        Key_Control              : Qt.Key = ... # 0x1000021
        Key_Meta                 : Qt.Key = ... # 0x1000022
        Key_Alt                  : Qt.Key = ... # 0x1000023
        Key_CapsLock             : Qt.Key = ... # 0x1000024
        Key_NumLock              : Qt.Key = ... # 0x1000025
        Key_ScrollLock           : Qt.Key = ... # 0x1000026
        Key_F1                   : Qt.Key = ... # 0x1000030
        Key_F2                   : Qt.Key = ... # 0x1000031
        Key_F3                   : Qt.Key = ... # 0x1000032
        Key_F4                   : Qt.Key = ... # 0x1000033
        Key_F5                   : Qt.Key = ... # 0x1000034
        Key_F6                   : Qt.Key = ... # 0x1000035
        Key_F7                   : Qt.Key = ... # 0x1000036
        Key_F8                   : Qt.Key = ... # 0x1000037
        Key_F9                   : Qt.Key = ... # 0x1000038
        Key_F10                  : Qt.Key = ... # 0x1000039
        Key_F11                  : Qt.Key = ... # 0x100003a
        Key_F12                  : Qt.Key = ... # 0x100003b
        Key_F13                  : Qt.Key = ... # 0x100003c
        Key_F14                  : Qt.Key = ... # 0x100003d
        Key_F15                  : Qt.Key = ... # 0x100003e
        Key_F16                  : Qt.Key = ... # 0x100003f
        Key_F17                  : Qt.Key = ... # 0x1000040
        Key_F18                  : Qt.Key = ... # 0x1000041
        Key_F19                  : Qt.Key = ... # 0x1000042
        Key_F20                  : Qt.Key = ... # 0x1000043
        Key_F21                  : Qt.Key = ... # 0x1000044
        Key_F22                  : Qt.Key = ... # 0x1000045
        Key_F23                  : Qt.Key = ... # 0x1000046
        Key_F24                  : Qt.Key = ... # 0x1000047
        Key_F25                  : Qt.Key = ... # 0x1000048
        Key_F26                  : Qt.Key = ... # 0x1000049
        Key_F27                  : Qt.Key = ... # 0x100004a
        Key_F28                  : Qt.Key = ... # 0x100004b
        Key_F29                  : Qt.Key = ... # 0x100004c
        Key_F30                  : Qt.Key = ... # 0x100004d
        Key_F31                  : Qt.Key = ... # 0x100004e
        Key_F32                  : Qt.Key = ... # 0x100004f
        Key_F33                  : Qt.Key = ... # 0x1000050
        Key_F34                  : Qt.Key = ... # 0x1000051
        Key_F35                  : Qt.Key = ... # 0x1000052
        Key_Super_L              : Qt.Key = ... # 0x1000053
        Key_Super_R              : Qt.Key = ... # 0x1000054
        Key_Menu                 : Qt.Key = ... # 0x1000055
        Key_Hyper_L              : Qt.Key = ... # 0x1000056
        Key_Hyper_R              : Qt.Key = ... # 0x1000057
        Key_Help                 : Qt.Key = ... # 0x1000058
        Key_Direction_L          : Qt.Key = ... # 0x1000059
        Key_Direction_R          : Qt.Key = ... # 0x1000060
        Key_Back                 : Qt.Key = ... # 0x1000061
        Key_Forward              : Qt.Key = ... # 0x1000062
        Key_Stop                 : Qt.Key = ... # 0x1000063
        Key_Refresh              : Qt.Key = ... # 0x1000064
        Key_VolumeDown           : Qt.Key = ... # 0x1000070
        Key_VolumeMute           : Qt.Key = ... # 0x1000071
        Key_VolumeUp             : Qt.Key = ... # 0x1000072
        Key_BassBoost            : Qt.Key = ... # 0x1000073
        Key_BassUp               : Qt.Key = ... # 0x1000074
        Key_BassDown             : Qt.Key = ... # 0x1000075
        Key_TrebleUp             : Qt.Key = ... # 0x1000076
        Key_TrebleDown           : Qt.Key = ... # 0x1000077
        Key_MediaPlay            : Qt.Key = ... # 0x1000080
        Key_MediaStop            : Qt.Key = ... # 0x1000081
        Key_MediaPrevious        : Qt.Key = ... # 0x1000082
        Key_MediaNext            : Qt.Key = ... # 0x1000083
        Key_MediaRecord          : Qt.Key = ... # 0x1000084
        Key_MediaPause           : Qt.Key = ... # 0x1000085
        Key_MediaTogglePlayPause : Qt.Key = ... # 0x1000086
        Key_HomePage             : Qt.Key = ... # 0x1000090
        Key_Favorites            : Qt.Key = ... # 0x1000091
        Key_Search               : Qt.Key = ... # 0x1000092
        Key_Standby              : Qt.Key = ... # 0x1000093
        Key_OpenUrl              : Qt.Key = ... # 0x1000094
        Key_LaunchMail           : Qt.Key = ... # 0x10000a0
        Key_LaunchMedia          : Qt.Key = ... # 0x10000a1
        Key_Launch0              : Qt.Key = ... # 0x10000a2
        Key_Launch1              : Qt.Key = ... # 0x10000a3
        Key_Launch2              : Qt.Key = ... # 0x10000a4
        Key_Launch3              : Qt.Key = ... # 0x10000a5
        Key_Launch4              : Qt.Key = ... # 0x10000a6
        Key_Launch5              : Qt.Key = ... # 0x10000a7
        Key_Launch6              : Qt.Key = ... # 0x10000a8
        Key_Launch7              : Qt.Key = ... # 0x10000a9
        Key_Launch8              : Qt.Key = ... # 0x10000aa
        Key_Launch9              : Qt.Key = ... # 0x10000ab
        Key_LaunchA              : Qt.Key = ... # 0x10000ac
        Key_LaunchB              : Qt.Key = ... # 0x10000ad
        Key_LaunchC              : Qt.Key = ... # 0x10000ae
        Key_LaunchD              : Qt.Key = ... # 0x10000af
        Key_LaunchE              : Qt.Key = ... # 0x10000b0
        Key_LaunchF              : Qt.Key = ... # 0x10000b1
        Key_MonBrightnessUp      : Qt.Key = ... # 0x10000b2
        Key_MonBrightnessDown    : Qt.Key = ... # 0x10000b3
        Key_KeyboardLightOnOff   : Qt.Key = ... # 0x10000b4
        Key_KeyboardBrightnessUp : Qt.Key = ... # 0x10000b5
        Key_KeyboardBrightnessDown: Qt.Key = ... # 0x10000b6
        Key_PowerOff             : Qt.Key = ... # 0x10000b7
        Key_WakeUp               : Qt.Key = ... # 0x10000b8
        Key_Eject                : Qt.Key = ... # 0x10000b9
        Key_ScreenSaver          : Qt.Key = ... # 0x10000ba
        Key_WWW                  : Qt.Key = ... # 0x10000bb
        Key_Memo                 : Qt.Key = ... # 0x10000bc
        Key_LightBulb            : Qt.Key = ... # 0x10000bd
        Key_Shop                 : Qt.Key = ... # 0x10000be
        Key_History              : Qt.Key = ... # 0x10000bf
        Key_AddFavorite          : Qt.Key = ... # 0x10000c0
        Key_HotLinks             : Qt.Key = ... # 0x10000c1
        Key_BrightnessAdjust     : Qt.Key = ... # 0x10000c2
        Key_Finance              : Qt.Key = ... # 0x10000c3
        Key_Community            : Qt.Key = ... # 0x10000c4
        Key_AudioRewind          : Qt.Key = ... # 0x10000c5
        Key_BackForward          : Qt.Key = ... # 0x10000c6
        Key_ApplicationLeft      : Qt.Key = ... # 0x10000c7
        Key_ApplicationRight     : Qt.Key = ... # 0x10000c8
        Key_Book                 : Qt.Key = ... # 0x10000c9
        Key_CD                   : Qt.Key = ... # 0x10000ca
        Key_Calculator           : Qt.Key = ... # 0x10000cb
        Key_ToDoList             : Qt.Key = ... # 0x10000cc
        Key_ClearGrab            : Qt.Key = ... # 0x10000cd
        Key_Close                : Qt.Key = ... # 0x10000ce
        Key_Copy                 : Qt.Key = ... # 0x10000cf
        Key_Cut                  : Qt.Key = ... # 0x10000d0
        Key_Display              : Qt.Key = ... # 0x10000d1
        Key_DOS                  : Qt.Key = ... # 0x10000d2
        Key_Documents            : Qt.Key = ... # 0x10000d3
        Key_Excel                : Qt.Key = ... # 0x10000d4
        Key_Explorer             : Qt.Key = ... # 0x10000d5
        Key_Game                 : Qt.Key = ... # 0x10000d6
        Key_Go                   : Qt.Key = ... # 0x10000d7
        Key_iTouch               : Qt.Key = ... # 0x10000d8
        Key_LogOff               : Qt.Key = ... # 0x10000d9
        Key_Market               : Qt.Key = ... # 0x10000da
        Key_Meeting              : Qt.Key = ... # 0x10000db
        Key_MenuKB               : Qt.Key = ... # 0x10000dc
        Key_MenuPB               : Qt.Key = ... # 0x10000dd
        Key_MySites              : Qt.Key = ... # 0x10000de
        Key_News                 : Qt.Key = ... # 0x10000df
        Key_OfficeHome           : Qt.Key = ... # 0x10000e0
        Key_Option               : Qt.Key = ... # 0x10000e1
        Key_Paste                : Qt.Key = ... # 0x10000e2
        Key_Phone                : Qt.Key = ... # 0x10000e3
        Key_Calendar             : Qt.Key = ... # 0x10000e4
        Key_Reply                : Qt.Key = ... # 0x10000e5
        Key_Reload               : Qt.Key = ... # 0x10000e6
        Key_RotateWindows        : Qt.Key = ... # 0x10000e7
        Key_RotationPB           : Qt.Key = ... # 0x10000e8
        Key_RotationKB           : Qt.Key = ... # 0x10000e9
        Key_Save                 : Qt.Key = ... # 0x10000ea
        Key_Send                 : Qt.Key = ... # 0x10000eb
        Key_Spell                : Qt.Key = ... # 0x10000ec
        Key_SplitScreen          : Qt.Key = ... # 0x10000ed
        Key_Support              : Qt.Key = ... # 0x10000ee
        Key_TaskPane             : Qt.Key = ... # 0x10000ef
        Key_Terminal             : Qt.Key = ... # 0x10000f0
        Key_Tools                : Qt.Key = ... # 0x10000f1
        Key_Travel               : Qt.Key = ... # 0x10000f2
        Key_Video                : Qt.Key = ... # 0x10000f3
        Key_Word                 : Qt.Key = ... # 0x10000f4
        Key_Xfer                 : Qt.Key = ... # 0x10000f5
        Key_ZoomIn               : Qt.Key = ... # 0x10000f6
        Key_ZoomOut              : Qt.Key = ... # 0x10000f7
        Key_Away                 : Qt.Key = ... # 0x10000f8
        Key_Messenger            : Qt.Key = ... # 0x10000f9
        Key_WebCam               : Qt.Key = ... # 0x10000fa
        Key_MailForward          : Qt.Key = ... # 0x10000fb
        Key_Pictures             : Qt.Key = ... # 0x10000fc
        Key_Music                : Qt.Key = ... # 0x10000fd
        Key_Battery              : Qt.Key = ... # 0x10000fe
        Key_Bluetooth            : Qt.Key = ... # 0x10000ff
        Key_WLAN                 : Qt.Key = ... # 0x1000100
        Key_UWB                  : Qt.Key = ... # 0x1000101
        Key_AudioForward         : Qt.Key = ... # 0x1000102
        Key_AudioRepeat          : Qt.Key = ... # 0x1000103
        Key_AudioRandomPlay      : Qt.Key = ... # 0x1000104
        Key_Subtitle             : Qt.Key = ... # 0x1000105
        Key_AudioCycleTrack      : Qt.Key = ... # 0x1000106
        Key_Time                 : Qt.Key = ... # 0x1000107
        Key_Hibernate            : Qt.Key = ... # 0x1000108
        Key_View                 : Qt.Key = ... # 0x1000109
        Key_TopMenu              : Qt.Key = ... # 0x100010a
        Key_PowerDown            : Qt.Key = ... # 0x100010b
        Key_Suspend              : Qt.Key = ... # 0x100010c
        Key_ContrastAdjust       : Qt.Key = ... # 0x100010d
        Key_LaunchG              : Qt.Key = ... # 0x100010e
        Key_LaunchH              : Qt.Key = ... # 0x100010f
        Key_TouchpadToggle       : Qt.Key = ... # 0x1000110
        Key_TouchpadOn           : Qt.Key = ... # 0x1000111
        Key_TouchpadOff          : Qt.Key = ... # 0x1000112
        Key_MicMute              : Qt.Key = ... # 0x1000113
        Key_Red                  : Qt.Key = ... # 0x1000114
        Key_Green                : Qt.Key = ... # 0x1000115
        Key_Yellow               : Qt.Key = ... # 0x1000116
        Key_Blue                 : Qt.Key = ... # 0x1000117
        Key_ChannelUp            : Qt.Key = ... # 0x1000118
        Key_ChannelDown          : Qt.Key = ... # 0x1000119
        Key_Guide                : Qt.Key = ... # 0x100011a
        Key_Info                 : Qt.Key = ... # 0x100011b
        Key_Settings             : Qt.Key = ... # 0x100011c
        Key_MicVolumeUp          : Qt.Key = ... # 0x100011d
        Key_MicVolumeDown        : Qt.Key = ... # 0x100011e
        Key_New                  : Qt.Key = ... # 0x1000120
        Key_Open                 : Qt.Key = ... # 0x1000121
        Key_Find                 : Qt.Key = ... # 0x1000122
        Key_Undo                 : Qt.Key = ... # 0x1000123
        Key_Redo                 : Qt.Key = ... # 0x1000124
        Key_AltGr                : Qt.Key = ... # 0x1001103
        Key_Multi_key            : Qt.Key = ... # 0x1001120
        Key_Kanji                : Qt.Key = ... # 0x1001121
        Key_Muhenkan             : Qt.Key = ... # 0x1001122
        Key_Henkan               : Qt.Key = ... # 0x1001123
        Key_Romaji               : Qt.Key = ... # 0x1001124
        Key_Hiragana             : Qt.Key = ... # 0x1001125
        Key_Katakana             : Qt.Key = ... # 0x1001126
        Key_Hiragana_Katakana    : Qt.Key = ... # 0x1001127
        Key_Zenkaku              : Qt.Key = ... # 0x1001128
        Key_Hankaku              : Qt.Key = ... # 0x1001129
        Key_Zenkaku_Hankaku      : Qt.Key = ... # 0x100112a
        Key_Touroku              : Qt.Key = ... # 0x100112b
        Key_Massyo               : Qt.Key = ... # 0x100112c
        Key_Kana_Lock            : Qt.Key = ... # 0x100112d
        Key_Kana_Shift           : Qt.Key = ... # 0x100112e
        Key_Eisu_Shift           : Qt.Key = ... # 0x100112f
        Key_Eisu_toggle          : Qt.Key = ... # 0x1001130
        Key_Hangul               : Qt.Key = ... # 0x1001131
        Key_Hangul_Start         : Qt.Key = ... # 0x1001132
        Key_Hangul_End           : Qt.Key = ... # 0x1001133
        Key_Hangul_Hanja         : Qt.Key = ... # 0x1001134
        Key_Hangul_Jamo          : Qt.Key = ... # 0x1001135
        Key_Hangul_Romaja        : Qt.Key = ... # 0x1001136
        Key_Codeinput            : Qt.Key = ... # 0x1001137
        Key_Hangul_Jeonja        : Qt.Key = ... # 0x1001138
        Key_Hangul_Banja         : Qt.Key = ... # 0x1001139
        Key_Hangul_PreHanja      : Qt.Key = ... # 0x100113a
        Key_Hangul_PostHanja     : Qt.Key = ... # 0x100113b
        Key_SingleCandidate      : Qt.Key = ... # 0x100113c
        Key_MultipleCandidate    : Qt.Key = ... # 0x100113d
        Key_PreviousCandidate    : Qt.Key = ... # 0x100113e
        Key_Hangul_Special       : Qt.Key = ... # 0x100113f
        Key_Mode_switch          : Qt.Key = ... # 0x100117e
        Key_Dead_Grave           : Qt.Key = ... # 0x1001250
        Key_Dead_Acute           : Qt.Key = ... # 0x1001251
        Key_Dead_Circumflex      : Qt.Key = ... # 0x1001252
        Key_Dead_Tilde           : Qt.Key = ... # 0x1001253
        Key_Dead_Macron          : Qt.Key = ... # 0x1001254
        Key_Dead_Breve           : Qt.Key = ... # 0x1001255
        Key_Dead_Abovedot        : Qt.Key = ... # 0x1001256
        Key_Dead_Diaeresis       : Qt.Key = ... # 0x1001257
        Key_Dead_Abovering       : Qt.Key = ... # 0x1001258
        Key_Dead_Doubleacute     : Qt.Key = ... # 0x1001259
        Key_Dead_Caron           : Qt.Key = ... # 0x100125a
        Key_Dead_Cedilla         : Qt.Key = ... # 0x100125b
        Key_Dead_Ogonek          : Qt.Key = ... # 0x100125c
        Key_Dead_Iota            : Qt.Key = ... # 0x100125d
        Key_Dead_Voiced_Sound    : Qt.Key = ... # 0x100125e
        Key_Dead_Semivoiced_Sound: Qt.Key = ... # 0x100125f
        Key_Dead_Belowdot        : Qt.Key = ... # 0x1001260
        Key_Dead_Hook            : Qt.Key = ... # 0x1001261
        Key_Dead_Horn            : Qt.Key = ... # 0x1001262
        Key_Dead_Stroke          : Qt.Key = ... # 0x1001263
        Key_Dead_Abovecomma      : Qt.Key = ... # 0x1001264
        Key_Dead_Abovereversedcomma: Qt.Key = ... # 0x1001265
        Key_Dead_Doublegrave     : Qt.Key = ... # 0x1001266
        Key_Dead_Belowring       : Qt.Key = ... # 0x1001267
        Key_Dead_Belowmacron     : Qt.Key = ... # 0x1001268
        Key_Dead_Belowcircumflex : Qt.Key = ... # 0x1001269
        Key_Dead_Belowtilde      : Qt.Key = ... # 0x100126a
        Key_Dead_Belowbreve      : Qt.Key = ... # 0x100126b
        Key_Dead_Belowdiaeresis  : Qt.Key = ... # 0x100126c
        Key_Dead_Invertedbreve   : Qt.Key = ... # 0x100126d
        Key_Dead_Belowcomma      : Qt.Key = ... # 0x100126e
        Key_Dead_Currency        : Qt.Key = ... # 0x100126f
        Key_Dead_a               : Qt.Key = ... # 0x1001280
        Key_Dead_A               : Qt.Key = ... # 0x1001281
        Key_Dead_e               : Qt.Key = ... # 0x1001282
        Key_Dead_E               : Qt.Key = ... # 0x1001283
        Key_Dead_i               : Qt.Key = ... # 0x1001284
        Key_Dead_I               : Qt.Key = ... # 0x1001285
        Key_Dead_o               : Qt.Key = ... # 0x1001286
        Key_Dead_O               : Qt.Key = ... # 0x1001287
        Key_Dead_u               : Qt.Key = ... # 0x1001288
        Key_Dead_U               : Qt.Key = ... # 0x1001289
        Key_Dead_Small_Schwa     : Qt.Key = ... # 0x100128a
        Key_Dead_Capital_Schwa   : Qt.Key = ... # 0x100128b
        Key_Dead_Greek           : Qt.Key = ... # 0x100128c
        Key_Dead_Lowline         : Qt.Key = ... # 0x1001290
        Key_Dead_Aboveverticalline: Qt.Key = ... # 0x1001291
        Key_Dead_Belowverticalline: Qt.Key = ... # 0x1001292
        Key_Dead_Longsolidusoverlay: Qt.Key = ... # 0x1001293
        Key_MediaLast            : Qt.Key = ... # 0x100ffff
        Key_Select               : Qt.Key = ... # 0x1010000
        Key_Yes                  : Qt.Key = ... # 0x1010001
        Key_No                   : Qt.Key = ... # 0x1010002
        Key_Cancel               : Qt.Key = ... # 0x1020001
        Key_Printer              : Qt.Key = ... # 0x1020002
        Key_Execute              : Qt.Key = ... # 0x1020003
        Key_Sleep                : Qt.Key = ... # 0x1020004
        Key_Play                 : Qt.Key = ... # 0x1020005
        Key_Zoom                 : Qt.Key = ... # 0x1020006
        Key_Exit                 : Qt.Key = ... # 0x102000a
        Key_Context1             : Qt.Key = ... # 0x1100000
        Key_Context2             : Qt.Key = ... # 0x1100001
        Key_Context3             : Qt.Key = ... # 0x1100002
        Key_Context4             : Qt.Key = ... # 0x1100003
        Key_Call                 : Qt.Key = ... # 0x1100004
        Key_Hangup               : Qt.Key = ... # 0x1100005
        Key_Flip                 : Qt.Key = ... # 0x1100006
        Key_ToggleCallHangup     : Qt.Key = ... # 0x1100007
        Key_VoiceDial            : Qt.Key = ... # 0x1100008
        Key_LastNumberRedial     : Qt.Key = ... # 0x1100009
        Key_Camera               : Qt.Key = ... # 0x1100020
        Key_CameraFocus          : Qt.Key = ... # 0x1100021
        Key_unknown              : Qt.Key = ... # 0x1ffffff

    class KeyboardModifier(object):
        KeyboardModifierMask     : Qt.KeyboardModifier = ... # -0x2000000
        NoModifier               : Qt.KeyboardModifier = ... # 0x0
        ShiftModifier            : Qt.KeyboardModifier = ... # 0x2000000
        ControlModifier          : Qt.KeyboardModifier = ... # 0x4000000
        AltModifier              : Qt.KeyboardModifier = ... # 0x8000000
        MetaModifier             : Qt.KeyboardModifier = ... # 0x10000000
        KeypadModifier           : Qt.KeyboardModifier = ... # 0x20000000
        GroupSwitchModifier      : Qt.KeyboardModifier = ... # 0x40000000

    class KeyboardModifiers(object): ...

    class LayoutDirection(object):
        LeftToRight              : Qt.LayoutDirection = ... # 0x0
        RightToLeft              : Qt.LayoutDirection = ... # 0x1
        LayoutDirectionAuto      : Qt.LayoutDirection = ... # 0x2

    class MaskMode(object):
        MaskInColor              : Qt.MaskMode = ... # 0x0
        MaskOutColor             : Qt.MaskMode = ... # 0x1

    class MatchFlag(object):
        MatchExactly             : Qt.MatchFlag = ... # 0x0
        MatchContains            : Qt.MatchFlag = ... # 0x1
        MatchStartsWith          : Qt.MatchFlag = ... # 0x2
        MatchEndsWith            : Qt.MatchFlag = ... # 0x3
        MatchRegularExpression   : Qt.MatchFlag = ... # 0x4
        MatchWildcard            : Qt.MatchFlag = ... # 0x5
        MatchFixedString         : Qt.MatchFlag = ... # 0x8
        MatchCaseSensitive       : Qt.MatchFlag = ... # 0x10
        MatchWrap                : Qt.MatchFlag = ... # 0x20
        MatchRecursive           : Qt.MatchFlag = ... # 0x40

    class MatchFlags(object): ...

    class Modifier(object):
        MODIFIER_MASK            : Qt.Modifier = ... # -0x2000000
        SHIFT                    : Qt.Modifier = ... # 0x2000000
        CTRL                     : Qt.Modifier = ... # 0x4000000
        ALT                      : Qt.Modifier = ... # 0x8000000
        META                     : Qt.Modifier = ... # 0x10000000

    class MouseButton(object):
        MouseButtonMask          : Qt.MouseButton = ... # -0x1
        NoButton                 : Qt.MouseButton = ... # 0x0
        LeftButton               : Qt.MouseButton = ... # 0x1
        RightButton              : Qt.MouseButton = ... # 0x2
        MiddleButton             : Qt.MouseButton = ... # 0x4
        BackButton               : Qt.MouseButton = ... # 0x8
        ExtraButton1             : Qt.MouseButton = ... # 0x8
        XButton1                 : Qt.MouseButton = ... # 0x8
        ExtraButton2             : Qt.MouseButton = ... # 0x10
        ForwardButton            : Qt.MouseButton = ... # 0x10
        XButton2                 : Qt.MouseButton = ... # 0x10
        ExtraButton3             : Qt.MouseButton = ... # 0x20
        TaskButton               : Qt.MouseButton = ... # 0x20
        ExtraButton4             : Qt.MouseButton = ... # 0x40
        ExtraButton5             : Qt.MouseButton = ... # 0x80
        ExtraButton6             : Qt.MouseButton = ... # 0x100
        ExtraButton7             : Qt.MouseButton = ... # 0x200
        ExtraButton8             : Qt.MouseButton = ... # 0x400
        ExtraButton9             : Qt.MouseButton = ... # 0x800
        ExtraButton10            : Qt.MouseButton = ... # 0x1000
        ExtraButton11            : Qt.MouseButton = ... # 0x2000
        ExtraButton12            : Qt.MouseButton = ... # 0x4000
        ExtraButton13            : Qt.MouseButton = ... # 0x8000
        ExtraButton14            : Qt.MouseButton = ... # 0x10000
        ExtraButton15            : Qt.MouseButton = ... # 0x20000
        ExtraButton16            : Qt.MouseButton = ... # 0x40000
        ExtraButton17            : Qt.MouseButton = ... # 0x80000
        ExtraButton18            : Qt.MouseButton = ... # 0x100000
        ExtraButton19            : Qt.MouseButton = ... # 0x200000
        ExtraButton20            : Qt.MouseButton = ... # 0x400000
        ExtraButton21            : Qt.MouseButton = ... # 0x800000
        ExtraButton22            : Qt.MouseButton = ... # 0x1000000
        ExtraButton23            : Qt.MouseButton = ... # 0x2000000
        ExtraButton24            : Qt.MouseButton = ... # 0x4000000
        MaxMouseButton           : Qt.MouseButton = ... # 0x4000000
        AllButtons               : Qt.MouseButton = ... # 0x7ffffff

    class MouseButtons(object): ...

    class MouseEventFlag(object):
        NoMouseEventFlag         : Qt.MouseEventFlag = ... # 0x0
        MouseEventCreatedDoubleClick: Qt.MouseEventFlag = ... # 0x1
        MouseEventFlagMask       : Qt.MouseEventFlag = ... # 0xff

    class MouseEventFlags(object): ...

    class MouseEventSource(object):
        MouseEventNotSynthesized : Qt.MouseEventSource = ... # 0x0
        MouseEventSynthesizedBySystem: Qt.MouseEventSource = ... # 0x1
        MouseEventSynthesizedByQt: Qt.MouseEventSource = ... # 0x2
        MouseEventSynthesizedByApplication: Qt.MouseEventSource = ... # 0x3

    class NativeGestureType(object):
        BeginNativeGesture       : Qt.NativeGestureType = ... # 0x0
        EndNativeGesture         : Qt.NativeGestureType = ... # 0x1
        PanNativeGesture         : Qt.NativeGestureType = ... # 0x2
        ZoomNativeGesture        : Qt.NativeGestureType = ... # 0x3
        SmartZoomNativeGesture   : Qt.NativeGestureType = ... # 0x4
        RotateNativeGesture      : Qt.NativeGestureType = ... # 0x5
        SwipeNativeGesture       : Qt.NativeGestureType = ... # 0x6

    class NavigationMode(object):
        NavigationModeNone       : Qt.NavigationMode = ... # 0x0
        NavigationModeKeypadTabOrder: Qt.NavigationMode = ... # 0x1
        NavigationModeKeypadDirectional: Qt.NavigationMode = ... # 0x2
        NavigationModeCursorAuto : Qt.NavigationMode = ... # 0x3
        NavigationModeCursorForceVisible: Qt.NavigationMode = ... # 0x4

    class Orientation(object):
        Horizontal               : Qt.Orientation = ... # 0x1
        Vertical                 : Qt.Orientation = ... # 0x2

    class Orientations(object): ...

    class PenCapStyle(object):
        FlatCap                  : Qt.PenCapStyle = ... # 0x0
        SquareCap                : Qt.PenCapStyle = ... # 0x10
        RoundCap                 : Qt.PenCapStyle = ... # 0x20
        MPenCapStyle             : Qt.PenCapStyle = ... # 0x30

    class PenJoinStyle(object):
        MiterJoin                : Qt.PenJoinStyle = ... # 0x0
        BevelJoin                : Qt.PenJoinStyle = ... # 0x40
        RoundJoin                : Qt.PenJoinStyle = ... # 0x80
        SvgMiterJoin             : Qt.PenJoinStyle = ... # 0x100
        MPenJoinStyle            : Qt.PenJoinStyle = ... # 0x1c0

    class PenStyle(object):
        NoPen                    : Qt.PenStyle = ... # 0x0
        SolidLine                : Qt.PenStyle = ... # 0x1
        DashLine                 : Qt.PenStyle = ... # 0x2
        DotLine                  : Qt.PenStyle = ... # 0x3
        DashDotLine              : Qt.PenStyle = ... # 0x4
        DashDotDotLine           : Qt.PenStyle = ... # 0x5
        CustomDashLine           : Qt.PenStyle = ... # 0x6
        MPenStyle                : Qt.PenStyle = ... # 0xf

    class ReturnByValueConstant(object):
        ReturnByValue            : Qt.ReturnByValueConstant = ... # 0x0

    class ScreenOrientation(object):
        PrimaryOrientation       : Qt.ScreenOrientation = ... # 0x0
        PortraitOrientation      : Qt.ScreenOrientation = ... # 0x1
        LandscapeOrientation     : Qt.ScreenOrientation = ... # 0x2
        InvertedPortraitOrientation: Qt.ScreenOrientation = ... # 0x4
        InvertedLandscapeOrientation: Qt.ScreenOrientation = ... # 0x8

    class ScreenOrientations(object): ...

    class ScrollBarPolicy(object):
        ScrollBarAsNeeded        : Qt.ScrollBarPolicy = ... # 0x0
        ScrollBarAlwaysOff       : Qt.ScrollBarPolicy = ... # 0x1
        ScrollBarAlwaysOn        : Qt.ScrollBarPolicy = ... # 0x2

    class ScrollPhase(object):
        NoScrollPhase            : Qt.ScrollPhase = ... # 0x0
        ScrollBegin              : Qt.ScrollPhase = ... # 0x1
        ScrollUpdate             : Qt.ScrollPhase = ... # 0x2
        ScrollEnd                : Qt.ScrollPhase = ... # 0x3
        ScrollMomentum           : Qt.ScrollPhase = ... # 0x4

    class ShortcutContext(object):
        WidgetShortcut           : Qt.ShortcutContext = ... # 0x0
        WindowShortcut           : Qt.ShortcutContext = ... # 0x1
        ApplicationShortcut      : Qt.ShortcutContext = ... # 0x2
        WidgetWithChildrenShortcut: Qt.ShortcutContext = ... # 0x3

    class SizeHint(object):
        MinimumSize              : Qt.SizeHint = ... # 0x0
        PreferredSize            : Qt.SizeHint = ... # 0x1
        MaximumSize              : Qt.SizeHint = ... # 0x2
        MinimumDescent           : Qt.SizeHint = ... # 0x3
        NSizeHints               : Qt.SizeHint = ... # 0x4

    class SizeMode(object):
        AbsoluteSize             : Qt.SizeMode = ... # 0x0
        RelativeSize             : Qt.SizeMode = ... # 0x1

    class SortOrder(object):
        AscendingOrder           : Qt.SortOrder = ... # 0x0
        DescendingOrder          : Qt.SortOrder = ... # 0x1

    class SplitBehavior(object): ...

    class SplitBehaviorFlags(object):
        KeepEmptyParts           : Qt.SplitBehaviorFlags = ... # 0x0
        SkipEmptyParts           : Qt.SplitBehaviorFlags = ... # 0x1

    class TabFocusBehavior(object):
        NoTabFocus               : Qt.TabFocusBehavior = ... # 0x0
        TabFocusTextControls     : Qt.TabFocusBehavior = ... # 0x1
        TabFocusListControls     : Qt.TabFocusBehavior = ... # 0x2
        TabFocusAllControls      : Qt.TabFocusBehavior = ... # 0xff

    class TextElideMode(object):
        ElideLeft                : Qt.TextElideMode = ... # 0x0
        ElideRight               : Qt.TextElideMode = ... # 0x1
        ElideMiddle              : Qt.TextElideMode = ... # 0x2
        ElideNone                : Qt.TextElideMode = ... # 0x3

    class TextFlag(object):
        TextSingleLine           : Qt.TextFlag = ... # 0x100
        TextDontClip             : Qt.TextFlag = ... # 0x200
        TextExpandTabs           : Qt.TextFlag = ... # 0x400
        TextShowMnemonic         : Qt.TextFlag = ... # 0x800
        TextWordWrap             : Qt.TextFlag = ... # 0x1000
        TextWrapAnywhere         : Qt.TextFlag = ... # 0x2000
        TextDontPrint            : Qt.TextFlag = ... # 0x4000
        TextHideMnemonic         : Qt.TextFlag = ... # 0x8000
        TextJustificationForced  : Qt.TextFlag = ... # 0x10000
        TextForceLeftToRight     : Qt.TextFlag = ... # 0x20000
        TextForceRightToLeft     : Qt.TextFlag = ... # 0x40000
        TextLongestVariant       : Qt.TextFlag = ... # 0x80000
        TextIncludeTrailingSpaces: Qt.TextFlag = ... # 0x8000000

    class TextFormat(object):
        PlainText                : Qt.TextFormat = ... # 0x0
        RichText                 : Qt.TextFormat = ... # 0x1
        AutoText                 : Qt.TextFormat = ... # 0x2
        MarkdownText             : Qt.TextFormat = ... # 0x3

    class TextInteractionFlag(object):
        NoTextInteraction        : Qt.TextInteractionFlag = ... # 0x0
        TextSelectableByMouse    : Qt.TextInteractionFlag = ... # 0x1
        TextSelectableByKeyboard : Qt.TextInteractionFlag = ... # 0x2
        LinksAccessibleByMouse   : Qt.TextInteractionFlag = ... # 0x4
        LinksAccessibleByKeyboard: Qt.TextInteractionFlag = ... # 0x8
        TextBrowserInteraction   : Qt.TextInteractionFlag = ... # 0xd
        TextEditable             : Qt.TextInteractionFlag = ... # 0x10
        TextEditorInteraction    : Qt.TextInteractionFlag = ... # 0x13

    class TextInteractionFlags(object): ...

    class TileRule(object):
        StretchTile              : Qt.TileRule = ... # 0x0
        RepeatTile               : Qt.TileRule = ... # 0x1
        RoundTile                : Qt.TileRule = ... # 0x2

    class TimeSpec(object):
        LocalTime                : Qt.TimeSpec = ... # 0x0
        UTC                      : Qt.TimeSpec = ... # 0x1
        OffsetFromUTC            : Qt.TimeSpec = ... # 0x2
        TimeZone                 : Qt.TimeSpec = ... # 0x3

    class TimerType(object):
        PreciseTimer             : Qt.TimerType = ... # 0x0
        CoarseTimer              : Qt.TimerType = ... # 0x1
        VeryCoarseTimer          : Qt.TimerType = ... # 0x2

    class ToolBarArea(object):
        NoToolBarArea            : Qt.ToolBarArea = ... # 0x0
        LeftToolBarArea          : Qt.ToolBarArea = ... # 0x1
        RightToolBarArea         : Qt.ToolBarArea = ... # 0x2
        TopToolBarArea           : Qt.ToolBarArea = ... # 0x4
        BottomToolBarArea        : Qt.ToolBarArea = ... # 0x8
        AllToolBarAreas          : Qt.ToolBarArea = ... # 0xf
        ToolBarArea_Mask         : Qt.ToolBarArea = ... # 0xf

    class ToolBarAreaSizes(object):
        NToolBarAreas            : Qt.ToolBarAreaSizes = ... # 0x4

    class ToolBarAreas(object): ...

    class ToolButtonStyle(object):
        ToolButtonIconOnly       : Qt.ToolButtonStyle = ... # 0x0
        ToolButtonTextOnly       : Qt.ToolButtonStyle = ... # 0x1
        ToolButtonTextBesideIcon : Qt.ToolButtonStyle = ... # 0x2
        ToolButtonTextUnderIcon  : Qt.ToolButtonStyle = ... # 0x3
        ToolButtonFollowStyle    : Qt.ToolButtonStyle = ... # 0x4

    class TouchPointState(object):
        TouchPointUnknownState   : Qt.TouchPointState = ... # 0x0
        TouchPointPressed        : Qt.TouchPointState = ... # 0x1
        TouchPointMoved          : Qt.TouchPointState = ... # 0x2
        TouchPointStationary     : Qt.TouchPointState = ... # 0x4
        TouchPointReleased       : Qt.TouchPointState = ... # 0x8

    class TouchPointStates(object): ...

    class TransformationMode(object):
        FastTransformation       : Qt.TransformationMode = ... # 0x0
        SmoothTransformation     : Qt.TransformationMode = ... # 0x1

    class UIEffect(object):
        UI_General               : Qt.UIEffect = ... # 0x0
        UI_AnimateMenu           : Qt.UIEffect = ... # 0x1
        UI_FadeMenu              : Qt.UIEffect = ... # 0x2
        UI_AnimateCombo          : Qt.UIEffect = ... # 0x3
        UI_AnimateTooltip        : Qt.UIEffect = ... # 0x4
        UI_FadeTooltip           : Qt.UIEffect = ... # 0x5
        UI_AnimateToolBox        : Qt.UIEffect = ... # 0x6

    class WhiteSpaceMode(object):
        WhiteSpaceModeUndefined  : Qt.WhiteSpaceMode = ... # -0x1
        WhiteSpaceNormal         : Qt.WhiteSpaceMode = ... # 0x0
        WhiteSpacePre            : Qt.WhiteSpaceMode = ... # 0x1
        WhiteSpaceNoWrap         : Qt.WhiteSpaceMode = ... # 0x2

    class WidgetAttribute(object):
        WA_Disabled              : Qt.WidgetAttribute = ... # 0x0
        WA_UnderMouse            : Qt.WidgetAttribute = ... # 0x1
        WA_MouseTracking         : Qt.WidgetAttribute = ... # 0x2
        WA_OpaquePaintEvent      : Qt.WidgetAttribute = ... # 0x4
        WA_StaticContents        : Qt.WidgetAttribute = ... # 0x5
        WA_LaidOut               : Qt.WidgetAttribute = ... # 0x7
        WA_PaintOnScreen         : Qt.WidgetAttribute = ... # 0x8
        WA_NoSystemBackground    : Qt.WidgetAttribute = ... # 0x9
        WA_UpdatesDisabled       : Qt.WidgetAttribute = ... # 0xa
        WA_Mapped                : Qt.WidgetAttribute = ... # 0xb
        WA_InputMethodEnabled    : Qt.WidgetAttribute = ... # 0xe
        WA_WState_Visible        : Qt.WidgetAttribute = ... # 0xf
        WA_WState_Hidden         : Qt.WidgetAttribute = ... # 0x10
        WA_ForceDisabled         : Qt.WidgetAttribute = ... # 0x20
        WA_KeyCompression        : Qt.WidgetAttribute = ... # 0x21
        WA_PendingMoveEvent      : Qt.WidgetAttribute = ... # 0x22
        WA_PendingResizeEvent    : Qt.WidgetAttribute = ... # 0x23
        WA_SetPalette            : Qt.WidgetAttribute = ... # 0x24
        WA_SetFont               : Qt.WidgetAttribute = ... # 0x25
        WA_SetCursor             : Qt.WidgetAttribute = ... # 0x26
        WA_NoChildEventsFromChildren: Qt.WidgetAttribute = ... # 0x27
        WA_WindowModified        : Qt.WidgetAttribute = ... # 0x29
        WA_Resized               : Qt.WidgetAttribute = ... # 0x2a
        WA_Moved                 : Qt.WidgetAttribute = ... # 0x2b
        WA_PendingUpdate         : Qt.WidgetAttribute = ... # 0x2c
        WA_InvalidSize           : Qt.WidgetAttribute = ... # 0x2d
        WA_CustomWhatsThis       : Qt.WidgetAttribute = ... # 0x2f
        WA_LayoutOnEntireRect    : Qt.WidgetAttribute = ... # 0x30
        WA_OutsideWSRange        : Qt.WidgetAttribute = ... # 0x31
        WA_GrabbedShortcut       : Qt.WidgetAttribute = ... # 0x32
        WA_TransparentForMouseEvents: Qt.WidgetAttribute = ... # 0x33
        WA_PaintUnclipped        : Qt.WidgetAttribute = ... # 0x34
        WA_SetWindowIcon         : Qt.WidgetAttribute = ... # 0x35
        WA_NoMouseReplay         : Qt.WidgetAttribute = ... # 0x36
        WA_DeleteOnClose         : Qt.WidgetAttribute = ... # 0x37
        WA_RightToLeft           : Qt.WidgetAttribute = ... # 0x38
        WA_SetLayoutDirection    : Qt.WidgetAttribute = ... # 0x39
        WA_NoChildEventsForParent: Qt.WidgetAttribute = ... # 0x3a
        WA_ForceUpdatesDisabled  : Qt.WidgetAttribute = ... # 0x3b
        WA_WState_Created        : Qt.WidgetAttribute = ... # 0x3c
        WA_WState_CompressKeys   : Qt.WidgetAttribute = ... # 0x3d
        WA_WState_InPaintEvent   : Qt.WidgetAttribute = ... # 0x3e
        WA_WState_Reparented     : Qt.WidgetAttribute = ... # 0x3f
        WA_WState_ConfigPending  : Qt.WidgetAttribute = ... # 0x40
        WA_WState_Polished       : Qt.WidgetAttribute = ... # 0x42
        WA_WState_OwnSizePolicy  : Qt.WidgetAttribute = ... # 0x44
        WA_WState_ExplicitShowHide: Qt.WidgetAttribute = ... # 0x45
        WA_ShowModal             : Qt.WidgetAttribute = ... # 0x46
        WA_MouseNoMask           : Qt.WidgetAttribute = ... # 0x47
        WA_NoMousePropagation    : Qt.WidgetAttribute = ... # 0x49
        WA_Hover                 : Qt.WidgetAttribute = ... # 0x4a
        WA_InputMethodTransparent: Qt.WidgetAttribute = ... # 0x4b
        WA_QuitOnClose           : Qt.WidgetAttribute = ... # 0x4c
        WA_KeyboardFocusChange   : Qt.WidgetAttribute = ... # 0x4d
        WA_AcceptDrops           : Qt.WidgetAttribute = ... # 0x4e
        WA_DropSiteRegistered    : Qt.WidgetAttribute = ... # 0x4f
        WA_WindowPropagation     : Qt.WidgetAttribute = ... # 0x50
        WA_NoX11EventCompression : Qt.WidgetAttribute = ... # 0x51
        WA_TintedBackground      : Qt.WidgetAttribute = ... # 0x52
        WA_X11OpenGLOverlay      : Qt.WidgetAttribute = ... # 0x53
        WA_AlwaysShowToolTips    : Qt.WidgetAttribute = ... # 0x54
        WA_MacOpaqueSizeGrip     : Qt.WidgetAttribute = ... # 0x55
        WA_SetStyle              : Qt.WidgetAttribute = ... # 0x56
        WA_SetLocale             : Qt.WidgetAttribute = ... # 0x57
        WA_MacShowFocusRect      : Qt.WidgetAttribute = ... # 0x58
        WA_MacNormalSize         : Qt.WidgetAttribute = ... # 0x59
        WA_MacSmallSize          : Qt.WidgetAttribute = ... # 0x5a
        WA_MacMiniSize           : Qt.WidgetAttribute = ... # 0x5b
        WA_LayoutUsesWidgetRect  : Qt.WidgetAttribute = ... # 0x5c
        WA_StyledBackground      : Qt.WidgetAttribute = ... # 0x5d
        WA_CanHostQMdiSubWindowTitleBar: Qt.WidgetAttribute = ... # 0x5f
        WA_MacAlwaysShowToolWindow: Qt.WidgetAttribute = ... # 0x60
        WA_StyleSheet            : Qt.WidgetAttribute = ... # 0x61
        WA_ShowWithoutActivating : Qt.WidgetAttribute = ... # 0x62
        WA_X11BypassTransientForHint: Qt.WidgetAttribute = ... # 0x63
        WA_NativeWindow          : Qt.WidgetAttribute = ... # 0x64
        WA_DontCreateNativeAncestors: Qt.WidgetAttribute = ... # 0x65
        WA_DontShowOnScreen      : Qt.WidgetAttribute = ... # 0x67
        WA_X11NetWmWindowTypeDesktop: Qt.WidgetAttribute = ... # 0x68
        WA_X11NetWmWindowTypeDock: Qt.WidgetAttribute = ... # 0x69
        WA_X11NetWmWindowTypeToolBar: Qt.WidgetAttribute = ... # 0x6a
        WA_X11NetWmWindowTypeMenu: Qt.WidgetAttribute = ... # 0x6b
        WA_X11NetWmWindowTypeUtility: Qt.WidgetAttribute = ... # 0x6c
        WA_X11NetWmWindowTypeSplash: Qt.WidgetAttribute = ... # 0x6d
        WA_X11NetWmWindowTypeDialog: Qt.WidgetAttribute = ... # 0x6e
        WA_X11NetWmWindowTypeDropDownMenu: Qt.WidgetAttribute = ... # 0x6f
        WA_X11NetWmWindowTypePopupMenu: Qt.WidgetAttribute = ... # 0x70
        WA_X11NetWmWindowTypeToolTip: Qt.WidgetAttribute = ... # 0x71
        WA_X11NetWmWindowTypeNotification: Qt.WidgetAttribute = ... # 0x72
        WA_X11NetWmWindowTypeCombo: Qt.WidgetAttribute = ... # 0x73
        WA_X11NetWmWindowTypeDND : Qt.WidgetAttribute = ... # 0x74
        WA_SetWindowModality     : Qt.WidgetAttribute = ... # 0x76
        WA_WState_WindowOpacitySet: Qt.WidgetAttribute = ... # 0x77
        WA_TranslucentBackground : Qt.WidgetAttribute = ... # 0x78
        WA_AcceptTouchEvents     : Qt.WidgetAttribute = ... # 0x79
        WA_WState_AcceptedTouchBeginEvent: Qt.WidgetAttribute = ... # 0x7a
        WA_TouchPadAcceptSingleTouchEvents: Qt.WidgetAttribute = ... # 0x7b
        WA_X11DoNotAcceptFocus   : Qt.WidgetAttribute = ... # 0x7e
        WA_AlwaysStackOnTop      : Qt.WidgetAttribute = ... # 0x80
        WA_TabletTracking        : Qt.WidgetAttribute = ... # 0x81
        WA_ContentsMarginsRespectsSafeArea: Qt.WidgetAttribute = ... # 0x82
        WA_StyleSheetTarget      : Qt.WidgetAttribute = ... # 0x83
        WA_AttributeCount        : Qt.WidgetAttribute = ... # 0x84

    class WindowFlags(object): ...

    class WindowFrameSection(object):
        NoSection                : Qt.WindowFrameSection = ... # 0x0
        LeftSection              : Qt.WindowFrameSection = ... # 0x1
        TopLeftSection           : Qt.WindowFrameSection = ... # 0x2
        TopSection               : Qt.WindowFrameSection = ... # 0x3
        TopRightSection          : Qt.WindowFrameSection = ... # 0x4
        RightSection             : Qt.WindowFrameSection = ... # 0x5
        BottomRightSection       : Qt.WindowFrameSection = ... # 0x6
        BottomSection            : Qt.WindowFrameSection = ... # 0x7
        BottomLeftSection        : Qt.WindowFrameSection = ... # 0x8
        TitleBarArea             : Qt.WindowFrameSection = ... # 0x9

    class WindowModality(object):
        NonModal                 : Qt.WindowModality = ... # 0x0
        WindowModal              : Qt.WindowModality = ... # 0x1
        ApplicationModal         : Qt.WindowModality = ... # 0x2

    class WindowState(object):
        WindowNoState            : Qt.WindowState = ... # 0x0
        WindowMinimized          : Qt.WindowState = ... # 0x1
        WindowMaximized          : Qt.WindowState = ... # 0x2
        WindowFullScreen         : Qt.WindowState = ... # 0x4
        WindowActive             : Qt.WindowState = ... # 0x8

    class WindowStates(object): ...

    class WindowType(object):
        WindowFullscreenButtonHint: Qt.WindowType = ... # -0x80000000
        Widget                   : Qt.WindowType = ... # 0x0
        Window                   : Qt.WindowType = ... # 0x1
        Dialog                   : Qt.WindowType = ... # 0x3
        Sheet                    : Qt.WindowType = ... # 0x5
        Drawer                   : Qt.WindowType = ... # 0x7
        Popup                    : Qt.WindowType = ... # 0x9
        Tool                     : Qt.WindowType = ... # 0xb
        ToolTip                  : Qt.WindowType = ... # 0xd
        SplashScreen             : Qt.WindowType = ... # 0xf
        Desktop                  : Qt.WindowType = ... # 0x11
        SubWindow                : Qt.WindowType = ... # 0x12
        ForeignWindow            : Qt.WindowType = ... # 0x21
        CoverWindow              : Qt.WindowType = ... # 0x41
        WindowType_Mask          : Qt.WindowType = ... # 0xff
        MSWindowsFixedSizeDialogHint: Qt.WindowType = ... # 0x100
        MSWindowsOwnDC           : Qt.WindowType = ... # 0x200
        BypassWindowManagerHint  : Qt.WindowType = ... # 0x400
        X11BypassWindowManagerHint: Qt.WindowType = ... # 0x400
        FramelessWindowHint      : Qt.WindowType = ... # 0x800
        WindowTitleHint          : Qt.WindowType = ... # 0x1000
        WindowSystemMenuHint     : Qt.WindowType = ... # 0x2000
        WindowMinimizeButtonHint : Qt.WindowType = ... # 0x4000
        WindowMaximizeButtonHint : Qt.WindowType = ... # 0x8000
        WindowMinMaxButtonsHint  : Qt.WindowType = ... # 0xc000
        WindowContextHelpButtonHint: Qt.WindowType = ... # 0x10000
        WindowShadeButtonHint    : Qt.WindowType = ... # 0x20000
        WindowStaysOnTopHint     : Qt.WindowType = ... # 0x40000
        WindowTransparentForInput: Qt.WindowType = ... # 0x80000
        WindowOverridesSystemGestures: Qt.WindowType = ... # 0x100000
        WindowDoesNotAcceptFocus : Qt.WindowType = ... # 0x200000
        MaximizeUsingFullscreenGeometryHint: Qt.WindowType = ... # 0x400000
        CustomizeWindowHint      : Qt.WindowType = ... # 0x2000000
        WindowStaysOnBottomHint  : Qt.WindowType = ... # 0x4000000
        WindowCloseButtonHint    : Qt.WindowType = ... # 0x8000000
        MacWindowToolBarButtonHint: Qt.WindowType = ... # 0x10000000
        BypassGraphicsProxyWidget: Qt.WindowType = ... # 0x20000000
        NoDropShadowWindowHint   : Qt.WindowType = ... # 0x40000000
    @staticmethod
    def bin(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def bom(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def center(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def dec(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def endl(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def fixed(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def flush(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def forcepoint(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def forcesign(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def hex(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def left(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def lowercasebase(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def lowercasedigits(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def noforcepoint(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def noforcesign(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def noshowbase(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def oct(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def reset(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def right(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def scientific(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def showbase(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def uppercasebase(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def uppercasedigits(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def ws(s:PySide6.QtCore.QTextStream) -> PySide6.QtCore.QTextStream: ...


class QtMsgType(object):
    QtDebugMsg               : QtMsgType = ... # 0x0
    QtWarningMsg             : QtMsgType = ... # 0x1
    QtCriticalMsg            : QtMsgType = ... # 0x2
    QtSystemMsg              : QtMsgType = ... # 0x2
    QtFatalMsg               : QtMsgType = ... # 0x3
    QtInfoMsg                : QtMsgType = ... # 0x4


class Signal(object):

    @staticmethod
    def __init__(*types:type, name:typing.Optional[str]=..., arguments:typing.Optional[str]=...) -> None: ...


class SignalInstance(object):
    @staticmethod
    def connect(slot:object, type:typing.Optional[type]=...) -> None: ...
    @staticmethod
    def disconnect(slot:object=...) -> None: ...
    @staticmethod
    def emit(*args:typing.Any) -> None: ...


class Slot(object):

    @staticmethod
    def __init__(*types:type, name:typing.Optional[str]=..., result:typing.Optional[str]=...) -> typing.Callable: ...

@staticmethod
def QEnum(arg__1:object) -> object: ...
@staticmethod
def QFlag(arg__1:object) -> object: ...
@staticmethod
def QT_TRANSLATE_NOOP(arg__1:object, arg__2:object) -> object: ...
@staticmethod
def QT_TRANSLATE_NOOP3(arg__1:object, arg__2:object, arg__3:object) -> object: ...
@staticmethod
def QT_TRANSLATE_NOOP_UTF8(arg__1:object) -> object: ...
@staticmethod
def QT_TR_NOOP(arg__1:object) -> object: ...
@staticmethod
def QT_TR_NOOP_UTF8(arg__1:object) -> object: ...
@staticmethod
def SIGNAL(arg__1:bytes) -> str: ...
@staticmethod
def SLOT(arg__1:bytes) -> str: ...
@staticmethod
def __init_feature__() -> None: ...
@staticmethod
def __moduleShutdown() -> None: ...
@staticmethod
def qAbs(arg__1:float) -> float: ...
@staticmethod
def qAddPostRoutine(arg__1:object) -> None: ...
@typing.overload
@staticmethod
def qCompress(data:PySide6.QtCore.QByteArray, compressionLevel:int=...) -> PySide6.QtCore.QByteArray: ...
@typing.overload
@staticmethod
def qCompress(data:bytes, nbytes:int, compressionLevel:int=...) -> PySide6.QtCore.QByteArray: ...
@staticmethod
def qCritical(arg__1:bytes) -> None: ...
@staticmethod
def qDebug(arg__1:bytes) -> None: ...
@staticmethod
def qFastCos(x:float) -> float: ...
@staticmethod
def qFastSin(x:float) -> float: ...
@staticmethod
def qFatal(arg__1:bytes) -> None: ...
@staticmethod
def qFuzzyCompare(p1:float, p2:float) -> bool: ...
@staticmethod
def qFuzzyIsNull(d:float) -> bool: ...
@staticmethod
def qInstallMessageHandler(arg__1:object) -> object: ...
@staticmethod
def qIsFinite(d:float) -> bool: ...
@staticmethod
def qIsInf(d:float) -> bool: ...
@staticmethod
def qIsNaN(d:float) -> bool: ...
@staticmethod
def qIsNull(d:float) -> bool: ...
@staticmethod
def qRegisterResourceData(arg__1:int, arg__2:bytes, arg__3:bytes, arg__4:bytes) -> bool: ...
@typing.overload
@staticmethod
def qUncompress(data:PySide6.QtCore.QByteArray) -> PySide6.QtCore.QByteArray: ...
@typing.overload
@staticmethod
def qUncompress(data:bytes, nbytes:int) -> PySide6.QtCore.QByteArray: ...
@staticmethod
def qUnregisterResourceData(arg__1:int, arg__2:bytes, arg__3:bytes, arg__4:bytes) -> bool: ...
@staticmethod
def qVersion() -> bytes: ...
@staticmethod
def qWarning(arg__1:bytes) -> None: ...
@staticmethod
def qtTrId(id:bytes, n:int=...) -> str: ...

# eof
