from .tokensets import _token_set_register
from .tokenset_basic_v2 import TokenSet_BASICv2


_simons_basic_tokens = (
    ("HIRES", 0x01),
    ("PLOT", 0x02),
    ("LINE", 0x03),
    ("BLOCK", 0x04),
    ("FCHR", 0x05),
    ("FCOL", 0x06),
    ("FILL", 0x07),
    ("REC", 0x08),
    ("ROT", 0x09),
    ("DRAW", 0x0A),
    ("CHAR", 0x0B),
    ("HI COL", 0x0C),
    ("INV", 0x0D),
    ("FRAC", 0x0E),
    ("MOVE", 0x0F),
    ("PLACE", 0x10),
    ("UPB", 0x11),
    ("UPW", 0x12),
    ("LEFTW", 0x13),
    ("LEFTB", 0x14),
    ("DOWNB", 0x15),
    ("DOWNW", 0x16),
    ("RIGHTB", 0x17),
    ("RIGHTW", 0x18),
    ("MULTI", 0x19),
    ("COLOUR", 0x1A),
    ("MMOB", 0x1B),
    ("BFLASH", 0x1C),
    ("MOB SET", 0x1D),
    ("MUSIC", 0x1E),
    ("FLASH", 0x1F),
    ("REPEAT", 0x20),
    ("PLAY", 0x21),
    ("CENTRE", 0x23),
    ("ENVELOPE", 0x24),
    ("CGOTO", 0x25),
    ("WAVE", 0x26),
    ("FETCH", 0x27),
    ("AT(", 0x28),
    ("UNTIL", 0x29),
    ("USE", 0x2C),
    ("GLOBAL", 0x2E),
    ("RESET", 0x30),
    ("PROC", 0x31),
    ("CALL", 0x32),
    ("EXEC", 0x33),
    ("END PROC", 0x34),
    ("EXIT", 0x35),
    ("END LOOP", 0x36),
    ("ON KEY", 0x37),
    ("DISABLE", 0x38),
    ("RESUME", 0x39),
    ("LOOP", 0x3A),
    ("DELAY", 0x3B),
    ("SECURE", 0x40),
    ("DISAPA", 0x41),
    ("CIRCLE", 0x42),
    ("ON ERROR", 0x43),
    ("NO ERROR", 0x44),
    ("LOCAL", 0x45),
    ("RCOMP", 0x46),
    ("ELSE", 0x47),
    ("RETRACE", 0x48),
    ("TRACE", 0x49),
    ("DIR", 0x4A),
    ("PAGE", 0x4B),
    ("DUMP", 0x4C),
    ("FIND", 0x4D),
    ("OPTION", 0x4E),
    ("AUTO", 0x4F),
    ("OLD", 0x50),
    ("JOY", 0x51),
    ("MOD", 0x52),
    ("DIV", 0x53),
    ("DUP", 0x55),
    ("INKEY", 0x56),
    ("INST", 0x57),
    ("TEST", 0x58),
    ("LIN", 0x59),
    ("EXOR", 0x5A),
    ("INSERT", 0x5B),
    ("POT", 0x5C),
    ("PENX", 0x5D),
    ("PENY", 0x5F),
    ("SOUND", 0x60),
    ("GRAPHICS", 0x61),
    ("DESIGN", 0x62),
    ("RLOCMOB", 0x63),
    ("CMOB", 0x64),
    ("BCKGNDS", 0x65),
    ("PAUSE", 0x66),
    ("NRM", 0x67),
    ("MOB OFF", 0x68),
    ("OFF", 0x69),
    ("ANGL", 0x6A),
    ("ARC", 0x6B),
    ("COLD", 0x6C),
    ("SCRSV", 0x6D),
    ("SCRLD", 0x6E),
    ("TEXT", 0X6F),
    ("CSET", 0x70),
    ("VOL", 0x71),
    ("DISK", 0x72),
    ("HRDCPY", 0x73),
    ("KEY", 0x74),
    ("PAINT", 0x75),
    ("LOW COL", 0x76),
    ("COPY", 0x77),
    ("MERGE", 0x78),
    ("RENUMBER", 0x79),
    ("MEM", 0x7A),
    ("DETECT", 0x7B),
    ("CHECK", 0x7C),
    ("DISPLAY", 0x7D),
    ("ERR", 0x7E),
    ("OUT", 0x7F)
)


class TokenSet_Simons_BASIC(TokenSet_BASICv2):
    """Tokens used by Simons Basic (C64)."""
    def __init__(self):
        super().__init__()
        self.set_secondary_tokens(0x64, _simons_basic_tokens)


_token_set_register['simons-basic'] = TokenSet_Simons_BASIC()
