<a id="mypy-boto3-guardduty"></a>

# mypy-boto3-guardduty

[![PyPI - mypy-boto3-guardduty](https://img.shields.io/pypi/v/mypy-boto3-guardduty.svg?color=blue)](https://pypi.org/project/mypy-boto3-guardduty)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-guardduty.svg?color=blue)](https://pypi.org/project/mypy-boto3-guardduty)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-guardduty?color=blue)](https://pypistats.org/packages/mypy-boto3-guardduty)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.GuardDuty 1.18.8](https://boto3.amazonaws.com/v1/documentation/api/1.18.8/reference/services/guardduty.html#GuardDuty)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-guardduty docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_guardduty/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-guardduty](#mypy-boto3-guardduty)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `GuardDuty` service.

```bash
python -m pip install boto3-stubs[guardduty]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[guardduty]` in your environment:
  `python -m pip install 'boto3-stubs[guardduty]'`

Both type checking and auto-complete should work for `GuardDuty` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[guardduty]` in your environment:
  `python -m pip install 'boto3-stubs[guardduty]'`

Both type checking and auto-complete should work for `GuardDuty` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[guardduty]` in your environment:
  `python -m pip install 'boto3-stubs[guardduty]'`
- Run `mypy` as usual

Type checking should work for `GuardDuty` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[guardduty]` in your environment:
  `python -m pip install 'boto3-stubs[guardduty]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `GuardDuty` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`GuardDutyClient` provides annotations for `boto3.client("guardduty")`.

```python
import boto3

from mypy_boto3_guardduty import GuardDutyClient

client: GuardDutyClient = boto3.client("guardduty")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GuardDutyClient = session.client("guardduty")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_guardduty.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_guardduty import GuardDutyClient
from mypy_boto3_guardduty.paginator import (
    ListDetectorsPaginator,
    ListFiltersPaginator,
    ListFindingsPaginator,
    ListIPSetsPaginator,
    ListInvitationsPaginator,
    ListMembersPaginator,
    ListOrganizationAdminAccountsPaginator,
    ListThreatIntelSetsPaginator,
)

client: GuardDutyClient = boto3.client("guardduty")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_detectors_paginator: ListDetectorsPaginator = client.get_paginator("list_detectors")
list_filters_paginator: ListFiltersPaginator = client.get_paginator("list_filters")
list_findings_paginator: ListFindingsPaginator = client.get_paginator("list_findings")
list_ip_sets_paginator: ListIPSetsPaginator = client.get_paginator("list_ip_sets")
list_invitations_paginator: ListInvitationsPaginator = client.get_paginator("list_invitations")
list_members_paginator: ListMembersPaginator = client.get_paginator("list_members")
list_organization_admin_accounts_paginator: ListOrganizationAdminAccountsPaginator = client.get_paginator("list_organization_admin_accounts")
list_threat_intel_sets_paginator: ListThreatIntelSetsPaginator = client.get_paginator("list_threat_intel_sets")
```

<a id="literals"></a>

### Literals

`mypy_boto3_guardduty.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_guardduty.literals import (
    AdminStatusType,
    DataSourceStatusType,
    DataSourceType,
    DestinationTypeType,
    DetectorStatusType,
    FeedbackType,
    FilterActionType,
    FindingPublishingFrequencyType,
    FindingStatisticTypeType,
    IpSetFormatType,
    IpSetStatusType,
    ListDetectorsPaginatorName,
    ListFiltersPaginatorName,
    ListFindingsPaginatorName,
    ListIPSetsPaginatorName,
    ListInvitationsPaginatorName,
    ListMembersPaginatorName,
    ListOrganizationAdminAccountsPaginatorName,
    ListThreatIntelSetsPaginatorName,
    OrderByType,
    PublishingStatusType,
    ThreatIntelSetFormatType,
    ThreatIntelSetStatusType,
    UsageStatisticTypeType,
)

def check_value(value: AdminStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_guardduty.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_guardduty.type_defs import (
    AcceptInvitationRequestRequestTypeDef,
    AccessControlListTypeDef,
    AccessKeyDetailsTypeDef,
    AccountDetailTypeDef,
    AccountLevelPermissionsTypeDef,
    ActionTypeDef,
    AdminAccountTypeDef,
    ArchiveFindingsRequestRequestTypeDef,
    AwsApiCallActionTypeDef,
    BlockPublicAccessTypeDef,
    BucketLevelPermissionsTypeDef,
    BucketPolicyTypeDef,
    CityTypeDef,
    CloudTrailConfigurationResultTypeDef,
    ConditionTypeDef,
    CountryTypeDef,
    CreateDetectorRequestRequestTypeDef,
    CreateDetectorResponseTypeDef,
    CreateFilterRequestRequestTypeDef,
    CreateFilterResponseTypeDef,
    CreateIPSetRequestRequestTypeDef,
    CreateIPSetResponseTypeDef,
    CreateMembersRequestRequestTypeDef,
    CreateMembersResponseTypeDef,
    CreatePublishingDestinationRequestRequestTypeDef,
    CreatePublishingDestinationResponseTypeDef,
    CreateSampleFindingsRequestRequestTypeDef,
    CreateThreatIntelSetRequestRequestTypeDef,
    CreateThreatIntelSetResponseTypeDef,
    DNSLogsConfigurationResultTypeDef,
    DataSourceConfigurationsResultTypeDef,
    DataSourceConfigurationsTypeDef,
    DeclineInvitationsRequestRequestTypeDef,
    DeclineInvitationsResponseTypeDef,
    DefaultServerSideEncryptionTypeDef,
    DeleteDetectorRequestRequestTypeDef,
    DeleteFilterRequestRequestTypeDef,
    DeleteIPSetRequestRequestTypeDef,
    DeleteInvitationsRequestRequestTypeDef,
    DeleteInvitationsResponseTypeDef,
    DeleteMembersRequestRequestTypeDef,
    DeleteMembersResponseTypeDef,
    DeletePublishingDestinationRequestRequestTypeDef,
    DeleteThreatIntelSetRequestRequestTypeDef,
    DescribeOrganizationConfigurationRequestRequestTypeDef,
    DescribeOrganizationConfigurationResponseTypeDef,
    DescribePublishingDestinationRequestRequestTypeDef,
    DescribePublishingDestinationResponseTypeDef,
    DestinationPropertiesTypeDef,
    DestinationTypeDef,
    DisableOrganizationAdminAccountRequestRequestTypeDef,
    DisassociateFromMasterAccountRequestRequestTypeDef,
    DisassociateMembersRequestRequestTypeDef,
    DisassociateMembersResponseTypeDef,
    DnsRequestActionTypeDef,
    DomainDetailsTypeDef,
    EnableOrganizationAdminAccountRequestRequestTypeDef,
    EvidenceTypeDef,
    FindingCriteriaTypeDef,
    FindingStatisticsTypeDef,
    FindingTypeDef,
    FlowLogsConfigurationResultTypeDef,
    GeoLocationTypeDef,
    GetDetectorRequestRequestTypeDef,
    GetDetectorResponseTypeDef,
    GetFilterRequestRequestTypeDef,
    GetFilterResponseTypeDef,
    GetFindingsRequestRequestTypeDef,
    GetFindingsResponseTypeDef,
    GetFindingsStatisticsRequestRequestTypeDef,
    GetFindingsStatisticsResponseTypeDef,
    GetIPSetRequestRequestTypeDef,
    GetIPSetResponseTypeDef,
    GetInvitationsCountResponseTypeDef,
    GetMasterAccountRequestRequestTypeDef,
    GetMasterAccountResponseTypeDef,
    GetMemberDetectorsRequestRequestTypeDef,
    GetMemberDetectorsResponseTypeDef,
    GetMembersRequestRequestTypeDef,
    GetMembersResponseTypeDef,
    GetThreatIntelSetRequestRequestTypeDef,
    GetThreatIntelSetResponseTypeDef,
    GetUsageStatisticsRequestRequestTypeDef,
    GetUsageStatisticsResponseTypeDef,
    IamInstanceProfileTypeDef,
    InstanceDetailsTypeDef,
    InvitationTypeDef,
    InviteMembersRequestRequestTypeDef,
    InviteMembersResponseTypeDef,
    ListDetectorsRequestRequestTypeDef,
    ListDetectorsResponseTypeDef,
    ListFiltersRequestRequestTypeDef,
    ListFiltersResponseTypeDef,
    ListFindingsRequestRequestTypeDef,
    ListFindingsResponseTypeDef,
    ListIPSetsRequestRequestTypeDef,
    ListIPSetsResponseTypeDef,
    ListInvitationsRequestRequestTypeDef,
    ListInvitationsResponseTypeDef,
    ListMembersRequestRequestTypeDef,
    ListMembersResponseTypeDef,
    ListOrganizationAdminAccountsRequestRequestTypeDef,
    ListOrganizationAdminAccountsResponseTypeDef,
    ListPublishingDestinationsRequestRequestTypeDef,
    ListPublishingDestinationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListThreatIntelSetsRequestRequestTypeDef,
    ListThreatIntelSetsResponseTypeDef,
    LocalIpDetailsTypeDef,
    LocalPortDetailsTypeDef,
    MasterTypeDef,
    MemberDataSourceConfigurationTypeDef,
    MemberTypeDef,
    NetworkConnectionActionTypeDef,
    NetworkInterfaceTypeDef,
    OrganizationDataSourceConfigurationsResultTypeDef,
    OrganizationDataSourceConfigurationsTypeDef,
    OrganizationS3LogsConfigurationResultTypeDef,
    OrganizationS3LogsConfigurationTypeDef,
    OrganizationTypeDef,
    OwnerTypeDef,
    PaginatorConfigTypeDef,
    PermissionConfigurationTypeDef,
    PortProbeActionTypeDef,
    PortProbeDetailTypeDef,
    PrivateIpAddressDetailsTypeDef,
    ProductCodeTypeDef,
    PublicAccessTypeDef,
    RemoteIpDetailsTypeDef,
    RemotePortDetailsTypeDef,
    ResourceTypeDef,
    ResponseMetadataTypeDef,
    S3BucketDetailTypeDef,
    S3LogsConfigurationResultTypeDef,
    S3LogsConfigurationTypeDef,
    SecurityGroupTypeDef,
    ServiceTypeDef,
    SortCriteriaTypeDef,
    StartMonitoringMembersRequestRequestTypeDef,
    StartMonitoringMembersResponseTypeDef,
    StopMonitoringMembersRequestRequestTypeDef,
    StopMonitoringMembersResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    ThreatIntelligenceDetailTypeDef,
    TotalTypeDef,
    UnarchiveFindingsRequestRequestTypeDef,
    UnprocessedAccountTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateDetectorRequestRequestTypeDef,
    UpdateFilterRequestRequestTypeDef,
    UpdateFilterResponseTypeDef,
    UpdateFindingsFeedbackRequestRequestTypeDef,
    UpdateIPSetRequestRequestTypeDef,
    UpdateMemberDetectorsRequestRequestTypeDef,
    UpdateMemberDetectorsResponseTypeDef,
    UpdateOrganizationConfigurationRequestRequestTypeDef,
    UpdatePublishingDestinationRequestRequestTypeDef,
    UpdateThreatIntelSetRequestRequestTypeDef,
    UsageAccountResultTypeDef,
    UsageCriteriaTypeDef,
    UsageDataSourceResultTypeDef,
    UsageResourceResultTypeDef,
    UsageStatisticsTypeDef,
)

def get_structure() -> AcceptInvitationRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-guardduty` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-guardduty docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_guardduty/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
