# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificateAuthorityVersionResult',
    'AwaitableGetCertificateAuthorityVersionResult',
    'get_certificate_authority_version',
    'get_certificate_authority_version_output',
]

@pulumi.output_type
class GetCertificateAuthorityVersionResult:
    """
    A collection of values returned by getCertificateAuthorityVersion.
    """
    def __init__(__self__, certificate_authority_id=None, certificate_authority_version_number=None, id=None, issuer_ca_version_number=None, revocation_statuses=None, serial_number=None, stages=None, subject_alternative_names=None, time_created=None, time_of_deletion=None, validities=None, version_name=None, version_number=None):
        if certificate_authority_id and not isinstance(certificate_authority_id, str):
            raise TypeError("Expected argument 'certificate_authority_id' to be a str")
        pulumi.set(__self__, "certificate_authority_id", certificate_authority_id)
        if certificate_authority_version_number and not isinstance(certificate_authority_version_number, str):
            raise TypeError("Expected argument 'certificate_authority_version_number' to be a str")
        pulumi.set(__self__, "certificate_authority_version_number", certificate_authority_version_number)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer_ca_version_number and not isinstance(issuer_ca_version_number, str):
            raise TypeError("Expected argument 'issuer_ca_version_number' to be a str")
        pulumi.set(__self__, "issuer_ca_version_number", issuer_ca_version_number)
        if revocation_statuses and not isinstance(revocation_statuses, list):
            raise TypeError("Expected argument 'revocation_statuses' to be a list")
        pulumi.set(__self__, "revocation_statuses", revocation_statuses)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if stages and not isinstance(stages, list):
            raise TypeError("Expected argument 'stages' to be a list")
        pulumi.set(__self__, "stages", stages)
        if subject_alternative_names and not isinstance(subject_alternative_names, list):
            raise TypeError("Expected argument 'subject_alternative_names' to be a list")
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if validities and not isinstance(validities, list):
            raise TypeError("Expected argument 'validities' to be a list")
        pulumi.set(__self__, "validities", validities)
        if version_name and not isinstance(version_name, str):
            raise TypeError("Expected argument 'version_name' to be a str")
        pulumi.set(__self__, "version_name", version_name)
        if version_number and not isinstance(version_number, str):
            raise TypeError("Expected argument 'version_number' to be a str")
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> str:
        """
        The OCID of the CA.
        """
        return pulumi.get(self, "certificate_authority_id")

    @property
    @pulumi.getter(name="certificateAuthorityVersionNumber")
    def certificate_authority_version_number(self) -> str:
        return pulumi.get(self, "certificate_authority_version_number")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="issuerCaVersionNumber")
    def issuer_ca_version_number(self) -> str:
        """
        The version number of the issuing CA.
        """
        return pulumi.get(self, "issuer_ca_version_number")

    @property
    @pulumi.getter(name="revocationStatuses")
    def revocation_statuses(self) -> Sequence['outputs.GetCertificateAuthorityVersionRevocationStatusResult']:
        """
        The current revocation status of the entity.
        """
        return pulumi.get(self, "revocation_statuses")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        A unique certificate identifier used in certificate revocation tracking, formatted as octets. Example: `03 AC FC FA CC B3 CB 02 B8 F8 DE F5 85 E7 7B FF`
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def stages(self) -> Sequence[str]:
        """
        A list of rotation states for this CA version.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence['outputs.GetCertificateAuthorityVersionSubjectAlternativeNameResult']:
        return pulumi.get(self, "subject_alternative_names")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        A optional property indicating when the CA version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the CA version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter
    def validities(self) -> Sequence['outputs.GetCertificateAuthorityVersionValidityResult']:
        """
        An object that describes a period of time during which an entity is valid. If this is not provided when you create a certificate, the validity of the issuing CA is used.
        """
        return pulumi.get(self, "validities")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        The name of the CA version. When this value is not null, the name is unique across CA versions for a given CA.
        """
        return pulumi.get(self, "version_name")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> str:
        """
        The version number of the CA.
        """
        return pulumi.get(self, "version_number")


class AwaitableGetCertificateAuthorityVersionResult(GetCertificateAuthorityVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateAuthorityVersionResult(
            certificate_authority_id=self.certificate_authority_id,
            certificate_authority_version_number=self.certificate_authority_version_number,
            id=self.id,
            issuer_ca_version_number=self.issuer_ca_version_number,
            revocation_statuses=self.revocation_statuses,
            serial_number=self.serial_number,
            stages=self.stages,
            subject_alternative_names=self.subject_alternative_names,
            time_created=self.time_created,
            time_of_deletion=self.time_of_deletion,
            validities=self.validities,
            version_name=self.version_name,
            version_number=self.version_number)


def get_certificate_authority_version(certificate_authority_id: Optional[str] = None,
                                      certificate_authority_version_number: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateAuthorityVersionResult:
    """
    This data source provides details about a specific Certificate Authority Version resource in Oracle Cloud Infrastructure Certificates Management service.

    Lists all versions for the specified certificate authority (CA).
    Optionally, you can use the parameter `FilterByVersionNumberQueryParam` to limit the results to a single item that matches the specified version number.


    :param str certificate_authority_id: The OCID of the certificate authority (CA).
    """
    __args__ = dict()
    __args__['certificateAuthorityId'] = certificate_authority_id
    __args__['certificateAuthorityVersionNumber'] = certificate_authority_version_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getCertificateAuthorityVersion:getCertificateAuthorityVersion', __args__, opts=opts, typ=GetCertificateAuthorityVersionResult).value

    return AwaitableGetCertificateAuthorityVersionResult(
        certificate_authority_id=pulumi.get(__ret__, 'certificate_authority_id'),
        certificate_authority_version_number=pulumi.get(__ret__, 'certificate_authority_version_number'),
        id=pulumi.get(__ret__, 'id'),
        issuer_ca_version_number=pulumi.get(__ret__, 'issuer_ca_version_number'),
        revocation_statuses=pulumi.get(__ret__, 'revocation_statuses'),
        serial_number=pulumi.get(__ret__, 'serial_number'),
        stages=pulumi.get(__ret__, 'stages'),
        subject_alternative_names=pulumi.get(__ret__, 'subject_alternative_names'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        validities=pulumi.get(__ret__, 'validities'),
        version_name=pulumi.get(__ret__, 'version_name'),
        version_number=pulumi.get(__ret__, 'version_number'))
def get_certificate_authority_version_output(certificate_authority_id: Optional[pulumi.Input[str]] = None,
                                             certificate_authority_version_number: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateAuthorityVersionResult]:
    """
    This data source provides details about a specific Certificate Authority Version resource in Oracle Cloud Infrastructure Certificates Management service.

    Lists all versions for the specified certificate authority (CA).
    Optionally, you can use the parameter `FilterByVersionNumberQueryParam` to limit the results to a single item that matches the specified version number.


    :param str certificate_authority_id: The OCID of the certificate authority (CA).
    """
    __args__ = dict()
    __args__['certificateAuthorityId'] = certificate_authority_id
    __args__['certificateAuthorityVersionNumber'] = certificate_authority_version_number
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CertificatesManagement/getCertificateAuthorityVersion:getCertificateAuthorityVersion', __args__, opts=opts, typ=GetCertificateAuthorityVersionResult)
    return __ret__.apply(lambda __response__: GetCertificateAuthorityVersionResult(
        certificate_authority_id=pulumi.get(__response__, 'certificate_authority_id'),
        certificate_authority_version_number=pulumi.get(__response__, 'certificate_authority_version_number'),
        id=pulumi.get(__response__, 'id'),
        issuer_ca_version_number=pulumi.get(__response__, 'issuer_ca_version_number'),
        revocation_statuses=pulumi.get(__response__, 'revocation_statuses'),
        serial_number=pulumi.get(__response__, 'serial_number'),
        stages=pulumi.get(__response__, 'stages'),
        subject_alternative_names=pulumi.get(__response__, 'subject_alternative_names'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_deletion=pulumi.get(__response__, 'time_of_deletion'),
        validities=pulumi.get(__response__, 'validities'),
        version_name=pulumi.get(__response__, 'version_name'),
        version_number=pulumi.get(__response__, 'version_number')))
