# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVmClusterResult',
    'AwaitableGetVmClusterResult',
    'get_vm_cluster',
    'get_vm_cluster_output',
]

@pulumi.output_type
class GetVmClusterResult:
    """
    A collection of values returned by getVmCluster.
    """
    def __init__(__self__, availability_domain=None, cloud_automation_update_details=None, compartment_id=None, cpu_core_count=None, cpus_enabled=None, data_collection_options=None, data_storage_size_in_gb=None, data_storage_size_in_tbs=None, db_node_storage_size_in_gbs=None, db_servers=None, defined_tags=None, display_name=None, exadata_infrastructure_id=None, file_system_configuration_details=None, freeform_tags=None, gi_version=None, id=None, is_local_backup_enabled=None, is_sparse_diskgroup_enabled=None, last_patch_history_entry_id=None, license_model=None, lifecycle_details=None, memory_size_in_gbs=None, ocpu_count=None, ocpus_enabled=None, shape=None, ssh_public_keys=None, state=None, system_version=None, time_created=None, time_zone=None, vm_cluster_id=None, vm_cluster_network_id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if cloud_automation_update_details and not isinstance(cloud_automation_update_details, list):
            raise TypeError("Expected argument 'cloud_automation_update_details' to be a list")
        pulumi.set(__self__, "cloud_automation_update_details", cloud_automation_update_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if cpus_enabled and not isinstance(cpus_enabled, int):
            raise TypeError("Expected argument 'cpus_enabled' to be a int")
        pulumi.set(__self__, "cpus_enabled", cpus_enabled)
        if data_collection_options and not isinstance(data_collection_options, list):
            raise TypeError("Expected argument 'data_collection_options' to be a list")
        pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_size_in_gb and not isinstance(data_storage_size_in_gb, float):
            raise TypeError("Expected argument 'data_storage_size_in_gb' to be a float")
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs and not isinstance(data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if file_system_configuration_details and not isinstance(file_system_configuration_details, list):
            raise TypeError("Expected argument 'file_system_configuration_details' to be a list")
        pulumi.set(__self__, "file_system_configuration_details", file_system_configuration_details)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gi_version and not isinstance(gi_version, str):
            raise TypeError("Expected argument 'gi_version' to be a str")
        pulumi.set(__self__, "gi_version", gi_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_local_backup_enabled and not isinstance(is_local_backup_enabled, bool):
            raise TypeError("Expected argument 'is_local_backup_enabled' to be a bool")
        pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled and not isinstance(is_sparse_diskgroup_enabled, bool):
            raise TypeError("Expected argument 'is_sparse_diskgroup_enabled' to be a bool")
        pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if last_patch_history_entry_id and not isinstance(last_patch_history_entry_id, str):
            raise TypeError("Expected argument 'last_patch_history_entry_id' to be a str")
        pulumi.set(__self__, "last_patch_history_entry_id", last_patch_history_entry_id)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if ocpu_count and not isinstance(ocpu_count, float):
            raise TypeError("Expected argument 'ocpu_count' to be a float")
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        if ocpus_enabled and not isinstance(ocpus_enabled, float):
            raise TypeError("Expected argument 'ocpus_enabled' to be a float")
        pulumi.set(__self__, "ocpus_enabled", ocpus_enabled)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if ssh_public_keys and not isinstance(ssh_public_keys, list):
            raise TypeError("Expected argument 'ssh_public_keys' to be a list")
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_version and not isinstance(system_version, str):
            raise TypeError("Expected argument 'system_version' to be a str")
        pulumi.set(__self__, "system_version", system_version)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)
        if vm_cluster_network_id and not isinstance(vm_cluster_network_id, str):
            raise TypeError("Expected argument 'vm_cluster_network_id' to be a str")
        pulumi.set(__self__, "vm_cluster_network_id", vm_cluster_network_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain that the VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="cloudAutomationUpdateDetails")
    def cloud_automation_update_details(self) -> Sequence['outputs.GetVmClusterCloudAutomationUpdateDetailResult']:
        """
        Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        """
        return pulumi.get(self, "cloud_automation_update_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> int:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Sequence['outputs.GetVmClusterDataCollectionOptionResult']:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> float:
        """
        Size of the DATA disk group in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> float:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> int:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Sequence[str]:
        """
        The list of Db server.
        """
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="fileSystemConfigurationDetails")
    def file_system_configuration_details(self) -> Sequence['outputs.GetVmClusterFileSystemConfigurationDetailResult']:
        """
        Details of the file system configuration of the VM cluster.
        """
        return pulumi.get(self, "file_system_configuration_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> str:
        """
        The Oracle Grid Infrastructure software version for the VM cluster.
        """
        return pulumi.get(self, "gi_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> bool:
        """
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> bool:
        """
        If true, sparse disk group is configured for the VM cluster. If false, sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> str:
        """
        The Oracle license model that applies to the VM cluster. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> int:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> float:
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="ocpusEnabled")
    def ocpus_enabled(self) -> float:
        return pulumi.get(self, "ocpus_enabled")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Sequence[str]:
        """
        The public key portion of one or more key pairs used for SSH access to the VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the VM cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> str:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        return pulumi.get(self, "vm_cluster_id")

    @property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        """
        return pulumi.get(self, "vm_cluster_network_id")


class AwaitableGetVmClusterResult(GetVmClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterResult(
            availability_domain=self.availability_domain,
            cloud_automation_update_details=self.cloud_automation_update_details,
            compartment_id=self.compartment_id,
            cpu_core_count=self.cpu_core_count,
            cpus_enabled=self.cpus_enabled,
            data_collection_options=self.data_collection_options,
            data_storage_size_in_gb=self.data_storage_size_in_gb,
            data_storage_size_in_tbs=self.data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_servers=self.db_servers,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            file_system_configuration_details=self.file_system_configuration_details,
            freeform_tags=self.freeform_tags,
            gi_version=self.gi_version,
            id=self.id,
            is_local_backup_enabled=self.is_local_backup_enabled,
            is_sparse_diskgroup_enabled=self.is_sparse_diskgroup_enabled,
            last_patch_history_entry_id=self.last_patch_history_entry_id,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            memory_size_in_gbs=self.memory_size_in_gbs,
            ocpu_count=self.ocpu_count,
            ocpus_enabled=self.ocpus_enabled,
            shape=self.shape,
            ssh_public_keys=self.ssh_public_keys,
            state=self.state,
            system_version=self.system_version,
            time_created=self.time_created,
            time_zone=self.time_zone,
            vm_cluster_id=self.vm_cluster_id,
            vm_cluster_network_id=self.vm_cluster_network_id)


def get_vm_cluster(vm_cluster_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterResult:
    """
    This data source provides details about a specific Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster = oci.Database.get_vm_cluster(vm_cluster_id=test_vm_cluster_oci_database_vm_cluster["id"])
    ```


    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmCluster:getVmCluster', __args__, opts=opts, typ=GetVmClusterResult).value

    return AwaitableGetVmClusterResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        cloud_automation_update_details=pulumi.get(__ret__, 'cloud_automation_update_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        cpus_enabled=pulumi.get(__ret__, 'cpus_enabled'),
        data_collection_options=pulumi.get(__ret__, 'data_collection_options'),
        data_storage_size_in_gb=pulumi.get(__ret__, 'data_storage_size_in_gb'),
        data_storage_size_in_tbs=pulumi.get(__ret__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        file_system_configuration_details=pulumi.get(__ret__, 'file_system_configuration_details'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gi_version=pulumi.get(__ret__, 'gi_version'),
        id=pulumi.get(__ret__, 'id'),
        is_local_backup_enabled=pulumi.get(__ret__, 'is_local_backup_enabled'),
        is_sparse_diskgroup_enabled=pulumi.get(__ret__, 'is_sparse_diskgroup_enabled'),
        last_patch_history_entry_id=pulumi.get(__ret__, 'last_patch_history_entry_id'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        ocpu_count=pulumi.get(__ret__, 'ocpu_count'),
        ocpus_enabled=pulumi.get(__ret__, 'ocpus_enabled'),
        shape=pulumi.get(__ret__, 'shape'),
        ssh_public_keys=pulumi.get(__ret__, 'ssh_public_keys'),
        state=pulumi.get(__ret__, 'state'),
        system_version=pulumi.get(__ret__, 'system_version'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_zone=pulumi.get(__ret__, 'time_zone'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'),
        vm_cluster_network_id=pulumi.get(__ret__, 'vm_cluster_network_id'))
def get_vm_cluster_output(vm_cluster_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVmClusterResult]:
    """
    This data source provides details about a specific Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster = oci.Database.get_vm_cluster(vm_cluster_id=test_vm_cluster_oci_database_vm_cluster["id"])
    ```


    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getVmCluster:getVmCluster', __args__, opts=opts, typ=GetVmClusterResult)
    return __ret__.apply(lambda __response__: GetVmClusterResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        cloud_automation_update_details=pulumi.get(__response__, 'cloud_automation_update_details'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        cpus_enabled=pulumi.get(__response__, 'cpus_enabled'),
        data_collection_options=pulumi.get(__response__, 'data_collection_options'),
        data_storage_size_in_gb=pulumi.get(__response__, 'data_storage_size_in_gb'),
        data_storage_size_in_tbs=pulumi.get(__response__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__response__, 'db_node_storage_size_in_gbs'),
        db_servers=pulumi.get(__response__, 'db_servers'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        file_system_configuration_details=pulumi.get(__response__, 'file_system_configuration_details'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        gi_version=pulumi.get(__response__, 'gi_version'),
        id=pulumi.get(__response__, 'id'),
        is_local_backup_enabled=pulumi.get(__response__, 'is_local_backup_enabled'),
        is_sparse_diskgroup_enabled=pulumi.get(__response__, 'is_sparse_diskgroup_enabled'),
        last_patch_history_entry_id=pulumi.get(__response__, 'last_patch_history_entry_id'),
        license_model=pulumi.get(__response__, 'license_model'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        memory_size_in_gbs=pulumi.get(__response__, 'memory_size_in_gbs'),
        ocpu_count=pulumi.get(__response__, 'ocpu_count'),
        ocpus_enabled=pulumi.get(__response__, 'ocpus_enabled'),
        shape=pulumi.get(__response__, 'shape'),
        ssh_public_keys=pulumi.get(__response__, 'ssh_public_keys'),
        state=pulumi.get(__response__, 'state'),
        system_version=pulumi.get(__response__, 'system_version'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_zone=pulumi.get(__response__, 'time_zone'),
        vm_cluster_id=pulumi.get(__response__, 'vm_cluster_id'),
        vm_cluster_network_id=pulumi.get(__response__, 'vm_cluster_network_id')))
