# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceApplicationPatchResult',
    'AwaitableGetWorkspaceApplicationPatchResult',
    'get_workspace_application_patch',
    'get_workspace_application_patch_output',
]

@pulumi.output_type
class GetWorkspaceApplicationPatchResult:
    """
    A collection of values returned by getWorkspaceApplicationPatch.
    """
    def __init__(__self__, application_key=None, application_version=None, dependent_object_metadatas=None, description=None, error_messages=None, id=None, identifier=None, key=None, key_map=None, metadatas=None, model_type=None, model_version=None, name=None, object_keys=None, object_status=None, object_version=None, parent_reves=None, patch_key=None, patch_object_metadatas=None, patch_status=None, patch_type=None, registry_metadatas=None, time_patched=None, workspace_id=None):
        if application_key and not isinstance(application_key, str):
            raise TypeError("Expected argument 'application_key' to be a str")
        pulumi.set(__self__, "application_key", application_key)
        if application_version and not isinstance(application_version, int):
            raise TypeError("Expected argument 'application_version' to be a int")
        pulumi.set(__self__, "application_version", application_version)
        if dependent_object_metadatas and not isinstance(dependent_object_metadatas, list):
            raise TypeError("Expected argument 'dependent_object_metadatas' to be a list")
        pulumi.set(__self__, "dependent_object_metadatas", dependent_object_metadatas)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if error_messages and not isinstance(error_messages, dict):
            raise TypeError("Expected argument 'error_messages' to be a dict")
        pulumi.set(__self__, "error_messages", error_messages)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if key_map and not isinstance(key_map, dict):
            raise TypeError("Expected argument 'key_map' to be a dict")
        pulumi.set(__self__, "key_map", key_map)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if model_type and not isinstance(model_type, str):
            raise TypeError("Expected argument 'model_type' to be a str")
        pulumi.set(__self__, "model_type", model_type)
        if model_version and not isinstance(model_version, str):
            raise TypeError("Expected argument 'model_version' to be a str")
        pulumi.set(__self__, "model_version", model_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_keys and not isinstance(object_keys, list):
            raise TypeError("Expected argument 'object_keys' to be a list")
        pulumi.set(__self__, "object_keys", object_keys)
        if object_status and not isinstance(object_status, int):
            raise TypeError("Expected argument 'object_status' to be a int")
        pulumi.set(__self__, "object_status", object_status)
        if object_version and not isinstance(object_version, int):
            raise TypeError("Expected argument 'object_version' to be a int")
        pulumi.set(__self__, "object_version", object_version)
        if parent_reves and not isinstance(parent_reves, list):
            raise TypeError("Expected argument 'parent_reves' to be a list")
        pulumi.set(__self__, "parent_reves", parent_reves)
        if patch_key and not isinstance(patch_key, str):
            raise TypeError("Expected argument 'patch_key' to be a str")
        pulumi.set(__self__, "patch_key", patch_key)
        if patch_object_metadatas and not isinstance(patch_object_metadatas, list):
            raise TypeError("Expected argument 'patch_object_metadatas' to be a list")
        pulumi.set(__self__, "patch_object_metadatas", patch_object_metadatas)
        if patch_status and not isinstance(patch_status, str):
            raise TypeError("Expected argument 'patch_status' to be a str")
        pulumi.set(__self__, "patch_status", patch_status)
        if patch_type and not isinstance(patch_type, str):
            raise TypeError("Expected argument 'patch_type' to be a str")
        pulumi.set(__self__, "patch_type", patch_type)
        if registry_metadatas and not isinstance(registry_metadatas, list):
            raise TypeError("Expected argument 'registry_metadatas' to be a list")
        pulumi.set(__self__, "registry_metadatas", registry_metadatas)
        if time_patched and not isinstance(time_patched, str):
            raise TypeError("Expected argument 'time_patched' to be a str")
        pulumi.set(__self__, "time_patched", time_patched)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> str:
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> int:
        """
        The application version of the patch.
        """
        return pulumi.get(self, "application_version")

    @property
    @pulumi.getter(name="dependentObjectMetadatas")
    def dependent_object_metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationPatchDependentObjectMetadataResult']:
        """
        List of dependent objects in this patch.
        """
        return pulumi.get(self, "dependent_object_metadatas")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the aggregator.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Mapping[str, str]:
        """
        The errors encountered while applying the patch, if any.
        """
        return pulumi.get(self, "error_messages")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the object.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> Mapping[str, str]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationPatchMetadataResult']:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        The object type.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> str:
        """
        The object's model version.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> Sequence[str]:
        return pulumi.get(self, "object_keys")

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> int:
        """
        The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> int:
        """
        The object version.
        """
        return pulumi.get(self, "object_version")

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> Sequence['outputs.GetWorkspaceApplicationPatchParentRefResult']:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @property
    @pulumi.getter(name="patchKey")
    def patch_key(self) -> str:
        return pulumi.get(self, "patch_key")

    @property
    @pulumi.getter(name="patchObjectMetadatas")
    def patch_object_metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationPatchPatchObjectMetadataResult']:
        """
        List of objects that are published or unpublished in this patch.
        """
        return pulumi.get(self, "patch_object_metadatas")

    @property
    @pulumi.getter(name="patchStatus")
    def patch_status(self) -> str:
        """
        Status of the patch applied or being applied on the application
        """
        return pulumi.get(self, "patch_status")

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> str:
        """
        The type of the patch applied or being applied on the application.
        """
        return pulumi.get(self, "patch_type")

    @property
    @pulumi.getter(name="registryMetadatas")
    def registry_metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationPatchRegistryMetadataResult']:
        return pulumi.get(self, "registry_metadatas")

    @property
    @pulumi.getter(name="timePatched")
    def time_patched(self) -> str:
        """
        The date and time the patch was applied, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_patched")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceApplicationPatchResult(GetWorkspaceApplicationPatchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceApplicationPatchResult(
            application_key=self.application_key,
            application_version=self.application_version,
            dependent_object_metadatas=self.dependent_object_metadatas,
            description=self.description,
            error_messages=self.error_messages,
            id=self.id,
            identifier=self.identifier,
            key=self.key,
            key_map=self.key_map,
            metadatas=self.metadatas,
            model_type=self.model_type,
            model_version=self.model_version,
            name=self.name,
            object_keys=self.object_keys,
            object_status=self.object_status,
            object_version=self.object_version,
            parent_reves=self.parent_reves,
            patch_key=self.patch_key,
            patch_object_metadatas=self.patch_object_metadatas,
            patch_status=self.patch_status,
            patch_type=self.patch_type,
            registry_metadatas=self.registry_metadatas,
            time_patched=self.time_patched,
            workspace_id=self.workspace_id)


def get_workspace_application_patch(application_key: Optional[str] = None,
                                    patch_key: Optional[str] = None,
                                    workspace_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceApplicationPatchResult:
    """
    This data source provides details about a specific Workspace Application Patch resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a patch in an application using the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application_patch = oci.DataIntegration.get_workspace_application_patch(application_key=workspace_application_patch_application_key,
        patch_key=workspace_application_patch_patch_key,
        workspace_id=test_workspace["id"])
    ```


    :param str application_key: The application key.
    :param str patch_key: The patch key.
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['applicationKey'] = application_key
    __args__['patchKey'] = patch_key
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaceApplicationPatch:getWorkspaceApplicationPatch', __args__, opts=opts, typ=GetWorkspaceApplicationPatchResult).value

    return AwaitableGetWorkspaceApplicationPatchResult(
        application_key=pulumi.get(__ret__, 'application_key'),
        application_version=pulumi.get(__ret__, 'application_version'),
        dependent_object_metadatas=pulumi.get(__ret__, 'dependent_object_metadatas'),
        description=pulumi.get(__ret__, 'description'),
        error_messages=pulumi.get(__ret__, 'error_messages'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        key=pulumi.get(__ret__, 'key'),
        key_map=pulumi.get(__ret__, 'key_map'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        model_type=pulumi.get(__ret__, 'model_type'),
        model_version=pulumi.get(__ret__, 'model_version'),
        name=pulumi.get(__ret__, 'name'),
        object_keys=pulumi.get(__ret__, 'object_keys'),
        object_status=pulumi.get(__ret__, 'object_status'),
        object_version=pulumi.get(__ret__, 'object_version'),
        parent_reves=pulumi.get(__ret__, 'parent_reves'),
        patch_key=pulumi.get(__ret__, 'patch_key'),
        patch_object_metadatas=pulumi.get(__ret__, 'patch_object_metadatas'),
        patch_status=pulumi.get(__ret__, 'patch_status'),
        patch_type=pulumi.get(__ret__, 'patch_type'),
        registry_metadatas=pulumi.get(__ret__, 'registry_metadatas'),
        time_patched=pulumi.get(__ret__, 'time_patched'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_workspace_application_patch_output(application_key: Optional[pulumi.Input[str]] = None,
                                           patch_key: Optional[pulumi.Input[str]] = None,
                                           workspace_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceApplicationPatchResult]:
    """
    This data source provides details about a specific Workspace Application Patch resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a patch in an application using the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application_patch = oci.DataIntegration.get_workspace_application_patch(application_key=workspace_application_patch_application_key,
        patch_key=workspace_application_patch_patch_key,
        workspace_id=test_workspace["id"])
    ```


    :param str application_key: The application key.
    :param str patch_key: The patch key.
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['applicationKey'] = application_key
    __args__['patchKey'] = patch_key
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataIntegration/getWorkspaceApplicationPatch:getWorkspaceApplicationPatch', __args__, opts=opts, typ=GetWorkspaceApplicationPatchResult)
    return __ret__.apply(lambda __response__: GetWorkspaceApplicationPatchResult(
        application_key=pulumi.get(__response__, 'application_key'),
        application_version=pulumi.get(__response__, 'application_version'),
        dependent_object_metadatas=pulumi.get(__response__, 'dependent_object_metadatas'),
        description=pulumi.get(__response__, 'description'),
        error_messages=pulumi.get(__response__, 'error_messages'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        key=pulumi.get(__response__, 'key'),
        key_map=pulumi.get(__response__, 'key_map'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        model_type=pulumi.get(__response__, 'model_type'),
        model_version=pulumi.get(__response__, 'model_version'),
        name=pulumi.get(__response__, 'name'),
        object_keys=pulumi.get(__response__, 'object_keys'),
        object_status=pulumi.get(__response__, 'object_status'),
        object_version=pulumi.get(__response__, 'object_version'),
        parent_reves=pulumi.get(__response__, 'parent_reves'),
        patch_key=pulumi.get(__response__, 'patch_key'),
        patch_object_metadatas=pulumi.get(__response__, 'patch_object_metadatas'),
        patch_status=pulumi.get(__response__, 'patch_status'),
        patch_type=pulumi.get(__response__, 'patch_type'),
        registry_metadatas=pulumi.get(__response__, 'registry_metadatas'),
        time_patched=pulumi.get(__response__, 'time_patched'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
