# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DrProtectionGroupArgs', 'DrProtectionGroup']

@pulumi.input_type
class DrProtectionGroupArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 log_location: pulumi.Input['DrProtectionGroupLogLocationArgs'],
                 association: Optional[pulumi.Input['DrProtectionGroupAssociationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disassociate_trigger: Optional[pulumi.Input[int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]]] = None):
        """
        The set of arguments for constructing a DrProtectionGroup resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR protection group.  Example: `EBS PHX Group`
        :param pulumi.Input['DrProtectionGroupLogLocationArgs'] log_location: (Updatable) The details for creating an object storage log location for a DR protection group.
        :param pulumi.Input['DrProtectionGroupAssociationArgs'] association: The details for associating a DR protection group with a peer DR protection group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[int] disassociate_trigger: (Updatable) An optional property when incremented triggers Disassociate. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]] members: (Updatable) A list of DR protection group members.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "log_location", log_location)
        if association is not None:
            pulumi.set(__self__, "association", association)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disassociate_trigger is not None:
            pulumi.set(__self__, "disassociate_trigger", disassociate_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if members is not None:
            pulumi.set(__self__, "members", members)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment in which to create the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The display name of the DR protection group.  Example: `EBS PHX Group`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="logLocation")
    def log_location(self) -> pulumi.Input['DrProtectionGroupLogLocationArgs']:
        """
        (Updatable) The details for creating an object storage log location for a DR protection group.
        """
        return pulumi.get(self, "log_location")

    @log_location.setter
    def log_location(self, value: pulumi.Input['DrProtectionGroupLogLocationArgs']):
        pulumi.set(self, "log_location", value)

    @property
    @pulumi.getter
    def association(self) -> Optional[pulumi.Input['DrProtectionGroupAssociationArgs']]:
        """
        The details for associating a DR protection group with a peer DR protection group.
        """
        return pulumi.get(self, "association")

    @association.setter
    def association(self, value: Optional[pulumi.Input['DrProtectionGroupAssociationArgs']]):
        pulumi.set(self, "association", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="disassociateTrigger")
    def disassociate_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Disassociate. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "disassociate_trigger")

    @disassociate_trigger.setter
    def disassociate_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disassociate_trigger", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]]]:
        """
        (Updatable) A list of DR protection group members.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]]]):
        pulumi.set(self, "members", value)


@pulumi.input_type
class _DrProtectionGroupState:
    def __init__(__self__, *,
                 association: Optional[pulumi.Input['DrProtectionGroupAssociationArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disassociate_trigger: Optional[pulumi.Input[int]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 life_cycle_details: Optional[pulumi.Input[str]] = None,
                 lifecycle_sub_state: Optional[pulumi.Input[str]] = None,
                 log_location: Optional[pulumi.Input['DrProtectionGroupLogLocationArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]]] = None,
                 peer_id: Optional[pulumi.Input[str]] = None,
                 peer_region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DrProtectionGroup resources.
        :param pulumi.Input['DrProtectionGroupAssociationArgs'] association: The details for associating a DR protection group with a peer DR protection group.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[int] disassociate_trigger: (Updatable) An optional property when incremented triggers Disassociate. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR protection group.  Example: `EBS PHX Group`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] life_cycle_details: A message describing the DR protection group's current state in more detail.
        :param pulumi.Input[str] lifecycle_sub_state: The current sub-state of the DR protection group.
        :param pulumi.Input['DrProtectionGroupLogLocationArgs'] log_location: (Updatable) The details for creating an object storage log location for a DR protection group.
        :param pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]] members: (Updatable) A list of DR protection group members.
        :param pulumi.Input[str] peer_id: The OCID of the peer DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[str] peer_region: The region of the peer DR protection group.  Example: `us-ashburn-1`
        :param pulumi.Input[str] role: The role of the DR protection group.
        :param pulumi.Input[str] state: The current state of the DR protection group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the DR protection group was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_updated: The date and time the DR protection group was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        if association is not None:
            pulumi.set(__self__, "association", association)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disassociate_trigger is not None:
            pulumi.set(__self__, "disassociate_trigger", disassociate_trigger)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if life_cycle_details is not None:
            pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        if lifecycle_sub_state is not None:
            pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if log_location is not None:
            pulumi.set(__self__, "log_location", log_location)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if peer_id is not None:
            pulumi.set(__self__, "peer_id", peer_id)
        if peer_region is not None:
            pulumi.set(__self__, "peer_region", peer_region)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def association(self) -> Optional[pulumi.Input['DrProtectionGroupAssociationArgs']]:
        """
        The details for associating a DR protection group with a peer DR protection group.
        """
        return pulumi.get(self, "association")

    @association.setter
    def association(self, value: Optional[pulumi.Input['DrProtectionGroupAssociationArgs']]):
        pulumi.set(self, "association", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment in which to create the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="disassociateTrigger")
    def disassociate_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Disassociate. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "disassociate_trigger")

    @disassociate_trigger.setter
    def disassociate_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disassociate_trigger", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the DR protection group.  Example: `EBS PHX Group`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the DR protection group's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @life_cycle_details.setter
    def life_cycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "life_cycle_details", value)

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> Optional[pulumi.Input[str]]:
        """
        The current sub-state of the DR protection group.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @lifecycle_sub_state.setter
    def lifecycle_sub_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_sub_state", value)

    @property
    @pulumi.getter(name="logLocation")
    def log_location(self) -> Optional[pulumi.Input['DrProtectionGroupLogLocationArgs']]:
        """
        (Updatable) The details for creating an object storage log location for a DR protection group.
        """
        return pulumi.get(self, "log_location")

    @log_location.setter
    def log_location(self, value: Optional[pulumi.Input['DrProtectionGroupLogLocationArgs']]):
        pulumi.set(self, "log_location", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]]]:
        """
        (Updatable) A list of DR protection group members.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the peer DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "peer_id")

    @peer_id.setter
    def peer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_id", value)

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the peer DR protection group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @peer_region.setter
    def peer_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_region", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of the DR protection group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DR protection group.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the DR protection group was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the DR protection group was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class DrProtectionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association: Optional[pulumi.Input[Union['DrProtectionGroupAssociationArgs', 'DrProtectionGroupAssociationArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disassociate_trigger: Optional[pulumi.Input[int]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_location: Optional[pulumi.Input[Union['DrProtectionGroupLogLocationArgs', 'DrProtectionGroupLogLocationArgsDict']]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DrProtectionGroupMemberArgs', 'DrProtectionGroupMemberArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Dr Protection Group resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Create a DR protection group.

        ## Create

        Create DR Protection Group resource with a default value of `disassociate_trigger` property, e.g.

        ## Delete

        Disassociate DR Protection Group (if associated) before deleting it. Increment value of `disassociate_trigger` property to trigger Disassociate, e.g.

        ## Import

        DrProtectionGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DisasterRecovery/drProtectionGroup:DrProtectionGroup test_dr_protection_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DrProtectionGroupAssociationArgs', 'DrProtectionGroupAssociationArgsDict']] association: The details for associating a DR protection group with a peer DR protection group.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[int] disassociate_trigger: (Updatable) An optional property when incremented triggers Disassociate. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR protection group.  Example: `EBS PHX Group`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['DrProtectionGroupLogLocationArgs', 'DrProtectionGroupLogLocationArgsDict']] log_location: (Updatable) The details for creating an object storage log location for a DR protection group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DrProtectionGroupMemberArgs', 'DrProtectionGroupMemberArgsDict']]]] members: (Updatable) A list of DR protection group members.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DrProtectionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dr Protection Group resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Create a DR protection group.

        ## Create

        Create DR Protection Group resource with a default value of `disassociate_trigger` property, e.g.

        ## Delete

        Disassociate DR Protection Group (if associated) before deleting it. Increment value of `disassociate_trigger` property to trigger Disassociate, e.g.

        ## Import

        DrProtectionGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DisasterRecovery/drProtectionGroup:DrProtectionGroup test_dr_protection_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param DrProtectionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DrProtectionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association: Optional[pulumi.Input[Union['DrProtectionGroupAssociationArgs', 'DrProtectionGroupAssociationArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disassociate_trigger: Optional[pulumi.Input[int]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_location: Optional[pulumi.Input[Union['DrProtectionGroupLogLocationArgs', 'DrProtectionGroupLogLocationArgsDict']]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DrProtectionGroupMemberArgs', 'DrProtectionGroupMemberArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DrProtectionGroupArgs.__new__(DrProtectionGroupArgs)

            __props__.__dict__["association"] = association
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["disassociate_trigger"] = disassociate_trigger
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if log_location is None and not opts.urn:
                raise TypeError("Missing required property 'log_location'")
            __props__.__dict__["log_location"] = log_location
            __props__.__dict__["members"] = members
            __props__.__dict__["life_cycle_details"] = None
            __props__.__dict__["lifecycle_sub_state"] = None
            __props__.__dict__["peer_id"] = None
            __props__.__dict__["peer_region"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DrProtectionGroup, __self__).__init__(
            'oci:DisasterRecovery/drProtectionGroup:DrProtectionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            association: Optional[pulumi.Input[Union['DrProtectionGroupAssociationArgs', 'DrProtectionGroupAssociationArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            disassociate_trigger: Optional[pulumi.Input[int]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            life_cycle_details: Optional[pulumi.Input[str]] = None,
            lifecycle_sub_state: Optional[pulumi.Input[str]] = None,
            log_location: Optional[pulumi.Input[Union['DrProtectionGroupLogLocationArgs', 'DrProtectionGroupLogLocationArgsDict']]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DrProtectionGroupMemberArgs', 'DrProtectionGroupMemberArgsDict']]]]] = None,
            peer_id: Optional[pulumi.Input[str]] = None,
            peer_region: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'DrProtectionGroup':
        """
        Get an existing DrProtectionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DrProtectionGroupAssociationArgs', 'DrProtectionGroupAssociationArgsDict']] association: The details for associating a DR protection group with a peer DR protection group.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[int] disassociate_trigger: (Updatable) An optional property when incremented triggers Disassociate. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR protection group.  Example: `EBS PHX Group`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] life_cycle_details: A message describing the DR protection group's current state in more detail.
        :param pulumi.Input[str] lifecycle_sub_state: The current sub-state of the DR protection group.
        :param pulumi.Input[Union['DrProtectionGroupLogLocationArgs', 'DrProtectionGroupLogLocationArgsDict']] log_location: (Updatable) The details for creating an object storage log location for a DR protection group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DrProtectionGroupMemberArgs', 'DrProtectionGroupMemberArgsDict']]]] members: (Updatable) A list of DR protection group members.
        :param pulumi.Input[str] peer_id: The OCID of the peer DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[str] peer_region: The region of the peer DR protection group.  Example: `us-ashburn-1`
        :param pulumi.Input[str] role: The role of the DR protection group.
        :param pulumi.Input[str] state: The current state of the DR protection group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the DR protection group was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_updated: The date and time the DR protection group was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DrProtectionGroupState.__new__(_DrProtectionGroupState)

        __props__.__dict__["association"] = association
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["disassociate_trigger"] = disassociate_trigger
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["life_cycle_details"] = life_cycle_details
        __props__.__dict__["lifecycle_sub_state"] = lifecycle_sub_state
        __props__.__dict__["log_location"] = log_location
        __props__.__dict__["members"] = members
        __props__.__dict__["peer_id"] = peer_id
        __props__.__dict__["peer_region"] = peer_region
        __props__.__dict__["role"] = role
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DrProtectionGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def association(self) -> pulumi.Output['outputs.DrProtectionGroupAssociation']:
        """
        The details for associating a DR protection group with a peer DR protection group.
        """
        return pulumi.get(self, "association")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment in which to create the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="disassociateTrigger")
    def disassociate_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional property when incremented triggers Disassociate. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "disassociate_trigger")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the DR protection group.  Example: `EBS PHX Group`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the DR protection group's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> pulumi.Output[str]:
        """
        The current sub-state of the DR protection group.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="logLocation")
    def log_location(self) -> pulumi.Output['outputs.DrProtectionGroupLogLocation']:
        """
        (Updatable) The details for creating an object storage log location for a DR protection group.
        """
        return pulumi.get(self, "log_location")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[Sequence['outputs.DrProtectionGroupMember']]]:
        """
        (Updatable) A list of DR protection group members.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> pulumi.Output[str]:
        """
        The OCID of the peer DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> pulumi.Output[str]:
        """
        The region of the peer DR protection group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The role of the DR protection group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DR protection group.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the DR protection group was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the DR protection group was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

