# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetResourcesResult',
    'AwaitableGetFleetResourcesResult',
    'get_fleet_resources',
    'get_fleet_resources_output',
]

@pulumi.output_type
class GetFleetResourcesResult:
    """
    A collection of values returned by getFleetResources.
    """
    def __init__(__self__, display_name=None, filters=None, fleet_id=None, fleet_resource_collections=None, fleet_resource_type=None, id=None, state=None, tenancy_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if fleet_resource_collections and not isinstance(fleet_resource_collections, list):
            raise TypeError("Expected argument 'fleet_resource_collections' to be a list")
        pulumi.set(__self__, "fleet_resource_collections", fleet_resource_collections)
        if fleet_resource_type and not isinstance(fleet_resource_type, str):
            raise TypeError("Expected argument 'fleet_resource_type' to be a str")
        pulumi.set(__self__, "fleet_resource_type", fleet_resource_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetResourceCollections")
    def fleet_resource_collections(self) -> Sequence['outputs.GetFleetResourcesFleetResourceCollectionResult']:
        """
        The list of fleet_resource_collection.
        """
        return pulumi.get(self, "fleet_resource_collections")

    @property
    @pulumi.getter(name="fleetResourceType")
    def fleet_resource_type(self) -> Optional[str]:
        return pulumi.get(self, "fleet_resource_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the FleetResource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[str]:
        """
        OCID of the tenancy to which the resource belongs to.
        """
        return pulumi.get(self, "tenancy_id")


class AwaitableGetFleetResourcesResult(GetFleetResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetResourcesResult(
            display_name=self.display_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            fleet_resource_collections=self.fleet_resource_collections,
            fleet_resource_type=self.fleet_resource_type,
            id=self.id,
            state=self.state,
            tenancy_id=self.tenancy_id)


def get_fleet_resources(display_name: Optional[str] = None,
                        filters: Optional[Sequence[Union['GetFleetResourcesFilterArgs', 'GetFleetResourcesFilterArgsDict']]] = None,
                        fleet_id: Optional[str] = None,
                        fleet_resource_type: Optional[str] = None,
                        id: Optional[str] = None,
                        state: Optional[str] = None,
                        tenancy_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetResourcesResult:
    """
    This data source provides the list of Fleet Resources in Oracle Cloud Infrastructure Fleet Apps Management service.

    List resources for a fleet in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_resources = oci.FleetAppsManagement.get_fleet_resources(fleet_id=test_fleet["id"],
        display_name=fleet_resource_display_name,
        fleet_resource_type=fleet_resource_fleet_resource_type,
        id=fleet_resource_id,
        state=fleet_resource_state,
        tenancy_id=test_tenancy["id"])
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: Unique Fleet identifier.
    :param str fleet_resource_type: A filter to return only resources whose resourceType matches the given resourceType.
    :param str id: A filter to return only resources whose identifier matches the given identifier.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param str tenancy_id: Resource Tenancy Id
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['fleetResourceType'] = fleet_resource_type
    __args__['id'] = id
    __args__['state'] = state
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetResources:getFleetResources', __args__, opts=opts, typ=GetFleetResourcesResult).value

    return AwaitableGetFleetResourcesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        fleet_resource_collections=pulumi.get(__ret__, 'fleet_resource_collections'),
        fleet_resource_type=pulumi.get(__ret__, 'fleet_resource_type'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'))
def get_fleet_resources_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetResourcesFilterArgs', 'GetFleetResourcesFilterArgsDict']]]]] = None,
                               fleet_id: Optional[pulumi.Input[str]] = None,
                               fleet_resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                               id: Optional[pulumi.Input[Optional[str]]] = None,
                               state: Optional[pulumi.Input[Optional[str]]] = None,
                               tenancy_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetResourcesResult]:
    """
    This data source provides the list of Fleet Resources in Oracle Cloud Infrastructure Fleet Apps Management service.

    List resources for a fleet in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_resources = oci.FleetAppsManagement.get_fleet_resources(fleet_id=test_fleet["id"],
        display_name=fleet_resource_display_name,
        fleet_resource_type=fleet_resource_fleet_resource_type,
        id=fleet_resource_id,
        state=fleet_resource_state,
        tenancy_id=test_tenancy["id"])
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: Unique Fleet identifier.
    :param str fleet_resource_type: A filter to return only resources whose resourceType matches the given resourceType.
    :param str id: A filter to return only resources whose identifier matches the given identifier.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param str tenancy_id: Resource Tenancy Id
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['fleetResourceType'] = fleet_resource_type
    __args__['id'] = id
    __args__['state'] = state
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetResources:getFleetResources', __args__, opts=opts, typ=GetFleetResourcesResult)
    return __ret__.apply(lambda __response__: GetFleetResourcesResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        fleet_resource_collections=pulumi.get(__response__, 'fleet_resource_collections'),
        fleet_resource_type=pulumi.get(__response__, 'fleet_resource_type'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id')))
