# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainsIdentitySettingResult',
    'AwaitableGetDomainsIdentitySettingResult',
    'get_domains_identity_setting',
    'get_domains_identity_setting_output',
]

@pulumi.output_type
class GetDomainsIdentitySettingResult:
    """
    A collection of values returned by getDomainsIdentitySetting.
    """
    def __init__(__self__, attribute_sets=None, attributes=None, authorization=None, compartment_ocid=None, delete_in_progress=None, domain_ocid=None, emit_locked_message_when_user_is_locked=None, external_id=None, id=None, idcs_created_bies=None, idcs_endpoint=None, idcs_last_modified_bies=None, idcs_last_upgraded_in_release=None, idcs_prevented_operations=None, identity_setting_id=None, metas=None, my_profiles=None, ocid=None, posix_gids=None, posix_uids=None, primary_email_required=None, remove_invalid_emails=None, resource_type_schema_version=None, return_inactive_over_locked_message=None, schemas=None, tags=None, tenancy_ocid=None, tokens=None, user_allowed_to_set_recovery_email=None):
        if attribute_sets and not isinstance(attribute_sets, list):
            raise TypeError("Expected argument 'attribute_sets' to be a list")
        pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes and not isinstance(attributes, str):
            raise TypeError("Expected argument 'attributes' to be a str")
        pulumi.set(__self__, "attributes", attributes)
        if authorization and not isinstance(authorization, str):
            raise TypeError("Expected argument 'authorization' to be a str")
        pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid and not isinstance(compartment_ocid, str):
            raise TypeError("Expected argument 'compartment_ocid' to be a str")
        pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress and not isinstance(delete_in_progress, bool):
            raise TypeError("Expected argument 'delete_in_progress' to be a bool")
        pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid and not isinstance(domain_ocid, str):
            raise TypeError("Expected argument 'domain_ocid' to be a str")
        pulumi.set(__self__, "domain_ocid", domain_ocid)
        if emit_locked_message_when_user_is_locked and not isinstance(emit_locked_message_when_user_is_locked, bool):
            raise TypeError("Expected argument 'emit_locked_message_when_user_is_locked' to be a bool")
        pulumi.set(__self__, "emit_locked_message_when_user_is_locked", emit_locked_message_when_user_is_locked)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_created_bies and not isinstance(idcs_created_bies, list):
            raise TypeError("Expected argument 'idcs_created_bies' to be a list")
        pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint and not isinstance(idcs_endpoint, str):
            raise TypeError("Expected argument 'idcs_endpoint' to be a str")
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies and not isinstance(idcs_last_modified_bies, list):
            raise TypeError("Expected argument 'idcs_last_modified_bies' to be a list")
        pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release and not isinstance(idcs_last_upgraded_in_release, str):
            raise TypeError("Expected argument 'idcs_last_upgraded_in_release' to be a str")
        pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations and not isinstance(idcs_prevented_operations, list):
            raise TypeError("Expected argument 'idcs_prevented_operations' to be a list")
        pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if identity_setting_id and not isinstance(identity_setting_id, str):
            raise TypeError("Expected argument 'identity_setting_id' to be a str")
        pulumi.set(__self__, "identity_setting_id", identity_setting_id)
        if metas and not isinstance(metas, list):
            raise TypeError("Expected argument 'metas' to be a list")
        pulumi.set(__self__, "metas", metas)
        if my_profiles and not isinstance(my_profiles, list):
            raise TypeError("Expected argument 'my_profiles' to be a list")
        pulumi.set(__self__, "my_profiles", my_profiles)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if posix_gids and not isinstance(posix_gids, list):
            raise TypeError("Expected argument 'posix_gids' to be a list")
        pulumi.set(__self__, "posix_gids", posix_gids)
        if posix_uids and not isinstance(posix_uids, list):
            raise TypeError("Expected argument 'posix_uids' to be a list")
        pulumi.set(__self__, "posix_uids", posix_uids)
        if primary_email_required and not isinstance(primary_email_required, bool):
            raise TypeError("Expected argument 'primary_email_required' to be a bool")
        pulumi.set(__self__, "primary_email_required", primary_email_required)
        if remove_invalid_emails and not isinstance(remove_invalid_emails, bool):
            raise TypeError("Expected argument 'remove_invalid_emails' to be a bool")
        pulumi.set(__self__, "remove_invalid_emails", remove_invalid_emails)
        if resource_type_schema_version and not isinstance(resource_type_schema_version, str):
            raise TypeError("Expected argument 'resource_type_schema_version' to be a str")
        pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if return_inactive_over_locked_message and not isinstance(return_inactive_over_locked_message, bool):
            raise TypeError("Expected argument 'return_inactive_over_locked_message' to be a bool")
        pulumi.set(__self__, "return_inactive_over_locked_message", return_inactive_over_locked_message)
        if schemas and not isinstance(schemas, list):
            raise TypeError("Expected argument 'schemas' to be a list")
        pulumi.set(__self__, "schemas", schemas)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tenancy_ocid and not isinstance(tenancy_ocid, str):
            raise TypeError("Expected argument 'tenancy_ocid' to be a str")
        pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if tokens and not isinstance(tokens, list):
            raise TypeError("Expected argument 'tokens' to be a list")
        pulumi.set(__self__, "tokens", tokens)
        if user_allowed_to_set_recovery_email and not isinstance(user_allowed_to_set_recovery_email, bool):
            raise TypeError("Expected argument 'user_allowed_to_set_recovery_email' to be a bool")
        pulumi.set(__self__, "user_allowed_to_set_recovery_email", user_allowed_to_set_recovery_email)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[str]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> Optional[str]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> str:
        """
        Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> bool:
        """
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> str:
        """
        Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="emitLockedMessageWhenUserIsLocked")
    def emit_locked_message_when_user_is_locked(self) -> bool:
        """
        Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.
        """
        return pulumi.get(self, "emit_locked_message_when_user_is_locked")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        """
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Sequence['outputs.GetDomainsIdentitySettingIdcsCreatedByResult']:
        """
        The User or App who created the Resource
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> str:
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Sequence['outputs.GetDomainsIdentitySettingIdcsLastModifiedByResult']:
        """
        The User or App who modified the Resource
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> str:
        """
        The release number when the resource was upgraded.
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Sequence[str]:
        """
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="identitySettingId")
    def identity_setting_id(self) -> str:
        return pulumi.get(self, "identity_setting_id")

    @property
    @pulumi.getter
    def metas(self) -> Sequence['outputs.GetDomainsIdentitySettingMetaResult']:
        """
        A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="myProfiles")
    def my_profiles(self) -> Sequence['outputs.GetDomainsIdentitySettingMyProfileResult']:
        """
        Whether to allow users to update their own profile.
        """
        return pulumi.get(self, "my_profiles")

    @property
    @pulumi.getter
    def ocid(self) -> str:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="posixGids")
    def posix_gids(self) -> Sequence['outputs.GetDomainsIdentitySettingPosixGidResult']:
        """
        A list of Posix Gid settings.
        """
        return pulumi.get(self, "posix_gids")

    @property
    @pulumi.getter(name="posixUids")
    def posix_uids(self) -> Sequence['outputs.GetDomainsIdentitySettingPosixUidResult']:
        """
        A list of Posix Uid settings.
        """
        return pulumi.get(self, "posix_uids")

    @property
    @pulumi.getter(name="primaryEmailRequired")
    def primary_email_required(self) -> bool:
        """
        Indicates whether the primary email is required.
        """
        return pulumi.get(self, "primary_email_required")

    @property
    @pulumi.getter(name="removeInvalidEmails")
    def remove_invalid_emails(self) -> bool:
        """
        Indicates whether to remove non-RFC5322 compliant emails before creating a user.
        """
        return pulumi.get(self, "remove_invalid_emails")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[str]:
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter(name="returnInactiveOverLockedMessage")
    def return_inactive_over_locked_message(self) -> bool:
        """
        **Added In:** 2302092332
        """
        return pulumi.get(self, "return_inactive_over_locked_message")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence[str]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetDomainsIdentitySettingTagResult']:
        """
        A list of tags on this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> str:
        """
        Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter
    def tokens(self) -> Sequence['outputs.GetDomainsIdentitySettingTokenResult']:
        """
        A list of tokens and their expiry length.
        """
        return pulumi.get(self, "tokens")

    @property
    @pulumi.getter(name="userAllowedToSetRecoveryEmail")
    def user_allowed_to_set_recovery_email(self) -> bool:
        """
        Indicates whether a user is allowed to change their own recovery email.
        """
        return pulumi.get(self, "user_allowed_to_set_recovery_email")


class AwaitableGetDomainsIdentitySettingResult(GetDomainsIdentitySettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsIdentitySettingResult(
            attribute_sets=self.attribute_sets,
            attributes=self.attributes,
            authorization=self.authorization,
            compartment_ocid=self.compartment_ocid,
            delete_in_progress=self.delete_in_progress,
            domain_ocid=self.domain_ocid,
            emit_locked_message_when_user_is_locked=self.emit_locked_message_when_user_is_locked,
            external_id=self.external_id,
            id=self.id,
            idcs_created_bies=self.idcs_created_bies,
            idcs_endpoint=self.idcs_endpoint,
            idcs_last_modified_bies=self.idcs_last_modified_bies,
            idcs_last_upgraded_in_release=self.idcs_last_upgraded_in_release,
            idcs_prevented_operations=self.idcs_prevented_operations,
            identity_setting_id=self.identity_setting_id,
            metas=self.metas,
            my_profiles=self.my_profiles,
            ocid=self.ocid,
            posix_gids=self.posix_gids,
            posix_uids=self.posix_uids,
            primary_email_required=self.primary_email_required,
            remove_invalid_emails=self.remove_invalid_emails,
            resource_type_schema_version=self.resource_type_schema_version,
            return_inactive_over_locked_message=self.return_inactive_over_locked_message,
            schemas=self.schemas,
            tags=self.tags,
            tenancy_ocid=self.tenancy_ocid,
            tokens=self.tokens,
            user_allowed_to_set_recovery_email=self.user_allowed_to_set_recovery_email)


def get_domains_identity_setting(attribute_sets: Optional[Sequence[str]] = None,
                                 attributes: Optional[str] = None,
                                 authorization: Optional[str] = None,
                                 idcs_endpoint: Optional[str] = None,
                                 identity_setting_id: Optional[str] = None,
                                 resource_type_schema_version: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsIdentitySettingResult:
    """
    This data source provides details about a specific Identity Setting resource in Oracle Cloud Infrastructure Identity Domains service.

    Get an Identity setting.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_identity_setting = oci.Identity.get_domains_identity_setting(idcs_endpoint=test_domain["url"],
        identity_setting_id=test_identity_setting_oci_identity_domains_identity_setting["id"],
        attribute_sets=["all"],
        attributes="",
        authorization=identity_setting_authorization,
        resource_type_schema_version=identity_setting_resource_type_schema_version)
    ```


    :param Sequence[str] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
    :param str attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
    :param str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param str idcs_endpoint: The basic endpoint for the identity domain
    :param str identity_setting_id: ID of the resource
    :param str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    __args__ = dict()
    __args__['attributeSets'] = attribute_sets
    __args__['attributes'] = attributes
    __args__['authorization'] = authorization
    __args__['idcsEndpoint'] = idcs_endpoint
    __args__['identitySettingId'] = identity_setting_id
    __args__['resourceTypeSchemaVersion'] = resource_type_schema_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getDomainsIdentitySetting:getDomainsIdentitySetting', __args__, opts=opts, typ=GetDomainsIdentitySettingResult).value

    return AwaitableGetDomainsIdentitySettingResult(
        attribute_sets=pulumi.get(__ret__, 'attribute_sets'),
        attributes=pulumi.get(__ret__, 'attributes'),
        authorization=pulumi.get(__ret__, 'authorization'),
        compartment_ocid=pulumi.get(__ret__, 'compartment_ocid'),
        delete_in_progress=pulumi.get(__ret__, 'delete_in_progress'),
        domain_ocid=pulumi.get(__ret__, 'domain_ocid'),
        emit_locked_message_when_user_is_locked=pulumi.get(__ret__, 'emit_locked_message_when_user_is_locked'),
        external_id=pulumi.get(__ret__, 'external_id'),
        id=pulumi.get(__ret__, 'id'),
        idcs_created_bies=pulumi.get(__ret__, 'idcs_created_bies'),
        idcs_endpoint=pulumi.get(__ret__, 'idcs_endpoint'),
        idcs_last_modified_bies=pulumi.get(__ret__, 'idcs_last_modified_bies'),
        idcs_last_upgraded_in_release=pulumi.get(__ret__, 'idcs_last_upgraded_in_release'),
        idcs_prevented_operations=pulumi.get(__ret__, 'idcs_prevented_operations'),
        identity_setting_id=pulumi.get(__ret__, 'identity_setting_id'),
        metas=pulumi.get(__ret__, 'metas'),
        my_profiles=pulumi.get(__ret__, 'my_profiles'),
        ocid=pulumi.get(__ret__, 'ocid'),
        posix_gids=pulumi.get(__ret__, 'posix_gids'),
        posix_uids=pulumi.get(__ret__, 'posix_uids'),
        primary_email_required=pulumi.get(__ret__, 'primary_email_required'),
        remove_invalid_emails=pulumi.get(__ret__, 'remove_invalid_emails'),
        resource_type_schema_version=pulumi.get(__ret__, 'resource_type_schema_version'),
        return_inactive_over_locked_message=pulumi.get(__ret__, 'return_inactive_over_locked_message'),
        schemas=pulumi.get(__ret__, 'schemas'),
        tags=pulumi.get(__ret__, 'tags'),
        tenancy_ocid=pulumi.get(__ret__, 'tenancy_ocid'),
        tokens=pulumi.get(__ret__, 'tokens'),
        user_allowed_to_set_recovery_email=pulumi.get(__ret__, 'user_allowed_to_set_recovery_email'))
def get_domains_identity_setting_output(attribute_sets: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                        attributes: Optional[pulumi.Input[Optional[str]]] = None,
                                        authorization: Optional[pulumi.Input[Optional[str]]] = None,
                                        idcs_endpoint: Optional[pulumi.Input[str]] = None,
                                        identity_setting_id: Optional[pulumi.Input[str]] = None,
                                        resource_type_schema_version: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainsIdentitySettingResult]:
    """
    This data source provides details about a specific Identity Setting resource in Oracle Cloud Infrastructure Identity Domains service.

    Get an Identity setting.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_identity_setting = oci.Identity.get_domains_identity_setting(idcs_endpoint=test_domain["url"],
        identity_setting_id=test_identity_setting_oci_identity_domains_identity_setting["id"],
        attribute_sets=["all"],
        attributes="",
        authorization=identity_setting_authorization,
        resource_type_schema_version=identity_setting_resource_type_schema_version)
    ```


    :param Sequence[str] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
    :param str attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
    :param str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param str idcs_endpoint: The basic endpoint for the identity domain
    :param str identity_setting_id: ID of the resource
    :param str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    __args__ = dict()
    __args__['attributeSets'] = attribute_sets
    __args__['attributes'] = attributes
    __args__['authorization'] = authorization
    __args__['idcsEndpoint'] = idcs_endpoint
    __args__['identitySettingId'] = identity_setting_id
    __args__['resourceTypeSchemaVersion'] = resource_type_schema_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getDomainsIdentitySetting:getDomainsIdentitySetting', __args__, opts=opts, typ=GetDomainsIdentitySettingResult)
    return __ret__.apply(lambda __response__: GetDomainsIdentitySettingResult(
        attribute_sets=pulumi.get(__response__, 'attribute_sets'),
        attributes=pulumi.get(__response__, 'attributes'),
        authorization=pulumi.get(__response__, 'authorization'),
        compartment_ocid=pulumi.get(__response__, 'compartment_ocid'),
        delete_in_progress=pulumi.get(__response__, 'delete_in_progress'),
        domain_ocid=pulumi.get(__response__, 'domain_ocid'),
        emit_locked_message_when_user_is_locked=pulumi.get(__response__, 'emit_locked_message_when_user_is_locked'),
        external_id=pulumi.get(__response__, 'external_id'),
        id=pulumi.get(__response__, 'id'),
        idcs_created_bies=pulumi.get(__response__, 'idcs_created_bies'),
        idcs_endpoint=pulumi.get(__response__, 'idcs_endpoint'),
        idcs_last_modified_bies=pulumi.get(__response__, 'idcs_last_modified_bies'),
        idcs_last_upgraded_in_release=pulumi.get(__response__, 'idcs_last_upgraded_in_release'),
        idcs_prevented_operations=pulumi.get(__response__, 'idcs_prevented_operations'),
        identity_setting_id=pulumi.get(__response__, 'identity_setting_id'),
        metas=pulumi.get(__response__, 'metas'),
        my_profiles=pulumi.get(__response__, 'my_profiles'),
        ocid=pulumi.get(__response__, 'ocid'),
        posix_gids=pulumi.get(__response__, 'posix_gids'),
        posix_uids=pulumi.get(__response__, 'posix_uids'),
        primary_email_required=pulumi.get(__response__, 'primary_email_required'),
        remove_invalid_emails=pulumi.get(__response__, 'remove_invalid_emails'),
        resource_type_schema_version=pulumi.get(__response__, 'resource_type_schema_version'),
        return_inactive_over_locked_message=pulumi.get(__response__, 'return_inactive_over_locked_message'),
        schemas=pulumi.get(__response__, 'schemas'),
        tags=pulumi.get(__response__, 'tags'),
        tenancy_ocid=pulumi.get(__response__, 'tenancy_ocid'),
        tokens=pulumi.get(__response__, 'tokens'),
        user_allowed_to_set_recovery_email=pulumi.get(__response__, 'user_allowed_to_set_recovery_email')))
